// Code generated by smithy-go-codegen DO NOT EDIT.

package vpclattice

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/vpclattice/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Updates the specified resource configuration.
func (c *Client) UpdateResourceConfiguration(ctx context.Context, params *UpdateResourceConfigurationInput, optFns ...func(*Options)) (*UpdateResourceConfigurationOutput, error) {
	if params == nil {
		params = &UpdateResourceConfigurationInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "UpdateResourceConfiguration", params, optFns, c.addOperationUpdateResourceConfigurationMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*UpdateResourceConfigurationOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type UpdateResourceConfigurationInput struct {

	// The ID of the resource configuration.
	//
	// This member is required.
	ResourceConfigurationIdentifier *string

	// Indicates whether to add the resource configuration to service networks that
	// are shared with other accounts.
	AllowAssociationToShareableServiceNetwork *bool

	// The TCP port ranges that a consumer can use to access a resource configuration.
	// You can separate port ranges with a comma. Example: 1-65535 or 1,2,22-30
	PortRanges []string

	// Identifies the resource configuration in one of the following ways:
	//
	//   - Amazon Resource Name (ARN) - Supported resource-types that are provisioned
	//   by Amazon Web Services services, such as RDS databases, can be identified by
	//   their ARN.
	//
	//   - Domain name - Any domain name that is publicly resolvable.
	//
	//   - IP address - For IPv4 and IPv6, only IP addresses in the VPC are supported.
	ResourceConfigurationDefinition types.ResourceConfigurationDefinition

	noSmithyDocumentSerde
}

type UpdateResourceConfigurationOutput struct {

	// Indicates whether to add the resource configuration to service networks that
	// are shared with other accounts.
	AllowAssociationToShareableServiceNetwork *bool

	// The Amazon Resource Name (ARN) of the resource configuration.
	Arn *string

	// The ID of the resource configuration.
	Id *string

	// The name of the resource configuration.
	Name *string

	// The TCP port ranges that a consumer can use to access a resource configuration.
	// You can separate port ranges with a comma. Example: 1-65535 or 1,2,22-30
	PortRanges []string

	// The TCP protocol accepted by the specified resource configuration.
	Protocol types.ProtocolType

	// The resource configuration.
	ResourceConfigurationDefinition types.ResourceConfigurationDefinition

	// The ID of the group resource configuration.
	ResourceConfigurationGroupId *string

	// The ID of the resource gateway associated with the resource configuration.
	ResourceGatewayId *string

	// The status of the resource configuration.
	Status types.ResourceConfigurationStatus

	// The type of resource configuration.
	//
	//   - SINGLE - A single resource.
	//
	//   - GROUP - A group of resources.
	//
	//   - CHILD - A single resource that is part of a group resource configuration.
	//
	//   - ARN - An Amazon Web Services resource.
	Type types.ResourceConfigurationType

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationUpdateResourceConfigurationMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpUpdateResourceConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpUpdateResourceConfiguration{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "UpdateResourceConfiguration"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpUpdateResourceConfigurationValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opUpdateResourceConfiguration(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opUpdateResourceConfiguration(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "UpdateResourceConfiguration",
	}
}
