// Code generated by smithy-go-codegen DO NOT EDIT.

package types

import (
	smithydocument "github.com/aws/smithy-go/document"
	"time"
)

// Summary information about an access log subscription.
type AccessLogSubscriptionSummary struct {

	// The Amazon Resource Name (ARN) of the access log subscription
	//
	// This member is required.
	Arn *string

	// The date and time that the access log subscription was created, in ISO-8601
	// format.
	//
	// This member is required.
	CreatedAt *time.Time

	// The Amazon Resource Name (ARN) of the destination.
	//
	// This member is required.
	DestinationArn *string

	// The ID of the access log subscription.
	//
	// This member is required.
	Id *string

	// The date and time that the access log subscription was last updated, in
	// ISO-8601 format.
	//
	// This member is required.
	LastUpdatedAt *time.Time

	// The Amazon Resource Name (ARN) of the service or service network.
	//
	// This member is required.
	ResourceArn *string

	// The ID of the service or service network.
	//
	// This member is required.
	ResourceId *string

	// Log type of the service network.
	ServiceNetworkLogType ServiceNetworkLogType

	noSmithyDocumentSerde
}

// The Amazon Resource Name (ARN) of the resource.
type ArnResource struct {

	// The Amazon Resource Name (ARN) of the resource.
	Arn *string

	noSmithyDocumentSerde
}

// Describes the DNS information of a service.
type DnsEntry struct {

	// The domain name of the service.
	DomainName *string

	// The ID of the hosted zone.
	HostedZoneId *string

	noSmithyDocumentSerde
}

// The DNS configuration options.
type DnsOptions struct {

	//  The preference for which private domains have a private hosted zone created
	// for and associated with the specified VPC. Only supported when private DNS is
	// enabled and when the VPC endpoint type is ServiceNetwork or Resource.
	//
	//   - ALL_DOMAINS - VPC Lattice provisions private hosted zones for all custom
	//   domain names.
	//
	//   - VERIFIED_DOMAINS_ONLY - VPC Lattice provisions a private hosted zone only if
	//   custom domain name has been verified by the provider.
	//
	//   - VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS - VPC Lattice provisions private
	//   hosted zones for all verified custom domain names and other domain names that
	//   the resource consumer specifies. The resource consumer specifies the domain
	//   names in the privateDnsSpecifiedDomains parameter.
	//
	//   - SPECIFIED_DOMAINS_ONLY - VPC Lattice provisions a private hosted zone for
	//   domain names specified by the resource consumer. The resource consumer specifies
	//   the domain names in the privateDnsSpecifiedDomains parameter.
	PrivateDnsPreference PrivateDnsPreference

	//  Indicates which of the private domains to create private hosted zones for and
	// associate with the specified VPC. Only supported when private DNS is enabled and
	// the private DNS preference is VERIFIED_DOMAINS_AND_SPECIFIED_DOMAINS or
	// SPECIFIED_DOMAINS_ONLY .
	PrivateDnsSpecifiedDomains []string

	noSmithyDocumentSerde
}

// The DNS name of the resource.
type DnsResource struct {

	// The domain name of the resource.
	DomainName *string

	// The type of IP address. Dualstack is currently not supported.
	IpAddressType ResourceConfigurationIpAddressType

	noSmithyDocumentSerde
}

// Summary information about a domain verification.
type DomainVerificationSummary struct {

	//  The Amazon Resource Name (ARN) of the domain verification.
	//
	// This member is required.
	Arn *string

	//  The date and time that the domain verification was created, in ISO-8601
	// format.
	//
	// This member is required.
	CreatedAt *time.Time

	//  The domain name being verified.
	//
	// This member is required.
	DomainName *string

	//  The ID of the domain verification.
	//
	// This member is required.
	Id *string

	//  The current status of the domain verification process.
	//
	// This member is required.
	Status VerificationStatus

	//  The date and time that the domain was last successfully verified, in ISO-8601
	// format.
	LastVerifiedTime *time.Time

	//  The tags associated with the domain verification.
	Tags map[string]string

	//  The TXT record configuration used for domain verification.
	TxtMethodConfig *TxtMethodConfig

	noSmithyDocumentSerde
}

// Describes an action that returns a custom HTTP response.
type FixedResponseAction struct {

	// The HTTP response code. Only 404 and 500 status codes are supported.
	//
	// This member is required.
	StatusCode *int32

	noSmithyDocumentSerde
}

// Describes a forward action. You can use forward actions to route requests to
// one or more target groups.
type ForwardAction struct {

	// The target groups. Traffic matching the rule is forwarded to the specified
	// target groups. With forward actions, you can assign a weight that controls the
	// prioritization and selection of each target group. This means that requests are
	// distributed to individual target groups based on their weights. For example, if
	// two target groups have the same weight, each target group receives half of the
	// traffic.
	//
	// The default value is 1. This means that if only one target group is provided,
	// there is no need to set the weight; 100% of the traffic goes to that target
	// group.
	//
	// This member is required.
	TargetGroups []WeightedTargetGroup

	noSmithyDocumentSerde
}

// Describes the constraints for a header match. Matches incoming requests with
// rule based on request header value before applying rule action.
type HeaderMatch struct {

	// The header match type.
	//
	// This member is required.
	Match HeaderMatchType

	// The name of the header.
	//
	// This member is required.
	Name *string

	// Indicates whether the match is case sensitive.
	CaseSensitive *bool

	noSmithyDocumentSerde
}

// Describes a header match type.
//
// The following types satisfy this interface:
//
//	HeaderMatchTypeMemberContains
//	HeaderMatchTypeMemberExact
//	HeaderMatchTypeMemberPrefix
type HeaderMatchType interface {
	isHeaderMatchType()
}

// A contains type match.
type HeaderMatchTypeMemberContains struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchTypeMemberContains) isHeaderMatchType() {}

// An exact type match.
type HeaderMatchTypeMemberExact struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchTypeMemberExact) isHeaderMatchType() {}

// A prefix type match. Matches the value with the prefix.
type HeaderMatchTypeMemberPrefix struct {
	Value string

	noSmithyDocumentSerde
}

func (*HeaderMatchTypeMemberPrefix) isHeaderMatchType() {}

// Describes the health check configuration of a target group. Health check
// configurations aren't used for target groups of type LAMBDA or ALB .
type HealthCheckConfig struct {

	// Indicates whether health checking is enabled.
	Enabled *bool

	// The approximate amount of time, in seconds, between health checks of an
	// individual target. The range is 5–300 seconds. The default is 30 seconds.
	HealthCheckIntervalSeconds *int32

	// The amount of time, in seconds, to wait before reporting a target as unhealthy.
	// The range is 1–120 seconds. The default is 5 seconds.
	HealthCheckTimeoutSeconds *int32

	// The number of consecutive successful health checks required before considering
	// an unhealthy target healthy. The range is 2–10. The default is 5.
	HealthyThresholdCount *int32

	// The codes to use when checking for a successful response from a target.
	Matcher Matcher

	// The destination for health checks on the targets. If the protocol version is
	// HTTP/1.1 or HTTP/2 , specify a valid URI (for example, /path?query ). The
	// default path is / . Health checks are not supported if the protocol version is
	// gRPC , however, you can choose HTTP/1.1 or HTTP/2 and specify a valid URI.
	Path *string

	// The port used when performing health checks on targets. The default setting is
	// the port that a target receives traffic on.
	Port *int32

	// The protocol used when performing health checks on targets. The possible
	// protocols are HTTP and HTTPS . The default is HTTP .
	Protocol TargetGroupProtocol

	// The protocol version used when performing health checks on targets. The
	// possible protocol versions are HTTP1 and HTTP2 .
	ProtocolVersion HealthCheckProtocolVersion

	// The number of consecutive failed health checks required before considering a
	// target unhealthy. The range is 2–10. The default is 2.
	UnhealthyThresholdCount *int32

	noSmithyDocumentSerde
}

// Describes criteria that can be applied to incoming requests.
type HttpMatch struct {

	// The header matches. Matches incoming requests with rule based on request header
	// value before applying rule action.
	HeaderMatches []HeaderMatch

	// The HTTP method type.
	Method *string

	// The path match.
	PathMatch *PathMatch

	noSmithyDocumentSerde
}

// Describes an IP resource.
type IpResource struct {

	// The IP address of the IP resource.
	IpAddress *string

	noSmithyDocumentSerde
}

// Summary information about a listener.
type ListenerSummary struct {

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string

	// The date and time that the listener was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The ID of the listener.
	Id *string

	// The date and time that the listener was last updated, in ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the listener.
	Name *string

	// The listener port.
	Port *int32

	// The listener protocol.
	Protocol ListenerProtocol

	noSmithyDocumentSerde
}

// Describes the codes to use when checking for a successful response from a
// target for health checks.
//
// The following types satisfy this interface:
//
//	MatcherMemberHttpCode
type Matcher interface {
	isMatcher()
}

// The HTTP code to use when checking for a successful response from a target.
type MatcherMemberHttpCode struct {
	Value string

	noSmithyDocumentSerde
}

func (*MatcherMemberHttpCode) isMatcher() {}

// Describes the conditions that can be applied when matching a path for incoming
// requests.
type PathMatch struct {

	// The type of path match.
	//
	// This member is required.
	Match PathMatchType

	// Indicates whether the match is case sensitive.
	CaseSensitive *bool

	noSmithyDocumentSerde
}

// Describes a path match type. Each rule can include only one of the following
// types of paths.
//
// The following types satisfy this interface:
//
//	PathMatchTypeMemberExact
//	PathMatchTypeMemberPrefix
type PathMatchType interface {
	isPathMatchType()
}

// An exact match of the path.
type PathMatchTypeMemberExact struct {
	Value string

	noSmithyDocumentSerde
}

func (*PathMatchTypeMemberExact) isPathMatchType() {}

// A prefix match of the path.
type PathMatchTypeMemberPrefix struct {
	Value string

	noSmithyDocumentSerde
}

func (*PathMatchTypeMemberPrefix) isPathMatchType() {}

// Describes a resource configuration.
//
// The following types satisfy this interface:
//
//	ResourceConfigurationDefinitionMemberArnResource
//	ResourceConfigurationDefinitionMemberDnsResource
//	ResourceConfigurationDefinitionMemberIpResource
type ResourceConfigurationDefinition interface {
	isResourceConfigurationDefinition()
}

// The Amazon Resource Name (ARN) of the resource.
type ResourceConfigurationDefinitionMemberArnResource struct {
	Value ArnResource

	noSmithyDocumentSerde
}

func (*ResourceConfigurationDefinitionMemberArnResource) isResourceConfigurationDefinition() {}

// The DNS name of the resource.
type ResourceConfigurationDefinitionMemberDnsResource struct {
	Value DnsResource

	noSmithyDocumentSerde
}

func (*ResourceConfigurationDefinitionMemberDnsResource) isResourceConfigurationDefinition() {}

// The IP resource.
type ResourceConfigurationDefinitionMemberIpResource struct {
	Value IpResource

	noSmithyDocumentSerde
}

func (*ResourceConfigurationDefinitionMemberIpResource) isResourceConfigurationDefinition() {}

// Summary information about a resource configuration.
type ResourceConfigurationSummary struct {

	// Indicates whether the resource configuration was created and is managed by
	// Amazon.
	AmazonManaged *bool

	// The Amazon Resource Name (ARN) of the resource configuration.
	Arn *string

	// The date and time that the resource configuration was created, in ISO-8601
	// format.
	CreatedAt *time.Time

	//  The custom domain name.
	CustomDomainName *string

	//  The domain verification ID.
	DomainVerificationId *string

	//  (GROUP) The group domain for a group resource configuration. Any domains that
	// you create for the child resource are subdomains of the group domain. Child
	// resources inherit the verification status of the domain.
	GroupDomain *string

	// The ID of the resource configuration.
	Id *string

	// The most recent date and time that the resource configuration was updated, in
	// ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the resource configuration.
	Name *string

	// The ID of the group resource configuration.
	ResourceConfigurationGroupId *string

	// The ID of the resource gateway.
	ResourceGatewayId *string

	// The status of the resource configuration.
	Status ResourceConfigurationStatus

	// The type of resource configuration.
	//
	//   - SINGLE - A single resource.
	//
	//   - GROUP - A group of resources. You must create a group resource configuration
	//   before you create a child resource configuration.
	//
	//   - CHILD - A single resource that is part of a group resource configuration.
	//
	//   - ARN - An Amazon Web Services resource.
	Type ResourceConfigurationType

	noSmithyDocumentSerde
}

// Summary information about a VPC endpoint association.
type ResourceEndpointAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the VPC endpoint association.
	Arn *string

	// The date and time that the VPC endpoint association was created, in ISO-8601
	// format.
	CreatedAt *time.Time

	// The account that created the association.
	CreatedBy *string

	// The ID of the VPC endpoint association.
	Id *string

	// The Amazon Resource Name (ARN) of the resource configuration.
	ResourceConfigurationArn *string

	// The ID of the resource configuration.
	ResourceConfigurationId *string

	// The name of the resource configuration.
	ResourceConfigurationName *string

	// The ID of the VPC endpoint.
	VpcEndpointId *string

	// The owner of the VPC endpoint.
	VpcEndpointOwner *string

	noSmithyDocumentSerde
}

// Summary information about a resource gateway.
type ResourceGatewaySummary struct {

	// The Amazon Resource Name (ARN) of the resource gateway.
	Arn *string

	// The date and time that the VPC endpoint association was created, in ISO-8601
	// format.
	CreatedAt *time.Time

	// The ID of the resource gateway.
	Id *string

	// The type of IP address used by the resource gateway.
	IpAddressType ResourceGatewayIpAddressType

	// The number of IPv4 addresses in each ENI for the resource gateway.
	Ipv4AddressesPerEni *int32

	// The most recent date and time that the resource gateway was updated, in
	// ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the resource gateway.
	Name *string

	// The IDs of the security groups applied to the resource gateway.
	SecurityGroupIds []string

	// The name of the resource gateway.
	Status ResourceGatewayStatus

	// The IDs of the VPC subnets for the resource gateway.
	SubnetIds []string

	// The ID of the VPC for the resource gateway.
	VpcIdentifier *string

	noSmithyDocumentSerde
}

// Describes the action for a rule.
//
// The following types satisfy this interface:
//
//	RuleActionMemberFixedResponse
//	RuleActionMemberForward
type RuleAction interface {
	isRuleAction()
}

// The fixed response action. The rule returns a custom HTTP response.
type RuleActionMemberFixedResponse struct {
	Value FixedResponseAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberFixedResponse) isRuleAction() {}

// The forward action. Traffic that matches the rule is forwarded to the specified
// target groups.
type RuleActionMemberForward struct {
	Value ForwardAction

	noSmithyDocumentSerde
}

func (*RuleActionMemberForward) isRuleAction() {}

// Describes a rule match.
//
// The following types satisfy this interface:
//
//	RuleMatchMemberHttpMatch
type RuleMatch interface {
	isRuleMatch()
}

// The HTTP criteria that a rule must match.
type RuleMatchMemberHttpMatch struct {
	Value HttpMatch

	noSmithyDocumentSerde
}

func (*RuleMatchMemberHttpMatch) isRuleMatch() {}

// Summary information about a listener rule.
type RuleSummary struct {

	// The Amazon Resource Name (ARN) of the rule.
	Arn *string

	// The date and time that the listener rule was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The ID of the rule.
	Id *string

	// Indicates whether this is the default listener rule.
	IsDefault *bool

	// The date and time that the listener rule was last updated, in ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the rule.
	Name *string

	// The priority of the rule.
	Priority *int32

	noSmithyDocumentSerde
}

// Describes a rule update.
type RuleUpdate struct {

	// The ID or ARN of the rule.
	//
	// This member is required.
	RuleIdentifier *string

	// The rule action.
	Action RuleAction

	// The rule match.
	Match RuleMatch

	// The rule priority. A listener can't have multiple rules with the same priority.
	Priority *int32

	noSmithyDocumentSerde
}

// Describes a rule update that failed.
type RuleUpdateFailure struct {

	// The failure code.
	FailureCode *string

	// The failure message.
	FailureMessage *string

	// The ID or ARN of the rule.
	RuleIdentifier *string

	noSmithyDocumentSerde
}

// Describes a successful rule update.
type RuleUpdateSuccess struct {

	// The action for the rule.
	Action RuleAction

	// The Amazon Resource Name (ARN) of the listener.
	Arn *string

	// The ID of the listener.
	Id *string

	// Indicates whether this is the default rule.
	IsDefault *bool

	// The rule match.
	Match RuleMatch

	// The name of the listener.
	Name *string

	// The rule priority.
	Priority *int32

	noSmithyDocumentSerde
}

// Describes the association between a service network and a VPC endpoint.
type ServiceNetworkEndpointAssociation struct {

	// The date and time that the association was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The ID of the association.
	Id *string

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string

	// The state of the association.
	State *string

	// The ID of the VPC endpoint associated with the service network.
	VpcEndpointId *string

	// The owner of the VPC endpoint associated with the service network.
	VpcEndpointOwnerId *string

	// The ID of the VPC for the association.
	VpcId *string

	noSmithyDocumentSerde
}

// Summary information about an association between a service network and a
// resource configuration.
type ServiceNetworkResourceAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the association.
	Arn *string

	// The date and time that the association was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The account that created the association.
	CreatedBy *string

	// The DNS entry for the service.
	DnsEntry *DnsEntry

	// The failure code.
	FailureCode *string

	// The ID of the association between the service network and resource
	// configuration.
	Id *string

	// Specifies whether the association is managed by Amazon.
	IsManagedAssociation *bool

	//  Indicates if private DNS is enabled for the service network resource
	// association.
	PrivateDnsEnabled *bool

	// The private DNS entry for the service.
	PrivateDnsEntry *DnsEntry

	// The Amazon Resource Name (ARN) of the association.
	ResourceConfigurationArn *string

	// The ID of the resource configuration associated with the service network.
	ResourceConfigurationId *string

	// The name of the resource configuration associated with the service network.
	ResourceConfigurationName *string

	// The Amazon Resource Name (ARN) of the service network associated with the
	// resource configuration.
	ServiceNetworkArn *string

	// The ID of the service network associated with the resource configuration.
	ServiceNetworkId *string

	// The name of the service network associated with the resource configuration.
	ServiceNetworkName *string

	// The status of the service network’s association with the resource
	// configuration. If the deletion fails, try to delete again.
	Status ServiceNetworkResourceAssociationStatus

	noSmithyDocumentSerde
}

// Summary information about an association between a service network and a
// service.
type ServiceNetworkServiceAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the association.
	Arn *string

	// The date and time that the association was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The account that created the association.
	CreatedBy *string

	// The custom domain name of the service.
	CustomDomainName *string

	// The DNS information.
	DnsEntry *DnsEntry

	// The ID of the association.
	Id *string

	// The Amazon Resource Name (ARN) of the service.
	ServiceArn *string

	// The ID of the service.
	ServiceId *string

	// The name of the service.
	ServiceName *string

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string

	// The ID of the service network.
	ServiceNetworkId *string

	// The name of the service network.
	ServiceNetworkName *string

	// The status of the service network’s association with the service. If the
	// deletion fails, try to delete again.
	Status ServiceNetworkServiceAssociationStatus

	noSmithyDocumentSerde
}

// Summary information about a service network.
type ServiceNetworkSummary struct {

	// The Amazon Resource Name (ARN) of the service network.
	Arn *string

	// The date and time that the service network was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The ID of the service network.
	Id *string

	// The date and time that the service network was last updated, in ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the service network.
	Name *string

	// The number of resource configurations associated with a service network.
	NumberOfAssociatedResourceConfigurations *int64

	// The number of services associated with the service network.
	NumberOfAssociatedServices *int64

	// The number of VPCs associated with the service network.
	NumberOfAssociatedVPCs *int64

	noSmithyDocumentSerde
}

// Summary information about an association between a service network and a VPC.
type ServiceNetworkVpcAssociationSummary struct {

	// The Amazon Resource Name (ARN) of the association.
	Arn *string

	// The date and time that the association was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The account that created the association.
	CreatedBy *string

	//  The DNS options for the service network VPC association.
	DnsOptions *DnsOptions

	// The ID of the association.
	Id *string

	// The date and time that the association was last updated, in ISO-8601 format.
	LastUpdatedAt *time.Time

	//  Indicates if private DNS is enabled for the service network VPC association.
	PrivateDnsEnabled *bool

	// The Amazon Resource Name (ARN) of the service network.
	ServiceNetworkArn *string

	// The ID of the service network.
	ServiceNetworkId *string

	// The name of the service network.
	ServiceNetworkName *string

	// The status.
	Status ServiceNetworkVpcAssociationStatus

	// The ID of the VPC.
	VpcId *string

	noSmithyDocumentSerde
}

// Summary information about a service.
type ServiceSummary struct {

	// The Amazon Resource Name (ARN) of the service.
	Arn *string

	// The date and time that the service was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The custom domain name of the service.
	CustomDomainName *string

	// The DNS information.
	DnsEntry *DnsEntry

	// The ID of the service.
	Id *string

	// The date and time that the service was last updated, in ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the service.
	Name *string

	// The status.
	Status ServiceStatus

	noSmithyDocumentSerde
}

// Specifies if the service network should be enabled for sharing.
type SharingConfig struct {

	// Specifies if the service network is enabled for sharing.
	Enabled *bool

	noSmithyDocumentSerde
}

// Describes a target.
type Target struct {

	// The ID of the target. If the target group type is INSTANCE , this is an instance
	// ID. If the target group type is IP , this is an IP address. If the target group
	// type is LAMBDA , this is the ARN of a Lambda function. If the target group type
	// is ALB , this is the ARN of an Application Load Balancer.
	//
	// This member is required.
	Id *string

	// The port on which the target is listening. For HTTP, the default is 80. For
	// HTTPS, the default is 443.
	Port *int32

	noSmithyDocumentSerde
}

// Describes a target failure.
type TargetFailure struct {

	// The failure code.
	FailureCode *string

	// The failure message.
	FailureMessage *string

	// The ID of the target. If the target group type is INSTANCE , this is an instance
	// ID. If the target group type is IP , this is an IP address. If the target group
	// type is LAMBDA , this is the ARN of a Lambda function. If the target group type
	// is ALB , this is the ARN of an Application Load Balancer.
	Id *string

	// The port on which the target is listening. This parameter doesn't apply if the
	// target is a Lambda function.
	Port *int32

	noSmithyDocumentSerde
}

// Describes the configuration of a target group.
//
// For more information, see [Target groups] in the Amazon VPC Lattice User Guide.
//
// [Target groups]: https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html
type TargetGroupConfig struct {

	// The health check configuration. Not supported if the target group type is LAMBDA
	// or ALB .
	HealthCheck *HealthCheckConfig

	// The type of IP address used for the target group. Supported only if the target
	// group type is IP . The default is IPV4 .
	IpAddressType IpAddressType

	// The version of the event structure that your Lambda function receives.
	// Supported only if the target group type is LAMBDA . The default is V1 .
	LambdaEventStructureVersion LambdaEventStructureVersion

	// The port on which the targets are listening. For HTTP, the default is 80. For
	// HTTPS, the default is 443. Not supported if the target group type is LAMBDA .
	Port *int32

	// The protocol to use for routing traffic to the targets. The default is the
	// protocol of the target group. Not supported if the target group type is LAMBDA .
	Protocol TargetGroupProtocol

	// The protocol version. The default is HTTP1 . Not supported if the target group
	// type is LAMBDA .
	ProtocolVersion TargetGroupProtocolVersion

	// The ID of the VPC. Not supported if the target group type is LAMBDA .
	VpcIdentifier *string

	noSmithyDocumentSerde
}

// Summary information about a target group.
//
// For more information, see [Target groups] in the Amazon VPC Lattice User Guide.
//
// [Target groups]: https://docs.aws.amazon.com/vpc-lattice/latest/ug/target-groups.html
type TargetGroupSummary struct {

	// The ARN (Amazon Resource Name) of the target group.
	Arn *string

	// The date and time that the target group was created, in ISO-8601 format.
	CreatedAt *time.Time

	// The ID of the target group.
	Id *string

	// The type of IP address used for the target group. The possible values are IPV4
	// and IPV6 . This is an optional parameter. If not specified, the default is IPV4 .
	IpAddressType IpAddressType

	// The version of the event structure that your Lambda function receives.
	// Supported only if the target group type is LAMBDA .
	LambdaEventStructureVersion LambdaEventStructureVersion

	// The date and time that the target group was last updated, in ISO-8601 format.
	LastUpdatedAt *time.Time

	// The name of the target group.
	Name *string

	// The port of the target group.
	Port *int32

	// The protocol of the target group.
	Protocol TargetGroupProtocol

	// The Amazon Resource Names (ARNs) of the service.
	ServiceArns []string

	// The status.
	Status TargetGroupStatus

	// The target group type.
	Type TargetGroupType

	// The ID of the VPC of the target group.
	VpcIdentifier *string

	noSmithyDocumentSerde
}

// Summary information about a target.
type TargetSummary struct {

	// The ID of the target. If the target group type is INSTANCE , this is an instance
	// ID. If the target group type is IP , this is an IP address. If the target group
	// type is LAMBDA , this is the ARN of a Lambda function. If the target type is ALB
	// , this is the ARN of an Application Load Balancer.
	Id *string

	// The port on which the target is listening.
	Port *int32

	// The code for why the target status is what it is.
	ReasonCode *string

	// The status of the target.
	//
	//   - DRAINING : The target is being deregistered. No new connections are sent to
	//   this target while current connections are being drained. The default draining
	//   time is 5 minutes.
	//
	//   - UNAVAILABLE : Health checks are unavailable for the target group.
	//
	//   - HEALTHY : The target is healthy.
	//
	//   - UNHEALTHY : The target is unhealthy.
	//
	//   - INITIAL : Initial health checks on the target are being performed.
	//
	//   - UNUSED : Target group is not used in a service.
	Status TargetStatus

	noSmithyDocumentSerde
}

// Configuration for TXT record-based domain verification method.
type TxtMethodConfig struct {

	//  The name of the TXT record that must be created for domain verification.
	//
	// This member is required.
	Name *string

	//  The value that must be added to the TXT record for domain verification.
	//
	// This member is required.
	Value *string

	noSmithyDocumentSerde
}

// Describes a validation failure.
type ValidationExceptionField struct {

	// Additional information about why the validation failed.
	//
	// This member is required.
	Message *string

	// The name of the validation exception.
	//
	// This member is required.
	Name *string

	noSmithyDocumentSerde
}

// Describes the weight of a target group.
type WeightedTargetGroup struct {

	// The ID or ARN of the target group.
	//
	// This member is required.
	TargetGroupIdentifier *string

	// Only required if you specify multiple target groups for a forward action. The
	// weight determines how requests are distributed to the target group. For example,
	// if you specify two target groups, each with a weight of 10, each target group
	// receives half the requests. If you specify two target groups, one with a weight
	// of 10 and the other with a weight of 20, the target group with a weight of 20
	// receives twice as many requests as the other target group. If there's only one
	// target group specified, then the default value is 100.
	Weight *int32

	noSmithyDocumentSerde
}

type noSmithyDocumentSerde = smithydocument.NoSerde

// UnknownUnionMember is returned when a union member is returned over the wire,
// but has an unknown tag.
type UnknownUnionMember struct {
	Tag   string
	Value []byte

	noSmithyDocumentSerde
}

func (*UnknownUnionMember) isHeaderMatchType()                 {}
func (*UnknownUnionMember) isMatcher()                         {}
func (*UnknownUnionMember) isPathMatchType()                   {}
func (*UnknownUnionMember) isResourceConfigurationDefinition() {}
func (*UnknownUnionMember) isRuleAction()                      {}
func (*UnknownUnionMember) isRuleMatch()                       {}
