// Code generated by smithy-go-codegen DO NOT EDIT.

package workspacesinstances

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/workspacesinstances/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of instance types supported by Amazon WorkSpaces Instances,
// enabling precise workspace infrastructure configuration.
func (c *Client) ListInstanceTypes(ctx context.Context, params *ListInstanceTypesInput, optFns ...func(*Options)) (*ListInstanceTypesOutput, error) {
	if params == nil {
		params = &ListInstanceTypesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListInstanceTypes", params, optFns, c.addOperationListInstanceTypesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListInstanceTypesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

// Defines input parameters for retrieving supported WorkSpaces Instances instance
// types.
type ListInstanceTypesInput struct {

	// Maximum number of instance types to return in a single API call. Enables
	// pagination of instance type results.
	MaxResults *int32

	// Pagination token for retrieving subsequent pages of instance type results.
	NextToken *string

	noSmithyDocumentSerde
}

// Contains the list of instance types supported by WorkSpaces Instances.
type ListInstanceTypesOutput struct {

	// Collection of supported instance types for WorkSpaces Instances.
	//
	// This member is required.
	InstanceTypes []types.InstanceTypeInfo

	// Token for retrieving additional instance types if the result set is paginated.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListInstanceTypesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsAwsjson10_serializeOpListInstanceTypes{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsAwsjson10_deserializeOpListInstanceTypes{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListInstanceTypes"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListInstanceTypes(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

// ListInstanceTypesPaginatorOptions is the paginator options for ListInstanceTypes
type ListInstanceTypesPaginatorOptions struct {
	// Maximum number of instance types to return in a single API call. Enables
	// pagination of instance type results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListInstanceTypesPaginator is a paginator for ListInstanceTypes
type ListInstanceTypesPaginator struct {
	options   ListInstanceTypesPaginatorOptions
	client    ListInstanceTypesAPIClient
	params    *ListInstanceTypesInput
	nextToken *string
	firstPage bool
}

// NewListInstanceTypesPaginator returns a new ListInstanceTypesPaginator
func NewListInstanceTypesPaginator(client ListInstanceTypesAPIClient, params *ListInstanceTypesInput, optFns ...func(*ListInstanceTypesPaginatorOptions)) *ListInstanceTypesPaginator {
	if params == nil {
		params = &ListInstanceTypesInput{}
	}

	options := ListInstanceTypesPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListInstanceTypesPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListInstanceTypesPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListInstanceTypes page.
func (p *ListInstanceTypesPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListInstanceTypesOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	optFns = append([]func(*Options){
		addIsPaginatorUserAgent,
	}, optFns...)
	result, err := p.client.ListInstanceTypes(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

// ListInstanceTypesAPIClient is a client that implements the ListInstanceTypes
// operation.
type ListInstanceTypesAPIClient interface {
	ListInstanceTypes(context.Context, *ListInstanceTypesInput, ...func(*Options)) (*ListInstanceTypesOutput, error)
}

var _ ListInstanceTypesAPIClient = (*Client)(nil)

func newServiceMetadataMiddleware_opListInstanceTypes(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListInstanceTypes",
	}
}
