// Code generated by smithy-go-codegen DO NOT EDIT.

package xray

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/service/xray/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

//	Retrieves a list of traces for a given RetrievalToken from the CloudWatch log
//
// group generated by Transaction Search. For information on what each trace
// returns, see [BatchGetTraces].
//
// This API does not initiate a retrieval process. To start a trace retrieval, use
// StartTraceRetrieval , which generates the required RetrievalToken .
//
// When the RetrievalStatus is not COMPLETE, the API will return an empty
// response. Retry the request once the retrieval has completed to access the full
// list of traces.
//
// For cross-account observability, this API can retrieve traces from linked
// accounts when CloudWatch log is set as the destination across relevant accounts.
// For more details, see [CloudWatch cross-account observability].
//
// For retrieving data from X-Ray directly as opposed to the Transaction Search
// generated log group, see [BatchGetTraces].
//
// [BatchGetTraces]: https://docs.aws.amazon.com/xray/latest/api/API_BatchGetTraces.html
// [CloudWatch cross-account observability]: https://docs.aws.amazon.com/AmazonCloudWatch/latest/monitoring/CloudWatch-Unified-Cross-Account.html
func (c *Client) ListRetrievedTraces(ctx context.Context, params *ListRetrievedTracesInput, optFns ...func(*Options)) (*ListRetrievedTracesOutput, error) {
	if params == nil {
		params = &ListRetrievedTracesInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListRetrievedTraces", params, optFns, c.addOperationListRetrievedTracesMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListRetrievedTracesOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListRetrievedTracesInput struct {

	//  Retrieval token.
	//
	// This member is required.
	RetrievalToken *string

	//  Specify the pagination token returned by a previous request to retrieve the
	// next page of indexes.
	NextToken *string

	//  Format of the requested traces.
	TraceFormat types.TraceFormatType

	noSmithyDocumentSerde
}

type ListRetrievedTracesOutput struct {

	//  Specify the pagination token returned by a previous request to retrieve the
	// next page of indexes.
	NextToken *string

	//  Status of the retrieval.
	RetrievalStatus types.RetrievalStatus

	//  Format of the requested traces.
	TraceFormat types.TraceFormatType

	//  Full traces for the specified requests.
	Traces []types.RetrievedTrace

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListRetrievedTracesMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListRetrievedTraces{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListRetrievedTraces{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListRetrievedTraces"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = addClientRequestID(stack); err != nil {
		return err
	}
	if err = addComputeContentLength(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = addComputePayloadSHA256(stack); err != nil {
		return err
	}
	if err = addRetry(stack, options); err != nil {
		return err
	}
	if err = addRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = addRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addSpanRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addTimeOffsetBuild(stack, c); err != nil {
		return err
	}
	if err = addUserAgentRetryMode(stack, options); err != nil {
		return err
	}
	if err = addCredentialSource(stack, options); err != nil {
		return err
	}
	if err = addOpListRetrievedTracesValidationMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListRetrievedTraces(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = addRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	if err = addInterceptBeforeRetryLoop(stack, options); err != nil {
		return err
	}
	if err = addInterceptAttempt(stack, options); err != nil {
		return err
	}
	if err = addInterceptors(stack, options); err != nil {
		return err
	}
	return nil
}

func newServiceMetadataMiddleware_opListRetrievedTraces(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListRetrievedTraces",
	}
}
