# AI Usage Policy

This project has strict rules for AI usage:

- **All AI usage in any form must be disclosed.** You must state
  the tool you used (e.g. Claude Code, Cursor, Amp) along with
  the extent that the work was AI-assisted.

- **Pull requests created in any way by AI can only be for accepted issues.**
  Drive-by pull requests that do not reference an accepted issue will be
  closed. If AI isn't disclosed but a maintainer suspects its use, the
  PR will be closed. If you want to share code for a non-accepted issue,
  attach it to the issue.

- **Pull requests created by AI must have been fully verified with
  human use.** AI must not create hypothetically correct code that
  hasn't been tested. Importantly, you must not allow AI to write
  code for platforms or environments you don't have access to manually
  test on.

- **Issues and discussions can use AI assistance, but must have a full
  human-in-the-loop.** This means that any content generated with AI
  must have been reviewed _and edited_ by a human before submission.
  AI is very good at being overly verbose and including noise that
  distracts from the main point. Humans must do their research and
  trim this down.

- **No AI-generated media is allowed (art, images, videos, audio, etc.).**
  Text and code are the only acceptable AI-generated content, per the
  other rules in this policy.

These rules apply only to outside contributions. Maintainers are exempt
from these rules and may use AI tools at their discretion;
they've proven themselves trustworthy to apply good judgment.

## There are Humans Here

Please remember that `aws-vault` is maintained by humans.

Every discussion, issue, and pull request is read and reviewed by
humans (and sometimes machines, too). It is a boundary point at which
people interact with each other and the work done. It is rude and
disrespectful to approach this boundary with low-effort, unqualified
work, since it puts the burden of validation on the maintainer.

In a perfect world, AI would produce high-quality, accurate work
every time. But today, that reality depends on the driver of the AI.
And today, most drivers of AI are just not good enough. So, until either
the people get better, the AI gets better, or both, we have to have
strict rules to protect maintainers.

## AI is Welcome Here

AI assistance is welcome, and many maintainers embrace AI tools as
a productive tool in their workflow. As a project, we welcome AI as
a tool!

**Our reason for the strict AI policy is not due to an anti-AI stance**, but
instead due to the number of highly unqualified people using AI. It's the
people, not the tools, that are the problem.

I include this section to be transparent about the project's usage about
AI for people who may disagree with it, and to address the misconception
that this policy is anti-AI in nature.
