# Contributing to Dasel

Thank you for considering contributing to Dasel! Contributions of all kinds are welcome — whether it's fixing bugs, improving documentation, or adding new features.

## How to Contribute

### 1. Reporting Issues

* Check the [issue tracker](https://github.com/TomWright/dasel/issues) to see if your issue has already been reported.
* If not, open a new issue with a clear description. Please include:

    * Steps to reproduce (if it's a bug)
    * Expected vs actual behavior
    * Versions of Dasel, Go, and your OS

### 2. Suggesting Features

* Open a [discussion](https://github.com/TomWright/dasel/discussions) if you'd like feedback before implementing.
* If the idea is well-defined, create an issue describing the use case and possible syntax.

### 3. Submitting Pull Requests

1. Fork the repository and clone your fork.
2. Create a new branch for your work:

   ```bash
   git checkout -b feature/my-new-feature
   ```
3. Make your changes and add tests if relevant.
4. Run the test suite to ensure nothing is broken:

   ```bash
   go test ./...
   ```
5. Commit your changes with a clear message:

   ```bash
   git commit -m "Add support for XYZ selector"
   ```
6. Push your branch and open a Pull Request.

### 4. Code Style

* Follow Go best practices and conventions.
* Keep code simple and readable.
* Add comments for complex logic.

### 5. Documentation

* Ensure documentation requirements are listed on your PR so docs site can be updated.
* Ensure examples are clear and consistent with the style of existing docs.

### 6. Communication

* Be respectful and constructive in discussions.
* Aim to keep contributions focused and incremental.

---

## Getting Help

If you have questions, feel free to:

* Start a [discussion](https://github.com/TomWright/dasel/discussions)
* Ask in an open issue related to your question

We appreciate your contribution and for helping improve Dasel!
