Feature: change the parent of a feature branch and update proposals

  Background:
    Given a Git repo with origin
    And the origin is "git@github.com:git-town/git-town.git"
    And the branches
      | NAME       | TYPE    | PARENT | LOCATIONS     |
      | old-parent | feature | main   | local, origin |
      | new-parent | feature | main   | local, origin |
    And the commits
      | BRANCH     | LOCATION | MESSAGE           |
      | old-parent | local    | old parent commit |
      | new-parent | local    | new parent commit |
    And the branches
      | NAME  | TYPE    | PARENT     | LOCATIONS     |
      | child | feature | old-parent | local, origin |
    And the commits
      | BRANCH | LOCATION | MESSAGE      |
      | child  | local    | child commit |
    And the proposals
      | ID | SOURCE BRANCH | TARGET BRANCH | TITLE               | BODY            | URL                      |
      | 1  | child         | old-parent    | child proposal      | child body      | https://example.com/pr/1 |
      | 2  | old-parent    | main          | old-parent proposal | old-parent body | https://example.com/pr/2 |
      | 3  | new-parent    | main          | new-parent proposal | new-parent body | https://example.com/pr/3 |
    And Git setting "git-town.proposal-breadcrumb" is "stacks"
    And Git setting "git-town.sync-feature-strategy" is "rebase"
    And the current branch is "child"
    When I run "git-town set-parent new-parent"

  Scenario: result
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                                 |
      |        | Finding proposal from child into old-parent ... #1 (child proposal)     |
      |        | Updating target branch of proposal #1 to new-parent ... ok              |
      | child  | git pull                                                                |
      |        | git -c rebase.updateRefs=false rebase --onto new-parent old-parent      |
      |        | git push --force-with-lease --force-if-includes                         |
      |        | Finding all proposals for child ... new-parent                          |
      |        | Finding proposal from new-parent into main ... #3 (new-parent proposal) |
      |        | Finding proposal from child into new-parent ... #1 (child proposal)     |
      |        | Update body for #1 ... ok                                               |
      |        | Finding all proposals for new-parent ... main                           |
      |        | Finding proposal from child into new-parent ... #1 (child proposal)     |
      |        | Update body for #3 ... ok                                               |
      |        | Finding all proposals for old-parent ... main                           |
      |        | Update body for #2 ... ok                                               |
    And this lineage exists now
      """
      main
        new-parent
          child
        old-parent
      """
    And the proposals are now
      """
      url: https://example.com/pr/1
      number: 1
      source: child
      target: new-parent
      body:
        child body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/3
            - https://example.com/pr/1 :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/2
      number: 2
      source: old-parent
      target: main
      body:
        old-parent body

        <!-- branch-stack-start -->

        <!-- branch-stack-end -->

      url: https://example.com/pr/3
      number: 3
      source: new-parent
      target: main
      body:
        new-parent body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/3 :point_left:
            - https://example.com/pr/1

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->
      """

  Scenario: undo
    When I run "git-town undo"
    Then Git Town runs the commands
      | BRANCH | COMMAND                                                                 |
      | child  | git reset --hard {{ sha 'child commit' }}                               |
      |        | git push --force-with-lease origin {{ sha 'old parent commit' }}:child  |
      |        | Updating target branch of proposal #1 to old-parent ... ok              |
      |        | Finding all proposals for child ... old-parent                          |
      |        | Finding proposal from new-parent into main ... #3 (new-parent proposal) |
      |        | Finding proposal from child into new-parent ... none                    |
      |        | Update body for #1 ... ok                                               |
      |        | Finding all proposals for new-parent ... main                           |
      |        | Finding proposal from child into new-parent ... none                    |
      |        | Update body for #3 ... ok                                               |
      |        | Finding all proposals for old-parent ... main                           |
    And the initial branches and lineage exist now
    And the initial commits exist now
    And the proposals are now
      """
      url: https://example.com/pr/1
      number: 1
      source: child
      target: old-parent
      body:
        child body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/3
            - child :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->

      url: https://example.com/pr/2
      number: 2
      source: old-parent
      target: main
      body:
        old-parent body

        <!-- branch-stack-start -->

        <!-- branch-stack-end -->

      url: https://example.com/pr/3
      number: 3
      source: new-parent
      target: main
      body:
        new-parent body

        <!-- branch-stack-start -->

        -------------------------
        - main
          - https://example.com/pr/3 :point_left:

        <sup>[Stack](https://www.git-town.com/how-to/proposal-breadcrumb.html) generated by [Git Town](https://github.com/git-town/git-town)</sup>

        <!-- branch-stack-end -->
      """
