// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/chat/v1/space_event.proto

package chatpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// An event that represents a change or activity in a Google Chat space. To
// learn more, see [Work with events from Google
// Chat](https://developers.google.com/workspace/chat/events-overview).
type SpaceEvent struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Resource name of the space event.
	//
	// Format: `spaces/{space}/spaceEvents/{spaceEvent}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Time when the event occurred.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
	// Type of space event. Each event type has a batch version, which
	// represents multiple instances of the event type that occur in a short
	// period of time. For `spaceEvents.list()` requests, omit batch event types
	// in your query filter. By default, the server returns both event type and
	// its batch version.
	//
	// Supported event types for
	// [messages](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages):
	//
	//   - New message: `google.workspace.chat.message.v1.created`
	//   - Updated message: `google.workspace.chat.message.v1.updated`
	//   - Deleted message: `google.workspace.chat.message.v1.deleted`
	//   - Multiple new messages: `google.workspace.chat.message.v1.batchCreated`
	//   - Multiple updated messages:
	//     `google.workspace.chat.message.v1.batchUpdated`
	//   - Multiple deleted messages:
	//     `google.workspace.chat.message.v1.batchDeleted`
	//
	// Supported event types for
	// [memberships](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.members):
	//
	//   - New membership: `google.workspace.chat.membership.v1.created`
	//   - Updated membership: `google.workspace.chat.membership.v1.updated`
	//   - Deleted membership: `google.workspace.chat.membership.v1.deleted`
	//   - Multiple new memberships:
	//     `google.workspace.chat.membership.v1.batchCreated`
	//   - Multiple updated memberships:
	//     `google.workspace.chat.membership.v1.batchUpdated`
	//   - Multiple deleted memberships:
	//     `google.workspace.chat.membership.v1.batchDeleted`
	//
	// Supported event types for
	// [reactions](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.messages.reactions):
	//
	//   - New reaction: `google.workspace.chat.reaction.v1.created`
	//   - Deleted reaction: `google.workspace.chat.reaction.v1.deleted`
	//   - Multiple new reactions:
	//     `google.workspace.chat.reaction.v1.batchCreated`
	//   - Multiple deleted reactions:
	//     `google.workspace.chat.reaction.v1.batchDeleted`
	//
	// Supported event types about the
	// [space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces):
	//
	//   - Updated space: `google.workspace.chat.space.v1.updated`
	//   - Multiple space updates: `google.workspace.chat.space.v1.batchUpdated`
	EventType string `protobuf:"bytes,6,opt,name=event_type,json=eventType,proto3" json:"event_type,omitempty"`
	// Types that are assignable to Payload:
	//
	//	*SpaceEvent_MessageCreatedEventData
	//	*SpaceEvent_MessageUpdatedEventData
	//	*SpaceEvent_MessageDeletedEventData
	//	*SpaceEvent_MessageBatchCreatedEventData
	//	*SpaceEvent_MessageBatchUpdatedEventData
	//	*SpaceEvent_MessageBatchDeletedEventData
	//	*SpaceEvent_SpaceUpdatedEventData
	//	*SpaceEvent_SpaceBatchUpdatedEventData
	//	*SpaceEvent_MembershipCreatedEventData
	//	*SpaceEvent_MembershipUpdatedEventData
	//	*SpaceEvent_MembershipDeletedEventData
	//	*SpaceEvent_MembershipBatchCreatedEventData
	//	*SpaceEvent_MembershipBatchUpdatedEventData
	//	*SpaceEvent_MembershipBatchDeletedEventData
	//	*SpaceEvent_ReactionCreatedEventData
	//	*SpaceEvent_ReactionDeletedEventData
	//	*SpaceEvent_ReactionBatchCreatedEventData
	//	*SpaceEvent_ReactionBatchDeletedEventData
	Payload isSpaceEvent_Payload `protobuf_oneof:"payload"`
}

func (x *SpaceEvent) Reset() {
	*x = SpaceEvent{}
	mi := &file_google_chat_v1_space_event_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SpaceEvent) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SpaceEvent) ProtoMessage() {}

func (x *SpaceEvent) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_event_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SpaceEvent.ProtoReflect.Descriptor instead.
func (*SpaceEvent) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_event_proto_rawDescGZIP(), []int{0}
}

func (x *SpaceEvent) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SpaceEvent) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

func (x *SpaceEvent) GetEventType() string {
	if x != nil {
		return x.EventType
	}
	return ""
}

func (m *SpaceEvent) GetPayload() isSpaceEvent_Payload {
	if m != nil {
		return m.Payload
	}
	return nil
}

func (x *SpaceEvent) GetMessageCreatedEventData() *MessageCreatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MessageCreatedEventData); ok {
		return x.MessageCreatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMessageUpdatedEventData() *MessageUpdatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MessageUpdatedEventData); ok {
		return x.MessageUpdatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMessageDeletedEventData() *MessageDeletedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MessageDeletedEventData); ok {
		return x.MessageDeletedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMessageBatchCreatedEventData() *MessageBatchCreatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MessageBatchCreatedEventData); ok {
		return x.MessageBatchCreatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMessageBatchUpdatedEventData() *MessageBatchUpdatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MessageBatchUpdatedEventData); ok {
		return x.MessageBatchUpdatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMessageBatchDeletedEventData() *MessageBatchDeletedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MessageBatchDeletedEventData); ok {
		return x.MessageBatchDeletedEventData
	}
	return nil
}

func (x *SpaceEvent) GetSpaceUpdatedEventData() *SpaceUpdatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_SpaceUpdatedEventData); ok {
		return x.SpaceUpdatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetSpaceBatchUpdatedEventData() *SpaceBatchUpdatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_SpaceBatchUpdatedEventData); ok {
		return x.SpaceBatchUpdatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMembershipCreatedEventData() *MembershipCreatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MembershipCreatedEventData); ok {
		return x.MembershipCreatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMembershipUpdatedEventData() *MembershipUpdatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MembershipUpdatedEventData); ok {
		return x.MembershipUpdatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMembershipDeletedEventData() *MembershipDeletedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MembershipDeletedEventData); ok {
		return x.MembershipDeletedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMembershipBatchCreatedEventData() *MembershipBatchCreatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MembershipBatchCreatedEventData); ok {
		return x.MembershipBatchCreatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMembershipBatchUpdatedEventData() *MembershipBatchUpdatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MembershipBatchUpdatedEventData); ok {
		return x.MembershipBatchUpdatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetMembershipBatchDeletedEventData() *MembershipBatchDeletedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_MembershipBatchDeletedEventData); ok {
		return x.MembershipBatchDeletedEventData
	}
	return nil
}

func (x *SpaceEvent) GetReactionCreatedEventData() *ReactionCreatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_ReactionCreatedEventData); ok {
		return x.ReactionCreatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetReactionDeletedEventData() *ReactionDeletedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_ReactionDeletedEventData); ok {
		return x.ReactionDeletedEventData
	}
	return nil
}

func (x *SpaceEvent) GetReactionBatchCreatedEventData() *ReactionBatchCreatedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_ReactionBatchCreatedEventData); ok {
		return x.ReactionBatchCreatedEventData
	}
	return nil
}

func (x *SpaceEvent) GetReactionBatchDeletedEventData() *ReactionBatchDeletedEventData {
	if x, ok := x.GetPayload().(*SpaceEvent_ReactionBatchDeletedEventData); ok {
		return x.ReactionBatchDeletedEventData
	}
	return nil
}

type isSpaceEvent_Payload interface {
	isSpaceEvent_Payload()
}

type SpaceEvent_MessageCreatedEventData struct {
	// Event payload for a new message.
	//
	// Event type: `google.workspace.chat.message.v1.created`
	MessageCreatedEventData *MessageCreatedEventData `protobuf:"bytes,12,opt,name=message_created_event_data,json=messageCreatedEventData,proto3,oneof"`
}

type SpaceEvent_MessageUpdatedEventData struct {
	// Event payload for an updated message.
	//
	// Event type: `google.workspace.chat.message.v1.updated`
	MessageUpdatedEventData *MessageUpdatedEventData `protobuf:"bytes,13,opt,name=message_updated_event_data,json=messageUpdatedEventData,proto3,oneof"`
}

type SpaceEvent_MessageDeletedEventData struct {
	// Event payload for a deleted message.
	//
	// Event type: `google.workspace.chat.message.v1.deleted`
	MessageDeletedEventData *MessageDeletedEventData `protobuf:"bytes,14,opt,name=message_deleted_event_data,json=messageDeletedEventData,proto3,oneof"`
}

type SpaceEvent_MessageBatchCreatedEventData struct {
	// Event payload for multiple new messages.
	//
	// Event type: `google.workspace.chat.message.v1.batchCreated`
	MessageBatchCreatedEventData *MessageBatchCreatedEventData `protobuf:"bytes,26,opt,name=message_batch_created_event_data,json=messageBatchCreatedEventData,proto3,oneof"`
}

type SpaceEvent_MessageBatchUpdatedEventData struct {
	// Event payload for multiple updated messages.
	//
	// Event type: `google.workspace.chat.message.v1.batchUpdated`
	MessageBatchUpdatedEventData *MessageBatchUpdatedEventData `protobuf:"bytes,27,opt,name=message_batch_updated_event_data,json=messageBatchUpdatedEventData,proto3,oneof"`
}

type SpaceEvent_MessageBatchDeletedEventData struct {
	// Event payload for multiple deleted messages.
	//
	// Event type: `google.workspace.chat.message.v1.batchDeleted`
	MessageBatchDeletedEventData *MessageBatchDeletedEventData `protobuf:"bytes,28,opt,name=message_batch_deleted_event_data,json=messageBatchDeletedEventData,proto3,oneof"`
}

type SpaceEvent_SpaceUpdatedEventData struct {
	// Event payload for a space update.
	//
	// Event type: `google.workspace.chat.space.v1.updated`
	SpaceUpdatedEventData *SpaceUpdatedEventData `protobuf:"bytes,15,opt,name=space_updated_event_data,json=spaceUpdatedEventData,proto3,oneof"`
}

type SpaceEvent_SpaceBatchUpdatedEventData struct {
	// Event payload for multiple updates to a space.
	//
	// Event type: `google.workspace.chat.space.v1.batchUpdated`
	SpaceBatchUpdatedEventData *SpaceBatchUpdatedEventData `protobuf:"bytes,29,opt,name=space_batch_updated_event_data,json=spaceBatchUpdatedEventData,proto3,oneof"`
}

type SpaceEvent_MembershipCreatedEventData struct {
	// Event payload for a new membership.
	//
	// Event type: `google.workspace.chat.membership.v1.created`
	MembershipCreatedEventData *MembershipCreatedEventData `protobuf:"bytes,17,opt,name=membership_created_event_data,json=membershipCreatedEventData,proto3,oneof"`
}

type SpaceEvent_MembershipUpdatedEventData struct {
	// Event payload for an updated membership.
	//
	// Event type: `google.workspace.chat.membership.v1.updated`
	MembershipUpdatedEventData *MembershipUpdatedEventData `protobuf:"bytes,18,opt,name=membership_updated_event_data,json=membershipUpdatedEventData,proto3,oneof"`
}

type SpaceEvent_MembershipDeletedEventData struct {
	// Event payload for a deleted membership.
	//
	// Event type: `google.workspace.chat.membership.v1.deleted`
	MembershipDeletedEventData *MembershipDeletedEventData `protobuf:"bytes,219,opt,name=membership_deleted_event_data,json=membershipDeletedEventData,proto3,oneof"`
}

type SpaceEvent_MembershipBatchCreatedEventData struct {
	// Event payload for multiple new memberships.
	//
	// Event type: `google.workspace.chat.membership.v1.batchCreated`
	MembershipBatchCreatedEventData *MembershipBatchCreatedEventData `protobuf:"bytes,31,opt,name=membership_batch_created_event_data,json=membershipBatchCreatedEventData,proto3,oneof"`
}

type SpaceEvent_MembershipBatchUpdatedEventData struct {
	// Event payload for multiple updated memberships.
	//
	// Event type: `google.workspace.chat.membership.v1.batchUpdated`
	MembershipBatchUpdatedEventData *MembershipBatchUpdatedEventData `protobuf:"bytes,32,opt,name=membership_batch_updated_event_data,json=membershipBatchUpdatedEventData,proto3,oneof"`
}

type SpaceEvent_MembershipBatchDeletedEventData struct {
	// Event payload for multiple deleted memberships.
	//
	// Event type: `google.workspace.chat.membership.v1.batchDeleted`
	MembershipBatchDeletedEventData *MembershipBatchDeletedEventData `protobuf:"bytes,33,opt,name=membership_batch_deleted_event_data,json=membershipBatchDeletedEventData,proto3,oneof"`
}

type SpaceEvent_ReactionCreatedEventData struct {
	// Event payload for a new reaction.
	//
	// Event type: `google.workspace.chat.reaction.v1.created`
	ReactionCreatedEventData *ReactionCreatedEventData `protobuf:"bytes,21,opt,name=reaction_created_event_data,json=reactionCreatedEventData,proto3,oneof"`
}

type SpaceEvent_ReactionDeletedEventData struct {
	// Event payload for a deleted reaction.
	//
	// Event type: `google.workspace.chat.reaction.v1.deleted`
	ReactionDeletedEventData *ReactionDeletedEventData `protobuf:"bytes,22,opt,name=reaction_deleted_event_data,json=reactionDeletedEventData,proto3,oneof"`
}

type SpaceEvent_ReactionBatchCreatedEventData struct {
	// Event payload for multiple new reactions.
	//
	// Event type: `google.workspace.chat.reaction.v1.batchCreated`
	ReactionBatchCreatedEventData *ReactionBatchCreatedEventData `protobuf:"bytes,34,opt,name=reaction_batch_created_event_data,json=reactionBatchCreatedEventData,proto3,oneof"`
}

type SpaceEvent_ReactionBatchDeletedEventData struct {
	// Event payload for multiple deleted reactions.
	//
	// Event type: `google.workspace.chat.reaction.v1.batchDeleted`
	ReactionBatchDeletedEventData *ReactionBatchDeletedEventData `protobuf:"bytes,35,opt,name=reaction_batch_deleted_event_data,json=reactionBatchDeletedEventData,proto3,oneof"`
}

func (*SpaceEvent_MessageCreatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MessageUpdatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MessageDeletedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MessageBatchCreatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MessageBatchUpdatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MessageBatchDeletedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_SpaceUpdatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_SpaceBatchUpdatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MembershipCreatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MembershipUpdatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MembershipDeletedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MembershipBatchCreatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MembershipBatchUpdatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_MembershipBatchDeletedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_ReactionCreatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_ReactionDeletedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_ReactionBatchCreatedEventData) isSpaceEvent_Payload() {}

func (*SpaceEvent_ReactionBatchDeletedEventData) isSpaceEvent_Payload() {}

// Request message for getting a space event.
type GetSpaceEventRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the space event.
	//
	// Format: `spaces/{space}/spaceEvents/{spaceEvent}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetSpaceEventRequest) Reset() {
	*x = GetSpaceEventRequest{}
	mi := &file_google_chat_v1_space_event_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetSpaceEventRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetSpaceEventRequest) ProtoMessage() {}

func (x *GetSpaceEventRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_event_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetSpaceEventRequest.ProtoReflect.Descriptor instead.
func (*GetSpaceEventRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_event_proto_rawDescGZIP(), []int{1}
}

func (x *GetSpaceEventRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for listing space events.
type ListSpaceEventsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Resource name of the [Google Chat
	// space](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces)
	// where the events occurred.
	//
	// Format: `spaces/{space}`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. The maximum number of space events returned. The service might
	// return fewer than this value.
	//
	// Negative values return an `INVALID_ARGUMENT` error.
	PageSize int32 `protobuf:"varint,5,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A page token, received from a previous list space events call.
	// Provide this to retrieve the subsequent page.
	//
	// When paginating, all other parameters provided to list space events must
	// match the call that provided the page token. Passing different values to
	// the other parameters might lead to unexpected results.
	PageToken string `protobuf:"bytes,6,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Required. A query filter.
	//
	// You must specify at least one event type (`event_type`)
	// using the has `:` operator. To filter by multiple event types, use the `OR`
	// operator. Omit batch event types in your filter. The request automatically
	// returns any related batch events. For example, if you filter by new
	// reactions
	// (`google.workspace.chat.reaction.v1.created`), the server also returns
	// batch new reactions events
	// (`google.workspace.chat.reaction.v1.batchCreated`). For a list of supported
	// event types, see the [`SpaceEvents` reference
	// documentation](https://developers.google.com/workspace/chat/api/reference/rest/v1/spaces.spaceEvents#SpaceEvent.FIELDS.event_type).
	//
	// Optionally, you can also filter by start time (`start_time`) and
	// end time (`end_time`):
	//
	// * `start_time`: Exclusive timestamp from which to start listing space
	// events.
	//
	//	You can list events that occurred up to 28 days ago. If unspecified, lists
	//	space events from the past 28 days.
	//   - `end_time`: Inclusive timestamp until which space events are listed.
	//     If unspecified, lists events up to the time of the request.
	//
	// To specify a start or end time, use the equals `=` operator and format in
	// [RFC-3339](https://www.rfc-editor.org/rfc/rfc3339). To filter by both
	// `start_time` and `end_time`, use the `AND` operator.
	//
	// For example, the following queries are valid:
	//
	// ```
	// start_time="2023-08-23T19:20:33+00:00" AND
	// end_time="2023-08-23T19:21:54+00:00"
	// ```
	// ```
	// start_time="2023-08-23T19:20:33+00:00" AND
	// (event_types:"google.workspace.chat.space.v1.updated" OR
	// event_types:"google.workspace.chat.message.v1.created")
	// ```
	//
	// The following queries are invalid:
	//
	// ```
	// start_time="2023-08-23T19:20:33+00:00" OR
	// end_time="2023-08-23T19:21:54+00:00"
	// ```
	// ```
	// event_types:"google.workspace.chat.space.v1.updated" AND
	// event_types:"google.workspace.chat.message.v1.created"
	// ```
	//
	// Invalid queries are rejected by the server with an `INVALID_ARGUMENT`
	// error.
	Filter string `protobuf:"bytes,8,opt,name=filter,proto3" json:"filter,omitempty"`
}

func (x *ListSpaceEventsRequest) Reset() {
	*x = ListSpaceEventsRequest{}
	mi := &file_google_chat_v1_space_event_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSpaceEventsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpaceEventsRequest) ProtoMessage() {}

func (x *ListSpaceEventsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_event_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpaceEventsRequest.ProtoReflect.Descriptor instead.
func (*ListSpaceEventsRequest) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_event_proto_rawDescGZIP(), []int{2}
}

func (x *ListSpaceEventsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListSpaceEventsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListSpaceEventsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListSpaceEventsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

// Response message for listing space events.
type ListSpaceEventsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results are returned in chronological order (oldest event first).
	// Note: The `permissionSettings` field is not returned in the Space
	// object for list requests.
	SpaceEvents []*SpaceEvent `protobuf:"bytes,1,rep,name=space_events,json=spaceEvents,proto3" json:"space_events,omitempty"`
	// Continuation token used to fetch more events.
	// If this field is omitted, there are no subsequent pages.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListSpaceEventsResponse) Reset() {
	*x = ListSpaceEventsResponse{}
	mi := &file_google_chat_v1_space_event_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListSpaceEventsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListSpaceEventsResponse) ProtoMessage() {}

func (x *ListSpaceEventsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_chat_v1_space_event_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListSpaceEventsResponse.ProtoReflect.Descriptor instead.
func (*ListSpaceEventsResponse) Descriptor() ([]byte, []int) {
	return file_google_chat_v1_space_event_proto_rawDescGZIP(), []int{3}
}

func (x *ListSpaceEventsResponse) GetSpaceEvents() []*SpaceEvent {
	if x != nil {
		return x.SpaceEvents
	}
	return nil
}

func (x *ListSpaceEventsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

var File_google_chat_v1_space_event_proto protoreflect.FileDescriptor

var file_google_chat_v1_space_event_proto_rawDesc = []byte{
	0x0a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x12, 0x0e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x22,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x5f, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0xeb, 0x11, 0x0a, 0x0a, 0x53, 0x70, 0x61, 0x63, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x39, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d,
	0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x66, 0x0a, 0x1a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x63, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52,
	0x17, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x66, 0x0a, 0x1a, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x17, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x66, 0x0a, 0x1a, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x65,
	0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x27, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52,
	0x17, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x76, 0x0a, 0x20, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x1a, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x1c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x76, 0x0a, 0x20, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x5f, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x1b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1c, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x76, 0x0a, 0x20, 0x6d, 0x65, 0x73, 0x73,
	0x61, 0x67, 0x65, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x1c, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x48, 0x00, 0x52, 0x1c, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x42, 0x61, 0x74, 0x63, 0x68,
	0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x60, 0x0a, 0x18, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x0f, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x15, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61,
	0x74, 0x61, 0x12, 0x70, 0x0a, 0x1e, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x62, 0x61, 0x74, 0x63,
	0x68, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x64, 0x61, 0x74, 0x61, 0x18, 0x1d, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63,
	0x65, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1a, 0x73, 0x70, 0x61, 0x63, 0x65, 0x42,
	0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x44, 0x61, 0x74, 0x61, 0x12, 0x6f, 0x0a, 0x1d, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x11, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1a, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x6f, 0x0a, 0x1d, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x12, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1a, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x70, 0x0a, 0x1d, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0xdb, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1a, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x23, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18,
	0x1f, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69,
	0x70, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1f, 0x6d, 0x65, 0x6d, 0x62, 0x65, 0x72,
	0x73, 0x68, 0x69, 0x70, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x23, 0x6d, 0x65, 0x6d,
	0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x75, 0x70,
	0x64, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x20, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73, 0x68,
	0x69, 0x70, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1f, 0x6d, 0x65, 0x6d, 0x62, 0x65,
	0x72, 0x73, 0x68, 0x69, 0x70, 0x42, 0x61, 0x74, 0x63, 0x68, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x7f, 0x0a, 0x23, 0x6d, 0x65,
	0x6d, 0x62, 0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x21, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x6d, 0x62, 0x65, 0x72, 0x73,
	0x68, 0x69, 0x70, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1f, 0x6d, 0x65, 0x6d, 0x62,
	0x65, 0x72, 0x73, 0x68, 0x69, 0x70, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74,
	0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x69, 0x0a, 0x1b, 0x72,
	0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x15, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x18, 0x72, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x69, 0x0a, 0x1b, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x64, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x16, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x18, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74,
	0x61, 0x12, 0x79, 0x0a, 0x21, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x61,
	0x74, 0x63, 0x68, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x22, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1d, 0x72,
	0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x64, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x12, 0x79, 0x0a, 0x21,
	0x72, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x64,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x23, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x61, 0x63, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x48, 0x00, 0x52, 0x1d, 0x72, 0x65, 0x61, 0x63, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x61, 0x74, 0x63, 0x68, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x64, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x44, 0x61, 0x74, 0x61, 0x3a, 0x4d, 0xea, 0x41, 0x4a, 0x0a, 0x1e, 0x63, 0x68,
	0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x12, 0x28, 0x73, 0x70,
	0x61, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x7d, 0x2f, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x7d, 0x42, 0x09, 0x0a, 0x07, 0x70, 0x61, 0x79, 0x6c, 0x6f, 0x61,
	0x64, 0x22, 0x52, 0x0a, 0x14, 0x47, 0x65, 0x74, 0x53, 0x70, 0x61, 0x63, 0x65, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x3a, 0x0a, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x0a,
	0x1e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70, 0x61, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0xbb, 0x01, 0x0a, 0x16, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x3e, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x26, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x20, 0x12, 0x1e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x70,
	0x61, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69,
	0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x22, 0x80, 0x01, 0x0a, 0x17, 0x4c, 0x69, 0x73, 0x74, 0x53, 0x70, 0x61, 0x63,
	0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x3d, 0x0a, 0x0c, 0x73, 0x70, 0x61, 0x63, 0x65, 0x5f, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x18,
	0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x70, 0x61, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e,
	0x74, 0x52, 0x0b, 0x73, 0x70, 0x61, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26,
	0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67,
	0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x42, 0x9a, 0x01, 0x0a, 0x12, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x68, 0x61, 0x74, 0x2e, 0x76, 0x31, 0x42, 0x0f, 0x53,
	0x70, 0x61, 0x63, 0x65, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x2c, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x63, 0x68, 0x61, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31,
	0x2f, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0x3b, 0x63, 0x68, 0x61, 0x74, 0x70, 0x62, 0xaa, 0x02,
	0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x41, 0x70, 0x70, 0x73, 0x2e, 0x43, 0x68, 0x61,
	0x74, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x13, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x41, 0x70,
	0x70, 0x73, 0x5c, 0x43, 0x68, 0x61, 0x74, 0x5c, 0x56, 0x31, 0xea, 0x02, 0x16, 0x47, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x41, 0x70, 0x70, 0x73, 0x3a, 0x3a, 0x43, 0x68, 0x61, 0x74, 0x3a,
	0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_chat_v1_space_event_proto_rawDescOnce sync.Once
	file_google_chat_v1_space_event_proto_rawDescData = file_google_chat_v1_space_event_proto_rawDesc
)

func file_google_chat_v1_space_event_proto_rawDescGZIP() []byte {
	file_google_chat_v1_space_event_proto_rawDescOnce.Do(func() {
		file_google_chat_v1_space_event_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_chat_v1_space_event_proto_rawDescData)
	})
	return file_google_chat_v1_space_event_proto_rawDescData
}

var file_google_chat_v1_space_event_proto_msgTypes = make([]protoimpl.MessageInfo, 4)
var file_google_chat_v1_space_event_proto_goTypes = []any{
	(*SpaceEvent)(nil),                      // 0: google.chat.v1.SpaceEvent
	(*GetSpaceEventRequest)(nil),            // 1: google.chat.v1.GetSpaceEventRequest
	(*ListSpaceEventsRequest)(nil),          // 2: google.chat.v1.ListSpaceEventsRequest
	(*ListSpaceEventsResponse)(nil),         // 3: google.chat.v1.ListSpaceEventsResponse
	(*timestamppb.Timestamp)(nil),           // 4: google.protobuf.Timestamp
	(*MessageCreatedEventData)(nil),         // 5: google.chat.v1.MessageCreatedEventData
	(*MessageUpdatedEventData)(nil),         // 6: google.chat.v1.MessageUpdatedEventData
	(*MessageDeletedEventData)(nil),         // 7: google.chat.v1.MessageDeletedEventData
	(*MessageBatchCreatedEventData)(nil),    // 8: google.chat.v1.MessageBatchCreatedEventData
	(*MessageBatchUpdatedEventData)(nil),    // 9: google.chat.v1.MessageBatchUpdatedEventData
	(*MessageBatchDeletedEventData)(nil),    // 10: google.chat.v1.MessageBatchDeletedEventData
	(*SpaceUpdatedEventData)(nil),           // 11: google.chat.v1.SpaceUpdatedEventData
	(*SpaceBatchUpdatedEventData)(nil),      // 12: google.chat.v1.SpaceBatchUpdatedEventData
	(*MembershipCreatedEventData)(nil),      // 13: google.chat.v1.MembershipCreatedEventData
	(*MembershipUpdatedEventData)(nil),      // 14: google.chat.v1.MembershipUpdatedEventData
	(*MembershipDeletedEventData)(nil),      // 15: google.chat.v1.MembershipDeletedEventData
	(*MembershipBatchCreatedEventData)(nil), // 16: google.chat.v1.MembershipBatchCreatedEventData
	(*MembershipBatchUpdatedEventData)(nil), // 17: google.chat.v1.MembershipBatchUpdatedEventData
	(*MembershipBatchDeletedEventData)(nil), // 18: google.chat.v1.MembershipBatchDeletedEventData
	(*ReactionCreatedEventData)(nil),        // 19: google.chat.v1.ReactionCreatedEventData
	(*ReactionDeletedEventData)(nil),        // 20: google.chat.v1.ReactionDeletedEventData
	(*ReactionBatchCreatedEventData)(nil),   // 21: google.chat.v1.ReactionBatchCreatedEventData
	(*ReactionBatchDeletedEventData)(nil),   // 22: google.chat.v1.ReactionBatchDeletedEventData
}
var file_google_chat_v1_space_event_proto_depIdxs = []int32{
	4,  // 0: google.chat.v1.SpaceEvent.event_time:type_name -> google.protobuf.Timestamp
	5,  // 1: google.chat.v1.SpaceEvent.message_created_event_data:type_name -> google.chat.v1.MessageCreatedEventData
	6,  // 2: google.chat.v1.SpaceEvent.message_updated_event_data:type_name -> google.chat.v1.MessageUpdatedEventData
	7,  // 3: google.chat.v1.SpaceEvent.message_deleted_event_data:type_name -> google.chat.v1.MessageDeletedEventData
	8,  // 4: google.chat.v1.SpaceEvent.message_batch_created_event_data:type_name -> google.chat.v1.MessageBatchCreatedEventData
	9,  // 5: google.chat.v1.SpaceEvent.message_batch_updated_event_data:type_name -> google.chat.v1.MessageBatchUpdatedEventData
	10, // 6: google.chat.v1.SpaceEvent.message_batch_deleted_event_data:type_name -> google.chat.v1.MessageBatchDeletedEventData
	11, // 7: google.chat.v1.SpaceEvent.space_updated_event_data:type_name -> google.chat.v1.SpaceUpdatedEventData
	12, // 8: google.chat.v1.SpaceEvent.space_batch_updated_event_data:type_name -> google.chat.v1.SpaceBatchUpdatedEventData
	13, // 9: google.chat.v1.SpaceEvent.membership_created_event_data:type_name -> google.chat.v1.MembershipCreatedEventData
	14, // 10: google.chat.v1.SpaceEvent.membership_updated_event_data:type_name -> google.chat.v1.MembershipUpdatedEventData
	15, // 11: google.chat.v1.SpaceEvent.membership_deleted_event_data:type_name -> google.chat.v1.MembershipDeletedEventData
	16, // 12: google.chat.v1.SpaceEvent.membership_batch_created_event_data:type_name -> google.chat.v1.MembershipBatchCreatedEventData
	17, // 13: google.chat.v1.SpaceEvent.membership_batch_updated_event_data:type_name -> google.chat.v1.MembershipBatchUpdatedEventData
	18, // 14: google.chat.v1.SpaceEvent.membership_batch_deleted_event_data:type_name -> google.chat.v1.MembershipBatchDeletedEventData
	19, // 15: google.chat.v1.SpaceEvent.reaction_created_event_data:type_name -> google.chat.v1.ReactionCreatedEventData
	20, // 16: google.chat.v1.SpaceEvent.reaction_deleted_event_data:type_name -> google.chat.v1.ReactionDeletedEventData
	21, // 17: google.chat.v1.SpaceEvent.reaction_batch_created_event_data:type_name -> google.chat.v1.ReactionBatchCreatedEventData
	22, // 18: google.chat.v1.SpaceEvent.reaction_batch_deleted_event_data:type_name -> google.chat.v1.ReactionBatchDeletedEventData
	0,  // 19: google.chat.v1.ListSpaceEventsResponse.space_events:type_name -> google.chat.v1.SpaceEvent
	20, // [20:20] is the sub-list for method output_type
	20, // [20:20] is the sub-list for method input_type
	20, // [20:20] is the sub-list for extension type_name
	20, // [20:20] is the sub-list for extension extendee
	0,  // [0:20] is the sub-list for field type_name
}

func init() { file_google_chat_v1_space_event_proto_init() }
func file_google_chat_v1_space_event_proto_init() {
	if File_google_chat_v1_space_event_proto != nil {
		return
	}
	file_google_chat_v1_event_payload_proto_init()
	file_google_chat_v1_space_event_proto_msgTypes[0].OneofWrappers = []any{
		(*SpaceEvent_MessageCreatedEventData)(nil),
		(*SpaceEvent_MessageUpdatedEventData)(nil),
		(*SpaceEvent_MessageDeletedEventData)(nil),
		(*SpaceEvent_MessageBatchCreatedEventData)(nil),
		(*SpaceEvent_MessageBatchUpdatedEventData)(nil),
		(*SpaceEvent_MessageBatchDeletedEventData)(nil),
		(*SpaceEvent_SpaceUpdatedEventData)(nil),
		(*SpaceEvent_SpaceBatchUpdatedEventData)(nil),
		(*SpaceEvent_MembershipCreatedEventData)(nil),
		(*SpaceEvent_MembershipUpdatedEventData)(nil),
		(*SpaceEvent_MembershipDeletedEventData)(nil),
		(*SpaceEvent_MembershipBatchCreatedEventData)(nil),
		(*SpaceEvent_MembershipBatchUpdatedEventData)(nil),
		(*SpaceEvent_MembershipBatchDeletedEventData)(nil),
		(*SpaceEvent_ReactionCreatedEventData)(nil),
		(*SpaceEvent_ReactionDeletedEventData)(nil),
		(*SpaceEvent_ReactionBatchCreatedEventData)(nil),
		(*SpaceEvent_ReactionBatchDeletedEventData)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_chat_v1_space_event_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   4,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_chat_v1_space_event_proto_goTypes,
		DependencyIndexes: file_google_chat_v1_space_event_proto_depIdxs,
		MessageInfos:      file_google_chat_v1_space_event_proto_msgTypes,
	}.Build()
	File_google_chat_v1_space_event_proto = out.File
	file_google_chat_v1_space_event_proto_rawDesc = nil
	file_google_chat_v1_space_event_proto_goTypes = nil
	file_google_chat_v1_space_event_proto_depIdxs = nil
}
