// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/discoveryengine/v1beta/completion_service.proto

package discoveryenginepb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Suggestion type to return.
type AdvancedCompleteQueryRequest_SuggestionType int32

const (
	// Default value.
	AdvancedCompleteQueryRequest_SUGGESTION_TYPE_UNSPECIFIED AdvancedCompleteQueryRequest_SuggestionType = 0
	// Returns query suggestions.
	AdvancedCompleteQueryRequest_QUERY AdvancedCompleteQueryRequest_SuggestionType = 1
	// Returns people suggestions.
	AdvancedCompleteQueryRequest_PEOPLE AdvancedCompleteQueryRequest_SuggestionType = 2
	// Returns content suggestions.
	AdvancedCompleteQueryRequest_CONTENT AdvancedCompleteQueryRequest_SuggestionType = 3
	// Returns recent search suggestions.
	AdvancedCompleteQueryRequest_RECENT_SEARCH AdvancedCompleteQueryRequest_SuggestionType = 4
	// Returns Google Workspace suggestions.
	AdvancedCompleteQueryRequest_GOOGLE_WORKSPACE AdvancedCompleteQueryRequest_SuggestionType = 5
)

// Enum value maps for AdvancedCompleteQueryRequest_SuggestionType.
var (
	AdvancedCompleteQueryRequest_SuggestionType_name = map[int32]string{
		0: "SUGGESTION_TYPE_UNSPECIFIED",
		1: "QUERY",
		2: "PEOPLE",
		3: "CONTENT",
		4: "RECENT_SEARCH",
		5: "GOOGLE_WORKSPACE",
	}
	AdvancedCompleteQueryRequest_SuggestionType_value = map[string]int32{
		"SUGGESTION_TYPE_UNSPECIFIED": 0,
		"QUERY":                       1,
		"PEOPLE":                      2,
		"CONTENT":                     3,
		"RECENT_SEARCH":               4,
		"GOOGLE_WORKSPACE":            5,
	}
)

func (x AdvancedCompleteQueryRequest_SuggestionType) Enum() *AdvancedCompleteQueryRequest_SuggestionType {
	p := new(AdvancedCompleteQueryRequest_SuggestionType)
	*p = x
	return p
}

func (x AdvancedCompleteQueryRequest_SuggestionType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AdvancedCompleteQueryRequest_SuggestionType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_enumTypes[0].Descriptor()
}

func (AdvancedCompleteQueryRequest_SuggestionType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_completion_service_proto_enumTypes[0]
}

func (x AdvancedCompleteQueryRequest_SuggestionType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AdvancedCompleteQueryRequest_SuggestionType.Descriptor instead.
func (AdvancedCompleteQueryRequest_SuggestionType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{2, 0}
}

// The type of the person based on the source.
type AdvancedCompleteQueryResponse_PersonSuggestion_PersonType int32

const (
	// Default value.
	AdvancedCompleteQueryResponse_PersonSuggestion_PERSON_TYPE_UNSPECIFIED AdvancedCompleteQueryResponse_PersonSuggestion_PersonType = 0
	// The suggestion is from a GOOGLE_IDENTITY source.
	AdvancedCompleteQueryResponse_PersonSuggestion_CLOUD_IDENTITY AdvancedCompleteQueryResponse_PersonSuggestion_PersonType = 1
	// The suggestion is from a THIRD_PARTY_IDENTITY source.
	AdvancedCompleteQueryResponse_PersonSuggestion_THIRD_PARTY_IDENTITY AdvancedCompleteQueryResponse_PersonSuggestion_PersonType = 2
)

// Enum value maps for AdvancedCompleteQueryResponse_PersonSuggestion_PersonType.
var (
	AdvancedCompleteQueryResponse_PersonSuggestion_PersonType_name = map[int32]string{
		0: "PERSON_TYPE_UNSPECIFIED",
		1: "CLOUD_IDENTITY",
		2: "THIRD_PARTY_IDENTITY",
	}
	AdvancedCompleteQueryResponse_PersonSuggestion_PersonType_value = map[string]int32{
		"PERSON_TYPE_UNSPECIFIED": 0,
		"CLOUD_IDENTITY":          1,
		"THIRD_PARTY_IDENTITY":    2,
	}
)

func (x AdvancedCompleteQueryResponse_PersonSuggestion_PersonType) Enum() *AdvancedCompleteQueryResponse_PersonSuggestion_PersonType {
	p := new(AdvancedCompleteQueryResponse_PersonSuggestion_PersonType)
	*p = x
	return p
}

func (x AdvancedCompleteQueryResponse_PersonSuggestion_PersonType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AdvancedCompleteQueryResponse_PersonSuggestion_PersonType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_enumTypes[1].Descriptor()
}

func (AdvancedCompleteQueryResponse_PersonSuggestion_PersonType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_completion_service_proto_enumTypes[1]
}

func (x AdvancedCompleteQueryResponse_PersonSuggestion_PersonType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AdvancedCompleteQueryResponse_PersonSuggestion_PersonType.Descriptor instead.
func (AdvancedCompleteQueryResponse_PersonSuggestion_PersonType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{3, 1, 0}
}

// The type of the content returned for content suggestions.
type AdvancedCompleteQueryResponse_ContentSuggestion_ContentType int32

const (
	// Default value.
	AdvancedCompleteQueryResponse_ContentSuggestion_CONTENT_TYPE_UNSPECIFIED AdvancedCompleteQueryResponse_ContentSuggestion_ContentType = 0
	// The suggestion is from a Google Workspace source.
	AdvancedCompleteQueryResponse_ContentSuggestion_GOOGLE_WORKSPACE AdvancedCompleteQueryResponse_ContentSuggestion_ContentType = 1
	// The suggestion is from a third party source.
	AdvancedCompleteQueryResponse_ContentSuggestion_THIRD_PARTY AdvancedCompleteQueryResponse_ContentSuggestion_ContentType = 2
)

// Enum value maps for AdvancedCompleteQueryResponse_ContentSuggestion_ContentType.
var (
	AdvancedCompleteQueryResponse_ContentSuggestion_ContentType_name = map[int32]string{
		0: "CONTENT_TYPE_UNSPECIFIED",
		1: "GOOGLE_WORKSPACE",
		2: "THIRD_PARTY",
	}
	AdvancedCompleteQueryResponse_ContentSuggestion_ContentType_value = map[string]int32{
		"CONTENT_TYPE_UNSPECIFIED": 0,
		"GOOGLE_WORKSPACE":         1,
		"THIRD_PARTY":              2,
	}
)

func (x AdvancedCompleteQueryResponse_ContentSuggestion_ContentType) Enum() *AdvancedCompleteQueryResponse_ContentSuggestion_ContentType {
	p := new(AdvancedCompleteQueryResponse_ContentSuggestion_ContentType)
	*p = x
	return p
}

func (x AdvancedCompleteQueryResponse_ContentSuggestion_ContentType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AdvancedCompleteQueryResponse_ContentSuggestion_ContentType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_enumTypes[2].Descriptor()
}

func (AdvancedCompleteQueryResponse_ContentSuggestion_ContentType) Type() protoreflect.EnumType {
	return &file_google_cloud_discoveryengine_v1beta_completion_service_proto_enumTypes[2]
}

func (x AdvancedCompleteQueryResponse_ContentSuggestion_ContentType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AdvancedCompleteQueryResponse_ContentSuggestion_ContentType.Descriptor instead.
func (AdvancedCompleteQueryResponse_ContentSuggestion_ContentType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{3, 2, 0}
}

// Request message for
// [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.CompleteQuery]
// method.
type CompleteQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent data store resource name for which the completion is
	// performed, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/default_data_store`.
	DataStore string `protobuf:"bytes,1,opt,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
	// Required. The typeahead input used to fetch suggestions. Maximum length is
	// 128 characters.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Specifies the autocomplete data model. This overrides any model specified
	// in the Configuration > Autocomplete section of the Cloud console. Currently
	// supported values:
	//
	// * `document` - Using suggestions generated from user-imported documents.
	// * `search-history` - Using suggestions generated from the past history of
	// [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
	// API calls. Do not use it when there is no traffic for Search API.
	// * `user-event` - Using suggestions generated from user-imported search
	// events.
	// * `document-completable` - Using suggestions taken directly from
	// user-imported document fields marked as completable.
	//
	// Default values:
	//
	// * `document` is the default model for regular dataStores.
	// * `search-history` is the default model for site search dataStores.
	QueryModel string `protobuf:"bytes,3,opt,name=query_model,json=queryModel,proto3" json:"query_model,omitempty"`
	// A unique identifier for tracking visitors. For example, this could be
	// implemented with an HTTP cookie, which should be able to uniquely identify
	// a visitor on a single device. This unique identifier should not change if
	// the visitor logs in or out of the website.
	//
	// This field should NOT have a fixed value such as `unknown_visitor`.
	//
	// This should be the same identifier as
	// [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
	// and
	// [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	// characters. Otherwise, an `INVALID_ARGUMENT` error is returned.
	UserPseudoId string `protobuf:"bytes,4,opt,name=user_pseudo_id,json=userPseudoId,proto3" json:"user_pseudo_id,omitempty"`
	// Indicates if tail suggestions should be returned if there are no
	// suggestions that match the full query. Even if set to true, if there are
	// suggestions that match the full query, those are returned and no
	// tail suggestions are returned.
	IncludeTailSuggestions bool `protobuf:"varint,5,opt,name=include_tail_suggestions,json=includeTailSuggestions,proto3" json:"include_tail_suggestions,omitempty"`
}

func (x *CompleteQueryRequest) Reset() {
	*x = CompleteQueryRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompleteQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteQueryRequest) ProtoMessage() {}

func (x *CompleteQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteQueryRequest.ProtoReflect.Descriptor instead.
func (*CompleteQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{0}
}

func (x *CompleteQueryRequest) GetDataStore() string {
	if x != nil {
		return x.DataStore
	}
	return ""
}

func (x *CompleteQueryRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *CompleteQueryRequest) GetQueryModel() string {
	if x != nil {
		return x.QueryModel
	}
	return ""
}

func (x *CompleteQueryRequest) GetUserPseudoId() string {
	if x != nil {
		return x.UserPseudoId
	}
	return ""
}

func (x *CompleteQueryRequest) GetIncludeTailSuggestions() bool {
	if x != nil {
		return x.IncludeTailSuggestions
	}
	return false
}

// Response message for
// [CompletionService.CompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.CompleteQuery]
// method.
type CompleteQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results of the matched query suggestions. The result list is ordered and
	// the first result is a top suggestion.
	QuerySuggestions []*CompleteQueryResponse_QuerySuggestion `protobuf:"bytes,1,rep,name=query_suggestions,json=querySuggestions,proto3" json:"query_suggestions,omitempty"`
	// True if the returned suggestions are all tail suggestions.
	//
	// For tail matching to be triggered, include_tail_suggestions in the request
	// must be true and there must be no suggestions that match the full query.
	TailMatchTriggered bool `protobuf:"varint,2,opt,name=tail_match_triggered,json=tailMatchTriggered,proto3" json:"tail_match_triggered,omitempty"`
}

func (x *CompleteQueryResponse) Reset() {
	*x = CompleteQueryResponse{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompleteQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteQueryResponse) ProtoMessage() {}

func (x *CompleteQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteQueryResponse.ProtoReflect.Descriptor instead.
func (*CompleteQueryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{1}
}

func (x *CompleteQueryResponse) GetQuerySuggestions() []*CompleteQueryResponse_QuerySuggestion {
	if x != nil {
		return x.QuerySuggestions
	}
	return nil
}

func (x *CompleteQueryResponse) GetTailMatchTriggered() bool {
	if x != nil {
		return x.TailMatchTriggered
	}
	return false
}

// Request message for
// [CompletionService.AdvancedCompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.AdvancedCompleteQuery]
// method.
// .
type AdvancedCompleteQueryRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The completion_config of the parent dataStore or engine resource
	// name for which the completion is performed, such as
	// `projects/*/locations/global/collections/default_collection/dataStores/*/completionConfig`
	// `projects/*/locations/global/collections/default_collection/engines/*/completionConfig`.
	CompletionConfig string `protobuf:"bytes,1,opt,name=completion_config,json=completionConfig,proto3" json:"completion_config,omitempty"`
	// Required. The typeahead input used to fetch suggestions. Maximum length is
	// 128 characters.
	//
	// The query can not be empty for most of the suggestion types. If it is
	// empty, an `INVALID_ARGUMENT` error is returned. The exception is when the
	// suggestion_types contains only the type `RECENT_SEARCH`, the query can
	// be an empty string. The is called "zero prefix" feature, which returns
	// user's recently searched queries given the empty query.
	Query string `protobuf:"bytes,2,opt,name=query,proto3" json:"query,omitempty"`
	// Specifies the autocomplete data model. This overrides any model specified
	// in the Configuration > Autocomplete section of the Cloud console. Currently
	// supported values:
	//
	// * `document` - Using suggestions generated from user-imported documents.
	// * `search-history` - Using suggestions generated from the past history of
	// [SearchService.Search][google.cloud.discoveryengine.v1beta.SearchService.Search]
	// API calls. Do not use it when there is no traffic for Search API.
	// * `user-event` - Using suggestions generated from user-imported search
	// events.
	// * `document-completable` - Using suggestions taken directly from
	// user-imported document fields marked as completable.
	//
	// Default values:
	//
	// * `document` is the default model for regular dataStores.
	// * `search-history` is the default model for site search dataStores.
	QueryModel string `protobuf:"bytes,3,opt,name=query_model,json=queryModel,proto3" json:"query_model,omitempty"`
	// A unique identifier for tracking visitors. For example, this could be
	// implemented with an HTTP cookie, which should be able to uniquely identify
	// a visitor on a single device. This unique identifier should not change if
	// the visitor logs in or out of the website.
	//
	// This field should NOT have a fixed value such as `unknown_visitor`.
	//
	// This should be the same identifier as
	// [UserEvent.user_pseudo_id][google.cloud.discoveryengine.v1beta.UserEvent.user_pseudo_id]
	// and
	// [SearchRequest.user_pseudo_id][google.cloud.discoveryengine.v1beta.SearchRequest.user_pseudo_id].
	//
	// The field must be a UTF-8 encoded string with a length limit of 128
	UserPseudoId string `protobuf:"bytes,4,opt,name=user_pseudo_id,json=userPseudoId,proto3" json:"user_pseudo_id,omitempty"`
	// Optional. Information about the end user.
	//
	// This should be the same identifier information as
	// [UserEvent.user_info][google.cloud.discoveryengine.v1beta.UserEvent.user_info]
	// and
	// [SearchRequest.user_info][google.cloud.discoveryengine.v1beta.SearchRequest.user_info].
	UserInfo *UserInfo `protobuf:"bytes,9,opt,name=user_info,json=userInfo,proto3" json:"user_info,omitempty"`
	// Indicates if tail suggestions should be returned if there are no
	// suggestions that match the full query. Even if set to true, if there are
	// suggestions that match the full query, those are returned and no
	// tail suggestions are returned.
	IncludeTailSuggestions bool `protobuf:"varint,5,opt,name=include_tail_suggestions,json=includeTailSuggestions,proto3" json:"include_tail_suggestions,omitempty"`
	// Optional. Specification to boost suggestions matching the condition.
	BoostSpec *AdvancedCompleteQueryRequest_BoostSpec `protobuf:"bytes,6,opt,name=boost_spec,json=boostSpec,proto3" json:"boost_spec,omitempty"`
	// Optional. Suggestion types to return. If empty or unspecified, query
	// suggestions are returned. Only one suggestion type is supported at the
	// moment.
	SuggestionTypes []AdvancedCompleteQueryRequest_SuggestionType `protobuf:"varint,7,rep,packed,name=suggestion_types,json=suggestionTypes,proto3,enum=google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest_SuggestionType" json:"suggestion_types,omitempty"`
}

func (x *AdvancedCompleteQueryRequest) Reset() {
	*x = AdvancedCompleteQueryRequest{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedCompleteQueryRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedCompleteQueryRequest) ProtoMessage() {}

func (x *AdvancedCompleteQueryRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedCompleteQueryRequest.ProtoReflect.Descriptor instead.
func (*AdvancedCompleteQueryRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{2}
}

func (x *AdvancedCompleteQueryRequest) GetCompletionConfig() string {
	if x != nil {
		return x.CompletionConfig
	}
	return ""
}

func (x *AdvancedCompleteQueryRequest) GetQuery() string {
	if x != nil {
		return x.Query
	}
	return ""
}

func (x *AdvancedCompleteQueryRequest) GetQueryModel() string {
	if x != nil {
		return x.QueryModel
	}
	return ""
}

func (x *AdvancedCompleteQueryRequest) GetUserPseudoId() string {
	if x != nil {
		return x.UserPseudoId
	}
	return ""
}

func (x *AdvancedCompleteQueryRequest) GetUserInfo() *UserInfo {
	if x != nil {
		return x.UserInfo
	}
	return nil
}

func (x *AdvancedCompleteQueryRequest) GetIncludeTailSuggestions() bool {
	if x != nil {
		return x.IncludeTailSuggestions
	}
	return false
}

func (x *AdvancedCompleteQueryRequest) GetBoostSpec() *AdvancedCompleteQueryRequest_BoostSpec {
	if x != nil {
		return x.BoostSpec
	}
	return nil
}

func (x *AdvancedCompleteQueryRequest) GetSuggestionTypes() []AdvancedCompleteQueryRequest_SuggestionType {
	if x != nil {
		return x.SuggestionTypes
	}
	return nil
}

// Response message for
// [CompletionService.AdvancedCompleteQuery][google.cloud.discoveryengine.v1beta.CompletionService.AdvancedCompleteQuery]
// method.
type AdvancedCompleteQueryResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Results of the matched query suggestions. The result list is ordered and
	// the first result is a top suggestion.
	QuerySuggestions []*AdvancedCompleteQueryResponse_QuerySuggestion `protobuf:"bytes,1,rep,name=query_suggestions,json=querySuggestions,proto3" json:"query_suggestions,omitempty"`
	// True if the returned suggestions are all tail suggestions.
	//
	// For tail matching to be triggered, include_tail_suggestions in the request
	// must be true and there must be no suggestions that match the full query.
	TailMatchTriggered bool `protobuf:"varint,2,opt,name=tail_match_triggered,json=tailMatchTriggered,proto3" json:"tail_match_triggered,omitempty"`
	// Results of the matched people suggestions. The result list is ordered and
	// the first result is the top suggestion.
	PeopleSuggestions []*AdvancedCompleteQueryResponse_PersonSuggestion `protobuf:"bytes,3,rep,name=people_suggestions,json=peopleSuggestions,proto3" json:"people_suggestions,omitempty"`
	// Results of the matched content suggestions. The result list is ordered and
	// the first result is the top suggestion.
	ContentSuggestions []*AdvancedCompleteQueryResponse_ContentSuggestion `protobuf:"bytes,4,rep,name=content_suggestions,json=contentSuggestions,proto3" json:"content_suggestions,omitempty"`
	// Results of the matched "recent search" suggestions. The result list is
	// ordered and the first result is the top suggestion.
	RecentSearchSuggestions []*AdvancedCompleteQueryResponse_RecentSearchSuggestion `protobuf:"bytes,5,rep,name=recent_search_suggestions,json=recentSearchSuggestions,proto3" json:"recent_search_suggestions,omitempty"`
}

func (x *AdvancedCompleteQueryResponse) Reset() {
	*x = AdvancedCompleteQueryResponse{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedCompleteQueryResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedCompleteQueryResponse) ProtoMessage() {}

func (x *AdvancedCompleteQueryResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedCompleteQueryResponse.ProtoReflect.Descriptor instead.
func (*AdvancedCompleteQueryResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{3}
}

func (x *AdvancedCompleteQueryResponse) GetQuerySuggestions() []*AdvancedCompleteQueryResponse_QuerySuggestion {
	if x != nil {
		return x.QuerySuggestions
	}
	return nil
}

func (x *AdvancedCompleteQueryResponse) GetTailMatchTriggered() bool {
	if x != nil {
		return x.TailMatchTriggered
	}
	return false
}

func (x *AdvancedCompleteQueryResponse) GetPeopleSuggestions() []*AdvancedCompleteQueryResponse_PersonSuggestion {
	if x != nil {
		return x.PeopleSuggestions
	}
	return nil
}

func (x *AdvancedCompleteQueryResponse) GetContentSuggestions() []*AdvancedCompleteQueryResponse_ContentSuggestion {
	if x != nil {
		return x.ContentSuggestions
	}
	return nil
}

func (x *AdvancedCompleteQueryResponse) GetRecentSearchSuggestions() []*AdvancedCompleteQueryResponse_RecentSearchSuggestion {
	if x != nil {
		return x.RecentSearchSuggestions
	}
	return nil
}

// Suggestions as search queries.
type CompleteQueryResponse_QuerySuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The suggestion for the query.
	Suggestion string `protobuf:"bytes,1,opt,name=suggestion,proto3" json:"suggestion,omitempty"`
	// The unique document field paths that serve as the source of this
	// suggestion if it was generated from completable fields.
	//
	// This field is only populated for the document-completable model.
	CompletableFieldPaths []string `protobuf:"bytes,2,rep,name=completable_field_paths,json=completableFieldPaths,proto3" json:"completable_field_paths,omitempty"`
}

func (x *CompleteQueryResponse_QuerySuggestion) Reset() {
	*x = CompleteQueryResponse_QuerySuggestion{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CompleteQueryResponse_QuerySuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CompleteQueryResponse_QuerySuggestion) ProtoMessage() {}

func (x *CompleteQueryResponse_QuerySuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CompleteQueryResponse_QuerySuggestion.ProtoReflect.Descriptor instead.
func (*CompleteQueryResponse_QuerySuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{1, 0}
}

func (x *CompleteQueryResponse_QuerySuggestion) GetSuggestion() string {
	if x != nil {
		return x.Suggestion
	}
	return ""
}

func (x *CompleteQueryResponse_QuerySuggestion) GetCompletableFieldPaths() []string {
	if x != nil {
		return x.CompletableFieldPaths
	}
	return nil
}

// Specification to boost suggestions based on the condtion of the suggestion.
type AdvancedCompleteQueryRequest_BoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Condition boost specifications. If a suggestion matches multiple
	// conditions in the specifictions, boost values from these specifications
	// are all applied and combined in a non-linear way. Maximum number of
	// specifications is 20.
	//
	// Note: Currently only support language condition boost.
	ConditionBoostSpecs []*AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec `protobuf:"bytes,1,rep,name=condition_boost_specs,json=conditionBoostSpecs,proto3" json:"condition_boost_specs,omitempty"`
}

func (x *AdvancedCompleteQueryRequest_BoostSpec) Reset() {
	*x = AdvancedCompleteQueryRequest_BoostSpec{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedCompleteQueryRequest_BoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedCompleteQueryRequest_BoostSpec) ProtoMessage() {}

func (x *AdvancedCompleteQueryRequest_BoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedCompleteQueryRequest_BoostSpec.ProtoReflect.Descriptor instead.
func (*AdvancedCompleteQueryRequest_BoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{2, 0}
}

func (x *AdvancedCompleteQueryRequest_BoostSpec) GetConditionBoostSpecs() []*AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec {
	if x != nil {
		return x.ConditionBoostSpecs
	}
	return nil
}

// Boost applies to suggestions which match a condition.
type AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// An expression which specifies a boost condition. The syntax is the same
	// as [filter expression
	// syntax](https://cloud.google.com/generative-ai-app-builder/docs/filter-search-metadata#filter-expression-syntax).
	// Currently, the only supported condition is a list of BCP-47 lang codes.
	//
	// Example:
	//
	// * To boost suggestions in languages `en` or `fr`:
	// `(lang_code: ANY("en", "fr"))`
	Condition string `protobuf:"bytes,1,opt,name=condition,proto3" json:"condition,omitempty"`
	// Strength of the boost, which should be in [-1, 1].
	// Negative boost means demotion. Default is 0.0.
	//
	// Setting to 1.0 gives the suggestions a big promotion. However, it does
	// not necessarily mean that the top result will be a boosted suggestion.
	//
	// Setting to -1.0 gives the suggestions a big demotion. However, other
	// suggestions that are relevant might still be shown.
	//
	// Setting to 0.0 means no boost applied. The boosting condition is
	// ignored.
	Boost float32 `protobuf:"fixed32,2,opt,name=boost,proto3" json:"boost,omitempty"`
}

func (x *AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec) Reset() {
	*x = AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec) ProtoMessage() {}

func (x *AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec.ProtoReflect.Descriptor instead.
func (*AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{2, 0, 0}
}

func (x *AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec) GetCondition() string {
	if x != nil {
		return x.Condition
	}
	return ""
}

func (x *AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec) GetBoost() float32 {
	if x != nil {
		return x.Boost
	}
	return 0
}

// Suggestions as search queries.
type AdvancedCompleteQueryResponse_QuerySuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The suggestion for the query.
	Suggestion string `protobuf:"bytes,1,opt,name=suggestion,proto3" json:"suggestion,omitempty"`
	// The unique document field paths that serve as the source of this
	// suggestion if it was generated from completable fields.
	//
	// This field is only populated for the document-completable model.
	CompletableFieldPaths []string `protobuf:"bytes,2,rep,name=completable_field_paths,json=completableFieldPaths,proto3" json:"completable_field_paths,omitempty"`
	// The name of the dataStore that this suggestion belongs to.
	DataStore []string `protobuf:"bytes,3,rep,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
}

func (x *AdvancedCompleteQueryResponse_QuerySuggestion) Reset() {
	*x = AdvancedCompleteQueryResponse_QuerySuggestion{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedCompleteQueryResponse_QuerySuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedCompleteQueryResponse_QuerySuggestion) ProtoMessage() {}

func (x *AdvancedCompleteQueryResponse_QuerySuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedCompleteQueryResponse_QuerySuggestion.ProtoReflect.Descriptor instead.
func (*AdvancedCompleteQueryResponse_QuerySuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{3, 0}
}

func (x *AdvancedCompleteQueryResponse_QuerySuggestion) GetSuggestion() string {
	if x != nil {
		return x.Suggestion
	}
	return ""
}

func (x *AdvancedCompleteQueryResponse_QuerySuggestion) GetCompletableFieldPaths() []string {
	if x != nil {
		return x.CompletableFieldPaths
	}
	return nil
}

func (x *AdvancedCompleteQueryResponse_QuerySuggestion) GetDataStore() []string {
	if x != nil {
		return x.DataStore
	}
	return nil
}

// Suggestions as people.
type AdvancedCompleteQueryResponse_PersonSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The suggestion for the query.
	Suggestion string `protobuf:"bytes,1,opt,name=suggestion,proto3" json:"suggestion,omitempty"`
	// The type of the person.
	PersonType AdvancedCompleteQueryResponse_PersonSuggestion_PersonType `protobuf:"varint,2,opt,name=person_type,json=personType,proto3,enum=google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse_PersonSuggestion_PersonType" json:"person_type,omitempty"`
	// The document data snippet in the suggestion. Only a subset of fields is
	// populated.
	Document *Document `protobuf:"bytes,4,opt,name=document,proto3" json:"document,omitempty"`
	// The name of the dataStore that this suggestion belongs to.
	DataStore string `protobuf:"bytes,5,opt,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
}

func (x *AdvancedCompleteQueryResponse_PersonSuggestion) Reset() {
	*x = AdvancedCompleteQueryResponse_PersonSuggestion{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedCompleteQueryResponse_PersonSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedCompleteQueryResponse_PersonSuggestion) ProtoMessage() {}

func (x *AdvancedCompleteQueryResponse_PersonSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedCompleteQueryResponse_PersonSuggestion.ProtoReflect.Descriptor instead.
func (*AdvancedCompleteQueryResponse_PersonSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{3, 1}
}

func (x *AdvancedCompleteQueryResponse_PersonSuggestion) GetSuggestion() string {
	if x != nil {
		return x.Suggestion
	}
	return ""
}

func (x *AdvancedCompleteQueryResponse_PersonSuggestion) GetPersonType() AdvancedCompleteQueryResponse_PersonSuggestion_PersonType {
	if x != nil {
		return x.PersonType
	}
	return AdvancedCompleteQueryResponse_PersonSuggestion_PERSON_TYPE_UNSPECIFIED
}

func (x *AdvancedCompleteQueryResponse_PersonSuggestion) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AdvancedCompleteQueryResponse_PersonSuggestion) GetDataStore() string {
	if x != nil {
		return x.DataStore
	}
	return ""
}

// Suggestions as content.
type AdvancedCompleteQueryResponse_ContentSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The suggestion for the query.
	Suggestion string `protobuf:"bytes,1,opt,name=suggestion,proto3" json:"suggestion,omitempty"`
	// The type of the content suggestion.
	ContentType AdvancedCompleteQueryResponse_ContentSuggestion_ContentType `protobuf:"varint,2,opt,name=content_type,json=contentType,proto3,enum=google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse_ContentSuggestion_ContentType" json:"content_type,omitempty"`
	// The document data snippet in the suggestion. Only a subset of fields will
	// be populated.
	Document *Document `protobuf:"bytes,4,opt,name=document,proto3" json:"document,omitempty"`
	// The name of the dataStore that this suggestion belongs to.
	DataStore string `protobuf:"bytes,5,opt,name=data_store,json=dataStore,proto3" json:"data_store,omitempty"`
}

func (x *AdvancedCompleteQueryResponse_ContentSuggestion) Reset() {
	*x = AdvancedCompleteQueryResponse_ContentSuggestion{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedCompleteQueryResponse_ContentSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedCompleteQueryResponse_ContentSuggestion) ProtoMessage() {}

func (x *AdvancedCompleteQueryResponse_ContentSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedCompleteQueryResponse_ContentSuggestion.ProtoReflect.Descriptor instead.
func (*AdvancedCompleteQueryResponse_ContentSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{3, 2}
}

func (x *AdvancedCompleteQueryResponse_ContentSuggestion) GetSuggestion() string {
	if x != nil {
		return x.Suggestion
	}
	return ""
}

func (x *AdvancedCompleteQueryResponse_ContentSuggestion) GetContentType() AdvancedCompleteQueryResponse_ContentSuggestion_ContentType {
	if x != nil {
		return x.ContentType
	}
	return AdvancedCompleteQueryResponse_ContentSuggestion_CONTENT_TYPE_UNSPECIFIED
}

func (x *AdvancedCompleteQueryResponse_ContentSuggestion) GetDocument() *Document {
	if x != nil {
		return x.Document
	}
	return nil
}

func (x *AdvancedCompleteQueryResponse_ContentSuggestion) GetDataStore() string {
	if x != nil {
		return x.DataStore
	}
	return ""
}

// Suggestions from recent search history.
type AdvancedCompleteQueryResponse_RecentSearchSuggestion struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The suggestion for the query.
	Suggestion string `protobuf:"bytes,1,opt,name=suggestion,proto3" json:"suggestion,omitempty"`
	// The time when this recent rearch happened.
	RecentSearchTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=recent_search_time,json=recentSearchTime,proto3" json:"recent_search_time,omitempty"`
}

func (x *AdvancedCompleteQueryResponse_RecentSearchSuggestion) Reset() {
	*x = AdvancedCompleteQueryResponse_RecentSearchSuggestion{}
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AdvancedCompleteQueryResponse_RecentSearchSuggestion) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AdvancedCompleteQueryResponse_RecentSearchSuggestion) ProtoMessage() {}

func (x *AdvancedCompleteQueryResponse_RecentSearchSuggestion) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AdvancedCompleteQueryResponse_RecentSearchSuggestion.ProtoReflect.Descriptor instead.
func (*AdvancedCompleteQueryResponse_RecentSearchSuggestion) Descriptor() ([]byte, []int) {
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP(), []int{3, 3}
}

func (x *AdvancedCompleteQueryResponse_RecentSearchSuggestion) GetSuggestion() string {
	if x != nil {
		return x.Suggestion
	}
	return ""
}

func (x *AdvancedCompleteQueryResponse_RecentSearchSuggestion) GetRecentSearchTime() *timestamppb.Timestamp {
	if x != nil {
		return x.RecentSearchTime
	}
	return nil
}

var File_google_cloud_discoveryengine_v1beta_completion_service_proto protoreflect.FileDescriptor

var file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDesc = []byte{
	0x0a, 0x3c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x23,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c,
	0x69, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68,
	0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x30, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x63, 0x6f, 0x6d, 0x6d,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x64, 0x6f,
	0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x70, 0x75, 0x72, 0x67, 0x65,
	0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e,
	0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x22, 0x83, 0x02, 0x0a, 0x14, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4f, 0x0a, 0x0a,
	0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x30, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76,
	0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x12, 0x19, 0x0a,
	0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x24, 0x0a, 0x0e, 0x75, 0x73, 0x65,
	0x72, 0x5f, 0x70, 0x73, 0x65, 0x75, 0x64, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x50, 0x73, 0x65, 0x75, 0x64, 0x6f, 0x49, 0x64, 0x12,
	0x38, 0x0a, 0x18, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74, 0x61, 0x69, 0x6c, 0x5f,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28,
	0x08, 0x52, 0x16, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x54, 0x61, 0x69, 0x6c, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x22, 0xad, 0x02, 0x0a, 0x15, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x12, 0x77, 0x0a, 0x11, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x10, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x30, 0x0a, 0x14,
	0x74, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52, 0x12, 0x74, 0x61, 0x69, 0x6c,
	0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x65, 0x64, 0x1a, 0x69,
	0x0a, 0x0f, 0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x36, 0x0a, 0x17, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65,
	0x5f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03,
	0x28, 0x09, 0x52, 0x15, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x46,
	0x69, 0x65, 0x6c, 0x64, 0x50, 0x61, 0x74, 0x68, 0x73, 0x22, 0xd2, 0x07, 0x0a, 0x1c, 0x41, 0x64,
	0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x64, 0x0a, 0x11, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x37, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x31, 0x0a, 0x2f, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x10,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x12, 0x19, 0x0a, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x71, 0x75, 0x65, 0x72, 0x79, 0x12, 0x1f, 0x0a, 0x0b, 0x71,
	0x75, 0x65, 0x72, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x65, 0x6c, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x71, 0x75, 0x65, 0x72, 0x79, 0x4d, 0x6f, 0x64, 0x65, 0x6c, 0x12, 0x24, 0x0a, 0x0e,
	0x75, 0x73, 0x65, 0x72, 0x5f, 0x70, 0x73, 0x65, 0x75, 0x64, 0x6f, 0x5f, 0x69, 0x64, 0x18, 0x04,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x75, 0x73, 0x65, 0x72, 0x50, 0x73, 0x65, 0x75, 0x64, 0x6f,
	0x49, 0x64, 0x12, 0x4f, 0x0a, 0x09, 0x75, 0x73, 0x65, 0x72, 0x5f, 0x69, 0x6e, 0x66, 0x6f, 0x18,
	0x09, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x55, 0x73, 0x65, 0x72,
	0x49, 0x6e, 0x66, 0x6f, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x75, 0x73, 0x65, 0x72, 0x49,
	0x6e, 0x66, 0x6f, 0x12, 0x38, 0x0a, 0x18, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x5f, 0x74,
	0x61, 0x69, 0x6c, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18,
	0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x16, 0x69, 0x6e, 0x63, 0x6c, 0x75, 0x64, 0x65, 0x54, 0x61,
	0x69, 0x6c, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x6f, 0x0a,
	0x0a, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x80,
	0x01, 0x0a, 0x10, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x0e, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x0f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x73, 0x1a, 0xea, 0x01, 0x0a, 0x09, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12,
	0x92, 0x01, 0x0a, 0x15, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x62, 0x6f,
	0x6f, 0x73, 0x74, 0x5f, 0x73, 0x70, 0x65, 0x63, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x2e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x2e, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x52,
	0x13, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53,
	0x70, 0x65, 0x63, 0x73, 0x1a, 0x48, 0x0a, 0x12, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x42, 0x6f, 0x6f, 0x73, 0x74, 0x53, 0x70, 0x65, 0x63, 0x12, 0x1c, 0x0a, 0x09, 0x63, 0x6f,
	0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x14, 0x0a, 0x05, 0x62, 0x6f, 0x6f, 0x73,
	0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x52, 0x05, 0x62, 0x6f, 0x6f, 0x73, 0x74, 0x22, 0x7e,
	0x0a, 0x0e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1f, 0x0a, 0x1b, 0x53, 0x55, 0x47, 0x47, 0x45, 0x53, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x09, 0x0a, 0x05, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06,
	0x50, 0x45, 0x4f, 0x50, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0b, 0x0a, 0x07, 0x43, 0x4f, 0x4e, 0x54,
	0x45, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x11, 0x0a, 0x0d, 0x52, 0x45, 0x43, 0x45, 0x4e, 0x54, 0x5f,
	0x53, 0x45, 0x41, 0x52, 0x43, 0x48, 0x10, 0x04, 0x12, 0x14, 0x0a, 0x10, 0x47, 0x4f, 0x4f, 0x47,
	0x4c, 0x45, 0x5f, 0x57, 0x4f, 0x52, 0x4b, 0x53, 0x50, 0x41, 0x43, 0x45, 0x10, 0x05, 0x22, 0xd8,
	0x0d, 0x0a, 0x1d, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x7f, 0x0a, 0x11, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x10, 0x71, 0x75, 0x65, 0x72, 0x79, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x12, 0x30, 0x0a, 0x14, 0x74, 0x61, 0x69, 0x6c, 0x5f, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x5f,
	0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x65, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x12, 0x74, 0x61, 0x69, 0x6c, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65,
	0x72, 0x65, 0x64, 0x12, 0x82, 0x01, 0x0a, 0x12, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x5f, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x53, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x11, 0x70, 0x65, 0x6f, 0x70, 0x6c, 0x65, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x85, 0x01, 0x0a, 0x13, 0x63, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x54, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x76,
	0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65,
	0x6e, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x12, 0x63, 0x6f,
	0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x12, 0x95, 0x01, 0x0a, 0x19, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x5f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x05,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x59, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e,
	0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x52, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x52,
	0x17, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x1a, 0x88, 0x01, 0x0a, 0x0f, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a,
	0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x36, 0x0a, 0x17,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x5f, 0x66, 0x69, 0x65, 0x6c,
	0x64, 0x5f, 0x70, 0x61, 0x74, 0x68, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x15, 0x63,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x61, 0x62, 0x6c, 0x65, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x50,
	0x61, 0x74, 0x68, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74,
	0x6f, 0x72, 0x65, 0x1a, 0xa5, 0x03, 0x0a, 0x10, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x7f, 0x0a, 0x0b, 0x70, 0x65, 0x72, 0x73,
	0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x5e, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0a, 0x70,
	0x65, 0x72, 0x73, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x64, 0x6f, 0x63,
	0x75, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f,
	0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2e, 0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f,
	0x72, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61,
	0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x22, 0x57, 0x0a, 0x0a, 0x50, 0x65, 0x72, 0x73, 0x6f, 0x6e, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x1b, 0x0a, 0x17, 0x50, 0x45, 0x52, 0x53, 0x4f, 0x4e, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x12, 0x0a,
	0x0e, 0x43, 0x4c, 0x4f, 0x55, 0x44, 0x5f, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x10,
	0x01, 0x12, 0x18, 0x0a, 0x14, 0x54, 0x48, 0x49, 0x52, 0x44, 0x5f, 0x50, 0x41, 0x52, 0x54, 0x59,
	0x5f, 0x49, 0x44, 0x45, 0x4e, 0x54, 0x49, 0x54, 0x59, 0x10, 0x02, 0x1a, 0xa6, 0x03, 0x0a, 0x11,
	0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x83, 0x01, 0x0a, 0x0c, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x5f, 0x74, 0x79,
	0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x60, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41,
	0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51,
	0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x43, 0x6f, 0x6e,
	0x74, 0x65, 0x6e, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x43,
	0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x63, 0x6f, 0x6e, 0x74,
	0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x49, 0x0a, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x44, 0x6f, 0x63, 0x75, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x08, 0x64, 0x6f, 0x63, 0x75, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x4c, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d, 0xfa, 0x41, 0x2a, 0x0a, 0x28, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x44, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x22, 0x52, 0x0a, 0x0b, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x54, 0x79, 0x70, 0x65, 0x12,
	0x1c, 0x0a, 0x18, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a,
	0x10, 0x47, 0x4f, 0x4f, 0x47, 0x4c, 0x45, 0x5f, 0x57, 0x4f, 0x52, 0x4b, 0x53, 0x50, 0x41, 0x43,
	0x45, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x54, 0x48, 0x49, 0x52, 0x44, 0x5f, 0x50, 0x41, 0x52,
	0x54, 0x59, 0x10, 0x02, 0x1a, 0x82, 0x01, 0x0a, 0x16, 0x52, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x1e, 0x0a, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x48, 0x0a, 0x12, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x52, 0x10, 0x72, 0x65, 0x63, 0x65, 0x6e, 0x74, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x54, 0x69, 0x6d, 0x65, 0x32, 0xc0, 0x16, 0x0a, 0x11, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0xb0, 0x02, 0x0a, 0x0d, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72,
	0x79, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65,
	0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xa7, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xa0, 0x01, 0x5a, 0x56, 0x12, 0x54, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x64,
	0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x46, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x64, 0x61, 0x74, 0x61, 0x5f, 0x73, 0x74, 0x6f, 0x72, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65,
	0x72, 0x79, 0x12, 0xee, 0x03, 0x0a, 0x15, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43,
	0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63,
	0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f, 0x6d, 0x70, 0x6c,
	0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x41, 0x64, 0x76, 0x61, 0x6e, 0x63, 0x65, 0x64, 0x43, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75, 0x65, 0x72, 0x79, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xcd, 0x02, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc6, 0x02, 0x3a, 0x01, 0x2a,
	0x5a, 0x71, 0x3a, 0x01, 0x2a, 0x22, 0x6c, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b,
	0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x5a, 0x6e, 0x3a, 0x01, 0x2a, 0x22, 0x69, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c,
	0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x22, 0x5e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65,
	0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x7d, 0x3a, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x65, 0x51, 0x75,
	0x65, 0x72, 0x79, 0x12, 0xf9, 0x03, 0x0a, 0x1f, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x12, 0x4b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d,
	0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65,
	0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x22, 0xe9, 0x02, 0xca, 0x41, 0x9a, 0x01, 0x0a, 0x4b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e,
	0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x4b, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc4, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x5a,
	0x3a, 0x01, 0x2a, 0x22, 0x55, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61,
	0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73,
	0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72,
	0x69, 0x65, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x63, 0x2f, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12,
	0xf4, 0x03, 0x0a, 0x1e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74,
	0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69,
	0x65, 0x73, 0x12, 0x4a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74,
	0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e,
	0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe6, 0x02,
	0xca, 0x41, 0x98, 0x01, 0x0a, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69,
	0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73,
	0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x4a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64,
	0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74,
	0x72, 0x69, 0x65, 0x73, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0xc3, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x5a, 0x3a, 0x01, 0x2a, 0x22, 0x55, 0x2f, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a,
	0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x65, 0x6e,
	0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73, 0x3a, 0x70, 0x75, 0x72,
	0x67, 0x65, 0x22, 0x62, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65,
	0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f,
	0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x73, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x44, 0x65, 0x6e, 0x79, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x72, 0x69, 0x65, 0x73,
	0x3a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x12, 0xe1, 0x03, 0x0a, 0x1b, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67,
	0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xd9,
	0x02, 0xca, 0x41, 0x92, 0x01, 0x0a, 0x47, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72,
	0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65,
	0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x47,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xbc, 0x01, 0x3a, 0x01,
	0x2a, 0x5a, 0x56, 0x3a, 0x01, 0x2a, 0x22, 0x51, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x22, 0x5f, 0x2f, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f,
	0x64, 0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f,
	0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x12, 0xdb, 0x03, 0x0a, 0x1a, 0x50,
	0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75,
	0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65,
	0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e,
	0x50, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53,
	0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72,
	0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x22, 0xd5, 0x02, 0xca, 0x41, 0x90, 0x01, 0x0a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65,
	0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x75, 0x72,
	0x67, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67,
	0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x64, 0x69,
	0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x2e, 0x50, 0x75, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xba, 0x01, 0x3a, 0x01,
	0x2a, 0x5a, 0x55, 0x3a, 0x01, 0x2a, 0x22, 0x50, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x22, 0x5e, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x63, 0x6f, 0x6c, 0x6c, 0x65, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x64,
	0x61, 0x74, 0x61, 0x53, 0x74, 0x6f, 0x72, 0x65, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x63, 0x6f, 0x6d,
	0x70, 0x6c, 0x65, 0x74, 0x69, 0x6f, 0x6e, 0x53, 0x75, 0x67, 0x67, 0x65, 0x73, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x3a, 0x70, 0x75, 0x72, 0x67, 0x65, 0x1a, 0x52, 0xca, 0x41, 0x1e, 0x64, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74,
	0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61, 0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x42, 0x9d, 0x02, 0x0a,
	0x27, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x42, 0x16, 0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x65,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f,
	0x50, 0x01, 0x5a, 0x51, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72,
	0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x2f, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67, 0x69, 0x6e,
	0x65, 0x70, 0x62, 0x3b, 0x64, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x65, 0x6e, 0x67,
	0x69, 0x6e, 0x65, 0x70, 0x62, 0xa2, 0x02, 0x0f, 0x44, 0x49, 0x53, 0x43, 0x4f, 0x56, 0x45, 0x52,
	0x59, 0x45, 0x4e, 0x47, 0x49, 0x4e, 0x45, 0xaa, 0x02, 0x23, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79,
	0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0xca, 0x02, 0x23,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x44, 0x69, 0x73,
	0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e, 0x67, 0x69, 0x6e, 0x65, 0x5c, 0x56, 0x31, 0x62,
	0x65, 0x74, 0x61, 0xea, 0x02, 0x26, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x44, 0x69, 0x73, 0x63, 0x6f, 0x76, 0x65, 0x72, 0x79, 0x45, 0x6e,
	0x67, 0x69, 0x6e, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x62, 0x06, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescOnce sync.Once
	file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescData = file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDesc
)

func file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescGZIP() []byte {
	file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescOnce.Do(func() {
		file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescData)
	})
	return file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDescData
}

var file_google_cloud_discoveryengine_v1beta_completion_service_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_discoveryengine_v1beta_completion_service_proto_goTypes = []any{
	(AdvancedCompleteQueryRequest_SuggestionType)(0),                  // 0: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType
	(AdvancedCompleteQueryResponse_PersonSuggestion_PersonType)(0),    // 1: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType
	(AdvancedCompleteQueryResponse_ContentSuggestion_ContentType)(0),  // 2: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType
	(*CompleteQueryRequest)(nil),                                      // 3: google.cloud.discoveryengine.v1beta.CompleteQueryRequest
	(*CompleteQueryResponse)(nil),                                     // 4: google.cloud.discoveryengine.v1beta.CompleteQueryResponse
	(*AdvancedCompleteQueryRequest)(nil),                              // 5: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
	(*AdvancedCompleteQueryResponse)(nil),                             // 6: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
	(*CompleteQueryResponse_QuerySuggestion)(nil),                     // 7: google.cloud.discoveryengine.v1beta.CompleteQueryResponse.QuerySuggestion
	(*AdvancedCompleteQueryRequest_BoostSpec)(nil),                    // 8: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
	(*AdvancedCompleteQueryRequest_BoostSpec_ConditionBoostSpec)(nil), // 9: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec
	(*AdvancedCompleteQueryResponse_QuerySuggestion)(nil),             // 10: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
	(*AdvancedCompleteQueryResponse_PersonSuggestion)(nil),            // 11: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
	(*AdvancedCompleteQueryResponse_ContentSuggestion)(nil),           // 12: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
	(*AdvancedCompleteQueryResponse_RecentSearchSuggestion)(nil),      // 13: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
	(*UserInfo)(nil),                               // 14: google.cloud.discoveryengine.v1beta.UserInfo
	(*Document)(nil),                               // 15: google.cloud.discoveryengine.v1beta.Document
	(*timestamppb.Timestamp)(nil),                  // 16: google.protobuf.Timestamp
	(*ImportSuggestionDenyListEntriesRequest)(nil), // 17: google.cloud.discoveryengine.v1beta.ImportSuggestionDenyListEntriesRequest
	(*PurgeSuggestionDenyListEntriesRequest)(nil),  // 18: google.cloud.discoveryengine.v1beta.PurgeSuggestionDenyListEntriesRequest
	(*ImportCompletionSuggestionsRequest)(nil),     // 19: google.cloud.discoveryengine.v1beta.ImportCompletionSuggestionsRequest
	(*PurgeCompletionSuggestionsRequest)(nil),      // 20: google.cloud.discoveryengine.v1beta.PurgeCompletionSuggestionsRequest
	(*longrunningpb.Operation)(nil),                // 21: google.longrunning.Operation
}
var file_google_cloud_discoveryengine_v1beta_completion_service_proto_depIdxs = []int32{
	7,  // 0: google.cloud.discoveryengine.v1beta.CompleteQueryResponse.query_suggestions:type_name -> google.cloud.discoveryengine.v1beta.CompleteQueryResponse.QuerySuggestion
	14, // 1: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.user_info:type_name -> google.cloud.discoveryengine.v1beta.UserInfo
	8,  // 2: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.boost_spec:type_name -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec
	0,  // 3: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.suggestion_types:type_name -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.SuggestionType
	10, // 4: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.query_suggestions:type_name -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.QuerySuggestion
	11, // 5: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.people_suggestions:type_name -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion
	12, // 6: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.content_suggestions:type_name -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion
	13, // 7: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.recent_search_suggestions:type_name -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion
	9,  // 8: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.condition_boost_specs:type_name -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest.BoostSpec.ConditionBoostSpec
	1,  // 9: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.person_type:type_name -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.PersonType
	15, // 10: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.PersonSuggestion.document:type_name -> google.cloud.discoveryengine.v1beta.Document
	2,  // 11: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.content_type:type_name -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.ContentType
	15, // 12: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.ContentSuggestion.document:type_name -> google.cloud.discoveryengine.v1beta.Document
	16, // 13: google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse.RecentSearchSuggestion.recent_search_time:type_name -> google.protobuf.Timestamp
	3,  // 14: google.cloud.discoveryengine.v1beta.CompletionService.CompleteQuery:input_type -> google.cloud.discoveryengine.v1beta.CompleteQueryRequest
	5,  // 15: google.cloud.discoveryengine.v1beta.CompletionService.AdvancedCompleteQuery:input_type -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryRequest
	17, // 16: google.cloud.discoveryengine.v1beta.CompletionService.ImportSuggestionDenyListEntries:input_type -> google.cloud.discoveryengine.v1beta.ImportSuggestionDenyListEntriesRequest
	18, // 17: google.cloud.discoveryengine.v1beta.CompletionService.PurgeSuggestionDenyListEntries:input_type -> google.cloud.discoveryengine.v1beta.PurgeSuggestionDenyListEntriesRequest
	19, // 18: google.cloud.discoveryengine.v1beta.CompletionService.ImportCompletionSuggestions:input_type -> google.cloud.discoveryengine.v1beta.ImportCompletionSuggestionsRequest
	20, // 19: google.cloud.discoveryengine.v1beta.CompletionService.PurgeCompletionSuggestions:input_type -> google.cloud.discoveryengine.v1beta.PurgeCompletionSuggestionsRequest
	4,  // 20: google.cloud.discoveryengine.v1beta.CompletionService.CompleteQuery:output_type -> google.cloud.discoveryengine.v1beta.CompleteQueryResponse
	6,  // 21: google.cloud.discoveryengine.v1beta.CompletionService.AdvancedCompleteQuery:output_type -> google.cloud.discoveryengine.v1beta.AdvancedCompleteQueryResponse
	21, // 22: google.cloud.discoveryengine.v1beta.CompletionService.ImportSuggestionDenyListEntries:output_type -> google.longrunning.Operation
	21, // 23: google.cloud.discoveryengine.v1beta.CompletionService.PurgeSuggestionDenyListEntries:output_type -> google.longrunning.Operation
	21, // 24: google.cloud.discoveryengine.v1beta.CompletionService.ImportCompletionSuggestions:output_type -> google.longrunning.Operation
	21, // 25: google.cloud.discoveryengine.v1beta.CompletionService.PurgeCompletionSuggestions:output_type -> google.longrunning.Operation
	20, // [20:26] is the sub-list for method output_type
	14, // [14:20] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_google_cloud_discoveryengine_v1beta_completion_service_proto_init() }
func file_google_cloud_discoveryengine_v1beta_completion_service_proto_init() {
	if File_google_cloud_discoveryengine_v1beta_completion_service_proto != nil {
		return
	}
	file_google_cloud_discoveryengine_v1beta_common_proto_init()
	file_google_cloud_discoveryengine_v1beta_document_proto_init()
	file_google_cloud_discoveryengine_v1beta_import_config_proto_init()
	file_google_cloud_discoveryengine_v1beta_purge_config_proto_init()
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_discoveryengine_v1beta_completion_service_proto_goTypes,
		DependencyIndexes: file_google_cloud_discoveryengine_v1beta_completion_service_proto_depIdxs,
		EnumInfos:         file_google_cloud_discoveryengine_v1beta_completion_service_proto_enumTypes,
		MessageInfos:      file_google_cloud_discoveryengine_v1beta_completion_service_proto_msgTypes,
	}.Build()
	File_google_cloud_discoveryengine_v1beta_completion_service_proto = out.File
	file_google_cloud_discoveryengine_v1beta_completion_service_proto_rawDesc = nil
	file_google_cloud_discoveryengine_v1beta_completion_service_proto_goTypes = nil
	file_google_cloud_discoveryengine_v1beta_completion_service_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// CompletionServiceClient is the client API for CompletionService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type CompletionServiceClient interface {
	// Completes the specified user input with keyword suggestions.
	CompleteQuery(ctx context.Context, in *CompleteQueryRequest, opts ...grpc.CallOption) (*CompleteQueryResponse, error)
	// Completes the user input with advanced keyword suggestions.
	AdvancedCompleteQuery(ctx context.Context, in *AdvancedCompleteQueryRequest, opts ...grpc.CallOption) (*AdvancedCompleteQueryResponse, error)
	// Imports all
	// [SuggestionDenyListEntry][google.cloud.discoveryengine.v1beta.SuggestionDenyListEntry]
	// for a DataStore.
	ImportSuggestionDenyListEntries(ctx context.Context, in *ImportSuggestionDenyListEntriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Permanently deletes all
	// [SuggestionDenyListEntry][google.cloud.discoveryengine.v1beta.SuggestionDenyListEntry]
	// for a DataStore.
	PurgeSuggestionDenyListEntries(ctx context.Context, in *PurgeSuggestionDenyListEntriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Imports
	// [CompletionSuggestion][google.cloud.discoveryengine.v1beta.CompletionSuggestion]s
	// for a DataStore.
	ImportCompletionSuggestions(ctx context.Context, in *ImportCompletionSuggestionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Permanently deletes all
	// [CompletionSuggestion][google.cloud.discoveryengine.v1beta.CompletionSuggestion]s
	// for a DataStore.
	PurgeCompletionSuggestions(ctx context.Context, in *PurgeCompletionSuggestionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type completionServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewCompletionServiceClient(cc grpc.ClientConnInterface) CompletionServiceClient {
	return &completionServiceClient{cc}
}

func (c *completionServiceClient) CompleteQuery(ctx context.Context, in *CompleteQueryRequest, opts ...grpc.CallOption) (*CompleteQueryResponse, error) {
	out := new(CompleteQueryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.CompletionService/CompleteQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *completionServiceClient) AdvancedCompleteQuery(ctx context.Context, in *AdvancedCompleteQueryRequest, opts ...grpc.CallOption) (*AdvancedCompleteQueryResponse, error) {
	out := new(AdvancedCompleteQueryResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.CompletionService/AdvancedCompleteQuery", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *completionServiceClient) ImportSuggestionDenyListEntries(ctx context.Context, in *ImportSuggestionDenyListEntriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.CompletionService/ImportSuggestionDenyListEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *completionServiceClient) PurgeSuggestionDenyListEntries(ctx context.Context, in *PurgeSuggestionDenyListEntriesRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.CompletionService/PurgeSuggestionDenyListEntries", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *completionServiceClient) ImportCompletionSuggestions(ctx context.Context, in *ImportCompletionSuggestionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.CompletionService/ImportCompletionSuggestions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *completionServiceClient) PurgeCompletionSuggestions(ctx context.Context, in *PurgeCompletionSuggestionsRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.discoveryengine.v1beta.CompletionService/PurgeCompletionSuggestions", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// CompletionServiceServer is the server API for CompletionService service.
type CompletionServiceServer interface {
	// Completes the specified user input with keyword suggestions.
	CompleteQuery(context.Context, *CompleteQueryRequest) (*CompleteQueryResponse, error)
	// Completes the user input with advanced keyword suggestions.
	AdvancedCompleteQuery(context.Context, *AdvancedCompleteQueryRequest) (*AdvancedCompleteQueryResponse, error)
	// Imports all
	// [SuggestionDenyListEntry][google.cloud.discoveryengine.v1beta.SuggestionDenyListEntry]
	// for a DataStore.
	ImportSuggestionDenyListEntries(context.Context, *ImportSuggestionDenyListEntriesRequest) (*longrunningpb.Operation, error)
	// Permanently deletes all
	// [SuggestionDenyListEntry][google.cloud.discoveryengine.v1beta.SuggestionDenyListEntry]
	// for a DataStore.
	PurgeSuggestionDenyListEntries(context.Context, *PurgeSuggestionDenyListEntriesRequest) (*longrunningpb.Operation, error)
	// Imports
	// [CompletionSuggestion][google.cloud.discoveryengine.v1beta.CompletionSuggestion]s
	// for a DataStore.
	ImportCompletionSuggestions(context.Context, *ImportCompletionSuggestionsRequest) (*longrunningpb.Operation, error)
	// Permanently deletes all
	// [CompletionSuggestion][google.cloud.discoveryengine.v1beta.CompletionSuggestion]s
	// for a DataStore.
	PurgeCompletionSuggestions(context.Context, *PurgeCompletionSuggestionsRequest) (*longrunningpb.Operation, error)
}

// UnimplementedCompletionServiceServer can be embedded to have forward compatible implementations.
type UnimplementedCompletionServiceServer struct {
}

func (*UnimplementedCompletionServiceServer) CompleteQuery(context.Context, *CompleteQueryRequest) (*CompleteQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CompleteQuery not implemented")
}
func (*UnimplementedCompletionServiceServer) AdvancedCompleteQuery(context.Context, *AdvancedCompleteQueryRequest) (*AdvancedCompleteQueryResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method AdvancedCompleteQuery not implemented")
}
func (*UnimplementedCompletionServiceServer) ImportSuggestionDenyListEntries(context.Context, *ImportSuggestionDenyListEntriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportSuggestionDenyListEntries not implemented")
}
func (*UnimplementedCompletionServiceServer) PurgeSuggestionDenyListEntries(context.Context, *PurgeSuggestionDenyListEntriesRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeSuggestionDenyListEntries not implemented")
}
func (*UnimplementedCompletionServiceServer) ImportCompletionSuggestions(context.Context, *ImportCompletionSuggestionsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportCompletionSuggestions not implemented")
}
func (*UnimplementedCompletionServiceServer) PurgeCompletionSuggestions(context.Context, *PurgeCompletionSuggestionsRequest) (*longrunningpb.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method PurgeCompletionSuggestions not implemented")
}

func RegisterCompletionServiceServer(s *grpc.Server, srv CompletionServiceServer) {
	s.RegisterService(&_CompletionService_serviceDesc, srv)
}

func _CompletionService_CompleteQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CompleteQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CompletionServiceServer).CompleteQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.CompletionService/CompleteQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CompletionServiceServer).CompleteQuery(ctx, req.(*CompleteQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CompletionService_AdvancedCompleteQuery_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(AdvancedCompleteQueryRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CompletionServiceServer).AdvancedCompleteQuery(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.CompletionService/AdvancedCompleteQuery",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CompletionServiceServer).AdvancedCompleteQuery(ctx, req.(*AdvancedCompleteQueryRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CompletionService_ImportSuggestionDenyListEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportSuggestionDenyListEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CompletionServiceServer).ImportSuggestionDenyListEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.CompletionService/ImportSuggestionDenyListEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CompletionServiceServer).ImportSuggestionDenyListEntries(ctx, req.(*ImportSuggestionDenyListEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CompletionService_PurgeSuggestionDenyListEntries_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeSuggestionDenyListEntriesRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CompletionServiceServer).PurgeSuggestionDenyListEntries(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.CompletionService/PurgeSuggestionDenyListEntries",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CompletionServiceServer).PurgeSuggestionDenyListEntries(ctx, req.(*PurgeSuggestionDenyListEntriesRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CompletionService_ImportCompletionSuggestions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportCompletionSuggestionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CompletionServiceServer).ImportCompletionSuggestions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.CompletionService/ImportCompletionSuggestions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CompletionServiceServer).ImportCompletionSuggestions(ctx, req.(*ImportCompletionSuggestionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _CompletionService_PurgeCompletionSuggestions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(PurgeCompletionSuggestionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(CompletionServiceServer).PurgeCompletionSuggestions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.discoveryengine.v1beta.CompletionService/PurgeCompletionSuggestions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(CompletionServiceServer).PurgeCompletionSuggestions(ctx, req.(*PurgeCompletionSuggestionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _CompletionService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.discoveryengine.v1beta.CompletionService",
	HandlerType: (*CompletionServiceServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CompleteQuery",
			Handler:    _CompletionService_CompleteQuery_Handler,
		},
		{
			MethodName: "AdvancedCompleteQuery",
			Handler:    _CompletionService_AdvancedCompleteQuery_Handler,
		},
		{
			MethodName: "ImportSuggestionDenyListEntries",
			Handler:    _CompletionService_ImportSuggestionDenyListEntries_Handler,
		},
		{
			MethodName: "PurgeSuggestionDenyListEntries",
			Handler:    _CompletionService_PurgeSuggestionDenyListEntries_Handler,
		},
		{
			MethodName: "ImportCompletionSuggestions",
			Handler:    _CompletionService_ImportCompletionSuggestions_Handler,
		},
		{
			MethodName: "PurgeCompletionSuggestions",
			Handler:    _CompletionService_PurgeCompletionSuggestions_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/discoveryengine/v1beta/completion_service.proto",
}
