// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/networkservices/v1/tcp_route.proto

package networkservicespb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// TcpRoute is the resource defining how TCP traffic should be routed by a
// Mesh/Gateway resource.
type TcpRoute struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the TcpRoute resource. It matches pattern
	// `projects/*/locations/global/tcpRoutes/tcp_route_name>`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server-defined URL of this resource
	SelfLink string `protobuf:"bytes,11,opt,name=self_link,json=selfLink,proto3" json:"self_link,omitempty"`
	// Output only. The timestamp when the resource was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The timestamp when the resource was updated.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. A free-text description of the resource. Max length 1024
	// characters.
	Description string `protobuf:"bytes,4,opt,name=description,proto3" json:"description,omitempty"`
	// Required. Rules that define how traffic is routed and handled. At least one
	// RouteRule must be supplied. If there are multiple rules then the action
	// taken will be the first rule to match.
	Rules []*TcpRoute_RouteRule `protobuf:"bytes,5,rep,name=rules,proto3" json:"rules,omitempty"`
	// Optional. Meshes defines a list of meshes this TcpRoute is attached to, as
	// one of the routing rules to route the requests served by the mesh.
	//
	// Each mesh reference should match the pattern:
	// `projects/*/locations/global/meshes/<mesh_name>`
	//
	// The attached Mesh should be of a type SIDECAR
	Meshes []string `protobuf:"bytes,8,rep,name=meshes,proto3" json:"meshes,omitempty"`
	// Optional. Gateways defines a list of gateways this TcpRoute is attached to,
	// as one of the routing rules to route the requests served by the gateway.
	//
	// Each gateway reference should match the pattern:
	// `projects/*/locations/global/gateways/<gateway_name>`
	Gateways []string `protobuf:"bytes,9,rep,name=gateways,proto3" json:"gateways,omitempty"`
	// Optional. Set of label tags associated with the TcpRoute resource.
	Labels map[string]string `protobuf:"bytes,10,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *TcpRoute) Reset() {
	*x = TcpRoute{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpRoute) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpRoute) ProtoMessage() {}

func (x *TcpRoute) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpRoute.ProtoReflect.Descriptor instead.
func (*TcpRoute) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{0}
}

func (x *TcpRoute) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *TcpRoute) GetSelfLink() string {
	if x != nil {
		return x.SelfLink
	}
	return ""
}

func (x *TcpRoute) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *TcpRoute) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *TcpRoute) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *TcpRoute) GetRules() []*TcpRoute_RouteRule {
	if x != nil {
		return x.Rules
	}
	return nil
}

func (x *TcpRoute) GetMeshes() []string {
	if x != nil {
		return x.Meshes
	}
	return nil
}

func (x *TcpRoute) GetGateways() []string {
	if x != nil {
		return x.Gateways
	}
	return nil
}

func (x *TcpRoute) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

// Request used with the ListTcpRoutes method.
type ListTcpRoutesRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The project and location from which the TcpRoutes should be
	// listed, specified in the format `projects/*/locations/global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Maximum number of TcpRoutes to return per call.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The value returned by the last `ListTcpRoutesResponse`
	// Indicates that this is a continuation of a prior `ListTcpRoutes` call,
	// and that the system should return the next page of data.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *ListTcpRoutesRequest) Reset() {
	*x = ListTcpRoutesRequest{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTcpRoutesRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTcpRoutesRequest) ProtoMessage() {}

func (x *ListTcpRoutesRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTcpRoutesRequest.ProtoReflect.Descriptor instead.
func (*ListTcpRoutesRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{1}
}

func (x *ListTcpRoutesRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListTcpRoutesRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListTcpRoutesRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response returned by the ListTcpRoutes method.
type ListTcpRoutesResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of TcpRoute resources.
	TcpRoutes []*TcpRoute `protobuf:"bytes,1,rep,name=tcp_routes,json=tcpRoutes,proto3" json:"tcp_routes,omitempty"`
	// If there might be more results than those appearing in this response, then
	// `next_page_token` is included. To get the next set of results, call this
	// method again using the value of `next_page_token` as `page_token`.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *ListTcpRoutesResponse) Reset() {
	*x = ListTcpRoutesResponse{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListTcpRoutesResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListTcpRoutesResponse) ProtoMessage() {}

func (x *ListTcpRoutesResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListTcpRoutesResponse.ProtoReflect.Descriptor instead.
func (*ListTcpRoutesResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{2}
}

func (x *ListTcpRoutesResponse) GetTcpRoutes() []*TcpRoute {
	if x != nil {
		return x.TcpRoutes
	}
	return nil
}

func (x *ListTcpRoutesResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Request used by the GetTcpRoute method.
type GetTcpRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the TcpRoute to get. Must be in the format
	// `projects/*/locations/global/tcpRoutes/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetTcpRouteRequest) Reset() {
	*x = GetTcpRouteRequest{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetTcpRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetTcpRouteRequest) ProtoMessage() {}

func (x *GetTcpRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetTcpRouteRequest.ProtoReflect.Descriptor instead.
func (*GetTcpRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{3}
}

func (x *GetTcpRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request used by the TcpRoute method.
type CreateTcpRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource of the TcpRoute. Must be in the
	// format `projects/*/locations/global`.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Short name of the TcpRoute resource to be created.
	TcpRouteId string `protobuf:"bytes,2,opt,name=tcp_route_id,json=tcpRouteId,proto3" json:"tcp_route_id,omitempty"`
	// Required. TcpRoute resource to be created.
	TcpRoute *TcpRoute `protobuf:"bytes,3,opt,name=tcp_route,json=tcpRoute,proto3" json:"tcp_route,omitempty"`
}

func (x *CreateTcpRouteRequest) Reset() {
	*x = CreateTcpRouteRequest{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateTcpRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateTcpRouteRequest) ProtoMessage() {}

func (x *CreateTcpRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateTcpRouteRequest.ProtoReflect.Descriptor instead.
func (*CreateTcpRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{4}
}

func (x *CreateTcpRouteRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateTcpRouteRequest) GetTcpRouteId() string {
	if x != nil {
		return x.TcpRouteId
	}
	return ""
}

func (x *CreateTcpRouteRequest) GetTcpRoute() *TcpRoute {
	if x != nil {
		return x.TcpRoute
	}
	return nil
}

// Request used by the UpdateTcpRoute method.
type UpdateTcpRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Field mask is used to specify the fields to be overwritten in the
	// TcpRoute resource by the update.
	// The fields specified in the update_mask are relative to the resource, not
	// the full request. A field will be overwritten if it is in the mask. If the
	// user does not provide a mask then all fields will be overwritten.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,1,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
	// Required. Updated TcpRoute resource.
	TcpRoute *TcpRoute `protobuf:"bytes,2,opt,name=tcp_route,json=tcpRoute,proto3" json:"tcp_route,omitempty"`
}

func (x *UpdateTcpRouteRequest) Reset() {
	*x = UpdateTcpRouteRequest{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateTcpRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateTcpRouteRequest) ProtoMessage() {}

func (x *UpdateTcpRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateTcpRouteRequest.ProtoReflect.Descriptor instead.
func (*UpdateTcpRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{5}
}

func (x *UpdateTcpRouteRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

func (x *UpdateTcpRouteRequest) GetTcpRoute() *TcpRoute {
	if x != nil {
		return x.TcpRoute
	}
	return nil
}

// Request used by the DeleteTcpRoute method.
type DeleteTcpRouteRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. A name of the TcpRoute to delete. Must be in the format
	// `projects/*/locations/global/tcpRoutes/*`.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *DeleteTcpRouteRequest) Reset() {
	*x = DeleteTcpRouteRequest{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteTcpRouteRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteTcpRouteRequest) ProtoMessage() {}

func (x *DeleteTcpRouteRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteTcpRouteRequest.ProtoReflect.Descriptor instead.
func (*DeleteTcpRouteRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{6}
}

func (x *DeleteTcpRouteRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Specifies how to match traffic and how to route traffic when traffic is
// matched.
type TcpRoute_RouteRule struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. RouteMatch defines the predicate used to match requests to a
	// given action. Multiple match types are "OR"ed for evaluation. If no
	// routeMatch field is specified, this rule will unconditionally match
	// traffic.
	Matches []*TcpRoute_RouteMatch `protobuf:"bytes,1,rep,name=matches,proto3" json:"matches,omitempty"`
	// Required. The detailed rule defining how to route matched traffic.
	Action *TcpRoute_RouteAction `protobuf:"bytes,2,opt,name=action,proto3" json:"action,omitempty"`
}

func (x *TcpRoute_RouteRule) Reset() {
	*x = TcpRoute_RouteRule{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpRoute_RouteRule) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpRoute_RouteRule) ProtoMessage() {}

func (x *TcpRoute_RouteRule) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpRoute_RouteRule.ProtoReflect.Descriptor instead.
func (*TcpRoute_RouteRule) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{0, 0}
}

func (x *TcpRoute_RouteRule) GetMatches() []*TcpRoute_RouteMatch {
	if x != nil {
		return x.Matches
	}
	return nil
}

func (x *TcpRoute_RouteRule) GetAction() *TcpRoute_RouteAction {
	if x != nil {
		return x.Action
	}
	return nil
}

// RouteMatch defines the predicate used to match requests to a given action.
// Multiple match types are "OR"ed for evaluation.
// If no routeMatch field is specified, this rule will unconditionally match
// traffic.
type TcpRoute_RouteMatch struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Must be specified in the CIDR range format. A CIDR range
	// consists of an IP Address and a prefix length to construct the subnet
	// mask. By default, the prefix length is 32 (i.e. matches a single IP
	// address). Only IPV4 addresses are supported.
	// Examples:
	// "10.0.0.1" - matches against this exact IP address.
	// "10.0.0.0/8" - matches against any IP address within the 10.0.0.0 subnet
	// and 255.255.255.0 mask.
	// "0.0.0.0/0" - matches against any IP address'.
	Address string `protobuf:"bytes,1,opt,name=address,proto3" json:"address,omitempty"`
	// Required. Specifies the destination port to match against.
	Port string `protobuf:"bytes,2,opt,name=port,proto3" json:"port,omitempty"`
}

func (x *TcpRoute_RouteMatch) Reset() {
	*x = TcpRoute_RouteMatch{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpRoute_RouteMatch) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpRoute_RouteMatch) ProtoMessage() {}

func (x *TcpRoute_RouteMatch) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpRoute_RouteMatch.ProtoReflect.Descriptor instead.
func (*TcpRoute_RouteMatch) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{0, 1}
}

func (x *TcpRoute_RouteMatch) GetAddress() string {
	if x != nil {
		return x.Address
	}
	return ""
}

func (x *TcpRoute_RouteMatch) GetPort() string {
	if x != nil {
		return x.Port
	}
	return ""
}

// The specifications for routing traffic and applying associated policies.
type TcpRoute_RouteAction struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The destination services to which traffic should be forwarded.
	// At least one destination service is required. Only one of route
	// destination or original destination can be set.
	Destinations []*TcpRoute_RouteDestination `protobuf:"bytes,1,rep,name=destinations,proto3" json:"destinations,omitempty"`
	// Optional. If true, Router will use the destination IP and port of the
	// original connection as the destination of the request. Default is false.
	// Only one of route destinations or original destination can be set.
	OriginalDestination bool `protobuf:"varint,3,opt,name=original_destination,json=originalDestination,proto3" json:"original_destination,omitempty"`
}

func (x *TcpRoute_RouteAction) Reset() {
	*x = TcpRoute_RouteAction{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpRoute_RouteAction) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpRoute_RouteAction) ProtoMessage() {}

func (x *TcpRoute_RouteAction) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpRoute_RouteAction.ProtoReflect.Descriptor instead.
func (*TcpRoute_RouteAction) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{0, 2}
}

func (x *TcpRoute_RouteAction) GetDestinations() []*TcpRoute_RouteDestination {
	if x != nil {
		return x.Destinations
	}
	return nil
}

func (x *TcpRoute_RouteAction) GetOriginalDestination() bool {
	if x != nil {
		return x.OriginalDestination
	}
	return false
}

// Describe the destination for traffic to be routed to.
type TcpRoute_RouteDestination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The URL of a BackendService to route traffic to.
	ServiceName string `protobuf:"bytes,1,opt,name=service_name,json=serviceName,proto3" json:"service_name,omitempty"`
	// Optional. Specifies the proportion of requests forwarded to the backend
	// referenced by the serviceName field. This is computed as:
	// - weight/Sum(weights in this destination list).
	// For non-zero values, there may be some epsilon from the exact proportion
	// defined here depending on the precision an implementation supports.
	//
	// If only one serviceName is specified and it has a weight greater than 0,
	// 100% of the traffic is forwarded to that backend.
	//
	// If weights are specified for any one service name, they need to be
	// specified for all of them.
	//
	// If weights are unspecified for all services, then, traffic is distributed
	// in equal proportions to all of them.
	Weight int32 `protobuf:"varint,2,opt,name=weight,proto3" json:"weight,omitempty"`
}

func (x *TcpRoute_RouteDestination) Reset() {
	*x = TcpRoute_RouteDestination{}
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TcpRoute_RouteDestination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TcpRoute_RouteDestination) ProtoMessage() {}

func (x *TcpRoute_RouteDestination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use TcpRoute_RouteDestination.ProtoReflect.Descriptor instead.
func (*TcpRoute_RouteDestination) Descriptor() ([]byte, []int) {
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP(), []int{0, 3}
}

func (x *TcpRoute_RouteDestination) GetServiceName() string {
	if x != nil {
		return x.ServiceName
	}
	return ""
}

func (x *TcpRoute_RouteDestination) GetWeight() int32 {
	if x != nil {
		return x.Weight
	}
	return 0
}

var File_google_cloud_networkservices_v1_tcp_route_proto protoreflect.FileDescriptor

var file_google_cloud_networkservices_v1_tcp_route_proto_rawDesc = []byte{
	0x0a, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x76,
	0x31, 0x2f, 0x74, 0x63, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x12, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75,
	0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x22, 0xfb, 0x09, 0x0a, 0x08, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x09, 0x73, 0x65, 0x6c, 0x66, 0x5f,
	0x6c, 0x69, 0x6e, 0x6b, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x08, 0x73, 0x65, 0x6c, 0x66, 0x4c, 0x69, 0x6e, 0x6b, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x25, 0x0a,
	0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70,
	0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4e, 0x0a, 0x05, 0x72, 0x75, 0x6c, 0x65, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x72,
	0x75, 0x6c, 0x65, 0x73, 0x12, 0x43, 0x0a, 0x06, 0x6d, 0x65, 0x73, 0x68, 0x65, 0x73, 0x18, 0x08,
	0x20, 0x03, 0x28, 0x09, 0x42, 0x2b, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x25, 0x0a, 0x23, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4d, 0x65, 0x73,
	0x68, 0x52, 0x06, 0x6d, 0x65, 0x73, 0x68, 0x65, 0x73, 0x12, 0x4a, 0x0a, 0x08, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x09, 0x42, 0x2e, 0xe0, 0x41, 0x01,
	0xfa, 0x41, 0x28, 0x0a, 0x26, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x61, 0x74, 0x65, 0x77, 0x61, 0x79, 0x52, 0x08, 0x67, 0x61, 0x74,
	0x65, 0x77, 0x61, 0x79, 0x73, 0x12, 0x52, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18,
	0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0xb4, 0x01, 0x0a, 0x09, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x52, 0x75, 0x6c, 0x65, 0x12, 0x53, 0x0a, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68,
	0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x63, 0x70, 0x52, 0x6f,
	0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x07, 0x6d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x12, 0x52, 0x0a, 0x06,
	0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x35, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x41, 0x63, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x06, 0x61, 0x63, 0x74, 0x69, 0x6f, 0x6e,
	0x1a, 0x44, 0x0a, 0x0a, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x12, 0x1d,
	0x0a, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x61, 0x64, 0x64, 0x72, 0x65, 0x73, 0x73, 0x12, 0x17, 0x0a,
	0x04, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x04, 0x70, 0x6f, 0x72, 0x74, 0x1a, 0xaa, 0x01, 0x0a, 0x0b, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x41, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x63, 0x0a, 0x0c, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x2e, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0c, 0x64,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x36, 0x0a, 0x14, 0x6f,
	0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x5f, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13,
	0x6f, 0x72, 0x69, 0x67, 0x69, 0x6e, 0x61, 0x6c, 0x44, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x1a, 0x81, 0x01, 0x0a, 0x10, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x44, 0x65, 0x73,
	0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x50, 0x0a, 0x0c, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2d,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x27, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74, 0x65, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x42,
	0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x0b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x77, 0x65,
	0x69, 0x67, 0x68, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x06, 0x77, 0x65, 0x69, 0x67, 0x68, 0x74, 0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x3a, 0x6b, 0xea, 0x41, 0x68, 0x0a, 0x27, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61,
	0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x12, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x63, 0x70, 0x52, 0x6f, 0x75,
	0x74, 0x65, 0x73, 0x2f, 0x7b, 0x74, 0x63, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x7d, 0x22,
	0x9b, 0x01, 0x0a, 0x14, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29,
	0x12, 0x27, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65,
	0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x1d,
	0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x89, 0x01,
	0x0a, 0x15, 0x4c, 0x69, 0x73, 0x74, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x48, 0x0a, 0x0a, 0x74, 0x63, 0x70, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f,
	0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x63,
	0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x09, 0x74, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65,
	0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74,
	0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74,
	0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x59, 0x0a, 0x12, 0x47, 0x65, 0x74,
	0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x43, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0,
	0x41, 0x02, 0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x04,
	0x6e, 0x61, 0x6d, 0x65, 0x22, 0xd4, 0x01, 0x0a, 0x15, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54,
	0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x47,
	0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f,
	0xe0, 0x41, 0x02, 0xfa, 0x41, 0x29, 0x12, 0x27, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x25, 0x0a, 0x0c, 0x74, 0x63, 0x70, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x02, 0x52, 0x0a, 0x74, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x49, 0x64, 0x12, 0x4b,
	0x0a, 0x09, 0x74, 0x63, 0x70, 0x5f, 0x72, 0x6f, 0x75, 0x74, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x74, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x22, 0xa6, 0x01, 0x0a, 0x15,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65,
	0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x12, 0x4b, 0x0a, 0x09, 0x74, 0x63, 0x70, 0x5f, 0x72,
	0x6f, 0x75, 0x74, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72,
	0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x63, 0x70,
	0x52, 0x6f, 0x75, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x74, 0x63, 0x70, 0x52,
	0x6f, 0x75, 0x74, 0x65, 0x22, 0x5c, 0x0a, 0x15, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x54, 0x63,
	0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x43, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xe0, 0x41, 0x02,
	0xfa, 0x41, 0x29, 0x0a, 0x27, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x42, 0xe3, 0x02, 0xea, 0x41, 0x72, 0x0a, 0x25, 0x63, 0x6f, 0x6d, 0x70, 0x75, 0x74,
	0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x42, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x12,
	0x49, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e, 0x64,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x7b, 0x62, 0x61, 0x63, 0x6b, 0x65, 0x6e,
	0x64, 0x5f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x7d, 0x0a, 0x23, 0x63, 0x6f, 0x6d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6e, 0x65, 0x74,
	0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x76, 0x31, 0x42,
	0x0d, 0x54, 0x63, 0x70, 0x52, 0x6f, 0x75, 0x74, 0x65, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01,
	0x5a, 0x4d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x73, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6e, 0x65, 0x74, 0x77,
	0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0x3b, 0x6e, 0x65,
	0x74, 0x77, 0x6f, 0x72, 0x6b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x70, 0x62, 0xaa,
	0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x4e,
	0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x73,
	0x5c, 0x56, 0x31, 0xea, 0x02, 0x22, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x4e, 0x65, 0x74, 0x77, 0x6f, 0x72, 0x6b, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x73, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_networkservices_v1_tcp_route_proto_rawDescOnce sync.Once
	file_google_cloud_networkservices_v1_tcp_route_proto_rawDescData = file_google_cloud_networkservices_v1_tcp_route_proto_rawDesc
)

func file_google_cloud_networkservices_v1_tcp_route_proto_rawDescGZIP() []byte {
	file_google_cloud_networkservices_v1_tcp_route_proto_rawDescOnce.Do(func() {
		file_google_cloud_networkservices_v1_tcp_route_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_networkservices_v1_tcp_route_proto_rawDescData)
	})
	return file_google_cloud_networkservices_v1_tcp_route_proto_rawDescData
}

var file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_google_cloud_networkservices_v1_tcp_route_proto_goTypes = []any{
	(*TcpRoute)(nil),                  // 0: google.cloud.networkservices.v1.TcpRoute
	(*ListTcpRoutesRequest)(nil),      // 1: google.cloud.networkservices.v1.ListTcpRoutesRequest
	(*ListTcpRoutesResponse)(nil),     // 2: google.cloud.networkservices.v1.ListTcpRoutesResponse
	(*GetTcpRouteRequest)(nil),        // 3: google.cloud.networkservices.v1.GetTcpRouteRequest
	(*CreateTcpRouteRequest)(nil),     // 4: google.cloud.networkservices.v1.CreateTcpRouteRequest
	(*UpdateTcpRouteRequest)(nil),     // 5: google.cloud.networkservices.v1.UpdateTcpRouteRequest
	(*DeleteTcpRouteRequest)(nil),     // 6: google.cloud.networkservices.v1.DeleteTcpRouteRequest
	(*TcpRoute_RouteRule)(nil),        // 7: google.cloud.networkservices.v1.TcpRoute.RouteRule
	(*TcpRoute_RouteMatch)(nil),       // 8: google.cloud.networkservices.v1.TcpRoute.RouteMatch
	(*TcpRoute_RouteAction)(nil),      // 9: google.cloud.networkservices.v1.TcpRoute.RouteAction
	(*TcpRoute_RouteDestination)(nil), // 10: google.cloud.networkservices.v1.TcpRoute.RouteDestination
	nil,                               // 11: google.cloud.networkservices.v1.TcpRoute.LabelsEntry
	(*timestamppb.Timestamp)(nil),     // 12: google.protobuf.Timestamp
	(*fieldmaskpb.FieldMask)(nil),     // 13: google.protobuf.FieldMask
}
var file_google_cloud_networkservices_v1_tcp_route_proto_depIdxs = []int32{
	12, // 0: google.cloud.networkservices.v1.TcpRoute.create_time:type_name -> google.protobuf.Timestamp
	12, // 1: google.cloud.networkservices.v1.TcpRoute.update_time:type_name -> google.protobuf.Timestamp
	7,  // 2: google.cloud.networkservices.v1.TcpRoute.rules:type_name -> google.cloud.networkservices.v1.TcpRoute.RouteRule
	11, // 3: google.cloud.networkservices.v1.TcpRoute.labels:type_name -> google.cloud.networkservices.v1.TcpRoute.LabelsEntry
	0,  // 4: google.cloud.networkservices.v1.ListTcpRoutesResponse.tcp_routes:type_name -> google.cloud.networkservices.v1.TcpRoute
	0,  // 5: google.cloud.networkservices.v1.CreateTcpRouteRequest.tcp_route:type_name -> google.cloud.networkservices.v1.TcpRoute
	13, // 6: google.cloud.networkservices.v1.UpdateTcpRouteRequest.update_mask:type_name -> google.protobuf.FieldMask
	0,  // 7: google.cloud.networkservices.v1.UpdateTcpRouteRequest.tcp_route:type_name -> google.cloud.networkservices.v1.TcpRoute
	8,  // 8: google.cloud.networkservices.v1.TcpRoute.RouteRule.matches:type_name -> google.cloud.networkservices.v1.TcpRoute.RouteMatch
	9,  // 9: google.cloud.networkservices.v1.TcpRoute.RouteRule.action:type_name -> google.cloud.networkservices.v1.TcpRoute.RouteAction
	10, // 10: google.cloud.networkservices.v1.TcpRoute.RouteAction.destinations:type_name -> google.cloud.networkservices.v1.TcpRoute.RouteDestination
	11, // [11:11] is the sub-list for method output_type
	11, // [11:11] is the sub-list for method input_type
	11, // [11:11] is the sub-list for extension type_name
	11, // [11:11] is the sub-list for extension extendee
	0,  // [0:11] is the sub-list for field type_name
}

func init() { file_google_cloud_networkservices_v1_tcp_route_proto_init() }
func file_google_cloud_networkservices_v1_tcp_route_proto_init() {
	if File_google_cloud_networkservices_v1_tcp_route_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_networkservices_v1_tcp_route_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_networkservices_v1_tcp_route_proto_goTypes,
		DependencyIndexes: file_google_cloud_networkservices_v1_tcp_route_proto_depIdxs,
		MessageInfos:      file_google_cloud_networkservices_v1_tcp_route_proto_msgTypes,
	}.Build()
	File_google_cloud_networkservices_v1_tcp_route_proto = out.File
	file_google_cloud_networkservices_v1_tcp_route_proto_rawDesc = nil
	file_google_cloud_networkservices_v1_tcp_route_proto_goTypes = nil
	file_google_cloud_networkservices_v1_tcp_route_proto_depIdxs = nil
}
