// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/oracledatabase/v1/autonomous_database_character_set.proto

package oracledatabasepb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// The type of character set an Autonomous Database can have.
type AutonomousDatabaseCharacterSet_CharacterSetType int32

const (
	// Character set type is not specified.
	AutonomousDatabaseCharacterSet_CHARACTER_SET_TYPE_UNSPECIFIED AutonomousDatabaseCharacterSet_CharacterSetType = 0
	// Character set type is set to database.
	AutonomousDatabaseCharacterSet_DATABASE AutonomousDatabaseCharacterSet_CharacterSetType = 1
	// Character set type is set to national.
	AutonomousDatabaseCharacterSet_NATIONAL AutonomousDatabaseCharacterSet_CharacterSetType = 2
)

// Enum value maps for AutonomousDatabaseCharacterSet_CharacterSetType.
var (
	AutonomousDatabaseCharacterSet_CharacterSetType_name = map[int32]string{
		0: "CHARACTER_SET_TYPE_UNSPECIFIED",
		1: "DATABASE",
		2: "NATIONAL",
	}
	AutonomousDatabaseCharacterSet_CharacterSetType_value = map[string]int32{
		"CHARACTER_SET_TYPE_UNSPECIFIED": 0,
		"DATABASE":                       1,
		"NATIONAL":                       2,
	}
)

func (x AutonomousDatabaseCharacterSet_CharacterSetType) Enum() *AutonomousDatabaseCharacterSet_CharacterSetType {
	p := new(AutonomousDatabaseCharacterSet_CharacterSetType)
	*p = x
	return p
}

func (x AutonomousDatabaseCharacterSet_CharacterSetType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AutonomousDatabaseCharacterSet_CharacterSetType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_enumTypes[0].Descriptor()
}

func (AutonomousDatabaseCharacterSet_CharacterSetType) Type() protoreflect.EnumType {
	return &file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_enumTypes[0]
}

func (x AutonomousDatabaseCharacterSet_CharacterSetType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AutonomousDatabaseCharacterSet_CharacterSetType.Descriptor instead.
func (AutonomousDatabaseCharacterSet_CharacterSetType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDescGZIP(), []int{0, 0}
}

// Details of the Autonomous Database character set resource.
// https://docs.oracle.com/en-us/iaas/api/#/en/database/20160918/AutonomousDatabaseCharacterSets/
type AutonomousDatabaseCharacterSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. The name of the Autonomous Database Character Set resource in
	// the following format:
	// projects/{project}/locations/{region}/autonomousDatabaseCharacterSets/{autonomous_database_character_set}
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. The character set type for the Autonomous Database.
	CharacterSetType AutonomousDatabaseCharacterSet_CharacterSetType `protobuf:"varint,2,opt,name=character_set_type,json=characterSetType,proto3,enum=google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet_CharacterSetType" json:"character_set_type,omitempty"`
	// Output only. The character set name for the Autonomous Database which is
	// the ID in the resource name.
	CharacterSet string `protobuf:"bytes,3,opt,name=character_set,json=characterSet,proto3" json:"character_set,omitempty"`
}

func (x *AutonomousDatabaseCharacterSet) Reset() {
	*x = AutonomousDatabaseCharacterSet{}
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AutonomousDatabaseCharacterSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AutonomousDatabaseCharacterSet) ProtoMessage() {}

func (x *AutonomousDatabaseCharacterSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AutonomousDatabaseCharacterSet.ProtoReflect.Descriptor instead.
func (*AutonomousDatabaseCharacterSet) Descriptor() ([]byte, []int) {
	return file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDescGZIP(), []int{0}
}

func (x *AutonomousDatabaseCharacterSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *AutonomousDatabaseCharacterSet) GetCharacterSetType() AutonomousDatabaseCharacterSet_CharacterSetType {
	if x != nil {
		return x.CharacterSetType
	}
	return AutonomousDatabaseCharacterSet_CHARACTER_SET_TYPE_UNSPECIFIED
}

func (x *AutonomousDatabaseCharacterSet) GetCharacterSet() string {
	if x != nil {
		return x.CharacterSet
	}
	return ""
}

var File_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto protoreflect.FileDescriptor

var file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDesc = []byte{
	0x0a, 0x46, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x76, 0x31,
	0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x73,
	0x65, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74,
	0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76,
	0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0xaf, 0x04, 0x0a, 0x1e, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d,
	0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61,
	0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x82, 0x01, 0x0a, 0x12, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x4f, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61,
	0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x2e, 0x41,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x2e, 0x43, 0x68,
	0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x54, 0x79, 0x70, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x10, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65,
	0x74, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x0d, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x5f, 0x73, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0c, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x22,
	0x52, 0x0a, 0x10, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x54,
	0x79, 0x70, 0x65, 0x12, 0x22, 0x0a, 0x1e, 0x43, 0x48, 0x41, 0x52, 0x41, 0x43, 0x54, 0x45, 0x52,
	0x5f, 0x53, 0x45, 0x54, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x41, 0x54, 0x41, 0x42,
	0x41, 0x53, 0x45, 0x10, 0x01, 0x12, 0x0c, 0x0a, 0x08, 0x4e, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x41,
	0x4c, 0x10, 0x02, 0x3a, 0xf0, 0x01, 0xea, 0x41, 0xec, 0x01, 0x0a, 0x3c, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x41, 0x75, 0x74, 0x6f, 0x6e, 0x6f,
	0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x72,
	0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x12, 0x6b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x7d, 0x2f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61,
	0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74,
	0x73, 0x2f, 0x7b, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x5f, 0x64, 0x61,
	0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5f, 0x63, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72,
	0x5f, 0x73, 0x65, 0x74, 0x7d, 0x2a, 0x1f, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75,
	0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74,
	0x65, 0x72, 0x53, 0x65, 0x74, 0x73, 0x32, 0x1e, 0x61, 0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f,
	0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63,
	0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x42, 0xfd, 0x01, 0x0a, 0x22, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x72, 0x61, 0x63,
	0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x76, 0x31, 0x42, 0x23, 0x41,
	0x75, 0x74, 0x6f, 0x6e, 0x6f, 0x6d, 0x6f, 0x75, 0x73, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73,
	0x65, 0x43, 0x68, 0x61, 0x72, 0x61, 0x63, 0x74, 0x65, 0x72, 0x53, 0x65, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x4a, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65,
	0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x6f,
	0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62, 0x3b,
	0x6f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x64, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x70, 0x62,
	0xaa, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x2e, 0x56,
	0x31, 0xca, 0x02, 0x1e, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x5c, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61, 0x73, 0x65, 0x5c,
	0x56, 0x31, 0xea, 0x02, 0x21, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f,
	0x75, 0x64, 0x3a, 0x3a, 0x4f, 0x72, 0x61, 0x63, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x62, 0x61,
	0x73, 0x65, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDescOnce sync.Once
	file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDescData = file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDesc
)

func file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDescGZIP() []byte {
	file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDescOnce.Do(func() {
		file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDescData)
	})
	return file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDescData
}

var file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_msgTypes = make([]protoimpl.MessageInfo, 1)
var file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_goTypes = []any{
	(AutonomousDatabaseCharacterSet_CharacterSetType)(0), // 0: google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet.CharacterSetType
	(*AutonomousDatabaseCharacterSet)(nil),               // 1: google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet
}
var file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_depIdxs = []int32{
	0, // 0: google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet.character_set_type:type_name -> google.cloud.oracledatabase.v1.AutonomousDatabaseCharacterSet.CharacterSetType
	1, // [1:1] is the sub-list for method output_type
	1, // [1:1] is the sub-list for method input_type
	1, // [1:1] is the sub-list for extension type_name
	1, // [1:1] is the sub-list for extension extendee
	0, // [0:1] is the sub-list for field type_name
}

func init() { file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_init() }
func file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_init() {
	if File_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto != nil {
		return
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   1,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_goTypes,
		DependencyIndexes: file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_depIdxs,
		EnumInfos:         file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_enumTypes,
		MessageInfos:      file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_msgTypes,
	}.Build()
	File_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto = out.File
	file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_rawDesc = nil
	file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_goTypes = nil
	file_google_cloud_oracledatabase_v1_autonomous_database_character_set_proto_depIdxs = nil
}
