// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.35.2
// 	protoc        v4.25.3
// source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

package privilegedaccessmanagerpb

import (
	context "context"
	reflect "reflect"
	sync "sync"

	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	_ "google.golang.org/genproto/googleapis/api/annotations"
	status "google.golang.org/genproto/googleapis/rpc/status"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status1 "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Different states an entitlement can be in.
type Entitlement_State int32

const (
	// Unspecified state. This value is never returned by the server.
	Entitlement_STATE_UNSPECIFIED Entitlement_State = 0
	// The entitlement is being created.
	Entitlement_CREATING Entitlement_State = 1
	// The entitlement is available for requesting access.
	Entitlement_AVAILABLE Entitlement_State = 2
	// The entitlement is being deleted.
	Entitlement_DELETING Entitlement_State = 3
	// The entitlement has been deleted.
	Entitlement_DELETED Entitlement_State = 4
	// The entitlement is being updated.
	Entitlement_UPDATING Entitlement_State = 5
)

// Enum value maps for Entitlement_State.
var (
	Entitlement_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "CREATING",
		2: "AVAILABLE",
		3: "DELETING",
		4: "DELETED",
		5: "UPDATING",
	}
	Entitlement_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"CREATING":          1,
		"AVAILABLE":         2,
		"DELETING":          3,
		"DELETED":           4,
		"UPDATING":          5,
	}
)

func (x Entitlement_State) Enum() *Entitlement_State {
	p := new(Entitlement_State)
	*p = x
	return p
}

func (x Entitlement_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Entitlement_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes[0].Descriptor()
}

func (Entitlement_State) Type() protoreflect.EnumType {
	return &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes[0]
}

func (x Entitlement_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Entitlement_State.Descriptor instead.
func (Entitlement_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{2, 0}
}

// Different types of access a user can have on the entitlement resource.
type SearchEntitlementsRequest_CallerAccessType int32

const (
	// Unspecified access type.
	SearchEntitlementsRequest_CALLER_ACCESS_TYPE_UNSPECIFIED SearchEntitlementsRequest_CallerAccessType = 0
	// The user has access to create grants using this entitlement.
	SearchEntitlementsRequest_GRANT_REQUESTER SearchEntitlementsRequest_CallerAccessType = 1
	// The user has access to approve/deny grants created under this
	// entitlement.
	SearchEntitlementsRequest_GRANT_APPROVER SearchEntitlementsRequest_CallerAccessType = 2
)

// Enum value maps for SearchEntitlementsRequest_CallerAccessType.
var (
	SearchEntitlementsRequest_CallerAccessType_name = map[int32]string{
		0: "CALLER_ACCESS_TYPE_UNSPECIFIED",
		1: "GRANT_REQUESTER",
		2: "GRANT_APPROVER",
	}
	SearchEntitlementsRequest_CallerAccessType_value = map[string]int32{
		"CALLER_ACCESS_TYPE_UNSPECIFIED": 0,
		"GRANT_REQUESTER":                1,
		"GRANT_APPROVER":                 2,
	}
)

func (x SearchEntitlementsRequest_CallerAccessType) Enum() *SearchEntitlementsRequest_CallerAccessType {
	p := new(SearchEntitlementsRequest_CallerAccessType)
	*p = x
	return p
}

func (x SearchEntitlementsRequest_CallerAccessType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchEntitlementsRequest_CallerAccessType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes[1].Descriptor()
}

func (SearchEntitlementsRequest_CallerAccessType) Type() protoreflect.EnumType {
	return &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes[1]
}

func (x SearchEntitlementsRequest_CallerAccessType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchEntitlementsRequest_CallerAccessType.Descriptor instead.
func (SearchEntitlementsRequest_CallerAccessType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{9, 0}
}

// Different states a grant can be in.
type Grant_State int32

const (
	// Unspecified state. This value is never returned by the server.
	Grant_STATE_UNSPECIFIED Grant_State = 0
	// The entitlement had an approval workflow configured and this grant is
	// waiting for the workflow to complete.
	Grant_APPROVAL_AWAITED Grant_State = 1
	// The approval workflow completed with a denied result. No access is
	// granted for this grant. This is a terminal state.
	Grant_DENIED Grant_State = 3
	// The approval workflow completed successfully with an approved result or
	// none was configured. Access is provided at an appropriate time.
	Grant_SCHEDULED Grant_State = 4
	// Access is being given.
	Grant_ACTIVATING Grant_State = 5
	// Access was successfully given and is currently active.
	Grant_ACTIVE Grant_State = 6
	// The system could not give access due to a non-retriable error. This is a
	// terminal state.
	Grant_ACTIVATION_FAILED Grant_State = 7
	// Expired after waiting for the approval workflow to complete. This is a
	// terminal state.
	Grant_EXPIRED Grant_State = 8
	// Access is being revoked.
	Grant_REVOKING Grant_State = 9
	// Access was revoked by a user. This is a terminal state.
	Grant_REVOKED Grant_State = 10
	// System took back access as the requested duration was over. This is a
	// terminal state.
	Grant_ENDED Grant_State = 11
)

// Enum value maps for Grant_State.
var (
	Grant_State_name = map[int32]string{
		0:  "STATE_UNSPECIFIED",
		1:  "APPROVAL_AWAITED",
		3:  "DENIED",
		4:  "SCHEDULED",
		5:  "ACTIVATING",
		6:  "ACTIVE",
		7:  "ACTIVATION_FAILED",
		8:  "EXPIRED",
		9:  "REVOKING",
		10: "REVOKED",
		11: "ENDED",
	}
	Grant_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"APPROVAL_AWAITED":  1,
		"DENIED":            3,
		"SCHEDULED":         4,
		"ACTIVATING":        5,
		"ACTIVE":            6,
		"ACTIVATION_FAILED": 7,
		"EXPIRED":           8,
		"REVOKING":          9,
		"REVOKED":           10,
		"ENDED":             11,
	}
)

func (x Grant_State) Enum() *Grant_State {
	p := new(Grant_State)
	*p = x
	return p
}

func (x Grant_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Grant_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes[2].Descriptor()
}

func (Grant_State) Type() protoreflect.EnumType {
	return &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes[2]
}

func (x Grant_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Grant_State.Descriptor instead.
func (Grant_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0}
}

// Different types of relationships a user can have with a grant.
type SearchGrantsRequest_CallerRelationshipType int32

const (
	// Unspecified caller relationship type.
	SearchGrantsRequest_CALLER_RELATIONSHIP_TYPE_UNSPECIFIED SearchGrantsRequest_CallerRelationshipType = 0
	// The user created this grant by calling `CreateGrant` earlier.
	SearchGrantsRequest_HAD_CREATED SearchGrantsRequest_CallerRelationshipType = 1
	// The user is an approver for the entitlement that this grant is parented
	// under and can currently approve/deny it.
	SearchGrantsRequest_CAN_APPROVE SearchGrantsRequest_CallerRelationshipType = 2
	// The caller had successfully approved/denied this grant earlier.
	SearchGrantsRequest_HAD_APPROVED SearchGrantsRequest_CallerRelationshipType = 3
)

// Enum value maps for SearchGrantsRequest_CallerRelationshipType.
var (
	SearchGrantsRequest_CallerRelationshipType_name = map[int32]string{
		0: "CALLER_RELATIONSHIP_TYPE_UNSPECIFIED",
		1: "HAD_CREATED",
		2: "CAN_APPROVE",
		3: "HAD_APPROVED",
	}
	SearchGrantsRequest_CallerRelationshipType_value = map[string]int32{
		"CALLER_RELATIONSHIP_TYPE_UNSPECIFIED": 0,
		"HAD_CREATED":                          1,
		"CAN_APPROVE":                          2,
		"HAD_APPROVED":                         3,
	}
)

func (x SearchGrantsRequest_CallerRelationshipType) Enum() *SearchGrantsRequest_CallerRelationshipType {
	p := new(SearchGrantsRequest_CallerRelationshipType)
	*p = x
	return p
}

func (x SearchGrantsRequest_CallerRelationshipType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SearchGrantsRequest_CallerRelationshipType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes[3].Descriptor()
}

func (SearchGrantsRequest_CallerRelationshipType) Type() protoreflect.EnumType {
	return &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes[3]
}

func (x SearchGrantsRequest_CallerRelationshipType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SearchGrantsRequest_CallerRelationshipType.Descriptor instead.
func (SearchGrantsRequest_CallerRelationshipType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{19, 0}
}

// Request message for `CheckOnboardingStatus` method.
type CheckOnboardingStatusRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource for which the onboarding status should be checked.
	// Should be in one of the following formats:
	//
	// * `projects/{project-number|project-id}/locations/{region}`
	// * `folders/{folder-number}/locations/{region}`
	// * `organizations/{organization-number}/locations/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
}

func (x *CheckOnboardingStatusRequest) Reset() {
	*x = CheckOnboardingStatusRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckOnboardingStatusRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckOnboardingStatusRequest) ProtoMessage() {}

func (x *CheckOnboardingStatusRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckOnboardingStatusRequest.ProtoReflect.Descriptor instead.
func (*CheckOnboardingStatusRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{0}
}

func (x *CheckOnboardingStatusRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

// Response message for `CheckOnboardingStatus` method.
type CheckOnboardingStatusResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The service account that PAM uses to act on this resource.
	ServiceAccount string `protobuf:"bytes,1,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// List of issues that are preventing PAM from functioning for this resource
	// and need to be fixed to complete onboarding. Some issues might not be
	// detected or reported.
	Findings []*CheckOnboardingStatusResponse_Finding `protobuf:"bytes,2,rep,name=findings,proto3" json:"findings,omitempty"`
}

func (x *CheckOnboardingStatusResponse) Reset() {
	*x = CheckOnboardingStatusResponse{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckOnboardingStatusResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckOnboardingStatusResponse) ProtoMessage() {}

func (x *CheckOnboardingStatusResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckOnboardingStatusResponse.ProtoReflect.Descriptor instead.
func (*CheckOnboardingStatusResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{1}
}

func (x *CheckOnboardingStatusResponse) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *CheckOnboardingStatusResponse) GetFindings() []*CheckOnboardingStatusResponse_Finding {
	if x != nil {
		return x.Findings
	}
	return nil
}

// An entitlement defines the eligibility of a set of users to obtain
// predefined access for some time possibly after going through an approval
// workflow.
type Entitlement struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Name of the entitlement.
	// Possible formats:
	//
	// * `organizations/{organization-number}/locations/{region}/entitlements/{entitlement-id}`
	// * `folders/{folder-number}/locations/{region}/entitlements/{entitlement-id}`
	// * `projects/{project-id|project-number}/locations/{region}/entitlements/{entitlement-id}`
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Create time stamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time stamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Optional. Who can create grants using this entitlement. This list should
	// contain at most one entry.
	EligibleUsers []*AccessControlEntry `protobuf:"bytes,5,rep,name=eligible_users,json=eligibleUsers,proto3" json:"eligible_users,omitempty"`
	// Optional. The approvals needed before access are granted to a requester. No
	// approvals are needed if this field is null.
	ApprovalWorkflow *ApprovalWorkflow `protobuf:"bytes,6,opt,name=approval_workflow,json=approvalWorkflow,proto3" json:"approval_workflow,omitempty"`
	// The access granted to a requester on successful approval.
	PrivilegedAccess *PrivilegedAccess `protobuf:"bytes,7,opt,name=privileged_access,json=privilegedAccess,proto3" json:"privileged_access,omitempty"`
	// Required. The maximum amount of time that access is granted for a request.
	// A requester can ask for a duration less than this, but never more.
	MaxRequestDuration *durationpb.Duration `protobuf:"bytes,8,opt,name=max_request_duration,json=maxRequestDuration,proto3" json:"max_request_duration,omitempty"`
	// Output only. Current state of this entitlement.
	State Entitlement_State `protobuf:"varint,9,opt,name=state,proto3,enum=google.cloud.privilegedaccessmanager.v1.Entitlement_State" json:"state,omitempty"`
	// Required. The manner in which the requester should provide a justification
	// for requesting access.
	RequesterJustificationConfig *Entitlement_RequesterJustificationConfig `protobuf:"bytes,10,opt,name=requester_justification_config,json=requesterJustificationConfig,proto3" json:"requester_justification_config,omitempty"`
	// Optional. Additional email addresses to be notified based on actions taken.
	AdditionalNotificationTargets *Entitlement_AdditionalNotificationTargets `protobuf:"bytes,11,opt,name=additional_notification_targets,json=additionalNotificationTargets,proto3" json:"additional_notification_targets,omitempty"`
	// An `etag` is used for optimistic concurrency control as a way to prevent
	// simultaneous updates to the same entitlement. An `etag` is returned in the
	// response to `GetEntitlement` and the caller should put the `etag` in the
	// request to `UpdateEntitlement` so that their change is applied on
	// the same version. If this field is omitted or if there is a mismatch while
	// updating an entitlement, then the server rejects the request.
	Etag string `protobuf:"bytes,12,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Entitlement) Reset() {
	*x = Entitlement{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entitlement) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entitlement) ProtoMessage() {}

func (x *Entitlement) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entitlement.ProtoReflect.Descriptor instead.
func (*Entitlement) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{2}
}

func (x *Entitlement) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Entitlement) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Entitlement) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Entitlement) GetEligibleUsers() []*AccessControlEntry {
	if x != nil {
		return x.EligibleUsers
	}
	return nil
}

func (x *Entitlement) GetApprovalWorkflow() *ApprovalWorkflow {
	if x != nil {
		return x.ApprovalWorkflow
	}
	return nil
}

func (x *Entitlement) GetPrivilegedAccess() *PrivilegedAccess {
	if x != nil {
		return x.PrivilegedAccess
	}
	return nil
}

func (x *Entitlement) GetMaxRequestDuration() *durationpb.Duration {
	if x != nil {
		return x.MaxRequestDuration
	}
	return nil
}

func (x *Entitlement) GetState() Entitlement_State {
	if x != nil {
		return x.State
	}
	return Entitlement_STATE_UNSPECIFIED
}

func (x *Entitlement) GetRequesterJustificationConfig() *Entitlement_RequesterJustificationConfig {
	if x != nil {
		return x.RequesterJustificationConfig
	}
	return nil
}

func (x *Entitlement) GetAdditionalNotificationTargets() *Entitlement_AdditionalNotificationTargets {
	if x != nil {
		return x.AdditionalNotificationTargets
	}
	return nil
}

func (x *Entitlement) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// `AccessControlEntry` is used to control who can do some operation.
type AccessControlEntry struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Users who are allowed for the operation. Each entry should be a
	// valid v1 IAM principal identifier. The format for these is documented at:
	// https://cloud.google.com/iam/docs/principal-identifiers#v1
	Principals []string `protobuf:"bytes,1,rep,name=principals,proto3" json:"principals,omitempty"`
}

func (x *AccessControlEntry) Reset() {
	*x = AccessControlEntry{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *AccessControlEntry) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*AccessControlEntry) ProtoMessage() {}

func (x *AccessControlEntry) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use AccessControlEntry.ProtoReflect.Descriptor instead.
func (*AccessControlEntry) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{3}
}

func (x *AccessControlEntry) GetPrincipals() []string {
	if x != nil {
		return x.Principals
	}
	return nil
}

// Different types of approval workflows that can be used to gate privileged
// access granting.
type ApprovalWorkflow struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to ApprovalWorkflow:
	//
	//	*ApprovalWorkflow_ManualApprovals
	ApprovalWorkflow isApprovalWorkflow_ApprovalWorkflow `protobuf_oneof:"approval_workflow"`
}

func (x *ApprovalWorkflow) Reset() {
	*x = ApprovalWorkflow{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApprovalWorkflow) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApprovalWorkflow) ProtoMessage() {}

func (x *ApprovalWorkflow) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApprovalWorkflow.ProtoReflect.Descriptor instead.
func (*ApprovalWorkflow) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{4}
}

func (m *ApprovalWorkflow) GetApprovalWorkflow() isApprovalWorkflow_ApprovalWorkflow {
	if m != nil {
		return m.ApprovalWorkflow
	}
	return nil
}

func (x *ApprovalWorkflow) GetManualApprovals() *ManualApprovals {
	if x, ok := x.GetApprovalWorkflow().(*ApprovalWorkflow_ManualApprovals); ok {
		return x.ManualApprovals
	}
	return nil
}

type isApprovalWorkflow_ApprovalWorkflow interface {
	isApprovalWorkflow_ApprovalWorkflow()
}

type ApprovalWorkflow_ManualApprovals struct {
	// An approval workflow where users designated as approvers review and act
	// on the grants.
	ManualApprovals *ManualApprovals `protobuf:"bytes,1,opt,name=manual_approvals,json=manualApprovals,proto3,oneof"`
}

func (*ApprovalWorkflow_ManualApprovals) isApprovalWorkflow_ApprovalWorkflow() {}

// A manual approval workflow where users who are designated as approvers
// need to call the `ApproveGrant`/`DenyGrant` APIs for a grant. The workflow
// can consist of multiple serial steps where each step defines who can act as
// approver in that step and how many of those users should approve before the
// workflow moves to the next step.
//
// This can be used to create approval workflows such as:
//
// * Require an approval from any user in a group G.
// * Require an approval from any k number of users from a Group G.
// * Require an approval from any user in a group G and then from a user U.
//
// A single user might be part of the `approvers` ACL for multiple steps in this
// workflow, but they can only approve once and that approval is only considered
// to satisfy the approval step at which it was granted.
type ManualApprovals struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Do the approvers need to provide a justification for their
	// actions?
	RequireApproverJustification bool `protobuf:"varint,1,opt,name=require_approver_justification,json=requireApproverJustification,proto3" json:"require_approver_justification,omitempty"`
	// Optional. List of approval steps in this workflow. These steps are followed
	// in the specified order sequentially. Only 1 step is supported.
	Steps []*ManualApprovals_Step `protobuf:"bytes,2,rep,name=steps,proto3" json:"steps,omitempty"`
}

func (x *ManualApprovals) Reset() {
	*x = ManualApprovals{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ManualApprovals) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManualApprovals) ProtoMessage() {}

func (x *ManualApprovals) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManualApprovals.ProtoReflect.Descriptor instead.
func (*ManualApprovals) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{5}
}

func (x *ManualApprovals) GetRequireApproverJustification() bool {
	if x != nil {
		return x.RequireApproverJustification
	}
	return false
}

func (x *ManualApprovals) GetSteps() []*ManualApprovals_Step {
	if x != nil {
		return x.Steps
	}
	return nil
}

// Privileged access that this service can be used to gate.
type PrivilegedAccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to AccessType:
	//
	//	*PrivilegedAccess_GcpIamAccess_
	AccessType isPrivilegedAccess_AccessType `protobuf_oneof:"access_type"`
}

func (x *PrivilegedAccess) Reset() {
	*x = PrivilegedAccess{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivilegedAccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivilegedAccess) ProtoMessage() {}

func (x *PrivilegedAccess) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivilegedAccess.ProtoReflect.Descriptor instead.
func (*PrivilegedAccess) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{6}
}

func (m *PrivilegedAccess) GetAccessType() isPrivilegedAccess_AccessType {
	if m != nil {
		return m.AccessType
	}
	return nil
}

func (x *PrivilegedAccess) GetGcpIamAccess() *PrivilegedAccess_GcpIamAccess {
	if x, ok := x.GetAccessType().(*PrivilegedAccess_GcpIamAccess_); ok {
		return x.GcpIamAccess
	}
	return nil
}

type isPrivilegedAccess_AccessType interface {
	isPrivilegedAccess_AccessType()
}

type PrivilegedAccess_GcpIamAccess_ struct {
	// Access to a Google Cloud resource through IAM.
	GcpIamAccess *PrivilegedAccess_GcpIamAccess `protobuf:"bytes,1,opt,name=gcp_iam_access,json=gcpIamAccess,proto3,oneof"`
}

func (*PrivilegedAccess_GcpIamAccess_) isPrivilegedAccess_AccessType() {}

// Message for requesting list of entitlements.
type ListEntitlementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns the entitlement resources.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. Server may return fewer items than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results.
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListEntitlementsRequest) Reset() {
	*x = ListEntitlementsRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntitlementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementsRequest) ProtoMessage() {}

func (x *ListEntitlementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementsRequest.ProtoReflect.Descriptor instead.
func (*ListEntitlementsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{7}
}

func (x *ListEntitlementsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListEntitlementsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListEntitlementsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListEntitlementsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListEntitlementsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing entitlements.
type ListEntitlementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of entitlements.
	Entitlements []*Entitlement `protobuf:"bytes,1,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListEntitlementsResponse) Reset() {
	*x = ListEntitlementsResponse{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListEntitlementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListEntitlementsResponse) ProtoMessage() {}

func (x *ListEntitlementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListEntitlementsResponse.ProtoReflect.Descriptor instead.
func (*ListEntitlementsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{8}
}

func (x *ListEntitlementsResponse) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

func (x *ListEntitlementsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListEntitlementsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for `SearchEntitlements` method.
type SearchEntitlementsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns the entitlement resources.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Only entitlements where the calling user has this access are
	// returned.
	CallerAccessType SearchEntitlementsRequest_CallerAccessType `protobuf:"varint,2,opt,name=caller_access_type,json=callerAccessType,proto3,enum=google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest_CallerAccessType" json:"caller_access_type,omitempty"`
	// Optional. Only entitlements matching this filter are returned in the
	// response.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. The server may return fewer items than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchEntitlementsRequest) Reset() {
	*x = SearchEntitlementsRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchEntitlementsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntitlementsRequest) ProtoMessage() {}

func (x *SearchEntitlementsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntitlementsRequest.ProtoReflect.Descriptor instead.
func (*SearchEntitlementsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{9}
}

func (x *SearchEntitlementsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchEntitlementsRequest) GetCallerAccessType() SearchEntitlementsRequest_CallerAccessType {
	if x != nil {
		return x.CallerAccessType
	}
	return SearchEntitlementsRequest_CALLER_ACCESS_TYPE_UNSPECIFIED
}

func (x *SearchEntitlementsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *SearchEntitlementsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchEntitlementsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `SearchEntitlements` method.
type SearchEntitlementsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of entitlements.
	Entitlements []*Entitlement `protobuf:"bytes,1,rep,name=entitlements,proto3" json:"entitlements,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchEntitlementsResponse) Reset() {
	*x = SearchEntitlementsResponse{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchEntitlementsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchEntitlementsResponse) ProtoMessage() {}

func (x *SearchEntitlementsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchEntitlementsResponse.ProtoReflect.Descriptor instead.
func (*SearchEntitlementsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{10}
}

func (x *SearchEntitlementsResponse) GetEntitlements() []*Entitlement {
	if x != nil {
		return x.Entitlements
	}
	return nil
}

func (x *SearchEntitlementsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting an entitlement.
type GetEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetEntitlementRequest) Reset() {
	*x = GetEntitlementRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetEntitlementRequest) ProtoMessage() {}

func (x *GetEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetEntitlementRequest.ProtoReflect.Descriptor instead.
func (*GetEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{11}
}

func (x *GetEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Message for creating an entitlement.
type CreateEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parent resource for the entitlement.
	// Possible formats:
	//
	// * `organizations/{organization-number}/locations/{region}`
	// * `folders/{folder-number}/locations/{region}`
	// * `projects/{project-id|project-number}/locations/{region}`
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The ID to use for this entitlement. This becomes the last part of
	// the resource name.
	//
	// This value should be 4-63 characters in length, and valid characters are
	// "[a-z]", "[0-9]", and "-". The first character should be from [a-z].
	//
	// This value should be unique among all other entitlements under the
	// specified `parent`.
	EntitlementId string `protobuf:"bytes,2,opt,name=entitlement_id,json=entitlementId,proto3" json:"entitlement_id,omitempty"`
	// Required. The resource being created
	Entitlement *Entitlement `protobuf:"bytes,3,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server knows to
	// ignore the request if it has already been completed. The server guarantees
	// this for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, ignores the second request and returns the
	// previous operation's response. This prevents clients from accidentally
	// creating duplicate entitlements.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,4,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateEntitlementRequest) Reset() {
	*x = CreateEntitlementRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[12]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateEntitlementRequest) ProtoMessage() {}

func (x *CreateEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[12]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateEntitlementRequest.ProtoReflect.Descriptor instead.
func (*CreateEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{12}
}

func (x *CreateEntitlementRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateEntitlementRequest) GetEntitlementId() string {
	if x != nil {
		return x.EntitlementId
	}
	return ""
}

func (x *CreateEntitlementRequest) GetEntitlement() *Entitlement {
	if x != nil {
		return x.Entitlement
	}
	return nil
}

func (x *CreateEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Message for deleting an entitlement.
type DeleteEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server knows to
	// ignore the request if it has already been completed. The server guarantees
	// this for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, ignores the second request.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,2,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
	// Optional. If set to true, any child grant under this entitlement is also
	// deleted. (Otherwise, the request only works if the entitlement has no child
	// grant.)
	Force bool `protobuf:"varint,3,opt,name=force,proto3" json:"force,omitempty"`
}

func (x *DeleteEntitlementRequest) Reset() {
	*x = DeleteEntitlementRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[13]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DeleteEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteEntitlementRequest) ProtoMessage() {}

func (x *DeleteEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[13]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteEntitlementRequest.ProtoReflect.Descriptor instead.
func (*DeleteEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteEntitlementRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DeleteEntitlementRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

func (x *DeleteEntitlementRequest) GetForce() bool {
	if x != nil {
		return x.Force
	}
	return false
}

// Message for updating an entitlement.
type UpdateEntitlementRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The entitlement resource that is updated.
	Entitlement *Entitlement `protobuf:"bytes,1,opt,name=entitlement,proto3" json:"entitlement,omitempty"`
	// Required. The list of fields to update. A field is overwritten if, and only
	// if, it is in the mask. Any immutable fields set in the mask are ignored by
	// the server. Repeated fields and map fields are only allowed in the last
	// position of a `paths` string and overwrite the existing values. Hence an
	// update to a repeated field or a map should contain the entire list of
	// values. The fields specified in the update_mask are relative to the
	// resource and not to the request.
	// (e.g. `MaxRequestDuration`; *not* `entitlement.MaxRequestDuration`)
	// A value of '*' for this field refers to full replacement of the resource.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,2,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateEntitlementRequest) Reset() {
	*x = UpdateEntitlementRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[14]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *UpdateEntitlementRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateEntitlementRequest) ProtoMessage() {}

func (x *UpdateEntitlementRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[14]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateEntitlementRequest.ProtoReflect.Descriptor instead.
func (*UpdateEntitlementRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateEntitlementRequest) GetEntitlement() *Entitlement {
	if x != nil {
		return x.Entitlement
	}
	return nil
}

func (x *UpdateEntitlementRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// A grant represents a request from a user for obtaining the access specified
// in an entitlement they are eligible for.
type Grant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Identifier. Name of this grant.
	// Possible formats:
	//
	// * `organizations/{organization-number}/locations/{region}/entitlements/{entitlement-id}/grants/{grant-id}`
	// * `folders/{folder-number}/locations/{region}/entitlements/{entitlement-id}/grants/{grant-id}`
	// * `projects/{project-id|project-number}/locations/{region}/entitlements/{entitlement-id}/grants/{grant-id}`
	//
	// The last segment of this name (`{grant-id}`) is autogenerated.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Create time stamp.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. Update time stamp.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,3,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Output only. Username of the user who created this grant.
	Requester string `protobuf:"bytes,4,opt,name=requester,proto3" json:"requester,omitempty"`
	// Required. The amount of time access is needed for. This value should be
	// less than the `max_request_duration` value of the entitlement.
	RequestedDuration *durationpb.Duration `protobuf:"bytes,5,opt,name=requested_duration,json=requestedDuration,proto3" json:"requested_duration,omitempty"`
	// Optional. Justification of why this access is needed.
	Justification *Justification `protobuf:"bytes,6,opt,name=justification,proto3" json:"justification,omitempty"`
	// Output only. Current state of this grant.
	State Grant_State `protobuf:"varint,7,opt,name=state,proto3,enum=google.cloud.privilegedaccessmanager.v1.Grant_State" json:"state,omitempty"`
	// Output only. Timeline of this grant.
	Timeline *Grant_Timeline `protobuf:"bytes,8,opt,name=timeline,proto3" json:"timeline,omitempty"`
	// Output only. The access that would be granted by this grant.
	PrivilegedAccess *PrivilegedAccess `protobuf:"bytes,9,opt,name=privileged_access,json=privilegedAccess,proto3" json:"privileged_access,omitempty"`
	// Output only. Audit trail of access provided by this grant. If unspecified
	// then access was never granted.
	AuditTrail *Grant_AuditTrail `protobuf:"bytes,10,opt,name=audit_trail,json=auditTrail,proto3" json:"audit_trail,omitempty"`
	// Optional. Additional email addresses to notify for all the actions
	// performed on the grant.
	AdditionalEmailRecipients []string `protobuf:"bytes,11,rep,name=additional_email_recipients,json=additionalEmailRecipients,proto3" json:"additional_email_recipients,omitempty"`
	// Output only. Flag set by the PAM system to indicate that policy bindings
	// made by this grant have been modified from outside PAM.
	//
	// After it is set, this flag remains set forever irrespective of the grant
	// state. A `true` value here indicates that PAM no longer has any certainty
	// on the access a user has because of this grant.
	ExternallyModified bool `protobuf:"varint,12,opt,name=externally_modified,json=externallyModified,proto3" json:"externally_modified,omitempty"`
}

func (x *Grant) Reset() {
	*x = Grant{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[15]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant) ProtoMessage() {}

func (x *Grant) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[15]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant.ProtoReflect.Descriptor instead.
func (*Grant) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15}
}

func (x *Grant) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Grant) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Grant) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Grant) GetRequester() string {
	if x != nil {
		return x.Requester
	}
	return ""
}

func (x *Grant) GetRequestedDuration() *durationpb.Duration {
	if x != nil {
		return x.RequestedDuration
	}
	return nil
}

func (x *Grant) GetJustification() *Justification {
	if x != nil {
		return x.Justification
	}
	return nil
}

func (x *Grant) GetState() Grant_State {
	if x != nil {
		return x.State
	}
	return Grant_STATE_UNSPECIFIED
}

func (x *Grant) GetTimeline() *Grant_Timeline {
	if x != nil {
		return x.Timeline
	}
	return nil
}

func (x *Grant) GetPrivilegedAccess() *PrivilegedAccess {
	if x != nil {
		return x.PrivilegedAccess
	}
	return nil
}

func (x *Grant) GetAuditTrail() *Grant_AuditTrail {
	if x != nil {
		return x.AuditTrail
	}
	return nil
}

func (x *Grant) GetAdditionalEmailRecipients() []string {
	if x != nil {
		return x.AdditionalEmailRecipients
	}
	return nil
}

func (x *Grant) GetExternallyModified() bool {
	if x != nil {
		return x.ExternallyModified
	}
	return false
}

// Justification represents a justification for requesting access.
type Justification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Justification:
	//
	//	*Justification_UnstructuredJustification
	Justification isJustification_Justification `protobuf_oneof:"justification"`
}

func (x *Justification) Reset() {
	*x = Justification{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[16]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Justification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Justification) ProtoMessage() {}

func (x *Justification) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[16]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Justification.ProtoReflect.Descriptor instead.
func (*Justification) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{16}
}

func (m *Justification) GetJustification() isJustification_Justification {
	if m != nil {
		return m.Justification
	}
	return nil
}

func (x *Justification) GetUnstructuredJustification() string {
	if x, ok := x.GetJustification().(*Justification_UnstructuredJustification); ok {
		return x.UnstructuredJustification
	}
	return ""
}

type isJustification_Justification interface {
	isJustification_Justification()
}

type Justification_UnstructuredJustification struct {
	// A free form textual justification. The system only ensures that this
	// is not empty. No other kind of validation is performed on the string.
	UnstructuredJustification string `protobuf:"bytes,1,opt,name=unstructured_justification,json=unstructuredJustification,proto3,oneof"`
}

func (*Justification_UnstructuredJustification) isJustification_Justification() {}

// Message for requesting list of grants.
type ListGrantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent resource which owns the grants.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Optional. Requested page size. The server may return fewer items than
	// requested. If unspecified, the server picks an appropriate default.
	PageSize int32 `protobuf:"varint,2,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// Optional. Filtering results.
	Filter string `protobuf:"bytes,4,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Hint for how to order the results
	OrderBy string `protobuf:"bytes,5,opt,name=order_by,json=orderBy,proto3" json:"order_by,omitempty"`
}

func (x *ListGrantsRequest) Reset() {
	*x = ListGrantsRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[17]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGrantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGrantsRequest) ProtoMessage() {}

func (x *ListGrantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[17]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGrantsRequest.ProtoReflect.Descriptor instead.
func (*ListGrantsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{17}
}

func (x *ListGrantsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *ListGrantsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *ListGrantsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *ListGrantsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *ListGrantsRequest) GetOrderBy() string {
	if x != nil {
		return x.OrderBy
	}
	return ""
}

// Message for response to listing grants.
type ListGrantsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of grants.
	Grants []*Grant `protobuf:"bytes,1,rep,name=grants,proto3" json:"grants,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
	// Locations that could not be reached.
	Unreachable []string `protobuf:"bytes,3,rep,name=unreachable,proto3" json:"unreachable,omitempty"`
}

func (x *ListGrantsResponse) Reset() {
	*x = ListGrantsResponse{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[18]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ListGrantsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ListGrantsResponse) ProtoMessage() {}

func (x *ListGrantsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[18]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ListGrantsResponse.ProtoReflect.Descriptor instead.
func (*ListGrantsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{18}
}

func (x *ListGrantsResponse) GetGrants() []*Grant {
	if x != nil {
		return x.Grants
	}
	return nil
}

func (x *ListGrantsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

func (x *ListGrantsResponse) GetUnreachable() []string {
	if x != nil {
		return x.Unreachable
	}
	return nil
}

// Request message for `SearchGrants` method.
type SearchGrantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The parent which owns the grant resources.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. Only grants which the caller is related to by this relationship
	// are returned in the response.
	CallerRelationship SearchGrantsRequest_CallerRelationshipType `protobuf:"varint,2,opt,name=caller_relationship,json=callerRelationship,proto3,enum=google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest_CallerRelationshipType" json:"caller_relationship,omitempty"`
	// Optional. Only grants matching this filter are returned in the response.
	Filter string `protobuf:"bytes,3,opt,name=filter,proto3" json:"filter,omitempty"`
	// Optional. Requested page size. The server may return fewer items than
	// requested. If unspecified, server picks an appropriate default.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// Optional. A token identifying a page of results the server should return.
	PageToken string `protobuf:"bytes,5,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
}

func (x *SearchGrantsRequest) Reset() {
	*x = SearchGrantsRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[19]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchGrantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchGrantsRequest) ProtoMessage() {}

func (x *SearchGrantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[19]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchGrantsRequest.ProtoReflect.Descriptor instead.
func (*SearchGrantsRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{19}
}

func (x *SearchGrantsRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *SearchGrantsRequest) GetCallerRelationship() SearchGrantsRequest_CallerRelationshipType {
	if x != nil {
		return x.CallerRelationship
	}
	return SearchGrantsRequest_CALLER_RELATIONSHIP_TYPE_UNSPECIFIED
}

func (x *SearchGrantsRequest) GetFilter() string {
	if x != nil {
		return x.Filter
	}
	return ""
}

func (x *SearchGrantsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchGrantsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

// Response message for `SearchGrants` method.
type SearchGrantsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of grants.
	Grants []*Grant `protobuf:"bytes,1,rep,name=grants,proto3" json:"grants,omitempty"`
	// A token identifying a page of results the server should return.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchGrantsResponse) Reset() {
	*x = SearchGrantsResponse{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[20]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *SearchGrantsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchGrantsResponse) ProtoMessage() {}

func (x *SearchGrantsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[20]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchGrantsResponse.ProtoReflect.Descriptor instead.
func (*SearchGrantsResponse) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{20}
}

func (x *SearchGrantsResponse) GetGrants() []*Grant {
	if x != nil {
		return x.Grants
	}
	return nil
}

func (x *SearchGrantsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// Message for getting a grant.
type GetGrantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the resource.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
}

func (x *GetGrantRequest) Reset() {
	*x = GetGrantRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[21]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *GetGrantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetGrantRequest) ProtoMessage() {}

func (x *GetGrantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[21]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetGrantRequest.ProtoReflect.Descriptor instead.
func (*GetGrantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{21}
}

func (x *GetGrantRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

// Request message for `ApproveGrant` method.
type ApproveGrantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the grant resource which is being approved.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The reason for approving this grant. This is required if the
	// `require_approver_justification` field of the `ManualApprovals` workflow
	// used in this grant is true.
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *ApproveGrantRequest) Reset() {
	*x = ApproveGrantRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[22]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ApproveGrantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApproveGrantRequest) ProtoMessage() {}

func (x *ApproveGrantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[22]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApproveGrantRequest.ProtoReflect.Descriptor instead.
func (*ApproveGrantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{22}
}

func (x *ApproveGrantRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *ApproveGrantRequest) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

// Request message for `DenyGrant` method.
type DenyGrantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the grant resource which is being denied.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The reason for denying this grant. This is required if
	// `require_approver_justification` field of the `ManualApprovals` workflow
	// used in this grant is true.
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *DenyGrantRequest) Reset() {
	*x = DenyGrantRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[23]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *DenyGrantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DenyGrantRequest) ProtoMessage() {}

func (x *DenyGrantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[23]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DenyGrantRequest.ProtoReflect.Descriptor instead.
func (*DenyGrantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{23}
}

func (x *DenyGrantRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *DenyGrantRequest) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

// Request message for `RevokeGrant` method.
type RevokeGrantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the grant resource which is being revoked.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Optional. The reason for revoking this grant.
	Reason string `protobuf:"bytes,2,opt,name=reason,proto3" json:"reason,omitempty"`
}

func (x *RevokeGrantRequest) Reset() {
	*x = RevokeGrantRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[24]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *RevokeGrantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*RevokeGrantRequest) ProtoMessage() {}

func (x *RevokeGrantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[24]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use RevokeGrantRequest.ProtoReflect.Descriptor instead.
func (*RevokeGrantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{24}
}

func (x *RevokeGrantRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *RevokeGrantRequest) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

// Message for creating a grant
type CreateGrantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Name of the parent entitlement for which this grant is being
	// requested.
	Parent string `protobuf:"bytes,1,opt,name=parent,proto3" json:"parent,omitempty"`
	// Required. The resource being created.
	Grant *Grant `protobuf:"bytes,2,opt,name=grant,proto3" json:"grant,omitempty"`
	// Optional. An optional request ID to identify requests. Specify a unique
	// request ID so that if you must retry your request, the server knows to
	// ignore the request if it has already been completed. The server guarantees
	// this for at least 60 minutes after the first request.
	//
	// For example, consider a situation where you make an initial request and the
	// request times out. If you make the request again with the same request
	// ID, the server can check if original operation with the same request ID
	// was received, and if so, ignores the second request. This prevents
	// clients from accidentally creating duplicate grants.
	//
	// The request ID must be a valid UUID with the exception that zero UUID is
	// not supported (00000000-0000-0000-0000-000000000000).
	RequestId string `protobuf:"bytes,3,opt,name=request_id,json=requestId,proto3" json:"request_id,omitempty"`
}

func (x *CreateGrantRequest) Reset() {
	*x = CreateGrantRequest{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[25]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CreateGrantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateGrantRequest) ProtoMessage() {}

func (x *CreateGrantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[25]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateGrantRequest.ProtoReflect.Descriptor instead.
func (*CreateGrantRequest) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{25}
}

func (x *CreateGrantRequest) GetParent() string {
	if x != nil {
		return x.Parent
	}
	return ""
}

func (x *CreateGrantRequest) GetGrant() *Grant {
	if x != nil {
		return x.Grant
	}
	return nil
}

func (x *CreateGrantRequest) GetRequestId() string {
	if x != nil {
		return x.RequestId
	}
	return ""
}

// Represents the metadata of the long-running operation.
type OperationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time the operation was created.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The time the operation finished running.
	EndTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=end_time,json=endTime,proto3" json:"end_time,omitempty"`
	// Output only. Server-defined resource path for the target of the operation.
	Target string `protobuf:"bytes,3,opt,name=target,proto3" json:"target,omitempty"`
	// Output only. Name of the verb executed by the operation.
	Verb string `protobuf:"bytes,4,opt,name=verb,proto3" json:"verb,omitempty"`
	// Output only. Human-readable status of the operation, if any.
	StatusMessage string `protobuf:"bytes,5,opt,name=status_message,json=statusMessage,proto3" json:"status_message,omitempty"`
	// Output only. Identifies whether the user has requested cancellation
	// of the operation. Operations that have been cancelled successfully
	// have [Operation.error][] value with a
	// [google.rpc.Status.code][google.rpc.Status.code] of 1, corresponding to
	// `Code.CANCELLED`.
	RequestedCancellation bool `protobuf:"varint,6,opt,name=requested_cancellation,json=requestedCancellation,proto3" json:"requested_cancellation,omitempty"`
	// Output only. API version used to start the operation.
	ApiVersion string `protobuf:"bytes,7,opt,name=api_version,json=apiVersion,proto3" json:"api_version,omitempty"`
}

func (x *OperationMetadata) Reset() {
	*x = OperationMetadata{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[26]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *OperationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*OperationMetadata) ProtoMessage() {}

func (x *OperationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[26]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use OperationMetadata.ProtoReflect.Descriptor instead.
func (*OperationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{26}
}

func (x *OperationMetadata) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *OperationMetadata) GetEndTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EndTime
	}
	return nil
}

func (x *OperationMetadata) GetTarget() string {
	if x != nil {
		return x.Target
	}
	return ""
}

func (x *OperationMetadata) GetVerb() string {
	if x != nil {
		return x.Verb
	}
	return ""
}

func (x *OperationMetadata) GetStatusMessage() string {
	if x != nil {
		return x.StatusMessage
	}
	return ""
}

func (x *OperationMetadata) GetRequestedCancellation() bool {
	if x != nil {
		return x.RequestedCancellation
	}
	return false
}

func (x *OperationMetadata) GetApiVersion() string {
	if x != nil {
		return x.ApiVersion
	}
	return ""
}

// Finding represents an issue which prevents PAM from functioning properly
// for this resource.
type CheckOnboardingStatusResponse_Finding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to FindingType:
	//
	//	*CheckOnboardingStatusResponse_Finding_IamAccessDenied
	FindingType isCheckOnboardingStatusResponse_Finding_FindingType `protobuf_oneof:"finding_type"`
}

func (x *CheckOnboardingStatusResponse_Finding) Reset() {
	*x = CheckOnboardingStatusResponse_Finding{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[27]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckOnboardingStatusResponse_Finding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckOnboardingStatusResponse_Finding) ProtoMessage() {}

func (x *CheckOnboardingStatusResponse_Finding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[27]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckOnboardingStatusResponse_Finding.ProtoReflect.Descriptor instead.
func (*CheckOnboardingStatusResponse_Finding) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{1, 0}
}

func (m *CheckOnboardingStatusResponse_Finding) GetFindingType() isCheckOnboardingStatusResponse_Finding_FindingType {
	if m != nil {
		return m.FindingType
	}
	return nil
}

func (x *CheckOnboardingStatusResponse_Finding) GetIamAccessDenied() *CheckOnboardingStatusResponse_Finding_IAMAccessDenied {
	if x, ok := x.GetFindingType().(*CheckOnboardingStatusResponse_Finding_IamAccessDenied); ok {
		return x.IamAccessDenied
	}
	return nil
}

type isCheckOnboardingStatusResponse_Finding_FindingType interface {
	isCheckOnboardingStatusResponse_Finding_FindingType()
}

type CheckOnboardingStatusResponse_Finding_IamAccessDenied struct {
	// PAM's service account is being denied access by Cloud IAM.
	IamAccessDenied *CheckOnboardingStatusResponse_Finding_IAMAccessDenied `protobuf:"bytes,1,opt,name=iam_access_denied,json=iamAccessDenied,proto3,oneof"`
}

func (*CheckOnboardingStatusResponse_Finding_IamAccessDenied) isCheckOnboardingStatusResponse_Finding_FindingType() {
}

// PAM's service account is being denied access by Cloud IAM.
// This can be fixed by granting a role that contains the missing
// permissions to the service account or exempting it from deny policies if
// they are blocking the access.
type CheckOnboardingStatusResponse_Finding_IAMAccessDenied struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of permissions that are being denied.
	MissingPermissions []string `protobuf:"bytes,1,rep,name=missing_permissions,json=missingPermissions,proto3" json:"missing_permissions,omitempty"`
}

func (x *CheckOnboardingStatusResponse_Finding_IAMAccessDenied) Reset() {
	*x = CheckOnboardingStatusResponse_Finding_IAMAccessDenied{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[28]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *CheckOnboardingStatusResponse_Finding_IAMAccessDenied) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CheckOnboardingStatusResponse_Finding_IAMAccessDenied) ProtoMessage() {}

func (x *CheckOnboardingStatusResponse_Finding_IAMAccessDenied) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[28]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CheckOnboardingStatusResponse_Finding_IAMAccessDenied.ProtoReflect.Descriptor instead.
func (*CheckOnboardingStatusResponse_Finding_IAMAccessDenied) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{1, 0, 0}
}

func (x *CheckOnboardingStatusResponse_Finding_IAMAccessDenied) GetMissingPermissions() []string {
	if x != nil {
		return x.MissingPermissions
	}
	return nil
}

// Defines how a requester must provide a justification when requesting
// access.
type Entitlement_RequesterJustificationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// This is a required field and the user must explicitly opt out if a
	// justification from the requester isn't mandatory.
	//
	// Types that are assignable to JustificationType:
	//
	//	*Entitlement_RequesterJustificationConfig_NotMandatory_
	//	*Entitlement_RequesterJustificationConfig_Unstructured_
	JustificationType isEntitlement_RequesterJustificationConfig_JustificationType `protobuf_oneof:"justification_type"`
}

func (x *Entitlement_RequesterJustificationConfig) Reset() {
	*x = Entitlement_RequesterJustificationConfig{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[29]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entitlement_RequesterJustificationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entitlement_RequesterJustificationConfig) ProtoMessage() {}

func (x *Entitlement_RequesterJustificationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[29]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entitlement_RequesterJustificationConfig.ProtoReflect.Descriptor instead.
func (*Entitlement_RequesterJustificationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{2, 0}
}

func (m *Entitlement_RequesterJustificationConfig) GetJustificationType() isEntitlement_RequesterJustificationConfig_JustificationType {
	if m != nil {
		return m.JustificationType
	}
	return nil
}

func (x *Entitlement_RequesterJustificationConfig) GetNotMandatory() *Entitlement_RequesterJustificationConfig_NotMandatory {
	if x, ok := x.GetJustificationType().(*Entitlement_RequesterJustificationConfig_NotMandatory_); ok {
		return x.NotMandatory
	}
	return nil
}

func (x *Entitlement_RequesterJustificationConfig) GetUnstructured() *Entitlement_RequesterJustificationConfig_Unstructured {
	if x, ok := x.GetJustificationType().(*Entitlement_RequesterJustificationConfig_Unstructured_); ok {
		return x.Unstructured
	}
	return nil
}

type isEntitlement_RequesterJustificationConfig_JustificationType interface {
	isEntitlement_RequesterJustificationConfig_JustificationType()
}

type Entitlement_RequesterJustificationConfig_NotMandatory_ struct {
	// This option means the requester isn't required to provide a
	// justification.
	NotMandatory *Entitlement_RequesterJustificationConfig_NotMandatory `protobuf:"bytes,1,opt,name=not_mandatory,json=notMandatory,proto3,oneof"`
}

type Entitlement_RequesterJustificationConfig_Unstructured_ struct {
	// This option means the requester must provide a string as
	// justification. If this is selected, the server allows the requester
	// to provide a justification but doesn't validate it.
	Unstructured *Entitlement_RequesterJustificationConfig_Unstructured `protobuf:"bytes,2,opt,name=unstructured,proto3,oneof"`
}

func (*Entitlement_RequesterJustificationConfig_NotMandatory_) isEntitlement_RequesterJustificationConfig_JustificationType() {
}

func (*Entitlement_RequesterJustificationConfig_Unstructured_) isEntitlement_RequesterJustificationConfig_JustificationType() {
}

// `AdditionalNotificationTargets` includes email addresses to be notified.
type Entitlement_AdditionalNotificationTargets struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Additional email addresses to be notified when a principal
	// (requester) is granted access.
	AdminEmailRecipients []string `protobuf:"bytes,1,rep,name=admin_email_recipients,json=adminEmailRecipients,proto3" json:"admin_email_recipients,omitempty"`
	// Optional. Additional email address to be notified about an eligible
	// entitlement.
	RequesterEmailRecipients []string `protobuf:"bytes,2,rep,name=requester_email_recipients,json=requesterEmailRecipients,proto3" json:"requester_email_recipients,omitempty"`
}

func (x *Entitlement_AdditionalNotificationTargets) Reset() {
	*x = Entitlement_AdditionalNotificationTargets{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[30]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entitlement_AdditionalNotificationTargets) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entitlement_AdditionalNotificationTargets) ProtoMessage() {}

func (x *Entitlement_AdditionalNotificationTargets) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[30]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entitlement_AdditionalNotificationTargets.ProtoReflect.Descriptor instead.
func (*Entitlement_AdditionalNotificationTargets) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{2, 1}
}

func (x *Entitlement_AdditionalNotificationTargets) GetAdminEmailRecipients() []string {
	if x != nil {
		return x.AdminEmailRecipients
	}
	return nil
}

func (x *Entitlement_AdditionalNotificationTargets) GetRequesterEmailRecipients() []string {
	if x != nil {
		return x.RequesterEmailRecipients
	}
	return nil
}

// The justification is not mandatory but can be provided in any of the
// supported formats.
type Entitlement_RequesterJustificationConfig_NotMandatory struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Entitlement_RequesterJustificationConfig_NotMandatory) Reset() {
	*x = Entitlement_RequesterJustificationConfig_NotMandatory{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[31]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entitlement_RequesterJustificationConfig_NotMandatory) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entitlement_RequesterJustificationConfig_NotMandatory) ProtoMessage() {}

func (x *Entitlement_RequesterJustificationConfig_NotMandatory) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[31]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entitlement_RequesterJustificationConfig_NotMandatory.ProtoReflect.Descriptor instead.
func (*Entitlement_RequesterJustificationConfig_NotMandatory) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{2, 0, 0}
}

// The requester has to provide a justification in the form of a string.
type Entitlement_RequesterJustificationConfig_Unstructured struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Entitlement_RequesterJustificationConfig_Unstructured) Reset() {
	*x = Entitlement_RequesterJustificationConfig_Unstructured{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[32]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Entitlement_RequesterJustificationConfig_Unstructured) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Entitlement_RequesterJustificationConfig_Unstructured) ProtoMessage() {}

func (x *Entitlement_RequesterJustificationConfig_Unstructured) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[32]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Entitlement_RequesterJustificationConfig_Unstructured.ProtoReflect.Descriptor instead.
func (*Entitlement_RequesterJustificationConfig_Unstructured) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{2, 0, 1}
}

// Step represents a logical step in a manual approval workflow.
type ManualApprovals_Step struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The potential set of approvers in this step. This list must
	// contain at most one entry.
	Approvers []*AccessControlEntry `protobuf:"bytes,1,rep,name=approvers,proto3" json:"approvers,omitempty"`
	// Required. How many users from the above list need to approve. If there
	// aren't enough distinct users in the list, then the workflow indefinitely
	// blocks. Should always be greater than 0. 1 is the only supported value.
	ApprovalsNeeded int32 `protobuf:"varint,2,opt,name=approvals_needed,json=approvalsNeeded,proto3" json:"approvals_needed,omitempty"`
	// Optional. Additional email addresses to be notified when a grant is
	// pending approval.
	ApproverEmailRecipients []string `protobuf:"bytes,3,rep,name=approver_email_recipients,json=approverEmailRecipients,proto3" json:"approver_email_recipients,omitempty"`
}

func (x *ManualApprovals_Step) Reset() {
	*x = ManualApprovals_Step{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[33]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ManualApprovals_Step) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ManualApprovals_Step) ProtoMessage() {}

func (x *ManualApprovals_Step) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[33]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ManualApprovals_Step.ProtoReflect.Descriptor instead.
func (*ManualApprovals_Step) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{5, 0}
}

func (x *ManualApprovals_Step) GetApprovers() []*AccessControlEntry {
	if x != nil {
		return x.Approvers
	}
	return nil
}

func (x *ManualApprovals_Step) GetApprovalsNeeded() int32 {
	if x != nil {
		return x.ApprovalsNeeded
	}
	return 0
}

func (x *ManualApprovals_Step) GetApproverEmailRecipients() []string {
	if x != nil {
		return x.ApproverEmailRecipients
	}
	return nil
}

// `GcpIamAccess` represents IAM based access control on a Google Cloud
// resource. Refer to https://cloud.google.com/iam/docs to understand more
// about IAM.
type PrivilegedAccess_GcpIamAccess struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The type of this resource.
	ResourceType string `protobuf:"bytes,1,opt,name=resource_type,json=resourceType,proto3" json:"resource_type,omitempty"`
	// Required. Name of the resource.
	Resource string `protobuf:"bytes,2,opt,name=resource,proto3" json:"resource,omitempty"`
	// Required. Role bindings that are created on successful grant.
	RoleBindings []*PrivilegedAccess_GcpIamAccess_RoleBinding `protobuf:"bytes,4,rep,name=role_bindings,json=roleBindings,proto3" json:"role_bindings,omitempty"`
}

func (x *PrivilegedAccess_GcpIamAccess) Reset() {
	*x = PrivilegedAccess_GcpIamAccess{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[34]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivilegedAccess_GcpIamAccess) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivilegedAccess_GcpIamAccess) ProtoMessage() {}

func (x *PrivilegedAccess_GcpIamAccess) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[34]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivilegedAccess_GcpIamAccess.ProtoReflect.Descriptor instead.
func (*PrivilegedAccess_GcpIamAccess) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{6, 0}
}

func (x *PrivilegedAccess_GcpIamAccess) GetResourceType() string {
	if x != nil {
		return x.ResourceType
	}
	return ""
}

func (x *PrivilegedAccess_GcpIamAccess) GetResource() string {
	if x != nil {
		return x.Resource
	}
	return ""
}

func (x *PrivilegedAccess_GcpIamAccess) GetRoleBindings() []*PrivilegedAccess_GcpIamAccess_RoleBinding {
	if x != nil {
		return x.RoleBindings
	}
	return nil
}

// IAM role bindings that are created after a successful grant.
type PrivilegedAccess_GcpIamAccess_RoleBinding struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. IAM role to be granted.
	// https://cloud.google.com/iam/docs/roles-overview.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// Optional. The expression field of the IAM condition to be associated
	// with the role. If specified, a user with an active grant for this
	// entitlement is able to access the resource only if this condition
	// evaluates to true for their request.
	//
	// This field uses the same CEL format as IAM and supports all attributes
	// that IAM supports, except tags.
	// https://cloud.google.com/iam/docs/conditions-overview#attributes.
	ConditionExpression string `protobuf:"bytes,2,opt,name=condition_expression,json=conditionExpression,proto3" json:"condition_expression,omitempty"`
}

func (x *PrivilegedAccess_GcpIamAccess_RoleBinding) Reset() {
	*x = PrivilegedAccess_GcpIamAccess_RoleBinding{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[35]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *PrivilegedAccess_GcpIamAccess_RoleBinding) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PrivilegedAccess_GcpIamAccess_RoleBinding) ProtoMessage() {}

func (x *PrivilegedAccess_GcpIamAccess_RoleBinding) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[35]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PrivilegedAccess_GcpIamAccess_RoleBinding.ProtoReflect.Descriptor instead.
func (*PrivilegedAccess_GcpIamAccess_RoleBinding) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{6, 0, 0}
}

func (x *PrivilegedAccess_GcpIamAccess_RoleBinding) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *PrivilegedAccess_GcpIamAccess_RoleBinding) GetConditionExpression() string {
	if x != nil {
		return x.ConditionExpression
	}
	return ""
}

// Timeline of a grant describing what happened to it and when.
type Grant_Timeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The events that have occurred on this grant. This list
	// contains entries in the same order as they occurred. The first entry is
	// always be of type `Requested` and there is always at least one entry in
	// this array.
	Events []*Grant_Timeline_Event `protobuf:"bytes,1,rep,name=events,proto3" json:"events,omitempty"`
}

func (x *Grant_Timeline) Reset() {
	*x = Grant_Timeline{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[36]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline) ProtoMessage() {}

func (x *Grant_Timeline) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[36]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline.ProtoReflect.Descriptor instead.
func (*Grant_Timeline) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0}
}

func (x *Grant_Timeline) GetEvents() []*Grant_Timeline_Event {
	if x != nil {
		return x.Events
	}
	return nil
}

// Audit trail for the access provided by this grant.
type Grant_AuditTrail struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which access was given.
	AccessGrantTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=access_grant_time,json=accessGrantTime,proto3" json:"access_grant_time,omitempty"`
	// Output only. The time at which the system removed access. This could be
	// because of an automatic expiry or because of a revocation.
	//
	// If unspecified, then access hasn't been removed yet.
	AccessRemoveTime *timestamppb.Timestamp `protobuf:"bytes,2,opt,name=access_remove_time,json=accessRemoveTime,proto3" json:"access_remove_time,omitempty"`
}

func (x *Grant_AuditTrail) Reset() {
	*x = Grant_AuditTrail{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[37]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_AuditTrail) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_AuditTrail) ProtoMessage() {}

func (x *Grant_AuditTrail) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[37]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_AuditTrail.ProtoReflect.Descriptor instead.
func (*Grant_AuditTrail) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 1}
}

func (x *Grant_AuditTrail) GetAccessGrantTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AccessGrantTime
	}
	return nil
}

func (x *Grant_AuditTrail) GetAccessRemoveTime() *timestamppb.Timestamp {
	if x != nil {
		return x.AccessRemoveTime
	}
	return nil
}

// A single operation on the grant.
type Grant_Timeline_Event struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Event:
	//
	//	*Grant_Timeline_Event_Requested_
	//	*Grant_Timeline_Event_Approved_
	//	*Grant_Timeline_Event_Denied_
	//	*Grant_Timeline_Event_Revoked_
	//	*Grant_Timeline_Event_Scheduled_
	//	*Grant_Timeline_Event_Activated_
	//	*Grant_Timeline_Event_ActivationFailed_
	//	*Grant_Timeline_Event_Expired_
	//	*Grant_Timeline_Event_Ended_
	//	*Grant_Timeline_Event_ExternallyModified_
	Event isGrant_Timeline_Event_Event `protobuf_oneof:"event"`
	// Output only. The time (as recorded at server) when this event occurred.
	EventTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=event_time,json=eventTime,proto3" json:"event_time,omitempty"`
}

func (x *Grant_Timeline_Event) Reset() {
	*x = Grant_Timeline_Event{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[38]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event) ProtoMessage() {}

func (x *Grant_Timeline_Event) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[38]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0}
}

func (m *Grant_Timeline_Event) GetEvent() isGrant_Timeline_Event_Event {
	if m != nil {
		return m.Event
	}
	return nil
}

func (x *Grant_Timeline_Event) GetRequested() *Grant_Timeline_Event_Requested {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_Requested_); ok {
		return x.Requested
	}
	return nil
}

func (x *Grant_Timeline_Event) GetApproved() *Grant_Timeline_Event_Approved {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_Approved_); ok {
		return x.Approved
	}
	return nil
}

func (x *Grant_Timeline_Event) GetDenied() *Grant_Timeline_Event_Denied {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_Denied_); ok {
		return x.Denied
	}
	return nil
}

func (x *Grant_Timeline_Event) GetRevoked() *Grant_Timeline_Event_Revoked {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_Revoked_); ok {
		return x.Revoked
	}
	return nil
}

func (x *Grant_Timeline_Event) GetScheduled() *Grant_Timeline_Event_Scheduled {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_Scheduled_); ok {
		return x.Scheduled
	}
	return nil
}

func (x *Grant_Timeline_Event) GetActivated() *Grant_Timeline_Event_Activated {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_Activated_); ok {
		return x.Activated
	}
	return nil
}

func (x *Grant_Timeline_Event) GetActivationFailed() *Grant_Timeline_Event_ActivationFailed {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_ActivationFailed_); ok {
		return x.ActivationFailed
	}
	return nil
}

func (x *Grant_Timeline_Event) GetExpired() *Grant_Timeline_Event_Expired {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_Expired_); ok {
		return x.Expired
	}
	return nil
}

func (x *Grant_Timeline_Event) GetEnded() *Grant_Timeline_Event_Ended {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_Ended_); ok {
		return x.Ended
	}
	return nil
}

func (x *Grant_Timeline_Event) GetExternallyModified() *Grant_Timeline_Event_ExternallyModified {
	if x, ok := x.GetEvent().(*Grant_Timeline_Event_ExternallyModified_); ok {
		return x.ExternallyModified
	}
	return nil
}

func (x *Grant_Timeline_Event) GetEventTime() *timestamppb.Timestamp {
	if x != nil {
		return x.EventTime
	}
	return nil
}

type isGrant_Timeline_Event_Event interface {
	isGrant_Timeline_Event_Event()
}

type Grant_Timeline_Event_Requested_ struct {
	// The grant was requested.
	Requested *Grant_Timeline_Event_Requested `protobuf:"bytes,2,opt,name=requested,proto3,oneof"`
}

type Grant_Timeline_Event_Approved_ struct {
	// The grant was approved.
	Approved *Grant_Timeline_Event_Approved `protobuf:"bytes,3,opt,name=approved,proto3,oneof"`
}

type Grant_Timeline_Event_Denied_ struct {
	// The grant was denied.
	Denied *Grant_Timeline_Event_Denied `protobuf:"bytes,4,opt,name=denied,proto3,oneof"`
}

type Grant_Timeline_Event_Revoked_ struct {
	// The grant was revoked.
	Revoked *Grant_Timeline_Event_Revoked `protobuf:"bytes,5,opt,name=revoked,proto3,oneof"`
}

type Grant_Timeline_Event_Scheduled_ struct {
	// The grant has been scheduled to give access.
	Scheduled *Grant_Timeline_Event_Scheduled `protobuf:"bytes,6,opt,name=scheduled,proto3,oneof"`
}

type Grant_Timeline_Event_Activated_ struct {
	// The grant was successfully activated to give access.
	Activated *Grant_Timeline_Event_Activated `protobuf:"bytes,7,opt,name=activated,proto3,oneof"`
}

type Grant_Timeline_Event_ActivationFailed_ struct {
	// There was a non-retriable error while trying to give access.
	ActivationFailed *Grant_Timeline_Event_ActivationFailed `protobuf:"bytes,8,opt,name=activation_failed,json=activationFailed,proto3,oneof"`
}

type Grant_Timeline_Event_Expired_ struct {
	// The approval workflow did not complete in the necessary duration,
	// and so the grant is expired.
	Expired *Grant_Timeline_Event_Expired `protobuf:"bytes,10,opt,name=expired,proto3,oneof"`
}

type Grant_Timeline_Event_Ended_ struct {
	// Access given by the grant ended automatically as the approved
	// duration was over.
	Ended *Grant_Timeline_Event_Ended `protobuf:"bytes,11,opt,name=ended,proto3,oneof"`
}

type Grant_Timeline_Event_ExternallyModified_ struct {
	// The policy bindings made by grant have been modified outside of PAM.
	ExternallyModified *Grant_Timeline_Event_ExternallyModified `protobuf:"bytes,12,opt,name=externally_modified,json=externallyModified,proto3,oneof"`
}

func (*Grant_Timeline_Event_Requested_) isGrant_Timeline_Event_Event() {}

func (*Grant_Timeline_Event_Approved_) isGrant_Timeline_Event_Event() {}

func (*Grant_Timeline_Event_Denied_) isGrant_Timeline_Event_Event() {}

func (*Grant_Timeline_Event_Revoked_) isGrant_Timeline_Event_Event() {}

func (*Grant_Timeline_Event_Scheduled_) isGrant_Timeline_Event_Event() {}

func (*Grant_Timeline_Event_Activated_) isGrant_Timeline_Event_Event() {}

func (*Grant_Timeline_Event_ActivationFailed_) isGrant_Timeline_Event_Event() {}

func (*Grant_Timeline_Event_Expired_) isGrant_Timeline_Event_Event() {}

func (*Grant_Timeline_Event_Ended_) isGrant_Timeline_Event_Event() {}

func (*Grant_Timeline_Event_ExternallyModified_) isGrant_Timeline_Event_Event() {}

// An event representing that a grant was requested.
type Grant_Timeline_Event_Requested struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which this grant expires unless the approval
	// workflow completes. If omitted, then the request never expires.
	ExpireTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=expire_time,json=expireTime,proto3" json:"expire_time,omitempty"`
}

func (x *Grant_Timeline_Event_Requested) Reset() {
	*x = Grant_Timeline_Event_Requested{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[39]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_Requested) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_Requested) ProtoMessage() {}

func (x *Grant_Timeline_Event_Requested) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[39]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_Requested.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_Requested) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 0}
}

func (x *Grant_Timeline_Event_Requested) GetExpireTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ExpireTime
	}
	return nil
}

// An event representing that the grant was approved.
type Grant_Timeline_Event_Approved struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The reason provided by the approver for approving the
	// grant.
	Reason string `protobuf:"bytes,1,opt,name=reason,proto3" json:"reason,omitempty"`
	// Output only. Username of the user who approved the grant.
	Actor string `protobuf:"bytes,2,opt,name=actor,proto3" json:"actor,omitempty"`
}

func (x *Grant_Timeline_Event_Approved) Reset() {
	*x = Grant_Timeline_Event_Approved{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[40]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_Approved) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_Approved) ProtoMessage() {}

func (x *Grant_Timeline_Event_Approved) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[40]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_Approved.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_Approved) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 1}
}

func (x *Grant_Timeline_Event_Approved) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *Grant_Timeline_Event_Approved) GetActor() string {
	if x != nil {
		return x.Actor
	}
	return ""
}

// An event representing that the grant was denied.
type Grant_Timeline_Event_Denied struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The reason provided by the approver for denying the
	// grant.
	Reason string `protobuf:"bytes,1,opt,name=reason,proto3" json:"reason,omitempty"`
	// Output only. Username of the user who denied the grant.
	Actor string `protobuf:"bytes,2,opt,name=actor,proto3" json:"actor,omitempty"`
}

func (x *Grant_Timeline_Event_Denied) Reset() {
	*x = Grant_Timeline_Event_Denied{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[41]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_Denied) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_Denied) ProtoMessage() {}

func (x *Grant_Timeline_Event_Denied) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[41]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_Denied.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_Denied) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 2}
}

func (x *Grant_Timeline_Event_Denied) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *Grant_Timeline_Event_Denied) GetActor() string {
	if x != nil {
		return x.Actor
	}
	return ""
}

// An event representing that the grant was revoked.
type Grant_Timeline_Event_Revoked struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The reason provided by the user for revoking the grant.
	Reason string `protobuf:"bytes,1,opt,name=reason,proto3" json:"reason,omitempty"`
	// Output only. Username of the user who revoked the grant.
	Actor string `protobuf:"bytes,2,opt,name=actor,proto3" json:"actor,omitempty"`
}

func (x *Grant_Timeline_Event_Revoked) Reset() {
	*x = Grant_Timeline_Event_Revoked{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[42]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_Revoked) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_Revoked) ProtoMessage() {}

func (x *Grant_Timeline_Event_Revoked) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[42]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_Revoked.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_Revoked) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 3}
}

func (x *Grant_Timeline_Event_Revoked) GetReason() string {
	if x != nil {
		return x.Reason
	}
	return ""
}

func (x *Grant_Timeline_Event_Revoked) GetActor() string {
	if x != nil {
		return x.Actor
	}
	return ""
}

// An event representing that the grant has been scheduled to be
// activated later.
type Grant_Timeline_Event_Scheduled struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The time at which the access is granted.
	ScheduledActivationTime *timestamppb.Timestamp `protobuf:"bytes,1,opt,name=scheduled_activation_time,json=scheduledActivationTime,proto3" json:"scheduled_activation_time,omitempty"`
}

func (x *Grant_Timeline_Event_Scheduled) Reset() {
	*x = Grant_Timeline_Event_Scheduled{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[43]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_Scheduled) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_Scheduled) ProtoMessage() {}

func (x *Grant_Timeline_Event_Scheduled) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[43]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_Scheduled.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_Scheduled) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 4}
}

func (x *Grant_Timeline_Event_Scheduled) GetScheduledActivationTime() *timestamppb.Timestamp {
	if x != nil {
		return x.ScheduledActivationTime
	}
	return nil
}

// An event representing that the grant was successfully
// activated.
type Grant_Timeline_Event_Activated struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Grant_Timeline_Event_Activated) Reset() {
	*x = Grant_Timeline_Event_Activated{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[44]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_Activated) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_Activated) ProtoMessage() {}

func (x *Grant_Timeline_Event_Activated) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[44]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_Activated.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_Activated) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 5}
}

// An event representing that the grant activation failed.
type Grant_Timeline_Event_ActivationFailed struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. The error that occurred while activating the grant.
	Error *status.Status `protobuf:"bytes,1,opt,name=error,proto3" json:"error,omitempty"`
}

func (x *Grant_Timeline_Event_ActivationFailed) Reset() {
	*x = Grant_Timeline_Event_ActivationFailed{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[45]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_ActivationFailed) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_ActivationFailed) ProtoMessage() {}

func (x *Grant_Timeline_Event_ActivationFailed) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[45]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_ActivationFailed.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_ActivationFailed) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 6}
}

func (x *Grant_Timeline_Event_ActivationFailed) GetError() *status.Status {
	if x != nil {
		return x.Error
	}
	return nil
}

// An event representing that the grant was expired.
type Grant_Timeline_Event_Expired struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Grant_Timeline_Event_Expired) Reset() {
	*x = Grant_Timeline_Event_Expired{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[46]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_Expired) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_Expired) ProtoMessage() {}

func (x *Grant_Timeline_Event_Expired) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[46]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_Expired.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_Expired) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 7}
}

// An event representing that the grant has ended.
type Grant_Timeline_Event_Ended struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Grant_Timeline_Event_Ended) Reset() {
	*x = Grant_Timeline_Event_Ended{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[47]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_Ended) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_Ended) ProtoMessage() {}

func (x *Grant_Timeline_Event_Ended) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[47]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_Ended.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_Ended) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 8}
}

// An event representing that the policy bindings made by this grant were
// modified externally.
type Grant_Timeline_Event_ExternallyModified struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields
}

func (x *Grant_Timeline_Event_ExternallyModified) Reset() {
	*x = Grant_Timeline_Event_ExternallyModified{}
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[48]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Grant_Timeline_Event_ExternallyModified) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Grant_Timeline_Event_ExternallyModified) ProtoMessage() {}

func (x *Grant_Timeline_Event_ExternallyModified) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[48]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Grant_Timeline_Event_ExternallyModified.ProtoReflect.Descriptor instead.
func (*Grant_Timeline_Event_ExternallyModified) Descriptor() ([]byte, []int) {
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP(), []int{15, 0, 0, 9}
}

var File_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto protoreflect.FileDescriptor

var file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDesc = []byte{
	0x0a, 0x45, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x70,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x27, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e,
	0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x63, 0x6c, 0x69, 0x65, 0x6e,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69,
	0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f,
	0x6d, 0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x74, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x22, 0x72, 0x0a, 0x1c, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x4f, 0x6e, 0x62,
	0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32, 0x70, 0x72,
	0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x22, 0xa3, 0x03, 0x0a, 0x1d, 0x43, 0x68, 0x65,
	0x63, 0x6b, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74,
	0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x27, 0x0a, 0x0f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x12, 0x6a, 0x0a, 0x08, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18,
	0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x43, 0x68, 0x65, 0x63, 0x6b, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e, 0x46, 0x69,
	0x6e, 0x64, 0x69, 0x6e, 0x67, 0x52, 0x08, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x1a,
	0xec, 0x01, 0x0a, 0x07, 0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x8c, 0x01, 0x0a, 0x11,
	0x69, 0x61, 0x6d, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x64, 0x65, 0x6e, 0x69, 0x65,
	0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65,
	0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e,
	0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x2e,
	0x46, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x2e, 0x49, 0x41, 0x4d, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0f, 0x69, 0x61, 0x6d, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x1a, 0x42, 0x0a, 0x0f, 0x49, 0x41,
	0x4d, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x12, 0x2f, 0x0a,
	0x13, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6e, 0x67, 0x5f, 0x70, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6f, 0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x12, 0x6d, 0x69, 0x73, 0x73,
	0x69, 0x6e, 0x67, 0x50, 0x65, 0x72, 0x6d, 0x69, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x73, 0x42, 0x0e,
	0x0a, 0x0c, 0x66, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xfc,
	0x0e, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x17,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x67, 0x0a, 0x0e, 0x65,
	0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x5f, 0x75, 0x73, 0x65, 0x72, 0x73, 0x18, 0x05, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x65, 0x6c, 0x69, 0x67, 0x69, 0x62, 0x6c, 0x65, 0x55,
	0x73, 0x65, 0x72, 0x73, 0x12, 0x6b, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76,
	0x61, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52,
	0x10, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f,
	0x77, 0x12, 0x66, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x5f,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65,
	0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52, 0x10, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65,
	0x67, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x12, 0x50, 0x0a, 0x14, 0x6d, 0x61, 0x78,
	0x5f, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x6d, 0x61, 0x78, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x55, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3a, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x12, 0x9c, 0x01, 0x0a, 0x1e, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72,
	0x5f, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x51, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72, 0x4a, 0x75, 0x73, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x1c, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72, 0x4a, 0x75,
	0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x12, 0x9f, 0x01, 0x0a, 0x1f, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x73, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x2e, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x1d, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67,
	0x65, 0x74, 0x73, 0x12, 0x12, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67, 0x1a, 0xe3, 0x02, 0x0a, 0x1c, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x65, 0x72, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x85, 0x01, 0x0a, 0x0d, 0x6e, 0x6f, 0x74,
	0x5f, 0x6d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72,
	0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x4e, 0x6f, 0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x6f, 0x72, 0x79,
	0x48, 0x00, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x4d, 0x61, 0x6e, 0x64, 0x61, 0x74, 0x6f, 0x72, 0x79,
	0x12, 0x84, 0x01, 0x0a, 0x0c, 0x75, 0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x5e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65,
	0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x55, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x48, 0x00, 0x52, 0x0c, 0x75, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x1a, 0x0e, 0x0a, 0x0c, 0x4e, 0x6f, 0x74, 0x4d, 0x61,
	0x6e, 0x64, 0x61, 0x74, 0x6f, 0x72, 0x79, 0x1a, 0x0e, 0x0a, 0x0c, 0x55, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x42, 0x14, 0x0a, 0x12, 0x6a, 0x75, 0x73, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x1a, 0x9d, 0x01,
	0x0a, 0x1d, 0x41, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x4e, 0x6f, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x61, 0x72, 0x67, 0x65, 0x74, 0x73, 0x12,
	0x39, 0x0a, 0x16, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x72,
	0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x14, 0x61, 0x64, 0x6d, 0x69, 0x6e, 0x45, 0x6d, 0x61, 0x69, 0x6c,
	0x52, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x41, 0x0a, 0x1a, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x72, 0x65,
	0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x18, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72, 0x45, 0x6d,
	0x61, 0x69, 0x6c, 0x52, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x22, 0x64, 0x0a,
	0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0c, 0x0a,
	0x08, 0x43, 0x52, 0x45, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x01, 0x12, 0x0d, 0x0a, 0x09, 0x41,
	0x56, 0x41, 0x49, 0x4c, 0x41, 0x42, 0x4c, 0x45, 0x10, 0x02, 0x12, 0x0c, 0x0a, 0x08, 0x44, 0x45,
	0x4c, 0x45, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x12, 0x0b, 0x0a, 0x07, 0x44, 0x45, 0x4c, 0x45,
	0x54, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0c, 0x0a, 0x08, 0x55, 0x50, 0x44, 0x41, 0x54, 0x49, 0x4e,
	0x47, 0x10, 0x05, 0x3a, 0xa7, 0x02, 0xea, 0x41, 0xa3, 0x02, 0x0a, 0x32, 0x70, 0x72, 0x69, 0x76,
	0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x42,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63,
	0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x7d, 0x12, 0x40, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x7d, 0x12, 0x4c, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x7d, 0x2a, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x32, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x39, 0x0a,
	0x12, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43, 0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x12, 0x23, 0x0a, 0x0a, 0x70, 0x72, 0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0a, 0x70, 0x72,
	0x69, 0x6e, 0x63, 0x69, 0x70, 0x61, 0x6c, 0x73, 0x22, 0x8e, 0x01, 0x0a, 0x10, 0x41, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x61, 0x6c, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x65, 0x0a,
	0x10, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65,
	0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x73, 0x48, 0x00, 0x52, 0x0f, 0x6d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x41, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x61, 0x6c, 0x73, 0x42, 0x13, 0x0a, 0x11, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x5f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x22, 0x90, 0x03, 0x0a, 0x0f, 0x4d, 0x61,
	0x6e, 0x75, 0x61, 0x6c, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x73, 0x12, 0x49, 0x0a,
	0x1e, 0x72, 0x65, 0x71, 0x75, 0x69, 0x72, 0x65, 0x5f, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65,
	0x72, 0x5f, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x1c, 0x72, 0x65, 0x71, 0x75,
	0x69, 0x72, 0x65, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x4a, 0x75, 0x73, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x58, 0x0a, 0x05, 0x73, 0x74, 0x65, 0x70,
	0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65,
	0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x4d, 0x61, 0x6e, 0x75, 0x61, 0x6c, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c,
	0x73, 0x2e, 0x53, 0x74, 0x65, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x73, 0x74, 0x65,
	0x70, 0x73, 0x1a, 0xd7, 0x01, 0x0a, 0x04, 0x53, 0x74, 0x65, 0x70, 0x12, 0x5e, 0x0a, 0x09, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x43,
	0x6f, 0x6e, 0x74, 0x72, 0x6f, 0x6c, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x09, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x73, 0x12, 0x2e, 0x0a, 0x10, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x61, 0x6c, 0x73, 0x5f, 0x6e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x61, 0x6c, 0x73, 0x4e, 0x65, 0x65, 0x64, 0x65, 0x64, 0x12, 0x3f, 0x0a, 0x19, 0x61,
	0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x72, 0x65,
	0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x17, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x72, 0x45, 0x6d, 0x61,
	0x69, 0x6c, 0x52, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x22, 0xcb, 0x03, 0x0a,
	0x10, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x6e, 0x0a, 0x0e, 0x67, 0x63, 0x70, 0x5f, 0x69, 0x61, 0x6d, 0x5f, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65,
	0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x41, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x2e, 0x47, 0x63, 0x70, 0x49, 0x61, 0x6d, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x48, 0x00, 0x52, 0x0c, 0x67, 0x63, 0x70, 0x49, 0x61, 0x6d, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x1a, 0xb7, 0x02, 0x0a, 0x0c, 0x47, 0x63, 0x70, 0x49, 0x61, 0x6d, 0x41, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x12, 0x28, 0x0a, 0x0d, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x74,
	0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1f, 0x0a, 0x08,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x08, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x12, 0x7c, 0x0a,
	0x0d, 0x72, 0x6f, 0x6c, 0x65, 0x5f, 0x62, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x18, 0x04,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x52, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x2e,
	0x47, 0x63, 0x70, 0x49, 0x61, 0x6d, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x2e, 0x52, 0x6f, 0x6c,
	0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x72,
	0x6f, 0x6c, 0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x73, 0x1a, 0x5e, 0x0a, 0x0b, 0x52,
	0x6f, 0x6c, 0x65, 0x42, 0x69, 0x6e, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x17, 0x0a, 0x04, 0x72, 0x6f,
	0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x72,
	0x6f, 0x6c, 0x65, 0x12, 0x36, 0x0a, 0x14, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x5f, 0x65, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x13, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x45, 0x78, 0x70, 0x72, 0x65, 0x73, 0x73, 0x69, 0x6f, 0x6e, 0x42, 0x0d, 0x0a, 0x0b, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x22, 0xf0, 0x01, 0x0a, 0x17, 0x4c,
	0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32,
	0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e,
	0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x1e, 0x0a,
	0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79, 0x22, 0xbe, 0x01,
	0x0a, 0x18, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x0c, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67,
	0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e,
	0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b,
	0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xbc,
	0x03, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06,
	0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x34, 0x12, 0x32, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x12, 0x86, 0x01, 0x0a, 0x12, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x10, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x41,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c,
	0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73,
	0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08,
	0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x5f, 0x0a, 0x10,
	0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x54, 0x79, 0x70, 0x65,
	0x12, 0x22, 0x0a, 0x1e, 0x43, 0x41, 0x4c, 0x4c, 0x45, 0x52, 0x5f, 0x41, 0x43, 0x43, 0x45, 0x53,
	0x53, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49,
	0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x47, 0x52, 0x41, 0x4e, 0x54, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x45, 0x53, 0x54, 0x45, 0x52, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x52, 0x41,
	0x4e, 0x54, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f, 0x56, 0x45, 0x52, 0x10, 0x02, 0x22, 0x9e, 0x01,
	0x0a, 0x1a, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x58, 0x0a, 0x0c,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65,
	0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x0c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70,
	0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x67,
	0x0a, 0x15, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x70,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69,
	0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x9b, 0x02, 0x0a, 0x18, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x52, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x12, 0x32, 0x70, 0x72,
	0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x0e, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0d, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x49, 0x64, 0x12, 0x5b, 0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65,
	0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xa9, 0x01, 0x0a, 0x18, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x4e, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x3a, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x34, 0x0a, 0x32, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x12, 0x19, 0x0a, 0x05, 0x66, 0x6f, 0x72, 0x63, 0x65, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x66, 0x6f, 0x72, 0x63,
	0x65, 0x22, 0xb9, 0x01, 0x0a, 0x18, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x5b,
	0x0a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x0b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x40, 0x0a, 0x0b, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xf6, 0x19,
	0x0a, 0x05, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x08, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65,
	0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d,
	0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69,
	0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x21, 0x0a, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65,
	0x72, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x72, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x72, 0x12, 0x4d, 0x0a, 0x12, 0x72, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x65, 0x64, 0x5f, 0x64, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x11, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x61, 0x0a, 0x0d, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x36, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x6a, 0x75, 0x73, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x4f, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67,
	0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x58, 0x0a, 0x08, 0x74, 0x69,
	0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x54, 0x69, 0x6d,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08, 0x74, 0x69, 0x6d, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x12, 0x6b, 0x0a, 0x11, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67,
	0x65, 0x64, 0x5f, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x18, 0x09, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x10, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x12, 0x5f, 0x0a, 0x0b, 0x61, 0x75, 0x64, 0x69, 0x74, 0x5f, 0x74, 0x72, 0x61, 0x69, 0x6c,
	0x18, 0x0a, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x41, 0x75, 0x64, 0x69, 0x74, 0x54, 0x72, 0x61, 0x69,
	0x6c, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x61, 0x75, 0x64, 0x69, 0x74, 0x54, 0x72, 0x61,
	0x69, 0x6c, 0x12, 0x43, 0x0a, 0x1b, 0x61, 0x64, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c,
	0x5f, 0x65, 0x6d, 0x61, 0x69, 0x6c, 0x5f, 0x72, 0x65, 0x63, 0x69, 0x70, 0x69, 0x65, 0x6e, 0x74,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x19, 0x61, 0x64,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x61, 0x6c, 0x45, 0x6d, 0x61, 0x69, 0x6c, 0x52, 0x65, 0x63,
	0x69, 0x70, 0x69, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x34, 0x0a, 0x13, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x0c,
	0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x12, 0x65, 0x78, 0x74, 0x65, 0x72,
	0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x1a, 0xde, 0x0d,
	0x0a, 0x08, 0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x5a, 0x0a, 0x06, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x73, 0x1a, 0xf5, 0x0c, 0x0a, 0x05, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x12, 0x67, 0x0a, 0x09, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72,
	0x61, 0x6e, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x2e, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x09,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x12, 0x64, 0x0a, 0x08, 0x61, 0x70, 0x70,
	0x72, 0x6f, 0x76, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f,
	0x76, 0x65, 0x64, 0x48, 0x00, 0x52, 0x08, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x64, 0x12,
	0x5e, 0x0a, 0x06, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x44,
	0x65, 0x6e, 0x69, 0x65, 0x64, 0x48, 0x00, 0x52, 0x06, 0x64, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x12,
	0x61, 0x0a, 0x07, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73,
	0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74,
	0x2e, 0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e,
	0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x48, 0x00, 0x52, 0x07, 0x72, 0x65, 0x76, 0x6f, 0x6b,
	0x65, 0x64, 0x12, 0x67, 0x0a, 0x09, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x18,
	0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x48, 0x00,
	0x52, 0x09, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x12, 0x67, 0x0a, 0x09, 0x61,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x47,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x54,
	0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41, 0x63,
	0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x48, 0x00, 0x52, 0x09, 0x61, 0x63, 0x74, 0x69, 0x76,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x7d, 0x0a, 0x11, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x5f, 0x66, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x4e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x2e, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x48,
	0x00, 0x52, 0x10, 0x61, 0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69,
	0x6c, 0x65, 0x64, 0x12, 0x61, 0x0a, 0x07, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x18, 0x0a,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x72, 0x61, 0x6e, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x76,
	0x65, 0x6e, 0x74, 0x2e, 0x45, 0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x48, 0x00, 0x52, 0x07, 0x65,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x12, 0x5b, 0x0a, 0x05, 0x65, 0x6e, 0x64, 0x65, 0x64, 0x18,
	0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x72, 0x61, 0x6e, 0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45,
	0x76, 0x65, 0x6e, 0x74, 0x2e, 0x45, 0x6e, 0x64, 0x65, 0x64, 0x48, 0x00, 0x52, 0x05, 0x65, 0x6e,
	0x64, 0x65, 0x64, 0x12, 0x83, 0x01, 0x0a, 0x13, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c,
	0x6c, 0x79, 0x5f, 0x6d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x50, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e,
	0x74, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74,
	0x2e, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x4d, 0x6f, 0x64, 0x69, 0x66,
	0x69, 0x65, 0x64, 0x48, 0x00, 0x52, 0x12, 0x65, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x6c,
	0x79, 0x4d, 0x6f, 0x64, 0x69, 0x66, 0x69, 0x65, 0x64, 0x12, 0x3e, 0x0a, 0x0a, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09,
	0x65, 0x76, 0x65, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x4d, 0x0a, 0x09, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x65, 0x78, 0x70, 0x69, 0x72, 0x65,
	0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69,
	0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x65, 0x78,
	0x70, 0x69, 0x72, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x42, 0x0a, 0x08, 0x41, 0x70, 0x70, 0x72,
	0x6f, 0x76, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x19, 0x0a, 0x05, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x40, 0x0a, 0x06,
	0x44, 0x65, 0x6e, 0x69, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x1a, 0x41,
	0x0a, 0x07, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x64, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x61,
	0x73, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x06,
	0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x05, 0x61, 0x63, 0x74, 0x6f, 0x72, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x61, 0x63, 0x74, 0x6f,
	0x72, 0x1a, 0x68, 0x0a, 0x09, 0x53, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x12, 0x5b,
	0x0a, 0x19, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x5f, 0x61, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x17, 0x73, 0x63, 0x68, 0x65, 0x64, 0x75, 0x6c, 0x65, 0x64, 0x41, 0x63, 0x74,
	0x69, 0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x1a, 0x0b, 0x0a, 0x09, 0x41,
	0x63, 0x74, 0x69, 0x76, 0x61, 0x74, 0x65, 0x64, 0x1a, 0x41, 0x0a, 0x10, 0x41, 0x63, 0x74, 0x69,
	0x76, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x46, 0x61, 0x69, 0x6c, 0x65, 0x64, 0x12, 0x2d, 0x0a, 0x05,
	0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x72, 0x70, 0x63, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x05, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x1a, 0x09, 0x0a, 0x07, 0x45,
	0x78, 0x70, 0x69, 0x72, 0x65, 0x64, 0x1a, 0x07, 0x0a, 0x05, 0x45, 0x6e, 0x64, 0x65, 0x64, 0x1a,
	0x14, 0x0a, 0x12, 0x45, 0x78, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x6c, 0x6c, 0x79, 0x4d, 0x6f, 0x64,
	0x69, 0x66, 0x69, 0x65, 0x64, 0x42, 0x07, 0x0a, 0x05, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x1a, 0xa8,
	0x01, 0x0a, 0x0a, 0x41, 0x75, 0x64, 0x69, 0x74, 0x54, 0x72, 0x61, 0x69, 0x6c, 0x12, 0x4b, 0x0a,
	0x11, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x5f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5f, 0x74, 0x69,
	0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73,
	0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x4d, 0x0a, 0x12, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x5f, 0x72, 0x65, 0x6d, 0x6f, 0x76, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61,
	0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x10, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x52,
	0x65, 0x6d, 0x6f, 0x76, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x22, 0xb5, 0x01, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x50,
	0x50, 0x52, 0x4f, 0x56, 0x41, 0x4c, 0x5f, 0x41, 0x57, 0x41, 0x49, 0x54, 0x45, 0x44, 0x10, 0x01,
	0x12, 0x0a, 0x0a, 0x06, 0x44, 0x45, 0x4e, 0x49, 0x45, 0x44, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09,
	0x53, 0x43, 0x48, 0x45, 0x44, 0x55, 0x4c, 0x45, 0x44, 0x10, 0x04, 0x12, 0x0e, 0x0a, 0x0a, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x41, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x12, 0x0a, 0x0a, 0x06, 0x41,
	0x43, 0x54, 0x49, 0x56, 0x45, 0x10, 0x06, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x43, 0x54, 0x49, 0x56,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44, 0x10, 0x07, 0x12, 0x0b,
	0x0a, 0x07, 0x45, 0x58, 0x50, 0x49, 0x52, 0x45, 0x44, 0x10, 0x08, 0x12, 0x0c, 0x0a, 0x08, 0x52,
	0x45, 0x56, 0x4f, 0x4b, 0x49, 0x4e, 0x47, 0x10, 0x09, 0x12, 0x0b, 0x0a, 0x07, 0x52, 0x45, 0x56,
	0x4f, 0x4b, 0x45, 0x44, 0x10, 0x0a, 0x12, 0x09, 0x0a, 0x05, 0x45, 0x4e, 0x44, 0x45, 0x44, 0x10,
	0x0b, 0x3a, 0xc2, 0x02, 0xea, 0x41, 0xbe, 0x02, 0x0a, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x12, 0x51, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74,
	0x73, 0x2f, 0x7b, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x7d, 0x12, 0x4f, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d,
	0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x67, 0x72, 0x61, 0x6e,
	0x74, 0x73, 0x2f, 0x7b, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x7d, 0x12, 0x5b, 0x6f, 0x72, 0x67, 0x61,
	0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x7d, 0x2a, 0x06, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x32,
	0x05, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x22, 0x61, 0x0a, 0x0d, 0x4a, 0x75, 0x73, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3f, 0x0a, 0x1a, 0x75, 0x6e, 0x73, 0x74, 0x72,
	0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x5f, 0x6a, 0x75, 0x73, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x48, 0x00, 0x52, 0x19, 0x75,
	0x6e, 0x73, 0x74, 0x72, 0x75, 0x63, 0x74, 0x75, 0x72, 0x65, 0x64, 0x4a, 0x75, 0x73, 0x74, 0x69,
	0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x0f, 0x0a, 0x0d, 0x6a, 0x75, 0x73, 0x74,
	0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xe4, 0x01, 0x0a, 0x11, 0x4c, 0x69,
	0x73, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65,
	0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x20, 0x0a,
	0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12,
	0x22, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x03, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72,
	0x12, 0x1e, 0x0a, 0x08, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x5f, 0x62, 0x79, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x6f, 0x72, 0x64, 0x65, 0x72, 0x42, 0x79,
	0x22, 0xa6, 0x01, 0x0a, 0x12, 0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x46, 0x0a, 0x06, 0x67, 0x72, 0x61, 0x6e, 0x74,
	0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65,
	0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x12,
	0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x20, 0x0a, 0x0b, 0x75, 0x6e, 0x72, 0x65, 0x61,
	0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0b, 0x75, 0x6e,
	0x72, 0x65, 0x61, 0x63, 0x68, 0x61, 0x62, 0x6c, 0x65, 0x22, 0xca, 0x03, 0x0a, 0x13, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x12, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12,
	0x89, 0x01, 0x0a, 0x13, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x5f, 0x72, 0x65, 0x6c, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x53, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x47, 0x72,
	0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x43, 0x61, 0x6c, 0x6c,
	0x65, 0x72, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x54, 0x79,
	0x70, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x12, 0x63, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x52,
	0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x68, 0x69, 0x70, 0x12, 0x1b, 0x0a, 0x06, 0x66,
	0x69, 0x6c, 0x74, 0x65, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x20, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x12, 0x22, 0x0a, 0x0a, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x76,
	0x0a, 0x16, 0x43, 0x61, 0x6c, 0x6c, 0x65, 0x72, 0x52, 0x65, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x68, 0x69, 0x70, 0x54, 0x79, 0x70, 0x65, 0x12, 0x28, 0x0a, 0x24, 0x43, 0x41, 0x4c, 0x4c,
	0x45, 0x52, 0x5f, 0x52, 0x45, 0x4c, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x53, 0x48, 0x49, 0x50, 0x5f,
	0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0f, 0x0a, 0x0b, 0x48, 0x41, 0x44, 0x5f, 0x43, 0x52, 0x45, 0x41, 0x54, 0x45,
	0x44, 0x10, 0x01, 0x12, 0x0f, 0x0a, 0x0b, 0x43, 0x41, 0x4e, 0x5f, 0x41, 0x50, 0x50, 0x52, 0x4f,
	0x56, 0x45, 0x10, 0x02, 0x12, 0x10, 0x0a, 0x0c, 0x48, 0x41, 0x44, 0x5f, 0x41, 0x50, 0x50, 0x52,
	0x4f, 0x56, 0x45, 0x44, 0x10, 0x03, 0x22, 0x86, 0x01, 0x0a, 0x14, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x46, 0x0a, 0x06, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70,
	0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d,
	0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52,
	0x06, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f,
	0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22,
	0x5b, 0x0a, 0x0f, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x22, 0x7c, 0x0a, 0x13,
	0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0x2f, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a,
	0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x01, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x79, 0x0a, 0x10, 0x44, 0x65,
	0x6e, 0x79, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41,
	0x02, 0xfa, 0x41, 0x2e, 0x0a, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x61,
	0x6e, 0x74, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x72,
	0x65, 0x61, 0x73, 0x6f, 0x6e, 0x22, 0x7b, 0x0a, 0x12, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x47,
	0x72, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x48, 0x0a, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2e, 0x0a, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x72, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x22, 0xd1, 0x01, 0x0a, 0x12, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x61,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x4c, 0x0a, 0x06, 0x70, 0x61, 0x72,
	0x65, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x34, 0xe0, 0x41, 0x02, 0xfa, 0x41,
	0x2e, 0x12, 0x2c, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52,
	0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x12, 0x49, 0x0a, 0x05, 0x67, 0x72, 0x61, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x67, 0x72, 0x61,
	0x6e, 0x74, 0x12, 0x22, 0x0a, 0x0a, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x72, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x49, 0x64, 0x22, 0xd5, 0x02, 0x0a, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x40, 0x0a, 0x0b,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x3a,
	0x0a, 0x08, 0x65, 0x6e, 0x64, 0x5f, 0x74, 0x69, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62,
	0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x07, 0x65, 0x6e, 0x64, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x06, 0x74, 0x61,
	0x72, 0x67, 0x65, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52,
	0x06, 0x74, 0x61, 0x72, 0x67, 0x65, 0x74, 0x12, 0x17, 0x0a, 0x04, 0x76, 0x65, 0x72, 0x62, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x76, 0x65, 0x72, 0x62,
	0x12, 0x2a, 0x0a, 0x0e, 0x73, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61,
	0x67, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73,
	0x74, 0x61, 0x74, 0x75, 0x73, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x12, 0x3a, 0x0a, 0x16,
	0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x5f, 0x63, 0x61, 0x6e, 0x63, 0x65, 0x6c,
	0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x15, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x65, 0x64, 0x43, 0x61, 0x6e, 0x63,
	0x65, 0x6c, 0x6c, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x0b, 0x61, 0x70, 0x69, 0x5f,
	0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0,
	0x41, 0x03, 0x52, 0x0a, 0x61, 0x70, 0x69, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x32, 0xc1,
	0x27, 0x0a, 0x17, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x12, 0xe9, 0x02, 0x0a, 0x15, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x12, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43,
	0x68, 0x65, 0x63, 0x6b, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74,
	0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x46, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x68, 0x65, 0x63, 0x6b, 0x4f, 0x6e, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f,
	0x6e, 0x73, 0x65, 0x22, 0xc0, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb9, 0x01, 0x5a, 0x40, 0x12,
	0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67,
	0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x4f,
	0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x5a,
	0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x4f, 0x6e, 0x62, 0x6f, 0x61,
	0x72, 0x64, 0x69, 0x6e, 0x67, 0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0x39, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x63, 0x68, 0x65, 0x63, 0x6b, 0x4f, 0x6e, 0x62, 0x6f, 0x61, 0x72, 0x64, 0x69, 0x6e, 0x67,
	0x53, 0x74, 0x61, 0x74, 0x75, 0x73, 0x12, 0xc8, 0x02, 0x0a, 0x10, 0x4c, 0x69, 0x73, 0x74, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x40, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x22, 0xae, 0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x9e, 0x01, 0x5a, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x5a, 0x31, 0x12, 0x2f,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64,
	0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12,
	0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x12, 0xda, 0x02, 0x0a, 0x12, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x12, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67,
	0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x43, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0xba, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb3, 0x01, 0x5a, 0x3e, 0x12, 0x3c, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e,
	0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5a, 0x38, 0x12, 0x36, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x73,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x37, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0xb5,
	0x02, 0x0a, 0x0e, 0x47, 0x65, 0x74, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x6e, 0x74, 0x69,
	0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0xac, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9e, 0x01, 0x5a, 0x37, 0x12, 0x35, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x5a, 0x31, 0x12, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x8b, 0x03, 0x0a, 0x11, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e,
	0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x93,
	0x02, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x21, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xc5, 0x01, 0x3a,
	0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5a, 0x44, 0x3a, 0x0b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x22, 0x35, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x5a, 0x3e, 0x3a, 0x0b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x22, 0x2f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e,
	0x74, 0x73, 0x22, 0x30, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x12, 0xc7, 0x02, 0x0a, 0x11, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69,
	0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xcf, 0x01, 0xca,
	0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12,
	0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x9e, 0x01,
	0x5a, 0x37, 0x2a, 0x35, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72,
	0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f,
	0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c,
	0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x31, 0x2a, 0x2f, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2a, 0x30, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xa5,
	0x03, 0x0a, 0x11, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x12, 0x41, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x55,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x45, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xad, 0x02, 0xca, 0x41, 0x20, 0x0a, 0x0b, 0x45, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0xda, 0x41, 0x17, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2c, 0x75, 0x70, 0x64, 0x61, 0x74,
	0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xe9, 0x01, 0x3a, 0x0b, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x5a, 0x50, 0x3a, 0x0b, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x4a, 0x3a, 0x0b,
	0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x32, 0x3b, 0x2f, 0x76, 0x31,
	0x2f, 0x7b, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x32, 0x3c, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x2e, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0xd1, 0x02, 0x0a, 0x0a, 0x4c, 0x69, 0x73, 0x74, 0x47,
	0x72, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x3a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61,
	0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x4c, 0x69, 0x73, 0x74,
	0x47, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xc9,
	0x01, 0xda, 0x41, 0x06, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb9,
	0x01, 0x5a, 0x40, 0x12, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74,
	0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74,
	0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72, 0x61,
	0x6e, 0x74, 0x73, 0x5a, 0x3a, 0x12, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65,
	0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x12,
	0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x12, 0xe3, 0x02, 0x0a, 0x0c, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x3c, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x47, 0x72, 0x61, 0x6e,
	0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65,
	0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72,
	0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0xd5, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0xce, 0x01, 0x5a, 0x47, 0x12, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e,
	0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72,
	0x61, 0x6e, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x5a, 0x41, 0x12, 0x3f, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65,
	0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x12, 0x40,
	0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x2a, 0x7d, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x3a, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68,
	0x12, 0xbe, 0x02, 0x0a, 0x08, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x12, 0x38, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69,
	0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x47, 0x72, 0x61, 0x6e, 0x74,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65,
	0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76,
	0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x22, 0xc7, 0x01, 0xda, 0x41, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xb9, 0x01, 0x5a, 0x40, 0x12, 0x3e, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x5a, 0x3a, 0x12, 0x38, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x61,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x12, 0x39, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65,
	0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a,
	0x7d, 0x12, 0xe1, 0x02, 0x0a, 0x0b, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x47, 0x72, 0x61, 0x6e,
	0x74, 0x12, 0x3b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72,
	0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61,
	0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x22, 0xe4,
	0x01, 0xda, 0x41, 0x0c, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x2c, 0x67, 0x72, 0x61, 0x6e, 0x74,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0xce, 0x01, 0x3a, 0x05, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x5a, 0x47,
	0x3a, 0x05, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x22, 0x3e, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61,
	0x72, 0x65, 0x6e, 0x74, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a,
	0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x5a, 0x41, 0x3a, 0x05, 0x67, 0x72, 0x61, 0x6e, 0x74,
	0x22, 0x38, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x66, 0x6f,
	0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x22, 0x39, 0x2f, 0x76, 0x31, 0x2f,
	0x7b, 0x70, 0x61, 0x72, 0x65, 0x6e, 0x74, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x2f, 0x67,
	0x72, 0x61, 0x6e, 0x74, 0x73, 0x12, 0xe0, 0x02, 0x0a, 0x0c, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76,
	0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x12, 0x3c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47,
	0x72, 0x61, 0x6e, 0x74, 0x22, 0xe1, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xda, 0x01, 0x3a, 0x01,
	0x2a, 0x5a, 0x4b, 0x3a, 0x01, 0x2a, 0x22, 0x46, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d,
	0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f,
	0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e,
	0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x61,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x5a, 0x45,
	0x3a, 0x01, 0x2a, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x61, 0x70,
	0x70, 0x72, 0x6f, 0x76, 0x65, 0x22, 0x41, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65,
	0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d,
	0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d,
	0x3a, 0x61, 0x70, 0x70, 0x72, 0x6f, 0x76, 0x65, 0x12, 0xd1, 0x02, 0x0a, 0x09, 0x44, 0x65, 0x6e,
	0x79, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x12, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64,
	0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31,
	0x2e, 0x44, 0x65, 0x6e, 0x79, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x1a, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73,
	0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x72, 0x61, 0x6e,
	0x74, 0x22, 0xd8, 0x01, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd1, 0x01, 0x3a, 0x01, 0x2a, 0x5a, 0x48,
	0x3a, 0x01, 0x2a, 0x22, 0x43, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x6f,
	0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74,
	0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73,
	0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x6e, 0x79, 0x5a, 0x42, 0x3a, 0x01, 0x2a, 0x22, 0x3d, 0x2f,
	0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72,
	0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x6e, 0x79, 0x22, 0x3e, 0x2f, 0x76,
	0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72,
	0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x64, 0x65, 0x6e, 0x79, 0x12, 0xe7, 0x02, 0x0a,
	0x0b, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x47, 0x72, 0x61, 0x6e, 0x74, 0x12, 0x3b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x2e, 0x52, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x47, 0x72, 0x61,
	0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xfb, 0x01, 0xca, 0x41, 0x1a, 0x0a, 0x05,
	0x47, 0x72, 0x61, 0x6e, 0x74, 0x12, 0x11, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0xd7, 0x01, 0x3a,
	0x01, 0x2a, 0x5a, 0x4a, 0x3a, 0x01, 0x2a, 0x22, 0x45, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61,
	0x6d, 0x65, 0x3d, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65,
	0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72,
	0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x5a, 0x44,
	0x3a, 0x01, 0x2a, 0x22, 0x3f, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d, 0x66,
	0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65, 0x6e, 0x74,
	0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a, 0x72, 0x65,
	0x76, 0x6f, 0x6b, 0x65, 0x22, 0x40, 0x2f, 0x76, 0x31, 0x2f, 0x7b, 0x6e, 0x61, 0x6d, 0x65, 0x3d,
	0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x2a, 0x2f, 0x65, 0x6e, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x6d, 0x65,
	0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x2f, 0x67, 0x72, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x2a, 0x7d, 0x3a,
	0x72, 0x65, 0x76, 0x6f, 0x6b, 0x65, 0x1a, 0x5a, 0xca, 0x41, 0x26, 0x70, 0x72, 0x69, 0x76, 0x69,
	0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67,
	0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f,
	0x6d, 0xd2, 0x41, 0x2e, 0x68, 0x74, 0x74, 0x70, 0x73, 0x3a, 0x2f, 0x2f, 0x77, 0x77, 0x77, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x61,
	0x75, 0x74, 0x68, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2d, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x42, 0x89, 0x04, 0xea, 0x41, 0x70, 0x0a, 0x3b, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x4f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6f, 0x72, 0x67, 0x61, 0x6e, 0x69, 0x7a, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x5e, 0x0a, 0x35, 0x70, 0x72, 0x69,
	0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e,
	0x63, 0x6f, 0x6d, 0x2f, 0x46, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x4c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x12, 0x25, 0x66, 0x6f, 0x6c, 0x64, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x66, 0x6f, 0x6c,
	0x64, 0x65, 0x72, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x0a, 0x2b, 0x63, 0x6f, 0x6d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x70, 0x72, 0x69, 0x76,
	0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2e, 0x76, 0x31, 0x42, 0x1c, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67,
	0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x50,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x65, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x72, 0x69, 0x76,
	0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61,
	0x67, 0x65, 0x72, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c,
	0x65, 0x67, 0x65, 0x64, 0x61, 0x63, 0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65,
	0x72, 0x70, 0x62, 0x3b, 0x70, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x61, 0x63,
	0x63, 0x65, 0x73, 0x73, 0x6d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x70, 0x62, 0xaa, 0x02, 0x27,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x50, 0x72, 0x69,
	0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x6e,
	0x61, 0x67, 0x65, 0x72, 0x2e, 0x56, 0x31, 0xca, 0x02, 0x27, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65,
	0x64, 0x41, 0x63, 0x63, 0x65, 0x73, 0x73, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x5c, 0x56,
	0x31, 0xea, 0x02, 0x2a, 0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75,
	0x64, 0x3a, 0x3a, 0x50, 0x72, 0x69, 0x76, 0x69, 0x6c, 0x65, 0x67, 0x65, 0x64, 0x41, 0x63, 0x63,
	0x65, 0x73, 0x73, 0x4d, 0x61, 0x6e, 0x61, 0x67, 0x65, 0x72, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x06,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescOnce sync.Once
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescData = file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDesc
)

func file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescGZIP() []byte {
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescOnce.Do(func() {
		file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescData)
	})
	return file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDescData
}

var file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes = make([]protoimpl.MessageInfo, 49)
var file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_goTypes = []any{
	(Entitlement_State)(0),                                        // 0: google.cloud.privilegedaccessmanager.v1.Entitlement.State
	(SearchEntitlementsRequest_CallerAccessType)(0),               // 1: google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest.CallerAccessType
	(Grant_State)(0),                                              // 2: google.cloud.privilegedaccessmanager.v1.Grant.State
	(SearchGrantsRequest_CallerRelationshipType)(0),               // 3: google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest.CallerRelationshipType
	(*CheckOnboardingStatusRequest)(nil),                          // 4: google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusRequest
	(*CheckOnboardingStatusResponse)(nil),                         // 5: google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse
	(*Entitlement)(nil),                                           // 6: google.cloud.privilegedaccessmanager.v1.Entitlement
	(*AccessControlEntry)(nil),                                    // 7: google.cloud.privilegedaccessmanager.v1.AccessControlEntry
	(*ApprovalWorkflow)(nil),                                      // 8: google.cloud.privilegedaccessmanager.v1.ApprovalWorkflow
	(*ManualApprovals)(nil),                                       // 9: google.cloud.privilegedaccessmanager.v1.ManualApprovals
	(*PrivilegedAccess)(nil),                                      // 10: google.cloud.privilegedaccessmanager.v1.PrivilegedAccess
	(*ListEntitlementsRequest)(nil),                               // 11: google.cloud.privilegedaccessmanager.v1.ListEntitlementsRequest
	(*ListEntitlementsResponse)(nil),                              // 12: google.cloud.privilegedaccessmanager.v1.ListEntitlementsResponse
	(*SearchEntitlementsRequest)(nil),                             // 13: google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest
	(*SearchEntitlementsResponse)(nil),                            // 14: google.cloud.privilegedaccessmanager.v1.SearchEntitlementsResponse
	(*GetEntitlementRequest)(nil),                                 // 15: google.cloud.privilegedaccessmanager.v1.GetEntitlementRequest
	(*CreateEntitlementRequest)(nil),                              // 16: google.cloud.privilegedaccessmanager.v1.CreateEntitlementRequest
	(*DeleteEntitlementRequest)(nil),                              // 17: google.cloud.privilegedaccessmanager.v1.DeleteEntitlementRequest
	(*UpdateEntitlementRequest)(nil),                              // 18: google.cloud.privilegedaccessmanager.v1.UpdateEntitlementRequest
	(*Grant)(nil),                                                 // 19: google.cloud.privilegedaccessmanager.v1.Grant
	(*Justification)(nil),                                         // 20: google.cloud.privilegedaccessmanager.v1.Justification
	(*ListGrantsRequest)(nil),                                     // 21: google.cloud.privilegedaccessmanager.v1.ListGrantsRequest
	(*ListGrantsResponse)(nil),                                    // 22: google.cloud.privilegedaccessmanager.v1.ListGrantsResponse
	(*SearchGrantsRequest)(nil),                                   // 23: google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest
	(*SearchGrantsResponse)(nil),                                  // 24: google.cloud.privilegedaccessmanager.v1.SearchGrantsResponse
	(*GetGrantRequest)(nil),                                       // 25: google.cloud.privilegedaccessmanager.v1.GetGrantRequest
	(*ApproveGrantRequest)(nil),                                   // 26: google.cloud.privilegedaccessmanager.v1.ApproveGrantRequest
	(*DenyGrantRequest)(nil),                                      // 27: google.cloud.privilegedaccessmanager.v1.DenyGrantRequest
	(*RevokeGrantRequest)(nil),                                    // 28: google.cloud.privilegedaccessmanager.v1.RevokeGrantRequest
	(*CreateGrantRequest)(nil),                                    // 29: google.cloud.privilegedaccessmanager.v1.CreateGrantRequest
	(*OperationMetadata)(nil),                                     // 30: google.cloud.privilegedaccessmanager.v1.OperationMetadata
	(*CheckOnboardingStatusResponse_Finding)(nil),                 // 31: google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse.Finding
	(*CheckOnboardingStatusResponse_Finding_IAMAccessDenied)(nil), // 32: google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse.Finding.IAMAccessDenied
	(*Entitlement_RequesterJustificationConfig)(nil),              // 33: google.cloud.privilegedaccessmanager.v1.Entitlement.RequesterJustificationConfig
	(*Entitlement_AdditionalNotificationTargets)(nil),             // 34: google.cloud.privilegedaccessmanager.v1.Entitlement.AdditionalNotificationTargets
	(*Entitlement_RequesterJustificationConfig_NotMandatory)(nil), // 35: google.cloud.privilegedaccessmanager.v1.Entitlement.RequesterJustificationConfig.NotMandatory
	(*Entitlement_RequesterJustificationConfig_Unstructured)(nil), // 36: google.cloud.privilegedaccessmanager.v1.Entitlement.RequesterJustificationConfig.Unstructured
	(*ManualApprovals_Step)(nil),                                  // 37: google.cloud.privilegedaccessmanager.v1.ManualApprovals.Step
	(*PrivilegedAccess_GcpIamAccess)(nil),                         // 38: google.cloud.privilegedaccessmanager.v1.PrivilegedAccess.GcpIamAccess
	(*PrivilegedAccess_GcpIamAccess_RoleBinding)(nil),             // 39: google.cloud.privilegedaccessmanager.v1.PrivilegedAccess.GcpIamAccess.RoleBinding
	(*Grant_Timeline)(nil),                                        // 40: google.cloud.privilegedaccessmanager.v1.Grant.Timeline
	(*Grant_AuditTrail)(nil),                                      // 41: google.cloud.privilegedaccessmanager.v1.Grant.AuditTrail
	(*Grant_Timeline_Event)(nil),                                  // 42: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event
	(*Grant_Timeline_Event_Requested)(nil),                        // 43: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Requested
	(*Grant_Timeline_Event_Approved)(nil),                         // 44: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Approved
	(*Grant_Timeline_Event_Denied)(nil),                           // 45: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Denied
	(*Grant_Timeline_Event_Revoked)(nil),                          // 46: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Revoked
	(*Grant_Timeline_Event_Scheduled)(nil),                        // 47: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Scheduled
	(*Grant_Timeline_Event_Activated)(nil),                        // 48: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Activated
	(*Grant_Timeline_Event_ActivationFailed)(nil),                 // 49: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.ActivationFailed
	(*Grant_Timeline_Event_Expired)(nil),                          // 50: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Expired
	(*Grant_Timeline_Event_Ended)(nil),                            // 51: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Ended
	(*Grant_Timeline_Event_ExternallyModified)(nil),               // 52: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.ExternallyModified
	(*timestamppb.Timestamp)(nil),                                 // 53: google.protobuf.Timestamp
	(*durationpb.Duration)(nil),                                   // 54: google.protobuf.Duration
	(*fieldmaskpb.FieldMask)(nil),                                 // 55: google.protobuf.FieldMask
	(*status.Status)(nil),                                         // 56: google.rpc.Status
	(*longrunningpb.Operation)(nil),                               // 57: google.longrunning.Operation
}
var file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_depIdxs = []int32{
	31, // 0: google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse.findings:type_name -> google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse.Finding
	53, // 1: google.cloud.privilegedaccessmanager.v1.Entitlement.create_time:type_name -> google.protobuf.Timestamp
	53, // 2: google.cloud.privilegedaccessmanager.v1.Entitlement.update_time:type_name -> google.protobuf.Timestamp
	7,  // 3: google.cloud.privilegedaccessmanager.v1.Entitlement.eligible_users:type_name -> google.cloud.privilegedaccessmanager.v1.AccessControlEntry
	8,  // 4: google.cloud.privilegedaccessmanager.v1.Entitlement.approval_workflow:type_name -> google.cloud.privilegedaccessmanager.v1.ApprovalWorkflow
	10, // 5: google.cloud.privilegedaccessmanager.v1.Entitlement.privileged_access:type_name -> google.cloud.privilegedaccessmanager.v1.PrivilegedAccess
	54, // 6: google.cloud.privilegedaccessmanager.v1.Entitlement.max_request_duration:type_name -> google.protobuf.Duration
	0,  // 7: google.cloud.privilegedaccessmanager.v1.Entitlement.state:type_name -> google.cloud.privilegedaccessmanager.v1.Entitlement.State
	33, // 8: google.cloud.privilegedaccessmanager.v1.Entitlement.requester_justification_config:type_name -> google.cloud.privilegedaccessmanager.v1.Entitlement.RequesterJustificationConfig
	34, // 9: google.cloud.privilegedaccessmanager.v1.Entitlement.additional_notification_targets:type_name -> google.cloud.privilegedaccessmanager.v1.Entitlement.AdditionalNotificationTargets
	9,  // 10: google.cloud.privilegedaccessmanager.v1.ApprovalWorkflow.manual_approvals:type_name -> google.cloud.privilegedaccessmanager.v1.ManualApprovals
	37, // 11: google.cloud.privilegedaccessmanager.v1.ManualApprovals.steps:type_name -> google.cloud.privilegedaccessmanager.v1.ManualApprovals.Step
	38, // 12: google.cloud.privilegedaccessmanager.v1.PrivilegedAccess.gcp_iam_access:type_name -> google.cloud.privilegedaccessmanager.v1.PrivilegedAccess.GcpIamAccess
	6,  // 13: google.cloud.privilegedaccessmanager.v1.ListEntitlementsResponse.entitlements:type_name -> google.cloud.privilegedaccessmanager.v1.Entitlement
	1,  // 14: google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest.caller_access_type:type_name -> google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest.CallerAccessType
	6,  // 15: google.cloud.privilegedaccessmanager.v1.SearchEntitlementsResponse.entitlements:type_name -> google.cloud.privilegedaccessmanager.v1.Entitlement
	6,  // 16: google.cloud.privilegedaccessmanager.v1.CreateEntitlementRequest.entitlement:type_name -> google.cloud.privilegedaccessmanager.v1.Entitlement
	6,  // 17: google.cloud.privilegedaccessmanager.v1.UpdateEntitlementRequest.entitlement:type_name -> google.cloud.privilegedaccessmanager.v1.Entitlement
	55, // 18: google.cloud.privilegedaccessmanager.v1.UpdateEntitlementRequest.update_mask:type_name -> google.protobuf.FieldMask
	53, // 19: google.cloud.privilegedaccessmanager.v1.Grant.create_time:type_name -> google.protobuf.Timestamp
	53, // 20: google.cloud.privilegedaccessmanager.v1.Grant.update_time:type_name -> google.protobuf.Timestamp
	54, // 21: google.cloud.privilegedaccessmanager.v1.Grant.requested_duration:type_name -> google.protobuf.Duration
	20, // 22: google.cloud.privilegedaccessmanager.v1.Grant.justification:type_name -> google.cloud.privilegedaccessmanager.v1.Justification
	2,  // 23: google.cloud.privilegedaccessmanager.v1.Grant.state:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.State
	40, // 24: google.cloud.privilegedaccessmanager.v1.Grant.timeline:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline
	10, // 25: google.cloud.privilegedaccessmanager.v1.Grant.privileged_access:type_name -> google.cloud.privilegedaccessmanager.v1.PrivilegedAccess
	41, // 26: google.cloud.privilegedaccessmanager.v1.Grant.audit_trail:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.AuditTrail
	19, // 27: google.cloud.privilegedaccessmanager.v1.ListGrantsResponse.grants:type_name -> google.cloud.privilegedaccessmanager.v1.Grant
	3,  // 28: google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest.caller_relationship:type_name -> google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest.CallerRelationshipType
	19, // 29: google.cloud.privilegedaccessmanager.v1.SearchGrantsResponse.grants:type_name -> google.cloud.privilegedaccessmanager.v1.Grant
	19, // 30: google.cloud.privilegedaccessmanager.v1.CreateGrantRequest.grant:type_name -> google.cloud.privilegedaccessmanager.v1.Grant
	53, // 31: google.cloud.privilegedaccessmanager.v1.OperationMetadata.create_time:type_name -> google.protobuf.Timestamp
	53, // 32: google.cloud.privilegedaccessmanager.v1.OperationMetadata.end_time:type_name -> google.protobuf.Timestamp
	32, // 33: google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse.Finding.iam_access_denied:type_name -> google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse.Finding.IAMAccessDenied
	35, // 34: google.cloud.privilegedaccessmanager.v1.Entitlement.RequesterJustificationConfig.not_mandatory:type_name -> google.cloud.privilegedaccessmanager.v1.Entitlement.RequesterJustificationConfig.NotMandatory
	36, // 35: google.cloud.privilegedaccessmanager.v1.Entitlement.RequesterJustificationConfig.unstructured:type_name -> google.cloud.privilegedaccessmanager.v1.Entitlement.RequesterJustificationConfig.Unstructured
	7,  // 36: google.cloud.privilegedaccessmanager.v1.ManualApprovals.Step.approvers:type_name -> google.cloud.privilegedaccessmanager.v1.AccessControlEntry
	39, // 37: google.cloud.privilegedaccessmanager.v1.PrivilegedAccess.GcpIamAccess.role_bindings:type_name -> google.cloud.privilegedaccessmanager.v1.PrivilegedAccess.GcpIamAccess.RoleBinding
	42, // 38: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.events:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event
	53, // 39: google.cloud.privilegedaccessmanager.v1.Grant.AuditTrail.access_grant_time:type_name -> google.protobuf.Timestamp
	53, // 40: google.cloud.privilegedaccessmanager.v1.Grant.AuditTrail.access_remove_time:type_name -> google.protobuf.Timestamp
	43, // 41: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.requested:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Requested
	44, // 42: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.approved:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Approved
	45, // 43: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.denied:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Denied
	46, // 44: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.revoked:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Revoked
	47, // 45: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.scheduled:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Scheduled
	48, // 46: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.activated:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Activated
	49, // 47: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.activation_failed:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.ActivationFailed
	50, // 48: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.expired:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Expired
	51, // 49: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.ended:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Ended
	52, // 50: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.externally_modified:type_name -> google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.ExternallyModified
	53, // 51: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.event_time:type_name -> google.protobuf.Timestamp
	53, // 52: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Requested.expire_time:type_name -> google.protobuf.Timestamp
	53, // 53: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.Scheduled.scheduled_activation_time:type_name -> google.protobuf.Timestamp
	56, // 54: google.cloud.privilegedaccessmanager.v1.Grant.Timeline.Event.ActivationFailed.error:type_name -> google.rpc.Status
	4,  // 55: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.CheckOnboardingStatus:input_type -> google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusRequest
	11, // 56: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.ListEntitlements:input_type -> google.cloud.privilegedaccessmanager.v1.ListEntitlementsRequest
	13, // 57: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.SearchEntitlements:input_type -> google.cloud.privilegedaccessmanager.v1.SearchEntitlementsRequest
	15, // 58: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.GetEntitlement:input_type -> google.cloud.privilegedaccessmanager.v1.GetEntitlementRequest
	16, // 59: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.CreateEntitlement:input_type -> google.cloud.privilegedaccessmanager.v1.CreateEntitlementRequest
	17, // 60: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.DeleteEntitlement:input_type -> google.cloud.privilegedaccessmanager.v1.DeleteEntitlementRequest
	18, // 61: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.UpdateEntitlement:input_type -> google.cloud.privilegedaccessmanager.v1.UpdateEntitlementRequest
	21, // 62: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.ListGrants:input_type -> google.cloud.privilegedaccessmanager.v1.ListGrantsRequest
	23, // 63: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.SearchGrants:input_type -> google.cloud.privilegedaccessmanager.v1.SearchGrantsRequest
	25, // 64: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.GetGrant:input_type -> google.cloud.privilegedaccessmanager.v1.GetGrantRequest
	29, // 65: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.CreateGrant:input_type -> google.cloud.privilegedaccessmanager.v1.CreateGrantRequest
	26, // 66: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.ApproveGrant:input_type -> google.cloud.privilegedaccessmanager.v1.ApproveGrantRequest
	27, // 67: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.DenyGrant:input_type -> google.cloud.privilegedaccessmanager.v1.DenyGrantRequest
	28, // 68: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.RevokeGrant:input_type -> google.cloud.privilegedaccessmanager.v1.RevokeGrantRequest
	5,  // 69: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.CheckOnboardingStatus:output_type -> google.cloud.privilegedaccessmanager.v1.CheckOnboardingStatusResponse
	12, // 70: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.ListEntitlements:output_type -> google.cloud.privilegedaccessmanager.v1.ListEntitlementsResponse
	14, // 71: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.SearchEntitlements:output_type -> google.cloud.privilegedaccessmanager.v1.SearchEntitlementsResponse
	6,  // 72: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.GetEntitlement:output_type -> google.cloud.privilegedaccessmanager.v1.Entitlement
	57, // 73: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.CreateEntitlement:output_type -> google.longrunning.Operation
	57, // 74: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.DeleteEntitlement:output_type -> google.longrunning.Operation
	57, // 75: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.UpdateEntitlement:output_type -> google.longrunning.Operation
	22, // 76: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.ListGrants:output_type -> google.cloud.privilegedaccessmanager.v1.ListGrantsResponse
	24, // 77: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.SearchGrants:output_type -> google.cloud.privilegedaccessmanager.v1.SearchGrantsResponse
	19, // 78: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.GetGrant:output_type -> google.cloud.privilegedaccessmanager.v1.Grant
	19, // 79: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.CreateGrant:output_type -> google.cloud.privilegedaccessmanager.v1.Grant
	19, // 80: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.ApproveGrant:output_type -> google.cloud.privilegedaccessmanager.v1.Grant
	19, // 81: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.DenyGrant:output_type -> google.cloud.privilegedaccessmanager.v1.Grant
	57, // 82: google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager.RevokeGrant:output_type -> google.longrunning.Operation
	69, // [69:83] is the sub-list for method output_type
	55, // [55:69] is the sub-list for method input_type
	55, // [55:55] is the sub-list for extension type_name
	55, // [55:55] is the sub-list for extension extendee
	0,  // [0:55] is the sub-list for field type_name
}

func init() { file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_init() }
func file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_init() {
	if File_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto != nil {
		return
	}
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[4].OneofWrappers = []any{
		(*ApprovalWorkflow_ManualApprovals)(nil),
	}
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[6].OneofWrappers = []any{
		(*PrivilegedAccess_GcpIamAccess_)(nil),
	}
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[16].OneofWrappers = []any{
		(*Justification_UnstructuredJustification)(nil),
	}
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[27].OneofWrappers = []any{
		(*CheckOnboardingStatusResponse_Finding_IamAccessDenied)(nil),
	}
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[29].OneofWrappers = []any{
		(*Entitlement_RequesterJustificationConfig_NotMandatory_)(nil),
		(*Entitlement_RequesterJustificationConfig_Unstructured_)(nil),
	}
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes[38].OneofWrappers = []any{
		(*Grant_Timeline_Event_Requested_)(nil),
		(*Grant_Timeline_Event_Approved_)(nil),
		(*Grant_Timeline_Event_Denied_)(nil),
		(*Grant_Timeline_Event_Revoked_)(nil),
		(*Grant_Timeline_Event_Scheduled_)(nil),
		(*Grant_Timeline_Event_Activated_)(nil),
		(*Grant_Timeline_Event_ActivationFailed_)(nil),
		(*Grant_Timeline_Event_Expired_)(nil),
		(*Grant_Timeline_Event_Ended_)(nil),
		(*Grant_Timeline_Event_ExternallyModified_)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   49,
			NumExtensions: 0,
			NumServices:   1,
		},
		GoTypes:           file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_goTypes,
		DependencyIndexes: file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_depIdxs,
		EnumInfos:         file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_enumTypes,
		MessageInfos:      file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_msgTypes,
	}.Build()
	File_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto = out.File
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_rawDesc = nil
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_goTypes = nil
	file_google_cloud_privilegedaccessmanager_v1_privilegedaccessmanager_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// PrivilegedAccessManagerClient is the client API for PrivilegedAccessManager service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type PrivilegedAccessManagerClient interface {
	// `CheckOnboardingStatus` reports the onboarding status for a
	// project/folder/organization. Any findings reported by this API need to be
	// fixed before PAM can be used on the resource.
	CheckOnboardingStatus(ctx context.Context, in *CheckOnboardingStatusRequest, opts ...grpc.CallOption) (*CheckOnboardingStatusResponse, error)
	// Lists entitlements in a given project/folder/organization and location.
	ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error)
	// `SearchEntitlements` returns entitlements on which the caller has the
	// specified access.
	SearchEntitlements(ctx context.Context, in *SearchEntitlementsRequest, opts ...grpc.CallOption) (*SearchEntitlementsResponse, error)
	// Gets details of a single entitlement.
	GetEntitlement(ctx context.Context, in *GetEntitlementRequest, opts ...grpc.CallOption) (*Entitlement, error)
	// Creates a new entitlement in a given project/folder/organization and
	// location.
	CreateEntitlement(ctx context.Context, in *CreateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Deletes a single entitlement. This method can only be called when there
	// are no in-progress (`ACTIVE`/`ACTIVATING`/`REVOKING`) grants under the
	// entitlement.
	DeleteEntitlement(ctx context.Context, in *DeleteEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Updates the entitlement specified in the request. Updated fields in the
	// entitlement need to be specified in an update mask. The changes made to an
	// entitlement are applicable only on future grants of the entitlement.
	// However, if new approvers are added or existing approvers are removed from
	// the approval workflow, the changes are effective on existing grants.
	//
	// The following fields are not supported for updates:
	//
	//   - All immutable fields
	//   - Entitlement name
	//   - Resource name
	//   - Resource type
	//   - Adding an approval workflow in an entitlement which previously had no
	//     approval workflow.
	//   - Deleting the approval workflow from an entitlement.
	//   - Adding or deleting a step in the approval workflow (only one step is
	//     supported)
	//
	// Note that updates are allowed on the list of approvers in an approval
	// workflow step.
	UpdateEntitlement(ctx context.Context, in *UpdateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
	// Lists grants for a given entitlement.
	ListGrants(ctx context.Context, in *ListGrantsRequest, opts ...grpc.CallOption) (*ListGrantsResponse, error)
	// `SearchGrants` returns grants that are related to the calling user in the
	// specified way.
	SearchGrants(ctx context.Context, in *SearchGrantsRequest, opts ...grpc.CallOption) (*SearchGrantsResponse, error)
	// Get details of a single grant.
	GetGrant(ctx context.Context, in *GetGrantRequest, opts ...grpc.CallOption) (*Grant, error)
	// Creates a new grant in a given project/folder/organization and
	// location.
	CreateGrant(ctx context.Context, in *CreateGrantRequest, opts ...grpc.CallOption) (*Grant, error)
	// `ApproveGrant` is used to approve a grant. This method can only be called
	// on a grant when it's in the `APPROVAL_AWAITED` state. This operation can't
	// be undone.
	ApproveGrant(ctx context.Context, in *ApproveGrantRequest, opts ...grpc.CallOption) (*Grant, error)
	// `DenyGrant` is used to deny a grant. This method can only be called on a
	// grant when it's in the `APPROVAL_AWAITED` state. This operation can't be
	// undone.
	DenyGrant(ctx context.Context, in *DenyGrantRequest, opts ...grpc.CallOption) (*Grant, error)
	// `RevokeGrant` is used to immediately revoke access for a grant. This method
	// can be called when the grant is in a non-terminal state.
	RevokeGrant(ctx context.Context, in *RevokeGrantRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error)
}

type privilegedAccessManagerClient struct {
	cc grpc.ClientConnInterface
}

func NewPrivilegedAccessManagerClient(cc grpc.ClientConnInterface) PrivilegedAccessManagerClient {
	return &privilegedAccessManagerClient{cc}
}

func (c *privilegedAccessManagerClient) CheckOnboardingStatus(ctx context.Context, in *CheckOnboardingStatusRequest, opts ...grpc.CallOption) (*CheckOnboardingStatusResponse, error) {
	out := new(CheckOnboardingStatusResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/CheckOnboardingStatus", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) ListEntitlements(ctx context.Context, in *ListEntitlementsRequest, opts ...grpc.CallOption) (*ListEntitlementsResponse, error) {
	out := new(ListEntitlementsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/ListEntitlements", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) SearchEntitlements(ctx context.Context, in *SearchEntitlementsRequest, opts ...grpc.CallOption) (*SearchEntitlementsResponse, error) {
	out := new(SearchEntitlementsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/SearchEntitlements", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) GetEntitlement(ctx context.Context, in *GetEntitlementRequest, opts ...grpc.CallOption) (*Entitlement, error) {
	out := new(Entitlement)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/GetEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) CreateEntitlement(ctx context.Context, in *CreateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/CreateEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) DeleteEntitlement(ctx context.Context, in *DeleteEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/DeleteEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) UpdateEntitlement(ctx context.Context, in *UpdateEntitlementRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/UpdateEntitlement", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) ListGrants(ctx context.Context, in *ListGrantsRequest, opts ...grpc.CallOption) (*ListGrantsResponse, error) {
	out := new(ListGrantsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/ListGrants", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) SearchGrants(ctx context.Context, in *SearchGrantsRequest, opts ...grpc.CallOption) (*SearchGrantsResponse, error) {
	out := new(SearchGrantsResponse)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/SearchGrants", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) GetGrant(ctx context.Context, in *GetGrantRequest, opts ...grpc.CallOption) (*Grant, error) {
	out := new(Grant)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/GetGrant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) CreateGrant(ctx context.Context, in *CreateGrantRequest, opts ...grpc.CallOption) (*Grant, error) {
	out := new(Grant)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/CreateGrant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) ApproveGrant(ctx context.Context, in *ApproveGrantRequest, opts ...grpc.CallOption) (*Grant, error) {
	out := new(Grant)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/ApproveGrant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) DenyGrant(ctx context.Context, in *DenyGrantRequest, opts ...grpc.CallOption) (*Grant, error) {
	out := new(Grant)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/DenyGrant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *privilegedAccessManagerClient) RevokeGrant(ctx context.Context, in *RevokeGrantRequest, opts ...grpc.CallOption) (*longrunningpb.Operation, error) {
	out := new(longrunningpb.Operation)
	err := c.cc.Invoke(ctx, "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/RevokeGrant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// PrivilegedAccessManagerServer is the server API for PrivilegedAccessManager service.
type PrivilegedAccessManagerServer interface {
	// `CheckOnboardingStatus` reports the onboarding status for a
	// project/folder/organization. Any findings reported by this API need to be
	// fixed before PAM can be used on the resource.
	CheckOnboardingStatus(context.Context, *CheckOnboardingStatusRequest) (*CheckOnboardingStatusResponse, error)
	// Lists entitlements in a given project/folder/organization and location.
	ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error)
	// `SearchEntitlements` returns entitlements on which the caller has the
	// specified access.
	SearchEntitlements(context.Context, *SearchEntitlementsRequest) (*SearchEntitlementsResponse, error)
	// Gets details of a single entitlement.
	GetEntitlement(context.Context, *GetEntitlementRequest) (*Entitlement, error)
	// Creates a new entitlement in a given project/folder/organization and
	// location.
	CreateEntitlement(context.Context, *CreateEntitlementRequest) (*longrunningpb.Operation, error)
	// Deletes a single entitlement. This method can only be called when there
	// are no in-progress (`ACTIVE`/`ACTIVATING`/`REVOKING`) grants under the
	// entitlement.
	DeleteEntitlement(context.Context, *DeleteEntitlementRequest) (*longrunningpb.Operation, error)
	// Updates the entitlement specified in the request. Updated fields in the
	// entitlement need to be specified in an update mask. The changes made to an
	// entitlement are applicable only on future grants of the entitlement.
	// However, if new approvers are added or existing approvers are removed from
	// the approval workflow, the changes are effective on existing grants.
	//
	// The following fields are not supported for updates:
	//
	//   - All immutable fields
	//   - Entitlement name
	//   - Resource name
	//   - Resource type
	//   - Adding an approval workflow in an entitlement which previously had no
	//     approval workflow.
	//   - Deleting the approval workflow from an entitlement.
	//   - Adding or deleting a step in the approval workflow (only one step is
	//     supported)
	//
	// Note that updates are allowed on the list of approvers in an approval
	// workflow step.
	UpdateEntitlement(context.Context, *UpdateEntitlementRequest) (*longrunningpb.Operation, error)
	// Lists grants for a given entitlement.
	ListGrants(context.Context, *ListGrantsRequest) (*ListGrantsResponse, error)
	// `SearchGrants` returns grants that are related to the calling user in the
	// specified way.
	SearchGrants(context.Context, *SearchGrantsRequest) (*SearchGrantsResponse, error)
	// Get details of a single grant.
	GetGrant(context.Context, *GetGrantRequest) (*Grant, error)
	// Creates a new grant in a given project/folder/organization and
	// location.
	CreateGrant(context.Context, *CreateGrantRequest) (*Grant, error)
	// `ApproveGrant` is used to approve a grant. This method can only be called
	// on a grant when it's in the `APPROVAL_AWAITED` state. This operation can't
	// be undone.
	ApproveGrant(context.Context, *ApproveGrantRequest) (*Grant, error)
	// `DenyGrant` is used to deny a grant. This method can only be called on a
	// grant when it's in the `APPROVAL_AWAITED` state. This operation can't be
	// undone.
	DenyGrant(context.Context, *DenyGrantRequest) (*Grant, error)
	// `RevokeGrant` is used to immediately revoke access for a grant. This method
	// can be called when the grant is in a non-terminal state.
	RevokeGrant(context.Context, *RevokeGrantRequest) (*longrunningpb.Operation, error)
}

// UnimplementedPrivilegedAccessManagerServer can be embedded to have forward compatible implementations.
type UnimplementedPrivilegedAccessManagerServer struct {
}

func (*UnimplementedPrivilegedAccessManagerServer) CheckOnboardingStatus(context.Context, *CheckOnboardingStatusRequest) (*CheckOnboardingStatusResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CheckOnboardingStatus not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) ListEntitlements(context.Context, *ListEntitlementsRequest) (*ListEntitlementsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListEntitlements not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) SearchEntitlements(context.Context, *SearchEntitlementsRequest) (*SearchEntitlementsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchEntitlements not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) GetEntitlement(context.Context, *GetEntitlementRequest) (*Entitlement, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetEntitlement not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) CreateEntitlement(context.Context, *CreateEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateEntitlement not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) DeleteEntitlement(context.Context, *DeleteEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DeleteEntitlement not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) UpdateEntitlement(context.Context, *UpdateEntitlementRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method UpdateEntitlement not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) ListGrants(context.Context, *ListGrantsRequest) (*ListGrantsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ListGrants not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) SearchGrants(context.Context, *SearchGrantsRequest) (*SearchGrantsResponse, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method SearchGrants not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) GetGrant(context.Context, *GetGrantRequest) (*Grant, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method GetGrant not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) CreateGrant(context.Context, *CreateGrantRequest) (*Grant, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method CreateGrant not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) ApproveGrant(context.Context, *ApproveGrantRequest) (*Grant, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method ApproveGrant not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) DenyGrant(context.Context, *DenyGrantRequest) (*Grant, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method DenyGrant not implemented")
}
func (*UnimplementedPrivilegedAccessManagerServer) RevokeGrant(context.Context, *RevokeGrantRequest) (*longrunningpb.Operation, error) {
	return nil, status1.Errorf(codes.Unimplemented, "method RevokeGrant not implemented")
}

func RegisterPrivilegedAccessManagerServer(s *grpc.Server, srv PrivilegedAccessManagerServer) {
	s.RegisterService(&_PrivilegedAccessManager_serviceDesc, srv)
}

func _PrivilegedAccessManager_CheckOnboardingStatus_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CheckOnboardingStatusRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).CheckOnboardingStatus(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/CheckOnboardingStatus",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).CheckOnboardingStatus(ctx, req.(*CheckOnboardingStatusRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_ListEntitlements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListEntitlementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).ListEntitlements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/ListEntitlements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).ListEntitlements(ctx, req.(*ListEntitlementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_SearchEntitlements_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchEntitlementsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).SearchEntitlements(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/SearchEntitlements",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).SearchEntitlements(ctx, req.(*SearchEntitlementsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_GetEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).GetEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/GetEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).GetEntitlement(ctx, req.(*GetEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_CreateEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).CreateEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/CreateEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).CreateEntitlement(ctx, req.(*CreateEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_DeleteEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).DeleteEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/DeleteEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).DeleteEntitlement(ctx, req.(*DeleteEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_UpdateEntitlement_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateEntitlementRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).UpdateEntitlement(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/UpdateEntitlement",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).UpdateEntitlement(ctx, req.(*UpdateEntitlementRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_ListGrants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ListGrantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).ListGrants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/ListGrants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).ListGrants(ctx, req.(*ListGrantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_SearchGrants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchGrantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).SearchGrants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/SearchGrants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).SearchGrants(ctx, req.(*SearchGrantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_GetGrant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetGrantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).GetGrant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/GetGrant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).GetGrant(ctx, req.(*GetGrantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_CreateGrant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateGrantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).CreateGrant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/CreateGrant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).CreateGrant(ctx, req.(*CreateGrantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_ApproveGrant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ApproveGrantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).ApproveGrant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/ApproveGrant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).ApproveGrant(ctx, req.(*ApproveGrantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_DenyGrant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DenyGrantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).DenyGrant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/DenyGrant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).DenyGrant(ctx, req.(*DenyGrantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _PrivilegedAccessManager_RevokeGrant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(RevokeGrantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(PrivilegedAccessManagerServer).RevokeGrant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager/RevokeGrant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(PrivilegedAccessManagerServer).RevokeGrant(ctx, req.(*RevokeGrantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _PrivilegedAccessManager_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.cloud.privilegedaccessmanager.v1.PrivilegedAccessManager",
	HandlerType: (*PrivilegedAccessManagerServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "CheckOnboardingStatus",
			Handler:    _PrivilegedAccessManager_CheckOnboardingStatus_Handler,
		},
		{
			MethodName: "ListEntitlements",
			Handler:    _PrivilegedAccessManager_ListEntitlements_Handler,
		},
		{
			MethodName: "SearchEntitlements",
			Handler:    _PrivilegedAccessManager_SearchEntitlements_Handler,
		},
		{
			MethodName: "GetEntitlement",
			Handler:    _PrivilegedAccessManager_GetEntitlement_Handler,
		},
		{
			MethodName: "CreateEntitlement",
			Handler:    _PrivilegedAccessManager_CreateEntitlement_Handler,
		},
		{
			MethodName: "DeleteEntitlement",
			Handler:    _PrivilegedAccessManager_DeleteEntitlement_Handler,
		},
		{
			MethodName: "UpdateEntitlement",
			Handler:    _PrivilegedAccessManager_UpdateEntitlement_Handler,
		},
		{
			MethodName: "ListGrants",
			Handler:    _PrivilegedAccessManager_ListGrants_Handler,
		},
		{
			MethodName: "SearchGrants",
			Handler:    _PrivilegedAccessManager_SearchGrants_Handler,
		},
		{
			MethodName: "GetGrant",
			Handler:    _PrivilegedAccessManager_GetGrant_Handler,
		},
		{
			MethodName: "CreateGrant",
			Handler:    _PrivilegedAccessManager_CreateGrant_Handler,
		},
		{
			MethodName: "ApproveGrant",
			Handler:    _PrivilegedAccessManager_ApproveGrant_Handler,
		},
		{
			MethodName: "DenyGrant",
			Handler:    _PrivilegedAccessManager_DenyGrant_Handler,
		},
		{
			MethodName: "RevokeGrant",
			Handler:    _PrivilegedAccessManager_RevokeGrant_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto",
}
