// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package accounts

import (
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"
	"time"

	accountspb "cloud.google.com/go/shopping/merchant/accounts/apiv1beta/accountspb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	"google.golang.org/grpc"
	"google.golang.org/grpc/codes"
	"google.golang.org/protobuf/encoding/protojson"
)

var newTermsOfServiceAgreementStateClientHook clientHook

// TermsOfServiceAgreementStateCallOptions contains the retry settings for each method of TermsOfServiceAgreementStateClient.
type TermsOfServiceAgreementStateCallOptions struct {
	GetTermsOfServiceAgreementState                    []gax.CallOption
	RetrieveForApplicationTermsOfServiceAgreementState []gax.CallOption
}

func defaultTermsOfServiceAgreementStateGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("merchantapi.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("merchantapi.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("merchantapi.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultTermsOfServiceAgreementStateCallOptions() *TermsOfServiceAgreementStateCallOptions {
	return &TermsOfServiceAgreementStateCallOptions{
		GetTermsOfServiceAgreementState: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
		RetrieveForApplicationTermsOfServiceAgreementState: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnCodes([]codes.Code{
					codes.Unavailable,
				}, gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				})
			}),
		},
	}
}

func defaultTermsOfServiceAgreementStateRESTCallOptions() *TermsOfServiceAgreementStateCallOptions {
	return &TermsOfServiceAgreementStateCallOptions{
		GetTermsOfServiceAgreementState: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
		RetrieveForApplicationTermsOfServiceAgreementState: []gax.CallOption{
			gax.WithTimeout(60000 * time.Millisecond),
			gax.WithRetry(func() gax.Retryer {
				return gax.OnHTTPCodes(gax.Backoff{
					Initial:    1000 * time.Millisecond,
					Max:        10000 * time.Millisecond,
					Multiplier: 1.30,
				},
					http.StatusServiceUnavailable)
			}),
		},
	}
}

// internalTermsOfServiceAgreementStateClient is an interface that defines the methods available from Merchant API.
type internalTermsOfServiceAgreementStateClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	GetTermsOfServiceAgreementState(context.Context, *accountspb.GetTermsOfServiceAgreementStateRequest, ...gax.CallOption) (*accountspb.TermsOfServiceAgreementState, error)
	RetrieveForApplicationTermsOfServiceAgreementState(context.Context, *accountspb.RetrieveForApplicationTermsOfServiceAgreementStateRequest, ...gax.CallOption) (*accountspb.TermsOfServiceAgreementState, error)
}

// TermsOfServiceAgreementStateClient is a client for interacting with Merchant API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// Service to support TermsOfServiceAgreementState API.
type TermsOfServiceAgreementStateClient struct {
	// The internal transport-dependent client.
	internalClient internalTermsOfServiceAgreementStateClient

	// The call options for this service.
	CallOptions *TermsOfServiceAgreementStateCallOptions
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *TermsOfServiceAgreementStateClient) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *TermsOfServiceAgreementStateClient) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *TermsOfServiceAgreementStateClient) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// GetTermsOfServiceAgreementState returns the state of a terms of service agreement.
func (c *TermsOfServiceAgreementStateClient) GetTermsOfServiceAgreementState(ctx context.Context, req *accountspb.GetTermsOfServiceAgreementStateRequest, opts ...gax.CallOption) (*accountspb.TermsOfServiceAgreementState, error) {
	return c.internalClient.GetTermsOfServiceAgreementState(ctx, req, opts...)
}

// RetrieveForApplicationTermsOfServiceAgreementState retrieves the state of the agreement for the application terms of service.
func (c *TermsOfServiceAgreementStateClient) RetrieveForApplicationTermsOfServiceAgreementState(ctx context.Context, req *accountspb.RetrieveForApplicationTermsOfServiceAgreementStateRequest, opts ...gax.CallOption) (*accountspb.TermsOfServiceAgreementState, error) {
	return c.internalClient.RetrieveForApplicationTermsOfServiceAgreementState(ctx, req, opts...)
}

// termsOfServiceAgreementStateGRPCClient is a client for interacting with Merchant API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type termsOfServiceAgreementStateGRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing TermsOfServiceAgreementStateClient
	CallOptions **TermsOfServiceAgreementStateCallOptions

	// The gRPC API client.
	termsOfServiceAgreementStateClient accountspb.TermsOfServiceAgreementStateServiceClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewTermsOfServiceAgreementStateClient creates a new terms of service agreement state service client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// Service to support TermsOfServiceAgreementState API.
func NewTermsOfServiceAgreementStateClient(ctx context.Context, opts ...option.ClientOption) (*TermsOfServiceAgreementStateClient, error) {
	clientOpts := defaultTermsOfServiceAgreementStateGRPCClientOptions()
	if newTermsOfServiceAgreementStateClientHook != nil {
		hookOpts, err := newTermsOfServiceAgreementStateClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := TermsOfServiceAgreementStateClient{CallOptions: defaultTermsOfServiceAgreementStateCallOptions()}

	c := &termsOfServiceAgreementStateGRPCClient{
		connPool:                           connPool,
		termsOfServiceAgreementStateClient: accountspb.NewTermsOfServiceAgreementStateServiceClient(connPool),
		CallOptions:                        &client.CallOptions,
		logger:                             internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *termsOfServiceAgreementStateGRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *termsOfServiceAgreementStateGRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *termsOfServiceAgreementStateGRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type termsOfServiceAgreementStateRESTClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing TermsOfServiceAgreementStateClient
	CallOptions **TermsOfServiceAgreementStateCallOptions

	logger *slog.Logger
}

// NewTermsOfServiceAgreementStateRESTClient creates a new terms of service agreement state service rest client.
//
// Service to support TermsOfServiceAgreementState API.
func NewTermsOfServiceAgreementStateRESTClient(ctx context.Context, opts ...option.ClientOption) (*TermsOfServiceAgreementStateClient, error) {
	clientOpts := append(defaultTermsOfServiceAgreementStateRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultTermsOfServiceAgreementStateRESTCallOptions()
	c := &termsOfServiceAgreementStateRESTClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	return &TermsOfServiceAgreementStateClient{internalClient: c, CallOptions: callOpts}, nil
}

func defaultTermsOfServiceAgreementStateRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://merchantapi.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://merchantapi.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://merchantapi.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://merchantapi.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *termsOfServiceAgreementStateRESTClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *termsOfServiceAgreementStateRESTClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *termsOfServiceAgreementStateRESTClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *termsOfServiceAgreementStateGRPCClient) GetTermsOfServiceAgreementState(ctx context.Context, req *accountspb.GetTermsOfServiceAgreementStateRequest, opts ...gax.CallOption) (*accountspb.TermsOfServiceAgreementState, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetTermsOfServiceAgreementState[0:len((*c.CallOptions).GetTermsOfServiceAgreementState):len((*c.CallOptions).GetTermsOfServiceAgreementState)], opts...)
	var resp *accountspb.TermsOfServiceAgreementState
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.termsOfServiceAgreementStateClient.GetTermsOfServiceAgreementState, req, settings.GRPC, c.logger, "GetTermsOfServiceAgreementState")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *termsOfServiceAgreementStateGRPCClient) RetrieveForApplicationTermsOfServiceAgreementState(ctx context.Context, req *accountspb.RetrieveForApplicationTermsOfServiceAgreementStateRequest, opts ...gax.CallOption) (*accountspb.TermsOfServiceAgreementState, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RetrieveForApplicationTermsOfServiceAgreementState[0:len((*c.CallOptions).RetrieveForApplicationTermsOfServiceAgreementState):len((*c.CallOptions).RetrieveForApplicationTermsOfServiceAgreementState)], opts...)
	var resp *accountspb.TermsOfServiceAgreementState
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.termsOfServiceAgreementStateClient.RetrieveForApplicationTermsOfServiceAgreementState, req, settings.GRPC, c.logger, "RetrieveForApplicationTermsOfServiceAgreementState")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

// GetTermsOfServiceAgreementState returns the state of a terms of service agreement.
func (c *termsOfServiceAgreementStateRESTClient) GetTermsOfServiceAgreementState(ctx context.Context, req *accountspb.GetTermsOfServiceAgreementStateRequest, opts ...gax.CallOption) (*accountspb.TermsOfServiceAgreementState, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetTermsOfServiceAgreementState[0:len((*c.CallOptions).GetTermsOfServiceAgreementState):len((*c.CallOptions).GetTermsOfServiceAgreementState)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accountspb.TermsOfServiceAgreementState{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetTermsOfServiceAgreementState")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// RetrieveForApplicationTermsOfServiceAgreementState retrieves the state of the agreement for the application terms of service.
func (c *termsOfServiceAgreementStateRESTClient) RetrieveForApplicationTermsOfServiceAgreementState(ctx context.Context, req *accountspb.RetrieveForApplicationTermsOfServiceAgreementStateRequest, opts ...gax.CallOption) (*accountspb.TermsOfServiceAgreementState, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/accounts/v1beta/%v/termsOfServiceAgreementStates:retrieveForApplication", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).RetrieveForApplicationTermsOfServiceAgreementState[0:len((*c.CallOptions).RetrieveForApplicationTermsOfServiceAgreementState):len((*c.CallOptions).RetrieveForApplicationTermsOfServiceAgreementState)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &accountspb.TermsOfServiceAgreementState{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "RetrieveForApplicationTermsOfServiceAgreementState")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}
