// Copyright 2025 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     https://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go_gapic. DO NOT EDIT.

package telcoautomation

import (
	"bytes"
	"context"
	"fmt"
	"log/slog"
	"math"
	"net/http"
	"net/url"

	"cloud.google.com/go/longrunning"
	lroauto "cloud.google.com/go/longrunning/autogen"
	longrunningpb "cloud.google.com/go/longrunning/autogen/longrunningpb"
	telcoautomationpb "cloud.google.com/go/telcoautomation/apiv1/telcoautomationpb"
	gax "github.com/googleapis/gax-go/v2"
	"google.golang.org/api/iterator"
	"google.golang.org/api/option"
	"google.golang.org/api/option/internaloption"
	gtransport "google.golang.org/api/transport/grpc"
	httptransport "google.golang.org/api/transport/http"
	locationpb "google.golang.org/genproto/googleapis/cloud/location"
	"google.golang.org/grpc"
	"google.golang.org/protobuf/encoding/protojson"
	"google.golang.org/protobuf/proto"
)

var newClientHook clientHook

// CallOptions contains the retry settings for each method of Client.
type CallOptions struct {
	ListOrchestrationClusters  []gax.CallOption
	GetOrchestrationCluster    []gax.CallOption
	CreateOrchestrationCluster []gax.CallOption
	DeleteOrchestrationCluster []gax.CallOption
	ListEdgeSlms               []gax.CallOption
	GetEdgeSlm                 []gax.CallOption
	CreateEdgeSlm              []gax.CallOption
	DeleteEdgeSlm              []gax.CallOption
	CreateBlueprint            []gax.CallOption
	UpdateBlueprint            []gax.CallOption
	GetBlueprint               []gax.CallOption
	DeleteBlueprint            []gax.CallOption
	ListBlueprints             []gax.CallOption
	ApproveBlueprint           []gax.CallOption
	ProposeBlueprint           []gax.CallOption
	RejectBlueprint            []gax.CallOption
	ListBlueprintRevisions     []gax.CallOption
	SearchBlueprintRevisions   []gax.CallOption
	SearchDeploymentRevisions  []gax.CallOption
	DiscardBlueprintChanges    []gax.CallOption
	ListPublicBlueprints       []gax.CallOption
	GetPublicBlueprint         []gax.CallOption
	CreateDeployment           []gax.CallOption
	UpdateDeployment           []gax.CallOption
	GetDeployment              []gax.CallOption
	RemoveDeployment           []gax.CallOption
	ListDeployments            []gax.CallOption
	ListDeploymentRevisions    []gax.CallOption
	DiscardDeploymentChanges   []gax.CallOption
	ApplyDeployment            []gax.CallOption
	ComputeDeploymentStatus    []gax.CallOption
	RollbackDeployment         []gax.CallOption
	GetHydratedDeployment      []gax.CallOption
	ListHydratedDeployments    []gax.CallOption
	UpdateHydratedDeployment   []gax.CallOption
	ApplyHydratedDeployment    []gax.CallOption
	GetLocation                []gax.CallOption
	ListLocations              []gax.CallOption
	CancelOperation            []gax.CallOption
	DeleteOperation            []gax.CallOption
	GetOperation               []gax.CallOption
	ListOperations             []gax.CallOption
}

func defaultGRPCClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("telcoautomation.googleapis.com:443"),
		internaloption.WithDefaultEndpointTemplate("telcoautomation.UNIVERSE_DOMAIN:443"),
		internaloption.WithDefaultMTLSEndpoint("telcoautomation.mtls.googleapis.com:443"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://telcoautomation.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableJwtWithScope(),
		internaloption.EnableNewAuthLibrary(),
		option.WithGRPCDialOption(grpc.WithDefaultCallOptions(
			grpc.MaxCallRecvMsgSize(math.MaxInt32))),
	}
}

func defaultCallOptions() *CallOptions {
	return &CallOptions{
		ListOrchestrationClusters:  []gax.CallOption{},
		GetOrchestrationCluster:    []gax.CallOption{},
		CreateOrchestrationCluster: []gax.CallOption{},
		DeleteOrchestrationCluster: []gax.CallOption{},
		ListEdgeSlms:               []gax.CallOption{},
		GetEdgeSlm:                 []gax.CallOption{},
		CreateEdgeSlm:              []gax.CallOption{},
		DeleteEdgeSlm:              []gax.CallOption{},
		CreateBlueprint:            []gax.CallOption{},
		UpdateBlueprint:            []gax.CallOption{},
		GetBlueprint:               []gax.CallOption{},
		DeleteBlueprint:            []gax.CallOption{},
		ListBlueprints:             []gax.CallOption{},
		ApproveBlueprint:           []gax.CallOption{},
		ProposeBlueprint:           []gax.CallOption{},
		RejectBlueprint:            []gax.CallOption{},
		ListBlueprintRevisions:     []gax.CallOption{},
		SearchBlueprintRevisions:   []gax.CallOption{},
		SearchDeploymentRevisions:  []gax.CallOption{},
		DiscardBlueprintChanges:    []gax.CallOption{},
		ListPublicBlueprints:       []gax.CallOption{},
		GetPublicBlueprint:         []gax.CallOption{},
		CreateDeployment:           []gax.CallOption{},
		UpdateDeployment:           []gax.CallOption{},
		GetDeployment:              []gax.CallOption{},
		RemoveDeployment:           []gax.CallOption{},
		ListDeployments:            []gax.CallOption{},
		ListDeploymentRevisions:    []gax.CallOption{},
		DiscardDeploymentChanges:   []gax.CallOption{},
		ApplyDeployment:            []gax.CallOption{},
		ComputeDeploymentStatus:    []gax.CallOption{},
		RollbackDeployment:         []gax.CallOption{},
		GetHydratedDeployment:      []gax.CallOption{},
		ListHydratedDeployments:    []gax.CallOption{},
		UpdateHydratedDeployment:   []gax.CallOption{},
		ApplyHydratedDeployment:    []gax.CallOption{},
		GetLocation:                []gax.CallOption{},
		ListLocations:              []gax.CallOption{},
		CancelOperation:            []gax.CallOption{},
		DeleteOperation:            []gax.CallOption{},
		GetOperation:               []gax.CallOption{},
		ListOperations:             []gax.CallOption{},
	}
}

func defaultRESTCallOptions() *CallOptions {
	return &CallOptions{
		ListOrchestrationClusters:  []gax.CallOption{},
		GetOrchestrationCluster:    []gax.CallOption{},
		CreateOrchestrationCluster: []gax.CallOption{},
		DeleteOrchestrationCluster: []gax.CallOption{},
		ListEdgeSlms:               []gax.CallOption{},
		GetEdgeSlm:                 []gax.CallOption{},
		CreateEdgeSlm:              []gax.CallOption{},
		DeleteEdgeSlm:              []gax.CallOption{},
		CreateBlueprint:            []gax.CallOption{},
		UpdateBlueprint:            []gax.CallOption{},
		GetBlueprint:               []gax.CallOption{},
		DeleteBlueprint:            []gax.CallOption{},
		ListBlueprints:             []gax.CallOption{},
		ApproveBlueprint:           []gax.CallOption{},
		ProposeBlueprint:           []gax.CallOption{},
		RejectBlueprint:            []gax.CallOption{},
		ListBlueprintRevisions:     []gax.CallOption{},
		SearchBlueprintRevisions:   []gax.CallOption{},
		SearchDeploymentRevisions:  []gax.CallOption{},
		DiscardBlueprintChanges:    []gax.CallOption{},
		ListPublicBlueprints:       []gax.CallOption{},
		GetPublicBlueprint:         []gax.CallOption{},
		CreateDeployment:           []gax.CallOption{},
		UpdateDeployment:           []gax.CallOption{},
		GetDeployment:              []gax.CallOption{},
		RemoveDeployment:           []gax.CallOption{},
		ListDeployments:            []gax.CallOption{},
		ListDeploymentRevisions:    []gax.CallOption{},
		DiscardDeploymentChanges:   []gax.CallOption{},
		ApplyDeployment:            []gax.CallOption{},
		ComputeDeploymentStatus:    []gax.CallOption{},
		RollbackDeployment:         []gax.CallOption{},
		GetHydratedDeployment:      []gax.CallOption{},
		ListHydratedDeployments:    []gax.CallOption{},
		UpdateHydratedDeployment:   []gax.CallOption{},
		ApplyHydratedDeployment:    []gax.CallOption{},
		GetLocation:                []gax.CallOption{},
		ListLocations:              []gax.CallOption{},
		CancelOperation:            []gax.CallOption{},
		DeleteOperation:            []gax.CallOption{},
		GetOperation:               []gax.CallOption{},
		ListOperations:             []gax.CallOption{},
	}
}

// internalClient is an interface that defines the methods available from Telco Automation API.
type internalClient interface {
	Close() error
	setGoogleClientInfo(...string)
	Connection() *grpc.ClientConn
	ListOrchestrationClusters(context.Context, *telcoautomationpb.ListOrchestrationClustersRequest, ...gax.CallOption) *OrchestrationClusterIterator
	GetOrchestrationCluster(context.Context, *telcoautomationpb.GetOrchestrationClusterRequest, ...gax.CallOption) (*telcoautomationpb.OrchestrationCluster, error)
	CreateOrchestrationCluster(context.Context, *telcoautomationpb.CreateOrchestrationClusterRequest, ...gax.CallOption) (*CreateOrchestrationClusterOperation, error)
	CreateOrchestrationClusterOperation(name string) *CreateOrchestrationClusterOperation
	DeleteOrchestrationCluster(context.Context, *telcoautomationpb.DeleteOrchestrationClusterRequest, ...gax.CallOption) (*DeleteOrchestrationClusterOperation, error)
	DeleteOrchestrationClusterOperation(name string) *DeleteOrchestrationClusterOperation
	ListEdgeSlms(context.Context, *telcoautomationpb.ListEdgeSlmsRequest, ...gax.CallOption) *EdgeSlmIterator
	GetEdgeSlm(context.Context, *telcoautomationpb.GetEdgeSlmRequest, ...gax.CallOption) (*telcoautomationpb.EdgeSlm, error)
	CreateEdgeSlm(context.Context, *telcoautomationpb.CreateEdgeSlmRequest, ...gax.CallOption) (*CreateEdgeSlmOperation, error)
	CreateEdgeSlmOperation(name string) *CreateEdgeSlmOperation
	DeleteEdgeSlm(context.Context, *telcoautomationpb.DeleteEdgeSlmRequest, ...gax.CallOption) (*DeleteEdgeSlmOperation, error)
	DeleteEdgeSlmOperation(name string) *DeleteEdgeSlmOperation
	CreateBlueprint(context.Context, *telcoautomationpb.CreateBlueprintRequest, ...gax.CallOption) (*telcoautomationpb.Blueprint, error)
	UpdateBlueprint(context.Context, *telcoautomationpb.UpdateBlueprintRequest, ...gax.CallOption) (*telcoautomationpb.Blueprint, error)
	GetBlueprint(context.Context, *telcoautomationpb.GetBlueprintRequest, ...gax.CallOption) (*telcoautomationpb.Blueprint, error)
	DeleteBlueprint(context.Context, *telcoautomationpb.DeleteBlueprintRequest, ...gax.CallOption) error
	ListBlueprints(context.Context, *telcoautomationpb.ListBlueprintsRequest, ...gax.CallOption) *BlueprintIterator
	ApproveBlueprint(context.Context, *telcoautomationpb.ApproveBlueprintRequest, ...gax.CallOption) (*telcoautomationpb.Blueprint, error)
	ProposeBlueprint(context.Context, *telcoautomationpb.ProposeBlueprintRequest, ...gax.CallOption) (*telcoautomationpb.Blueprint, error)
	RejectBlueprint(context.Context, *telcoautomationpb.RejectBlueprintRequest, ...gax.CallOption) (*telcoautomationpb.Blueprint, error)
	ListBlueprintRevisions(context.Context, *telcoautomationpb.ListBlueprintRevisionsRequest, ...gax.CallOption) *BlueprintIterator
	SearchBlueprintRevisions(context.Context, *telcoautomationpb.SearchBlueprintRevisionsRequest, ...gax.CallOption) *BlueprintIterator
	SearchDeploymentRevisions(context.Context, *telcoautomationpb.SearchDeploymentRevisionsRequest, ...gax.CallOption) *DeploymentIterator
	DiscardBlueprintChanges(context.Context, *telcoautomationpb.DiscardBlueprintChangesRequest, ...gax.CallOption) (*telcoautomationpb.DiscardBlueprintChangesResponse, error)
	ListPublicBlueprints(context.Context, *telcoautomationpb.ListPublicBlueprintsRequest, ...gax.CallOption) *PublicBlueprintIterator
	GetPublicBlueprint(context.Context, *telcoautomationpb.GetPublicBlueprintRequest, ...gax.CallOption) (*telcoautomationpb.PublicBlueprint, error)
	CreateDeployment(context.Context, *telcoautomationpb.CreateDeploymentRequest, ...gax.CallOption) (*telcoautomationpb.Deployment, error)
	UpdateDeployment(context.Context, *telcoautomationpb.UpdateDeploymentRequest, ...gax.CallOption) (*telcoautomationpb.Deployment, error)
	GetDeployment(context.Context, *telcoautomationpb.GetDeploymentRequest, ...gax.CallOption) (*telcoautomationpb.Deployment, error)
	RemoveDeployment(context.Context, *telcoautomationpb.RemoveDeploymentRequest, ...gax.CallOption) error
	ListDeployments(context.Context, *telcoautomationpb.ListDeploymentsRequest, ...gax.CallOption) *DeploymentIterator
	ListDeploymentRevisions(context.Context, *telcoautomationpb.ListDeploymentRevisionsRequest, ...gax.CallOption) *DeploymentIterator
	DiscardDeploymentChanges(context.Context, *telcoautomationpb.DiscardDeploymentChangesRequest, ...gax.CallOption) (*telcoautomationpb.DiscardDeploymentChangesResponse, error)
	ApplyDeployment(context.Context, *telcoautomationpb.ApplyDeploymentRequest, ...gax.CallOption) (*telcoautomationpb.Deployment, error)
	ComputeDeploymentStatus(context.Context, *telcoautomationpb.ComputeDeploymentStatusRequest, ...gax.CallOption) (*telcoautomationpb.ComputeDeploymentStatusResponse, error)
	RollbackDeployment(context.Context, *telcoautomationpb.RollbackDeploymentRequest, ...gax.CallOption) (*telcoautomationpb.Deployment, error)
	GetHydratedDeployment(context.Context, *telcoautomationpb.GetHydratedDeploymentRequest, ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error)
	ListHydratedDeployments(context.Context, *telcoautomationpb.ListHydratedDeploymentsRequest, ...gax.CallOption) *HydratedDeploymentIterator
	UpdateHydratedDeployment(context.Context, *telcoautomationpb.UpdateHydratedDeploymentRequest, ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error)
	ApplyHydratedDeployment(context.Context, *telcoautomationpb.ApplyHydratedDeploymentRequest, ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error)
	GetLocation(context.Context, *locationpb.GetLocationRequest, ...gax.CallOption) (*locationpb.Location, error)
	ListLocations(context.Context, *locationpb.ListLocationsRequest, ...gax.CallOption) *LocationIterator
	CancelOperation(context.Context, *longrunningpb.CancelOperationRequest, ...gax.CallOption) error
	DeleteOperation(context.Context, *longrunningpb.DeleteOperationRequest, ...gax.CallOption) error
	GetOperation(context.Context, *longrunningpb.GetOperationRequest, ...gax.CallOption) (*longrunningpb.Operation, error)
	ListOperations(context.Context, *longrunningpb.ListOperationsRequest, ...gax.CallOption) *OperationIterator
}

// Client is a client for interacting with Telco Automation API.
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
//
// TelcoAutomation Service manages the control plane cluster a.k.a.
// Orchestration Cluster (GKE cluster with config controller) of TNA. It also
// exposes blueprint APIs which manages the lifecycle of blueprints that control
// the infrastructure setup (e.g GDCE clusters) and deployment of network
// functions.
type Client struct {
	// The internal transport-dependent client.
	internalClient internalClient

	// The call options for this service.
	CallOptions *CallOptions

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient *lroauto.OperationsClient
}

// Wrapper methods routed to the internal client.

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *Client) Close() error {
	return c.internalClient.Close()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *Client) setGoogleClientInfo(keyval ...string) {
	c.internalClient.setGoogleClientInfo(keyval...)
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *Client) Connection() *grpc.ClientConn {
	return c.internalClient.Connection()
}

// ListOrchestrationClusters lists OrchestrationClusters in a given project and location.
func (c *Client) ListOrchestrationClusters(ctx context.Context, req *telcoautomationpb.ListOrchestrationClustersRequest, opts ...gax.CallOption) *OrchestrationClusterIterator {
	return c.internalClient.ListOrchestrationClusters(ctx, req, opts...)
}

// GetOrchestrationCluster gets details of a single OrchestrationCluster.
func (c *Client) GetOrchestrationCluster(ctx context.Context, req *telcoautomationpb.GetOrchestrationClusterRequest, opts ...gax.CallOption) (*telcoautomationpb.OrchestrationCluster, error) {
	return c.internalClient.GetOrchestrationCluster(ctx, req, opts...)
}

// CreateOrchestrationCluster creates a new OrchestrationCluster in a given project and location.
func (c *Client) CreateOrchestrationCluster(ctx context.Context, req *telcoautomationpb.CreateOrchestrationClusterRequest, opts ...gax.CallOption) (*CreateOrchestrationClusterOperation, error) {
	return c.internalClient.CreateOrchestrationCluster(ctx, req, opts...)
}

// CreateOrchestrationClusterOperation returns a new CreateOrchestrationClusterOperation from a given name.
// The name must be that of a previously created CreateOrchestrationClusterOperation, possibly from a different process.
func (c *Client) CreateOrchestrationClusterOperation(name string) *CreateOrchestrationClusterOperation {
	return c.internalClient.CreateOrchestrationClusterOperation(name)
}

// DeleteOrchestrationCluster deletes a single OrchestrationCluster.
func (c *Client) DeleteOrchestrationCluster(ctx context.Context, req *telcoautomationpb.DeleteOrchestrationClusterRequest, opts ...gax.CallOption) (*DeleteOrchestrationClusterOperation, error) {
	return c.internalClient.DeleteOrchestrationCluster(ctx, req, opts...)
}

// DeleteOrchestrationClusterOperation returns a new DeleteOrchestrationClusterOperation from a given name.
// The name must be that of a previously created DeleteOrchestrationClusterOperation, possibly from a different process.
func (c *Client) DeleteOrchestrationClusterOperation(name string) *DeleteOrchestrationClusterOperation {
	return c.internalClient.DeleteOrchestrationClusterOperation(name)
}

// ListEdgeSlms lists EdgeSlms in a given project and location.
func (c *Client) ListEdgeSlms(ctx context.Context, req *telcoautomationpb.ListEdgeSlmsRequest, opts ...gax.CallOption) *EdgeSlmIterator {
	return c.internalClient.ListEdgeSlms(ctx, req, opts...)
}

// GetEdgeSlm gets details of a single EdgeSlm.
func (c *Client) GetEdgeSlm(ctx context.Context, req *telcoautomationpb.GetEdgeSlmRequest, opts ...gax.CallOption) (*telcoautomationpb.EdgeSlm, error) {
	return c.internalClient.GetEdgeSlm(ctx, req, opts...)
}

// CreateEdgeSlm creates a new EdgeSlm in a given project and location.
func (c *Client) CreateEdgeSlm(ctx context.Context, req *telcoautomationpb.CreateEdgeSlmRequest, opts ...gax.CallOption) (*CreateEdgeSlmOperation, error) {
	return c.internalClient.CreateEdgeSlm(ctx, req, opts...)
}

// CreateEdgeSlmOperation returns a new CreateEdgeSlmOperation from a given name.
// The name must be that of a previously created CreateEdgeSlmOperation, possibly from a different process.
func (c *Client) CreateEdgeSlmOperation(name string) *CreateEdgeSlmOperation {
	return c.internalClient.CreateEdgeSlmOperation(name)
}

// DeleteEdgeSlm deletes a single EdgeSlm.
func (c *Client) DeleteEdgeSlm(ctx context.Context, req *telcoautomationpb.DeleteEdgeSlmRequest, opts ...gax.CallOption) (*DeleteEdgeSlmOperation, error) {
	return c.internalClient.DeleteEdgeSlm(ctx, req, opts...)
}

// DeleteEdgeSlmOperation returns a new DeleteEdgeSlmOperation from a given name.
// The name must be that of a previously created DeleteEdgeSlmOperation, possibly from a different process.
func (c *Client) DeleteEdgeSlmOperation(name string) *DeleteEdgeSlmOperation {
	return c.internalClient.DeleteEdgeSlmOperation(name)
}

// CreateBlueprint creates a blueprint.
func (c *Client) CreateBlueprint(ctx context.Context, req *telcoautomationpb.CreateBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	return c.internalClient.CreateBlueprint(ctx, req, opts...)
}

// UpdateBlueprint updates a blueprint.
func (c *Client) UpdateBlueprint(ctx context.Context, req *telcoautomationpb.UpdateBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	return c.internalClient.UpdateBlueprint(ctx, req, opts...)
}

// GetBlueprint returns the requested blueprint.
func (c *Client) GetBlueprint(ctx context.Context, req *telcoautomationpb.GetBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	return c.internalClient.GetBlueprint(ctx, req, opts...)
}

// DeleteBlueprint deletes a blueprint and all its revisions.
func (c *Client) DeleteBlueprint(ctx context.Context, req *telcoautomationpb.DeleteBlueprintRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteBlueprint(ctx, req, opts...)
}

// ListBlueprints list all blueprints.
func (c *Client) ListBlueprints(ctx context.Context, req *telcoautomationpb.ListBlueprintsRequest, opts ...gax.CallOption) *BlueprintIterator {
	return c.internalClient.ListBlueprints(ctx, req, opts...)
}

// ApproveBlueprint approves a blueprint and commits a new revision.
func (c *Client) ApproveBlueprint(ctx context.Context, req *telcoautomationpb.ApproveBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	return c.internalClient.ApproveBlueprint(ctx, req, opts...)
}

// ProposeBlueprint proposes a blueprint for approval of changes.
func (c *Client) ProposeBlueprint(ctx context.Context, req *telcoautomationpb.ProposeBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	return c.internalClient.ProposeBlueprint(ctx, req, opts...)
}

// RejectBlueprint rejects a blueprint revision proposal and flips it back to Draft state.
func (c *Client) RejectBlueprint(ctx context.Context, req *telcoautomationpb.RejectBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	return c.internalClient.RejectBlueprint(ctx, req, opts...)
}

// ListBlueprintRevisions list blueprint revisions of a given blueprint.
func (c *Client) ListBlueprintRevisions(ctx context.Context, req *telcoautomationpb.ListBlueprintRevisionsRequest, opts ...gax.CallOption) *BlueprintIterator {
	return c.internalClient.ListBlueprintRevisions(ctx, req, opts...)
}

// SearchBlueprintRevisions searches across blueprint revisions.
func (c *Client) SearchBlueprintRevisions(ctx context.Context, req *telcoautomationpb.SearchBlueprintRevisionsRequest, opts ...gax.CallOption) *BlueprintIterator {
	return c.internalClient.SearchBlueprintRevisions(ctx, req, opts...)
}

// SearchDeploymentRevisions searches across deployment revisions.
func (c *Client) SearchDeploymentRevisions(ctx context.Context, req *telcoautomationpb.SearchDeploymentRevisionsRequest, opts ...gax.CallOption) *DeploymentIterator {
	return c.internalClient.SearchDeploymentRevisions(ctx, req, opts...)
}

// DiscardBlueprintChanges discards the changes in a blueprint and reverts the blueprint to the last
// approved blueprint revision. No changes take place if a blueprint does not
// have revisions.
func (c *Client) DiscardBlueprintChanges(ctx context.Context, req *telcoautomationpb.DiscardBlueprintChangesRequest, opts ...gax.CallOption) (*telcoautomationpb.DiscardBlueprintChangesResponse, error) {
	return c.internalClient.DiscardBlueprintChanges(ctx, req, opts...)
}

// ListPublicBlueprints lists the blueprints in TNA’s public catalog. Default page size = 20,
// Max Page Size = 100.
func (c *Client) ListPublicBlueprints(ctx context.Context, req *telcoautomationpb.ListPublicBlueprintsRequest, opts ...gax.CallOption) *PublicBlueprintIterator {
	return c.internalClient.ListPublicBlueprints(ctx, req, opts...)
}

// GetPublicBlueprint returns the requested public blueprint.
func (c *Client) GetPublicBlueprint(ctx context.Context, req *telcoautomationpb.GetPublicBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.PublicBlueprint, error) {
	return c.internalClient.GetPublicBlueprint(ctx, req, opts...)
}

// CreateDeployment creates a deployment.
func (c *Client) CreateDeployment(ctx context.Context, req *telcoautomationpb.CreateDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	return c.internalClient.CreateDeployment(ctx, req, opts...)
}

// UpdateDeployment updates a deployment.
func (c *Client) UpdateDeployment(ctx context.Context, req *telcoautomationpb.UpdateDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	return c.internalClient.UpdateDeployment(ctx, req, opts...)
}

// GetDeployment returns the requested deployment.
func (c *Client) GetDeployment(ctx context.Context, req *telcoautomationpb.GetDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	return c.internalClient.GetDeployment(ctx, req, opts...)
}

// RemoveDeployment removes the deployment by marking it as DELETING. Post which deployment and
// it’s revisions gets deleted.
func (c *Client) RemoveDeployment(ctx context.Context, req *telcoautomationpb.RemoveDeploymentRequest, opts ...gax.CallOption) error {
	return c.internalClient.RemoveDeployment(ctx, req, opts...)
}

// ListDeployments list all deployments.
func (c *Client) ListDeployments(ctx context.Context, req *telcoautomationpb.ListDeploymentsRequest, opts ...gax.CallOption) *DeploymentIterator {
	return c.internalClient.ListDeployments(ctx, req, opts...)
}

// ListDeploymentRevisions list deployment revisions of a given deployment.
func (c *Client) ListDeploymentRevisions(ctx context.Context, req *telcoautomationpb.ListDeploymentRevisionsRequest, opts ...gax.CallOption) *DeploymentIterator {
	return c.internalClient.ListDeploymentRevisions(ctx, req, opts...)
}

// DiscardDeploymentChanges discards the changes in a deployment and reverts the deployment to the last
// approved deployment revision. No changes take place if a deployment does
// not have revisions.
func (c *Client) DiscardDeploymentChanges(ctx context.Context, req *telcoautomationpb.DiscardDeploymentChangesRequest, opts ...gax.CallOption) (*telcoautomationpb.DiscardDeploymentChangesResponse, error) {
	return c.internalClient.DiscardDeploymentChanges(ctx, req, opts...)
}

// ApplyDeployment applies the deployment’s YAML files to the parent orchestration cluster.
func (c *Client) ApplyDeployment(ctx context.Context, req *telcoautomationpb.ApplyDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	return c.internalClient.ApplyDeployment(ctx, req, opts...)
}

// ComputeDeploymentStatus returns the requested deployment status.
func (c *Client) ComputeDeploymentStatus(ctx context.Context, req *telcoautomationpb.ComputeDeploymentStatusRequest, opts ...gax.CallOption) (*telcoautomationpb.ComputeDeploymentStatusResponse, error) {
	return c.internalClient.ComputeDeploymentStatus(ctx, req, opts...)
}

// RollbackDeployment rollback the active deployment to the given past approved deployment
// revision.
func (c *Client) RollbackDeployment(ctx context.Context, req *telcoautomationpb.RollbackDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	return c.internalClient.RollbackDeployment(ctx, req, opts...)
}

// GetHydratedDeployment returns the requested hydrated deployment.
func (c *Client) GetHydratedDeployment(ctx context.Context, req *telcoautomationpb.GetHydratedDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error) {
	return c.internalClient.GetHydratedDeployment(ctx, req, opts...)
}

// ListHydratedDeployments list all hydrated deployments present under a deployment.
func (c *Client) ListHydratedDeployments(ctx context.Context, req *telcoautomationpb.ListHydratedDeploymentsRequest, opts ...gax.CallOption) *HydratedDeploymentIterator {
	return c.internalClient.ListHydratedDeployments(ctx, req, opts...)
}

// UpdateHydratedDeployment updates a hydrated deployment.
func (c *Client) UpdateHydratedDeployment(ctx context.Context, req *telcoautomationpb.UpdateHydratedDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error) {
	return c.internalClient.UpdateHydratedDeployment(ctx, req, opts...)
}

// ApplyHydratedDeployment applies a hydrated deployment to a workload cluster.
func (c *Client) ApplyHydratedDeployment(ctx context.Context, req *telcoautomationpb.ApplyHydratedDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error) {
	return c.internalClient.ApplyHydratedDeployment(ctx, req, opts...)
}

// GetLocation gets information about a location.
func (c *Client) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	return c.internalClient.GetLocation(ctx, req, opts...)
}

// ListLocations lists information about the supported locations for this service.
func (c *Client) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	return c.internalClient.ListLocations(ctx, req, opts...)
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *Client) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.CancelOperation(ctx, req, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *Client) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	return c.internalClient.DeleteOperation(ctx, req, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *Client) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	return c.internalClient.GetOperation(ctx, req, opts...)
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *Client) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	return c.internalClient.ListOperations(ctx, req, opts...)
}

// gRPCClient is a client for interacting with Telco Automation API over gRPC transport.
//
// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type gRPCClient struct {
	// Connection pool of gRPC connections to the service.
	connPool gtransport.ConnPool

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	// The gRPC API client.
	client telcoautomationpb.TelcoAutomationClient

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	operationsClient longrunningpb.OperationsClient

	locationsClient locationpb.LocationsClient

	// The x-goog-* metadata to be sent with each request.
	xGoogHeaders []string

	logger *slog.Logger
}

// NewClient creates a new telco automation client based on gRPC.
// The returned client must be Closed when it is done being used to clean up its underlying connections.
//
// TelcoAutomation Service manages the control plane cluster a.k.a.
// Orchestration Cluster (GKE cluster with config controller) of TNA. It also
// exposes blueprint APIs which manages the lifecycle of blueprints that control
// the infrastructure setup (e.g GDCE clusters) and deployment of network
// functions.
func NewClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := defaultGRPCClientOptions()
	if newClientHook != nil {
		hookOpts, err := newClientHook(ctx, clientHookParams{})
		if err != nil {
			return nil, err
		}
		clientOpts = append(clientOpts, hookOpts...)
	}

	connPool, err := gtransport.DialPool(ctx, append(clientOpts, opts...)...)
	if err != nil {
		return nil, err
	}
	client := Client{CallOptions: defaultCallOptions()}

	c := &gRPCClient{
		connPool:         connPool,
		client:           telcoautomationpb.NewTelcoAutomationClient(connPool),
		CallOptions:      &client.CallOptions,
		logger:           internaloption.GetLogger(opts),
		operationsClient: longrunningpb.NewOperationsClient(connPool),
		locationsClient:  locationpb.NewLocationsClient(connPool),
	}
	c.setGoogleClientInfo()

	client.internalClient = c

	client.LROClient, err = lroauto.NewOperationsClient(ctx, gtransport.WithConnPool(connPool))
	if err != nil {
		// This error "should not happen", since we are just reusing old connection pool
		// and never actually need to dial.
		// If this does happen, we could leak connp. However, we cannot close conn:
		// If the user invoked the constructor with option.WithGRPCConn,
		// we would close a connection that's still in use.
		// TODO: investigate error conditions.
		return nil, err
	}
	c.LROClient = &client.LROClient
	return &client, nil
}

// Connection returns a connection to the API service.
//
// Deprecated: Connections are now pooled so this method does not always
// return the same resource.
func (c *gRPCClient) Connection() *grpc.ClientConn {
	return c.connPool.Conn()
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *gRPCClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "grpc", grpc.Version)
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *gRPCClient) Close() error {
	return c.connPool.Close()
}

// Methods, except Close, may be called concurrently. However, fields must not be modified concurrently with method calls.
type restClient struct {
	// The http endpoint to connect to.
	endpoint string

	// The http client.
	httpClient *http.Client

	// LROClient is used internally to handle long-running operations.
	// It is exposed so that its CallOptions can be modified if required.
	// Users should not Close this client.
	LROClient **lroauto.OperationsClient

	// The x-goog-* headers to be sent with each request.
	xGoogHeaders []string

	// Points back to the CallOptions field of the containing Client
	CallOptions **CallOptions

	logger *slog.Logger
}

// NewRESTClient creates a new telco automation rest client.
//
// TelcoAutomation Service manages the control plane cluster a.k.a.
// Orchestration Cluster (GKE cluster with config controller) of TNA. It also
// exposes blueprint APIs which manages the lifecycle of blueprints that control
// the infrastructure setup (e.g GDCE clusters) and deployment of network
// functions.
func NewRESTClient(ctx context.Context, opts ...option.ClientOption) (*Client, error) {
	clientOpts := append(defaultRESTClientOptions(), opts...)
	httpClient, endpoint, err := httptransport.NewClient(ctx, clientOpts...)
	if err != nil {
		return nil, err
	}

	callOpts := defaultRESTCallOptions()
	c := &restClient{
		endpoint:    endpoint,
		httpClient:  httpClient,
		CallOptions: &callOpts,
		logger:      internaloption.GetLogger(opts),
	}
	c.setGoogleClientInfo()

	lroOpts := []option.ClientOption{
		option.WithHTTPClient(httpClient),
		option.WithEndpoint(endpoint),
	}
	opClient, err := lroauto.NewOperationsRESTClient(ctx, lroOpts...)
	if err != nil {
		return nil, err
	}
	c.LROClient = &opClient

	return &Client{internalClient: c, CallOptions: callOpts}, nil
}

func defaultRESTClientOptions() []option.ClientOption {
	return []option.ClientOption{
		internaloption.WithDefaultEndpoint("https://telcoautomation.googleapis.com"),
		internaloption.WithDefaultEndpointTemplate("https://telcoautomation.UNIVERSE_DOMAIN"),
		internaloption.WithDefaultMTLSEndpoint("https://telcoautomation.mtls.googleapis.com"),
		internaloption.WithDefaultUniverseDomain("googleapis.com"),
		internaloption.WithDefaultAudience("https://telcoautomation.googleapis.com/"),
		internaloption.WithDefaultScopes(DefaultAuthScopes()...),
		internaloption.EnableNewAuthLibrary(),
	}
}

// setGoogleClientInfo sets the name and version of the application in
// the `x-goog-api-client` header passed on each request. Intended for
// use by Google-written clients.
func (c *restClient) setGoogleClientInfo(keyval ...string) {
	kv := append([]string{"gl-go", gax.GoVersion}, keyval...)
	kv = append(kv, "gapic", getVersionClient(), "gax", gax.Version, "rest", "UNKNOWN")
	c.xGoogHeaders = []string{
		"x-goog-api-client", gax.XGoogHeader(kv...),
	}
}

// Close closes the connection to the API service. The user should invoke this when
// the client is no longer required.
func (c *restClient) Close() error {
	// Replace httpClient with nil to force cleanup.
	c.httpClient = nil
	return nil
}

// Connection returns a connection to the API service.
//
// Deprecated: This method always returns nil.
func (c *restClient) Connection() *grpc.ClientConn {
	return nil
}
func (c *gRPCClient) ListOrchestrationClusters(ctx context.Context, req *telcoautomationpb.ListOrchestrationClustersRequest, opts ...gax.CallOption) *OrchestrationClusterIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOrchestrationClusters[0:len((*c.CallOptions).ListOrchestrationClusters):len((*c.CallOptions).ListOrchestrationClusters)], opts...)
	it := &OrchestrationClusterIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListOrchestrationClustersRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.OrchestrationCluster, string, error) {
		resp := &telcoautomationpb.ListOrchestrationClustersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListOrchestrationClusters, req, settings.GRPC, c.logger, "ListOrchestrationClusters")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOrchestrationClusters(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetOrchestrationCluster(ctx context.Context, req *telcoautomationpb.GetOrchestrationClusterRequest, opts ...gax.CallOption) (*telcoautomationpb.OrchestrationCluster, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOrchestrationCluster[0:len((*c.CallOptions).GetOrchestrationCluster):len((*c.CallOptions).GetOrchestrationCluster)], opts...)
	var resp *telcoautomationpb.OrchestrationCluster
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetOrchestrationCluster, req, settings.GRPC, c.logger, "GetOrchestrationCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateOrchestrationCluster(ctx context.Context, req *telcoautomationpb.CreateOrchestrationClusterRequest, opts ...gax.CallOption) (*CreateOrchestrationClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateOrchestrationCluster[0:len((*c.CallOptions).CreateOrchestrationCluster):len((*c.CallOptions).CreateOrchestrationCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateOrchestrationCluster, req, settings.GRPC, c.logger, "CreateOrchestrationCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateOrchestrationClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteOrchestrationCluster(ctx context.Context, req *telcoautomationpb.DeleteOrchestrationClusterRequest, opts ...gax.CallOption) (*DeleteOrchestrationClusterOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOrchestrationCluster[0:len((*c.CallOptions).DeleteOrchestrationCluster):len((*c.CallOptions).DeleteOrchestrationCluster)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteOrchestrationCluster, req, settings.GRPC, c.logger, "DeleteOrchestrationCluster")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteOrchestrationClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) ListEdgeSlms(ctx context.Context, req *telcoautomationpb.ListEdgeSlmsRequest, opts ...gax.CallOption) *EdgeSlmIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListEdgeSlms[0:len((*c.CallOptions).ListEdgeSlms):len((*c.CallOptions).ListEdgeSlms)], opts...)
	it := &EdgeSlmIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListEdgeSlmsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.EdgeSlm, string, error) {
		resp := &telcoautomationpb.ListEdgeSlmsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListEdgeSlms, req, settings.GRPC, c.logger, "ListEdgeSlms")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetEdgeSlms(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetEdgeSlm(ctx context.Context, req *telcoautomationpb.GetEdgeSlmRequest, opts ...gax.CallOption) (*telcoautomationpb.EdgeSlm, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetEdgeSlm[0:len((*c.CallOptions).GetEdgeSlm):len((*c.CallOptions).GetEdgeSlm)], opts...)
	var resp *telcoautomationpb.EdgeSlm
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetEdgeSlm, req, settings.GRPC, c.logger, "GetEdgeSlm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateEdgeSlm(ctx context.Context, req *telcoautomationpb.CreateEdgeSlmRequest, opts ...gax.CallOption) (*CreateEdgeSlmOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateEdgeSlm[0:len((*c.CallOptions).CreateEdgeSlm):len((*c.CallOptions).CreateEdgeSlm)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateEdgeSlm, req, settings.GRPC, c.logger, "CreateEdgeSlm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &CreateEdgeSlmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) DeleteEdgeSlm(ctx context.Context, req *telcoautomationpb.DeleteEdgeSlmRequest, opts ...gax.CallOption) (*DeleteEdgeSlmOperation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteEdgeSlm[0:len((*c.CallOptions).DeleteEdgeSlm):len((*c.CallOptions).DeleteEdgeSlm)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DeleteEdgeSlm, req, settings.GRPC, c.logger, "DeleteEdgeSlm")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return &DeleteEdgeSlmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, resp),
	}, nil
}

func (c *gRPCClient) CreateBlueprint(ctx context.Context, req *telcoautomationpb.CreateBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateBlueprint[0:len((*c.CallOptions).CreateBlueprint):len((*c.CallOptions).CreateBlueprint)], opts...)
	var resp *telcoautomationpb.Blueprint
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateBlueprint, req, settings.GRPC, c.logger, "CreateBlueprint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateBlueprint(ctx context.Context, req *telcoautomationpb.UpdateBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "blueprint.name", url.QueryEscape(req.GetBlueprint().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateBlueprint[0:len((*c.CallOptions).UpdateBlueprint):len((*c.CallOptions).UpdateBlueprint)], opts...)
	var resp *telcoautomationpb.Blueprint
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateBlueprint, req, settings.GRPC, c.logger, "UpdateBlueprint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetBlueprint(ctx context.Context, req *telcoautomationpb.GetBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetBlueprint[0:len((*c.CallOptions).GetBlueprint):len((*c.CallOptions).GetBlueprint)], opts...)
	var resp *telcoautomationpb.Blueprint
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetBlueprint, req, settings.GRPC, c.logger, "GetBlueprint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) DeleteBlueprint(ctx context.Context, req *telcoautomationpb.DeleteBlueprintRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteBlueprint[0:len((*c.CallOptions).DeleteBlueprint):len((*c.CallOptions).DeleteBlueprint)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.client.DeleteBlueprint, req, settings.GRPC, c.logger, "DeleteBlueprint")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) ListBlueprints(ctx context.Context, req *telcoautomationpb.ListBlueprintsRequest, opts ...gax.CallOption) *BlueprintIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListBlueprints[0:len((*c.CallOptions).ListBlueprints):len((*c.CallOptions).ListBlueprints)], opts...)
	it := &BlueprintIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListBlueprintsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Blueprint, string, error) {
		resp := &telcoautomationpb.ListBlueprintsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListBlueprints, req, settings.GRPC, c.logger, "ListBlueprints")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetBlueprints(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) ApproveBlueprint(ctx context.Context, req *telcoautomationpb.ApproveBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ApproveBlueprint[0:len((*c.CallOptions).ApproveBlueprint):len((*c.CallOptions).ApproveBlueprint)], opts...)
	var resp *telcoautomationpb.Blueprint
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ApproveBlueprint, req, settings.GRPC, c.logger, "ApproveBlueprint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ProposeBlueprint(ctx context.Context, req *telcoautomationpb.ProposeBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ProposeBlueprint[0:len((*c.CallOptions).ProposeBlueprint):len((*c.CallOptions).ProposeBlueprint)], opts...)
	var resp *telcoautomationpb.Blueprint
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ProposeBlueprint, req, settings.GRPC, c.logger, "ProposeBlueprint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) RejectBlueprint(ctx context.Context, req *telcoautomationpb.RejectBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RejectBlueprint[0:len((*c.CallOptions).RejectBlueprint):len((*c.CallOptions).RejectBlueprint)], opts...)
	var resp *telcoautomationpb.Blueprint
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.RejectBlueprint, req, settings.GRPC, c.logger, "RejectBlueprint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListBlueprintRevisions(ctx context.Context, req *telcoautomationpb.ListBlueprintRevisionsRequest, opts ...gax.CallOption) *BlueprintIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListBlueprintRevisions[0:len((*c.CallOptions).ListBlueprintRevisions):len((*c.CallOptions).ListBlueprintRevisions)], opts...)
	it := &BlueprintIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListBlueprintRevisionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Blueprint, string, error) {
		resp := &telcoautomationpb.ListBlueprintRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListBlueprintRevisions, req, settings.GRPC, c.logger, "ListBlueprintRevisions")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetBlueprints(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) SearchBlueprintRevisions(ctx context.Context, req *telcoautomationpb.SearchBlueprintRevisionsRequest, opts ...gax.CallOption) *BlueprintIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchBlueprintRevisions[0:len((*c.CallOptions).SearchBlueprintRevisions):len((*c.CallOptions).SearchBlueprintRevisions)], opts...)
	it := &BlueprintIterator{}
	req = proto.Clone(req).(*telcoautomationpb.SearchBlueprintRevisionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Blueprint, string, error) {
		resp := &telcoautomationpb.SearchBlueprintRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.SearchBlueprintRevisions, req, settings.GRPC, c.logger, "SearchBlueprintRevisions")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetBlueprints(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) SearchDeploymentRevisions(ctx context.Context, req *telcoautomationpb.SearchDeploymentRevisionsRequest, opts ...gax.CallOption) *DeploymentIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).SearchDeploymentRevisions[0:len((*c.CallOptions).SearchDeploymentRevisions):len((*c.CallOptions).SearchDeploymentRevisions)], opts...)
	it := &DeploymentIterator{}
	req = proto.Clone(req).(*telcoautomationpb.SearchDeploymentRevisionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Deployment, string, error) {
		resp := &telcoautomationpb.SearchDeploymentRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.SearchDeploymentRevisions, req, settings.GRPC, c.logger, "SearchDeploymentRevisions")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDeployments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) DiscardBlueprintChanges(ctx context.Context, req *telcoautomationpb.DiscardBlueprintChangesRequest, opts ...gax.CallOption) (*telcoautomationpb.DiscardBlueprintChangesResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DiscardBlueprintChanges[0:len((*c.CallOptions).DiscardBlueprintChanges):len((*c.CallOptions).DiscardBlueprintChanges)], opts...)
	var resp *telcoautomationpb.DiscardBlueprintChangesResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DiscardBlueprintChanges, req, settings.GRPC, c.logger, "DiscardBlueprintChanges")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListPublicBlueprints(ctx context.Context, req *telcoautomationpb.ListPublicBlueprintsRequest, opts ...gax.CallOption) *PublicBlueprintIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListPublicBlueprints[0:len((*c.CallOptions).ListPublicBlueprints):len((*c.CallOptions).ListPublicBlueprints)], opts...)
	it := &PublicBlueprintIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListPublicBlueprintsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.PublicBlueprint, string, error) {
		resp := &telcoautomationpb.ListPublicBlueprintsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListPublicBlueprints, req, settings.GRPC, c.logger, "ListPublicBlueprints")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetPublicBlueprints(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) GetPublicBlueprint(ctx context.Context, req *telcoautomationpb.GetPublicBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.PublicBlueprint, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetPublicBlueprint[0:len((*c.CallOptions).GetPublicBlueprint):len((*c.CallOptions).GetPublicBlueprint)], opts...)
	var resp *telcoautomationpb.PublicBlueprint
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetPublicBlueprint, req, settings.GRPC, c.logger, "GetPublicBlueprint")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) CreateDeployment(ctx context.Context, req *telcoautomationpb.CreateDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CreateDeployment[0:len((*c.CallOptions).CreateDeployment):len((*c.CallOptions).CreateDeployment)], opts...)
	var resp *telcoautomationpb.Deployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.CreateDeployment, req, settings.GRPC, c.logger, "CreateDeployment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) UpdateDeployment(ctx context.Context, req *telcoautomationpb.UpdateDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "deployment.name", url.QueryEscape(req.GetDeployment().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDeployment[0:len((*c.CallOptions).UpdateDeployment):len((*c.CallOptions).UpdateDeployment)], opts...)
	var resp *telcoautomationpb.Deployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateDeployment, req, settings.GRPC, c.logger, "UpdateDeployment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetDeployment(ctx context.Context, req *telcoautomationpb.GetDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetDeployment[0:len((*c.CallOptions).GetDeployment):len((*c.CallOptions).GetDeployment)], opts...)
	var resp *telcoautomationpb.Deployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetDeployment, req, settings.GRPC, c.logger, "GetDeployment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) RemoveDeployment(ctx context.Context, req *telcoautomationpb.RemoveDeploymentRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RemoveDeployment[0:len((*c.CallOptions).RemoveDeployment):len((*c.CallOptions).RemoveDeployment)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.client.RemoveDeployment, req, settings.GRPC, c.logger, "RemoveDeployment")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) ListDeployments(ctx context.Context, req *telcoautomationpb.ListDeploymentsRequest, opts ...gax.CallOption) *DeploymentIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDeployments[0:len((*c.CallOptions).ListDeployments):len((*c.CallOptions).ListDeployments)], opts...)
	it := &DeploymentIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListDeploymentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Deployment, string, error) {
		resp := &telcoautomationpb.ListDeploymentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListDeployments, req, settings.GRPC, c.logger, "ListDeployments")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDeployments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) ListDeploymentRevisions(ctx context.Context, req *telcoautomationpb.ListDeploymentRevisionsRequest, opts ...gax.CallOption) *DeploymentIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListDeploymentRevisions[0:len((*c.CallOptions).ListDeploymentRevisions):len((*c.CallOptions).ListDeploymentRevisions)], opts...)
	it := &DeploymentIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListDeploymentRevisionsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Deployment, string, error) {
		resp := &telcoautomationpb.ListDeploymentRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListDeploymentRevisions, req, settings.GRPC, c.logger, "ListDeploymentRevisions")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetDeployments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) DiscardDeploymentChanges(ctx context.Context, req *telcoautomationpb.DiscardDeploymentChangesRequest, opts ...gax.CallOption) (*telcoautomationpb.DiscardDeploymentChangesResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DiscardDeploymentChanges[0:len((*c.CallOptions).DiscardDeploymentChanges):len((*c.CallOptions).DiscardDeploymentChanges)], opts...)
	var resp *telcoautomationpb.DiscardDeploymentChangesResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.DiscardDeploymentChanges, req, settings.GRPC, c.logger, "DiscardDeploymentChanges")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ApplyDeployment(ctx context.Context, req *telcoautomationpb.ApplyDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ApplyDeployment[0:len((*c.CallOptions).ApplyDeployment):len((*c.CallOptions).ApplyDeployment)], opts...)
	var resp *telcoautomationpb.Deployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ApplyDeployment, req, settings.GRPC, c.logger, "ApplyDeployment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ComputeDeploymentStatus(ctx context.Context, req *telcoautomationpb.ComputeDeploymentStatusRequest, opts ...gax.CallOption) (*telcoautomationpb.ComputeDeploymentStatusResponse, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ComputeDeploymentStatus[0:len((*c.CallOptions).ComputeDeploymentStatus):len((*c.CallOptions).ComputeDeploymentStatus)], opts...)
	var resp *telcoautomationpb.ComputeDeploymentStatusResponse
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ComputeDeploymentStatus, req, settings.GRPC, c.logger, "ComputeDeploymentStatus")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) RollbackDeployment(ctx context.Context, req *telcoautomationpb.RollbackDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).RollbackDeployment[0:len((*c.CallOptions).RollbackDeployment):len((*c.CallOptions).RollbackDeployment)], opts...)
	var resp *telcoautomationpb.Deployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.RollbackDeployment, req, settings.GRPC, c.logger, "RollbackDeployment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetHydratedDeployment(ctx context.Context, req *telcoautomationpb.GetHydratedDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetHydratedDeployment[0:len((*c.CallOptions).GetHydratedDeployment):len((*c.CallOptions).GetHydratedDeployment)], opts...)
	var resp *telcoautomationpb.HydratedDeployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.GetHydratedDeployment, req, settings.GRPC, c.logger, "GetHydratedDeployment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListHydratedDeployments(ctx context.Context, req *telcoautomationpb.ListHydratedDeploymentsRequest, opts ...gax.CallOption) *HydratedDeploymentIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListHydratedDeployments[0:len((*c.CallOptions).ListHydratedDeployments):len((*c.CallOptions).ListHydratedDeployments)], opts...)
	it := &HydratedDeploymentIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListHydratedDeploymentsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.HydratedDeployment, string, error) {
		resp := &telcoautomationpb.ListHydratedDeploymentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.client.ListHydratedDeployments, req, settings.GRPC, c.logger, "ListHydratedDeployments")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetHydratedDeployments(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) UpdateHydratedDeployment(ctx context.Context, req *telcoautomationpb.UpdateHydratedDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "hydrated_deployment.name", url.QueryEscape(req.GetHydratedDeployment().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).UpdateHydratedDeployment[0:len((*c.CallOptions).UpdateHydratedDeployment):len((*c.CallOptions).UpdateHydratedDeployment)], opts...)
	var resp *telcoautomationpb.HydratedDeployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.UpdateHydratedDeployment, req, settings.GRPC, c.logger, "UpdateHydratedDeployment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ApplyHydratedDeployment(ctx context.Context, req *telcoautomationpb.ApplyHydratedDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ApplyHydratedDeployment[0:len((*c.CallOptions).ApplyHydratedDeployment):len((*c.CallOptions).ApplyHydratedDeployment)], opts...)
	var resp *telcoautomationpb.HydratedDeployment
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.client.ApplyHydratedDeployment, req, settings.GRPC, c.logger, "ApplyHydratedDeployment")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	var resp *locationpb.Location
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.locationsClient.GetLocation, req, settings.GRPC, c.logger, "GetLocation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListLocations[0:len((*c.CallOptions).ListLocations):len((*c.CallOptions).ListLocations)], opts...)
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.locationsClient.ListLocations, req, settings.GRPC, c.logger, "ListLocations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

func (c *gRPCClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).CancelOperation[0:len((*c.CallOptions).CancelOperation):len((*c.CallOptions).CancelOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.CancelOperation, req, settings.GRPC, c.logger, "CancelOperation")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).DeleteOperation[0:len((*c.CallOptions).DeleteOperation):len((*c.CallOptions).DeleteOperation)], opts...)
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		_, err = executeRPC(ctx, c.operationsClient.DeleteOperation, req, settings.GRPC, c.logger, "DeleteOperation")
		return err
	}, opts...)
	return err
}

func (c *gRPCClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	var resp *longrunningpb.Operation
	err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		var err error
		resp, err = executeRPC(ctx, c.operationsClient.GetOperation, req, settings.GRPC, c.logger, "GetOperation")
		return err
	}, opts...)
	if err != nil {
		return nil, err
	}
	return resp, nil
}

func (c *gRPCClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	ctx = gax.InsertMetadataIntoOutgoingContext(ctx, hds...)
	opts = append((*c.CallOptions).ListOperations[0:len((*c.CallOptions).ListOperations):len((*c.CallOptions).ListOperations)], opts...)
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		err := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			var err error
			resp, err = executeRPC(ctx, c.operationsClient.ListOperations, req, settings.GRPC, c.logger, "ListOperations")
			return err
		}, opts...)
		if err != nil {
			return nil, "", err
		}

		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}
	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListOrchestrationClusters lists OrchestrationClusters in a given project and location.
func (c *restClient) ListOrchestrationClusters(ctx context.Context, req *telcoautomationpb.ListOrchestrationClustersRequest, opts ...gax.CallOption) *OrchestrationClusterIterator {
	it := &OrchestrationClusterIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListOrchestrationClustersRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.OrchestrationCluster, string, error) {
		resp := &telcoautomationpb.ListOrchestrationClustersResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/orchestrationClusters", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOrchestrationClusters")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOrchestrationClusters(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetOrchestrationCluster gets details of a single OrchestrationCluster.
func (c *restClient) GetOrchestrationCluster(ctx context.Context, req *telcoautomationpb.GetOrchestrationClusterRequest, opts ...gax.CallOption) (*telcoautomationpb.OrchestrationCluster, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOrchestrationCluster[0:len((*c.CallOptions).GetOrchestrationCluster):len((*c.CallOptions).GetOrchestrationCluster)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.OrchestrationCluster{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOrchestrationCluster")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateOrchestrationCluster creates a new OrchestrationCluster in a given project and location.
func (c *restClient) CreateOrchestrationCluster(ctx context.Context, req *telcoautomationpb.CreateOrchestrationClusterRequest, opts ...gax.CallOption) (*CreateOrchestrationClusterOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetOrchestrationCluster()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/orchestrationClusters", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("orchestrationClusterId", fmt.Sprintf("%v", req.GetOrchestrationClusterId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateOrchestrationCluster")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateOrchestrationClusterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteOrchestrationCluster deletes a single OrchestrationCluster.
func (c *restClient) DeleteOrchestrationCluster(ctx context.Context, req *telcoautomationpb.DeleteOrchestrationClusterRequest, opts ...gax.CallOption) (*DeleteOrchestrationClusterOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOrchestrationCluster")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteOrchestrationClusterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// ListEdgeSlms lists EdgeSlms in a given project and location.
func (c *restClient) ListEdgeSlms(ctx context.Context, req *telcoautomationpb.ListEdgeSlmsRequest, opts ...gax.CallOption) *EdgeSlmIterator {
	it := &EdgeSlmIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListEdgeSlmsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.EdgeSlm, string, error) {
		resp := &telcoautomationpb.ListEdgeSlmsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/edgeSlms", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetOrderBy() != "" {
			params.Add("orderBy", fmt.Sprintf("%v", req.GetOrderBy()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListEdgeSlms")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetEdgeSlms(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetEdgeSlm gets details of a single EdgeSlm.
func (c *restClient) GetEdgeSlm(ctx context.Context, req *telcoautomationpb.GetEdgeSlmRequest, opts ...gax.CallOption) (*telcoautomationpb.EdgeSlm, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetEdgeSlm[0:len((*c.CallOptions).GetEdgeSlm):len((*c.CallOptions).GetEdgeSlm)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.EdgeSlm{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetEdgeSlm")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateEdgeSlm creates a new EdgeSlm in a given project and location.
func (c *restClient) CreateEdgeSlm(ctx context.Context, req *telcoautomationpb.CreateEdgeSlmRequest, opts ...gax.CallOption) (*CreateEdgeSlmOperation, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetEdgeSlm()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/edgeSlms", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	params.Add("edgeSlmId", fmt.Sprintf("%v", req.GetEdgeSlmId()))
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateEdgeSlm")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &CreateEdgeSlmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// DeleteEdgeSlm deletes a single EdgeSlm.
func (c *restClient) DeleteEdgeSlm(ctx context.Context, req *telcoautomationpb.DeleteEdgeSlmRequest, opts ...gax.CallOption) (*DeleteEdgeSlmOperation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetRequestId() != "" {
		params.Add("requestId", fmt.Sprintf("%v", req.GetRequestId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteEdgeSlm")
		if err != nil {
			return err
		}
		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}

	override := fmt.Sprintf("/v1/%s", resp.GetName())
	return &DeleteEdgeSlmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, resp),
		pollPath: override,
	}, nil
}

// CreateBlueprint creates a blueprint.
func (c *restClient) CreateBlueprint(ctx context.Context, req *telcoautomationpb.CreateBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBlueprint()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/blueprints", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetBlueprintId() != "" {
		params.Add("blueprintId", fmt.Sprintf("%v", req.GetBlueprintId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateBlueprint[0:len((*c.CallOptions).CreateBlueprint):len((*c.CallOptions).CreateBlueprint)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Blueprint{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateBlueprint")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateBlueprint updates a blueprint.
func (c *restClient) UpdateBlueprint(ctx context.Context, req *telcoautomationpb.UpdateBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetBlueprint()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetBlueprint().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "blueprint.name", url.QueryEscape(req.GetBlueprint().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateBlueprint[0:len((*c.CallOptions).UpdateBlueprint):len((*c.CallOptions).UpdateBlueprint)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Blueprint{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateBlueprint")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetBlueprint returns the requested blueprint.
func (c *restClient) GetBlueprint(ctx context.Context, req *telcoautomationpb.GetBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetView() != 0 {
		params.Add("view", fmt.Sprintf("%v", req.GetView()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetBlueprint[0:len((*c.CallOptions).GetBlueprint):len((*c.CallOptions).GetBlueprint)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Blueprint{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetBlueprint")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// DeleteBlueprint deletes a blueprint and all its revisions.
func (c *restClient) DeleteBlueprint(ctx context.Context, req *telcoautomationpb.DeleteBlueprintRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteBlueprint")
		return err
	}, opts...)
}

// ListBlueprints list all blueprints.
func (c *restClient) ListBlueprints(ctx context.Context, req *telcoautomationpb.ListBlueprintsRequest, opts ...gax.CallOption) *BlueprintIterator {
	it := &BlueprintIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListBlueprintsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Blueprint, string, error) {
		resp := &telcoautomationpb.ListBlueprintsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/blueprints", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListBlueprints")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetBlueprints(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ApproveBlueprint approves a blueprint and commits a new revision.
func (c *restClient) ApproveBlueprint(ctx context.Context, req *telcoautomationpb.ApproveBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:approve", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ApproveBlueprint[0:len((*c.CallOptions).ApproveBlueprint):len((*c.CallOptions).ApproveBlueprint)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Blueprint{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ApproveBlueprint")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ProposeBlueprint proposes a blueprint for approval of changes.
func (c *restClient) ProposeBlueprint(ctx context.Context, req *telcoautomationpb.ProposeBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:propose", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ProposeBlueprint[0:len((*c.CallOptions).ProposeBlueprint):len((*c.CallOptions).ProposeBlueprint)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Blueprint{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ProposeBlueprint")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// RejectBlueprint rejects a blueprint revision proposal and flips it back to Draft state.
func (c *restClient) RejectBlueprint(ctx context.Context, req *telcoautomationpb.RejectBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.Blueprint, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:reject", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).RejectBlueprint[0:len((*c.CallOptions).RejectBlueprint):len((*c.CallOptions).RejectBlueprint)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Blueprint{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RejectBlueprint")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListBlueprintRevisions list blueprint revisions of a given blueprint.
func (c *restClient) ListBlueprintRevisions(ctx context.Context, req *telcoautomationpb.ListBlueprintRevisionsRequest, opts ...gax.CallOption) *BlueprintIterator {
	it := &BlueprintIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListBlueprintRevisionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Blueprint, string, error) {
		resp := &telcoautomationpb.ListBlueprintRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v:listRevisions", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListBlueprintRevisions")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetBlueprints(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SearchBlueprintRevisions searches across blueprint revisions.
func (c *restClient) SearchBlueprintRevisions(ctx context.Context, req *telcoautomationpb.SearchBlueprintRevisionsRequest, opts ...gax.CallOption) *BlueprintIterator {
	it := &BlueprintIterator{}
	req = proto.Clone(req).(*telcoautomationpb.SearchBlueprintRevisionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Blueprint, string, error) {
		resp := &telcoautomationpb.SearchBlueprintRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/blueprints:searchRevisions", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		params.Add("query", fmt.Sprintf("%v", req.GetQuery()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "SearchBlueprintRevisions")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetBlueprints(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// SearchDeploymentRevisions searches across deployment revisions.
func (c *restClient) SearchDeploymentRevisions(ctx context.Context, req *telcoautomationpb.SearchDeploymentRevisionsRequest, opts ...gax.CallOption) *DeploymentIterator {
	it := &DeploymentIterator{}
	req = proto.Clone(req).(*telcoautomationpb.SearchDeploymentRevisionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Deployment, string, error) {
		resp := &telcoautomationpb.SearchDeploymentRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/deployments:searchRevisions", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}
		params.Add("query", fmt.Sprintf("%v", req.GetQuery()))

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "SearchDeploymentRevisions")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDeployments(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DiscardBlueprintChanges discards the changes in a blueprint and reverts the blueprint to the last
// approved blueprint revision. No changes take place if a blueprint does not
// have revisions.
func (c *restClient) DiscardBlueprintChanges(ctx context.Context, req *telcoautomationpb.DiscardBlueprintChangesRequest, opts ...gax.CallOption) (*telcoautomationpb.DiscardBlueprintChangesResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:discard", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).DiscardBlueprintChanges[0:len((*c.CallOptions).DiscardBlueprintChanges):len((*c.CallOptions).DiscardBlueprintChanges)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.DiscardBlueprintChangesResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "DiscardBlueprintChanges")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListPublicBlueprints lists the blueprints in TNA’s public catalog. Default page size = 20,
// Max Page Size = 100.
func (c *restClient) ListPublicBlueprints(ctx context.Context, req *telcoautomationpb.ListPublicBlueprintsRequest, opts ...gax.CallOption) *PublicBlueprintIterator {
	it := &PublicBlueprintIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListPublicBlueprintsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.PublicBlueprint, string, error) {
		resp := &telcoautomationpb.ListPublicBlueprintsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/publicBlueprints", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListPublicBlueprints")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetPublicBlueprints(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// GetPublicBlueprint returns the requested public blueprint.
func (c *restClient) GetPublicBlueprint(ctx context.Context, req *telcoautomationpb.GetPublicBlueprintRequest, opts ...gax.CallOption) (*telcoautomationpb.PublicBlueprint, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetPublicBlueprint[0:len((*c.CallOptions).GetPublicBlueprint):len((*c.CallOptions).GetPublicBlueprint)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.PublicBlueprint{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetPublicBlueprint")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// CreateDeployment creates a deployment.
func (c *restClient) CreateDeployment(ctx context.Context, req *telcoautomationpb.CreateDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDeployment()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v/deployments", req.GetParent())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetDeploymentId() != "" {
		params.Add("deploymentId", fmt.Sprintf("%v", req.GetDeploymentId()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "parent", url.QueryEscape(req.GetParent()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).CreateDeployment[0:len((*c.CallOptions).CreateDeployment):len((*c.CallOptions).CreateDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Deployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CreateDeployment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// UpdateDeployment updates a deployment.
func (c *restClient) UpdateDeployment(ctx context.Context, req *telcoautomationpb.UpdateDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetDeployment()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetDeployment().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "deployment.name", url.QueryEscape(req.GetDeployment().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateDeployment[0:len((*c.CallOptions).UpdateDeployment):len((*c.CallOptions).UpdateDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Deployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateDeployment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetDeployment returns the requested deployment.
func (c *restClient) GetDeployment(ctx context.Context, req *telcoautomationpb.GetDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetView() != 0 {
		params.Add("view", fmt.Sprintf("%v", req.GetView()))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetDeployment[0:len((*c.CallOptions).GetDeployment):len((*c.CallOptions).GetDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Deployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetDeployment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// RemoveDeployment removes the deployment by marking it as DELETING. Post which deployment and
// it’s revisions gets deleted.
func (c *restClient) RemoveDeployment(ctx context.Context, req *telcoautomationpb.RemoveDeploymentRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:remove", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RemoveDeployment")
		return err
	}, opts...)
}

// ListDeployments list all deployments.
func (c *restClient) ListDeployments(ctx context.Context, req *telcoautomationpb.ListDeploymentsRequest, opts ...gax.CallOption) *DeploymentIterator {
	it := &DeploymentIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListDeploymentsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Deployment, string, error) {
		resp := &telcoautomationpb.ListDeploymentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/deployments", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListDeployments")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDeployments(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// ListDeploymentRevisions list deployment revisions of a given deployment.
func (c *restClient) ListDeploymentRevisions(ctx context.Context, req *telcoautomationpb.ListDeploymentRevisionsRequest, opts ...gax.CallOption) *DeploymentIterator {
	it := &DeploymentIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListDeploymentRevisionsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.Deployment, string, error) {
		resp := &telcoautomationpb.ListDeploymentRevisionsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v:listRevisions", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListDeploymentRevisions")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetDeployments(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// DiscardDeploymentChanges discards the changes in a deployment and reverts the deployment to the last
// approved deployment revision. No changes take place if a deployment does
// not have revisions.
func (c *restClient) DiscardDeploymentChanges(ctx context.Context, req *telcoautomationpb.DiscardDeploymentChangesRequest, opts ...gax.CallOption) (*telcoautomationpb.DiscardDeploymentChangesResponse, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:discard", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).DiscardDeploymentChanges[0:len((*c.CallOptions).DiscardDeploymentChanges):len((*c.CallOptions).DiscardDeploymentChanges)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.DiscardDeploymentChangesResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "DiscardDeploymentChanges")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ApplyDeployment applies the deployment’s YAML files to the parent orchestration cluster.
func (c *restClient) ApplyDeployment(ctx context.Context, req *telcoautomationpb.ApplyDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:apply", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ApplyDeployment[0:len((*c.CallOptions).ApplyDeployment):len((*c.CallOptions).ApplyDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Deployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ApplyDeployment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ComputeDeploymentStatus returns the requested deployment status.
func (c *restClient) ComputeDeploymentStatus(ctx context.Context, req *telcoautomationpb.ComputeDeploymentStatusRequest, opts ...gax.CallOption) (*telcoautomationpb.ComputeDeploymentStatusResponse, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:computeDeploymentStatus", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ComputeDeploymentStatus[0:len((*c.CallOptions).ComputeDeploymentStatus):len((*c.CallOptions).ComputeDeploymentStatus)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.ComputeDeploymentStatusResponse{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ComputeDeploymentStatus")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// RollbackDeployment rollback the active deployment to the given past approved deployment
// revision.
func (c *restClient) RollbackDeployment(ctx context.Context, req *telcoautomationpb.RollbackDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.Deployment, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:rollback", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).RollbackDeployment[0:len((*c.CallOptions).RollbackDeployment):len((*c.CallOptions).RollbackDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.Deployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "RollbackDeployment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetHydratedDeployment returns the requested hydrated deployment.
func (c *restClient) GetHydratedDeployment(ctx context.Context, req *telcoautomationpb.GetHydratedDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetHydratedDeployment[0:len((*c.CallOptions).GetHydratedDeployment):len((*c.CallOptions).GetHydratedDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.HydratedDeployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetHydratedDeployment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListHydratedDeployments list all hydrated deployments present under a deployment.
func (c *restClient) ListHydratedDeployments(ctx context.Context, req *telcoautomationpb.ListHydratedDeploymentsRequest, opts ...gax.CallOption) *HydratedDeploymentIterator {
	it := &HydratedDeploymentIterator{}
	req = proto.Clone(req).(*telcoautomationpb.ListHydratedDeploymentsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*telcoautomationpb.HydratedDeployment, string, error) {
		resp := &telcoautomationpb.ListHydratedDeploymentsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v/hydratedDeployments", req.GetParent())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListHydratedDeployments")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetHydratedDeployments(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// UpdateHydratedDeployment updates a hydrated deployment.
func (c *restClient) UpdateHydratedDeployment(ctx context.Context, req *telcoautomationpb.UpdateHydratedDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	body := req.GetHydratedDeployment()
	jsonReq, err := m.Marshal(body)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetHydratedDeployment().GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")
	if req.GetUpdateMask() != nil {
		field, err := protojson.Marshal(req.GetUpdateMask())
		if err != nil {
			return nil, err
		}
		params.Add("updateMask", string(field[1:len(field)-1]))
	}

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "hydrated_deployment.name", url.QueryEscape(req.GetHydratedDeployment().GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).UpdateHydratedDeployment[0:len((*c.CallOptions).UpdateHydratedDeployment):len((*c.CallOptions).UpdateHydratedDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.HydratedDeployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("PATCH", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "UpdateHydratedDeployment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ApplyHydratedDeployment applies a hydrated deployment to a workload cluster.
func (c *restClient) ApplyHydratedDeployment(ctx context.Context, req *telcoautomationpb.ApplyHydratedDeploymentRequest, opts ...gax.CallOption) (*telcoautomationpb.HydratedDeployment, error) {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return nil, err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:apply", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).ApplyHydratedDeployment[0:len((*c.CallOptions).ApplyHydratedDeployment):len((*c.CallOptions).ApplyHydratedDeployment)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &telcoautomationpb.HydratedDeployment{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "ApplyHydratedDeployment")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// GetLocation gets information about a location.
func (c *restClient) GetLocation(ctx context.Context, req *locationpb.GetLocationRequest, opts ...gax.CallOption) (*locationpb.Location, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetLocation[0:len((*c.CallOptions).GetLocation):len((*c.CallOptions).GetLocation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &locationpb.Location{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetLocation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListLocations lists information about the supported locations for this service.
func (c *restClient) ListLocations(ctx context.Context, req *locationpb.ListLocationsRequest, opts ...gax.CallOption) *LocationIterator {
	it := &LocationIterator{}
	req = proto.Clone(req).(*locationpb.ListLocationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*locationpb.Location, string, error) {
		resp := &locationpb.ListLocationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListLocations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetLocations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CancelOperation is a utility method from google.longrunning.Operations.
func (c *restClient) CancelOperation(ctx context.Context, req *longrunningpb.CancelOperationRequest, opts ...gax.CallOption) error {
	m := protojson.MarshalOptions{AllowPartial: true, UseEnumNumbers: true}
	jsonReq, err := m.Marshal(req)
	if err != nil {
		return err
	}

	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v:cancel", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("POST", baseUrl.String(), bytes.NewReader(jsonReq))
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, jsonReq, "CancelOperation")
		return err
	}, opts...)
}

// DeleteOperation is a utility method from google.longrunning.Operations.
func (c *restClient) DeleteOperation(ctx context.Context, req *longrunningpb.DeleteOperationRequest, opts ...gax.CallOption) error {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	return gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("DELETE", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		_, err = executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "DeleteOperation")
		return err
	}, opts...)
}

// GetOperation is a utility method from google.longrunning.Operations.
func (c *restClient) GetOperation(ctx context.Context, req *longrunningpb.GetOperationRequest, opts ...gax.CallOption) (*longrunningpb.Operation, error) {
	baseUrl, err := url.Parse(c.endpoint)
	if err != nil {
		return nil, err
	}
	baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

	params := url.Values{}
	params.Add("$alt", "json;enum-encoding=int")

	baseUrl.RawQuery = params.Encode()

	// Build HTTP headers from client and context metadata.
	hds := []string{"x-goog-request-params", fmt.Sprintf("%s=%v", "name", url.QueryEscape(req.GetName()))}

	hds = append(c.xGoogHeaders, hds...)
	hds = append(hds, "Content-Type", "application/json")
	headers := gax.BuildHeaders(ctx, hds...)
	opts = append((*c.CallOptions).GetOperation[0:len((*c.CallOptions).GetOperation):len((*c.CallOptions).GetOperation)], opts...)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	resp := &longrunningpb.Operation{}
	e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
		if settings.Path != "" {
			baseUrl.Path = settings.Path
		}
		httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
		if err != nil {
			return err
		}
		httpReq = httpReq.WithContext(ctx)
		httpReq.Header = headers

		buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "GetOperation")
		if err != nil {
			return err
		}

		if err := unm.Unmarshal(buf, resp); err != nil {
			return err
		}

		return nil
	}, opts...)
	if e != nil {
		return nil, e
	}
	return resp, nil
}

// ListOperations is a utility method from google.longrunning.Operations.
func (c *restClient) ListOperations(ctx context.Context, req *longrunningpb.ListOperationsRequest, opts ...gax.CallOption) *OperationIterator {
	it := &OperationIterator{}
	req = proto.Clone(req).(*longrunningpb.ListOperationsRequest)
	unm := protojson.UnmarshalOptions{AllowPartial: true, DiscardUnknown: true}
	it.InternalFetch = func(pageSize int, pageToken string) ([]*longrunningpb.Operation, string, error) {
		resp := &longrunningpb.ListOperationsResponse{}
		if pageToken != "" {
			req.PageToken = pageToken
		}
		if pageSize > math.MaxInt32 {
			req.PageSize = math.MaxInt32
		} else if pageSize != 0 {
			req.PageSize = int32(pageSize)
		}
		baseUrl, err := url.Parse(c.endpoint)
		if err != nil {
			return nil, "", err
		}
		baseUrl.Path += fmt.Sprintf("/v1/%v", req.GetName())

		params := url.Values{}
		params.Add("$alt", "json;enum-encoding=int")
		if req.GetFilter() != "" {
			params.Add("filter", fmt.Sprintf("%v", req.GetFilter()))
		}
		if req.GetPageSize() != 0 {
			params.Add("pageSize", fmt.Sprintf("%v", req.GetPageSize()))
		}
		if req.GetPageToken() != "" {
			params.Add("pageToken", fmt.Sprintf("%v", req.GetPageToken()))
		}

		baseUrl.RawQuery = params.Encode()

		// Build HTTP headers from client and context metadata.
		hds := append(c.xGoogHeaders, "Content-Type", "application/json")
		headers := gax.BuildHeaders(ctx, hds...)
		e := gax.Invoke(ctx, func(ctx context.Context, settings gax.CallSettings) error {
			if settings.Path != "" {
				baseUrl.Path = settings.Path
			}
			httpReq, err := http.NewRequest("GET", baseUrl.String(), nil)
			if err != nil {
				return err
			}
			httpReq.Header = headers

			buf, err := executeHTTPRequest(ctx, c.httpClient, httpReq, c.logger, nil, "ListOperations")
			if err != nil {
				return err
			}
			if err := unm.Unmarshal(buf, resp); err != nil {
				return err
			}

			return nil
		}, opts...)
		if e != nil {
			return nil, "", e
		}
		it.Response = resp
		return resp.GetOperations(), resp.GetNextPageToken(), nil
	}

	fetch := func(pageSize int, pageToken string) (string, error) {
		items, nextPageToken, err := it.InternalFetch(pageSize, pageToken)
		if err != nil {
			return "", err
		}
		it.items = append(it.items, items...)
		return nextPageToken, nil
	}

	it.pageInfo, it.nextFunc = iterator.NewPageInfo(fetch, it.bufLen, it.takeBuf)
	it.pageInfo.MaxSize = int(req.GetPageSize())
	it.pageInfo.Token = req.GetPageToken()

	return it
}

// CreateEdgeSlmOperation returns a new CreateEdgeSlmOperation from a given name.
// The name must be that of a previously created CreateEdgeSlmOperation, possibly from a different process.
func (c *gRPCClient) CreateEdgeSlmOperation(name string) *CreateEdgeSlmOperation {
	return &CreateEdgeSlmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateEdgeSlmOperation returns a new CreateEdgeSlmOperation from a given name.
// The name must be that of a previously created CreateEdgeSlmOperation, possibly from a different process.
func (c *restClient) CreateEdgeSlmOperation(name string) *CreateEdgeSlmOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateEdgeSlmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// CreateOrchestrationClusterOperation returns a new CreateOrchestrationClusterOperation from a given name.
// The name must be that of a previously created CreateOrchestrationClusterOperation, possibly from a different process.
func (c *gRPCClient) CreateOrchestrationClusterOperation(name string) *CreateOrchestrationClusterOperation {
	return &CreateOrchestrationClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// CreateOrchestrationClusterOperation returns a new CreateOrchestrationClusterOperation from a given name.
// The name must be that of a previously created CreateOrchestrationClusterOperation, possibly from a different process.
func (c *restClient) CreateOrchestrationClusterOperation(name string) *CreateOrchestrationClusterOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &CreateOrchestrationClusterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteEdgeSlmOperation returns a new DeleteEdgeSlmOperation from a given name.
// The name must be that of a previously created DeleteEdgeSlmOperation, possibly from a different process.
func (c *gRPCClient) DeleteEdgeSlmOperation(name string) *DeleteEdgeSlmOperation {
	return &DeleteEdgeSlmOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteEdgeSlmOperation returns a new DeleteEdgeSlmOperation from a given name.
// The name must be that of a previously created DeleteEdgeSlmOperation, possibly from a different process.
func (c *restClient) DeleteEdgeSlmOperation(name string) *DeleteEdgeSlmOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteEdgeSlmOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}

// DeleteOrchestrationClusterOperation returns a new DeleteOrchestrationClusterOperation from a given name.
// The name must be that of a previously created DeleteOrchestrationClusterOperation, possibly from a different process.
func (c *gRPCClient) DeleteOrchestrationClusterOperation(name string) *DeleteOrchestrationClusterOperation {
	return &DeleteOrchestrationClusterOperation{
		lro: longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
	}
}

// DeleteOrchestrationClusterOperation returns a new DeleteOrchestrationClusterOperation from a given name.
// The name must be that of a previously created DeleteOrchestrationClusterOperation, possibly from a different process.
func (c *restClient) DeleteOrchestrationClusterOperation(name string) *DeleteOrchestrationClusterOperation {
	override := fmt.Sprintf("/v1/%s", name)
	return &DeleteOrchestrationClusterOperation{
		lro:      longrunning.InternalNewOperation(*c.LROClient, &longrunningpb.Operation{Name: name}),
		pollPath: override,
	}
}
