package pcap

//go:generate go tool stringer -type=iface,protocolFamily -output types_string.go

type protocolFamily uint32 // for darwin

const (
	Unspecified protocolFamily = 0  // syscall.AF_UNSPEC
	Unix        protocolFamily = 1  // syscall.AF_UNIX  - Unix domain sockets
	IPv4        protocolFamily = 2  // syscall.AF_INET  - Internet Protocol v4
	IPv6        protocolFamily = 30 // syscall.AF_INET6 - Internet Protocol v6
)

type iface uint8

const (
	other                         iface = 1
	regular1822                   iface = 2
	hdh1822                       iface = 3
	ddnX25                        iface = 4
	rfc877x25                     iface = 5
	ethernetCsmacd                iface = 6
	iso88023Csmacd                iface = 7
	iso88024TokenBus              iface = 8
	iso88025TokenRing             iface = 9
	iso88026Man                   iface = 10
	starLan                       iface = 11
	proteon10Mbit                 iface = 12
	proteon80Mbit                 iface = 13
	hyperchannel                  iface = 14
	fddi                          iface = 15
	lapb                          iface = 16
	sdlc                          iface = 17
	ds1                           iface = 18
	e1                            iface = 19
	basicISDN                     iface = 20
	primaryISDN                   iface = 21
	propPointToPointSerial        iface = 22
	ppp                           iface = 23
	softwareLoopback              iface = 24
	eon                           iface = 25
	ethernet3Mbit                 iface = 26
	nsip                          iface = 27
	slip                          iface = 28
	ultra                         iface = 29
	ds3                           iface = 30
	sip                           iface = 31
	frameRelay                    iface = 32
	rs232                         iface = 33
	para                          iface = 34
	arcnet                        iface = 35
	arcnetPlus                    iface = 36
	atm                           iface = 37
	miox25                        iface = 38
	sonet                         iface = 39
	x25ple                        iface = 40
	iso88022llc                   iface = 41
	localTalk                     iface = 42
	smdsDxi                       iface = 43
	frameRelayService             iface = 44
	v35                           iface = 45
	hssi                          iface = 46
	hippi                         iface = 47
	modem                         iface = 48
	aal5                          iface = 49
	sonetPath                     iface = 50
	sonetVT                       iface = 51
	smdsIcip                      iface = 52
	propVirtual                   iface = 53
	propMultiplexor               iface = 54
	ieee80212                     iface = 55
	fibreChannel                  iface = 56
	hippiInterface                iface = 57
	frameRelayInterconnect        iface = 58
	aflane8023                    iface = 59
	aflane8025                    iface = 60
	cctEmul                       iface = 61
	fastEther                     iface = 62
	isdn                          iface = 63
	v11                           iface = 64
	v36                           iface = 65
	g703at64k                     iface = 66
	g703at2mb                     iface = 67
	qllc                          iface = 68
	fastEtherFX                   iface = 69
	channel                       iface = 70
	ieee80211                     iface = 71
	ibm370parChan                 iface = 72
	escon                         iface = 73
	dlsw                          iface = 74
	isdns                         iface = 75
	isdnu                         iface = 76
	lapd                          iface = 77
	ipSwitch                      iface = 78
	rsrb                          iface = 79
	atmLogical                    iface = 80
	ds0                           iface = 81
	ds0Bundle                     iface = 82
	bsc                           iface = 83
	async                         iface = 84
	cnr                           iface = 85
	iso88025Dtr                   iface = 86
	eplrs                         iface = 87
	arap                          iface = 88
	propCnls                      iface = 89
	hostPad                       iface = 90
	termPad                       iface = 91
	frameRelayMPI                 iface = 92
	x213                          iface = 93
	adsl                          iface = 94
	radsl                         iface = 95
	sdsl                          iface = 96
	vdsl                          iface = 97
	iso88025CRFPInt               iface = 98
	myrinet                       iface = 99
	voiceEM                       iface = 100
	voiceFXO                      iface = 101
	voiceFXS                      iface = 102
	voiceEncap                    iface = 103
	voiceOverIp                   iface = 104
	atmDxi                        iface = 105
	atmFuni                       iface = 106
	atmIma                        iface = 107
	pppMultilinkBundle            iface = 108
	ipOverCdlc                    iface = 109
	ipOverClaw                    iface = 110
	stackToStack                  iface = 111
	virtualIpAddress              iface = 112
	mpc                           iface = 113
	ipOverAtm                     iface = 114
	iso88025Fiber                 iface = 115
	tdlc                          iface = 116
	gigabitEthernet               iface = 117
	hdlc                          iface = 118
	lapf                          iface = 119
	v37                           iface = 120
	x25mlp                        iface = 121
	x25huntGroup                  iface = 122
	transpHdlc                    iface = 123
	interleave                    iface = 124
	fast                          iface = 125
	ip                            iface = 126
	docsCableMaclayer             iface = 127
	docsCableDownstream           iface = 128
	docsCableUpstream             iface = 129
	a12MppSwitch                  iface = 130
	tunnel                        iface = 131
	coffee                        iface = 132
	ces                           iface = 133
	atmSubInterface               iface = 134
	l2vlan                        iface = 135
	l3ipvlan                      iface = 136
	l3ipxvlan                     iface = 137
	digitalPowerline              iface = 138
	mediaMailOverIp               iface = 139
	dtm                           iface = 140
	dcn                           iface = 141
	ipForward                     iface = 142
	msdsl                         iface = 143
	ieee1394                      iface = 144
	if_gsn                        iface = 145
	dvbRccMacLayer                iface = 146
	dvbRccDownstream              iface = 147
	dvbRccUpstream                iface = 148
	atmVirtual                    iface = 149
	mplsTunnel                    iface = 150
	srp                           iface = 151
	voiceOverAtm                  iface = 152
	voiceOverFrameRelay           iface = 153
	idsl                          iface = 154
	compositeLink                 iface = 155
	ss7SigLink                    iface = 156
	propWirelessP2P               iface = 157
	frForward                     iface = 158
	rfc1483                       iface = 159
	USB                           iface = 160
	ieee8023adLag                 iface = 161
	bgppolicyaccounting           iface = 162
	frf16MfrBundle                iface = 163
	h323Gatekeeper                iface = 164
	h323Proxy                     iface = 165
	mpls                          iface = 166
	mfSigLink                     iface = 167
	hdsl2                         iface = 168
	shdsl                         iface = 169
	ds1FDL                        iface = 170
	pos                           iface = 171
	dvbAsiIn                      iface = 172
	dvbAsiOut                     iface = 173
	plc                           iface = 174
	nfas                          iface = 175
	tr008                         iface = 176
	gr303RDT                      iface = 177
	gr303IDT                      iface = 178
	isup                          iface = 179
	propDocsWirelessMaclayer      iface = 180
	propDocsWirelessDownstream    iface = 181
	propDocsWirelessUpstream      iface = 182
	hiperlan2                     iface = 183
	propBWAp2Mp                   iface = 184
	sonetOverheadChannel          iface = 185
	digitalWrapperOverheadChannel iface = 186
	aal2                          iface = 187
	radioMAC                      iface = 188
	atmRadio                      iface = 189
	imt                           iface = 190
	mvl                           iface = 191
	reachDSL                      iface = 192
	frDlciEndPt                   iface = 193
	atmVciEndPt                   iface = 194
	opticalChannel                iface = 195
	opticalTransport              iface = 196
	propAtm                       iface = 197
	voiceOverCable                iface = 198
	infiniband                    iface = 199
	teLink                        iface = 200
	q2931                         iface = 201
	virtualTg                     iface = 202
	sipTg                         iface = 203
	sipSig                        iface = 204
	docsCableUpstreamChannel      iface = 205
	econet                        iface = 206
	pon155                        iface = 207
	pon622                        iface = 208
	bridge                        iface = 209
	linegroup                     iface = 210
	voiceEMFGD                    iface = 211
	voiceFGDEANA                  iface = 212
	voiceDID                      iface = 213
	mpegTransport                 iface = 214
	sixToFour                     iface = 215
	gtp                           iface = 216
	pdnEtherLoop1                 iface = 217
	pdnEtherLoop2                 iface = 218
	opticalChannelGroup           iface = 219
	homepna                       iface = 220
	gfp                           iface = 221
	ciscoISLvlan                  iface = 222
	actelisMetaLOOP               iface = 223
	fcipLink                      iface = 224
	rpr                           iface = 225
	qam                           iface = 226
	lmp                           iface = 227
	cblVectaStar                  iface = 228
	docsCableMCmtsDownstream      iface = 229
	adsl2                         iface = 230
	macSecControlledIF            iface = 231
	macSecUncontrolledIF          iface = 232
	aviciOpticalEther             iface = 233
	atmbond                       iface = 234
	voiceFGDOS                    iface = 235
	mocaVersion1                  iface = 236
	ieee80216WMAN                 iface = 237
	adsl2plus                     iface = 238
	dvbRcsMacLayer                iface = 239
	dvbTdm                        iface = 240
	dvbRcsTdma                    iface = 241
	x86Laps                       iface = 242
	wwanPP                        iface = 243
	wwanPP2                       iface = 244
	voiceEBS                      iface = 245
	ifPwType                      iface = 246
	ilan                          iface = 247
	pip                           iface = 248
	aluELP                        iface = 249
	gpon                          iface = 250
	vdsl2                         iface = 251
	capwapDot11Profile            iface = 252
	capwapDot11Bss                iface = 253
	capwapWtpVirtualRadio         iface = 254
	bits                          iface = 255
	// docsCableUpstreamRfPort       iface = 256
	// cableDownstreamRfPort         iface = 257
	// vmwareVirtualNic              iface = 258
	// ieee802154                    iface = 259
)
