// Copyright 2017 Prometheus Team
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.36.5
// 	protoc        (unknown)
// source: types.proto

//go:build protoopaque

package _go

import (
	_ "buf.build/gen/go/gogo/protobuf/protocolbuffers/go/gogoproto"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	unsafe "unsafe"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type MetricMetadata_MetricType int32

const (
	MetricMetadata_UNKNOWN        MetricMetadata_MetricType = 0
	MetricMetadata_COUNTER        MetricMetadata_MetricType = 1
	MetricMetadata_GAUGE          MetricMetadata_MetricType = 2
	MetricMetadata_HISTOGRAM      MetricMetadata_MetricType = 3
	MetricMetadata_GAUGEHISTOGRAM MetricMetadata_MetricType = 4
	MetricMetadata_SUMMARY        MetricMetadata_MetricType = 5
	MetricMetadata_INFO           MetricMetadata_MetricType = 6
	MetricMetadata_STATESET       MetricMetadata_MetricType = 7
)

// Enum value maps for MetricMetadata_MetricType.
var (
	MetricMetadata_MetricType_name = map[int32]string{
		0: "UNKNOWN",
		1: "COUNTER",
		2: "GAUGE",
		3: "HISTOGRAM",
		4: "GAUGEHISTOGRAM",
		5: "SUMMARY",
		6: "INFO",
		7: "STATESET",
	}
	MetricMetadata_MetricType_value = map[string]int32{
		"UNKNOWN":        0,
		"COUNTER":        1,
		"GAUGE":          2,
		"HISTOGRAM":      3,
		"GAUGEHISTOGRAM": 4,
		"SUMMARY":        5,
		"INFO":           6,
		"STATESET":       7,
	}
)

func (x MetricMetadata_MetricType) Enum() *MetricMetadata_MetricType {
	p := new(MetricMetadata_MetricType)
	*p = x
	return p
}

func (x MetricMetadata_MetricType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (MetricMetadata_MetricType) Descriptor() protoreflect.EnumDescriptor {
	return file_types_proto_enumTypes[0].Descriptor()
}

func (MetricMetadata_MetricType) Type() protoreflect.EnumType {
	return &file_types_proto_enumTypes[0]
}

func (x MetricMetadata_MetricType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type Histogram_ResetHint int32

const (
	Histogram_UNKNOWN Histogram_ResetHint = 0 // Need to test for a counter reset explicitly.
	Histogram_YES     Histogram_ResetHint = 1 // This is the 1st histogram after a counter reset.
	Histogram_NO      Histogram_ResetHint = 2 // There was no counter reset between this and the previous Histogram.
	Histogram_GAUGE   Histogram_ResetHint = 3 // This is a gauge histogram where counter resets don't happen.
)

// Enum value maps for Histogram_ResetHint.
var (
	Histogram_ResetHint_name = map[int32]string{
		0: "UNKNOWN",
		1: "YES",
		2: "NO",
		3: "GAUGE",
	}
	Histogram_ResetHint_value = map[string]int32{
		"UNKNOWN": 0,
		"YES":     1,
		"NO":      2,
		"GAUGE":   3,
	}
)

func (x Histogram_ResetHint) Enum() *Histogram_ResetHint {
	p := new(Histogram_ResetHint)
	*p = x
	return p
}

func (x Histogram_ResetHint) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Histogram_ResetHint) Descriptor() protoreflect.EnumDescriptor {
	return file_types_proto_enumTypes[1].Descriptor()
}

func (Histogram_ResetHint) Type() protoreflect.EnumType {
	return &file_types_proto_enumTypes[1]
}

func (x Histogram_ResetHint) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type LabelMatcher_Type int32

const (
	LabelMatcher_EQ  LabelMatcher_Type = 0
	LabelMatcher_NEQ LabelMatcher_Type = 1
	LabelMatcher_RE  LabelMatcher_Type = 2
	LabelMatcher_NRE LabelMatcher_Type = 3
)

// Enum value maps for LabelMatcher_Type.
var (
	LabelMatcher_Type_name = map[int32]string{
		0: "EQ",
		1: "NEQ",
		2: "RE",
		3: "NRE",
	}
	LabelMatcher_Type_value = map[string]int32{
		"EQ":  0,
		"NEQ": 1,
		"RE":  2,
		"NRE": 3,
	}
)

func (x LabelMatcher_Type) Enum() *LabelMatcher_Type {
	p := new(LabelMatcher_Type)
	*p = x
	return p
}

func (x LabelMatcher_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (LabelMatcher_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_types_proto_enumTypes[2].Descriptor()
}

func (LabelMatcher_Type) Type() protoreflect.EnumType {
	return &file_types_proto_enumTypes[2]
}

func (x LabelMatcher_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// We require this to match chunkenc.Encoding.
type Chunk_Encoding int32

const (
	Chunk_UNKNOWN         Chunk_Encoding = 0
	Chunk_XOR             Chunk_Encoding = 1
	Chunk_HISTOGRAM       Chunk_Encoding = 2
	Chunk_FLOAT_HISTOGRAM Chunk_Encoding = 3
)

// Enum value maps for Chunk_Encoding.
var (
	Chunk_Encoding_name = map[int32]string{
		0: "UNKNOWN",
		1: "XOR",
		2: "HISTOGRAM",
		3: "FLOAT_HISTOGRAM",
	}
	Chunk_Encoding_value = map[string]int32{
		"UNKNOWN":         0,
		"XOR":             1,
		"HISTOGRAM":       2,
		"FLOAT_HISTOGRAM": 3,
	}
)

func (x Chunk_Encoding) Enum() *Chunk_Encoding {
	p := new(Chunk_Encoding)
	*p = x
	return p
}

func (x Chunk_Encoding) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Chunk_Encoding) Descriptor() protoreflect.EnumDescriptor {
	return file_types_proto_enumTypes[3].Descriptor()
}

func (Chunk_Encoding) Type() protoreflect.EnumType {
	return &file_types_proto_enumTypes[3]
}

func (x Chunk_Encoding) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

type MetricMetadata struct {
	state                       protoimpl.MessageState    `protogen:"opaque.v1"`
	xxx_hidden_Type             MetricMetadata_MetricType `protobuf:"varint,1,opt,name=type,proto3,enum=prometheus.MetricMetadata_MetricType"`
	xxx_hidden_MetricFamilyName string                    `protobuf:"bytes,2,opt,name=metric_family_name,json=metricFamilyName,proto3"`
	xxx_hidden_Help             string                    `protobuf:"bytes,4,opt,name=help,proto3"`
	xxx_hidden_Unit             string                    `protobuf:"bytes,5,opt,name=unit,proto3"`
	unknownFields               protoimpl.UnknownFields
	sizeCache                   protoimpl.SizeCache
}

func (x *MetricMetadata) Reset() {
	*x = MetricMetadata{}
	mi := &file_types_proto_msgTypes[0]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *MetricMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MetricMetadata) ProtoMessage() {}

func (x *MetricMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[0]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *MetricMetadata) GetType() MetricMetadata_MetricType {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return MetricMetadata_UNKNOWN
}

func (x *MetricMetadata) GetMetricFamilyName() string {
	if x != nil {
		return x.xxx_hidden_MetricFamilyName
	}
	return ""
}

func (x *MetricMetadata) GetHelp() string {
	if x != nil {
		return x.xxx_hidden_Help
	}
	return ""
}

func (x *MetricMetadata) GetUnit() string {
	if x != nil {
		return x.xxx_hidden_Unit
	}
	return ""
}

func (x *MetricMetadata) SetType(v MetricMetadata_MetricType) {
	x.xxx_hidden_Type = v
}

func (x *MetricMetadata) SetMetricFamilyName(v string) {
	x.xxx_hidden_MetricFamilyName = v
}

func (x *MetricMetadata) SetHelp(v string) {
	x.xxx_hidden_Help = v
}

func (x *MetricMetadata) SetUnit(v string) {
	x.xxx_hidden_Unit = v
}

type MetricMetadata_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Represents the metric type, these match the set from Prometheus.
	// Refer to github.com/prometheus/common/model/metadata.go for details.
	Type             MetricMetadata_MetricType
	MetricFamilyName string
	Help             string
	Unit             string
}

func (b0 MetricMetadata_builder) Build() *MetricMetadata {
	m0 := &MetricMetadata{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_MetricFamilyName = b.MetricFamilyName
	x.xxx_hidden_Help = b.Help
	x.xxx_hidden_Unit = b.Unit
	return m0
}

type Sample struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Value     float64                `protobuf:"fixed64,1,opt,name=value,proto3"`
	xxx_hidden_Timestamp int64                  `protobuf:"varint,2,opt,name=timestamp,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Sample) Reset() {
	*x = Sample{}
	mi := &file_types_proto_msgTypes[1]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Sample) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Sample) ProtoMessage() {}

func (x *Sample) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[1]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Sample) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Sample) GetTimestamp() int64 {
	if x != nil {
		return x.xxx_hidden_Timestamp
	}
	return 0
}

func (x *Sample) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

func (x *Sample) SetTimestamp(v int64) {
	x.xxx_hidden_Timestamp = v
}

type Sample_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Value float64
	// timestamp is in ms format, see model/timestamp/timestamp.go for
	// conversion from time.Time to Prometheus timestamp.
	Timestamp int64
}

func (b0 Sample_builder) Build() *Sample {
	m0 := &Sample{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Timestamp = b.Timestamp
	return m0
}

type Exemplar struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Labels    *[]*Label              `protobuf:"bytes,1,rep,name=labels,proto3"`
	xxx_hidden_Value     float64                `protobuf:"fixed64,2,opt,name=value,proto3"`
	xxx_hidden_Timestamp int64                  `protobuf:"varint,3,opt,name=timestamp,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Exemplar) Reset() {
	*x = Exemplar{}
	mi := &file_types_proto_msgTypes[2]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Exemplar) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Exemplar) ProtoMessage() {}

func (x *Exemplar) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[2]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Exemplar) GetLabels() []*Label {
	if x != nil {
		if x.xxx_hidden_Labels != nil {
			return *x.xxx_hidden_Labels
		}
	}
	return nil
}

func (x *Exemplar) GetValue() float64 {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return 0
}

func (x *Exemplar) GetTimestamp() int64 {
	if x != nil {
		return x.xxx_hidden_Timestamp
	}
	return 0
}

func (x *Exemplar) SetLabels(v []*Label) {
	x.xxx_hidden_Labels = &v
}

func (x *Exemplar) SetValue(v float64) {
	x.xxx_hidden_Value = v
}

func (x *Exemplar) SetTimestamp(v int64) {
	x.xxx_hidden_Timestamp = v
}

type Exemplar_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Optional, can be empty.
	Labels []*Label
	Value  float64
	// timestamp is in ms format, see model/timestamp/timestamp.go for
	// conversion from time.Time to Prometheus timestamp.
	Timestamp int64
}

func (b0 Exemplar_builder) Build() *Exemplar {
	m0 := &Exemplar{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Labels = &b.Labels
	x.xxx_hidden_Value = b.Value
	x.xxx_hidden_Timestamp = b.Timestamp
	return m0
}

// A native histogram, also known as a sparse histogram.
// Original design doc:
// https://docs.google.com/document/d/1cLNv3aufPZb3fNfaJgdaRBZsInZKKIHo9E6HinJVbpM/edit
// The appendix of this design doc also explains the concept of float
// histograms. This Histogram message can represent both, the usual
// integer histogram as well as a float histogram.
type Histogram struct {
	state                     protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Count          isHistogram_Count      `protobuf_oneof:"count"`
	xxx_hidden_Sum            float64                `protobuf:"fixed64,3,opt,name=sum,proto3"`
	xxx_hidden_Schema         int32                  `protobuf:"zigzag32,4,opt,name=schema,proto3"`
	xxx_hidden_ZeroThreshold  float64                `protobuf:"fixed64,5,opt,name=zero_threshold,json=zeroThreshold,proto3"`
	xxx_hidden_ZeroCount      isHistogram_ZeroCount  `protobuf_oneof:"zero_count"`
	xxx_hidden_NegativeSpans  *[]*BucketSpan         `protobuf:"bytes,8,rep,name=negative_spans,json=negativeSpans,proto3"`
	xxx_hidden_NegativeDeltas []int64                `protobuf:"zigzag64,9,rep,packed,name=negative_deltas,json=negativeDeltas,proto3"`
	xxx_hidden_NegativeCounts []float64              `protobuf:"fixed64,10,rep,packed,name=negative_counts,json=negativeCounts,proto3"`
	xxx_hidden_PositiveSpans  *[]*BucketSpan         `protobuf:"bytes,11,rep,name=positive_spans,json=positiveSpans,proto3"`
	xxx_hidden_PositiveDeltas []int64                `protobuf:"zigzag64,12,rep,packed,name=positive_deltas,json=positiveDeltas,proto3"`
	xxx_hidden_PositiveCounts []float64              `protobuf:"fixed64,13,rep,packed,name=positive_counts,json=positiveCounts,proto3"`
	xxx_hidden_ResetHint      Histogram_ResetHint    `protobuf:"varint,14,opt,name=reset_hint,json=resetHint,proto3,enum=prometheus.Histogram_ResetHint"`
	xxx_hidden_Timestamp      int64                  `protobuf:"varint,15,opt,name=timestamp,proto3"`
	unknownFields             protoimpl.UnknownFields
	sizeCache                 protoimpl.SizeCache
}

func (x *Histogram) Reset() {
	*x = Histogram{}
	mi := &file_types_proto_msgTypes[3]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Histogram) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Histogram) ProtoMessage() {}

func (x *Histogram) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[3]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Histogram) GetCountInt() uint64 {
	if x != nil {
		if x, ok := x.xxx_hidden_Count.(*histogram_CountInt); ok {
			return x.CountInt
		}
	}
	return 0
}

func (x *Histogram) GetCountFloat() float64 {
	if x != nil {
		if x, ok := x.xxx_hidden_Count.(*histogram_CountFloat); ok {
			return x.CountFloat
		}
	}
	return 0
}

func (x *Histogram) GetSum() float64 {
	if x != nil {
		return x.xxx_hidden_Sum
	}
	return 0
}

func (x *Histogram) GetSchema() int32 {
	if x != nil {
		return x.xxx_hidden_Schema
	}
	return 0
}

func (x *Histogram) GetZeroThreshold() float64 {
	if x != nil {
		return x.xxx_hidden_ZeroThreshold
	}
	return 0
}

func (x *Histogram) GetZeroCountInt() uint64 {
	if x != nil {
		if x, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountInt); ok {
			return x.ZeroCountInt
		}
	}
	return 0
}

func (x *Histogram) GetZeroCountFloat() float64 {
	if x != nil {
		if x, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountFloat); ok {
			return x.ZeroCountFloat
		}
	}
	return 0
}

func (x *Histogram) GetNegativeSpans() []*BucketSpan {
	if x != nil {
		if x.xxx_hidden_NegativeSpans != nil {
			return *x.xxx_hidden_NegativeSpans
		}
	}
	return nil
}

func (x *Histogram) GetNegativeDeltas() []int64 {
	if x != nil {
		return x.xxx_hidden_NegativeDeltas
	}
	return nil
}

func (x *Histogram) GetNegativeCounts() []float64 {
	if x != nil {
		return x.xxx_hidden_NegativeCounts
	}
	return nil
}

func (x *Histogram) GetPositiveSpans() []*BucketSpan {
	if x != nil {
		if x.xxx_hidden_PositiveSpans != nil {
			return *x.xxx_hidden_PositiveSpans
		}
	}
	return nil
}

func (x *Histogram) GetPositiveDeltas() []int64 {
	if x != nil {
		return x.xxx_hidden_PositiveDeltas
	}
	return nil
}

func (x *Histogram) GetPositiveCounts() []float64 {
	if x != nil {
		return x.xxx_hidden_PositiveCounts
	}
	return nil
}

func (x *Histogram) GetResetHint() Histogram_ResetHint {
	if x != nil {
		return x.xxx_hidden_ResetHint
	}
	return Histogram_UNKNOWN
}

func (x *Histogram) GetTimestamp() int64 {
	if x != nil {
		return x.xxx_hidden_Timestamp
	}
	return 0
}

func (x *Histogram) SetCountInt(v uint64) {
	x.xxx_hidden_Count = &histogram_CountInt{v}
}

func (x *Histogram) SetCountFloat(v float64) {
	x.xxx_hidden_Count = &histogram_CountFloat{v}
}

func (x *Histogram) SetSum(v float64) {
	x.xxx_hidden_Sum = v
}

func (x *Histogram) SetSchema(v int32) {
	x.xxx_hidden_Schema = v
}

func (x *Histogram) SetZeroThreshold(v float64) {
	x.xxx_hidden_ZeroThreshold = v
}

func (x *Histogram) SetZeroCountInt(v uint64) {
	x.xxx_hidden_ZeroCount = &histogram_ZeroCountInt{v}
}

func (x *Histogram) SetZeroCountFloat(v float64) {
	x.xxx_hidden_ZeroCount = &histogram_ZeroCountFloat{v}
}

func (x *Histogram) SetNegativeSpans(v []*BucketSpan) {
	x.xxx_hidden_NegativeSpans = &v
}

func (x *Histogram) SetNegativeDeltas(v []int64) {
	x.xxx_hidden_NegativeDeltas = v
}

func (x *Histogram) SetNegativeCounts(v []float64) {
	x.xxx_hidden_NegativeCounts = v
}

func (x *Histogram) SetPositiveSpans(v []*BucketSpan) {
	x.xxx_hidden_PositiveSpans = &v
}

func (x *Histogram) SetPositiveDeltas(v []int64) {
	x.xxx_hidden_PositiveDeltas = v
}

func (x *Histogram) SetPositiveCounts(v []float64) {
	x.xxx_hidden_PositiveCounts = v
}

func (x *Histogram) SetResetHint(v Histogram_ResetHint) {
	x.xxx_hidden_ResetHint = v
}

func (x *Histogram) SetTimestamp(v int64) {
	x.xxx_hidden_Timestamp = v
}

func (x *Histogram) HasCount() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_Count != nil
}

func (x *Histogram) HasCountInt() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Count.(*histogram_CountInt)
	return ok
}

func (x *Histogram) HasCountFloat() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_Count.(*histogram_CountFloat)
	return ok
}

func (x *Histogram) HasZeroCount() bool {
	if x == nil {
		return false
	}
	return x.xxx_hidden_ZeroCount != nil
}

func (x *Histogram) HasZeroCountInt() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountInt)
	return ok
}

func (x *Histogram) HasZeroCountFloat() bool {
	if x == nil {
		return false
	}
	_, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountFloat)
	return ok
}

func (x *Histogram) ClearCount() {
	x.xxx_hidden_Count = nil
}

func (x *Histogram) ClearCountInt() {
	if _, ok := x.xxx_hidden_Count.(*histogram_CountInt); ok {
		x.xxx_hidden_Count = nil
	}
}

func (x *Histogram) ClearCountFloat() {
	if _, ok := x.xxx_hidden_Count.(*histogram_CountFloat); ok {
		x.xxx_hidden_Count = nil
	}
}

func (x *Histogram) ClearZeroCount() {
	x.xxx_hidden_ZeroCount = nil
}

func (x *Histogram) ClearZeroCountInt() {
	if _, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountInt); ok {
		x.xxx_hidden_ZeroCount = nil
	}
}

func (x *Histogram) ClearZeroCountFloat() {
	if _, ok := x.xxx_hidden_ZeroCount.(*histogram_ZeroCountFloat); ok {
		x.xxx_hidden_ZeroCount = nil
	}
}

const Histogram_Count_not_set_case case_Histogram_Count = 0
const Histogram_CountInt_case case_Histogram_Count = 1
const Histogram_CountFloat_case case_Histogram_Count = 2

func (x *Histogram) WhichCount() case_Histogram_Count {
	if x == nil {
		return Histogram_Count_not_set_case
	}
	switch x.xxx_hidden_Count.(type) {
	case *histogram_CountInt:
		return Histogram_CountInt_case
	case *histogram_CountFloat:
		return Histogram_CountFloat_case
	default:
		return Histogram_Count_not_set_case
	}
}

const Histogram_ZeroCount_not_set_case case_Histogram_ZeroCount = 0
const Histogram_ZeroCountInt_case case_Histogram_ZeroCount = 6
const Histogram_ZeroCountFloat_case case_Histogram_ZeroCount = 7

func (x *Histogram) WhichZeroCount() case_Histogram_ZeroCount {
	if x == nil {
		return Histogram_ZeroCount_not_set_case
	}
	switch x.xxx_hidden_ZeroCount.(type) {
	case *histogram_ZeroCountInt:
		return Histogram_ZeroCountInt_case
	case *histogram_ZeroCountFloat:
		return Histogram_ZeroCountFloat_case
	default:
		return Histogram_ZeroCount_not_set_case
	}
}

type Histogram_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Fields of oneof xxx_hidden_Count:
	CountInt   *uint64
	CountFloat *float64
	// -- end of xxx_hidden_Count
	Sum float64
	// The schema defines the bucket schema. Currently, valid numbers
	// are -4 <= n <= 8. They are all for base-2 bucket schemas, where 1
	// is a bucket boundary in each case, and then each power of two is
	// divided into 2^n logarithmic buckets. Or in other words, each
	// bucket boundary is the previous boundary times 2^(2^-n). In the
	// future, more bucket schemas may be added using numbers < -4 or >
	// 8.
	Schema        int32
	ZeroThreshold float64
	// Fields of oneof xxx_hidden_ZeroCount:
	ZeroCountInt   *uint64
	ZeroCountFloat *float64
	// -- end of xxx_hidden_ZeroCount
	// Negative Buckets.
	NegativeSpans []*BucketSpan
	// Use either "negative_deltas" or "negative_counts", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	NegativeDeltas []int64
	NegativeCounts []float64
	// Positive Buckets.
	PositiveSpans []*BucketSpan
	// Use either "positive_deltas" or "positive_counts", the former for
	// regular histograms with integer counts, the latter for float
	// histograms.
	PositiveDeltas []int64
	PositiveCounts []float64
	ResetHint      Histogram_ResetHint
	// timestamp is in ms format, see model/timestamp/timestamp.go for
	// conversion from time.Time to Prometheus timestamp.
	Timestamp int64
}

func (b0 Histogram_builder) Build() *Histogram {
	m0 := &Histogram{}
	b, x := &b0, m0
	_, _ = b, x
	if b.CountInt != nil {
		x.xxx_hidden_Count = &histogram_CountInt{*b.CountInt}
	}
	if b.CountFloat != nil {
		x.xxx_hidden_Count = &histogram_CountFloat{*b.CountFloat}
	}
	x.xxx_hidden_Sum = b.Sum
	x.xxx_hidden_Schema = b.Schema
	x.xxx_hidden_ZeroThreshold = b.ZeroThreshold
	if b.ZeroCountInt != nil {
		x.xxx_hidden_ZeroCount = &histogram_ZeroCountInt{*b.ZeroCountInt}
	}
	if b.ZeroCountFloat != nil {
		x.xxx_hidden_ZeroCount = &histogram_ZeroCountFloat{*b.ZeroCountFloat}
	}
	x.xxx_hidden_NegativeSpans = &b.NegativeSpans
	x.xxx_hidden_NegativeDeltas = b.NegativeDeltas
	x.xxx_hidden_NegativeCounts = b.NegativeCounts
	x.xxx_hidden_PositiveSpans = &b.PositiveSpans
	x.xxx_hidden_PositiveDeltas = b.PositiveDeltas
	x.xxx_hidden_PositiveCounts = b.PositiveCounts
	x.xxx_hidden_ResetHint = b.ResetHint
	x.xxx_hidden_Timestamp = b.Timestamp
	return m0
}

type case_Histogram_Count protoreflect.FieldNumber

func (x case_Histogram_Count) String() string {
	md := file_types_proto_msgTypes[3].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type case_Histogram_ZeroCount protoreflect.FieldNumber

func (x case_Histogram_ZeroCount) String() string {
	md := file_types_proto_msgTypes[3].Descriptor()
	if x == 0 {
		return "not set"
	}
	return protoimpl.X.MessageFieldStringOf(md, protoreflect.FieldNumber(x))
}

type isHistogram_Count interface {
	isHistogram_Count()
}

type histogram_CountInt struct {
	CountInt uint64 `protobuf:"varint,1,opt,name=count_int,json=countInt,proto3,oneof"`
}

type histogram_CountFloat struct {
	CountFloat float64 `protobuf:"fixed64,2,opt,name=count_float,json=countFloat,proto3,oneof"`
}

func (*histogram_CountInt) isHistogram_Count() {}

func (*histogram_CountFloat) isHistogram_Count() {}

type isHistogram_ZeroCount interface {
	isHistogram_ZeroCount()
}

type histogram_ZeroCountInt struct {
	ZeroCountInt uint64 `protobuf:"varint,6,opt,name=zero_count_int,json=zeroCountInt,proto3,oneof"`
}

type histogram_ZeroCountFloat struct {
	ZeroCountFloat float64 `protobuf:"fixed64,7,opt,name=zero_count_float,json=zeroCountFloat,proto3,oneof"`
}

func (*histogram_ZeroCountInt) isHistogram_ZeroCount() {}

func (*histogram_ZeroCountFloat) isHistogram_ZeroCount() {}

// A BucketSpan defines a number of consecutive buckets with their
// offset. Logically, it would be more straightforward to include the
// bucket counts in the Span. However, the protobuf representation is
// more compact in the way the data is structured here (with all the
// buckets in a single array separate from the Spans).
type BucketSpan struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Offset int32                  `protobuf:"zigzag32,1,opt,name=offset,proto3"`
	xxx_hidden_Length uint32                 `protobuf:"varint,2,opt,name=length,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *BucketSpan) Reset() {
	*x = BucketSpan{}
	mi := &file_types_proto_msgTypes[4]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *BucketSpan) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*BucketSpan) ProtoMessage() {}

func (x *BucketSpan) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[4]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *BucketSpan) GetOffset() int32 {
	if x != nil {
		return x.xxx_hidden_Offset
	}
	return 0
}

func (x *BucketSpan) GetLength() uint32 {
	if x != nil {
		return x.xxx_hidden_Length
	}
	return 0
}

func (x *BucketSpan) SetOffset(v int32) {
	x.xxx_hidden_Offset = v
}

func (x *BucketSpan) SetLength(v uint32) {
	x.xxx_hidden_Length = v
}

type BucketSpan_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Offset int32
	Length uint32
}

func (b0 BucketSpan_builder) Build() *BucketSpan {
	m0 := &BucketSpan{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Offset = b.Offset
	x.xxx_hidden_Length = b.Length
	return m0
}

// TimeSeries represents samples and labels for a single time series.
type TimeSeries struct {
	state                 protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Labels     *[]*Label              `protobuf:"bytes,1,rep,name=labels,proto3"`
	xxx_hidden_Samples    *[]*Sample             `protobuf:"bytes,2,rep,name=samples,proto3"`
	xxx_hidden_Exemplars  *[]*Exemplar           `protobuf:"bytes,3,rep,name=exemplars,proto3"`
	xxx_hidden_Histograms *[]*Histogram          `protobuf:"bytes,4,rep,name=histograms,proto3"`
	unknownFields         protoimpl.UnknownFields
	sizeCache             protoimpl.SizeCache
}

func (x *TimeSeries) Reset() {
	*x = TimeSeries{}
	mi := &file_types_proto_msgTypes[5]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *TimeSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*TimeSeries) ProtoMessage() {}

func (x *TimeSeries) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[5]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *TimeSeries) GetLabels() []*Label {
	if x != nil {
		if x.xxx_hidden_Labels != nil {
			return *x.xxx_hidden_Labels
		}
	}
	return nil
}

func (x *TimeSeries) GetSamples() []*Sample {
	if x != nil {
		if x.xxx_hidden_Samples != nil {
			return *x.xxx_hidden_Samples
		}
	}
	return nil
}

func (x *TimeSeries) GetExemplars() []*Exemplar {
	if x != nil {
		if x.xxx_hidden_Exemplars != nil {
			return *x.xxx_hidden_Exemplars
		}
	}
	return nil
}

func (x *TimeSeries) GetHistograms() []*Histogram {
	if x != nil {
		if x.xxx_hidden_Histograms != nil {
			return *x.xxx_hidden_Histograms
		}
	}
	return nil
}

func (x *TimeSeries) SetLabels(v []*Label) {
	x.xxx_hidden_Labels = &v
}

func (x *TimeSeries) SetSamples(v []*Sample) {
	x.xxx_hidden_Samples = &v
}

func (x *TimeSeries) SetExemplars(v []*Exemplar) {
	x.xxx_hidden_Exemplars = &v
}

func (x *TimeSeries) SetHistograms(v []*Histogram) {
	x.xxx_hidden_Histograms = &v
}

type TimeSeries_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// For a timeseries to be valid, and for the samples and exemplars
	// to be ingested by the remote system properly, the labels field is required.
	Labels     []*Label
	Samples    []*Sample
	Exemplars  []*Exemplar
	Histograms []*Histogram
}

func (b0 TimeSeries_builder) Build() *TimeSeries {
	m0 := &TimeSeries{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Labels = &b.Labels
	x.xxx_hidden_Samples = &b.Samples
	x.xxx_hidden_Exemplars = &b.Exemplars
	x.xxx_hidden_Histograms = &b.Histograms
	return m0
}

type Label struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Name  string                 `protobuf:"bytes,1,opt,name=name,proto3"`
	xxx_hidden_Value string                 `protobuf:"bytes,2,opt,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *Label) Reset() {
	*x = Label{}
	mi := &file_types_proto_msgTypes[6]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Label) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Label) ProtoMessage() {}

func (x *Label) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[6]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Label) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *Label) GetValue() string {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return ""
}

func (x *Label) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *Label) SetValue(v string) {
	x.xxx_hidden_Value = v
}

type Label_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Name  string
	Value string
}

func (b0 Label_builder) Build() *Label {
	m0 := &Label{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Value = b.Value
	return m0
}

type Labels struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Labels *[]*Label              `protobuf:"bytes,1,rep,name=labels,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *Labels) Reset() {
	*x = Labels{}
	mi := &file_types_proto_msgTypes[7]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Labels) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Labels) ProtoMessage() {}

func (x *Labels) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[7]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Labels) GetLabels() []*Label {
	if x != nil {
		if x.xxx_hidden_Labels != nil {
			return *x.xxx_hidden_Labels
		}
	}
	return nil
}

func (x *Labels) SetLabels(v []*Label) {
	x.xxx_hidden_Labels = &v
}

type Labels_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Labels []*Label
}

func (b0 Labels_builder) Build() *Labels {
	m0 := &Labels{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Labels = &b.Labels
	return m0
}

// Matcher specifies a rule, which can match or set of labels or not.
type LabelMatcher struct {
	state            protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Type  LabelMatcher_Type      `protobuf:"varint,1,opt,name=type,proto3,enum=prometheus.LabelMatcher_Type"`
	xxx_hidden_Name  string                 `protobuf:"bytes,2,opt,name=name,proto3"`
	xxx_hidden_Value string                 `protobuf:"bytes,3,opt,name=value,proto3"`
	unknownFields    protoimpl.UnknownFields
	sizeCache        protoimpl.SizeCache
}

func (x *LabelMatcher) Reset() {
	*x = LabelMatcher{}
	mi := &file_types_proto_msgTypes[8]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *LabelMatcher) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*LabelMatcher) ProtoMessage() {}

func (x *LabelMatcher) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[8]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *LabelMatcher) GetType() LabelMatcher_Type {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return LabelMatcher_EQ
}

func (x *LabelMatcher) GetName() string {
	if x != nil {
		return x.xxx_hidden_Name
	}
	return ""
}

func (x *LabelMatcher) GetValue() string {
	if x != nil {
		return x.xxx_hidden_Value
	}
	return ""
}

func (x *LabelMatcher) SetType(v LabelMatcher_Type) {
	x.xxx_hidden_Type = v
}

func (x *LabelMatcher) SetName(v string) {
	x.xxx_hidden_Name = v
}

func (x *LabelMatcher) SetValue(v string) {
	x.xxx_hidden_Value = v
}

type LabelMatcher_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	Type  LabelMatcher_Type
	Name  string
	Value string
}

func (b0 LabelMatcher_builder) Build() *LabelMatcher {
	m0 := &LabelMatcher{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Name = b.Name
	x.xxx_hidden_Value = b.Value
	return m0
}

type ReadHints struct {
	state               protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_StepMs   int64                  `protobuf:"varint,1,opt,name=step_ms,json=stepMs,proto3"`
	xxx_hidden_Func     string                 `protobuf:"bytes,2,opt,name=func,proto3"`
	xxx_hidden_StartMs  int64                  `protobuf:"varint,3,opt,name=start_ms,json=startMs,proto3"`
	xxx_hidden_EndMs    int64                  `protobuf:"varint,4,opt,name=end_ms,json=endMs,proto3"`
	xxx_hidden_Grouping []string               `protobuf:"bytes,5,rep,name=grouping,proto3"`
	xxx_hidden_By       bool                   `protobuf:"varint,6,opt,name=by,proto3"`
	xxx_hidden_RangeMs  int64                  `protobuf:"varint,7,opt,name=range_ms,json=rangeMs,proto3"`
	unknownFields       protoimpl.UnknownFields
	sizeCache           protoimpl.SizeCache
}

func (x *ReadHints) Reset() {
	*x = ReadHints{}
	mi := &file_types_proto_msgTypes[9]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ReadHints) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReadHints) ProtoMessage() {}

func (x *ReadHints) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[9]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ReadHints) GetStepMs() int64 {
	if x != nil {
		return x.xxx_hidden_StepMs
	}
	return 0
}

func (x *ReadHints) GetFunc() string {
	if x != nil {
		return x.xxx_hidden_Func
	}
	return ""
}

func (x *ReadHints) GetStartMs() int64 {
	if x != nil {
		return x.xxx_hidden_StartMs
	}
	return 0
}

func (x *ReadHints) GetEndMs() int64 {
	if x != nil {
		return x.xxx_hidden_EndMs
	}
	return 0
}

func (x *ReadHints) GetGrouping() []string {
	if x != nil {
		return x.xxx_hidden_Grouping
	}
	return nil
}

func (x *ReadHints) GetBy() bool {
	if x != nil {
		return x.xxx_hidden_By
	}
	return false
}

func (x *ReadHints) GetRangeMs() int64 {
	if x != nil {
		return x.xxx_hidden_RangeMs
	}
	return 0
}

func (x *ReadHints) SetStepMs(v int64) {
	x.xxx_hidden_StepMs = v
}

func (x *ReadHints) SetFunc(v string) {
	x.xxx_hidden_Func = v
}

func (x *ReadHints) SetStartMs(v int64) {
	x.xxx_hidden_StartMs = v
}

func (x *ReadHints) SetEndMs(v int64) {
	x.xxx_hidden_EndMs = v
}

func (x *ReadHints) SetGrouping(v []string) {
	x.xxx_hidden_Grouping = v
}

func (x *ReadHints) SetBy(v bool) {
	x.xxx_hidden_By = v
}

func (x *ReadHints) SetRangeMs(v int64) {
	x.xxx_hidden_RangeMs = v
}

type ReadHints_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	StepMs   int64
	Func     string
	StartMs  int64
	EndMs    int64
	Grouping []string
	By       bool
	RangeMs  int64
}

func (b0 ReadHints_builder) Build() *ReadHints {
	m0 := &ReadHints{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_StepMs = b.StepMs
	x.xxx_hidden_Func = b.Func
	x.xxx_hidden_StartMs = b.StartMs
	x.xxx_hidden_EndMs = b.EndMs
	x.xxx_hidden_Grouping = b.Grouping
	x.xxx_hidden_By = b.By
	x.xxx_hidden_RangeMs = b.RangeMs
	return m0
}

// Chunk represents a TSDB chunk.
// Time range [min, max] is inclusive.
type Chunk struct {
	state                protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_MinTimeMs int64                  `protobuf:"varint,1,opt,name=min_time_ms,json=minTimeMs,proto3"`
	xxx_hidden_MaxTimeMs int64                  `protobuf:"varint,2,opt,name=max_time_ms,json=maxTimeMs,proto3"`
	xxx_hidden_Type      Chunk_Encoding         `protobuf:"varint,3,opt,name=type,proto3,enum=prometheus.Chunk_Encoding"`
	xxx_hidden_Data      []byte                 `protobuf:"bytes,4,opt,name=data,proto3"`
	unknownFields        protoimpl.UnknownFields
	sizeCache            protoimpl.SizeCache
}

func (x *Chunk) Reset() {
	*x = Chunk{}
	mi := &file_types_proto_msgTypes[10]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *Chunk) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Chunk) ProtoMessage() {}

func (x *Chunk) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[10]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *Chunk) GetMinTimeMs() int64 {
	if x != nil {
		return x.xxx_hidden_MinTimeMs
	}
	return 0
}

func (x *Chunk) GetMaxTimeMs() int64 {
	if x != nil {
		return x.xxx_hidden_MaxTimeMs
	}
	return 0
}

func (x *Chunk) GetType() Chunk_Encoding {
	if x != nil {
		return x.xxx_hidden_Type
	}
	return Chunk_UNKNOWN
}

func (x *Chunk) GetData() []byte {
	if x != nil {
		return x.xxx_hidden_Data
	}
	return nil
}

func (x *Chunk) SetMinTimeMs(v int64) {
	x.xxx_hidden_MinTimeMs = v
}

func (x *Chunk) SetMaxTimeMs(v int64) {
	x.xxx_hidden_MaxTimeMs = v
}

func (x *Chunk) SetType(v Chunk_Encoding) {
	x.xxx_hidden_Type = v
}

func (x *Chunk) SetData(v []byte) {
	if v == nil {
		v = []byte{}
	}
	x.xxx_hidden_Data = v
}

type Chunk_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	MinTimeMs int64
	MaxTimeMs int64
	Type      Chunk_Encoding
	Data      []byte
}

func (b0 Chunk_builder) Build() *Chunk {
	m0 := &Chunk{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_MinTimeMs = b.MinTimeMs
	x.xxx_hidden_MaxTimeMs = b.MaxTimeMs
	x.xxx_hidden_Type = b.Type
	x.xxx_hidden_Data = b.Data
	return m0
}

// ChunkedSeries represents single, encoded time series.
type ChunkedSeries struct {
	state             protoimpl.MessageState `protogen:"opaque.v1"`
	xxx_hidden_Labels *[]*Label              `protobuf:"bytes,1,rep,name=labels,proto3"`
	xxx_hidden_Chunks *[]*Chunk              `protobuf:"bytes,2,rep,name=chunks,proto3"`
	unknownFields     protoimpl.UnknownFields
	sizeCache         protoimpl.SizeCache
}

func (x *ChunkedSeries) Reset() {
	*x = ChunkedSeries{}
	mi := &file_types_proto_msgTypes[11]
	ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
	ms.StoreMessageInfo(mi)
}

func (x *ChunkedSeries) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ChunkedSeries) ProtoMessage() {}

func (x *ChunkedSeries) ProtoReflect() protoreflect.Message {
	mi := &file_types_proto_msgTypes[11]
	if x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

func (x *ChunkedSeries) GetLabels() []*Label {
	if x != nil {
		if x.xxx_hidden_Labels != nil {
			return *x.xxx_hidden_Labels
		}
	}
	return nil
}

func (x *ChunkedSeries) GetChunks() []*Chunk {
	if x != nil {
		if x.xxx_hidden_Chunks != nil {
			return *x.xxx_hidden_Chunks
		}
	}
	return nil
}

func (x *ChunkedSeries) SetLabels(v []*Label) {
	x.xxx_hidden_Labels = &v
}

func (x *ChunkedSeries) SetChunks(v []*Chunk) {
	x.xxx_hidden_Chunks = &v
}

type ChunkedSeries_builder struct {
	_ [0]func() // Prevents comparability and use of unkeyed literals for the builder.

	// Labels should be sorted.
	Labels []*Label
	// Chunks will be in start time order and may overlap.
	Chunks []*Chunk
}

func (b0 ChunkedSeries_builder) Build() *ChunkedSeries {
	m0 := &ChunkedSeries{}
	b, x := &b0, m0
	_, _ = b, x
	x.xxx_hidden_Labels = &b.Labels
	x.xxx_hidden_Chunks = &b.Chunks
	return m0
}

var File_types_proto protoreflect.FileDescriptor

var file_types_proto_rawDesc = string([]byte{
	0x0a, 0x0b, 0x74, 0x79, 0x70, 0x65, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x0a, 0x70,
	0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x1a, 0x14, 0x67, 0x6f, 0x67, 0x6f, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x67, 0x6f, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22,
	0x9c, 0x02, 0x0a, 0x0e, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x39, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e,
	0x32, 0x25, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x4d, 0x65,
	0x74, 0x72, 0x69, 0x63, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x4d, 0x65, 0x74,
	0x72, 0x69, 0x63, 0x54, 0x79, 0x70, 0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x2c, 0x0a,
	0x12, 0x6d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x5f, 0x66, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x5f, 0x6e,
	0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x10, 0x6d, 0x65, 0x74, 0x72, 0x69,
	0x63, 0x46, 0x61, 0x6d, 0x69, 0x6c, 0x79, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x68,
	0x65, 0x6c, 0x70, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x68, 0x65, 0x6c, 0x70, 0x12,
	0x12, 0x0a, 0x04, 0x75, 0x6e, 0x69, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x75,
	0x6e, 0x69, 0x74, 0x22, 0x79, 0x0a, 0x0a, 0x4d, 0x65, 0x74, 0x72, 0x69, 0x63, 0x54, 0x79, 0x70,
	0x65, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x0b,
	0x0a, 0x07, 0x43, 0x4f, 0x55, 0x4e, 0x54, 0x45, 0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x47,
	0x41, 0x55, 0x47, 0x45, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x47,
	0x52, 0x41, 0x4d, 0x10, 0x03, 0x12, 0x12, 0x0a, 0x0e, 0x47, 0x41, 0x55, 0x47, 0x45, 0x48, 0x49,
	0x53, 0x54, 0x4f, 0x47, 0x52, 0x41, 0x4d, 0x10, 0x04, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x55, 0x4d,
	0x4d, 0x41, 0x52, 0x59, 0x10, 0x05, 0x12, 0x08, 0x0a, 0x04, 0x49, 0x4e, 0x46, 0x4f, 0x10, 0x06,
	0x12, 0x0c, 0x0a, 0x08, 0x53, 0x54, 0x41, 0x54, 0x45, 0x53, 0x45, 0x54, 0x10, 0x07, 0x22, 0x3c,
	0x0a, 0x06, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1c,
	0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x6f, 0x0a, 0x08,
	0x45, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x12, 0x2f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65,
	0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x04, 0xc8, 0xde, 0x1f,
	0x00, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c,
	0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12,
	0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0xcb, 0x05,
	0x0a, 0x09, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x12, 0x1d, 0x0a, 0x09, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x04, 0x48, 0x00,
	0x52, 0x08, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x49, 0x6e, 0x74, 0x12, 0x21, 0x0a, 0x0b, 0x63, 0x6f,
	0x75, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x01, 0x48,
	0x00, 0x52, 0x0a, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x46, 0x6c, 0x6f, 0x61, 0x74, 0x12, 0x10, 0x0a,
	0x03, 0x73, 0x75, 0x6d, 0x18, 0x03, 0x20, 0x01, 0x28, 0x01, 0x52, 0x03, 0x73, 0x75, 0x6d, 0x12,
	0x16, 0x0a, 0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x11, 0x52,
	0x06, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x25, 0x0a, 0x0e, 0x7a, 0x65, 0x72, 0x6f, 0x5f,
	0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x01, 0x52,
	0x0d, 0x7a, 0x65, 0x72, 0x6f, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x26,
	0x0a, 0x0e, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x69, 0x6e, 0x74,
	0x18, 0x06, 0x20, 0x01, 0x28, 0x04, 0x48, 0x01, 0x52, 0x0c, 0x7a, 0x65, 0x72, 0x6f, 0x43, 0x6f,
	0x75, 0x6e, 0x74, 0x49, 0x6e, 0x74, 0x12, 0x2a, 0x0a, 0x10, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x5f, 0x66, 0x6c, 0x6f, 0x61, 0x74, 0x18, 0x07, 0x20, 0x01, 0x28, 0x01,
	0x48, 0x01, 0x52, 0x0e, 0x7a, 0x65, 0x72, 0x6f, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x46, 0x6c, 0x6f,
	0x61, 0x74, 0x12, 0x43, 0x0a, 0x0e, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73,
	0x70, 0x61, 0x6e, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f,
	0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x42, 0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70,
	0x61, 0x6e, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52, 0x0d, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69,
	0x76, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x6e, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x74, 0x61, 0x73, 0x18, 0x09, 0x20, 0x03, 0x28, 0x12,
	0x52, 0x0e, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x73,
	0x12, 0x27, 0x0a, 0x0f, 0x6e, 0x65, 0x67, 0x61, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x01, 0x52, 0x0e, 0x6e, 0x65, 0x67, 0x61, 0x74,
	0x69, 0x76, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x12, 0x43, 0x0a, 0x0e, 0x70, 0x6f, 0x73,
	0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x73, 0x70, 0x61, 0x6e, 0x73, 0x18, 0x0b, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52,
	0x0d, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x53, 0x70, 0x61, 0x6e, 0x73, 0x12, 0x27,
	0x0a, 0x0f, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x5f, 0x64, 0x65, 0x6c, 0x74, 0x61,
	0x73, 0x18, 0x0c, 0x20, 0x03, 0x28, 0x12, 0x52, 0x0e, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76,
	0x65, 0x44, 0x65, 0x6c, 0x74, 0x61, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x70, 0x6f, 0x73, 0x69, 0x74,
	0x69, 0x76, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x73, 0x18, 0x0d, 0x20, 0x03, 0x28, 0x01,
	0x52, 0x0e, 0x70, 0x6f, 0x73, 0x69, 0x74, 0x69, 0x76, 0x65, 0x43, 0x6f, 0x75, 0x6e, 0x74, 0x73,
	0x12, 0x3e, 0x0a, 0x0a, 0x72, 0x65, 0x73, 0x65, 0x74, 0x5f, 0x68, 0x69, 0x6e, 0x74, 0x18, 0x0e,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x1f, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75,
	0x73, 0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72, 0x61, 0x6d, 0x2e, 0x52, 0x65, 0x73, 0x65,
	0x74, 0x48, 0x69, 0x6e, 0x74, 0x52, 0x09, 0x72, 0x65, 0x73, 0x65, 0x74, 0x48, 0x69, 0x6e, 0x74,
	0x12, 0x1c, 0x0a, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x18, 0x0f, 0x20,
	0x01, 0x28, 0x03, 0x52, 0x09, 0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x22, 0x34,
	0x0a, 0x09, 0x52, 0x65, 0x73, 0x65, 0x74, 0x48, 0x69, 0x6e, 0x74, 0x12, 0x0b, 0x0a, 0x07, 0x55,
	0x4e, 0x4b, 0x4e, 0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x59, 0x45, 0x53, 0x10,
	0x01, 0x12, 0x06, 0x0a, 0x02, 0x4e, 0x4f, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x47, 0x41, 0x55,
	0x47, 0x45, 0x10, 0x03, 0x42, 0x07, 0x0a, 0x05, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x42, 0x0c, 0x0a,
	0x0a, 0x7a, 0x65, 0x72, 0x6f, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x22, 0x3c, 0x0a, 0x0a, 0x42,
	0x75, 0x63, 0x6b, 0x65, 0x74, 0x53, 0x70, 0x61, 0x6e, 0x12, 0x16, 0x0a, 0x06, 0x6f, 0x66, 0x66,
	0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x11, 0x52, 0x06, 0x6f, 0x66, 0x66, 0x73, 0x65,
	0x74, 0x12, 0x16, 0x0a, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x0d, 0x52, 0x06, 0x6c, 0x65, 0x6e, 0x67, 0x74, 0x68, 0x22, 0xe8, 0x01, 0x0a, 0x0a, 0x54, 0x69,
	0x6d, 0x65, 0x53, 0x65, 0x72, 0x69, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65,
	0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x04, 0xc8, 0xde, 0x1f,
	0x00, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x12, 0x32, 0x0a, 0x07, 0x73, 0x61, 0x6d,
	0x70, 0x6c, 0x65, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x12, 0x2e, 0x70, 0x72, 0x6f,
	0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x53, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x42, 0x04,
	0xc8, 0xde, 0x1f, 0x00, 0x52, 0x07, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x73, 0x12, 0x38, 0x0a,
	0x09, 0x65, 0x78, 0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x14, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x45, 0x78,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52, 0x09, 0x65, 0x78,
	0x65, 0x6d, 0x70, 0x6c, 0x61, 0x72, 0x73, 0x12, 0x3b, 0x0a, 0x0a, 0x68, 0x69, 0x73, 0x74, 0x6f,
	0x67, 0x72, 0x61, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x15, 0x2e, 0x70, 0x72,
	0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x48, 0x69, 0x73, 0x74, 0x6f, 0x67, 0x72,
	0x61, 0x6d, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52, 0x0a, 0x68, 0x69, 0x73, 0x74, 0x6f, 0x67,
	0x72, 0x61, 0x6d, 0x73, 0x22, 0x31, 0x0a, 0x05, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x12, 0x12, 0x0a,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x22, 0x39, 0x0a, 0x06, 0x4c, 0x61, 0x62, 0x65, 0x6c,
	0x73, 0x12, 0x2f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65,
	0x6c, 0x73, 0x22, 0x95, 0x01, 0x0a, 0x0c, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x4d, 0x61, 0x74, 0x63,
	0x68, 0x65, 0x72, 0x12, 0x31, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x1d, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2e, 0x4c,
	0x61, 0x62, 0x65, 0x6c, 0x4d, 0x61, 0x74, 0x63, 0x68, 0x65, 0x72, 0x2e, 0x54, 0x79, 0x70, 0x65,
	0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61,
	0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x22, 0x28, 0x0a, 0x04, 0x54, 0x79, 0x70, 0x65, 0x12, 0x06, 0x0a, 0x02, 0x45, 0x51, 0x10, 0x00,
	0x12, 0x07, 0x0a, 0x03, 0x4e, 0x45, 0x51, 0x10, 0x01, 0x12, 0x06, 0x0a, 0x02, 0x52, 0x45, 0x10,
	0x02, 0x12, 0x07, 0x0a, 0x03, 0x4e, 0x52, 0x45, 0x10, 0x03, 0x22, 0xb1, 0x01, 0x0a, 0x09, 0x52,
	0x65, 0x61, 0x64, 0x48, 0x69, 0x6e, 0x74, 0x73, 0x12, 0x17, 0x0a, 0x07, 0x73, 0x74, 0x65, 0x70,
	0x5f, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x06, 0x73, 0x74, 0x65, 0x70, 0x4d,
	0x73, 0x12, 0x12, 0x0a, 0x04, 0x66, 0x75, 0x6e, 0x63, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x66, 0x75, 0x6e, 0x63, 0x12, 0x19, 0x0a, 0x08, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6d,
	0x73, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x73, 0x74, 0x61, 0x72, 0x74, 0x4d, 0x73,
	0x12, 0x15, 0x0a, 0x06, 0x65, 0x6e, 0x64, 0x5f, 0x6d, 0x73, 0x18, 0x04, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x05, 0x65, 0x6e, 0x64, 0x4d, 0x73, 0x12, 0x1a, 0x0a, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x69, 0x6e, 0x67, 0x18, 0x05, 0x20, 0x03, 0x28, 0x09, 0x52, 0x08, 0x67, 0x72, 0x6f, 0x75, 0x70,
	0x69, 0x6e, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x62, 0x79, 0x18, 0x06, 0x20, 0x01, 0x28, 0x08, 0x52,
	0x02, 0x62, 0x79, 0x12, 0x19, 0x0a, 0x08, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x5f, 0x6d, 0x73, 0x18,
	0x07, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x72, 0x61, 0x6e, 0x67, 0x65, 0x4d, 0x73, 0x22, 0xd1,
	0x01, 0x0a, 0x05, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x12, 0x1e, 0x0a, 0x0b, 0x6d, 0x69, 0x6e, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6d, 0x73, 0x18, 0x01, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6d,
	0x69, 0x6e, 0x54, 0x69, 0x6d, 0x65, 0x4d, 0x73, 0x12, 0x1e, 0x0a, 0x0b, 0x6d, 0x61, 0x78, 0x5f,
	0x74, 0x69, 0x6d, 0x65, 0x5f, 0x6d, 0x73, 0x18, 0x02, 0x20, 0x01, 0x28, 0x03, 0x52, 0x09, 0x6d,
	0x61, 0x78, 0x54, 0x69, 0x6d, 0x65, 0x4d, 0x73, 0x12, 0x2e, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68,
	0x65, 0x75, 0x73, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69,
	0x6e, 0x67, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x12, 0x0a, 0x04, 0x64, 0x61, 0x74, 0x61,
	0x18, 0x04, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x04, 0x64, 0x61, 0x74, 0x61, 0x22, 0x44, 0x0a, 0x08,
	0x45, 0x6e, 0x63, 0x6f, 0x64, 0x69, 0x6e, 0x67, 0x12, 0x0b, 0x0a, 0x07, 0x55, 0x4e, 0x4b, 0x4e,
	0x4f, 0x57, 0x4e, 0x10, 0x00, 0x12, 0x07, 0x0a, 0x03, 0x58, 0x4f, 0x52, 0x10, 0x01, 0x12, 0x0d,
	0x0a, 0x09, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x47, 0x52, 0x41, 0x4d, 0x10, 0x02, 0x12, 0x13, 0x0a,
	0x0f, 0x46, 0x4c, 0x4f, 0x41, 0x54, 0x5f, 0x48, 0x49, 0x53, 0x54, 0x4f, 0x47, 0x52, 0x41, 0x4d,
	0x10, 0x03, 0x22, 0x71, 0x0a, 0x0d, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x65, 0x64, 0x53, 0x65, 0x72,
	0x69, 0x65, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x01, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73,
	0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52, 0x06, 0x6c, 0x61,
	0x62, 0x65, 0x6c, 0x73, 0x12, 0x2f, 0x0a, 0x06, 0x63, 0x68, 0x75, 0x6e, 0x6b, 0x73, 0x18, 0x02,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75,
	0x73, 0x2e, 0x43, 0x68, 0x75, 0x6e, 0x6b, 0x42, 0x04, 0xc8, 0xde, 0x1f, 0x00, 0x52, 0x06, 0x63,
	0x68, 0x75, 0x6e, 0x6b, 0x73, 0x42, 0x3b, 0x5a, 0x39, 0x62, 0x75, 0x66, 0x2e, 0x62, 0x75, 0x69,
	0x6c, 0x64, 0x2f, 0x67, 0x65, 0x6e, 0x2f, 0x67, 0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74,
	0x68, 0x65, 0x75, 0x73, 0x2f, 0x70, 0x72, 0x6f, 0x6d, 0x65, 0x74, 0x68, 0x65, 0x75, 0x73, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x63, 0x6f, 0x6c, 0x62, 0x75, 0x66, 0x66, 0x65, 0x72, 0x73, 0x2f,
	0x67, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
})

var file_types_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_types_proto_msgTypes = make([]protoimpl.MessageInfo, 12)
var file_types_proto_goTypes = []any{
	(MetricMetadata_MetricType)(0), // 0: prometheus.MetricMetadata.MetricType
	(Histogram_ResetHint)(0),       // 1: prometheus.Histogram.ResetHint
	(LabelMatcher_Type)(0),         // 2: prometheus.LabelMatcher.Type
	(Chunk_Encoding)(0),            // 3: prometheus.Chunk.Encoding
	(*MetricMetadata)(nil),         // 4: prometheus.MetricMetadata
	(*Sample)(nil),                 // 5: prometheus.Sample
	(*Exemplar)(nil),               // 6: prometheus.Exemplar
	(*Histogram)(nil),              // 7: prometheus.Histogram
	(*BucketSpan)(nil),             // 8: prometheus.BucketSpan
	(*TimeSeries)(nil),             // 9: prometheus.TimeSeries
	(*Label)(nil),                  // 10: prometheus.Label
	(*Labels)(nil),                 // 11: prometheus.Labels
	(*LabelMatcher)(nil),           // 12: prometheus.LabelMatcher
	(*ReadHints)(nil),              // 13: prometheus.ReadHints
	(*Chunk)(nil),                  // 14: prometheus.Chunk
	(*ChunkedSeries)(nil),          // 15: prometheus.ChunkedSeries
}
var file_types_proto_depIdxs = []int32{
	0,  // 0: prometheus.MetricMetadata.type:type_name -> prometheus.MetricMetadata.MetricType
	10, // 1: prometheus.Exemplar.labels:type_name -> prometheus.Label
	8,  // 2: prometheus.Histogram.negative_spans:type_name -> prometheus.BucketSpan
	8,  // 3: prometheus.Histogram.positive_spans:type_name -> prometheus.BucketSpan
	1,  // 4: prometheus.Histogram.reset_hint:type_name -> prometheus.Histogram.ResetHint
	10, // 5: prometheus.TimeSeries.labels:type_name -> prometheus.Label
	5,  // 6: prometheus.TimeSeries.samples:type_name -> prometheus.Sample
	6,  // 7: prometheus.TimeSeries.exemplars:type_name -> prometheus.Exemplar
	7,  // 8: prometheus.TimeSeries.histograms:type_name -> prometheus.Histogram
	10, // 9: prometheus.Labels.labels:type_name -> prometheus.Label
	2,  // 10: prometheus.LabelMatcher.type:type_name -> prometheus.LabelMatcher.Type
	3,  // 11: prometheus.Chunk.type:type_name -> prometheus.Chunk.Encoding
	10, // 12: prometheus.ChunkedSeries.labels:type_name -> prometheus.Label
	14, // 13: prometheus.ChunkedSeries.chunks:type_name -> prometheus.Chunk
	14, // [14:14] is the sub-list for method output_type
	14, // [14:14] is the sub-list for method input_type
	14, // [14:14] is the sub-list for extension type_name
	14, // [14:14] is the sub-list for extension extendee
	0,  // [0:14] is the sub-list for field type_name
}

func init() { file_types_proto_init() }
func file_types_proto_init() {
	if File_types_proto != nil {
		return
	}
	file_types_proto_msgTypes[3].OneofWrappers = []any{
		(*histogram_CountInt)(nil),
		(*histogram_CountFloat)(nil),
		(*histogram_ZeroCountInt)(nil),
		(*histogram_ZeroCountFloat)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: unsafe.Slice(unsafe.StringData(file_types_proto_rawDesc), len(file_types_proto_rawDesc)),
			NumEnums:      4,
			NumMessages:   12,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_types_proto_goTypes,
		DependencyIndexes: file_types_proto_depIdxs,
		EnumInfos:         file_types_proto_enumTypes,
		MessageInfos:      file_types_proto_msgTypes,
	}.Build()
	File_types_proto = out.File
	file_types_proto_goTypes = nil
	file_types_proto_depIdxs = nil
}
