/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the AllowedProjectApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &AllowedProjectApiModel{}

// AllowedProjectApiModel struct for AllowedProjectApiModel
type AllowedProjectApiModel struct {
	// ID of the project.
	Id int32 `json:"id"`
	// Name of the project.
	Name                 string `json:"name"`
	AdditionalProperties map[string]interface{}
}

type _AllowedProjectApiModel AllowedProjectApiModel

// NewAllowedProjectApiModel instantiates a new AllowedProjectApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewAllowedProjectApiModel(id int32, name string) *AllowedProjectApiModel {
	this := AllowedProjectApiModel{}
	this.Id = id
	this.Name = name
	return &this
}

// NewAllowedProjectApiModelWithDefaults instantiates a new AllowedProjectApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewAllowedProjectApiModelWithDefaults() *AllowedProjectApiModel {
	this := AllowedProjectApiModel{}
	return &this
}

// GetId returns the Id field value
func (o *AllowedProjectApiModel) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *AllowedProjectApiModel) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *AllowedProjectApiModel) SetId(v int32) {
	o.Id = v
}

// GetName returns the Name field value
func (o *AllowedProjectApiModel) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *AllowedProjectApiModel) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *AllowedProjectApiModel) SetName(v string) {
	o.Name = v
}

func (o AllowedProjectApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o AllowedProjectApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["name"] = o.Name

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *AllowedProjectApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"name",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varAllowedProjectApiModel := _AllowedProjectApiModel{}

	err = json.Unmarshal(data, &varAllowedProjectApiModel)

	if err != nil {
		return err
	}

	*o = AllowedProjectApiModel(varAllowedProjectApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "id")
		delete(additionalProperties, "name")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableAllowedProjectApiModel struct {
	value *AllowedProjectApiModel
	isSet bool
}

func (v NullableAllowedProjectApiModel) Get() *AllowedProjectApiModel {
	return v.value
}

func (v *NullableAllowedProjectApiModel) Set(val *AllowedProjectApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableAllowedProjectApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableAllowedProjectApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableAllowedProjectApiModel(val *AllowedProjectApiModel) *NullableAllowedProjectApiModel {
	return &NullableAllowedProjectApiModel{value: val, isSet: true}
}

func (v NullableAllowedProjectApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableAllowedProjectApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
