/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
)

// checks if the CloudOptions type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CloudOptions{}

// CloudOptions struct for CloudOptions
type CloudOptions struct {
	// ID of a project where the test belongs.
	ProjectID            *int32 `json:"projectID,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CloudOptions CloudOptions

// NewCloudOptions instantiates a new CloudOptions object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCloudOptions() *CloudOptions {
	this := CloudOptions{}
	return &this
}

// NewCloudOptionsWithDefaults instantiates a new CloudOptions object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCloudOptionsWithDefaults() *CloudOptions {
	this := CloudOptions{}
	return &this
}

// GetProjectID returns the ProjectID field value if set, zero value otherwise.
func (o *CloudOptions) GetProjectID() int32 {
	if o == nil || IsNil(o.ProjectID) {
		var ret int32
		return ret
	}
	return *o.ProjectID
}

// GetProjectIDOk returns a tuple with the ProjectID field value if set, nil otherwise
// and a boolean to check if the value has been set.
func (o *CloudOptions) GetProjectIDOk() (*int32, bool) {
	if o == nil || IsNil(o.ProjectID) {
		return nil, false
	}
	return o.ProjectID, true
}

// HasProjectID returns a boolean if a field has been set.
func (o *CloudOptions) HasProjectID() bool {
	if o != nil && !IsNil(o.ProjectID) {
		return true
	}

	return false
}

// SetProjectID gets a reference to the given int32 and assigns it to the ProjectID field.
func (o *CloudOptions) SetProjectID(v int32) {
	o.ProjectID = &v
}

func (o CloudOptions) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CloudOptions) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	if !IsNil(o.ProjectID) {
		toSerialize["projectID"] = o.ProjectID
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CloudOptions) UnmarshalJSON(data []byte) (err error) {
	varCloudOptions := _CloudOptions{}

	err = json.Unmarshal(data, &varCloudOptions)

	if err != nil {
		return err
	}

	*o = CloudOptions(varCloudOptions)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "projectID")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCloudOptions struct {
	value *CloudOptions
	isSet bool
}

func (v NullableCloudOptions) Get() *CloudOptions {
	return v.value
}

func (v *NullableCloudOptions) Set(val *CloudOptions) {
	v.value = val
	v.isSet = true
}

func (v NullableCloudOptions) IsSet() bool {
	return v.isSet
}

func (v *NullableCloudOptions) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCloudOptions(val *CloudOptions) *NullableCloudOptions {
	return &NullableCloudOptions{value: val, isSet: true}
}

func (v NullableCloudOptions) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCloudOptions) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
