/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the CreateProjectApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CreateProjectApiModel{}

// CreateProjectApiModel struct for CreateProjectApiModel
type CreateProjectApiModel struct {
	// Project name.
	Name                 string `json:"name"`
	AdditionalProperties map[string]interface{}
}

type _CreateProjectApiModel CreateProjectApiModel

// NewCreateProjectApiModel instantiates a new CreateProjectApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateProjectApiModel(name string) *CreateProjectApiModel {
	this := CreateProjectApiModel{}
	this.Name = name
	return &this
}

// NewCreateProjectApiModelWithDefaults instantiates a new CreateProjectApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateProjectApiModelWithDefaults() *CreateProjectApiModel {
	this := CreateProjectApiModel{}
	return &this
}

// GetName returns the Name field value
func (o *CreateProjectApiModel) GetName() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Name
}

// GetNameOk returns a tuple with the Name field value
// and a boolean to check if the value has been set.
func (o *CreateProjectApiModel) GetNameOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Name, true
}

// SetName sets field value
func (o *CreateProjectApiModel) SetName(v string) {
	o.Name = v
}

func (o CreateProjectApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CreateProjectApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["name"] = o.Name

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CreateProjectApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"name",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varCreateProjectApiModel := _CreateProjectApiModel{}

	err = json.Unmarshal(data, &varCreateProjectApiModel)

	if err != nil {
		return err
	}

	*o = CreateProjectApiModel(varCreateProjectApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "name")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCreateProjectApiModel struct {
	value *CreateProjectApiModel
	isSet bool
}

func (v NullableCreateProjectApiModel) Get() *CreateProjectApiModel {
	return v.value
}

func (v *NullableCreateProjectApiModel) Set(val *CreateProjectApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateProjectApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateProjectApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateProjectApiModel(val *CreateProjectApiModel) *NullableCreateProjectApiModel {
	return &NullableCreateProjectApiModel{value: val, isSet: true}
}

func (v NullableCreateProjectApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateProjectApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
