/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
	"time"
)

// checks if the CreateScheduleRequest type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &CreateScheduleRequest{}

// CreateScheduleRequest struct for CreateScheduleRequest
type CreateScheduleRequest struct {
	// The timezone-aware date on which the schedule will start running the test.
	Starts               time.Time                      `json:"starts"`
	RecurrenceRule       NullableScheduleRecurrenceRule `json:"recurrence_rule,omitempty"`
	Cron                 NullableScheduleCron           `json:"cron,omitempty"`
	AdditionalProperties map[string]interface{}
}

type _CreateScheduleRequest CreateScheduleRequest

// NewCreateScheduleRequest instantiates a new CreateScheduleRequest object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewCreateScheduleRequest(starts time.Time) *CreateScheduleRequest {
	this := CreateScheduleRequest{}
	this.Starts = starts
	return &this
}

// NewCreateScheduleRequestWithDefaults instantiates a new CreateScheduleRequest object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewCreateScheduleRequestWithDefaults() *CreateScheduleRequest {
	this := CreateScheduleRequest{}
	return &this
}

// GetStarts returns the Starts field value
func (o *CreateScheduleRequest) GetStarts() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.Starts
}

// GetStartsOk returns a tuple with the Starts field value
// and a boolean to check if the value has been set.
func (o *CreateScheduleRequest) GetStartsOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Starts, true
}

// SetStarts sets field value
func (o *CreateScheduleRequest) SetStarts(v time.Time) {
	o.Starts = v
}

// GetRecurrenceRule returns the RecurrenceRule field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *CreateScheduleRequest) GetRecurrenceRule() ScheduleRecurrenceRule {
	if o == nil || IsNil(o.RecurrenceRule.Get()) {
		var ret ScheduleRecurrenceRule
		return ret
	}
	return *o.RecurrenceRule.Get()
}

// GetRecurrenceRuleOk returns a tuple with the RecurrenceRule field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CreateScheduleRequest) GetRecurrenceRuleOk() (*ScheduleRecurrenceRule, bool) {
	if o == nil {
		return nil, false
	}
	return o.RecurrenceRule.Get(), o.RecurrenceRule.IsSet()
}

// HasRecurrenceRule returns a boolean if a field has been set.
func (o *CreateScheduleRequest) HasRecurrenceRule() bool {
	if o != nil && o.RecurrenceRule.IsSet() {
		return true
	}

	return false
}

// SetRecurrenceRule gets a reference to the given NullableScheduleRecurrenceRule and assigns it to the RecurrenceRule field.
func (o *CreateScheduleRequest) SetRecurrenceRule(v ScheduleRecurrenceRule) {
	o.RecurrenceRule.Set(&v)
}

// SetRecurrenceRuleNil sets the value for RecurrenceRule to be an explicit nil
func (o *CreateScheduleRequest) SetRecurrenceRuleNil() {
	o.RecurrenceRule.Set(nil)
}

// UnsetRecurrenceRule ensures that no value is present for RecurrenceRule, not even an explicit nil
func (o *CreateScheduleRequest) UnsetRecurrenceRule() {
	o.RecurrenceRule.Unset()
}

// GetCron returns the Cron field value if set, zero value otherwise (both if not set or set to explicit null).
func (o *CreateScheduleRequest) GetCron() ScheduleCron {
	if o == nil || IsNil(o.Cron.Get()) {
		var ret ScheduleCron
		return ret
	}
	return *o.Cron.Get()
}

// GetCronOk returns a tuple with the Cron field value if set, nil otherwise
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *CreateScheduleRequest) GetCronOk() (*ScheduleCron, bool) {
	if o == nil {
		return nil, false
	}
	return o.Cron.Get(), o.Cron.IsSet()
}

// HasCron returns a boolean if a field has been set.
func (o *CreateScheduleRequest) HasCron() bool {
	if o != nil && o.Cron.IsSet() {
		return true
	}

	return false
}

// SetCron gets a reference to the given NullableScheduleCron and assigns it to the Cron field.
func (o *CreateScheduleRequest) SetCron(v ScheduleCron) {
	o.Cron.Set(&v)
}

// SetCronNil sets the value for Cron to be an explicit nil
func (o *CreateScheduleRequest) SetCronNil() {
	o.Cron.Set(nil)
}

// UnsetCron ensures that no value is present for Cron, not even an explicit nil
func (o *CreateScheduleRequest) UnsetCron() {
	o.Cron.Unset()
}

func (o CreateScheduleRequest) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o CreateScheduleRequest) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["starts"] = o.Starts
	if o.RecurrenceRule.IsSet() {
		toSerialize["recurrence_rule"] = o.RecurrenceRule.Get()
	}
	if o.Cron.IsSet() {
		toSerialize["cron"] = o.Cron.Get()
	}

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *CreateScheduleRequest) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"starts",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varCreateScheduleRequest := _CreateScheduleRequest{}

	err = json.Unmarshal(data, &varCreateScheduleRequest)

	if err != nil {
		return err
	}

	*o = CreateScheduleRequest(varCreateScheduleRequest)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "starts")
		delete(additionalProperties, "recurrence_rule")
		delete(additionalProperties, "cron")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableCreateScheduleRequest struct {
	value *CreateScheduleRequest
	isSet bool
}

func (v NullableCreateScheduleRequest) Get() *CreateScheduleRequest {
	return v.value
}

func (v *NullableCreateScheduleRequest) Set(val *CreateScheduleRequest) {
	v.value = val
	v.isSet = true
}

func (v NullableCreateScheduleRequest) IsSet() bool {
	return v.isSet
}

func (v *NullableCreateScheduleRequest) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableCreateScheduleRequest(val *CreateScheduleRequest) *NullableCreateScheduleRequest {
	return &NullableCreateScheduleRequest{value: val, isSet: true}
}

func (v NullableCreateScheduleRequest) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableCreateScheduleRequest) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
