/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the NodeApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &NodeApiModel{}

// NodeApiModel Details of a single node in the test run distribution.
type NodeApiModel struct {
	// Size/type of the node (e.g., 'm5.large').
	Size string `json:"size"`
	// Public IP address of the node.
	PublicIp             string `json:"public_ip"`
	AdditionalProperties map[string]interface{}
}

type _NodeApiModel NodeApiModel

// NewNodeApiModel instantiates a new NodeApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewNodeApiModel(size string, publicIp string) *NodeApiModel {
	this := NodeApiModel{}
	this.Size = size
	this.PublicIp = publicIp
	return &this
}

// NewNodeApiModelWithDefaults instantiates a new NodeApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewNodeApiModelWithDefaults() *NodeApiModel {
	this := NodeApiModel{}
	return &this
}

// GetSize returns the Size field value
func (o *NodeApiModel) GetSize() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Size
}

// GetSizeOk returns a tuple with the Size field value
// and a boolean to check if the value has been set.
func (o *NodeApiModel) GetSizeOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Size, true
}

// SetSize sets field value
func (o *NodeApiModel) SetSize(v string) {
	o.Size = v
}

// GetPublicIp returns the PublicIp field value
func (o *NodeApiModel) GetPublicIp() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.PublicIp
}

// GetPublicIpOk returns a tuple with the PublicIp field value
// and a boolean to check if the value has been set.
func (o *NodeApiModel) GetPublicIpOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.PublicIp, true
}

// SetPublicIp sets field value
func (o *NodeApiModel) SetPublicIp(v string) {
	o.PublicIp = v
}

func (o NodeApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o NodeApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["size"] = o.Size
	toSerialize["public_ip"] = o.PublicIp

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *NodeApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"size",
		"public_ip",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varNodeApiModel := _NodeApiModel{}

	err = json.Unmarshal(data, &varNodeApiModel)

	if err != nil {
		return err
	}

	*o = NodeApiModel(varNodeApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "size")
		delete(additionalProperties, "public_ip")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableNodeApiModel struct {
	value *NodeApiModel
	isSet bool
}

func (v NullableNodeApiModel) Get() *NodeApiModel {
	return v.value
}

func (v *NullableNodeApiModel) Set(val *NodeApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableNodeApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableNodeApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableNodeApiModel(val *NodeApiModel) *NullableNodeApiModel {
	return &NullableNodeApiModel{value: val, isSet: true}
}

func (v NullableNodeApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableNodeApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
