/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the PatchTestRunApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &PatchTestRunApiModel{}

// PatchTestRunApiModel struct for PatchTestRunApiModel
type PatchTestRunApiModel struct {
	// User-defined note for the test run.
	Note                 string `json:"note"`
	AdditionalProperties map[string]interface{}
}

type _PatchTestRunApiModel PatchTestRunApiModel

// NewPatchTestRunApiModel instantiates a new PatchTestRunApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewPatchTestRunApiModel(note string) *PatchTestRunApiModel {
	this := PatchTestRunApiModel{}
	this.Note = note
	return &this
}

// NewPatchTestRunApiModelWithDefaults instantiates a new PatchTestRunApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewPatchTestRunApiModelWithDefaults() *PatchTestRunApiModel {
	this := PatchTestRunApiModel{}
	return &this
}

// GetNote returns the Note field value
func (o *PatchTestRunApiModel) GetNote() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Note
}

// GetNoteOk returns a tuple with the Note field value
// and a boolean to check if the value has been set.
func (o *PatchTestRunApiModel) GetNoteOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Note, true
}

// SetNote sets field value
func (o *PatchTestRunApiModel) SetNote(v string) {
	o.Note = v
}

func (o PatchTestRunApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o PatchTestRunApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["note"] = o.Note

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *PatchTestRunApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"note",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varPatchTestRunApiModel := _PatchTestRunApiModel{}

	err = json.Unmarshal(data, &varPatchTestRunApiModel)

	if err != nil {
		return err
	}

	*o = PatchTestRunApiModel(varPatchTestRunApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "note")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullablePatchTestRunApiModel struct {
	value *PatchTestRunApiModel
	isSet bool
}

func (v NullablePatchTestRunApiModel) Get() *PatchTestRunApiModel {
	return v.value
}

func (v *NullablePatchTestRunApiModel) Set(val *PatchTestRunApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullablePatchTestRunApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullablePatchTestRunApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullablePatchTestRunApiModel(val *PatchTestRunApiModel) *NullablePatchTestRunApiModel {
	return &NullablePatchTestRunApiModel{value: val, isSet: true}
}

func (v NullablePatchTestRunApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullablePatchTestRunApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
