/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
	"time"
)

// checks if the ScheduleApiModel type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ScheduleApiModel{}

// ScheduleApiModel struct for ScheduleApiModel
type ScheduleApiModel struct {
	// ID of the schedule.
	Id int32 `json:"id"`
	// ID of the test to run.
	LoadTestId int32 `json:"load_test_id"`
	// The date on which the schedule will start running the test.
	Starts         time.Time                      `json:"starts"`
	RecurrenceRule NullableScheduleRecurrenceRule `json:"recurrence_rule"`
	Cron           NullableScheduleCron           `json:"cron"`
	// Whether the schedule is deactivated. A deactivated schedule will not trigger new test runs, but the schedule recurrence rule and expiration is not affected.
	Deactivated bool `json:"deactivated"`
	// The date of the next scheduled test run. The value is `null` if the schedule is expired and no more occurrences are expected in the future according to the recurrence rule.
	NextRun NullableTime `json:"next_run"`
	// The email of the user who created the schedule if applicable.
	CreatedBy            NullableString `json:"created_by"`
	AdditionalProperties map[string]interface{}
}

type _ScheduleApiModel ScheduleApiModel

// NewScheduleApiModel instantiates a new ScheduleApiModel object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewScheduleApiModel(id int32, loadTestId int32, starts time.Time, recurrenceRule NullableScheduleRecurrenceRule, cron NullableScheduleCron, deactivated bool, nextRun NullableTime, createdBy NullableString) *ScheduleApiModel {
	this := ScheduleApiModel{}
	this.Id = id
	this.LoadTestId = loadTestId
	this.Starts = starts
	this.RecurrenceRule = recurrenceRule
	this.Cron = cron
	this.Deactivated = deactivated
	this.NextRun = nextRun
	this.CreatedBy = createdBy
	return &this
}

// NewScheduleApiModelWithDefaults instantiates a new ScheduleApiModel object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewScheduleApiModelWithDefaults() *ScheduleApiModel {
	this := ScheduleApiModel{}
	return &this
}

// GetId returns the Id field value
func (o *ScheduleApiModel) GetId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.Id
}

// GetIdOk returns a tuple with the Id field value
// and a boolean to check if the value has been set.
func (o *ScheduleApiModel) GetIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Id, true
}

// SetId sets field value
func (o *ScheduleApiModel) SetId(v int32) {
	o.Id = v
}

// GetLoadTestId returns the LoadTestId field value
func (o *ScheduleApiModel) GetLoadTestId() int32 {
	if o == nil {
		var ret int32
		return ret
	}

	return o.LoadTestId
}

// GetLoadTestIdOk returns a tuple with the LoadTestId field value
// and a boolean to check if the value has been set.
func (o *ScheduleApiModel) GetLoadTestIdOk() (*int32, bool) {
	if o == nil {
		return nil, false
	}
	return &o.LoadTestId, true
}

// SetLoadTestId sets field value
func (o *ScheduleApiModel) SetLoadTestId(v int32) {
	o.LoadTestId = v
}

// GetStarts returns the Starts field value
func (o *ScheduleApiModel) GetStarts() time.Time {
	if o == nil {
		var ret time.Time
		return ret
	}

	return o.Starts
}

// GetStartsOk returns a tuple with the Starts field value
// and a boolean to check if the value has been set.
func (o *ScheduleApiModel) GetStartsOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Starts, true
}

// SetStarts sets field value
func (o *ScheduleApiModel) SetStarts(v time.Time) {
	o.Starts = v
}

// GetRecurrenceRule returns the RecurrenceRule field value
// If the value is explicit nil, the zero value for ScheduleRecurrenceRule will be returned
func (o *ScheduleApiModel) GetRecurrenceRule() ScheduleRecurrenceRule {
	if o == nil || o.RecurrenceRule.Get() == nil {
		var ret ScheduleRecurrenceRule
		return ret
	}

	return *o.RecurrenceRule.Get()
}

// GetRecurrenceRuleOk returns a tuple with the RecurrenceRule field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ScheduleApiModel) GetRecurrenceRuleOk() (*ScheduleRecurrenceRule, bool) {
	if o == nil {
		return nil, false
	}
	return o.RecurrenceRule.Get(), o.RecurrenceRule.IsSet()
}

// SetRecurrenceRule sets field value
func (o *ScheduleApiModel) SetRecurrenceRule(v ScheduleRecurrenceRule) {
	o.RecurrenceRule.Set(&v)
}

// GetCron returns the Cron field value
// If the value is explicit nil, the zero value for ScheduleCron will be returned
func (o *ScheduleApiModel) GetCron() ScheduleCron {
	if o == nil || o.Cron.Get() == nil {
		var ret ScheduleCron
		return ret
	}

	return *o.Cron.Get()
}

// GetCronOk returns a tuple with the Cron field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ScheduleApiModel) GetCronOk() (*ScheduleCron, bool) {
	if o == nil {
		return nil, false
	}
	return o.Cron.Get(), o.Cron.IsSet()
}

// SetCron sets field value
func (o *ScheduleApiModel) SetCron(v ScheduleCron) {
	o.Cron.Set(&v)
}

// GetDeactivated returns the Deactivated field value
func (o *ScheduleApiModel) GetDeactivated() bool {
	if o == nil {
		var ret bool
		return ret
	}

	return o.Deactivated
}

// GetDeactivatedOk returns a tuple with the Deactivated field value
// and a boolean to check if the value has been set.
func (o *ScheduleApiModel) GetDeactivatedOk() (*bool, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Deactivated, true
}

// SetDeactivated sets field value
func (o *ScheduleApiModel) SetDeactivated(v bool) {
	o.Deactivated = v
}

// GetNextRun returns the NextRun field value
// If the value is explicit nil, the zero value for time.Time will be returned
func (o *ScheduleApiModel) GetNextRun() time.Time {
	if o == nil || o.NextRun.Get() == nil {
		var ret time.Time
		return ret
	}

	return *o.NextRun.Get()
}

// GetNextRunOk returns a tuple with the NextRun field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ScheduleApiModel) GetNextRunOk() (*time.Time, bool) {
	if o == nil {
		return nil, false
	}
	return o.NextRun.Get(), o.NextRun.IsSet()
}

// SetNextRun sets field value
func (o *ScheduleApiModel) SetNextRun(v time.Time) {
	o.NextRun.Set(&v)
}

// GetCreatedBy returns the CreatedBy field value
// If the value is explicit nil, the zero value for string will be returned
func (o *ScheduleApiModel) GetCreatedBy() string {
	if o == nil || o.CreatedBy.Get() == nil {
		var ret string
		return ret
	}

	return *o.CreatedBy.Get()
}

// GetCreatedByOk returns a tuple with the CreatedBy field value
// and a boolean to check if the value has been set.
// NOTE: If the value is an explicit nil, `nil, true` will be returned
func (o *ScheduleApiModel) GetCreatedByOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return o.CreatedBy.Get(), o.CreatedBy.IsSet()
}

// SetCreatedBy sets field value
func (o *ScheduleApiModel) SetCreatedBy(v string) {
	o.CreatedBy.Set(&v)
}

func (o ScheduleApiModel) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ScheduleApiModel) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["id"] = o.Id
	toSerialize["load_test_id"] = o.LoadTestId
	toSerialize["starts"] = o.Starts
	toSerialize["recurrence_rule"] = o.RecurrenceRule.Get()
	toSerialize["cron"] = o.Cron.Get()
	toSerialize["deactivated"] = o.Deactivated
	toSerialize["next_run"] = o.NextRun.Get()
	toSerialize["created_by"] = o.CreatedBy.Get()

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ScheduleApiModel) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"id",
		"load_test_id",
		"starts",
		"recurrence_rule",
		"cron",
		"deactivated",
		"next_run",
		"created_by",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varScheduleApiModel := _ScheduleApiModel{}

	err = json.Unmarshal(data, &varScheduleApiModel)

	if err != nil {
		return err
	}

	*o = ScheduleApiModel(varScheduleApiModel)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "id")
		delete(additionalProperties, "load_test_id")
		delete(additionalProperties, "starts")
		delete(additionalProperties, "recurrence_rule")
		delete(additionalProperties, "cron")
		delete(additionalProperties, "deactivated")
		delete(additionalProperties, "next_run")
		delete(additionalProperties, "created_by")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableScheduleApiModel struct {
	value *ScheduleApiModel
	isSet bool
}

func (v NullableScheduleApiModel) Get() *ScheduleApiModel {
	return v.value
}

func (v *NullableScheduleApiModel) Set(val *ScheduleApiModel) {
	v.value = val
	v.isSet = true
}

func (v NullableScheduleApiModel) IsSet() bool {
	return v.isSet
}

func (v *NullableScheduleApiModel) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableScheduleApiModel(val *ScheduleApiModel) *NullableScheduleApiModel {
	return &NullableScheduleApiModel{value: val, isSet: true}
}

func (v NullableScheduleApiModel) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableScheduleApiModel) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
