/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// checks if the ScheduleCron type satisfies the MappedNullable interface at compile time
var _ MappedNullable = &ScheduleCron{}

// ScheduleCron struct for ScheduleCron
type ScheduleCron struct {
	// A cron expression with exactly 5 entries, or an alias. The allowed aliases are: @yearly, @annually, @monthly, @weekly, @daily, @hourly.
	Schedule string `json:"schedule"`
	// The timezone of the cron expression.
	TimeZone             string `json:"time_zone"`
	AdditionalProperties map[string]interface{}
}

type _ScheduleCron ScheduleCron

// NewScheduleCron instantiates a new ScheduleCron object
// This constructor will assign default values to properties that have it defined,
// and makes sure properties required by API are set, but the set of arguments
// will change when the set of required properties is changed
func NewScheduleCron(schedule string, timeZone string) *ScheduleCron {
	this := ScheduleCron{}
	this.Schedule = schedule
	this.TimeZone = timeZone
	return &this
}

// NewScheduleCronWithDefaults instantiates a new ScheduleCron object
// This constructor will only assign default values to properties that have it defined,
// but it doesn't guarantee that properties required by API are set
func NewScheduleCronWithDefaults() *ScheduleCron {
	this := ScheduleCron{}
	return &this
}

// GetSchedule returns the Schedule field value
func (o *ScheduleCron) GetSchedule() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.Schedule
}

// GetScheduleOk returns a tuple with the Schedule field value
// and a boolean to check if the value has been set.
func (o *ScheduleCron) GetScheduleOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.Schedule, true
}

// SetSchedule sets field value
func (o *ScheduleCron) SetSchedule(v string) {
	o.Schedule = v
}

// GetTimeZone returns the TimeZone field value
func (o *ScheduleCron) GetTimeZone() string {
	if o == nil {
		var ret string
		return ret
	}

	return o.TimeZone
}

// GetTimeZoneOk returns a tuple with the TimeZone field value
// and a boolean to check if the value has been set.
func (o *ScheduleCron) GetTimeZoneOk() (*string, bool) {
	if o == nil {
		return nil, false
	}
	return &o.TimeZone, true
}

// SetTimeZone sets field value
func (o *ScheduleCron) SetTimeZone(v string) {
	o.TimeZone = v
}

func (o ScheduleCron) MarshalJSON() ([]byte, error) {
	toSerialize, err := o.ToMap()
	if err != nil {
		return []byte{}, err
	}
	return json.Marshal(toSerialize)
}

func (o ScheduleCron) ToMap() (map[string]interface{}, error) {
	toSerialize := map[string]interface{}{}
	toSerialize["schedule"] = o.Schedule
	toSerialize["time_zone"] = o.TimeZone

	for key, value := range o.AdditionalProperties {
		toSerialize[key] = value
	}

	return toSerialize, nil
}

func (o *ScheduleCron) UnmarshalJSON(data []byte) (err error) {
	// This validates that all required properties are included in the JSON object
	// by unmarshalling the object into a generic map with string keys and checking
	// that every required field exists as a key in the generic map.
	requiredProperties := []string{
		"schedule",
		"time_zone",
	}

	allProperties := make(map[string]interface{})

	err = json.Unmarshal(data, &allProperties)

	if err != nil {
		return err
	}

	for _, requiredProperty := range requiredProperties {
		if _, exists := allProperties[requiredProperty]; !exists {
			return fmt.Errorf("no value given for required property %v", requiredProperty)
		}
	}

	varScheduleCron := _ScheduleCron{}

	err = json.Unmarshal(data, &varScheduleCron)

	if err != nil {
		return err
	}

	*o = ScheduleCron(varScheduleCron)

	additionalProperties := make(map[string]interface{})

	if err = json.Unmarshal(data, &additionalProperties); err == nil {
		delete(additionalProperties, "schedule")
		delete(additionalProperties, "time_zone")
		o.AdditionalProperties = additionalProperties
	}

	return err
}

type NullableScheduleCron struct {
	value *ScheduleCron
	isSet bool
}

func (v NullableScheduleCron) Get() *ScheduleCron {
	return v.value
}

func (v *NullableScheduleCron) Set(val *ScheduleCron) {
	v.value = val
	v.isSet = true
}

func (v NullableScheduleCron) IsSet() bool {
	return v.isSet
}

func (v *NullableScheduleCron) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableScheduleCron(val *ScheduleCron) *NullableScheduleCron {
	return &NullableScheduleCron{value: val, isSet: true}
}

func (v NullableScheduleCron) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableScheduleCron) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
