/*
Grafana Cloud k6

HTTP API for interacting with Grafana Cloud k6.

API version: 1.7.1
Contact: info@grafana.com
*/

// Code generated by OpenAPI Generator (https://openapi-generator.tech); DO NOT EDIT.

package k6

import (
	"encoding/json"
	"fmt"
)

// Weekday the model 'Weekday'
type Weekday string

// List of Weekday
const (
	MO Weekday = "MO"
	TU Weekday = "TU"
	WE Weekday = "WE"
	TH Weekday = "TH"
	FR Weekday = "FR"
	SA Weekday = "SA"
	SU Weekday = "SU"
)

// All allowed values of Weekday enum
var AllowedWeekdayEnumValues = []Weekday{
	"MO",
	"TU",
	"WE",
	"TH",
	"FR",
	"SA",
	"SU",
}

func (v *Weekday) UnmarshalJSON(src []byte) error {
	var value string
	err := json.Unmarshal(src, &value)
	if err != nil {
		return err
	}
	enumTypeValue := Weekday(value)
	for _, existing := range AllowedWeekdayEnumValues {
		if existing == enumTypeValue {
			*v = enumTypeValue
			return nil
		}
	}

	return fmt.Errorf("%+v is not a valid Weekday", value)
}

// NewWeekdayFromValue returns a pointer to a valid Weekday
// for the value passed as argument, or an error if the value passed is not allowed by the enum
func NewWeekdayFromValue(v string) (*Weekday, error) {
	ev := Weekday(v)
	if ev.IsValid() {
		return &ev, nil
	} else {
		return nil, fmt.Errorf("invalid value '%v' for Weekday: valid values are %v", v, AllowedWeekdayEnumValues)
	}
}

// IsValid return true if the value is valid for the enum, false otherwise
func (v Weekday) IsValid() bool {
	for _, existing := range AllowedWeekdayEnumValues {
		if existing == v {
			return true
		}
	}
	return false
}

// Ptr returns reference to Weekday value
func (v Weekday) Ptr() *Weekday {
	return &v
}

type NullableWeekday struct {
	value *Weekday
	isSet bool
}

func (v NullableWeekday) Get() *Weekday {
	return v.value
}

func (v *NullableWeekday) Set(val *Weekday) {
	v.value = val
	v.isSet = true
}

func (v NullableWeekday) IsSet() bool {
	return v.isSet
}

func (v *NullableWeekday) Unset() {
	v.value = nil
	v.isSet = false
}

func NewNullableWeekday(val *Weekday) *NullableWeekday {
	return &NullableWeekday{value: val, isSet: true}
}

func (v NullableWeekday) MarshalJSON() ([]byte, error) {
	return json.Marshal(v.value)
}

func (v *NullableWeekday) UnmarshalJSON(src []byte) error {
	v.isSet = true
	return json.Unmarshal(src, &v.value)
}
