/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by mockery; DO NOT EDIT.
// github.com/vektra/mockery
// template: testify

package testing

import (
	mock "github.com/stretchr/testify/mock"
	"k8s.io/api/core/v1"
	"k8s.io/apimachinery/pkg/types"
	types0 "k8s.io/kubernetes/pkg/kubelet/types"
)

// NewMockManager creates a new instance of MockManager. It also registers a testing interface on the mock and a cleanup function to assert the mocks expectations.
// The first argument is typically a *testing.T value.
func NewMockManager(t interface {
	mock.TestingT
	Cleanup(func())
}) *MockManager {
	mock := &MockManager{}
	mock.Mock.Test(t)

	t.Cleanup(func() { mock.AssertExpectations(t) })

	return mock
}

// MockManager is an autogenerated mock type for the Manager type
type MockManager struct {
	mock.Mock
}

type MockManager_Expecter struct {
	mock *mock.Mock
}

func (_m *MockManager) EXPECT() *MockManager_Expecter {
	return &MockManager_Expecter{mock: &_m.Mock}
}

// AddPod provides a mock function for the type MockManager
func (_mock *MockManager) AddPod(pod *v1.Pod) {
	_mock.Called(pod)
	return
}

// MockManager_AddPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'AddPod'
type MockManager_AddPod_Call struct {
	*mock.Call
}

// AddPod is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockManager_Expecter) AddPod(pod interface{}) *MockManager_AddPod_Call {
	return &MockManager_AddPod_Call{Call: _e.mock.On("AddPod", pod)}
}

func (_c *MockManager_AddPod_Call) Run(run func(pod *v1.Pod)) *MockManager_AddPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_AddPod_Call) Return() *MockManager_AddPod_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockManager_AddPod_Call) RunAndReturn(run func(pod *v1.Pod)) *MockManager_AddPod_Call {
	_c.Run(run)
	return _c
}

// GetMirrorPodByPod provides a mock function for the type MockManager
func (_mock *MockManager) GetMirrorPodByPod(pod *v1.Pod) (*v1.Pod, bool) {
	ret := _mock.Called(pod)

	if len(ret) == 0 {
		panic("no return value specified for GetMirrorPodByPod")
	}

	var r0 *v1.Pod
	var r1 bool
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) (*v1.Pod, bool)); ok {
		return returnFunc(pod)
	}
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) *v1.Pod); ok {
		r0 = returnFunc(pod)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(*v1.Pod) bool); ok {
		r1 = returnFunc(pod)
	} else {
		r1 = ret.Get(1).(bool)
	}
	return r0, r1
}

// MockManager_GetMirrorPodByPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetMirrorPodByPod'
type MockManager_GetMirrorPodByPod_Call struct {
	*mock.Call
}

// GetMirrorPodByPod is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockManager_Expecter) GetMirrorPodByPod(pod interface{}) *MockManager_GetMirrorPodByPod_Call {
	return &MockManager_GetMirrorPodByPod_Call{Call: _e.mock.On("GetMirrorPodByPod", pod)}
}

func (_c *MockManager_GetMirrorPodByPod_Call) Run(run func(pod *v1.Pod)) *MockManager_GetMirrorPodByPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_GetMirrorPodByPod_Call) Return(pod1 *v1.Pod, b bool) *MockManager_GetMirrorPodByPod_Call {
	_c.Call.Return(pod1, b)
	return _c
}

func (_c *MockManager_GetMirrorPodByPod_Call) RunAndReturn(run func(pod *v1.Pod) (*v1.Pod, bool)) *MockManager_GetMirrorPodByPod_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodAndMirrorPod provides a mock function for the type MockManager
func (_mock *MockManager) GetPodAndMirrorPod(pod *v1.Pod) (*v1.Pod, *v1.Pod, bool) {
	ret := _mock.Called(pod)

	if len(ret) == 0 {
		panic("no return value specified for GetPodAndMirrorPod")
	}

	var r0 *v1.Pod
	var r1 *v1.Pod
	var r2 bool
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) (*v1.Pod, *v1.Pod, bool)); ok {
		return returnFunc(pod)
	}
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) *v1.Pod); ok {
		r0 = returnFunc(pod)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(*v1.Pod) *v1.Pod); ok {
		r1 = returnFunc(pod)
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(*v1.Pod)
		}
	}
	if returnFunc, ok := ret.Get(2).(func(*v1.Pod) bool); ok {
		r2 = returnFunc(pod)
	} else {
		r2 = ret.Get(2).(bool)
	}
	return r0, r1, r2
}

// MockManager_GetPodAndMirrorPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodAndMirrorPod'
type MockManager_GetPodAndMirrorPod_Call struct {
	*mock.Call
}

// GetPodAndMirrorPod is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockManager_Expecter) GetPodAndMirrorPod(pod interface{}) *MockManager_GetPodAndMirrorPod_Call {
	return &MockManager_GetPodAndMirrorPod_Call{Call: _e.mock.On("GetPodAndMirrorPod", pod)}
}

func (_c *MockManager_GetPodAndMirrorPod_Call) Run(run func(pod *v1.Pod)) *MockManager_GetPodAndMirrorPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_GetPodAndMirrorPod_Call) Return(pod1 *v1.Pod, mirrorPod *v1.Pod, wasMirror bool) *MockManager_GetPodAndMirrorPod_Call {
	_c.Call.Return(pod1, mirrorPod, wasMirror)
	return _c
}

func (_c *MockManager_GetPodAndMirrorPod_Call) RunAndReturn(run func(pod *v1.Pod) (*v1.Pod, *v1.Pod, bool)) *MockManager_GetPodAndMirrorPod_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodByFullName provides a mock function for the type MockManager
func (_mock *MockManager) GetPodByFullName(podFullName string) (*v1.Pod, bool) {
	ret := _mock.Called(podFullName)

	if len(ret) == 0 {
		panic("no return value specified for GetPodByFullName")
	}

	var r0 *v1.Pod
	var r1 bool
	if returnFunc, ok := ret.Get(0).(func(string) (*v1.Pod, bool)); ok {
		return returnFunc(podFullName)
	}
	if returnFunc, ok := ret.Get(0).(func(string) *v1.Pod); ok {
		r0 = returnFunc(podFullName)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(string) bool); ok {
		r1 = returnFunc(podFullName)
	} else {
		r1 = ret.Get(1).(bool)
	}
	return r0, r1
}

// MockManager_GetPodByFullName_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodByFullName'
type MockManager_GetPodByFullName_Call struct {
	*mock.Call
}

// GetPodByFullName is a helper method to define mock.On call
//   - podFullName string
func (_e *MockManager_Expecter) GetPodByFullName(podFullName interface{}) *MockManager_GetPodByFullName_Call {
	return &MockManager_GetPodByFullName_Call{Call: _e.mock.On("GetPodByFullName", podFullName)}
}

func (_c *MockManager_GetPodByFullName_Call) Run(run func(podFullName string)) *MockManager_GetPodByFullName_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_GetPodByFullName_Call) Return(pod *v1.Pod, b bool) *MockManager_GetPodByFullName_Call {
	_c.Call.Return(pod, b)
	return _c
}

func (_c *MockManager_GetPodByFullName_Call) RunAndReturn(run func(podFullName string) (*v1.Pod, bool)) *MockManager_GetPodByFullName_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodByMirrorPod provides a mock function for the type MockManager
func (_mock *MockManager) GetPodByMirrorPod(pod *v1.Pod) (*v1.Pod, bool) {
	ret := _mock.Called(pod)

	if len(ret) == 0 {
		panic("no return value specified for GetPodByMirrorPod")
	}

	var r0 *v1.Pod
	var r1 bool
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) (*v1.Pod, bool)); ok {
		return returnFunc(pod)
	}
	if returnFunc, ok := ret.Get(0).(func(*v1.Pod) *v1.Pod); ok {
		r0 = returnFunc(pod)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(*v1.Pod) bool); ok {
		r1 = returnFunc(pod)
	} else {
		r1 = ret.Get(1).(bool)
	}
	return r0, r1
}

// MockManager_GetPodByMirrorPod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodByMirrorPod'
type MockManager_GetPodByMirrorPod_Call struct {
	*mock.Call
}

// GetPodByMirrorPod is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockManager_Expecter) GetPodByMirrorPod(pod interface{}) *MockManager_GetPodByMirrorPod_Call {
	return &MockManager_GetPodByMirrorPod_Call{Call: _e.mock.On("GetPodByMirrorPod", pod)}
}

func (_c *MockManager_GetPodByMirrorPod_Call) Run(run func(pod *v1.Pod)) *MockManager_GetPodByMirrorPod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_GetPodByMirrorPod_Call) Return(pod1 *v1.Pod, b bool) *MockManager_GetPodByMirrorPod_Call {
	_c.Call.Return(pod1, b)
	return _c
}

func (_c *MockManager_GetPodByMirrorPod_Call) RunAndReturn(run func(pod *v1.Pod) (*v1.Pod, bool)) *MockManager_GetPodByMirrorPod_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodByName provides a mock function for the type MockManager
func (_mock *MockManager) GetPodByName(namespace string, name string) (*v1.Pod, bool) {
	ret := _mock.Called(namespace, name)

	if len(ret) == 0 {
		panic("no return value specified for GetPodByName")
	}

	var r0 *v1.Pod
	var r1 bool
	if returnFunc, ok := ret.Get(0).(func(string, string) (*v1.Pod, bool)); ok {
		return returnFunc(namespace, name)
	}
	if returnFunc, ok := ret.Get(0).(func(string, string) *v1.Pod); ok {
		r0 = returnFunc(namespace, name)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(string, string) bool); ok {
		r1 = returnFunc(namespace, name)
	} else {
		r1 = ret.Get(1).(bool)
	}
	return r0, r1
}

// MockManager_GetPodByName_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodByName'
type MockManager_GetPodByName_Call struct {
	*mock.Call
}

// GetPodByName is a helper method to define mock.On call
//   - namespace string
//   - name string
func (_e *MockManager_Expecter) GetPodByName(namespace interface{}, name interface{}) *MockManager_GetPodByName_Call {
	return &MockManager_GetPodByName_Call{Call: _e.mock.On("GetPodByName", namespace, name)}
}

func (_c *MockManager_GetPodByName_Call) Run(run func(namespace string, name string)) *MockManager_GetPodByName_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 string
		if args[0] != nil {
			arg0 = args[0].(string)
		}
		var arg1 string
		if args[1] != nil {
			arg1 = args[1].(string)
		}
		run(
			arg0,
			arg1,
		)
	})
	return _c
}

func (_c *MockManager_GetPodByName_Call) Return(pod *v1.Pod, b bool) *MockManager_GetPodByName_Call {
	_c.Call.Return(pod, b)
	return _c
}

func (_c *MockManager_GetPodByName_Call) RunAndReturn(run func(namespace string, name string) (*v1.Pod, bool)) *MockManager_GetPodByName_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodByUID provides a mock function for the type MockManager
func (_mock *MockManager) GetPodByUID(uID types.UID) (*v1.Pod, bool) {
	ret := _mock.Called(uID)

	if len(ret) == 0 {
		panic("no return value specified for GetPodByUID")
	}

	var r0 *v1.Pod
	var r1 bool
	if returnFunc, ok := ret.Get(0).(func(types.UID) (*v1.Pod, bool)); ok {
		return returnFunc(uID)
	}
	if returnFunc, ok := ret.Get(0).(func(types.UID) *v1.Pod); ok {
		r0 = returnFunc(uID)
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(*v1.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func(types.UID) bool); ok {
		r1 = returnFunc(uID)
	} else {
		r1 = ret.Get(1).(bool)
	}
	return r0, r1
}

// MockManager_GetPodByUID_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodByUID'
type MockManager_GetPodByUID_Call struct {
	*mock.Call
}

// GetPodByUID is a helper method to define mock.On call
//   - uID types.UID
func (_e *MockManager_Expecter) GetPodByUID(uID interface{}) *MockManager_GetPodByUID_Call {
	return &MockManager_GetPodByUID_Call{Call: _e.mock.On("GetPodByUID", uID)}
}

func (_c *MockManager_GetPodByUID_Call) Run(run func(uID types.UID)) *MockManager_GetPodByUID_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 types.UID
		if args[0] != nil {
			arg0 = args[0].(types.UID)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_GetPodByUID_Call) Return(pod *v1.Pod, b bool) *MockManager_GetPodByUID_Call {
	_c.Call.Return(pod, b)
	return _c
}

func (_c *MockManager_GetPodByUID_Call) RunAndReturn(run func(uID types.UID) (*v1.Pod, bool)) *MockManager_GetPodByUID_Call {
	_c.Call.Return(run)
	return _c
}

// GetPods provides a mock function for the type MockManager
func (_mock *MockManager) GetPods() []*v1.Pod {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPods")
	}

	var r0 []*v1.Pod
	if returnFunc, ok := ret.Get(0).(func() []*v1.Pod); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.Pod)
		}
	}
	return r0
}

// MockManager_GetPods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPods'
type MockManager_GetPods_Call struct {
	*mock.Call
}

// GetPods is a helper method to define mock.On call
func (_e *MockManager_Expecter) GetPods() *MockManager_GetPods_Call {
	return &MockManager_GetPods_Call{Call: _e.mock.On("GetPods")}
}

func (_c *MockManager_GetPods_Call) Run(run func()) *MockManager_GetPods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockManager_GetPods_Call) Return(pods []*v1.Pod) *MockManager_GetPods_Call {
	_c.Call.Return(pods)
	return _c
}

func (_c *MockManager_GetPods_Call) RunAndReturn(run func() []*v1.Pod) *MockManager_GetPods_Call {
	_c.Call.Return(run)
	return _c
}

// GetPodsAndMirrorPods provides a mock function for the type MockManager
func (_mock *MockManager) GetPodsAndMirrorPods() ([]*v1.Pod, []*v1.Pod, []string) {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetPodsAndMirrorPods")
	}

	var r0 []*v1.Pod
	var r1 []*v1.Pod
	var r2 []string
	if returnFunc, ok := ret.Get(0).(func() ([]*v1.Pod, []*v1.Pod, []string)); ok {
		return returnFunc()
	}
	if returnFunc, ok := ret.Get(0).(func() []*v1.Pod); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).([]*v1.Pod)
		}
	}
	if returnFunc, ok := ret.Get(1).(func() []*v1.Pod); ok {
		r1 = returnFunc()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).([]*v1.Pod)
		}
	}
	if returnFunc, ok := ret.Get(2).(func() []string); ok {
		r2 = returnFunc()
	} else {
		if ret.Get(2) != nil {
			r2 = ret.Get(2).([]string)
		}
	}
	return r0, r1, r2
}

// MockManager_GetPodsAndMirrorPods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetPodsAndMirrorPods'
type MockManager_GetPodsAndMirrorPods_Call struct {
	*mock.Call
}

// GetPodsAndMirrorPods is a helper method to define mock.On call
func (_e *MockManager_Expecter) GetPodsAndMirrorPods() *MockManager_GetPodsAndMirrorPods_Call {
	return &MockManager_GetPodsAndMirrorPods_Call{Call: _e.mock.On("GetPodsAndMirrorPods")}
}

func (_c *MockManager_GetPodsAndMirrorPods_Call) Run(run func()) *MockManager_GetPodsAndMirrorPods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockManager_GetPodsAndMirrorPods_Call) Return(allPods []*v1.Pod, allMirrorPods []*v1.Pod, orphanedMirrorPodFullnames []string) *MockManager_GetPodsAndMirrorPods_Call {
	_c.Call.Return(allPods, allMirrorPods, orphanedMirrorPodFullnames)
	return _c
}

func (_c *MockManager_GetPodsAndMirrorPods_Call) RunAndReturn(run func() ([]*v1.Pod, []*v1.Pod, []string)) *MockManager_GetPodsAndMirrorPods_Call {
	_c.Call.Return(run)
	return _c
}

// GetStaticPodToMirrorPodMap provides a mock function for the type MockManager
func (_mock *MockManager) GetStaticPodToMirrorPodMap() map[*v1.Pod]*v1.Pod {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetStaticPodToMirrorPodMap")
	}

	var r0 map[*v1.Pod]*v1.Pod
	if returnFunc, ok := ret.Get(0).(func() map[*v1.Pod]*v1.Pod); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[*v1.Pod]*v1.Pod)
		}
	}
	return r0
}

// MockManager_GetStaticPodToMirrorPodMap_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetStaticPodToMirrorPodMap'
type MockManager_GetStaticPodToMirrorPodMap_Call struct {
	*mock.Call
}

// GetStaticPodToMirrorPodMap is a helper method to define mock.On call
func (_e *MockManager_Expecter) GetStaticPodToMirrorPodMap() *MockManager_GetStaticPodToMirrorPodMap_Call {
	return &MockManager_GetStaticPodToMirrorPodMap_Call{Call: _e.mock.On("GetStaticPodToMirrorPodMap")}
}

func (_c *MockManager_GetStaticPodToMirrorPodMap_Call) Run(run func()) *MockManager_GetStaticPodToMirrorPodMap_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockManager_GetStaticPodToMirrorPodMap_Call) Return(podToPod map[*v1.Pod]*v1.Pod) *MockManager_GetStaticPodToMirrorPodMap_Call {
	_c.Call.Return(podToPod)
	return _c
}

func (_c *MockManager_GetStaticPodToMirrorPodMap_Call) RunAndReturn(run func() map[*v1.Pod]*v1.Pod) *MockManager_GetStaticPodToMirrorPodMap_Call {
	_c.Call.Return(run)
	return _c
}

// GetUIDTranslations provides a mock function for the type MockManager
func (_mock *MockManager) GetUIDTranslations() (map[types0.ResolvedPodUID]types0.MirrorPodUID, map[types0.MirrorPodUID]types0.ResolvedPodUID) {
	ret := _mock.Called()

	if len(ret) == 0 {
		panic("no return value specified for GetUIDTranslations")
	}

	var r0 map[types0.ResolvedPodUID]types0.MirrorPodUID
	var r1 map[types0.MirrorPodUID]types0.ResolvedPodUID
	if returnFunc, ok := ret.Get(0).(func() (map[types0.ResolvedPodUID]types0.MirrorPodUID, map[types0.MirrorPodUID]types0.ResolvedPodUID)); ok {
		return returnFunc()
	}
	if returnFunc, ok := ret.Get(0).(func() map[types0.ResolvedPodUID]types0.MirrorPodUID); ok {
		r0 = returnFunc()
	} else {
		if ret.Get(0) != nil {
			r0 = ret.Get(0).(map[types0.ResolvedPodUID]types0.MirrorPodUID)
		}
	}
	if returnFunc, ok := ret.Get(1).(func() map[types0.MirrorPodUID]types0.ResolvedPodUID); ok {
		r1 = returnFunc()
	} else {
		if ret.Get(1) != nil {
			r1 = ret.Get(1).(map[types0.MirrorPodUID]types0.ResolvedPodUID)
		}
	}
	return r0, r1
}

// MockManager_GetUIDTranslations_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'GetUIDTranslations'
type MockManager_GetUIDTranslations_Call struct {
	*mock.Call
}

// GetUIDTranslations is a helper method to define mock.On call
func (_e *MockManager_Expecter) GetUIDTranslations() *MockManager_GetUIDTranslations_Call {
	return &MockManager_GetUIDTranslations_Call{Call: _e.mock.On("GetUIDTranslations")}
}

func (_c *MockManager_GetUIDTranslations_Call) Run(run func()) *MockManager_GetUIDTranslations_Call {
	_c.Call.Run(func(args mock.Arguments) {
		run()
	})
	return _c
}

func (_c *MockManager_GetUIDTranslations_Call) Return(podToMirror map[types0.ResolvedPodUID]types0.MirrorPodUID, mirrorToPod map[types0.MirrorPodUID]types0.ResolvedPodUID) *MockManager_GetUIDTranslations_Call {
	_c.Call.Return(podToMirror, mirrorToPod)
	return _c
}

func (_c *MockManager_GetUIDTranslations_Call) RunAndReturn(run func() (map[types0.ResolvedPodUID]types0.MirrorPodUID, map[types0.MirrorPodUID]types0.ResolvedPodUID)) *MockManager_GetUIDTranslations_Call {
	_c.Call.Return(run)
	return _c
}

// RemovePod provides a mock function for the type MockManager
func (_mock *MockManager) RemovePod(pod *v1.Pod) {
	_mock.Called(pod)
	return
}

// MockManager_RemovePod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'RemovePod'
type MockManager_RemovePod_Call struct {
	*mock.Call
}

// RemovePod is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockManager_Expecter) RemovePod(pod interface{}) *MockManager_RemovePod_Call {
	return &MockManager_RemovePod_Call{Call: _e.mock.On("RemovePod", pod)}
}

func (_c *MockManager_RemovePod_Call) Run(run func(pod *v1.Pod)) *MockManager_RemovePod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_RemovePod_Call) Return() *MockManager_RemovePod_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockManager_RemovePod_Call) RunAndReturn(run func(pod *v1.Pod)) *MockManager_RemovePod_Call {
	_c.Run(run)
	return _c
}

// SetPods provides a mock function for the type MockManager
func (_mock *MockManager) SetPods(pods []*v1.Pod) {
	_mock.Called(pods)
	return
}

// MockManager_SetPods_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'SetPods'
type MockManager_SetPods_Call struct {
	*mock.Call
}

// SetPods is a helper method to define mock.On call
//   - pods []*v1.Pod
func (_e *MockManager_Expecter) SetPods(pods interface{}) *MockManager_SetPods_Call {
	return &MockManager_SetPods_Call{Call: _e.mock.On("SetPods", pods)}
}

func (_c *MockManager_SetPods_Call) Run(run func(pods []*v1.Pod)) *MockManager_SetPods_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 []*v1.Pod
		if args[0] != nil {
			arg0 = args[0].([]*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_SetPods_Call) Return() *MockManager_SetPods_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockManager_SetPods_Call) RunAndReturn(run func(pods []*v1.Pod)) *MockManager_SetPods_Call {
	_c.Run(run)
	return _c
}

// TranslatePodUID provides a mock function for the type MockManager
func (_mock *MockManager) TranslatePodUID(uid types.UID) types0.ResolvedPodUID {
	ret := _mock.Called(uid)

	if len(ret) == 0 {
		panic("no return value specified for TranslatePodUID")
	}

	var r0 types0.ResolvedPodUID
	if returnFunc, ok := ret.Get(0).(func(types.UID) types0.ResolvedPodUID); ok {
		r0 = returnFunc(uid)
	} else {
		r0 = ret.Get(0).(types0.ResolvedPodUID)
	}
	return r0
}

// MockManager_TranslatePodUID_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'TranslatePodUID'
type MockManager_TranslatePodUID_Call struct {
	*mock.Call
}

// TranslatePodUID is a helper method to define mock.On call
//   - uid types.UID
func (_e *MockManager_Expecter) TranslatePodUID(uid interface{}) *MockManager_TranslatePodUID_Call {
	return &MockManager_TranslatePodUID_Call{Call: _e.mock.On("TranslatePodUID", uid)}
}

func (_c *MockManager_TranslatePodUID_Call) Run(run func(uid types.UID)) *MockManager_TranslatePodUID_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 types.UID
		if args[0] != nil {
			arg0 = args[0].(types.UID)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_TranslatePodUID_Call) Return(resolvedPodUID types0.ResolvedPodUID) *MockManager_TranslatePodUID_Call {
	_c.Call.Return(resolvedPodUID)
	return _c
}

func (_c *MockManager_TranslatePodUID_Call) RunAndReturn(run func(uid types.UID) types0.ResolvedPodUID) *MockManager_TranslatePodUID_Call {
	_c.Call.Return(run)
	return _c
}

// UpdatePod provides a mock function for the type MockManager
func (_mock *MockManager) UpdatePod(pod *v1.Pod) {
	_mock.Called(pod)
	return
}

// MockManager_UpdatePod_Call is a *mock.Call that shadows Run/Return methods with type explicit version for method 'UpdatePod'
type MockManager_UpdatePod_Call struct {
	*mock.Call
}

// UpdatePod is a helper method to define mock.On call
//   - pod *v1.Pod
func (_e *MockManager_Expecter) UpdatePod(pod interface{}) *MockManager_UpdatePod_Call {
	return &MockManager_UpdatePod_Call{Call: _e.mock.On("UpdatePod", pod)}
}

func (_c *MockManager_UpdatePod_Call) Run(run func(pod *v1.Pod)) *MockManager_UpdatePod_Call {
	_c.Call.Run(func(args mock.Arguments) {
		var arg0 *v1.Pod
		if args[0] != nil {
			arg0 = args[0].(*v1.Pod)
		}
		run(
			arg0,
		)
	})
	return _c
}

func (_c *MockManager_UpdatePod_Call) Return() *MockManager_UpdatePod_Call {
	_c.Call.Return()
	return _c
}

func (_c *MockManager_UpdatePod_Call) RunAndReturn(run func(pod *v1.Pod)) *MockManager_UpdatePod_Call {
	_c.Run(run)
	return _c
}
