/*
Copyright 2022 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package provider

import "k8s.io/minikube/pkg/libmachine/host"

type Provider interface {
	// IsValid checks whether or not the Provider can successfully create
	// machines.  If the check does not pass, the provider is no good.
	IsValid() bool

	// Create calls out to the driver this provider is associated with, to
	// actually create the resource.
	Create() (host.Host, error)
}
