/*
Copyright 2016 The Kubernetes Authors All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

package bsutil

import (
	"fmt"
	"os/exec"
	"strings"

	"k8s.io/klog/v2"
	"k8s.io/minikube/pkg/minikube/command"
)

// AdjustResourceLimits makes fine adjustments to pod resources that aren't possible via kubeadm config.
func AdjustResourceLimits(c command.Runner) error {
	rr, err := c.RunCmd(exec.Command("/bin/bash", "-c", "cat /proc/$(pgrep kube-apiserver)/oom_adj"))
	if err != nil {
		return fmt.Errorf("oom_adj check cmd %s. : %w", rr.Command(), err)
	}
	klog.Infof("apiserver oom_adj: %s", rr.Stdout.String())
	// oom_adj is already a negative number
	if strings.HasPrefix(rr.Stdout.String(), "-") {
		return nil
	}
	klog.Infof("adjusting apiserver oom_adj to -10")

	// Prevent the apiserver from OOM'ing before other pods, as it is our gateway into the cluster.
	// It'd be preferable to do this via Kubernetes, but kubeadm doesn't have a way to set pod QoS.
	if _, err = c.RunCmd(exec.Command("/bin/bash", "-c", "echo -10 | sudo tee /proc/$(pgrep kube-apiserver)/oom_adj")); err != nil {
		return fmt.Errorf("oom_adj adjust: %w", err)
	}
	return nil
}

// ExistingConfig checks if there are config files from possible previous Kubernetes cluster
func ExistingConfig(c command.Runner) error {
	args := append([]string{"ls"}, expectedRemoteArtifacts...)
	_, err := c.RunCmd(exec.Command("sudo", args...))
	return err
}
