package v1

// This file contains a collection of methods that can be used from go-restful to
// generate Swagger API documentation for its models. Please read this PR for more
// information on the implementation: https://github.com/emicklei/go-restful/pull/215
//
// TODOs are ignored from the parser (e.g. TODO(andronat):... || TODO:...) if and only if
// they are on one line! For multiple line or blocks that you want to ignore use ---.
// Any context after a --- is ignored.
//
// Those methods can be generated by using hack/update-swagger-docs.sh

// AUTO-GENERATED FUNCTIONS START HERE
var map_CertExpiry = map[string]string{
	"":        "ceryExpiry contains the bundle name and the expiry date",
	"bundle":  "bundle is the name of the bundle in which the subject certificate resides",
	"subject": "subject is the subject of the certificate",
	"expiry":  "expiry is the date after which the certificate will no longer be valid",
}

func (CertExpiry) SwaggerDoc() map[string]string {
	return map_CertExpiry
}

var map_ContainerRuntimeConfig = map[string]string{
	"":       "ContainerRuntimeConfig describes a customized Container Runtime configuration.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"spec":   "spec contains the desired container runtime configuration.",
	"status": "status contains observed information about the container runtime configuration.",
}

func (ContainerRuntimeConfig) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfig
}

var map_ContainerRuntimeConfigCondition = map[string]string{
	"":                   "ContainerRuntimeConfigCondition defines the state of the ContainerRuntimeConfig",
	"type":               "type specifies the state of the operator's reconciliation functionality.",
	"status":             "status of the condition, one of True, False, Unknown.",
	"lastTransitionTime": "lastTransitionTime is the time of the last update to the current status object.",
	"reason":             "reason is the reason for the condition's last transition.  Reasons are PascalCase",
	"message":            "message provides additional information about the current condition. This is only to be consumed by humans.",
}

func (ContainerRuntimeConfigCondition) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfigCondition
}

var map_ContainerRuntimeConfigList = map[string]string{
	"": "ContainerRuntimeConfigList is a list of ContainerRuntimeConfig resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (ContainerRuntimeConfigList) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfigList
}

var map_ContainerRuntimeConfigSpec = map[string]string{
	"":                          "ContainerRuntimeConfigSpec defines the desired state of ContainerRuntimeConfig",
	"machineConfigPoolSelector": "machineConfigPoolSelector selects which pools the ContainerRuntimeConfig shoud apply to. A nil selector will result in no pools being selected.",
	"containerRuntimeConfig":    "containerRuntimeConfig defines the tuneables of the container runtime.",
}

func (ContainerRuntimeConfigSpec) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfigSpec
}

var map_ContainerRuntimeConfigStatus = map[string]string{
	"":                   "ContainerRuntimeConfigStatus defines the observed state of a ContainerRuntimeConfig",
	"observedGeneration": "observedGeneration represents the generation observed by the controller.",
	"conditions":         "conditions represents the latest available observations of current state.",
}

func (ContainerRuntimeConfigStatus) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfigStatus
}

var map_ContainerRuntimeConfiguration = map[string]string{
	"":               "ContainerRuntimeConfiguration defines the tuneables of the container runtime",
	"pidsLimit":      "pidsLimit specifies the maximum number of processes allowed in a container",
	"logLevel":       "logLevel specifies the verbosity of the logs based on the level it is set to. Options are fatal, panic, error, warn, info, and debug.",
	"logSizeMax":     "logSizeMax specifies the Maximum size allowed for the container log file. Negative numbers indicate that no size limit is imposed. If it is positive, it must be >= 8192 to match/exceed conmon's read buffer.",
	"overlaySize":    "overlaySize specifies the maximum size of a container image. This flag can be used to set quota on the size of container images. (default: 10GB)",
	"defaultRuntime": "defaultRuntime is the name of the OCI runtime to be used as the default for containers. Allowed values are `runc` and `crun`. When set to `runc`, OpenShift will use runc to execute the container When set to `crun`, OpenShift will use crun to execute the container When omitted, this means no opinion and the platform is left to choose a reasonable default, which is subject to change over time. Currently, the default is `crun`.",
}

func (ContainerRuntimeConfiguration) SwaggerDoc() map[string]string {
	return map_ContainerRuntimeConfiguration
}

var map_ControllerCertificate = map[string]string{
	"":           "ControllerCertificate contains info about a specific cert.",
	"subject":    "subject is the cert subject",
	"signer":     "signer is the  cert Issuer",
	"notBefore":  "notBefore is the lower boundary for validity",
	"notAfter":   "notAfter is the upper boundary for validity",
	"bundleFile": "bundleFile is the larger bundle a cert comes from",
}

func (ControllerCertificate) SwaggerDoc() map[string]string {
	return map_ControllerCertificate
}

var map_ControllerConfig = map[string]string{
	"":       "ControllerConfig describes configuration for MachineConfigController. This is currently only used to drive the MachineConfig objects generated by the TemplateController.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"spec":   "spec contains the desired controller config configuration.",
	"status": "status contains observed information about the controller config.",
}

func (ControllerConfig) SwaggerDoc() map[string]string {
	return map_ControllerConfig
}

var map_ControllerConfigList = map[string]string{
	"": "ControllerConfigList is a list of ControllerConfig resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (ControllerConfigList) SwaggerDoc() map[string]string {
	return map_ControllerConfigList
}

var map_ControllerConfigSpec = map[string]string{
	"":                               "ControllerConfigSpec is the spec for ControllerConfig resource.",
	"clusterDNSIP":                   "clusterDNSIP is the cluster DNS IP address",
	"cloudProviderConfig":            "cloudProviderConfig is the configuration for the given cloud provider",
	"platform":                       "platform is deprecated, use Infra.Status.PlatformStatus.Type instead",
	"etcdDiscoveryDomain":            "etcdDiscoveryDomain is deprecated, use Infra.Status.EtcdDiscoveryDomain instead",
	"kubeAPIServerServingCAData":     "kubeAPIServerServingCAData managed Kubelet to API Server Cert... Rotated automatically",
	"rootCAData":                     "rootCAData specifies the root CA data",
	"cloudProviderCAData":            "cloudProviderCAData specifies the cloud provider CA data",
	"additionalTrustBundle":          "additionalTrustBundle is a certificate bundle that will be added to the nodes trusted certificate store.",
	"imageRegistryBundleUserData":    "imageRegistryBundleUserData is Image Registry Data provided by the user",
	"imageRegistryBundleData":        "imageRegistryBundleData is the ImageRegistryData",
	"pullSecret":                     "pullSecret is the default pull secret that needs to be installed on all machines.",
	"internalRegistryPullSecret":     "internalRegistryPullSecret is the pull secret for the internal registry, used by rpm-ostree to pull images from the internal registry if present",
	"images":                         "images is map of images that are used by the controller to render templates under ./templates/",
	"baseOSContainerImage":           "baseOSContainerImage is the new-format container image for operating system updates.",
	"baseOSExtensionsContainerImage": "baseOSExtensionsContainerImage is the matching extensions container for the new-format container",
	"osImageURL":                     "osImageURL is the old-format container image that contains the OS update payload.",
	"releaseImage":                   "releaseImage is the image used when installing the cluster",
	"proxy":                          "proxy holds the current proxy configuration for the nodes",
	"infra":                          "infra holds the infrastructure details",
	"dns":                            "dns holds the cluster dns details",
	"ipFamilies":                     "ipFamilies indicates the IP families in use by the cluster network",
	"networkType":                    "networkType holds the type of network the cluster is using XXX: this is temporary and will be dropped as soon as possible in favor of a better support to start network related services the proper way. Nobody is also changing this once the cluster is up and running the first time, so, disallow regeneration if this changes.",
	"network":                        "network contains additional network related information",
}

func (ControllerConfigSpec) SwaggerDoc() map[string]string {
	return map_ControllerConfigSpec
}

var map_ControllerConfigStatus = map[string]string{
	"":                       "ControllerConfigStatus is the status for ControllerConfig",
	"observedGeneration":     "observedGeneration represents the generation observed by the controller.",
	"conditions":             "conditions represents the latest available observations of current state.",
	"controllerCertificates": "controllerCertificates represents the latest available observations of the automatically rotating certificates in the MCO.",
}

func (ControllerConfigStatus) SwaggerDoc() map[string]string {
	return map_ControllerConfigStatus
}

var map_ControllerConfigStatusCondition = map[string]string{
	"":                   "ControllerConfigStatusCondition contains condition information for ControllerConfigStatus",
	"type":               "type specifies the state of the operator's reconciliation functionality.",
	"status":             "status of the condition, one of True, False, Unknown.",
	"lastTransitionTime": "lastTransitionTime is the time of the last update to the current status object.",
	"reason":             "reason is the reason for the condition's last transition.  Reasons are PascalCase",
	"message":            "message provides additional information about the current condition. This is only to be consumed by humans.",
}

func (ControllerConfigStatusCondition) SwaggerDoc() map[string]string {
	return map_ControllerConfigStatusCondition
}

var map_ImageRegistryBundle = map[string]string{
	"":     "ImageRegistryBundle contains information for writing image registry certificates",
	"file": "file holds the name of the file where the bundle will be written to disk",
	"data": "data holds the contents of the bundle that will be written to the file location",
}

func (ImageRegistryBundle) SwaggerDoc() map[string]string {
	return map_ImageRegistryBundle
}

var map_KubeletConfig = map[string]string{
	"":       "KubeletConfig describes a customized Kubelet configuration.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"spec":   "spec contains the desired kubelet configuration.",
	"status": "status contains observed information about the kubelet configuration.",
}

func (KubeletConfig) SwaggerDoc() map[string]string {
	return map_KubeletConfig
}

var map_KubeletConfigCondition = map[string]string{
	"":                   "KubeletConfigCondition defines the state of the KubeletConfig",
	"type":               "type specifies the state of the operator's reconciliation functionality.",
	"status":             "status of the condition, one of True, False, Unknown.",
	"lastTransitionTime": "lastTransitionTime is the time of the last update to the current status object.",
	"reason":             "reason is the reason for the condition's last transition.  Reasons are PascalCase",
	"message":            "message provides additional information about the current condition. This is only to be consumed by humans.",
}

func (KubeletConfigCondition) SwaggerDoc() map[string]string {
	return map_KubeletConfigCondition
}

var map_KubeletConfigList = map[string]string{
	"": "KubeletConfigList is a list of KubeletConfig resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (KubeletConfigList) SwaggerDoc() map[string]string {
	return map_KubeletConfigList
}

var map_KubeletConfigSpec = map[string]string{
	"":                          "KubeletConfigSpec defines the desired state of KubeletConfig",
	"machineConfigPoolSelector": "machineConfigPoolSelector selects which pools the KubeletConfig shoud apply to. A nil selector will result in no pools being selected.",
	"kubeletConfig":             "kubeletConfig fields are defined in kubernetes upstream. Please refer to the types defined in the version/commit used by OpenShift of the upstream kubernetes. It's important to note that, since the fields of the kubelet configuration are directly fetched from upstream the validation of those values is handled directly by the kubelet. Please refer to the upstream version of the relevant kubernetes for the valid values of these fields. Invalid values of the kubelet configuration fields may render cluster nodes unusable.",
	"tlsSecurityProfile":        "If unset, the default is based on the apiservers.config.openshift.io/cluster resource. Note that only Old and Intermediate profiles are currently supported, and the maximum available minTLSVersion is VersionTLS12.",
}

func (KubeletConfigSpec) SwaggerDoc() map[string]string {
	return map_KubeletConfigSpec
}

var map_KubeletConfigStatus = map[string]string{
	"":                   "KubeletConfigStatus defines the observed state of a KubeletConfig",
	"observedGeneration": "observedGeneration represents the generation observed by the controller.",
	"conditions":         "conditions represents the latest available observations of current state.",
}

func (KubeletConfigStatus) SwaggerDoc() map[string]string {
	return map_KubeletConfigStatus
}

var map_MachineConfig = map[string]string{
	"": "MachineConfig defines the configuration for a machine\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (MachineConfig) SwaggerDoc() map[string]string {
	return map_MachineConfig
}

var map_MachineConfigList = map[string]string{
	"": "MachineConfigList is a list of MachineConfig resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (MachineConfigList) SwaggerDoc() map[string]string {
	return map_MachineConfigList
}

var map_MachineConfigPool = map[string]string{
	"":       "MachineConfigPool describes a pool of MachineConfigs.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"spec":   "spec contains the desired machine config pool configuration.",
	"status": "status contains observed information about the machine config pool.",
}

func (MachineConfigPool) SwaggerDoc() map[string]string {
	return map_MachineConfigPool
}

var map_MachineConfigPoolCondition = map[string]string{
	"":                   "MachineConfigPoolCondition contains condition information for an MachineConfigPool.",
	"type":               "type of the condition, currently ('Done', 'Updating', 'Failed').",
	"status":             "status of the condition, one of ('True', 'False', 'Unknown').",
	"lastTransitionTime": "lastTransitionTime is the timestamp corresponding to the last status change of this condition.",
	"reason":             "reason is a brief machine readable explanation for the condition's last transition.",
	"message":            "message is a human readable description of the details of the last transition, complementing reason.",
}

func (MachineConfigPoolCondition) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolCondition
}

var map_MachineConfigPoolList = map[string]string{
	"": "MachineConfigPoolList is a list of MachineConfigPool resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
}

func (MachineConfigPoolList) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolList
}

var map_MachineConfigPoolSpec = map[string]string{
	"":                      "MachineConfigPoolSpec is the spec for MachineConfigPool resource.",
	"machineConfigSelector": "machineConfigSelector specifies a label selector for MachineConfigs. Refer https://kubernetes.io/docs/concepts/overview/working-with-objects/labels/ on how label and selectors work.",
	"nodeSelector":          "nodeSelector specifies a label selector for Machines",
	"paused":                "paused specifies whether or not changes to this machine config pool should be stopped. This includes generating new desiredMachineConfig and update of machines.",
	"maxUnavailable":        "maxUnavailable defines either an integer number or percentage of nodes in the pool that can go Unavailable during an update. This includes nodes Unavailable for any reason, including user initiated cordons, failing nodes, etc. The default value is 1.\n\nA value larger than 1 will mean multiple nodes going unavailable during the update, which may affect your workload stress on the remaining nodes. You cannot set this value to 0 to stop updates (it will default back to 1); to stop updates, use the 'paused' property instead. Drain will respect Pod Disruption Budgets (PDBs) such as etcd quorum guards, even if maxUnavailable is greater than one.",
	"configuration":         "The targeted MachineConfig object for the machine config pool.",
	"pinnedImageSets":       "pinnedImageSets specifies a sequence of PinnedImageSetRef objects for the pool. Nodes within this pool will preload and pin images defined in the PinnedImageSet. Before pulling images the MachineConfigDaemon will ensure the total uncompressed size of all the images does not exceed available resources. If the total size of the images exceeds the available resources the controller will report a Degraded status to the MachineConfigPool and not attempt to pull any images. Also to help ensure the kubelet can mitigate storage risk, the pinned_image configuration and subsequent service reload will happen only after all of the images have been pulled for each set. Images from multiple PinnedImageSets are loaded and pinned sequentially as listed. Duplicate and existing images will be skipped.\n\nAny failure to prefetch or pin images will result in a Degraded pool. Resolving these failures is the responsibility of the user. The admin should be proactive in ensuring adequate storage and proper image authentication exists in advance.",
}

func (MachineConfigPoolSpec) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolSpec
}

var map_MachineConfigPoolStatus = map[string]string{
	"":                        "MachineConfigPoolStatus is the status for MachineConfigPool resource.",
	"observedGeneration":      "observedGeneration represents the generation observed by the controller.",
	"configuration":           "configuration represents the current MachineConfig object for the machine config pool.",
	"machineCount":            "machineCount represents the total number of machines in the machine config pool.",
	"updatedMachineCount":     "updatedMachineCount represents the total number of machines targeted by the pool that have the CurrentMachineConfig as their config.",
	"readyMachineCount":       "readyMachineCount represents the total number of ready machines targeted by the pool.",
	"unavailableMachineCount": "unavailableMachineCount represents the total number of unavailable (non-ready) machines targeted by the pool. A node is marked unavailable if it is in updating state or NodeReady condition is false.",
	"degradedMachineCount":    "degradedMachineCount represents the total number of machines marked degraded (or unreconcilable). A node is marked degraded if applying a configuration failed..",
	"conditions":              "conditions represents the latest available observations of current state.",
	"certExpirys":             "certExpirys keeps track of important certificate expiration data",
	"poolSynchronizersStatus": "poolSynchronizersStatus is the status of the machines managed by the pool synchronizers.",
}

func (MachineConfigPoolStatus) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolStatus
}

var map_MachineConfigPoolStatusConfiguration = map[string]string{
	"":       "MachineConfigPoolStatusConfiguration stores the current configuration for the pool, and optionally also stores the list of MachineConfig objects used to generate the configuration.",
	"source": "source is the list of MachineConfig objects that were used to generate the single MachineConfig object specified in `content`.",
}

func (MachineConfigPoolStatusConfiguration) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolStatusConfiguration
}

var map_MachineConfigSpec = map[string]string{
	"":                               "MachineConfigSpec is the spec for MachineConfig",
	"osImageURL":                     "osImageURL specifies the remote location that will be used to fetch the OS.",
	"baseOSExtensionsContainerImage": "baseOSExtensionsContainerImage specifies the remote location that will be used to fetch the extensions container matching a new-format OS image",
	"config":                         "config is a Ignition Config object.",
	"kernelArguments":                "kernelArguments contains a list of kernel arguments to be added",
	"extensions":                     "extensions contains a list of additional features that can be enabled on host",
	"fips":                           "fips controls FIPS mode",
	"kernelType":                     "kernelType contains which kernel we want to be running like default (traditional), realtime, 64k-pages (aarch64 only).",
}

func (MachineConfigSpec) SwaggerDoc() map[string]string {
	return map_MachineConfigSpec
}

var map_NetworkInfo = map[string]string{
	"":             "Network contains network related configuration",
	"mtuMigration": "mtuMigration contains the MTU migration configuration.",
}

func (NetworkInfo) SwaggerDoc() map[string]string {
	return map_NetworkInfo
}

var map_PinnedImageSetRef = map[string]string{
	"name": "name is a reference to the name of a PinnedImageSet.  Must adhere to RFC-1123 (https://tools.ietf.org/html/rfc1123). Made up of one of more period-separated (.) segments, where each segment consists of alphanumeric characters and hyphens (-), must begin and end with an alphanumeric character, and is at most 63 characters in length. The total length of the name must not exceed 253 characters.",
}

func (PinnedImageSetRef) SwaggerDoc() map[string]string {
	return map_PinnedImageSetRef
}

var map_PoolSynchronizerStatus = map[string]string{
	"poolSynchronizerType":    "poolSynchronizerType describes the type of the pool synchronizer.",
	"machineCount":            "machineCount is the number of machines that are managed by the node synchronizer.",
	"updatedMachineCount":     "updatedMachineCount is the number of machines that have been updated by the node synchronizer.",
	"readyMachineCount":       "readyMachineCount is the number of machines managed by the node synchronizer that are in a ready state.",
	"availableMachineCount":   "availableMachineCount is the number of machines managed by the node synchronizer which are available.",
	"unavailableMachineCount": "unavailableMachineCount is the number of machines managed by the node synchronizer but are unavailable.",
	"observedGeneration":      "observedGeneration is the last generation change that has been applied.",
}

func (PoolSynchronizerStatus) SwaggerDoc() map[string]string {
	return map_PoolSynchronizerStatus
}

var map_IrreconcilableChangeDiff = map[string]string{
	"":          "IrreconcilableChangeDiff holds an individual diff between the initial install-time MachineConfig and the latest applied one caused by the presence of irreconcilable changes.",
	"fieldPath": "fieldPath is a required reference to the path in the latest rendered MachineConfig that differs from this nodes configuration. Must not be empty and must not exceed 70 characters in length. Must begin with the prefix 'spec.' and only contain alphanumeric characters, square brackets ('[]'), or dots ('.').",
	"diff":      "diff is a required field containing the difference between the nodes current configuration and the latest rendered MachineConfig for the field specified in fieldPath. Must not be an empty string and must not exceed 4096 characters in length.",
}

func (IrreconcilableChangeDiff) SwaggerDoc() map[string]string {
	return map_IrreconcilableChangeDiff
}

var map_MCOObjectReference = map[string]string{
	"":     "MCOObjectReference holds information about an object the MCO either owns or modifies in some way",
	"name": "name is the name of the object being referenced. For example, this can represent a machine config pool or node name. Must be a lowercase RFC-1123 subdomain name (https://tools.ietf.org/html/rfc1123) consisting of only lowercase alphanumeric characters, hyphens (-), and periods (.), and must start and end with an alphanumeric character, and be at most 253 characters in length.",
}

func (MCOObjectReference) SwaggerDoc() map[string]string {
	return map_MCOObjectReference
}

var map_MachineConfigNode = map[string]string{
	"":         "MachineConfigNode describes the health of the Machines on the system Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object metadata.",
	"spec":     "spec describes the configuration of the machine config node.",
	"status":   "status describes the last observed state of this machine config node.",
}

func (MachineConfigNode) SwaggerDoc() map[string]string {
	return map_MachineConfigNode
}

var map_MachineConfigNodeList = map[string]string{
	"":         "MachineConfigNodeList describes all of the MachinesStates on the system\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list metadata.",
	"items":    "items contains a collection of MachineConfigNode resources.",
}

func (MachineConfigNodeList) SwaggerDoc() map[string]string {
	return map_MachineConfigNodeList
}

var map_MachineConfigNodeSpec = map[string]string{
	"":              "MachineConfigNodeSpec describes the MachineConfigNode we are managing.",
	"node":          "node contains a reference to the node for this machine config node.",
	"pool":          "pool contains a reference to the machine config pool that this machine config node's referenced node belongs to.",
	"configVersion": "configVersion holds the desired config version for the node targeted by this machine config node resource. The desired version represents the machine config the node will attempt to update to and gets set before the machine config operator validates the new machine config against the current machine config.",
	"configImage":   "configImage is an optional field for configuring the OS image to be used for this node. This field will only exist if the node belongs to a pool opted into on-cluster image builds, and will override any MachineConfig referenced OSImageURL fields When omitted, Image Mode is not be enabled and the node will follow the standard update process of creating a rendered MachineConfig and updating to its specifications. When specified, Image Mode is enabled and will attempt to update the node to use the desired image. Following this, the node will follow the standard update process of creating a rendered MachineConfig and updating to its specifications.",
}

func (MachineConfigNodeSpec) SwaggerDoc() map[string]string {
	return map_MachineConfigNodeSpec
}

var map_MachineConfigNodeSpecConfigImage = map[string]string{
	"":             "MachineConfigNodeSpecConfigImage holds the desired image for the node. This structure is populated from the `machineconfiguration.openshift.io/desiredImage` annotation on the target node, which is set by the Machine Config Pool controller to signal the desired image pullspec for the node to update to.",
	"desiredImage": "desiredImage is a required field that configures the image that the node should be updated to use. It must be a fully qualified OCI image pull spec of the format host[:port][/namespace]/name@sha256:, where the digest must be exactly 64 characters in length and consist only of lowercase hexadecimal characters, a-f and 0-9. desiredImage must not be an empty string and must not exceed 447 characters in length.",
}

func (MachineConfigNodeSpecConfigImage) SwaggerDoc() map[string]string {
	return map_MachineConfigNodeSpecConfigImage
}

var map_MachineConfigNodeSpecMachineConfigVersion = map[string]string{
	"":        "MachineConfigNodeSpecMachineConfigVersion holds the desired config version for the current observed machine config node. When Current is not equal to Desired, the MachineConfigOperator is in an upgrade phase and the machine config node will take account of upgrade related events. Otherwise, they will be ignored given that certain operations happen both during the MCO's upgrade mode and the daily operations mode.",
	"desired": "desired is the name of the machine config that the the node should be upgraded to. This value is set when the machine config pool generates a new version of its rendered configuration. When this value is changed, the machine config daemon starts the node upgrade process. This value gets set in the machine config node spec once the machine config has been targeted for upgrade and before it is validated. Must be a lowercase RFC-1123 subdomain name (https://tools.ietf.org/html/rfc1123) consisting of only lowercase alphanumeric characters, hyphens (-), and periods (.), and must start and end with an alphanumeric character, and be at most 253 characters in length.",
}

func (MachineConfigNodeSpecMachineConfigVersion) SwaggerDoc() map[string]string {
	return map_MachineConfigNodeSpecMachineConfigVersion
}

var map_MachineConfigNodeStatus = map[string]string{
	"":                      "MachineConfigNodeStatus holds the reported information on a particular machine config node.",
	"conditions":            "conditions represent the observations of a machine config node's current state. Valid types are: UpdatePrepared, UpdateExecuted, UpdatePostActionComplete, UpdateComplete, Updated, Resumed, Drained, AppliedFilesAndOS, Cordoned, Uncordoned, RebootedNode, NodeDegraded, PinnedImageSetsProgressing, and PinnedImageSetsDegraded. The following types are only available when the ImageModeStatusReporting feature gate is enabled: ImagePulledFromRegistry, AppliedOSImage, AppliedFiles",
	"observedGeneration":    "observedGeneration represents the generation of the MachineConfigNode object observed by the Machine Config Operator's controller. This field is updated when the controller observes a change to the desiredConfig in the configVersion of the machine config node spec.",
	"configVersion":         "configVersion describes the current and desired machine config version for this node.",
	"configImage":           "configImage is an optional field for configuring the OS image to be used for this node. This field will only exist if the node belongs to a pool opted into on-cluster image builds, and will override any MachineConfig referenced OSImageURL fields. When omitted, this means that the Image Mode feature is not being used and the node will be up to date with the specific current rendered config version for the nodes MachinePool. When specified, the Image Mode feature is enabled and the contents of this field show the observed state of the node image. When Image Mode is enabled and a new MachineConfig is applied such that a new OS image build is not created, only the configVersion field will change. When Image Mode is enabled and a new MachineConfig is applied such that a new OS image build is created, then only the configImage field will change. It is also possible that both the configImage and configVersion change during the same update.",
	"pinnedImageSets":       "pinnedImageSets describes the current and desired pinned image sets for this node.",
	"irreconcilableChanges": "irreconcilableChanges is an optional field that contains the observed differences between this nodes configuration and the target rendered MachineConfig. This field will be set when there are changes to the target rendered MachineConfig that can only be applied to new nodes joining the cluster. Entries must be unique, keyed on the fieldPath field. Must not exceed 32 entries.",
}

func (MachineConfigNodeStatus) SwaggerDoc() map[string]string {
	return map_MachineConfigNodeStatus
}

var map_MachineConfigNodeStatusConfigImage = map[string]string{
	"":             "MachineConfigNodeStatusConfigImage holds the observed state of the image on the node, including both the image targeted for an update and the image currently applied. This allows for monitoring the progress of the layering rollout. If Image Mode is enabled, desiredImage must be defined.",
	"currentImage": "currentImage is an optional field that represents the current image that is applied to the node. When omitted, this means that no image updates have been applied to the node and it will be up to date with the specific current rendered config version. When specified, this means that the node is currently using this image. currentImage must be a fully qualified OCI image pull spec of the format host[:port][/namespace]/name@sha256:, where the digest must be exactly 64 characters in length and consist only of lowercase hexadecimal characters, a-f and 0-9. currentImage must not be an empty string and must not exceed 447 characters in length.",
	"desiredImage": "desiredImage is an optional field that represents the currently observed state of image that the node should be updated to use. When not specified, this means that Image Mode has been disabled and the node will up to date with the specific current rendered config version. When specified, this means that Image Mode has been enabled and the node is actively progressing to update the node to this image. If currentImage and desiredImage match, the node has been successfully updated to use the desired image. desiredImage must be a fully qualified OCI image pull spec of the format host[:port][/namespace]/name@sha256:, where the digest must be exactly 64 characters in length and consist only of lowercase hexadecimal characters, a-f and 0-9. desiredImage must not be an empty string and must not exceed 447 characters in length.",
}

func (MachineConfigNodeStatusConfigImage) SwaggerDoc() map[string]string {
	return map_MachineConfigNodeStatusConfigImage
}

var map_MachineConfigNodeStatusMachineConfigVersion = map[string]string{
	"":        "MachineConfigNodeStatusMachineConfigVersion holds the current and desired config versions as last updated in the MCN status. When the current and desired versions do not match, the machine config pool is processing an upgrade and the machine config node will monitor the upgrade process. When the current and desired versions do match, the machine config node will ignore these events given that certain operations happen both during the MCO's upgrade mode and the daily operations mode.",
	"current": "current is the name of the machine config currently in use on the node. This value is updated once the machine config daemon has completed the update of the configuration for the node. This value should match the desired version unless an upgrade is in progress. Must be a lowercase RFC-1123 subdomain name (https://tools.ietf.org/html/rfc1123) consisting of only lowercase alphanumeric characters, hyphens (-), and periods (.), and must start and end with an alphanumeric character, and be at most 253 characters in length.",
	"desired": "desired is the MachineConfig the node wants to upgrade to. This value gets set in the machine config node status once the machine config has been validated against the current machine config. Must be a lowercase RFC-1123 subdomain name (https://tools.ietf.org/html/rfc1123) consisting of only lowercase alphanumeric characters, hyphens (-), and periods (.), and must start and end with an alphanumeric character, and be at most 253 characters in length.",
}

func (MachineConfigNodeStatusMachineConfigVersion) SwaggerDoc() map[string]string {
	return map_MachineConfigNodeStatusMachineConfigVersion
}

var map_MachineConfigNodeStatusPinnedImageSet = map[string]string{
	"":                          "MachineConfigNodeStatusPinnedImageSet holds information about the current, desired, and failed pinned image sets for the observed machine config node.",
	"name":                      "name is the name of the pinned image set. Must be a lowercase RFC-1123 subdomain name (https://tools.ietf.org/html/rfc1123) consisting of only lowercase alphanumeric characters, hyphens (-), and periods (.), and must start and end with an alphanumeric character, and be at most 253 characters in length.",
	"currentGeneration":         "currentGeneration is the generation of the pinned image set that has most recently been successfully pulled and pinned on this node.",
	"desiredGeneration":         "desiredGeneration is the generation of the pinned image set that is targeted to be pulled and pinned on this node.",
	"lastFailedGeneration":      "lastFailedGeneration is the generation of the most recent pinned image set that failed to be pulled and pinned on this node.",
	"lastFailedGenerationError": "lastFailedGenerationError is the error explaining why the desired images failed to be pulled and pinned. The error is an empty string if the image pull and pin is successful.",
}

func (MachineConfigNodeStatusPinnedImageSet) SwaggerDoc() map[string]string {
	return map_MachineConfigNodeStatusPinnedImageSet
}

var map_MachineConfigReference = map[string]string{
	"":     "Refers to the name of a rendered MachineConfig (e.g., \"rendered-worker-ec40d2965ff81bce7cd7a7e82a680739\", etc.): the build targets this MachineConfig, this is often used to tell us whether we need an update.",
	"name": "name is the name of the rendered MachineConfig object. This value should be between 10 and 253 characters, and must contain only lowercase alphanumeric characters, hyphens and periods, and should start and end with an alphanumeric character.",
}

func (MachineConfigReference) SwaggerDoc() map[string]string {
	return map_MachineConfigReference
}

var map_MachineOSBuild = map[string]string{
	"":         "MachineOSBuild describes a build process managed and deployed by the MCO Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object metadata.",
	"spec":     "spec describes the configuration of the machine os build. It is immutable once set.",
	"status":   "status describes the last observed state of this machine os build.",
}

func (MachineOSBuild) SwaggerDoc() map[string]string {
	return map_MachineOSBuild
}

var map_MachineOSBuildList = map[string]string{
	"":         "MachineOSBuildList describes all of the Builds on the system\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list metadata.",
	"items":    "items contains a collection of MachineOSBuild resources.",
}

func (MachineOSBuildList) SwaggerDoc() map[string]string {
	return map_MachineOSBuildList
}

var map_MachineOSBuildSpec = map[string]string{
	"":                      "MachineOSBuildSpec describes information about a build process primarily populated from a MachineOSConfig object.",
	"machineConfig":         "machineConfig points to the rendered MachineConfig resource to be included in this image build.",
	"machineOSConfig":       "machineOSConfig references the MachineOSConfig resource that this image build extends.",
	"renderedImagePushSpec": "renderedImagePushSpec is set by the Machine Config Operator from the MachineOSConfig object this build is attached to. This field describes the location of the final image, which will be pushed by the build once complete. The format of the image push spec is: host[:port][/namespace]/name:<tag> or svc_name.namespace.svc[:port]/repository/name:<tag>. The length of the push spec must be between 1 to 447 characters.",
}

func (MachineOSBuildSpec) SwaggerDoc() map[string]string {
	return map_MachineOSBuildSpec
}

var map_MachineOSBuildStatus = map[string]string{
	"":                      "MachineOSBuildStatus describes the state of a build and other helpful information.",
	"conditions":            "conditions are state related conditions for the build. Valid types are: Prepared, Building, Failed, Interrupted, and Succeeded. Once a Build is marked as Failed, Interrupted or Succeeded, no future conditions can be set.",
	"builder":               "builder describes the image builder backend used for this build.",
	"relatedObjects":        "relatedObjects is a list of references to ephemeral objects such as ConfigMaps or Secrets that are meant to be consumed while the build process runs. After a successful build or when this MachineOSBuild is deleted, these ephemeral objects will be removed. In the event of a failed build, the objects will remain until the build is removed to allow for inspection.",
	"buildStart":            "buildStart is the timestamp corresponding to the build controller initiating the build backend for this MachineOSBuild.",
	"buildEnd":              "buildEnd is the timestamp corresponding to completion of the builder backend. When omitted the build has either not been started, or is in progress. It will be populated once the build completes, fails or is interrupted.",
	"digestedImagePushSpec": "digestedImagePushSpec describes the fully qualified push spec produced by this build. The format of the push spec is: host[:port][/namespace]/name@sha256:<digest>, where the digest must be 64 characters long, and consist only of lowercase hexadecimal characters, a-f and 0-9. The length of the whole spec must be between 1 to 447 characters.",
}

func (MachineOSBuildStatus) SwaggerDoc() map[string]string {
	return map_MachineOSBuildStatus
}

var map_MachineOSBuilderReference = map[string]string{
	"":                 "MachineOSBuilderReference describes which ImageBuilder backend to use for this build",
	"imageBuilderType": "imageBuilderType describes the type of image builder used to build this image. Valid values are Job only. When set to Job, a pod based builder, using buildah, is launched to build the specified image.",
	"job":              "job is a reference to the job object that is managing the image build. This is required if the imageBuilderType is Job, and forbidden otherwise.",
}

func (MachineOSBuilderReference) SwaggerDoc() map[string]string {
	return map_MachineOSBuilderReference
}

var map_MachineOSConfigReference = map[string]string{
	"":     "MachineOSConfigReference refers to the MachineOSConfig this build is based off of",
	"name": "name of the MachineOSConfig. The name must contain only lowercase alphanumeric characters, '-' or '.' and start/end with an alphanumeric character.",
}

func (MachineOSConfigReference) SwaggerDoc() map[string]string {
	return map_MachineOSConfigReference
}

var map_ObjectReference = map[string]string{
	"":          "ObjectReference contains enough information to let you inspect or modify the referred object.",
	"group":     "group of the referent. The name must contain only lowercase alphanumeric characters, '-' or '.' and start/end with an alphanumeric character. Example: \"\", \"apps\", \"build.openshift.io\", etc.",
	"resource":  "resource of the referent. This value should consist of at most 63 characters, and of only lowercase alphanumeric characters and hyphens, and should start with an alphabetic character and end with an alphanumeric character. Example: \"deployments\", \"deploymentconfigs\", \"pods\", etc.",
	"namespace": "namespace of the referent. This value should consist of at most 63 characters, and of only lowercase alphanumeric characters and hyphens, and should start and end with an alphanumeric character.",
	"name":      "name of the referent. The name must contain only lowercase alphanumeric characters, '-' or '.' and start/end with an alphanumeric character.",
}

func (ObjectReference) SwaggerDoc() map[string]string {
	return map_ObjectReference
}

var map_ImageSecretObjectReference = map[string]string{
	"":     "Refers to the name of an image registry push/pull secret needed in the build process.",
	"name": "name is the name of the secret used to push or pull this MachineOSConfig object. Must consist of lower case alphanumeric characters, '-' or '.', and must start and end with an alphanumeric character. This secret must be in the openshift-machine-config-operator namespace.",
}

func (ImageSecretObjectReference) SwaggerDoc() map[string]string {
	return map_ImageSecretObjectReference
}

var map_MachineConfigPoolReference = map[string]string{
	"":     "Refers to the name of a MachineConfigPool (e.g., \"worker\", \"infra\", etc.): the MachineOSBuilder pod validates that the user has provided a valid pool",
	"name": "name of the MachineConfigPool object. This value should be at most 253 characters, and must contain only lowercase alphanumeric characters, hyphens and periods, and should start and end with an alphanumeric character.",
}

func (MachineConfigPoolReference) SwaggerDoc() map[string]string {
	return map_MachineConfigPoolReference
}

var map_MachineOSConfig = map[string]string{
	"":         "MachineOSConfig describes the configuration for a build process managed by the MCO Compatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object metadata.",
	"spec":     "spec describes the configuration of the machineosconfig",
	"status":   "status describes the status of the machineosconfig",
}

func (MachineOSConfig) SwaggerDoc() map[string]string {
	return map_MachineOSConfig
}

var map_MachineOSConfigList = map[string]string{
	"":         "MachineOSConfigList describes all configurations for image builds on the system\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list metadata.",
	"items":    "items contains a collection of MachineOSConfig resources.",
}

func (MachineOSConfigList) SwaggerDoc() map[string]string {
	return map_MachineOSConfigList
}

var map_MachineOSConfigSpec = map[string]string{
	"":                        "MachineOSConfigSpec describes user-configurable options as well as information about a build process.",
	"machineConfigPool":       "machineConfigPool is the pool which the build is for. The Machine Config Operator will perform the build and roll out the built image to the specified pool.",
	"imageBuilder":            "imageBuilder describes which image builder will be used in each build triggered by this MachineOSConfig. Currently supported type(s): Job",
	"baseImagePullSecret":     "baseImagePullSecret is the secret used to pull the base image. Must live in the openshift-machine-config-operator namespace if provided. Defaults to using the cluster-wide pull secret if not specified. This is provided during install time of the cluster, and lives in the openshift-config namespace as a secret.",
	"renderedImagePushSecret": "renderedImagePushSecret is the secret used to connect to a user registry. The final image push and pull secrets should be separate and assume the principal of least privilege. The push secret with write privilege is only required to be present on the node hosting the MachineConfigController pod. The pull secret with read only privileges is required on all nodes. By separating the two secrets, the risk of write credentials becoming compromised is reduced.",
	"renderedImagePushSpec":   "renderedImagePushSpec describes the location of the final image. The MachineOSConfig object will use the in cluster image registry configuration. If you wish to use a mirror or any other settings specific to registries.conf, please specify those in the cluster wide registries.conf via the cluster image.config, ImageContentSourcePolicies, ImageDigestMirrorSet, or ImageTagMirrorSet objects. The format of the image push spec is: host[:port][/namespace]/name:<tag> or svc_name.namespace.svc[:port]/repository/name:<tag>. The length of the push spec must be between 1 to 447 characters.",
	"containerFile":           "containerFile describes the custom data the user has specified to build into the image. This is also commonly called a Dockerfile and you can treat it as such. The content is the content of your Dockerfile. See https://github.com/containers/common/blob/main/docs/Containerfile.5.md for the spec reference. This is a list indexed by architecture name (e.g. AMD64), and allows specifying one containerFile per arch, up to 4.",
}

func (MachineOSConfigSpec) SwaggerDoc() map[string]string {
	return map_MachineOSConfigSpec
}

var map_MachineOSConfigStatus = map[string]string{
	"":                     "MachineOSConfigStatus describes the status this config object and relates it to the builds associated with this MachineOSConfig",
	"conditions":           "conditions are state related conditions for the object.",
	"observedGeneration":   "observedGeneration represents the generation of the MachineOSConfig object observed by the Machine Config Operator's build controller.",
	"currentImagePullSpec": "currentImagePullSpec is the fully qualified image pull spec used by the MCO to pull down the new OSImage. This includes the sha256 image digest. This is generated when the Machine Config Operator's build controller successfully completes the build, and is populated from the corresponding MachineOSBuild object's FinalImagePushSpec. This may change after completion in reaction to spec changes that would cause a new image build, but will not be removed. The format of the image pull spec is: host[:port][/namespace]/name@sha256:<digest>, where the digest must be 64 characters long, and consist only of lowercase hexadecimal characters, a-f and 0-9. The length of the whole spec must be between 1 to 447 characters.",
	"machineOSBuild":       "machineOSBuild is a reference to the MachineOSBuild object for this MachineOSConfig, which contains the status for the image build.",
}

func (MachineOSConfigStatus) SwaggerDoc() map[string]string {
	return map_MachineOSConfigStatus
}

var map_MachineOSContainerfile = map[string]string{
	"":                  "MachineOSContainerfile contains all custom content the user wants built into the image",
	"containerfileArch": "containerfileArch describes the architecture this containerfile is to be built for. This arch is optional. If the user does not specify an architecture, it is assumed that the content can be applied to all architectures, or in a single arch cluster: the only architecture.",
	"content":           "content is an embedded Containerfile/Dockerfile that defines the contents to be built into your image. See https://github.com/containers/common/blob/main/docs/Containerfile.5.md for the spec reference. for example, this would add the tree package to your hosts:\n  FROM configs AS final\n  RUN rpm-ostree install tree && \\n    ostree container commit\nThis is a required field and can have a maximum length of **4096** characters.",
}

func (MachineOSContainerfile) SwaggerDoc() map[string]string {
	return map_MachineOSContainerfile
}

var map_MachineOSImageBuilder = map[string]string{
	"imageBuilderType": "imageBuilderType specifies the backend to be used to build the image. Valid options are: Job",
}

func (MachineOSImageBuilder) SwaggerDoc() map[string]string {
	return map_MachineOSImageBuilder
}

var map_PinnedImageRef = map[string]string{
	"":     "PinnedImageRef represents a reference to an OCI image",
	"name": "name is an OCI Image referenced by digest. The format of the image pull spec is: host[:port][/namespace]/name@sha256:<digest>, where the digest must be 64 characters long, and consist only of lowercase hexadecimal characters, a-f and 0-9. The length of the whole spec must be between 1 to 447 characters.",
}

func (PinnedImageRef) SwaggerDoc() map[string]string {
	return map_PinnedImageRef
}

var map_PinnedImageSet = map[string]string{
	"":         "PinnedImageSet describes a set of images that should be pinned by CRI-O and pulled to the nodes which are members of the declared MachineConfigPools.\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard object metadata.",
	"spec":     "spec describes the configuration of this pinned image set.",
}

func (PinnedImageSet) SwaggerDoc() map[string]string {
	return map_PinnedImageSet
}

var map_PinnedImageSetList = map[string]string{
	"":         "PinnedImageSetList is a list of PinnedImageSet resources\n\nCompatibility level 1: Stable within a major release for a minimum of 12 months or 3 minor releases (whichever is longer).",
	"metadata": "metadata is the standard list metadata. More info: https://git.k8s.io/community/contributors/devel/sig-architecture/api-conventions.md#metadata",
	"items":    "items contains a collection of PinnedImageSet resources.",
}

func (PinnedImageSetList) SwaggerDoc() map[string]string {
	return map_PinnedImageSetList
}

var map_PinnedImageSetSpec = map[string]string{
	"":             "PinnedImageSetSpec defines the desired state of a PinnedImageSet.",
	"pinnedImages": "pinnedImages is a list of OCI Image referenced by digest that should be pinned and pre-loaded by the nodes of a MachineConfigPool. Translates into a new file inside the /etc/crio/crio.conf.d directory with content similar to this:\n\n     pinned_images = [\n             \"quay.io/openshift-release-dev/ocp-release@sha256:...\",\n             \"quay.io/openshift-release-dev/ocp-v4.0-art-dev@sha256:...\",\n             \"quay.io/openshift-release-dev/ocp-v4.0-art-dev@sha256:...\",\n             ...\n     ]\n\nImage references must be by digest. A maximum of 500 images may be specified.",
}

func (PinnedImageSetSpec) SwaggerDoc() map[string]string {
	return map_PinnedImageSetSpec
}

// AUTO-GENERATED FUNCTIONS END HERE
