// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	appsv1 "github.com/openshift/api/apps/v1"
	internal "github.com/openshift/client-go/apps/applyconfigurations/internal"
	apismetav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// DeploymentConfigApplyConfiguration represents a declarative configuration of the DeploymentConfig type for use
// with apply.
type DeploymentConfigApplyConfiguration struct {
	metav1.TypeMetaApplyConfiguration    `json:",inline"`
	*metav1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	Spec                                 *DeploymentConfigSpecApplyConfiguration   `json:"spec,omitempty"`
	Status                               *DeploymentConfigStatusApplyConfiguration `json:"status,omitempty"`
}

// DeploymentConfig constructs a declarative configuration of the DeploymentConfig type for use with
// apply.
func DeploymentConfig(name, namespace string) *DeploymentConfigApplyConfiguration {
	b := &DeploymentConfigApplyConfiguration{}
	b.WithName(name)
	b.WithNamespace(namespace)
	b.WithKind("DeploymentConfig")
	b.WithAPIVersion("apps.openshift.io/v1")
	return b
}

// ExtractDeploymentConfig extracts the applied configuration owned by fieldManager from
// deploymentConfig. If no managedFields are found in deploymentConfig for fieldManager, a
// DeploymentConfigApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// deploymentConfig must be a unmodified DeploymentConfig API object that was retrieved from the Kubernetes API.
// ExtractDeploymentConfig provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
// Experimental!
func ExtractDeploymentConfig(deploymentConfig *appsv1.DeploymentConfig, fieldManager string) (*DeploymentConfigApplyConfiguration, error) {
	return extractDeploymentConfig(deploymentConfig, fieldManager, "")
}

// ExtractDeploymentConfigStatus is the same as ExtractDeploymentConfig except
// that it extracts the status subresource applied configuration.
// Experimental!
func ExtractDeploymentConfigStatus(deploymentConfig *appsv1.DeploymentConfig, fieldManager string) (*DeploymentConfigApplyConfiguration, error) {
	return extractDeploymentConfig(deploymentConfig, fieldManager, "status")
}

func extractDeploymentConfig(deploymentConfig *appsv1.DeploymentConfig, fieldManager string, subresource string) (*DeploymentConfigApplyConfiguration, error) {
	b := &DeploymentConfigApplyConfiguration{}
	err := managedfields.ExtractInto(deploymentConfig, internal.Parser().Type("com.github.openshift.api.apps.v1.DeploymentConfig"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(deploymentConfig.Name)
	b.WithNamespace(deploymentConfig.Namespace)

	b.WithKind("DeploymentConfig")
	b.WithAPIVersion("apps.openshift.io/v1")
	return b, nil
}
func (b DeploymentConfigApplyConfiguration) IsApplyConfiguration() {}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithKind(value string) *DeploymentConfigApplyConfiguration {
	b.TypeMetaApplyConfiguration.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithAPIVersion(value string) *DeploymentConfigApplyConfiguration {
	b.TypeMetaApplyConfiguration.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithName(value string) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithGenerateName(value string) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithNamespace(value string) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithUID(value types.UID) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithResourceVersion(value string) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithGeneration(value int64) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithCreationTimestamp(value apismetav1.Time) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithDeletionTimestamp(value apismetav1.Time) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *DeploymentConfigApplyConfiguration) WithLabels(entries map[string]string) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Labels == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *DeploymentConfigApplyConfiguration) WithAnnotations(entries map[string]string) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Annotations == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *DeploymentConfigApplyConfiguration) WithOwnerReferences(values ...*metav1.OwnerReferenceApplyConfiguration) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.ObjectMetaApplyConfiguration.OwnerReferences = append(b.ObjectMetaApplyConfiguration.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *DeploymentConfigApplyConfiguration) WithFinalizers(values ...string) *DeploymentConfigApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.ObjectMetaApplyConfiguration.Finalizers = append(b.ObjectMetaApplyConfiguration.Finalizers, values[i])
	}
	return b
}

func (b *DeploymentConfigApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &metav1.ObjectMetaApplyConfiguration{}
	}
}

// WithSpec sets the Spec field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Spec field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithSpec(value *DeploymentConfigSpecApplyConfiguration) *DeploymentConfigApplyConfiguration {
	b.Spec = value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *DeploymentConfigApplyConfiguration) WithStatus(value *DeploymentConfigStatusApplyConfiguration) *DeploymentConfigApplyConfiguration {
	b.Status = value
	return b
}

// GetKind retrieves the value of the Kind field in the declarative configuration.
func (b *DeploymentConfigApplyConfiguration) GetKind() *string {
	return b.TypeMetaApplyConfiguration.Kind
}

// GetAPIVersion retrieves the value of the APIVersion field in the declarative configuration.
func (b *DeploymentConfigApplyConfiguration) GetAPIVersion() *string {
	return b.TypeMetaApplyConfiguration.APIVersion
}

// GetName retrieves the value of the Name field in the declarative configuration.
func (b *DeploymentConfigApplyConfiguration) GetName() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Name
}

// GetNamespace retrieves the value of the Namespace field in the declarative configuration.
func (b *DeploymentConfigApplyConfiguration) GetNamespace() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Namespace
}
