// Code generated by client-gen. DO NOT EDIT.

package fake

import (
	context "context"

	v1 "github.com/openshift/api/image/v1"
	imagev1 "github.com/openshift/client-go/image/applyconfigurations/image/v1"
	typedimagev1 "github.com/openshift/client-go/image/clientset/versioned/typed/image/v1"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	gentype "k8s.io/client-go/gentype"
	testing "k8s.io/client-go/testing"
)

// fakeImageStreams implements ImageStreamInterface
type fakeImageStreams struct {
	*gentype.FakeClientWithListAndApply[*v1.ImageStream, *v1.ImageStreamList, *imagev1.ImageStreamApplyConfiguration]
	Fake *FakeImageV1
}

func newFakeImageStreams(fake *FakeImageV1, namespace string) typedimagev1.ImageStreamInterface {
	return &fakeImageStreams{
		gentype.NewFakeClientWithListAndApply[*v1.ImageStream, *v1.ImageStreamList, *imagev1.ImageStreamApplyConfiguration](
			fake.Fake,
			namespace,
			v1.SchemeGroupVersion.WithResource("imagestreams"),
			v1.SchemeGroupVersion.WithKind("ImageStream"),
			func() *v1.ImageStream { return &v1.ImageStream{} },
			func() *v1.ImageStreamList { return &v1.ImageStreamList{} },
			func(dst, src *v1.ImageStreamList) { dst.ListMeta = src.ListMeta },
			func(list *v1.ImageStreamList) []*v1.ImageStream { return gentype.ToPointerSlice(list.Items) },
			func(list *v1.ImageStreamList, items []*v1.ImageStream) { list.Items = gentype.FromPointerSlice(items) },
		),
		fake,
	}
}

// Secrets takes name of the imageStream, and returns the corresponding secretList object, and an error if there is any.
func (c *fakeImageStreams) Secrets(ctx context.Context, imageStreamName string, options metav1.GetOptions) (result *v1.SecretList, err error) {
	emptyResult := &v1.SecretList{}
	obj, err := c.Fake.
		Invokes(testing.NewGetSubresourceActionWithOptions(c.Resource(), c.Namespace(), "secrets", imageStreamName, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.SecretList), err
}

// Layers takes name of the imageStream, and returns the corresponding imageStreamLayers object, and an error if there is any.
func (c *fakeImageStreams) Layers(ctx context.Context, imageStreamName string, options metav1.GetOptions) (result *v1.ImageStreamLayers, err error) {
	emptyResult := &v1.ImageStreamLayers{}
	obj, err := c.Fake.
		Invokes(testing.NewGetSubresourceActionWithOptions(c.Resource(), c.Namespace(), "layers", imageStreamName, options), emptyResult)

	if obj == nil {
		return emptyResult, err
	}
	return obj.(*v1.ImageStreamLayers), err
}
