// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1

import (
	networkv1 "github.com/openshift/api/network/v1"
	internal "github.com/openshift/client-go/network/applyconfigurations/internal"
	apismetav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	metav1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// HostSubnetApplyConfiguration represents a declarative configuration of the HostSubnet type for use
// with apply.
type HostSubnetApplyConfiguration struct {
	metav1.TypeMetaApplyConfiguration    `json:",inline"`
	*metav1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	Host                                 *string                          `json:"host,omitempty"`
	HostIP                               *string                          `json:"hostIP,omitempty"`
	Subnet                               *string                          `json:"subnet,omitempty"`
	EgressIPs                            []networkv1.HostSubnetEgressIP   `json:"egressIPs,omitempty"`
	EgressCIDRs                          []networkv1.HostSubnetEgressCIDR `json:"egressCIDRs,omitempty"`
}

// HostSubnet constructs a declarative configuration of the HostSubnet type for use with
// apply.
func HostSubnet(name string) *HostSubnetApplyConfiguration {
	b := &HostSubnetApplyConfiguration{}
	b.WithName(name)
	b.WithKind("HostSubnet")
	b.WithAPIVersion("network.openshift.io/v1")
	return b
}

// ExtractHostSubnet extracts the applied configuration owned by fieldManager from
// hostSubnet. If no managedFields are found in hostSubnet for fieldManager, a
// HostSubnetApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// hostSubnet must be a unmodified HostSubnet API object that was retrieved from the Kubernetes API.
// ExtractHostSubnet provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
// Experimental!
func ExtractHostSubnet(hostSubnet *networkv1.HostSubnet, fieldManager string) (*HostSubnetApplyConfiguration, error) {
	return extractHostSubnet(hostSubnet, fieldManager, "")
}

// ExtractHostSubnetStatus is the same as ExtractHostSubnet except
// that it extracts the status subresource applied configuration.
// Experimental!
func ExtractHostSubnetStatus(hostSubnet *networkv1.HostSubnet, fieldManager string) (*HostSubnetApplyConfiguration, error) {
	return extractHostSubnet(hostSubnet, fieldManager, "status")
}

func extractHostSubnet(hostSubnet *networkv1.HostSubnet, fieldManager string, subresource string) (*HostSubnetApplyConfiguration, error) {
	b := &HostSubnetApplyConfiguration{}
	err := managedfields.ExtractInto(hostSubnet, internal.Parser().Type("com.github.openshift.api.network.v1.HostSubnet"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(hostSubnet.Name)

	b.WithKind("HostSubnet")
	b.WithAPIVersion("network.openshift.io/v1")
	return b, nil
}
func (b HostSubnetApplyConfiguration) IsApplyConfiguration() {}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithKind(value string) *HostSubnetApplyConfiguration {
	b.TypeMetaApplyConfiguration.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithAPIVersion(value string) *HostSubnetApplyConfiguration {
	b.TypeMetaApplyConfiguration.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithName(value string) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithGenerateName(value string) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithNamespace(value string) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithUID(value types.UID) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithResourceVersion(value string) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithGeneration(value int64) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithCreationTimestamp(value apismetav1.Time) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithDeletionTimestamp(value apismetav1.Time) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *HostSubnetApplyConfiguration) WithLabels(entries map[string]string) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Labels == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *HostSubnetApplyConfiguration) WithAnnotations(entries map[string]string) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Annotations == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *HostSubnetApplyConfiguration) WithOwnerReferences(values ...*metav1.OwnerReferenceApplyConfiguration) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.ObjectMetaApplyConfiguration.OwnerReferences = append(b.ObjectMetaApplyConfiguration.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *HostSubnetApplyConfiguration) WithFinalizers(values ...string) *HostSubnetApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.ObjectMetaApplyConfiguration.Finalizers = append(b.ObjectMetaApplyConfiguration.Finalizers, values[i])
	}
	return b
}

func (b *HostSubnetApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &metav1.ObjectMetaApplyConfiguration{}
	}
}

// WithHost sets the Host field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Host field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithHost(value string) *HostSubnetApplyConfiguration {
	b.Host = &value
	return b
}

// WithHostIP sets the HostIP field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the HostIP field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithHostIP(value string) *HostSubnetApplyConfiguration {
	b.HostIP = &value
	return b
}

// WithSubnet sets the Subnet field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Subnet field is set to the value of the last call.
func (b *HostSubnetApplyConfiguration) WithSubnet(value string) *HostSubnetApplyConfiguration {
	b.Subnet = &value
	return b
}

// WithEgressIPs adds the given value to the EgressIPs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the EgressIPs field.
func (b *HostSubnetApplyConfiguration) WithEgressIPs(values ...networkv1.HostSubnetEgressIP) *HostSubnetApplyConfiguration {
	for i := range values {
		b.EgressIPs = append(b.EgressIPs, values[i])
	}
	return b
}

// WithEgressCIDRs adds the given value to the EgressCIDRs field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the EgressCIDRs field.
func (b *HostSubnetApplyConfiguration) WithEgressCIDRs(values ...networkv1.HostSubnetEgressCIDR) *HostSubnetApplyConfiguration {
	for i := range values {
		b.EgressCIDRs = append(b.EgressCIDRs, values[i])
	}
	return b
}

// GetKind retrieves the value of the Kind field in the declarative configuration.
func (b *HostSubnetApplyConfiguration) GetKind() *string {
	return b.TypeMetaApplyConfiguration.Kind
}

// GetAPIVersion retrieves the value of the APIVersion field in the declarative configuration.
func (b *HostSubnetApplyConfiguration) GetAPIVersion() *string {
	return b.TypeMetaApplyConfiguration.APIVersion
}

// GetName retrieves the value of the Name field in the declarative configuration.
func (b *HostSubnetApplyConfiguration) GetName() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Name
}

// GetNamespace retrieves the value of the Namespace field in the declarative configuration.
func (b *HostSubnetApplyConfiguration) GetNamespace() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Namespace
}
