// Code generated by applyconfiguration-gen. DO NOT EDIT.

package v1alpha1

import (
	operatorv1alpha1 "github.com/openshift/api/operator/v1alpha1"
	internal "github.com/openshift/client-go/operator/applyconfigurations/internal"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	managedfields "k8s.io/apimachinery/pkg/util/managedfields"
	v1 "k8s.io/client-go/applyconfigurations/meta/v1"
)

// ClusterVersionOperatorApplyConfiguration represents a declarative configuration of the ClusterVersionOperator type for use
// with apply.
type ClusterVersionOperatorApplyConfiguration struct {
	v1.TypeMetaApplyConfiguration    `json:",inline"`
	*v1.ObjectMetaApplyConfiguration `json:"metadata,omitempty"`
	Spec                             *ClusterVersionOperatorSpecApplyConfiguration   `json:"spec,omitempty"`
	Status                           *ClusterVersionOperatorStatusApplyConfiguration `json:"status,omitempty"`
}

// ClusterVersionOperator constructs a declarative configuration of the ClusterVersionOperator type for use with
// apply.
func ClusterVersionOperator(name string) *ClusterVersionOperatorApplyConfiguration {
	b := &ClusterVersionOperatorApplyConfiguration{}
	b.WithName(name)
	b.WithKind("ClusterVersionOperator")
	b.WithAPIVersion("operator.openshift.io/v1alpha1")
	return b
}

// ExtractClusterVersionOperator extracts the applied configuration owned by fieldManager from
// clusterVersionOperator. If no managedFields are found in clusterVersionOperator for fieldManager, a
// ClusterVersionOperatorApplyConfiguration is returned with only the Name, Namespace (if applicable),
// APIVersion and Kind populated. It is possible that no managed fields were found for because other
// field managers have taken ownership of all the fields previously owned by fieldManager, or because
// the fieldManager never owned fields any fields.
// clusterVersionOperator must be a unmodified ClusterVersionOperator API object that was retrieved from the Kubernetes API.
// ExtractClusterVersionOperator provides a way to perform a extract/modify-in-place/apply workflow.
// Note that an extracted apply configuration will contain fewer fields than what the fieldManager previously
// applied if another fieldManager has updated or force applied any of the previously applied fields.
// Experimental!
func ExtractClusterVersionOperator(clusterVersionOperator *operatorv1alpha1.ClusterVersionOperator, fieldManager string) (*ClusterVersionOperatorApplyConfiguration, error) {
	return extractClusterVersionOperator(clusterVersionOperator, fieldManager, "")
}

// ExtractClusterVersionOperatorStatus is the same as ExtractClusterVersionOperator except
// that it extracts the status subresource applied configuration.
// Experimental!
func ExtractClusterVersionOperatorStatus(clusterVersionOperator *operatorv1alpha1.ClusterVersionOperator, fieldManager string) (*ClusterVersionOperatorApplyConfiguration, error) {
	return extractClusterVersionOperator(clusterVersionOperator, fieldManager, "status")
}

func extractClusterVersionOperator(clusterVersionOperator *operatorv1alpha1.ClusterVersionOperator, fieldManager string, subresource string) (*ClusterVersionOperatorApplyConfiguration, error) {
	b := &ClusterVersionOperatorApplyConfiguration{}
	err := managedfields.ExtractInto(clusterVersionOperator, internal.Parser().Type("com.github.openshift.api.operator.v1alpha1.ClusterVersionOperator"), fieldManager, b, subresource)
	if err != nil {
		return nil, err
	}
	b.WithName(clusterVersionOperator.Name)

	b.WithKind("ClusterVersionOperator")
	b.WithAPIVersion("operator.openshift.io/v1alpha1")
	return b, nil
}
func (b ClusterVersionOperatorApplyConfiguration) IsApplyConfiguration() {}

// WithKind sets the Kind field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Kind field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithKind(value string) *ClusterVersionOperatorApplyConfiguration {
	b.TypeMetaApplyConfiguration.Kind = &value
	return b
}

// WithAPIVersion sets the APIVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the APIVersion field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithAPIVersion(value string) *ClusterVersionOperatorApplyConfiguration {
	b.TypeMetaApplyConfiguration.APIVersion = &value
	return b
}

// WithName sets the Name field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Name field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithName(value string) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Name = &value
	return b
}

// WithGenerateName sets the GenerateName field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the GenerateName field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithGenerateName(value string) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.GenerateName = &value
	return b
}

// WithNamespace sets the Namespace field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Namespace field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithNamespace(value string) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Namespace = &value
	return b
}

// WithUID sets the UID field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the UID field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithUID(value types.UID) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.UID = &value
	return b
}

// WithResourceVersion sets the ResourceVersion field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the ResourceVersion field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithResourceVersion(value string) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.ResourceVersion = &value
	return b
}

// WithGeneration sets the Generation field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Generation field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithGeneration(value int64) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.Generation = &value
	return b
}

// WithCreationTimestamp sets the CreationTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the CreationTimestamp field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithCreationTimestamp(value metav1.Time) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.CreationTimestamp = &value
	return b
}

// WithDeletionTimestamp sets the DeletionTimestamp field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionTimestamp field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithDeletionTimestamp(value metav1.Time) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionTimestamp = &value
	return b
}

// WithDeletionGracePeriodSeconds sets the DeletionGracePeriodSeconds field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the DeletionGracePeriodSeconds field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithDeletionGracePeriodSeconds(value int64) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	b.ObjectMetaApplyConfiguration.DeletionGracePeriodSeconds = &value
	return b
}

// WithLabels puts the entries into the Labels field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Labels field,
// overwriting an existing map entries in Labels field with the same key.
func (b *ClusterVersionOperatorApplyConfiguration) WithLabels(entries map[string]string) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Labels == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Labels = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Labels[k] = v
	}
	return b
}

// WithAnnotations puts the entries into the Annotations field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, the entries provided by each call will be put on the Annotations field,
// overwriting an existing map entries in Annotations field with the same key.
func (b *ClusterVersionOperatorApplyConfiguration) WithAnnotations(entries map[string]string) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	if b.ObjectMetaApplyConfiguration.Annotations == nil && len(entries) > 0 {
		b.ObjectMetaApplyConfiguration.Annotations = make(map[string]string, len(entries))
	}
	for k, v := range entries {
		b.ObjectMetaApplyConfiguration.Annotations[k] = v
	}
	return b
}

// WithOwnerReferences adds the given value to the OwnerReferences field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the OwnerReferences field.
func (b *ClusterVersionOperatorApplyConfiguration) WithOwnerReferences(values ...*v1.OwnerReferenceApplyConfiguration) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		if values[i] == nil {
			panic("nil value passed to WithOwnerReferences")
		}
		b.ObjectMetaApplyConfiguration.OwnerReferences = append(b.ObjectMetaApplyConfiguration.OwnerReferences, *values[i])
	}
	return b
}

// WithFinalizers adds the given value to the Finalizers field in the declarative configuration
// and returns the receiver, so that objects can be build by chaining "With" function invocations.
// If called multiple times, values provided by each call will be appended to the Finalizers field.
func (b *ClusterVersionOperatorApplyConfiguration) WithFinalizers(values ...string) *ClusterVersionOperatorApplyConfiguration {
	b.ensureObjectMetaApplyConfigurationExists()
	for i := range values {
		b.ObjectMetaApplyConfiguration.Finalizers = append(b.ObjectMetaApplyConfiguration.Finalizers, values[i])
	}
	return b
}

func (b *ClusterVersionOperatorApplyConfiguration) ensureObjectMetaApplyConfigurationExists() {
	if b.ObjectMetaApplyConfiguration == nil {
		b.ObjectMetaApplyConfiguration = &v1.ObjectMetaApplyConfiguration{}
	}
}

// WithSpec sets the Spec field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Spec field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithSpec(value *ClusterVersionOperatorSpecApplyConfiguration) *ClusterVersionOperatorApplyConfiguration {
	b.Spec = value
	return b
}

// WithStatus sets the Status field in the declarative configuration to the given value
// and returns the receiver, so that objects can be built by chaining "With" function invocations.
// If called multiple times, the Status field is set to the value of the last call.
func (b *ClusterVersionOperatorApplyConfiguration) WithStatus(value *ClusterVersionOperatorStatusApplyConfiguration) *ClusterVersionOperatorApplyConfiguration {
	b.Status = value
	return b
}

// GetKind retrieves the value of the Kind field in the declarative configuration.
func (b *ClusterVersionOperatorApplyConfiguration) GetKind() *string {
	return b.TypeMetaApplyConfiguration.Kind
}

// GetAPIVersion retrieves the value of the APIVersion field in the declarative configuration.
func (b *ClusterVersionOperatorApplyConfiguration) GetAPIVersion() *string {
	return b.TypeMetaApplyConfiguration.APIVersion
}

// GetName retrieves the value of the Name field in the declarative configuration.
func (b *ClusterVersionOperatorApplyConfiguration) GetName() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Name
}

// GetNamespace retrieves the value of the Namespace field in the declarative configuration.
func (b *ClusterVersionOperatorApplyConfiguration) GetNamespace() *string {
	b.ensureObjectMetaApplyConfigurationExists()
	return b.ObjectMetaApplyConfiguration.Namespace
}
