// Code generated by client-gen. DO NOT EDIT.

package v1

import (
	http "net/http"

	projectv1 "github.com/openshift/api/project/v1"
	scheme "github.com/openshift/client-go/project/clientset/versioned/scheme"
	rest "k8s.io/client-go/rest"
)

type ProjectV1Interface interface {
	RESTClient() rest.Interface
	ProjectsGetter
	ProjectRequestsGetter
}

// ProjectV1Client is used to interact with features provided by the project.openshift.io group.
type ProjectV1Client struct {
	restClient rest.Interface
}

func (c *ProjectV1Client) Projects() ProjectInterface {
	return newProjects(c)
}

func (c *ProjectV1Client) ProjectRequests() ProjectRequestInterface {
	return newProjectRequests(c)
}

// NewForConfig creates a new ProjectV1Client for the given config.
// NewForConfig is equivalent to NewForConfigAndClient(c, httpClient),
// where httpClient was generated with rest.HTTPClientFor(c).
func NewForConfig(c *rest.Config) (*ProjectV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	httpClient, err := rest.HTTPClientFor(&config)
	if err != nil {
		return nil, err
	}
	return NewForConfigAndClient(&config, httpClient)
}

// NewForConfigAndClient creates a new ProjectV1Client for the given config and http client.
// Note the http client provided takes precedence over the configured transport values.
func NewForConfigAndClient(c *rest.Config, h *http.Client) (*ProjectV1Client, error) {
	config := *c
	setConfigDefaults(&config)
	client, err := rest.RESTClientForConfigAndClient(&config, h)
	if err != nil {
		return nil, err
	}
	return &ProjectV1Client{client}, nil
}

// NewForConfigOrDie creates a new ProjectV1Client for the given config and
// panics if there is an error in the config.
func NewForConfigOrDie(c *rest.Config) *ProjectV1Client {
	client, err := NewForConfig(c)
	if err != nil {
		panic(err)
	}
	return client
}

// New creates a new ProjectV1Client for the given RESTClient.
func New(c rest.Interface) *ProjectV1Client {
	return &ProjectV1Client{c}
}

func setConfigDefaults(config *rest.Config) {
	gv := projectv1.SchemeGroupVersion
	config.GroupVersion = &gv
	config.APIPath = "/apis"
	config.NegotiatedSerializer = rest.CodecFactoryForGeneratedClient(scheme.Scheme, scheme.Codecs).WithoutConversion()

	if config.UserAgent == "" {
		config.UserAgent = rest.DefaultKubernetesUserAgent()
	}
}

// RESTClient returns a RESTClient that is used to communicate
// with API server by this client implementation.
func (c *ProjectV1Client) RESTClient() rest.Interface {
	if c == nil {
		return nil
	}
	return c.restClient
}
