import { forwardRef } from "react";

interface ButtonProps {
  isVisible?: boolean;
  isActive: boolean;
  onToggle: () => void;
}

export const WebSearchButton = forwardRef<HTMLButtonElement, ButtonProps>(
  function WebSearchButton({ isVisible, isActive, onToggle }, ref) {
    if (!isVisible) return null;

    return (
      <button
        ref={ref}
        title={isActive ? "Disable web search" : "Enable web search"}
        onClick={onToggle}
        className={`select-none flex items-center justify-center rounded-full h-9 w-9 bg-white dark:bg-neutral-700 focus:outline-none focus:ring-2 focus:ring-blue-500 cursor-pointer transition-all whitespace-nowrap border border-transparent ${
          isActive
            ? "text-[rgba(0,115,255,1)] dark:text-[rgba(70,155,255,1)]"
            : "text-neutral-500 dark:text-neutral-400"
        }`}
      >
        <svg
          className="h-5 w-5"
          fill="none"
          stroke="currentColor"
          strokeWidth="2"
          viewBox="0 0 24 24"
        >
          <path
            strokeLinecap="round"
            strokeLinejoin="round"
            d="M21 12a9 9 0 01-9 9m9-9a9 9 0 00-9-9m9 9H3m9 9a9 9 0 01-9-9m9 9c1.657 0 3-4.03 3-9s-1.343-9-3-9m0 18c-1.657 0-3-4.03-3-9s1.343-9 3-9m-9 9a9 9 0 019-9"
          />
        </svg>
      </button>
    );
  },
);
