// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v3.21.12
// source: sp_pipeline.proto

package protos

import (
	steps "github.com/streamdal/streamdal/libs/protos/build/go/protos/steps"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

type PipelineDataFormat int32

const (
	PipelineDataFormat_PIPELINE_DATA_FORMAT_UNSET     PipelineDataFormat = 0
	PipelineDataFormat_PIPELINE_DATA_FORMAT_JSON      PipelineDataFormat = 1
	PipelineDataFormat_PIPELINE_DATA_FORMAT_PLAINTEXT PipelineDataFormat = 2
)

// Enum value maps for PipelineDataFormat.
var (
	PipelineDataFormat_name = map[int32]string{
		0: "PIPELINE_DATA_FORMAT_UNSET",
		1: "PIPELINE_DATA_FORMAT_JSON",
		2: "PIPELINE_DATA_FORMAT_PLAINTEXT",
	}
	PipelineDataFormat_value = map[string]int32{
		"PIPELINE_DATA_FORMAT_UNSET":     0,
		"PIPELINE_DATA_FORMAT_JSON":      1,
		"PIPELINE_DATA_FORMAT_PLAINTEXT": 2,
	}
)

func (x PipelineDataFormat) Enum() *PipelineDataFormat {
	p := new(PipelineDataFormat)
	*p = x
	return p
}

func (x PipelineDataFormat) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PipelineDataFormat) Descriptor() protoreflect.EnumDescriptor {
	return file_sp_pipeline_proto_enumTypes[0].Descriptor()
}

func (PipelineDataFormat) Type() protoreflect.EnumType {
	return &file_sp_pipeline_proto_enumTypes[0]
}

func (x PipelineDataFormat) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PipelineDataFormat.Descriptor instead.
func (PipelineDataFormat) EnumDescriptor() ([]byte, []int) {
	return file_sp_pipeline_proto_rawDescGZIP(), []int{0}
}

// Defines the ways in which a pipeline can be aborted
type AbortCondition int32

const (
	AbortCondition_ABORT_CONDITION_UNSET         AbortCondition = 0
	AbortCondition_ABORT_CONDITION_ABORT_CURRENT AbortCondition = 1
	AbortCondition_ABORT_CONDITION_ABORT_ALL     AbortCondition = 2
)

// Enum value maps for AbortCondition.
var (
	AbortCondition_name = map[int32]string{
		0: "ABORT_CONDITION_UNSET",
		1: "ABORT_CONDITION_ABORT_CURRENT",
		2: "ABORT_CONDITION_ABORT_ALL",
	}
	AbortCondition_value = map[string]int32{
		"ABORT_CONDITION_UNSET":         0,
		"ABORT_CONDITION_ABORT_CURRENT": 1,
		"ABORT_CONDITION_ABORT_ALL":     2,
	}
)

func (x AbortCondition) Enum() *AbortCondition {
	p := new(AbortCondition)
	*p = x
	return p
}

func (x AbortCondition) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (AbortCondition) Descriptor() protoreflect.EnumDescriptor {
	return file_sp_pipeline_proto_enumTypes[1].Descriptor()
}

func (AbortCondition) Type() protoreflect.EnumType {
	return &file_sp_pipeline_proto_enumTypes[1]
}

func (x AbortCondition) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use AbortCondition.Descriptor instead.
func (AbortCondition) EnumDescriptor() ([]byte, []int) {
	return file_sp_pipeline_proto_rawDescGZIP(), []int{1}
}

type PipelineStepNotification_PayloadType int32

const (
	// Same functionality as PAYLOAD_TYPE_EXCLUDE
	PipelineStepNotification_PAYLOAD_TYPE_UNSET PipelineStepNotification_PayloadType = 0
	// Default. No payload data included in notification
	PipelineStepNotification_PAYLOAD_TYPE_EXCLUDE PipelineStepNotification_PayloadType = 1
	// Entire payload content included in notification
	PipelineStepNotification_PAYLOAD_TYPE_FULL_PAYLOAD PipelineStepNotification_PayloadType = 2
	// Only specified paths of payload content included in notification
	// Only works on JSON. Plaintext payloads will be ignored.
	PipelineStepNotification_PAYLOAD_TYPE_SELECT_PATHS PipelineStepNotification_PayloadType = 3
)

// Enum value maps for PipelineStepNotification_PayloadType.
var (
	PipelineStepNotification_PayloadType_name = map[int32]string{
		0: "PAYLOAD_TYPE_UNSET",
		1: "PAYLOAD_TYPE_EXCLUDE",
		2: "PAYLOAD_TYPE_FULL_PAYLOAD",
		3: "PAYLOAD_TYPE_SELECT_PATHS",
	}
	PipelineStepNotification_PayloadType_value = map[string]int32{
		"PAYLOAD_TYPE_UNSET":        0,
		"PAYLOAD_TYPE_EXCLUDE":      1,
		"PAYLOAD_TYPE_FULL_PAYLOAD": 2,
		"PAYLOAD_TYPE_SELECT_PATHS": 3,
	}
)

func (x PipelineStepNotification_PayloadType) Enum() *PipelineStepNotification_PayloadType {
	p := new(PipelineStepNotification_PayloadType)
	*p = x
	return p
}

func (x PipelineStepNotification_PayloadType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (PipelineStepNotification_PayloadType) Descriptor() protoreflect.EnumDescriptor {
	return file_sp_pipeline_proto_enumTypes[2].Descriptor()
}

func (PipelineStepNotification_PayloadType) Type() protoreflect.EnumType {
	return &file_sp_pipeline_proto_enumTypes[2]
}

func (x PipelineStepNotification_PayloadType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use PipelineStepNotification_PayloadType.Descriptor instead.
func (PipelineStepNotification_PayloadType) EnumDescriptor() ([]byte, []int) {
	return file_sp_pipeline_proto_rawDescGZIP(), []int{2, 0}
}

// Pipeline is a structure that holds one or more pipeline steps. This structure
// is intended to be immutable; clients are expected to generate WASMRequest's
// that contain a pipeline step.
type Pipeline struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// If left blank, the server will generate a unique ID. If one is provided,
	// the server will check if that is ID is already in use when creating a pipeline.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// Friendly name for the pipeline
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// One or more steps to execute
	Steps []*PipelineStep `protobuf:"bytes,3,rep,name=steps,proto3" json:"steps,omitempty"`
	// Notification configs for this pipeline. Only filled out in external API responses
	// This is deprecated and the data has moved to PipelineStep
	//
	// Deprecated: Marked as deprecated in sp_pipeline.proto.
	XNotificationConfigs []*NotificationConfig `protobuf:"bytes,4,rep,name=_notification_configs,json=NotificationConfigs,proto3" json:"_notification_configs,omitempty"` // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	DataFormat           PipelineDataFormat    `protobuf:"varint,5,opt,name=data_format,json=dataFormat,proto3,enum=protos.PipelineDataFormat" json:"data_format,omitempty"`
	// Indicates whether the pipeline is paused or not. Used internally by server.
	XPaused             *bool   `protobuf:"varint,1000,opt,name=_paused,json=Paused,proto3,oneof" json:"_paused,omitempty"`                                             // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	XDescription        *string `protobuf:"bytes,1001,opt,name=_description,json=Description,proto3,oneof" json:"_description,omitempty"`                               // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	XVersion            *string `protobuf:"bytes,1002,opt,name=_version,json=Version,proto3,oneof" json:"_version,omitempty"`                                           // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	XUrl                *string `protobuf:"bytes,1003,opt,name=_url,json=Url,proto3,oneof" json:"_url,omitempty"`                                                       // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	XCreatedAtUnixTsUtc *int64  `protobuf:"varint,1004,opt,name=_created_at_unix_ts_utc,json=CreatedAtUnixTsUtc,proto3,oneof" json:"_created_at_unix_ts_utc,omitempty"` // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	XUpdatedAtUnixTsUtc *int64  `protobuf:"varint,1005,opt,name=_updated_at_unix_ts_utc,json=UpdatedAtUnixTsUtc,proto3,oneof" json:"_updated_at_unix_ts_utc,omitempty"` // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	// Used internally by server and k8s operator to determine who manages this resource
	XCreatedBy *string `protobuf:"bytes,1006,opt,name=_created_by,json=CreatedBy,proto3,oneof" json:"_created_by,omitempty"` // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
}

func (x *Pipeline) Reset() {
	*x = Pipeline{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sp_pipeline_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Pipeline) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pipeline) ProtoMessage() {}

func (x *Pipeline) ProtoReflect() protoreflect.Message {
	mi := &file_sp_pipeline_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pipeline.ProtoReflect.Descriptor instead.
func (*Pipeline) Descriptor() ([]byte, []int) {
	return file_sp_pipeline_proto_rawDescGZIP(), []int{0}
}

func (x *Pipeline) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Pipeline) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Pipeline) GetSteps() []*PipelineStep {
	if x != nil {
		return x.Steps
	}
	return nil
}

// Deprecated: Marked as deprecated in sp_pipeline.proto.
func (x *Pipeline) GetXNotificationConfigs() []*NotificationConfig {
	if x != nil {
		return x.XNotificationConfigs
	}
	return nil
}

func (x *Pipeline) GetDataFormat() PipelineDataFormat {
	if x != nil {
		return x.DataFormat
	}
	return PipelineDataFormat_PIPELINE_DATA_FORMAT_UNSET
}

func (x *Pipeline) GetXPaused() bool {
	if x != nil && x.XPaused != nil {
		return *x.XPaused
	}
	return false
}

func (x *Pipeline) GetXDescription() string {
	if x != nil && x.XDescription != nil {
		return *x.XDescription
	}
	return ""
}

func (x *Pipeline) GetXVersion() string {
	if x != nil && x.XVersion != nil {
		return *x.XVersion
	}
	return ""
}

func (x *Pipeline) GetXUrl() string {
	if x != nil && x.XUrl != nil {
		return *x.XUrl
	}
	return ""
}

func (x *Pipeline) GetXCreatedAtUnixTsUtc() int64 {
	if x != nil && x.XCreatedAtUnixTsUtc != nil {
		return *x.XCreatedAtUnixTsUtc
	}
	return 0
}

func (x *Pipeline) GetXUpdatedAtUnixTsUtc() int64 {
	if x != nil && x.XUpdatedAtUnixTsUtc != nil {
		return *x.XUpdatedAtUnixTsUtc
	}
	return 0
}

func (x *Pipeline) GetXCreatedBy() string {
	if x != nil && x.XCreatedBy != nil {
		return *x.XCreatedBy
	}
	return ""
}

// Conditions define how the SDK should handle a Wasm response in a step.
// Should it continue executing the pipeline, should it abort, should it notify
// and on_error.
// TODO: de-pluralize this name
type PipelineStepConditions struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Should we abort execution?
	Abort AbortCondition `protobuf:"varint,1,opt,name=abort,proto3,enum=protos.AbortCondition" json:"abort,omitempty"`
	// Deprecated: Marked as deprecated in sp_pipeline.proto.
	Notify bool `protobuf:"varint,2,opt,name=notify,proto3" json:"notify,omitempty"`
	// Should we include additional metadata that SDK should pass back to user?
	Metadata     map[string]string         `protobuf:"bytes,3,rep,name=metadata,proto3" json:"metadata,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	Notification *PipelineStepNotification `protobuf:"bytes,4,opt,name=notification,proto3" json:"notification,omitempty"`
}

func (x *PipelineStepConditions) Reset() {
	*x = PipelineStepConditions{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sp_pipeline_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineStepConditions) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineStepConditions) ProtoMessage() {}

func (x *PipelineStepConditions) ProtoReflect() protoreflect.Message {
	mi := &file_sp_pipeline_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineStepConditions.ProtoReflect.Descriptor instead.
func (*PipelineStepConditions) Descriptor() ([]byte, []int) {
	return file_sp_pipeline_proto_rawDescGZIP(), []int{1}
}

func (x *PipelineStepConditions) GetAbort() AbortCondition {
	if x != nil {
		return x.Abort
	}
	return AbortCondition_ABORT_CONDITION_UNSET
}

// Deprecated: Marked as deprecated in sp_pipeline.proto.
func (x *PipelineStepConditions) GetNotify() bool {
	if x != nil {
		return x.Notify
	}
	return false
}

func (x *PipelineStepConditions) GetMetadata() map[string]string {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *PipelineStepConditions) GetNotification() *PipelineStepNotification {
	if x != nil {
		return x.Notification
	}
	return nil
}

type PipelineStepNotification struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The UUIDs of the notification config to use
	// This is kept separate to avoid having to configure slack/email settings
	// every time and also because that config info is sensitive and is encrypted
	NotificationConfigIds []string                             `protobuf:"bytes,1,rep,name=notification_config_ids,json=notificationConfigIds,proto3" json:"notification_config_ids,omitempty"`
	PayloadType           PipelineStepNotification_PayloadType `protobuf:"varint,2,opt,name=payload_type,json=payloadType,proto3,enum=protos.PipelineStepNotification_PayloadType" json:"payload_type,omitempty"`
	// If type == paths, then we will look here for a list of json paths to include
	// in the notification payload.
	Paths []string `protobuf:"bytes,3,rep,name=paths,proto3" json:"paths,omitempty"`
}

func (x *PipelineStepNotification) Reset() {
	*x = PipelineStepNotification{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sp_pipeline_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineStepNotification) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineStepNotification) ProtoMessage() {}

func (x *PipelineStepNotification) ProtoReflect() protoreflect.Message {
	mi := &file_sp_pipeline_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineStepNotification.ProtoReflect.Descriptor instead.
func (*PipelineStepNotification) Descriptor() ([]byte, []int) {
	return file_sp_pipeline_proto_rawDescGZIP(), []int{2}
}

func (x *PipelineStepNotification) GetNotificationConfigIds() []string {
	if x != nil {
		return x.NotificationConfigIds
	}
	return nil
}

func (x *PipelineStepNotification) GetPayloadType() PipelineStepNotification_PayloadType {
	if x != nil {
		return x.PayloadType
	}
	return PipelineStepNotification_PAYLOAD_TYPE_UNSET
}

func (x *PipelineStepNotification) GetPaths() []string {
	if x != nil {
		return x.Paths
	}
	return nil
}

// A pipeline step is a single step in a pipeline.
type PipelineStep struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Friendly name for the step
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// SDKs should read this when Wasm returns 'true' to determine what to do next.
	OnTrue *PipelineStepConditions `protobuf:"bytes,2,opt,name=on_true,json=onTrue,proto3" json:"on_true,omitempty"`
	// SDKs should read this when Wasm returns 'false' to determine what to do next.
	OnFalse *PipelineStepConditions `protobuf:"bytes,3,opt,name=on_false,json=onFalse,proto3" json:"on_false,omitempty"`
	// Indicates whether to use the results from a previous step as input to this step
	Dynamic bool `protobuf:"varint,4,opt,name=dynamic,proto3" json:"dynamic,omitempty"`
	// SDKs should read this when Wasm returns 'error' to determine what to do next.
	OnError *PipelineStepConditions `protobuf:"bytes,5,opt,name=on_error,json=onError,proto3" json:"on_error,omitempty"`
	// Types that are assignable to Step:
	//
	//	*PipelineStep_Detective
	//	*PipelineStep_Transform
	//	*PipelineStep_Encode
	//	*PipelineStep_Decode
	//	*PipelineStep_Custom
	//	*PipelineStep_HttpRequest
	//	*PipelineStep_Kv
	//	*PipelineStep_InferSchema
	//	*PipelineStep_ValidJson
	//	*PipelineStep_SchemaValidation
	Step isPipelineStep_Step `protobuf_oneof:"step"`
	// Set by server UNLESS step is CustomStep
	XWasmId *string `protobuf:"bytes,10000,opt,name=_wasm_id,json=WasmId,proto3,oneof" json:"_wasm_id,omitempty"` // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	// Set by server
	XWasmBytes []byte `protobuf:"bytes,10001,opt,name=_wasm_bytes,json=WasmBytes,proto3,oneof" json:"_wasm_bytes,omitempty"` // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	// Set by server
	XWasmFunction *string `protobuf:"bytes,10002,opt,name=_wasm_function,json=WasmFunction,proto3,oneof" json:"_wasm_function,omitempty"` // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
}

func (x *PipelineStep) Reset() {
	*x = PipelineStep{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sp_pipeline_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineStep) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineStep) ProtoMessage() {}

func (x *PipelineStep) ProtoReflect() protoreflect.Message {
	mi := &file_sp_pipeline_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineStep.ProtoReflect.Descriptor instead.
func (*PipelineStep) Descriptor() ([]byte, []int) {
	return file_sp_pipeline_proto_rawDescGZIP(), []int{3}
}

func (x *PipelineStep) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *PipelineStep) GetOnTrue() *PipelineStepConditions {
	if x != nil {
		return x.OnTrue
	}
	return nil
}

func (x *PipelineStep) GetOnFalse() *PipelineStepConditions {
	if x != nil {
		return x.OnFalse
	}
	return nil
}

func (x *PipelineStep) GetDynamic() bool {
	if x != nil {
		return x.Dynamic
	}
	return false
}

func (x *PipelineStep) GetOnError() *PipelineStepConditions {
	if x != nil {
		return x.OnError
	}
	return nil
}

func (m *PipelineStep) GetStep() isPipelineStep_Step {
	if m != nil {
		return m.Step
	}
	return nil
}

func (x *PipelineStep) GetDetective() *steps.DetectiveStep {
	if x, ok := x.GetStep().(*PipelineStep_Detective); ok {
		return x.Detective
	}
	return nil
}

func (x *PipelineStep) GetTransform() *steps.TransformStep {
	if x, ok := x.GetStep().(*PipelineStep_Transform); ok {
		return x.Transform
	}
	return nil
}

func (x *PipelineStep) GetEncode() *steps.EncodeStep {
	if x, ok := x.GetStep().(*PipelineStep_Encode); ok {
		return x.Encode
	}
	return nil
}

func (x *PipelineStep) GetDecode() *steps.DecodeStep {
	if x, ok := x.GetStep().(*PipelineStep_Decode); ok {
		return x.Decode
	}
	return nil
}

func (x *PipelineStep) GetCustom() *steps.CustomStep {
	if x, ok := x.GetStep().(*PipelineStep_Custom); ok {
		return x.Custom
	}
	return nil
}

func (x *PipelineStep) GetHttpRequest() *steps.HttpRequestStep {
	if x, ok := x.GetStep().(*PipelineStep_HttpRequest); ok {
		return x.HttpRequest
	}
	return nil
}

func (x *PipelineStep) GetKv() *steps.KVStep {
	if x, ok := x.GetStep().(*PipelineStep_Kv); ok {
		return x.Kv
	}
	return nil
}

func (x *PipelineStep) GetInferSchema() *steps.InferSchemaStep {
	if x, ok := x.GetStep().(*PipelineStep_InferSchema); ok {
		return x.InferSchema
	}
	return nil
}

func (x *PipelineStep) GetValidJson() *steps.ValidJSONStep {
	if x, ok := x.GetStep().(*PipelineStep_ValidJson); ok {
		return x.ValidJson
	}
	return nil
}

func (x *PipelineStep) GetSchemaValidation() *steps.SchemaValidationStep {
	if x, ok := x.GetStep().(*PipelineStep_SchemaValidation); ok {
		return x.SchemaValidation
	}
	return nil
}

func (x *PipelineStep) GetXWasmId() string {
	if x != nil && x.XWasmId != nil {
		return *x.XWasmId
	}
	return ""
}

func (x *PipelineStep) GetXWasmBytes() []byte {
	if x != nil {
		return x.XWasmBytes
	}
	return nil
}

func (x *PipelineStep) GetXWasmFunction() string {
	if x != nil && x.XWasmFunction != nil {
		return *x.XWasmFunction
	}
	return ""
}

type isPipelineStep_Step interface {
	isPipelineStep_Step()
}

type PipelineStep_Detective struct {
	Detective *steps.DetectiveStep `protobuf:"bytes,1000,opt,name=detective,proto3,oneof"`
}

type PipelineStep_Transform struct {
	Transform *steps.TransformStep `protobuf:"bytes,1001,opt,name=transform,proto3,oneof"`
}

type PipelineStep_Encode struct {
	Encode *steps.EncodeStep `protobuf:"bytes,1002,opt,name=encode,proto3,oneof"`
}

type PipelineStep_Decode struct {
	Decode *steps.DecodeStep `protobuf:"bytes,1003,opt,name=decode,proto3,oneof"`
}

type PipelineStep_Custom struct {
	// If set, _wasm_id MUST be set
	Custom *steps.CustomStep `protobuf:"bytes,1004,opt,name=custom,proto3,oneof"`
}

type PipelineStep_HttpRequest struct {
	HttpRequest *steps.HttpRequestStep `protobuf:"bytes,1005,opt,name=http_request,json=httpRequest,proto3,oneof"`
}

type PipelineStep_Kv struct {
	Kv *steps.KVStep `protobuf:"bytes,1006,opt,name=kv,proto3,oneof"`
}

type PipelineStep_InferSchema struct {
	InferSchema *steps.InferSchemaStep `protobuf:"bytes,1007,opt,name=infer_schema,json=inferSchema,proto3,oneof"`
}

type PipelineStep_ValidJson struct {
	ValidJson *steps.ValidJSONStep `protobuf:"bytes,1008,opt,name=valid_json,json=validJson,proto3,oneof"`
}

type PipelineStep_SchemaValidation struct {
	SchemaValidation *steps.SchemaValidationStep `protobuf:"bytes,1009,opt,name=schema_validation,json=schemaValidation,proto3,oneof"`
}

func (*PipelineStep_Detective) isPipelineStep_Step() {}

func (*PipelineStep_Transform) isPipelineStep_Step() {}

func (*PipelineStep_Encode) isPipelineStep_Step() {}

func (*PipelineStep_Decode) isPipelineStep_Step() {}

func (*PipelineStep_Custom) isPipelineStep_Step() {}

func (*PipelineStep_HttpRequest) isPipelineStep_Step() {}

func (*PipelineStep_Kv) isPipelineStep_Step() {}

func (*PipelineStep_InferSchema) isPipelineStep_Step() {}

func (*PipelineStep_ValidJson) isPipelineStep_Step() {}

func (*PipelineStep_SchemaValidation) isPipelineStep_Step() {}

// PipelineConfigs is stored encoded in redis:streamdal_audience:$audStr; it is
// also used in external.GetAllResponse:config.
type PipelineConfigs struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Configs []*PipelineConfig `protobuf:"bytes,1,rep,name=configs,proto3" json:"configs,omitempty"`
	// !!!!!!!! IMPORTANT !!!!!!!!!!
	//
	// For internal use only in server. We need this because marshalling/encoding
	// an empty protobuf results in nil. If someone does a SetPipelines() with
	// empty pipeline IDs - we will set this, so that the encoded protobuf gets
	// written as the actual object and not nil.
	XIsEmpty *bool `protobuf:"varint,1000,opt,name=_is_empty,json=IsEmpty,proto3,oneof" json:"_is_empty,omitempty"` // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
	// Used internally by server and k8s operator to determine who manages this resource/mapping
	XCreatedBy *string `protobuf:"bytes,1001,opt,name=_created_by,json=CreatedBy,proto3,oneof" json:"_created_by,omitempty"` // protolint:disable:this FIELD_NAMES_LOWER_SNAKE_CASE
}

func (x *PipelineConfigs) Reset() {
	*x = PipelineConfigs{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sp_pipeline_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineConfigs) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineConfigs) ProtoMessage() {}

func (x *PipelineConfigs) ProtoReflect() protoreflect.Message {
	mi := &file_sp_pipeline_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineConfigs.ProtoReflect.Descriptor instead.
func (*PipelineConfigs) Descriptor() ([]byte, []int) {
	return file_sp_pipeline_proto_rawDescGZIP(), []int{4}
}

func (x *PipelineConfigs) GetConfigs() []*PipelineConfig {
	if x != nil {
		return x.Configs
	}
	return nil
}

func (x *PipelineConfigs) GetXIsEmpty() bool {
	if x != nil && x.XIsEmpty != nil {
		return *x.XIsEmpty
	}
	return false
}

func (x *PipelineConfigs) GetXCreatedBy() string {
	if x != nil && x.XCreatedBy != nil {
		return *x.XCreatedBy
	}
	return ""
}

// PipelineConfig is structure used in protos.PipelineConfigs
type PipelineConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Id                 string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	Paused             bool   `protobuf:"varint,2,opt,name=paused,proto3" json:"paused,omitempty"`
	CreatedAtUnixTsUtc int64  `protobuf:"varint,3,opt,name=created_at_unix_ts_utc,json=createdAtUnixTsUtc,proto3" json:"created_at_unix_ts_utc,omitempty"`
}

func (x *PipelineConfig) Reset() {
	*x = PipelineConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_sp_pipeline_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *PipelineConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*PipelineConfig) ProtoMessage() {}

func (x *PipelineConfig) ProtoReflect() protoreflect.Message {
	mi := &file_sp_pipeline_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use PipelineConfig.ProtoReflect.Descriptor instead.
func (*PipelineConfig) Descriptor() ([]byte, []int) {
	return file_sp_pipeline_proto_rawDescGZIP(), []int{5}
}

func (x *PipelineConfig) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *PipelineConfig) GetPaused() bool {
	if x != nil {
		return x.Paused
	}
	return false
}

func (x *PipelineConfig) GetCreatedAtUnixTsUtc() int64 {
	if x != nil {
		return x.CreatedAtUnixTsUtc
	}
	return 0
}

var File_sp_pipeline_proto protoreflect.FileDescriptor

var file_sp_pipeline_proto_rawDesc = []byte{
	0x0a, 0x11, 0x73, 0x70, 0x5f, 0x70, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x1a, 0x0f, 0x73, 0x70, 0x5f,
	0x6e, 0x6f, 0x74, 0x69, 0x66, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x73, 0x74,
	0x65, 0x70, 0x73, 0x2f, 0x73, 0x70, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x63, 0x75, 0x73,
	0x74, 0x6f, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x73, 0x74, 0x65, 0x70, 0x73,
	0x2f, 0x73, 0x70, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x63, 0x6f, 0x64, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2f, 0x73, 0x70,
	0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2f, 0x73, 0x70,
	0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2f, 0x73, 0x70, 0x5f, 0x73, 0x74,
	0x65, 0x70, 0x73, 0x5f, 0x68, 0x74, 0x74, 0x70, 0x72, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2f, 0x73, 0x70, 0x5f,
	0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x73, 0x63, 0x68, 0x65, 0x6d,
	0x61, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x17, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2f, 0x73,
	0x70, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x6b, 0x76, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x1a, 0x26, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2f, 0x73, 0x70, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73,
	0x5f, 0x73, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2f,
	0x73, 0x70, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x74, 0x72, 0x61, 0x6e, 0x73, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2f,
	0x73, 0x70, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x73, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x5f, 0x6a,
	0x73, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x84, 0x05, 0x0a, 0x08, 0x50, 0x69,
	0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x2a, 0x0a, 0x05, 0x73, 0x74,
	0x65, 0x70, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x73, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x65, 0x70, 0x52,
	0x05, 0x73, 0x74, 0x65, 0x70, 0x73, 0x12, 0x52, 0x0a, 0x15, 0x5f, 0x6e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x18,
	0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x4e,
	0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x42, 0x02, 0x18, 0x01, 0x52, 0x13, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x3b, 0x0a, 0x0b, 0x64, 0x61,
	0x74, 0x61, 0x5f, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x1a, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e,
	0x65, 0x44, 0x61, 0x74, 0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x0a, 0x64, 0x61, 0x74,
	0x61, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1d, 0x0a, 0x07, 0x5f, 0x70, 0x61, 0x75, 0x73,
	0x65, 0x64, 0x18, 0xe8, 0x07, 0x20, 0x01, 0x28, 0x08, 0x48, 0x00, 0x52, 0x06, 0x50, 0x61, 0x75,
	0x73, 0x65, 0x64, 0x88, 0x01, 0x01, 0x12, 0x27, 0x0a, 0x0c, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72,
	0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52,
	0x0b, 0x44, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x12,
	0x1f, 0x0a, 0x08, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0xea, 0x07, 0x20, 0x01,
	0x28, 0x09, 0x48, 0x02, 0x52, 0x07, 0x56, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01,
	0x12, 0x17, 0x0a, 0x04, 0x5f, 0x75, 0x72, 0x6c, 0x18, 0xeb, 0x07, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x03, 0x52, 0x03, 0x55, 0x72, 0x6c, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x17, 0x5f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x74, 0x73,
	0x5f, 0x75, 0x74, 0x63, 0x18, 0xec, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48, 0x04, 0x52, 0x12, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x55, 0x6e, 0x69, 0x78, 0x54, 0x73, 0x55, 0x74,
	0x63, 0x88, 0x01, 0x01, 0x12, 0x39, 0x0a, 0x17, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x64,
	0x5f, 0x61, 0x74, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x74, 0x73, 0x5f, 0x75, 0x74, 0x63, 0x18,
	0xed, 0x07, 0x20, 0x01, 0x28, 0x03, 0x48, 0x05, 0x52, 0x12, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x41, 0x74, 0x55, 0x6e, 0x69, 0x78, 0x54, 0x73, 0x55, 0x74, 0x63, 0x88, 0x01, 0x01, 0x12,
	0x24, 0x0a, 0x0b, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0xee,
	0x07, 0x20, 0x01, 0x28, 0x09, 0x48, 0x06, 0x52, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64,
	0x42, 0x79, 0x88, 0x01, 0x01, 0x42, 0x0a, 0x0a, 0x08, 0x58, 0x5f, 0x70, 0x61, 0x75, 0x73, 0x65,
	0x64, 0x42, 0x0f, 0x0a, 0x0d, 0x58, 0x5f, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69,
	0x6f, 0x6e, 0x42, 0x0b, 0x0a, 0x09, 0x58, 0x5f, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e, 0x42,
	0x07, 0x0a, 0x05, 0x58, 0x5f, 0x75, 0x72, 0x6c, 0x42, 0x1a, 0x0a, 0x18, 0x58, 0x5f, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x74, 0x73,
	0x5f, 0x75, 0x74, 0x63, 0x42, 0x1a, 0x0a, 0x18, 0x58, 0x5f, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x64, 0x5f, 0x61, 0x74, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f, 0x74, 0x73, 0x5f, 0x75, 0x74, 0x63,
	0x42, 0x0e, 0x0a, 0x0c, 0x58, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79,
	0x22, 0xaf, 0x02, 0x0a, 0x16, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x65,
	0x70, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x2c, 0x0a, 0x05, 0x61,
	0x62, 0x6f, 0x72, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x16, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x73, 0x2e, 0x41, 0x62, 0x6f, 0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x05, 0x61, 0x62, 0x6f, 0x72, 0x74, 0x12, 0x1a, 0x0a, 0x06, 0x6e, 0x6f, 0x74,
	0x69, 0x66, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x08, 0x42, 0x02, 0x18, 0x01, 0x52, 0x06, 0x6e,
	0x6f, 0x74, 0x69, 0x66, 0x79, 0x12, 0x48, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73,
	0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61,
	0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12,
	0x44, 0x0a, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x50,
	0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x65, 0x70, 0x4e, 0x6f, 0x74, 0x69, 0x66,
	0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x0c, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x1a, 0x3b, 0x0a, 0x0d, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02,
	0x38, 0x01, 0x22, 0xb8, 0x02, 0x0a, 0x18, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53,
	0x74, 0x65, 0x70, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x36, 0x0a, 0x17, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x15, 0x6e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x49, 0x64, 0x73, 0x12, 0x4f, 0x0a, 0x0c, 0x70, 0x61, 0x79, 0x6c, 0x6f,
	0x61, 0x64, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2c, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53,
	0x74, 0x65, 0x70, 0x4e, 0x6f, 0x74, 0x69, 0x66, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e,
	0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x79, 0x70, 0x65, 0x52, 0x0b, 0x70, 0x61, 0x79,
	0x6c, 0x6f, 0x61, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x05, 0x70, 0x61, 0x74, 0x68,
	0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x70, 0x61, 0x74, 0x68, 0x73, 0x22, 0x7d,
	0x0a, 0x0b, 0x50, 0x61, 0x79, 0x6c, 0x6f, 0x61, 0x64, 0x54, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a,
	0x12, 0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x45, 0x54, 0x10, 0x00, 0x12, 0x18, 0x0a, 0x14, 0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41, 0x44,
	0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x45, 0x58, 0x43, 0x4c, 0x55, 0x44, 0x45, 0x10, 0x01, 0x12,
	0x1d, 0x0a, 0x19, 0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f,
	0x46, 0x55, 0x4c, 0x4c, 0x5f, 0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41, 0x44, 0x10, 0x02, 0x12, 0x1d,
	0x0a, 0x19, 0x50, 0x41, 0x59, 0x4c, 0x4f, 0x41, 0x44, 0x5f, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x53,
	0x45, 0x4c, 0x45, 0x43, 0x54, 0x5f, 0x50, 0x41, 0x54, 0x48, 0x53, 0x10, 0x03, 0x22, 0xf6, 0x07,
	0x0a, 0x0c, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x65, 0x70, 0x12, 0x12,
	0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e, 0x61,
	0x6d, 0x65, 0x12, 0x37, 0x0a, 0x07, 0x6f, 0x6e, 0x5f, 0x74, 0x72, 0x75, 0x65, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x50, 0x69, 0x70,
	0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x52, 0x06, 0x6f, 0x6e, 0x54, 0x72, 0x75, 0x65, 0x12, 0x39, 0x0a, 0x08, 0x6f,
	0x6e, 0x5f, 0x66, 0x61, 0x6c, 0x73, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x53,
	0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x52, 0x07, 0x6f,
	0x6e, 0x46, 0x61, 0x6c, 0x73, 0x65, 0x12, 0x18, 0x0a, 0x07, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69,
	0x63, 0x18, 0x04, 0x20, 0x01, 0x28, 0x08, 0x52, 0x07, 0x64, 0x79, 0x6e, 0x61, 0x6d, 0x69, 0x63,
	0x12, 0x39, 0x0a, 0x08, 0x6f, 0x6e, 0x5f, 0x65, 0x72, 0x72, 0x6f, 0x72, 0x18, 0x05, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x50, 0x69, 0x70, 0x65,
	0x6c, 0x69, 0x6e, 0x65, 0x53, 0x74, 0x65, 0x70, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x52, 0x07, 0x6f, 0x6e, 0x45, 0x72, 0x72, 0x6f, 0x72, 0x12, 0x3c, 0x0a, 0x09, 0x64,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0xe8, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2e, 0x44,
	0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x09,
	0x64, 0x65, 0x74, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x12, 0x3c, 0x0a, 0x09, 0x74, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x18, 0xe9, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2e, 0x54, 0x72, 0x61,
	0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x09, 0x74, 0x72,
	0x61, 0x6e, 0x73, 0x66, 0x6f, 0x72, 0x6d, 0x12, 0x33, 0x0a, 0x06, 0x65, 0x6e, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0xea, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2e, 0x45, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x53, 0x74,
	0x65, 0x70, 0x48, 0x00, 0x52, 0x06, 0x65, 0x6e, 0x63, 0x6f, 0x64, 0x65, 0x12, 0x33, 0x0a, 0x06,
	0x64, 0x65, 0x63, 0x6f, 0x64, 0x65, 0x18, 0xeb, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x18, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2e, 0x44, 0x65, 0x63,
	0x6f, 0x64, 0x65, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x06, 0x64, 0x65, 0x63, 0x6f, 0x64,
	0x65, 0x12, 0x33, 0x0a, 0x06, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x18, 0xec, 0x07, 0x20, 0x01,
	0x28, 0x0b, 0x32, 0x18, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74, 0x65, 0x70,
	0x73, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x06,
	0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x12, 0x43, 0x0a, 0x0c, 0x68, 0x74, 0x74, 0x70, 0x5f, 0x72,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x18, 0xed, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2e, 0x48, 0x74, 0x74,
	0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x0b,
	0x68, 0x74, 0x74, 0x70, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x27, 0x0a, 0x02, 0x6b,
	0x76, 0x18, 0xee, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x14, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x73, 0x2e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2e, 0x4b, 0x56, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00,
	0x52, 0x02, 0x6b, 0x76, 0x12, 0x43, 0x0a, 0x0c, 0x69, 0x6e, 0x66, 0x65, 0x72, 0x5f, 0x73, 0x63,
	0x68, 0x65, 0x6d, 0x61, 0x18, 0xef, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2e, 0x49, 0x6e, 0x66, 0x65, 0x72,
	0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x0b, 0x69, 0x6e,
	0x66, 0x65, 0x72, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x12, 0x3d, 0x0a, 0x0a, 0x76, 0x61, 0x6c,
	0x69, 0x64, 0x5f, 0x6a, 0x73, 0x6f, 0x6e, 0x18, 0xf0, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74, 0x65, 0x70, 0x73, 0x2e, 0x56, 0x61,
	0x6c, 0x69, 0x64, 0x4a, 0x53, 0x4f, 0x4e, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x09, 0x76,
	0x61, 0x6c, 0x69, 0x64, 0x4a, 0x73, 0x6f, 0x6e, 0x12, 0x52, 0x0a, 0x11, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x5f, 0x76, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0xf1, 0x07,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x73, 0x74,
	0x65, 0x70, 0x73, 0x2e, 0x53, 0x63, 0x68, 0x65, 0x6d, 0x61, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61,
	0x74, 0x69, 0x6f, 0x6e, 0x53, 0x74, 0x65, 0x70, 0x48, 0x00, 0x52, 0x10, 0x73, 0x63, 0x68, 0x65,
	0x6d, 0x61, 0x56, 0x61, 0x6c, 0x69, 0x64, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x1e, 0x0a, 0x08,
	0x5f, 0x77, 0x61, 0x73, 0x6d, 0x5f, 0x69, 0x64, 0x18, 0x90, 0x4e, 0x20, 0x01, 0x28, 0x09, 0x48,
	0x01, 0x52, 0x06, 0x57, 0x61, 0x73, 0x6d, 0x49, 0x64, 0x88, 0x01, 0x01, 0x12, 0x24, 0x0a, 0x0b,
	0x5f, 0x77, 0x61, 0x73, 0x6d, 0x5f, 0x62, 0x79, 0x74, 0x65, 0x73, 0x18, 0x91, 0x4e, 0x20, 0x01,
	0x28, 0x0c, 0x48, 0x02, 0x52, 0x09, 0x57, 0x61, 0x73, 0x6d, 0x42, 0x79, 0x74, 0x65, 0x73, 0x88,
	0x01, 0x01, 0x12, 0x2a, 0x0a, 0x0e, 0x5f, 0x77, 0x61, 0x73, 0x6d, 0x5f, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x18, 0x92, 0x4e, 0x20, 0x01, 0x28, 0x09, 0x48, 0x03, 0x52, 0x0c, 0x57,
	0x61, 0x73, 0x6d, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x88, 0x01, 0x01, 0x42, 0x06,
	0x0a, 0x04, 0x73, 0x74, 0x65, 0x70, 0x42, 0x0b, 0x0a, 0x09, 0x58, 0x5f, 0x77, 0x61, 0x73, 0x6d,
	0x5f, 0x69, 0x64, 0x42, 0x0e, 0x0a, 0x0c, 0x58, 0x5f, 0x77, 0x61, 0x73, 0x6d, 0x5f, 0x62, 0x79,
	0x74, 0x65, 0x73, 0x42, 0x11, 0x0a, 0x0f, 0x58, 0x5f, 0x77, 0x61, 0x73, 0x6d, 0x5f, 0x66, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0xa9, 0x01, 0x0a, 0x0f, 0x50, 0x69, 0x70, 0x65, 0x6c,
	0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x30, 0x0a, 0x07, 0x63, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x16, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x73, 0x2e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x73, 0x12, 0x20, 0x0a, 0x09,
	0x5f, 0x69, 0x73, 0x5f, 0x65, 0x6d, 0x70, 0x74, 0x79, 0x18, 0xe8, 0x07, 0x20, 0x01, 0x28, 0x08,
	0x48, 0x00, 0x52, 0x07, 0x49, 0x73, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x88, 0x01, 0x01, 0x12, 0x24,
	0x0a, 0x0b, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x62, 0x79, 0x18, 0xe9, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x48, 0x01, 0x52, 0x09, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x42,
	0x79, 0x88, 0x01, 0x01, 0x42, 0x0c, 0x0a, 0x0a, 0x58, 0x5f, 0x69, 0x73, 0x5f, 0x65, 0x6d, 0x70,
	0x74, 0x79, 0x42, 0x0e, 0x0a, 0x0c, 0x58, 0x5f, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f,
	0x62, 0x79, 0x22, 0x6c, 0x0a, 0x0e, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x02, 0x69, 0x64, 0x12, 0x16, 0x0a, 0x06, 0x70, 0x61, 0x75, 0x73, 0x65, 0x64, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x70, 0x61, 0x75, 0x73, 0x65, 0x64, 0x12, 0x32, 0x0a, 0x16,
	0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x5f, 0x61, 0x74, 0x5f, 0x75, 0x6e, 0x69, 0x78, 0x5f,
	0x74, 0x73, 0x5f, 0x75, 0x74, 0x63, 0x18, 0x03, 0x20, 0x01, 0x28, 0x03, 0x52, 0x12, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x41, 0x74, 0x55, 0x6e, 0x69, 0x78, 0x54, 0x73, 0x55, 0x74, 0x63,
	0x2a, 0x77, 0x0a, 0x12, 0x50, 0x69, 0x70, 0x65, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x1e, 0x0a, 0x1a, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49,
	0x4e, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55,
	0x4e, 0x53, 0x45, 0x54, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49,
	0x4e, 0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x4a,
	0x53, 0x4f, 0x4e, 0x10, 0x01, 0x12, 0x22, 0x0a, 0x1e, 0x50, 0x49, 0x50, 0x45, 0x4c, 0x49, 0x4e,
	0x45, 0x5f, 0x44, 0x41, 0x54, 0x41, 0x5f, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x50, 0x4c,
	0x41, 0x49, 0x4e, 0x54, 0x45, 0x58, 0x54, 0x10, 0x02, 0x2a, 0x6d, 0x0a, 0x0e, 0x41, 0x62, 0x6f,
	0x72, 0x74, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x19, 0x0a, 0x15, 0x41,
	0x42, 0x4f, 0x52, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55,
	0x4e, 0x53, 0x45, 0x54, 0x10, 0x00, 0x12, 0x21, 0x0a, 0x1d, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x5f,
	0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x42, 0x4f, 0x52, 0x54, 0x5f,
	0x43, 0x55, 0x52, 0x52, 0x45, 0x4e, 0x54, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x41, 0x42, 0x4f,
	0x52, 0x54, 0x5f, 0x43, 0x4f, 0x4e, 0x44, 0x49, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x41, 0x42, 0x4f,
	0x52, 0x54, 0x5f, 0x41, 0x4c, 0x4c, 0x10, 0x02, 0x42, 0x50, 0x5a, 0x3a, 0x67, 0x69, 0x74, 0x68,
	0x75, 0x62, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x64, 0x61, 0x6c,
	0x2f, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x64, 0x61, 0x6c, 0x2f, 0x6c, 0x69, 0x62, 0x73, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x2f, 0x62, 0x75, 0x69, 0x6c, 0x64, 0x2f, 0x67, 0x6f, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0xea, 0x02, 0x11, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x64,
	0x61, 0x6c, 0x3a, 0x3a, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x73, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_sp_pipeline_proto_rawDescOnce sync.Once
	file_sp_pipeline_proto_rawDescData = file_sp_pipeline_proto_rawDesc
)

func file_sp_pipeline_proto_rawDescGZIP() []byte {
	file_sp_pipeline_proto_rawDescOnce.Do(func() {
		file_sp_pipeline_proto_rawDescData = protoimpl.X.CompressGZIP(file_sp_pipeline_proto_rawDescData)
	})
	return file_sp_pipeline_proto_rawDescData
}

var file_sp_pipeline_proto_enumTypes = make([]protoimpl.EnumInfo, 3)
var file_sp_pipeline_proto_msgTypes = make([]protoimpl.MessageInfo, 7)
var file_sp_pipeline_proto_goTypes = []interface{}{
	(PipelineDataFormat)(0),                   // 0: protos.PipelineDataFormat
	(AbortCondition)(0),                       // 1: protos.AbortCondition
	(PipelineStepNotification_PayloadType)(0), // 2: protos.PipelineStepNotification.PayloadType
	(*Pipeline)(nil),                          // 3: protos.Pipeline
	(*PipelineStepConditions)(nil),            // 4: protos.PipelineStepConditions
	(*PipelineStepNotification)(nil),          // 5: protos.PipelineStepNotification
	(*PipelineStep)(nil),                      // 6: protos.PipelineStep
	(*PipelineConfigs)(nil),                   // 7: protos.PipelineConfigs
	(*PipelineConfig)(nil),                    // 8: protos.PipelineConfig
	nil,                                       // 9: protos.PipelineStepConditions.MetadataEntry
	(*NotificationConfig)(nil),                // 10: protos.NotificationConfig
	(*steps.DetectiveStep)(nil),               // 11: protos.steps.DetectiveStep
	(*steps.TransformStep)(nil),               // 12: protos.steps.TransformStep
	(*steps.EncodeStep)(nil),                  // 13: protos.steps.EncodeStep
	(*steps.DecodeStep)(nil),                  // 14: protos.steps.DecodeStep
	(*steps.CustomStep)(nil),                  // 15: protos.steps.CustomStep
	(*steps.HttpRequestStep)(nil),             // 16: protos.steps.HttpRequestStep
	(*steps.KVStep)(nil),                      // 17: protos.steps.KVStep
	(*steps.InferSchemaStep)(nil),             // 18: protos.steps.InferSchemaStep
	(*steps.ValidJSONStep)(nil),               // 19: protos.steps.ValidJSONStep
	(*steps.SchemaValidationStep)(nil),        // 20: protos.steps.SchemaValidationStep
}
var file_sp_pipeline_proto_depIdxs = []int32{
	6,  // 0: protos.Pipeline.steps:type_name -> protos.PipelineStep
	10, // 1: protos.Pipeline._notification_configs:type_name -> protos.NotificationConfig
	0,  // 2: protos.Pipeline.data_format:type_name -> protos.PipelineDataFormat
	1,  // 3: protos.PipelineStepConditions.abort:type_name -> protos.AbortCondition
	9,  // 4: protos.PipelineStepConditions.metadata:type_name -> protos.PipelineStepConditions.MetadataEntry
	5,  // 5: protos.PipelineStepConditions.notification:type_name -> protos.PipelineStepNotification
	2,  // 6: protos.PipelineStepNotification.payload_type:type_name -> protos.PipelineStepNotification.PayloadType
	4,  // 7: protos.PipelineStep.on_true:type_name -> protos.PipelineStepConditions
	4,  // 8: protos.PipelineStep.on_false:type_name -> protos.PipelineStepConditions
	4,  // 9: protos.PipelineStep.on_error:type_name -> protos.PipelineStepConditions
	11, // 10: protos.PipelineStep.detective:type_name -> protos.steps.DetectiveStep
	12, // 11: protos.PipelineStep.transform:type_name -> protos.steps.TransformStep
	13, // 12: protos.PipelineStep.encode:type_name -> protos.steps.EncodeStep
	14, // 13: protos.PipelineStep.decode:type_name -> protos.steps.DecodeStep
	15, // 14: protos.PipelineStep.custom:type_name -> protos.steps.CustomStep
	16, // 15: protos.PipelineStep.http_request:type_name -> protos.steps.HttpRequestStep
	17, // 16: protos.PipelineStep.kv:type_name -> protos.steps.KVStep
	18, // 17: protos.PipelineStep.infer_schema:type_name -> protos.steps.InferSchemaStep
	19, // 18: protos.PipelineStep.valid_json:type_name -> protos.steps.ValidJSONStep
	20, // 19: protos.PipelineStep.schema_validation:type_name -> protos.steps.SchemaValidationStep
	8,  // 20: protos.PipelineConfigs.configs:type_name -> protos.PipelineConfig
	21, // [21:21] is the sub-list for method output_type
	21, // [21:21] is the sub-list for method input_type
	21, // [21:21] is the sub-list for extension type_name
	21, // [21:21] is the sub-list for extension extendee
	0,  // [0:21] is the sub-list for field type_name
}

func init() { file_sp_pipeline_proto_init() }
func file_sp_pipeline_proto_init() {
	if File_sp_pipeline_proto != nil {
		return
	}
	file_sp_notify_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_sp_pipeline_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Pipeline); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sp_pipeline_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineStepConditions); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sp_pipeline_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineStepNotification); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sp_pipeline_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineStep); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sp_pipeline_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineConfigs); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_sp_pipeline_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*PipelineConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_sp_pipeline_proto_msgTypes[0].OneofWrappers = []interface{}{}
	file_sp_pipeline_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*PipelineStep_Detective)(nil),
		(*PipelineStep_Transform)(nil),
		(*PipelineStep_Encode)(nil),
		(*PipelineStep_Decode)(nil),
		(*PipelineStep_Custom)(nil),
		(*PipelineStep_HttpRequest)(nil),
		(*PipelineStep_Kv)(nil),
		(*PipelineStep_InferSchema)(nil),
		(*PipelineStep_ValidJson)(nil),
		(*PipelineStep_SchemaValidation)(nil),
	}
	file_sp_pipeline_proto_msgTypes[4].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_sp_pipeline_proto_rawDesc,
			NumEnums:      3,
			NumMessages:   7,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_sp_pipeline_proto_goTypes,
		DependencyIndexes: file_sp_pipeline_proto_depIdxs,
		EnumInfos:         file_sp_pipeline_proto_enumTypes,
		MessageInfos:      file_sp_pipeline_proto_msgTypes,
	}.Build()
	File_sp_pipeline_proto = out.File
	file_sp_pipeline_proto_rawDesc = nil
	file_sp_pipeline_proto_goTypes = nil
	file_sp_pipeline_proto_depIdxs = nil
}
