// Code generated by github.com/abhimanyu003/sttr/cmd/generate.go. DO NOT EDIT

package cmd

import (
	"fmt"
	"os"

	"github.com/abhimanyu003/sttr/processors"
	"github.com/abhimanyu003/sttr/utils"
	"github.com/spf13/cobra"
)

var morseDecode_flag_l string

func init() {
	morseDecodeCmd.Flags().StringVarP(&morseDecode_flag_l, "lang", "l", "la", "Morse code set to decode [la(Latin), ru(Cyrillic), gr(Greek), he(Hebrew), ar(Arabic), ja(Japanese), kr(Korean), th(Thai)]")
	rootCmd.AddCommand(morseDecodeCmd)
}

var morseDecodeCmd = &cobra.Command{
	Use:     "morse-decode [string]",
	Short:   "Decode Morse Code to text",
	Aliases: []string{"morse-dec", "morse-decode", "morse-code-decode", "morse-code-dec"},
	Args:    cobra.MaximumNArgs(1),
	RunE: func(cmd *cobra.Command, args []string) error {
		var err error
		var out string

		flags := make([]processors.Flag, 0)
		p := processors.MorseCodeDecode{}
		flags = append(flags, processors.Flag{Short: "l", Value: morseDecode_flag_l})

		if len(args) == 0 {
			// Handle stdin/interactive input
			in := []byte(utils.ReadMultilineInput())
			out, err = p.Transform(in, flags...)
			if err != nil {
				return err
			}
		} else {
			// Check if it's a file
			if fi, err := os.Stat(args[0]); err == nil && !fi.IsDir() {
				// It's a file - check if we should use streaming
				const largeFileThreshold = 10 * 1024 * 1024 // 10MB
				
				// Use central streaming function for all processors
				if processors.CanStream(p) && (fi.Size() > largeFileThreshold || processors.PreferStream(p)) {
					// Use streaming
					file, err := os.Open(args[0])
					if err != nil {
						return err
					}
					defer file.Close()
					
					err = processors.TransformStream(p, file, os.Stdout, flags...)
					return err
				} else {
					// Use traditional method for small files
					d, err := os.ReadFile(args[0])
					if err != nil {
						return err
					}
					out, err = p.Transform(d, flags...)
					if err != nil {
						return err
					}
				}
			} else {
				// Not a file, treat as string input
				out, err = p.Transform([]byte(args[0]), flags...)
				if err != nil {
					return err
				}
			}
		}

		_, err = fmt.Fprint(os.Stdout, out)
		return err
	},
}
