"""Generated client library for cloudnumberregistry version v1alpha."""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.py import base_api
from googlecloudsdk.generated_clients.apis.cloudnumberregistry.v1alpha import cloudnumberregistry_v1alpha_messages as messages


class CloudnumberregistryV1alpha(base_api.BaseApiClient):
  """Generated client library for service cloudnumberregistry version v1alpha."""

  MESSAGES_MODULE = messages
  BASE_URL = 'https://cloudnumberregistry.googleapis.com/'
  MTLS_BASE_URL = 'https://cloudnumberregistry.mtls.googleapis.com/'

  _PACKAGE = 'cloudnumberregistry'
  _SCOPES = ['https://www.googleapis.com/auth/cloud-platform']
  _VERSION = 'v1alpha'
  _CLIENT_ID = 'CLIENT_ID'
  _CLIENT_SECRET = 'CLIENT_SECRET'
  _USER_AGENT = 'google-cloud-sdk'
  _CLIENT_CLASS_NAME = 'CloudnumberregistryV1alpha'
  _URL_VERSION = 'v1alpha'
  _API_KEY = None

  def __init__(self, url='', credentials=None,
               get_credentials=True, http=None, model=None,
               log_request=False, log_response=False,
               credentials_args=None, default_global_params=None,
               additional_http_headers=None, response_encoding=None):
    """Create a new cloudnumberregistry handle."""
    url = url or self.BASE_URL
    super(CloudnumberregistryV1alpha, self).__init__(
        url, credentials=credentials,
        get_credentials=get_credentials, http=http, model=model,
        log_request=log_request, log_response=log_response,
        credentials_args=credentials_args,
        default_global_params=default_global_params,
        additional_http_headers=additional_http_headers,
        response_encoding=response_encoding)
    self.projects_locations_customRanges = self.ProjectsLocationsCustomRangesService(self)
    self.projects_locations_discoveredRanges = self.ProjectsLocationsDiscoveredRangesService(self)
    self.projects_locations_ipamAdminScopes = self.ProjectsLocationsIpamAdminScopesService(self)
    self.projects_locations_operations = self.ProjectsLocationsOperationsService(self)
    self.projects_locations_realms = self.ProjectsLocationsRealmsService(self)
    self.projects_locations_registryBooks = self.ProjectsLocationsRegistryBooksService(self)
    self.projects_locations = self.ProjectsLocationsService(self)
    self.projects = self.ProjectsService(self)

  class ProjectsLocationsCustomRangesService(base_api.BaseApiService):
    """Service class for the projects_locations_customRanges resource."""

    _NAME = 'projects_locations_customRanges'

    def __init__(self, client):
      super(CloudnumberregistryV1alpha.ProjectsLocationsCustomRangesService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new CustomRange in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsCustomRangesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/customRanges',
        http_method='POST',
        method_id='cloudnumberregistry.projects.locations.customRanges.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['customRangeId', 'requestId'],
        relative_path='v1alpha/{+parent}/customRanges',
        request_field='customRange',
        request_type_name='CloudnumberregistryProjectsLocationsCustomRangesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single CustomRange.

      Args:
        request: (CloudnumberregistryProjectsLocationsCustomRangesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/customRanges/{customRangesId}',
        http_method='DELETE',
        method_id='cloudnumberregistry.projects.locations.customRanges.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsCustomRangesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def FindFreeIpRanges(self, request, global_params=None):
      r"""Finds free IP ranges in a single CustomRange.

      Args:
        request: (CloudnumberregistryProjectsLocationsCustomRangesFindFreeIpRangesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FindCustomRangeFreeIpRangesResponse) The response message.
      """
      config = self.GetMethodConfig('FindFreeIpRanges')
      return self._RunMethod(
          config, request, global_params=global_params)

    FindFreeIpRanges.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/customRanges/{customRangesId}:findFreeIpRanges',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.customRanges.findFreeIpRanges',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['cidrPrefixLength', 'rangeCount', 'requestId'],
        relative_path='v1alpha/{+name}:findFreeIpRanges',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsCustomRangesFindFreeIpRangesRequest',
        response_type_name='FindCustomRangeFreeIpRangesResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single CustomRange.

      Args:
        request: (CloudnumberregistryProjectsLocationsCustomRangesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CustomRange) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/customRanges/{customRangesId}',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.customRanges.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsCustomRangesGetRequest',
        response_type_name='CustomRange',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists CustomRanges in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsCustomRangesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListCustomRangesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/customRanges',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.customRanges.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/customRanges',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsCustomRangesListRequest',
        response_type_name='ListCustomRangesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single CustomRange.

      Args:
        request: (CloudnumberregistryProjectsLocationsCustomRangesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/customRanges/{customRangesId}',
        http_method='PATCH',
        method_id='cloudnumberregistry.projects.locations.customRanges.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='customRange',
        request_type_name='CloudnumberregistryProjectsLocationsCustomRangesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def ShowUtilization(self, request, global_params=None):
      r"""Gets the details of a single CustomRange and its utilization.

      Args:
        request: (CloudnumberregistryProjectsLocationsCustomRangesShowUtilizationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ShowCustomRangeUtilizationResponse) The response message.
      """
      config = self.GetMethodConfig('ShowUtilization')
      return self._RunMethod(
          config, request, global_params=global_params)

    ShowUtilization.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/customRanges/{customRangesId}:showUtilization',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.customRanges.showUtilization',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:showUtilization',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsCustomRangesShowUtilizationRequest',
        response_type_name='ShowCustomRangeUtilizationResponse',
        supports_download=False,
    )

  class ProjectsLocationsDiscoveredRangesService(base_api.BaseApiService):
    """Service class for the projects_locations_discoveredRanges resource."""

    _NAME = 'projects_locations_discoveredRanges'

    def __init__(self, client):
      super(CloudnumberregistryV1alpha.ProjectsLocationsDiscoveredRangesService, self).__init__(client)
      self._upload_configs = {
          }

    def FindFreeIpRanges(self, request, global_params=None):
      r"""Finds free IP ranges in a single DiscoveredRange.

      Args:
        request: (CloudnumberregistryProjectsLocationsDiscoveredRangesFindFreeIpRangesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (FindDiscoveredRangeFreeIpRangesResponse) The response message.
      """
      config = self.GetMethodConfig('FindFreeIpRanges')
      return self._RunMethod(
          config, request, global_params=global_params)

    FindFreeIpRanges.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/discoveredRanges/{discoveredRangesId}:findFreeIpRanges',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.discoveredRanges.findFreeIpRanges',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['cidrPrefixLength', 'rangeCount', 'requestId'],
        relative_path='v1alpha/{+name}:findFreeIpRanges',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsDiscoveredRangesFindFreeIpRangesRequest',
        response_type_name='FindDiscoveredRangeFreeIpRangesResponse',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single DiscoveredRange.

      Args:
        request: (CloudnumberregistryProjectsLocationsDiscoveredRangesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (DiscoveredRange) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/discoveredRanges/{discoveredRangesId}',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.discoveredRanges.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsDiscoveredRangesGetRequest',
        response_type_name='DiscoveredRange',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists DiscoveredRanges in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsDiscoveredRangesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListDiscoveredRangesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/discoveredRanges',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.discoveredRanges.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/discoveredRanges',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsDiscoveredRangesListRequest',
        response_type_name='ListDiscoveredRangesResponse',
        supports_download=False,
    )

    def ShowUtilization(self, request, global_params=None):
      r"""Gets the details of a single DiscoveredRange and its utilization.

      Args:
        request: (CloudnumberregistryProjectsLocationsDiscoveredRangesShowUtilizationRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ShowDiscoveredRangeUtilizationResponse) The response message.
      """
      config = self.GetMethodConfig('ShowUtilization')
      return self._RunMethod(
          config, request, global_params=global_params)

    ShowUtilization.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/discoveredRanges/{discoveredRangesId}:showUtilization',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.discoveredRanges.showUtilization',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:showUtilization',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsDiscoveredRangesShowUtilizationRequest',
        response_type_name='ShowDiscoveredRangeUtilizationResponse',
        supports_download=False,
    )

  class ProjectsLocationsIpamAdminScopesService(base_api.BaseApiService):
    """Service class for the projects_locations_ipamAdminScopes resource."""

    _NAME = 'projects_locations_ipamAdminScopes'

    def __init__(self, client):
      super(CloudnumberregistryV1alpha.ProjectsLocationsIpamAdminScopesService, self).__init__(client)
      self._upload_configs = {
          }

    def CheckAvailability(self, request, global_params=None):
      r"""Checks the availability of IPAM admin scopes in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsIpamAdminScopesCheckAvailabilityRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (CheckAvailabilityIpamAdminScopesResponse) The response message.
      """
      config = self.GetMethodConfig('CheckAvailability')
      return self._RunMethod(
          config, request, global_params=global_params)

    CheckAvailability.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/ipamAdminScopes:checkAvailability',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.ipamAdminScopes.checkAvailability',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['scopes'],
        relative_path='v1alpha/{+parent}/ipamAdminScopes:checkAvailability',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsIpamAdminScopesCheckAvailabilityRequest',
        response_type_name='CheckAvailabilityIpamAdminScopesResponse',
        supports_download=False,
    )

    def Cleanup(self, request, global_params=None):
      r"""Cleans up a single IpamAdminScope.

      Args:
        request: (CloudnumberregistryProjectsLocationsIpamAdminScopesCleanupRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Cleanup')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cleanup.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/ipamAdminScopes/{ipamAdminScopesId}:cleanup',
        http_method='POST',
        method_id='cloudnumberregistry.projects.locations.ipamAdminScopes.cleanup',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:cleanup',
        request_field='cleanupIpamAdminScopeRequest',
        request_type_name='CloudnumberregistryProjectsLocationsIpamAdminScopesCleanupRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Create(self, request, global_params=None):
      r"""Creates a new IpamAdminScope in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsIpamAdminScopesCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/ipamAdminScopes',
        http_method='POST',
        method_id='cloudnumberregistry.projects.locations.ipamAdminScopes.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['ipamAdminScopeId', 'requestId'],
        relative_path='v1alpha/{+parent}/ipamAdminScopes',
        request_field='ipamAdminScope',
        request_type_name='CloudnumberregistryProjectsLocationsIpamAdminScopesCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single IpamAdminScope.

      Args:
        request: (CloudnumberregistryProjectsLocationsIpamAdminScopesDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/ipamAdminScopes/{ipamAdminScopesId}',
        http_method='DELETE',
        method_id='cloudnumberregistry.projects.locations.ipamAdminScopes.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsIpamAdminScopesDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Disable(self, request, global_params=None):
      r"""Disables a single IpamAdminScope.

      Args:
        request: (CloudnumberregistryProjectsLocationsIpamAdminScopesDisableRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Disable')
      return self._RunMethod(
          config, request, global_params=global_params)

    Disable.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/ipamAdminScopes/{ipamAdminScopesId}:disable',
        http_method='POST',
        method_id='cloudnumberregistry.projects.locations.ipamAdminScopes.disable',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:disable',
        request_field='disableIpamAdminScopeRequest',
        request_type_name='CloudnumberregistryProjectsLocationsIpamAdminScopesDisableRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single IpamAdminScope.

      Args:
        request: (CloudnumberregistryProjectsLocationsIpamAdminScopesGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (IpamAdminScope) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/ipamAdminScopes/{ipamAdminScopesId}',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.ipamAdminScopes.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsIpamAdminScopesGetRequest',
        response_type_name='IpamAdminScope',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""List all IPAM admin scopes in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsIpamAdminScopesListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListIpamAdminScopesResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/ipamAdminScopes',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.ipamAdminScopes.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/ipamAdminScopes',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsIpamAdminScopesListRequest',
        response_type_name='ListIpamAdminScopesResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single IpamAdminScope.

      Args:
        request: (CloudnumberregistryProjectsLocationsIpamAdminScopesPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/ipamAdminScopes/{ipamAdminScopesId}',
        http_method='PATCH',
        method_id='cloudnumberregistry.projects.locations.ipamAdminScopes.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='ipamAdminScope',
        request_type_name='CloudnumberregistryProjectsLocationsIpamAdminScopesPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsOperationsService(base_api.BaseApiService):
    """Service class for the projects_locations_operations resource."""

    _NAME = 'projects_locations_operations'

    def __init__(self, client):
      super(CloudnumberregistryV1alpha.ProjectsLocationsOperationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Cancel(self, request, global_params=None):
      r"""Starts asynchronous cancellation on a long-running operation. The server makes a best effort to cancel the operation, but success is not guaranteed. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`. Clients can use Operations.GetOperation or other methods to check whether the cancellation succeeded or whether the operation completed despite cancellation. On successful cancellation, the operation is not deleted; instead, it becomes an operation with an Operation.error value with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.

      Args:
        request: (CloudnumberregistryProjectsLocationsOperationsCancelRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Cancel')
      return self._RunMethod(
          config, request, global_params=global_params)

    Cancel.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}:cancel',
        http_method='POST',
        method_id='cloudnumberregistry.projects.locations.operations.cancel',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:cancel',
        request_field='cancelOperationRequest',
        request_type_name='CloudnumberregistryProjectsLocationsOperationsCancelRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a long-running operation. This method indicates that the client is no longer interested in the operation result. It does not cancel the operation. If the server doesn't support this method, it returns `google.rpc.Code.UNIMPLEMENTED`.

      Args:
        request: (CloudnumberregistryProjectsLocationsOperationsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Empty) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='DELETE',
        method_id='cloudnumberregistry.projects.locations.operations.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsOperationsDeleteRequest',
        response_type_name='Empty',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets the latest state of a long-running operation. Clients can use this method to poll the operation result at intervals as recommended by the API service.

      Args:
        request: (CloudnumberregistryProjectsLocationsOperationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations/{operationsId}',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.operations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsOperationsGetRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists operations that match the specified filter in the request. If the server doesn't support this method, it returns `UNIMPLEMENTED`.

      Args:
        request: (CloudnumberregistryProjectsLocationsOperationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListOperationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/operations',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.operations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['filter', 'pageSize', 'pageToken', 'returnPartialSuccess'],
        relative_path='v1alpha/{+name}/operations',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsOperationsListRequest',
        response_type_name='ListOperationsResponse',
        supports_download=False,
    )

  class ProjectsLocationsRealmsService(base_api.BaseApiService):
    """Service class for the projects_locations_realms resource."""

    _NAME = 'projects_locations_realms'

    def __init__(self, client):
      super(CloudnumberregistryV1alpha.ProjectsLocationsRealmsService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new Realm in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsRealmsCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/realms',
        http_method='POST',
        method_id='cloudnumberregistry.projects.locations.realms.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['realmId', 'requestId'],
        relative_path='v1alpha/{+parent}/realms',
        request_field='realm',
        request_type_name='CloudnumberregistryProjectsLocationsRealmsCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single Realm.

      Args:
        request: (CloudnumberregistryProjectsLocationsRealmsDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}',
        http_method='DELETE',
        method_id='cloudnumberregistry.projects.locations.realms.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsRealmsDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single Realm.

      Args:
        request: (CloudnumberregistryProjectsLocationsRealmsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Realm) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.realms.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsRealmsGetRequest',
        response_type_name='Realm',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists Realms in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsRealmsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRealmsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/realms',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.realms.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/realms',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsRealmsListRequest',
        response_type_name='ListRealmsResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single Realm.

      Args:
        request: (CloudnumberregistryProjectsLocationsRealmsPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/realms/{realmsId}',
        http_method='PATCH',
        method_id='cloudnumberregistry.projects.locations.realms.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='realm',
        request_type_name='CloudnumberregistryProjectsLocationsRealmsPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

  class ProjectsLocationsRegistryBooksService(base_api.BaseApiService):
    """Service class for the projects_locations_registryBooks resource."""

    _NAME = 'projects_locations_registryBooks'

    def __init__(self, client):
      super(CloudnumberregistryV1alpha.ProjectsLocationsRegistryBooksService, self).__init__(client)
      self._upload_configs = {
          }

    def Create(self, request, global_params=None):
      r"""Creates a new RegistryBook in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsRegistryBooksCreateRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Create')
      return self._RunMethod(
          config, request, global_params=global_params)

    Create.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/registryBooks',
        http_method='POST',
        method_id='cloudnumberregistry.projects.locations.registryBooks.create',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['registryBookId', 'requestId'],
        relative_path='v1alpha/{+parent}/registryBooks',
        request_field='registryBook',
        request_type_name='CloudnumberregistryProjectsLocationsRegistryBooksCreateRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Delete(self, request, global_params=None):
      r"""Deletes a single RegistryBook.

      Args:
        request: (CloudnumberregistryProjectsLocationsRegistryBooksDeleteRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Delete')
      return self._RunMethod(
          config, request, global_params=global_params)

    Delete.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/registryBooks/{registryBooksId}',
        http_method='DELETE',
        method_id='cloudnumberregistry.projects.locations.registryBooks.delete',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['force', 'requestId'],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsRegistryBooksDeleteRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def Get(self, request, global_params=None):
      r"""Gets details of a single RegistryBook.

      Args:
        request: (CloudnumberregistryProjectsLocationsRegistryBooksGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (RegistryBook) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/registryBooks/{registryBooksId}',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.registryBooks.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsRegistryBooksGetRequest',
        response_type_name='RegistryBook',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists RegistryBooks in a given project and location.

      Args:
        request: (CloudnumberregistryProjectsLocationsRegistryBooksListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListRegistryBooksResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/registryBooks',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.registryBooks.list',
        ordered_params=['parent'],
        path_params=['parent'],
        query_params=['filter', 'orderBy', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+parent}/registryBooks',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsRegistryBooksListRequest',
        response_type_name='ListRegistryBooksResponse',
        supports_download=False,
    )

    def Patch(self, request, global_params=None):
      r"""Updates the parameters of a single RegistryBook.

      Args:
        request: (CloudnumberregistryProjectsLocationsRegistryBooksPatchRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Operation) The response message.
      """
      config = self.GetMethodConfig('Patch')
      return self._RunMethod(
          config, request, global_params=global_params)

    Patch.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/registryBooks/{registryBooksId}',
        http_method='PATCH',
        method_id='cloudnumberregistry.projects.locations.registryBooks.patch',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['requestId', 'updateMask'],
        relative_path='v1alpha/{+name}',
        request_field='registryBook',
        request_type_name='CloudnumberregistryProjectsLocationsRegistryBooksPatchRequest',
        response_type_name='Operation',
        supports_download=False,
    )

    def SearchIpResources(self, request, global_params=None):
      r"""Searches IP resources in a given RegistryBook.

      Args:
        request: (CloudnumberregistryProjectsLocationsRegistryBooksSearchIpResourcesRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (SearchIpResourcesResponse) The response message.
      """
      config = self.GetMethodConfig('SearchIpResources')
      return self._RunMethod(
          config, request, global_params=global_params)

    SearchIpResources.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}/registryBooks/{registryBooksId}:searchIpResources',
        http_method='POST',
        method_id='cloudnumberregistry.projects.locations.registryBooks.searchIpResources',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}:searchIpResources',
        request_field='searchIpResourcesRequest',
        request_type_name='CloudnumberregistryProjectsLocationsRegistryBooksSearchIpResourcesRequest',
        response_type_name='SearchIpResourcesResponse',
        supports_download=False,
    )

  class ProjectsLocationsService(base_api.BaseApiService):
    """Service class for the projects_locations resource."""

    _NAME = 'projects_locations'

    def __init__(self, client):
      super(CloudnumberregistryV1alpha.ProjectsLocationsService, self).__init__(client)
      self._upload_configs = {
          }

    def Get(self, request, global_params=None):
      r"""Gets information about a location.

      Args:
        request: (CloudnumberregistryProjectsLocationsGetRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (Location) The response message.
      """
      config = self.GetMethodConfig('Get')
      return self._RunMethod(
          config, request, global_params=global_params)

    Get.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations/{locationsId}',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.get',
        ordered_params=['name'],
        path_params=['name'],
        query_params=[],
        relative_path='v1alpha/{+name}',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsGetRequest',
        response_type_name='Location',
        supports_download=False,
    )

    def List(self, request, global_params=None):
      r"""Lists information about the supported locations for this service. This method can be called in two ways: * **List all public locations:** Use the path `GET /v1/locations`. * **List project-visible locations:** Use the path `GET /v1/projects/{project_id}/locations`. This may include public locations as well as private or other locations specifically visible to the project.

      Args:
        request: (CloudnumberregistryProjectsLocationsListRequest) input message
        global_params: (StandardQueryParameters, default: None) global arguments
      Returns:
        (ListLocationsResponse) The response message.
      """
      config = self.GetMethodConfig('List')
      return self._RunMethod(
          config, request, global_params=global_params)

    List.method_config = lambda: base_api.ApiMethodInfo(
        flat_path='v1alpha/projects/{projectsId}/locations',
        http_method='GET',
        method_id='cloudnumberregistry.projects.locations.list',
        ordered_params=['name'],
        path_params=['name'],
        query_params=['extraLocationTypes', 'filter', 'pageSize', 'pageToken'],
        relative_path='v1alpha/{+name}/locations',
        request_field='',
        request_type_name='CloudnumberregistryProjectsLocationsListRequest',
        response_type_name='ListLocationsResponse',
        supports_download=False,
    )

  class ProjectsService(base_api.BaseApiService):
    """Service class for the projects resource."""

    _NAME = 'projects'

    def __init__(self, client):
      super(CloudnumberregistryV1alpha.ProjectsService, self).__init__(client)
      self._upload_configs = {
          }
