"""Generated message classes for vectorsearch version v1.

The Vector Search API provides a fully-managed, highly performant, and
scalable vector database designed to power next-generation search,
recommendation, and generative AI applications. It allows you to store, index,
and query your data and its corresponding vector embeddings through a simple,
intuitive interface. With Vector Search, you can define custom schemas for
your data, insert objects with associated metadata, automatically generate
embeddings from your data, and perform fast approximate nearest neighbor (ANN)
searches to find semantically similar items at scale.
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'vectorsearch'


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class GoogleCloudLocationListLocationsResponse(_messages.Message):
  r"""The response message for Locations.ListLocations.

  Fields:
    locations: A list of locations that matches the specified filter in the
      request.
    nextPageToken: The standard List next-page token.
  """

  locations = _messages.MessageField('GoogleCloudLocationLocation', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudLocationLocation(_messages.Message):
  r"""A resource that represents a Google Cloud location.

  Messages:
    LabelsValue: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    MetadataValue: Service-specific metadata. For example the available
      capacity at the given location.

  Fields:
    displayName: The friendly name for this location, typically a nearby city
      name. For example, "Tokyo".
    labels: Cross-service attributes for the location. For example
      {"cloud.googleapis.com/region": "us-east1"}
    locationId: The canonical id for this location. For example: `"us-east1"`.
    metadata: Service-specific metadata. For example the available capacity at
      the given location.
    name: Resource name for the location, which may vary between
      implementations. For example: `"projects/example-project/locations/us-
      east1"`
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Cross-service attributes for the location. For example
    {"cloud.googleapis.com/region": "us-east1"}

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata. For example the available capacity at the
    given location.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  displayName = _messages.StringField(1)
  labels = _messages.MessageField('LabelsValue', 2)
  locationId = _messages.StringField(3)
  metadata = _messages.MessageField('MetadataValue', 4)
  name = _messages.StringField(5)


class GoogleCloudVectorsearchV1AggregateDataObjectsRequest(_messages.Message):
  r"""Request message for DataObjectSearchService.AggregateDataObjects.

  Enums:
    AggregateValueValuesEnum: Required. The aggregation method to apply to the
      query.

  Messages:
    FilterValue: Optional. A JSON filter expression, e.g. {"genre": {"$eq":
      "sci-fi"}}, represented as a google.protobuf.Struct.

  Fields:
    aggregate: Required. The aggregation method to apply to the query.
    filter: Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-
      fi"}}, represented as a google.protobuf.Struct.
  """

  class AggregateValueValuesEnum(_messages.Enum):
    r"""Required. The aggregation method to apply to the query.

    Values:
      AGGREGATION_METHOD_UNSPECIFIED: Should not be used.
      COUNT: Count the number of data objects that match the filter.
    """
    AGGREGATION_METHOD_UNSPECIFIED = 0
    COUNT = 1

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FilterValue(_messages.Message):
    r"""Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-fi"}},
    represented as a google.protobuf.Struct.

    Messages:
      AdditionalProperty: An additional property for a FilterValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FilterValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  aggregate = _messages.EnumField('AggregateValueValuesEnum', 1)
  filter = _messages.MessageField('FilterValue', 2)


class GoogleCloudVectorsearchV1AggregateDataObjectsResponse(_messages.Message):
  r"""Response message for DataObjectSearchService.AggregateDataObjects.

  Messages:
    AggregateResultsValueListEntry: A AggregateResultsValueListEntry object.

  Fields:
    aggregateResults: Output only. The aggregated results of the query.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class AggregateResultsValueListEntry(_messages.Message):
    r"""A AggregateResultsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a
        AggregateResultsValueListEntry object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a AggregateResultsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  aggregateResults = _messages.MessageField('AggregateResultsValueListEntry', 1, repeated=True)


class GoogleCloudVectorsearchV1BatchCreateDataObjectsRequest(_messages.Message):
  r"""Request message for DataObjectService.BatchCreateDataObjects.

  Fields:
    requests: Required. The request message specifying the resources to
      create. A maximum of 1000 DataObjects can be created in a batch.
  """

  requests = _messages.MessageField('GoogleCloudVectorsearchV1CreateDataObjectRequest', 1, repeated=True)


class GoogleCloudVectorsearchV1BatchCreateDataObjectsResponse(_messages.Message):
  r"""Response message for DataObjectService.BatchCreateDataObjects.

  Fields:
    dataObjects: Output only. DataObjects created.
  """

  dataObjects = _messages.MessageField('GoogleCloudVectorsearchV1DataObject', 1, repeated=True)


class GoogleCloudVectorsearchV1BatchDeleteDataObjectsRequest(_messages.Message):
  r"""Request message for DataObjectService.BatchDeleteDataObjects.

  Fields:
    requests: Required. The request message specifying the resources to
      delete. A maximum of 1000 DataObjects can be deleted in a batch.
  """

  requests = _messages.MessageField('GoogleCloudVectorsearchV1DeleteDataObjectRequest', 1, repeated=True)


class GoogleCloudVectorsearchV1BatchSearchDataObjectsRequest(_messages.Message):
  r"""A request to perform a batch of search operations.

  Fields:
    combine: Optional. Options for combining the results of the batch search
      operations.
    searches: Required. A list of search requests to execute in parallel.
  """

  combine = _messages.MessageField('GoogleCloudVectorsearchV1BatchSearchDataObjectsRequestCombineResultsOptions', 1)
  searches = _messages.MessageField('GoogleCloudVectorsearchV1Search', 2, repeated=True)


class GoogleCloudVectorsearchV1BatchSearchDataObjectsRequestCombineResultsOptions(_messages.Message):
  r"""Options for combining the results of the batch search operations.

  Fields:
    outputFields: Optional. Mask specifying which fields to return.
    ranker: Required. The ranker to use for combining the results.
    topK: Optional. The number of results to return. If not set, a default
      value will be used.
  """

  outputFields = _messages.MessageField('GoogleCloudVectorsearchV1OutputFields', 1)
  ranker = _messages.MessageField('GoogleCloudVectorsearchV1Ranker', 2)
  topK = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class GoogleCloudVectorsearchV1BatchSearchDataObjectsResponse(_messages.Message):
  r"""A response from a batch search operation.

  Fields:
    results: Output only. A list of search responses, one for each request in
      the batch. If a ranker is used, a single ranked list of results is
      returned.
  """

  results = _messages.MessageField('GoogleCloudVectorsearchV1SearchDataObjectsResponse', 1, repeated=True)


class GoogleCloudVectorsearchV1BatchUpdateDataObjectsRequest(_messages.Message):
  r"""Request message for DataObjectService.BatchUpdateDataObjects.

  Fields:
    requests: Required. The request message specifying the resources to
      update. A maximum of 1000 DataObjects can be updated in a batch.
  """

  requests = _messages.MessageField('GoogleCloudVectorsearchV1UpdateDataObjectRequest', 1, repeated=True)


class GoogleCloudVectorsearchV1BatchUpdateDataObjectsResponse(_messages.Message):
  r"""Response message for DataObjectService.BatchUpdateDataObjects."""


class GoogleCloudVectorsearchV1Collection(_messages.Message):
  r"""Message describing Collection object

  Messages:
    DataSchemaValue: Optional. JSON Schema for data. Field names must contain
      only alphanumeric characters, underscores, and hyphens.
    LabelsValue: Optional. Labels as key value pairs.
    VectorSchemaValue: Optional. Schema for vector fields. Only vector fields
      in this schema will be searchable. Field names must contain only
      alphanumeric characters, underscores, and hyphens.

  Fields:
    createTime: Output only. [Output only] Create time stamp
    dataSchema: Optional. JSON Schema for data. Field names must contain only
      alphanumeric characters, underscores, and hyphens.
    description: Optional. User-specified description of the collection
    displayName: Optional. User-specified display name of the collection
    labels: Optional. Labels as key value pairs.
    name: Identifier. name of resource
    updateTime: Output only. [Output only] Update time stamp
    vectorSchema: Optional. Schema for vector fields. Only vector fields in
      this schema will be searchable. Field names must contain only
      alphanumeric characters, underscores, and hyphens.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataSchemaValue(_messages.Message):
    r"""Optional. JSON Schema for data. Field names must contain only
    alphanumeric characters, underscores, and hyphens.

    Messages:
      AdditionalProperty: An additional property for a DataSchemaValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataSchemaValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class VectorSchemaValue(_messages.Message):
    r"""Optional. Schema for vector fields. Only vector fields in this schema
    will be searchable. Field names must contain only alphanumeric characters,
    underscores, and hyphens.

    Messages:
      AdditionalProperty: An additional property for a VectorSchemaValue
        object.

    Fields:
      additionalProperties: Additional properties of type VectorSchemaValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a VectorSchemaValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudVectorsearchV1VectorField attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudVectorsearchV1VectorField', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  dataSchema = _messages.MessageField('DataSchemaValue', 2)
  description = _messages.StringField(3)
  displayName = _messages.StringField(4)
  labels = _messages.MessageField('LabelsValue', 5)
  name = _messages.StringField(6)
  updateTime = _messages.StringField(7)
  vectorSchema = _messages.MessageField('VectorSchemaValue', 8)


class GoogleCloudVectorsearchV1CreateDataObjectRequest(_messages.Message):
  r"""Request message for DataObjectService.CreateDataObject.

  Fields:
    dataObject: Required. The DataObject to create.
    dataObjectId: Required. The id of the dataObject to create. The id must be
      1-63 characters long, and comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, it must
      be 1-63 characters long and match the regular expression
      `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
    parent: Required. The resource name of the Collection to create the
      DataObject in. Format:
      `projects/{project}/locations/{location}/collections/{collection}`
  """

  dataObject = _messages.MessageField('GoogleCloudVectorsearchV1DataObject', 1)
  dataObjectId = _messages.StringField(2)
  parent = _messages.StringField(3)


class GoogleCloudVectorsearchV1DataObject(_messages.Message):
  r"""A dataObject resource in Vector Search.

  Messages:
    DataValue: Optional. The data of the dataObject.
    VectorsValue: Optional. The vectors of the dataObject.

  Fields:
    createTime: Output only. Timestamp the dataObject was created at.
    data: Optional. The data of the dataObject.
    dataObjectId: Output only. The id of the dataObject.
    name: Identifier. The fully qualified resource name of the dataObject.
      Format: `projects/{project}/locations/{location}/collections/{collection
      }/dataObjects/{data_object_id}` The data_object_id must be 1-63
      characters long, and comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
    updateTime: Output only. Timestamp the dataObject was last updated.
    vectors: Optional. The vectors of the dataObject.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DataValue(_messages.Message):
    r"""Optional. The data of the dataObject.

    Messages:
      AdditionalProperty: An additional property for a DataValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class VectorsValue(_messages.Message):
    r"""Optional. The vectors of the dataObject.

    Messages:
      AdditionalProperty: An additional property for a VectorsValue object.

    Fields:
      additionalProperties: Additional properties of type VectorsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a VectorsValue object.

      Fields:
        key: Name of the additional property.
        value: A GoogleCloudVectorsearchV1Vector attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('GoogleCloudVectorsearchV1Vector', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  data = _messages.MessageField('DataValue', 2)
  dataObjectId = _messages.StringField(3)
  name = _messages.StringField(4)
  updateTime = _messages.StringField(5)
  vectors = _messages.MessageField('VectorsValue', 6)


class GoogleCloudVectorsearchV1DedicatedInfrastructure(_messages.Message):
  r"""Represents dedicated infrastructure for the index.

  Enums:
    ModeValueValuesEnum: Optional. Mode of the dedicated infrastructure.

  Fields:
    autoscalingSpec: Optional. Autoscaling specification.
    mode: Optional. Mode of the dedicated infrastructure.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Optional. Mode of the dedicated infrastructure.

    Values:
      MODE_UNSPECIFIED: Default will use `PERFORMANCE_OPTIMIZED`.
      STORAGE_OPTIMIZED: This is storage optimized variation.
      PERFORMANCE_OPTIMIZED: This is Performance optimized on E2 or equivalent
        family.
    """
    MODE_UNSPECIFIED = 0
    STORAGE_OPTIMIZED = 1
    PERFORMANCE_OPTIMIZED = 2

  autoscalingSpec = _messages.MessageField('GoogleCloudVectorsearchV1DedicatedInfrastructureAutoscalingSpec', 1)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)


class GoogleCloudVectorsearchV1DedicatedInfrastructureAutoscalingSpec(_messages.Message):
  r"""Specification for autoscaling.

  Fields:
    maxReplicaCount: Optional. The maximum number of replicas. If not set or
      set to `0`, defaults to the greater of `min_replica_count` and `5`. Must
      be >= `min_replica_count` and <= `1000`.
    minReplicaCount: Optional. The minimum number of replicas. If not set or
      set to `0`, defaults to `2`. Must be >= `2` and <= `1000`.
  """

  maxReplicaCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  minReplicaCount = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudVectorsearchV1DeleteDataObjectRequest(_messages.Message):
  r"""Request message for DataObjectService.DeleteDataObject.

  Fields:
    name: Required. The name of the DataObject resource to be deleted. Format:
      `projects/{project}/locations/{location}/collections/{collection}/dataOb
      jects/{dataObject}`
  """

  name = _messages.StringField(1)


class GoogleCloudVectorsearchV1DenseScannIndex(_messages.Message):
  r"""Dense ScaNN index configuration.

  Enums:
    FeatureNormTypeValueValuesEnum: Optional. Feature norm type.

  Fields:
    featureNormType: Optional. Feature norm type.
  """

  class FeatureNormTypeValueValuesEnum(_messages.Enum):
    r"""Optional. Feature norm type.

    Values:
      FEATURE_NORM_TYPE_UNSPECIFIED: Unspecified feature norm type.
      NONE: No norm applied.
      UNIT_L2_NORM: Unit L2 norm.
    """
    FEATURE_NORM_TYPE_UNSPECIFIED = 0
    NONE = 1
    UNIT_L2_NORM = 2

  featureNormType = _messages.EnumField('FeatureNormTypeValueValuesEnum', 1)


class GoogleCloudVectorsearchV1DenseVector(_messages.Message):
  r"""A dense vector.

  Fields:
    values: Required. The values of the vector.
  """

  values = _messages.FloatField(1, repeated=True, variant=_messages.Variant.FLOAT)


class GoogleCloudVectorsearchV1DenseVectorField(_messages.Message):
  r"""Message describing a dense vector field.

  Fields:
    dimensions: Dimensionality of the vector field.
    vertexEmbeddingConfig: Optional. Configuration for generating embeddings
      for the vector field. If not specified, the embedding field must be
      populated in the DataObject.
  """

  dimensions = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  vertexEmbeddingConfig = _messages.MessageField('GoogleCloudVectorsearchV1VertexEmbeddingConfig', 2)


class GoogleCloudVectorsearchV1ImportDataObjectsRequest(_messages.Message):
  r"""Request message for VectorSearchService.ImportDataObjects.

  Fields:
    gcsImport: The Cloud Storage location of the input content.
  """

  gcsImport = _messages.MessageField('GoogleCloudVectorsearchV1ImportDataObjectsRequestGcsImportConfig', 1)


class GoogleCloudVectorsearchV1ImportDataObjectsRequestGcsImportConfig(_messages.Message):
  r"""Google Cloud Storage configuration for the import.

  Fields:
    contentsUri: Required. URI prefix of the Cloud Storage DataObjects to
      import.
    errorUri: Required. URI prefix of the Cloud Storage location to write any
      errors encountered during the import.
    outputUri: Optional. URI prefix of the Cloud Storage location to write
      DataObject `IDs` and `etags` of DataObjects that were successfully
      imported. The service will write the successfully imported DataObjects
      to sharded files under this prefix. If this field is empty, no output
      will be written.
  """

  contentsUri = _messages.StringField(1)
  errorUri = _messages.StringField(2)
  outputUri = _messages.StringField(3)


class GoogleCloudVectorsearchV1Index(_messages.Message):
  r"""Message describing Index object

  Enums:
    DistanceMetricValueValuesEnum: Optional. Distance metric used for
      indexing. If not specified, will default to DOT_PRODUCT.

  Messages:
    LabelsValue: Optional. Labels as key value pairs.

  Fields:
    createTime: Output only. [Output only] Create time stamp
    dedicatedInfrastructure: Optional. Dedicated infrastructure for the index.
    denseScann: Optional. Dense ScaNN index.
    description: Optional. User-specified description of the index
    displayName: Optional. User-specified display name of the index
    distanceMetric: Optional. Distance metric used for indexing. If not
      specified, will default to DOT_PRODUCT.
    filterFields: Optional. The fields to push into the index to enable fast
      ANN inline filtering.
    indexField: Required. The collection schema field to index.
    labels: Optional. Labels as key value pairs.
    name: Identifier. name of resource
    storeFields: Optional. The fields to push into the index to enable inline
      data retrieval.
    updateTime: Output only. [Output only] Update time stamp
  """

  class DistanceMetricValueValuesEnum(_messages.Enum):
    r"""Optional. Distance metric used for indexing. If not specified, will
    default to DOT_PRODUCT.

    Values:
      DISTANCE_METRIC_UNSPECIFIED: Default value, distance metric is not
        specified.
      DOT_PRODUCT: Dot product distance metric.
      COSINE_DISTANCE: Cosine distance metric.
    """
    DISTANCE_METRIC_UNSPECIFIED = 0
    DOT_PRODUCT = 1
    COSINE_DISTANCE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class LabelsValue(_messages.Message):
    r"""Optional. Labels as key value pairs.

    Messages:
      AdditionalProperty: An additional property for a LabelsValue object.

    Fields:
      additionalProperties: Additional properties of type LabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a LabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  createTime = _messages.StringField(1)
  dedicatedInfrastructure = _messages.MessageField('GoogleCloudVectorsearchV1DedicatedInfrastructure', 2)
  denseScann = _messages.MessageField('GoogleCloudVectorsearchV1DenseScannIndex', 3)
  description = _messages.StringField(4)
  displayName = _messages.StringField(5)
  distanceMetric = _messages.EnumField('DistanceMetricValueValuesEnum', 6)
  filterFields = _messages.StringField(7, repeated=True)
  indexField = _messages.StringField(8)
  labels = _messages.MessageField('LabelsValue', 9)
  name = _messages.StringField(10)
  storeFields = _messages.StringField(11, repeated=True)
  updateTime = _messages.StringField(12)


class GoogleCloudVectorsearchV1ListCollectionsResponse(_messages.Message):
  r"""Message for response to listing Collections

  Fields:
    collections: The list of Collection
    nextPageToken: A token identifying a page of results the server should
      return.
    unreachable: Unordered list. Locations that could not be reached.
  """

  collections = _messages.MessageField('GoogleCloudVectorsearchV1Collection', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleCloudVectorsearchV1ListIndexesResponse(_messages.Message):
  r"""Message for response to listing Indexes

  Fields:
    indexes: The list of Index
    nextPageToken: A token identifying a page of results the server should
      return.
  """

  indexes = _messages.MessageField('GoogleCloudVectorsearchV1Index', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudVectorsearchV1OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    requestedCancellation: Output only. Identifies whether the user has
      requested cancellation of the operation. Operations that have been
      cancelled successfully have google.longrunning.Operation.error value
      with a google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
    statusMessage: Output only. Human-readable status of the operation, if
      any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  createTime = _messages.StringField(2)
  endTime = _messages.StringField(3)
  requestedCancellation = _messages.BooleanField(4)
  statusMessage = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class GoogleCloudVectorsearchV1OutputFields(_messages.Message):
  r"""Defines a output fields struct for data in DataObject.

  Fields:
    dataFields: Optional. The fields from the data fields to include in the
      output.
    metadataFields: Optional. The fields from the DataObject metadata to
      include in the output.
    vectorFields: Optional. The fields from the vector fields to include in
      the output.
  """

  dataFields = _messages.StringField(1, repeated=True)
  metadataFields = _messages.StringField(2, repeated=True)
  vectorFields = _messages.StringField(3, repeated=True)


class GoogleCloudVectorsearchV1QueryDataObjectsRequest(_messages.Message):
  r"""Request message for DataObjectSearchService.QueryDataObjects.

  Messages:
    FilterValue: Optional. A JSON filter expression, e.g. {"genre": {"$eq":
      "sci-fi"}}, represented as a google.protobuf.Struct.

  Fields:
    filter: Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-
      fi"}}, represented as a google.protobuf.Struct.
    outputFields: Optional. Mask specifying which fields to return.
    pageSize: Optional. The standard list page size. Default is 100. The
      maximum value is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. The standard list page token. Typically obtained via
      QueryDataObjectsResponse.next_page_token of the previous
      DataObjectSearchService.QueryDataObjects call.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FilterValue(_messages.Message):
    r"""Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-fi"}},
    represented as a google.protobuf.Struct.

    Messages:
      AdditionalProperty: An additional property for a FilterValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FilterValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  filter = _messages.MessageField('FilterValue', 1)
  outputFields = _messages.MessageField('GoogleCloudVectorsearchV1OutputFields', 2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)


class GoogleCloudVectorsearchV1QueryDataObjectsResponse(_messages.Message):
  r"""Response message for DataObjectSearchService.QueryDataObjects.

  Fields:
    dataObjects: Output only. The list of dataObjects that match the query.
    nextPageToken: Output only. A token to retrieve next page of results. Pass
      to DataObjectSearchService.QueryDataObjectsRequest.page_token to obtain
      that page.
  """

  dataObjects = _messages.MessageField('GoogleCloudVectorsearchV1DataObject', 1, repeated=True)
  nextPageToken = _messages.StringField(2)


class GoogleCloudVectorsearchV1Ranker(_messages.Message):
  r"""Defines a ranker to combine results from multiple searches.

  Fields:
    rrf: Reciprocal Rank Fusion ranking.
    vertex: Vertex AI ranking.
  """

  rrf = _messages.MessageField('GoogleCloudVectorsearchV1ReciprocalRankFusion', 1)
  vertex = _messages.MessageField('GoogleCloudVectorsearchV1VertexRanker', 2)


class GoogleCloudVectorsearchV1ReciprocalRankFusion(_messages.Message):
  r"""Defines the Reciprocal Rank Fusion (RRF) algorithm for result ranking.

  Fields:
    weights: Required. The weights to apply to each search result set during
      fusion.
  """

  weights = _messages.FloatField(1, repeated=True)


class GoogleCloudVectorsearchV1Search(_messages.Message):
  r"""A single search request within a batch operation.

  Fields:
    semanticSearch: A semantic search.
    textSearch: A text search operation.
    vectorSearch: A vector-based search.
  """

  semanticSearch = _messages.MessageField('GoogleCloudVectorsearchV1SemanticSearch', 1)
  textSearch = _messages.MessageField('GoogleCloudVectorsearchV1TextSearch', 2)
  vectorSearch = _messages.MessageField('GoogleCloudVectorsearchV1VectorSearch', 3)


class GoogleCloudVectorsearchV1SearchDataObjectsRequest(_messages.Message):
  r"""Request for performing a single search.

  Fields:
    pageSize: Optional. The standard list page size. Only supported for KNN.
      If not set, up to search_type.top_k results will be returned. The
      maximum value is 1000; values above 1000 will be coerced to 1000.
    pageToken: Optional. The standard list page token. Typically obtained via
      SearchDataObjectsResponse.next_page_token of the previous
      DataObjectSearchService.SearchDataObjects call.
    semanticSearch: A semantic search operation.
    textSearch: Optional. A text search operation.
    vectorSearch: A vector search operation.
  """

  pageSize = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(2)
  semanticSearch = _messages.MessageField('GoogleCloudVectorsearchV1SemanticSearch', 3)
  textSearch = _messages.MessageField('GoogleCloudVectorsearchV1TextSearch', 4)
  vectorSearch = _messages.MessageField('GoogleCloudVectorsearchV1VectorSearch', 5)


class GoogleCloudVectorsearchV1SearchDataObjectsResponse(_messages.Message):
  r"""Response for a search request.

  Fields:
    nextPageToken: Output only. A token to retrieve next page of results. Pass
      to DataObjectSearchService.SearchDataObjectsRequest.page_token to obtain
      that page.
    results: Output only. The list of dataObjects that match the search
      criteria.
  """

  nextPageToken = _messages.StringField(1)
  results = _messages.MessageField('GoogleCloudVectorsearchV1SearchResult', 2, repeated=True)


class GoogleCloudVectorsearchV1SearchHint(_messages.Message):
  r"""Represents a hint to the search index engine.

  Fields:
    indexHint: Optional. Specifies that the search should use a particular
      index.
    knnHint: Optional. If set, the search will use the system's default
      K-Nearest Neighbor (KNN) index engine.
  """

  indexHint = _messages.MessageField('GoogleCloudVectorsearchV1SearchHintIndexHint', 1)
  knnHint = _messages.MessageField('GoogleCloudVectorsearchV1SearchHintKnnHint', 2)


class GoogleCloudVectorsearchV1SearchHintIndexHint(_messages.Message):
  r"""Message to specify the index to use for the search.

  Fields:
    denseScannParams: Optional. Dense ScaNN parameters.
    name: Required. The resource name of the index to use for the search. The
      index must be in the same project, location, and collection. Format: `pr
      ojects/{project}/locations/{location}/collections/{collection}/indexes/{
      index}`
  """

  denseScannParams = _messages.MessageField('GoogleCloudVectorsearchV1SearchHintIndexHintDenseScannParams', 1)
  name = _messages.StringField(2)


class GoogleCloudVectorsearchV1SearchHintIndexHintDenseScannParams(_messages.Message):
  r"""Parameters for dense ScaNN.

  Fields:
    initialCandidateCount: Optional. The number of initial candidates. Must be
      a positive integer (> 0).
    searchLeavesPct: Optional. Dense ANN param overrides to control recall and
      latency. The percentage of leaves to search, in the range [0, 100].
  """

  initialCandidateCount = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  searchLeavesPct = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class GoogleCloudVectorsearchV1SearchHintKnnHint(_messages.Message):
  r"""KnnHint will be used if search should be explicitly done on system's
  default K-Nearest Neighbor (KNN) index engine.
  """



class GoogleCloudVectorsearchV1SearchResult(_messages.Message):
  r"""A single search result.

  Fields:
    dataObject: Output only. The matching data object.
    distance: Output only. Similarity distance or ranker score returned by
      BatchSearchDataObjects.
  """

  dataObject = _messages.MessageField('GoogleCloudVectorsearchV1DataObject', 1)
  distance = _messages.FloatField(2)


class GoogleCloudVectorsearchV1SemanticSearch(_messages.Message):
  r"""Defines a semantic search operation.

  Enums:
    TaskTypeValueValuesEnum: Required. The task type of the query embedding.

  Messages:
    FilterValue: Optional. A JSON filter expression, e.g. {"genre": {"$eq":
      "sci-fi"}}, represented as a google.protobuf.Struct.

  Fields:
    filter: Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-
      fi"}}, represented as a google.protobuf.Struct.
    outputFields: Optional. The fields to return in the search results.
    searchField: Required. The vector field to search.
    searchHint: Optional. Sets the search hint. If no strategy is specified,
      the service will use an index if one is available, and fall back to KNN
      search otherwise.
    searchText: Required. The query text, which is used to generate an
      embedding according to the embedding model specified in the collection
      config.
    taskType: Required. The task type of the query embedding.
    topK: Optional. The number of data objects to return.
  """

  class TaskTypeValueValuesEnum(_messages.Enum):
    r"""Required. The task type of the query embedding.

    Values:
      EMBEDDING_TASK_TYPE_UNSPECIFIED: Unspecified task type.
      RETRIEVAL_QUERY: Specifies the given text is a query in a
        search/retrieval setting.
      RETRIEVAL_DOCUMENT: Specifies the given text is a document from the
        corpus being searched.
      SEMANTIC_SIMILARITY: Specifies the given text will be used for STS.
      CLASSIFICATION: Specifies that the given text will be classified.
      CLUSTERING: Specifies that the embeddings will be used for clustering.
      QUESTION_ANSWERING: Specifies that the embeddings will be used for
        question answering.
      FACT_VERIFICATION: Specifies that the embeddings will be used for fact
        verification.
      CODE_RETRIEVAL_QUERY: Specifies that the embeddings will be used for
        code retrieval.
    """
    EMBEDDING_TASK_TYPE_UNSPECIFIED = 0
    RETRIEVAL_QUERY = 1
    RETRIEVAL_DOCUMENT = 2
    SEMANTIC_SIMILARITY = 3
    CLASSIFICATION = 4
    CLUSTERING = 5
    QUESTION_ANSWERING = 6
    FACT_VERIFICATION = 7
    CODE_RETRIEVAL_QUERY = 8

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FilterValue(_messages.Message):
    r"""Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-fi"}},
    represented as a google.protobuf.Struct.

    Messages:
      AdditionalProperty: An additional property for a FilterValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FilterValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  filter = _messages.MessageField('FilterValue', 1)
  outputFields = _messages.MessageField('GoogleCloudVectorsearchV1OutputFields', 2)
  searchField = _messages.StringField(3)
  searchHint = _messages.MessageField('GoogleCloudVectorsearchV1SearchHint', 4)
  searchText = _messages.StringField(5)
  taskType = _messages.EnumField('TaskTypeValueValuesEnum', 6)
  topK = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class GoogleCloudVectorsearchV1SparseVector(_messages.Message):
  r"""A sparse vector.

  Fields:
    indices: Required. The corresponding indices for the values.
    values: Required. The values of the vector.
  """

  indices = _messages.IntegerField(1, repeated=True, variant=_messages.Variant.INT32)
  values = _messages.FloatField(2, repeated=True, variant=_messages.Variant.FLOAT)


class GoogleCloudVectorsearchV1SparseVectorField(_messages.Message):
  r"""Message describing a sparse vector field."""


class GoogleCloudVectorsearchV1TextSearch(_messages.Message):
  r"""Defines a text search operation.

  Messages:
    FilterValue: Optional. A JSON filter expression, e.g. `{"genre": {"$eq":
      "sci-fi"}}`, represented as a `google.protobuf.Struct`.

  Fields:
    dataFieldNames: Required. The data field names to search.
    filter: Optional. A JSON filter expression, e.g. `{"genre": {"$eq": "sci-
      fi"}}`, represented as a `google.protobuf.Struct`.
    outputFields: Optional. The fields to return in the search results.
    searchText: Required. The query text.
    topK: Optional. The number of results to return.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FilterValue(_messages.Message):
    r"""Optional. A JSON filter expression, e.g. `{"genre": {"$eq": "sci-
    fi"}}`, represented as a `google.protobuf.Struct`.

    Messages:
      AdditionalProperty: An additional property for a FilterValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FilterValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  dataFieldNames = _messages.StringField(1, repeated=True)
  filter = _messages.MessageField('FilterValue', 2)
  outputFields = _messages.MessageField('GoogleCloudVectorsearchV1OutputFields', 3)
  searchText = _messages.StringField(4)
  topK = _messages.IntegerField(5, variant=_messages.Variant.INT32)


class GoogleCloudVectorsearchV1UpdateDataObjectRequest(_messages.Message):
  r"""Request message for DataObjectService.UpdateDataObject.

  Fields:
    dataObject: Required. The DataObject which replaces the resource on the
      server.
    updateMask: Optional. The update mask applies to the resource. See
      google.protobuf.FieldMask.
  """

  dataObject = _messages.MessageField('GoogleCloudVectorsearchV1DataObject', 1)
  updateMask = _messages.StringField(2)


class GoogleCloudVectorsearchV1Vector(_messages.Message):
  r"""A vector which can be either dense or sparse.

  Fields:
    dense: A dense vector.
    sparse: A sparse vector.
  """

  dense = _messages.MessageField('GoogleCloudVectorsearchV1DenseVector', 1)
  sparse = _messages.MessageField('GoogleCloudVectorsearchV1SparseVector', 2)


class GoogleCloudVectorsearchV1VectorField(_messages.Message):
  r"""Message describing a vector field.

  Fields:
    denseVector: Dense vector field.
    sparseVector: Sparse vector field.
  """

  denseVector = _messages.MessageField('GoogleCloudVectorsearchV1DenseVectorField', 1)
  sparseVector = _messages.MessageField('GoogleCloudVectorsearchV1SparseVectorField', 2)


class GoogleCloudVectorsearchV1VectorSearch(_messages.Message):
  r"""Defines a search operation using a query vector.

  Enums:
    DistanceMetricValueValuesEnum: Optional. The distance metric to use for
      the KNN search. If not specified, DOT_PRODUCT will be used as the
      default.

  Messages:
    FilterValue: Optional. A JSON filter expression, e.g. {"genre": {"$eq":
      "sci-fi"}}, represented as a google.protobuf.Struct.

  Fields:
    distanceMetric: Optional. The distance metric to use for the KNN search.
      If not specified, DOT_PRODUCT will be used as the default.
    filter: Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-
      fi"}}, represented as a google.protobuf.Struct.
    outputFields: Optional. Mask specifying which fields to return.
    searchField: Required. The vector field to search.
    searchHint: Optional. Sets the search hint. If no strategy is specified,
      the service will use an index if one is available, and fall back to the
      default KNN search otherwise.
    sparseVector: A sparse vector for the query.
    topK: Optional. The number of nearest neighbors to return.
    vector: A dense vector for the query.
  """

  class DistanceMetricValueValuesEnum(_messages.Enum):
    r"""Optional. The distance metric to use for the KNN search. If not
    specified, DOT_PRODUCT will be used as the default.

    Values:
      DISTANCE_METRIC_UNSPECIFIED: Default value, distance metric is not
        specified.
      DOT_PRODUCT: Dot product distance metric.
      COSINE_DISTANCE: Cosine distance metric.
    """
    DISTANCE_METRIC_UNSPECIFIED = 0
    DOT_PRODUCT = 1
    COSINE_DISTANCE = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class FilterValue(_messages.Message):
    r"""Optional. A JSON filter expression, e.g. {"genre": {"$eq": "sci-fi"}},
    represented as a google.protobuf.Struct.

    Messages:
      AdditionalProperty: An additional property for a FilterValue object.

    Fields:
      additionalProperties: Properties of the object.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a FilterValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  distanceMetric = _messages.EnumField('DistanceMetricValueValuesEnum', 1)
  filter = _messages.MessageField('FilterValue', 2)
  outputFields = _messages.MessageField('GoogleCloudVectorsearchV1OutputFields', 3)
  searchField = _messages.StringField(4)
  searchHint = _messages.MessageField('GoogleCloudVectorsearchV1SearchHint', 5)
  sparseVector = _messages.MessageField('GoogleCloudVectorsearchV1SparseVector', 6)
  topK = _messages.IntegerField(7, variant=_messages.Variant.INT32)
  vector = _messages.MessageField('GoogleCloudVectorsearchV1DenseVector', 8)


class GoogleCloudVectorsearchV1VertexEmbeddingConfig(_messages.Message):
  r"""Message describing the configuration for generating embeddings for a
  vector field using Vertex AI embeddings API.

  Enums:
    TaskTypeValueValuesEnum: Required. Required: Task type for the embeddings.

  Fields:
    modelId: Required. Required: ID of the embedding model to use. See
      https://cloud.google.com/vertex-ai/generative-
      ai/docs/learn/models#embeddings-models for the list of supported models.
    taskType: Required. Required: Task type for the embeddings.
    textTemplate: Required. Required: Text template for the input to the
      model. The template must contain one or more references to fields in the
      DataObject, e.g.: "Movie Title: {title} ---- Movie Plot: {plot}".
  """

  class TaskTypeValueValuesEnum(_messages.Enum):
    r"""Required. Required: Task type for the embeddings.

    Values:
      EMBEDDING_TASK_TYPE_UNSPECIFIED: Unspecified task type.
      RETRIEVAL_QUERY: Specifies the given text is a query in a
        search/retrieval setting.
      RETRIEVAL_DOCUMENT: Specifies the given text is a document from the
        corpus being searched.
      SEMANTIC_SIMILARITY: Specifies the given text will be used for STS.
      CLASSIFICATION: Specifies that the given text will be classified.
      CLUSTERING: Specifies that the embeddings will be used for clustering.
      QUESTION_ANSWERING: Specifies that the embeddings will be used for
        question answering.
      FACT_VERIFICATION: Specifies that the embeddings will be used for fact
        verification.
      CODE_RETRIEVAL_QUERY: Specifies that the embeddings will be used for
        code retrieval.
    """
    EMBEDDING_TASK_TYPE_UNSPECIFIED = 0
    RETRIEVAL_QUERY = 1
    RETRIEVAL_DOCUMENT = 2
    SEMANTIC_SIMILARITY = 3
    CLASSIFICATION = 4
    CLUSTERING = 5
    QUESTION_ANSWERING = 6
    FACT_VERIFICATION = 7
    CODE_RETRIEVAL_QUERY = 8

  modelId = _messages.StringField(1)
  taskType = _messages.EnumField('TaskTypeValueValuesEnum', 2)
  textTemplate = _messages.StringField(3)


class GoogleCloudVectorsearchV1VertexRanker(_messages.Message):
  r"""Defines a ranker using the Vertex AI ranking service. See
  https://cloud.google.com/generative-ai-app-builder/docs/ranking for details.

  Fields:
    contentTemplate: Optional. The template used to generate the record's
      content.
    model: Required. The model used for ranking documents. If no model is
      specified, then semantic-ranker-default@latest is used.
    query: Required. The query against which the records are ranked and
      scored.
    titleTemplate: Optional. The template used to generate the record's title.
  """

  contentTemplate = _messages.StringField(1)
  model = _messages.StringField(2)
  query = _messages.StringField(3)
  titleTemplate = _messages.StringField(4)


class GoogleLongrunningCancelOperationRequest(_messages.Message):
  r"""The request message for Operations.CancelOperation."""


class GoogleLongrunningListOperationsResponse(_messages.Message):
  r"""The response message for Operations.ListOperations.

  Fields:
    nextPageToken: The standard List next-page token.
    operations: A list of operations that matches the specified filter in the
      request.
    unreachable: Unordered list. Unreachable resources. Populated when the
      request sets `ListOperationsRequest.return_partial_success` and reads
      across collections. For example, when attempting to list all resources
      across all supported locations.
  """

  nextPageToken = _messages.StringField(1)
  operations = _messages.MessageField('GoogleLongrunningOperation', 2, repeated=True)
  unreachable = _messages.StringField(3, repeated=True)


class GoogleLongrunningOperation(_messages.Message):
  r"""This resource represents a long-running operation that is the result of
  a network API call.

  Messages:
    MetadataValue: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    ResponseValue: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

  Fields:
    done: If the value is `false`, it means the operation is still in
      progress. If `true`, the operation is completed, and either `error` or
      `response` is available.
    error: The error result of the operation in case of failure or
      cancellation.
    metadata: Service-specific metadata associated with the operation. It
      typically contains progress information and common metadata such as
      create time. Some services might not provide such metadata. Any method
      that returns a long-running operation should document the metadata type,
      if any.
    name: The server-assigned name, which is only unique within the same
      service that originally returns it. If you use the default HTTP mapping,
      the `name` should be a resource name ending with
      `operations/{unique_id}`.
    response: The normal, successful response of the operation. If the
      original method returns no data on success, such as `Delete`, the
      response is `google.protobuf.Empty`. If the original method is standard
      `Get`/`Create`/`Update`, the response should be the resource. For other
      methods, the response should have the type `XxxResponse`, where `Xxx` is
      the original method name. For example, if the original method name is
      `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class MetadataValue(_messages.Message):
    r"""Service-specific metadata associated with the operation. It typically
    contains progress information and common metadata such as create time.
    Some services might not provide such metadata. Any method that returns a
    long-running operation should document the metadata type, if any.

    Messages:
      AdditionalProperty: An additional property for a MetadataValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a MetadataValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class ResponseValue(_messages.Message):
    r"""The normal, successful response of the operation. If the original
    method returns no data on success, such as `Delete`, the response is
    `google.protobuf.Empty`. If the original method is standard
    `Get`/`Create`/`Update`, the response should be the resource. For other
    methods, the response should have the type `XxxResponse`, where `Xxx` is
    the original method name. For example, if the original method name is
    `TakeSnapshot()`, the inferred response type is `TakeSnapshotResponse`.

    Messages:
      AdditionalProperty: An additional property for a ResponseValue object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a ResponseValue object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  done = _messages.BooleanField(1)
  error = _messages.MessageField('GoogleRpcStatus', 2)
  metadata = _messages.MessageField('MetadataValue', 3)
  name = _messages.StringField(4)
  response = _messages.MessageField('ResponseValue', 5)


class GoogleRpcStatus(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class VectorsearchProjectsLocationsCollectionsCreateRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsCreateRequest object.

  Fields:
    collectionId: Required. ID of the Collection to create. The id must be
      1-63 characters long, and comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, it must
      be 1-63 characters long and match the regular expression
      `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
    googleCloudVectorsearchV1Collection: A GoogleCloudVectorsearchV1Collection
      resource to be passed as the request body.
    parent: Required. Value for parent.
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  collectionId = _messages.StringField(1)
  googleCloudVectorsearchV1Collection = _messages.MessageField('GoogleCloudVectorsearchV1Collection', 2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class VectorsearchProjectsLocationsCollectionsDataObjectsAggregateRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsAggregateRequest
  object.

  Fields:
    googleCloudVectorsearchV1AggregateDataObjectsRequest: A
      GoogleCloudVectorsearchV1AggregateDataObjectsRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the Collection for which to query.
      Format:
      `projects/{project}/locations/{location}/collections/{collection}`
  """

  googleCloudVectorsearchV1AggregateDataObjectsRequest = _messages.MessageField('GoogleCloudVectorsearchV1AggregateDataObjectsRequest', 1)
  parent = _messages.StringField(2, required=True)


class VectorsearchProjectsLocationsCollectionsDataObjectsBatchCreateRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsBatchCreateRequest
  object.

  Fields:
    googleCloudVectorsearchV1BatchCreateDataObjectsRequest: A
      GoogleCloudVectorsearchV1BatchCreateDataObjectsRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the Collection to create the
      DataObjects in. Format:
      `projects/{project}/locations/{location}/collections/{collection}`. The
      parent field in the CreateDataObjectRequest messages must match this
      field.
  """

  googleCloudVectorsearchV1BatchCreateDataObjectsRequest = _messages.MessageField('GoogleCloudVectorsearchV1BatchCreateDataObjectsRequest', 1)
  parent = _messages.StringField(2, required=True)


class VectorsearchProjectsLocationsCollectionsDataObjectsBatchDeleteRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsBatchDeleteRequest
  object.

  Fields:
    googleCloudVectorsearchV1BatchDeleteDataObjectsRequest: A
      GoogleCloudVectorsearchV1BatchDeleteDataObjectsRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the Collection to delete the
      DataObjects in. Format:
      `projects/{project}/locations/{location}/collections/{collection}`.
  """

  googleCloudVectorsearchV1BatchDeleteDataObjectsRequest = _messages.MessageField('GoogleCloudVectorsearchV1BatchDeleteDataObjectsRequest', 1)
  parent = _messages.StringField(2, required=True)


class VectorsearchProjectsLocationsCollectionsDataObjectsBatchSearchRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsBatchSearchRequest
  object.

  Fields:
    googleCloudVectorsearchV1BatchSearchDataObjectsRequest: A
      GoogleCloudVectorsearchV1BatchSearchDataObjectsRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the Collection for which to search.
      Format:
      `projects/{project}/locations/{location}/collections/{collection}`
  """

  googleCloudVectorsearchV1BatchSearchDataObjectsRequest = _messages.MessageField('GoogleCloudVectorsearchV1BatchSearchDataObjectsRequest', 1)
  parent = _messages.StringField(2, required=True)


class VectorsearchProjectsLocationsCollectionsDataObjectsBatchUpdateRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsBatchUpdateRequest
  object.

  Fields:
    googleCloudVectorsearchV1BatchUpdateDataObjectsRequest: A
      GoogleCloudVectorsearchV1BatchUpdateDataObjectsRequest resource to be
      passed as the request body.
    parent: Required. The resource name of the Collection to update the
      DataObjects in. Format:
      `projects/{project}/locations/{location}/collections/{collection}`. The
      parent field in the UpdateDataObjectRequest messages must match this
      field.
  """

  googleCloudVectorsearchV1BatchUpdateDataObjectsRequest = _messages.MessageField('GoogleCloudVectorsearchV1BatchUpdateDataObjectsRequest', 1)
  parent = _messages.StringField(2, required=True)


class VectorsearchProjectsLocationsCollectionsDataObjectsCreateRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsCreateRequest
  object.

  Fields:
    dataObjectId: Required. The id of the dataObject to create. The id must be
      1-63 characters long, and comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, it must
      be 1-63 characters long and match the regular expression
      `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
    googleCloudVectorsearchV1DataObject: A GoogleCloudVectorsearchV1DataObject
      resource to be passed as the request body.
    parent: Required. The resource name of the Collection to create the
      DataObject in. Format:
      `projects/{project}/locations/{location}/collections/{collection}`
  """

  dataObjectId = _messages.StringField(1)
  googleCloudVectorsearchV1DataObject = _messages.MessageField('GoogleCloudVectorsearchV1DataObject', 2)
  parent = _messages.StringField(3, required=True)


class VectorsearchProjectsLocationsCollectionsDataObjectsDeleteRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsDeleteRequest
  object.

  Fields:
    name: Required. The name of the DataObject resource to be deleted. Format:
      `projects/{project}/locations/{location}/collections/{collection}/dataOb
      jects/{dataObject}`
  """

  name = _messages.StringField(1, required=True)


class VectorsearchProjectsLocationsCollectionsDataObjectsGetRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsGetRequest object.

  Fields:
    name: Required. The name of the DataObject resource. Format: `projects/{pr
      oject}/locations/{location}/collections/{collection}/dataObjects/{dataOb
      ject}`
  """

  name = _messages.StringField(1, required=True)


class VectorsearchProjectsLocationsCollectionsDataObjectsPatchRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsPatchRequest
  object.

  Fields:
    googleCloudVectorsearchV1DataObject: A GoogleCloudVectorsearchV1DataObject
      resource to be passed as the request body.
    name: Identifier. The fully qualified resource name of the dataObject.
      Format: `projects/{project}/locations/{location}/collections/{collection
      }/dataObjects/{data_object_id}` The data_object_id must be 1-63
      characters long, and comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt).
    updateMask: Optional. The update mask applies to the resource. See
      google.protobuf.FieldMask.
  """

  googleCloudVectorsearchV1DataObject = _messages.MessageField('GoogleCloudVectorsearchV1DataObject', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class VectorsearchProjectsLocationsCollectionsDataObjectsQueryRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsQueryRequest
  object.

  Fields:
    googleCloudVectorsearchV1QueryDataObjectsRequest: A
      GoogleCloudVectorsearchV1QueryDataObjectsRequest resource to be passed
      as the request body.
    parent: Required. The resource name of the Collection for which to query.
      Format:
      `projects/{project}/locations/{location}/collections/{collection}`
  """

  googleCloudVectorsearchV1QueryDataObjectsRequest = _messages.MessageField('GoogleCloudVectorsearchV1QueryDataObjectsRequest', 1)
  parent = _messages.StringField(2, required=True)


class VectorsearchProjectsLocationsCollectionsDataObjectsSearchRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDataObjectsSearchRequest
  object.

  Fields:
    googleCloudVectorsearchV1SearchDataObjectsRequest: A
      GoogleCloudVectorsearchV1SearchDataObjectsRequest resource to be passed
      as the request body.
    parent: Required. The resource name of the Collection for which to search.
      Format:
      `projects/{project}/locations/{location}/collections/{collection}`
  """

  googleCloudVectorsearchV1SearchDataObjectsRequest = _messages.MessageField('GoogleCloudVectorsearchV1SearchDataObjectsRequest', 1)
  parent = _messages.StringField(2, required=True)


class VectorsearchProjectsLocationsCollectionsDeleteRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsDeleteRequest object.

  Fields:
    name: Required. Name of the resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes after the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class VectorsearchProjectsLocationsCollectionsGetRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class VectorsearchProjectsLocationsCollectionsImportDataObjectsRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsImportDataObjectsRequest
  object.

  Fields:
    googleCloudVectorsearchV1ImportDataObjectsRequest: A
      GoogleCloudVectorsearchV1ImportDataObjectsRequest resource to be passed
      as the request body.
    name: Required. The resource name of the Collection to import DataObjects
      into. Format:
      `projects/{project}/locations/{location}/collections/{collection}`.
  """

  googleCloudVectorsearchV1ImportDataObjectsRequest = _messages.MessageField('GoogleCloudVectorsearchV1ImportDataObjectsRequest', 1)
  name = _messages.StringField(2, required=True)


class VectorsearchProjectsLocationsCollectionsIndexesCreateRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsIndexesCreateRequest object.

  Fields:
    googleCloudVectorsearchV1Index: A GoogleCloudVectorsearchV1Index resource
      to be passed as the request body.
    indexId: Required. ID of the Index to create. The id must be 1-63
      characters long, and comply with
      [RFC1035](https://www.ietf.org/rfc/rfc1035.txt). Specifically, it must
      be 1-63 characters long and match the regular expression
      `[a-z](?:[-a-z0-9]{0,61}[a-z0-9])?`.
    parent: Required. The resource name of the Collection for which to create
      the Index. Format:
      `projects/{project}/locations/{location}/collections/{collection}`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  googleCloudVectorsearchV1Index = _messages.MessageField('GoogleCloudVectorsearchV1Index', 1)
  indexId = _messages.StringField(2)
  parent = _messages.StringField(3, required=True)
  requestId = _messages.StringField(4)


class VectorsearchProjectsLocationsCollectionsIndexesDeleteRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsIndexesDeleteRequest object.

  Fields:
    name: Required. The resource name of the Index to delete. Format: `project
      s/{project}/locations/{location}/collections/{collection}/indexes/{index
      }`
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
  """

  name = _messages.StringField(1, required=True)
  requestId = _messages.StringField(2)


class VectorsearchProjectsLocationsCollectionsIndexesGetRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsIndexesGetRequest object.

  Fields:
    name: Required. Name of the resource
  """

  name = _messages.StringField(1, required=True)


class VectorsearchProjectsLocationsCollectionsIndexesListRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsIndexesListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListIndexesRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class VectorsearchProjectsLocationsCollectionsListRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsListRequest object.

  Fields:
    filter: Optional. Filtering results
    orderBy: Optional. Hint for how to order the results
    pageSize: Optional. Requested page size. Server may return fewer items
      than requested. If unspecified, server will pick an appropriate default.
    pageToken: Optional. A token identifying a page of results the server
      should return.
    parent: Required. Parent value for ListCollectionsRequest
  """

  filter = _messages.StringField(1)
  orderBy = _messages.StringField(2)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  parent = _messages.StringField(5, required=True)


class VectorsearchProjectsLocationsCollectionsPatchRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsCollectionsPatchRequest object.

  Fields:
    googleCloudVectorsearchV1Collection: A GoogleCloudVectorsearchV1Collection
      resource to be passed as the request body.
    name: Identifier. name of resource
    requestId: Optional. An optional request ID to identify requests. Specify
      a unique request ID so that if you must retry your request, the server
      will know to ignore the request if it has already been completed. The
      server will guarantee that for at least 60 minutes since the first
      request. For example, consider a situation where you make an initial
      request and the request times out. If you make the request again with
      the same request ID, the server can check if original operation with the
      same request ID was received, and if so, will ignore the second request.
      This prevents clients from accidentally creating duplicate commitments.
      The request ID must be a valid UUID with the exception that zero UUID is
      not supported (00000000-0000-0000-0000-000000000000).
    updateMask: Optional. Field mask is used to specify the fields to be
      overwritten in the Collection resource by the update. The fields
      specified in the update_mask are relative to the resource, not the full
      request. A field will be overwritten if it is in the mask. If the user
      does not provide a mask then all fields present in the request will be
      overwritten. The following fields support update: `display_name`,
      `description`, `labels`, `data_schema`, `vector_schema`. For
      `data_schema` and `vector_schema`, fields can only be added, not
      deleted, but `vertex_embedding_config` in `vector_schema` can be added
      or removed. Partial updates for `data_schema` and `vector_schema` are
      also supported by using sub-field paths in `update_mask`, e.g.
      `data_schema.properties.foo` or `vector_schema.my_vector_field`. If `*`
      is provided in the update_mask, full replacement will be performed.
  """

  googleCloudVectorsearchV1Collection = _messages.MessageField('GoogleCloudVectorsearchV1Collection', 1)
  name = _messages.StringField(2, required=True)
  requestId = _messages.StringField(3)
  updateMask = _messages.StringField(4)


class VectorsearchProjectsLocationsGetRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsGetRequest object.

  Fields:
    name: Resource name for the location.
  """

  name = _messages.StringField(1, required=True)


class VectorsearchProjectsLocationsListRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsListRequest object.

  Fields:
    extraLocationTypes: Optional. Do not use this field. It is unsupported and
      is ignored unless explicitly documented otherwise. This is primarily for
      internal usage.
    filter: A filter to narrow down results to a preferred subset. The
      filtering language accepts strings like `"displayName=tokyo"`, and is
      documented in more detail in [AIP-160](https://google.aip.dev/160).
    name: The resource that owns the locations collection, if applicable.
    pageSize: The maximum number of results to return. If not set, the service
      selects a default.
    pageToken: A page token received from the `next_page_token` field in the
      response. Send that page token to receive the subsequent page.
  """

  extraLocationTypes = _messages.StringField(1, repeated=True)
  filter = _messages.StringField(2)
  name = _messages.StringField(3, required=True)
  pageSize = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(5)


class VectorsearchProjectsLocationsOperationsCancelRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsOperationsCancelRequest object.

  Fields:
    googleLongrunningCancelOperationRequest: A
      GoogleLongrunningCancelOperationRequest resource to be passed as the
      request body.
    name: The name of the operation resource to be cancelled.
  """

  googleLongrunningCancelOperationRequest = _messages.MessageField('GoogleLongrunningCancelOperationRequest', 1)
  name = _messages.StringField(2, required=True)


class VectorsearchProjectsLocationsOperationsDeleteRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsOperationsDeleteRequest object.

  Fields:
    name: The name of the operation resource to be deleted.
  """

  name = _messages.StringField(1, required=True)


class VectorsearchProjectsLocationsOperationsGetRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsOperationsGetRequest object.

  Fields:
    name: The name of the operation resource.
  """

  name = _messages.StringField(1, required=True)


class VectorsearchProjectsLocationsOperationsListRequest(_messages.Message):
  r"""A VectorsearchProjectsLocationsOperationsListRequest object.

  Fields:
    filter: The standard list filter.
    name: The name of the operation's parent resource.
    pageSize: The standard list page size.
    pageToken: The standard list page token.
    returnPartialSuccess: When set to `true`, operations that are reachable
      are returned as normal, and those that are unreachable are returned in
      the ListOperationsResponse.unreachable field. This can only be `true`
      when reading across collections. For example, when `parent` is set to
      `"projects/example/locations/-"`. This field is not supported by default
      and will result in an `UNIMPLEMENTED` error if set unless explicitly
      documented otherwise in service or product specific documentation.
  """

  filter = _messages.StringField(1)
  name = _messages.StringField(2, required=True)
  pageSize = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(4)
  returnPartialSuccess = _messages.BooleanField(5)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
