/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.project;

import org.gradle.api.Task;
import org.gradle.api.internal.project.ProjectState;
import org.gradle.api.internal.tasks.TaskResolver;
import org.gradle.internal.build.BuildState;
import org.gradle.util.Path;

public class BuildScopedTaskResolver
implements TaskResolver {
    private final BuildState build;

    public BuildScopedTaskResolver(BuildState build) {
        this.build = build;
    }

    public Task resolveTask(Path path) {
        String targetTaskName = path.getName();
        if (targetTaskName == null) {
            assert (path == Path.ROOT);
            throw new IllegalArgumentException("The root path is not a valid task path");
        }
        if (!path.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Cannot resolve task at path '%s' since the path is not absolute.", path));
        }
        this.build.ensureProjectsConfigured();
        Path targetProjectPath = path.getParent() == null ? Path.ROOT : path.getParent();
        ProjectState projectState = this.build.getProjects().getProject(targetProjectPath);
        projectState.ensureTasksDiscovered();
        return projectState.getMutableModel().getTasks().getByName(targetTaskName);
    }
}

