/*
 * Decompiled with CFR 0.152.
 */
package org.multiverse.commitbarriers;

import java.util.List;
import org.multiverse.api.Txn;
import org.multiverse.api.TxnStatus;
import org.multiverse.api.exceptions.DeadTxnException;
import org.multiverse.api.exceptions.PreparedTxnException;
import org.multiverse.api.lifecycle.TxnEvent;
import org.multiverse.api.lifecycle.TxnListener;
import org.multiverse.commitbarriers.CommitBarrier;
import org.multiverse.commitbarriers.CommitBarrierOpenException;

public final class CountDownCommitBarrier
extends CommitBarrier {
    private volatile int parties;

    public CountDownCommitBarrier(int parties) {
        this(parties, false);
    }

    public CountDownCommitBarrier(int parties, boolean fair) {
        super(parties == 0 ? CommitBarrier.Status.Committed : CommitBarrier.Status.Closed, fair);
        if (parties < 0) {
            throw new IllegalArgumentException();
        }
        this.parties = parties;
    }

    public int getParties() {
        return this.parties;
    }

    @Override
    protected boolean isLastParty() {
        return this.getNumberWaiting() == this.parties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void countDown() {
        onCommitTasks = null;
        this.lock.lock();
        try {
            switch (1.$SwitchMap$org$multiverse$commitbarriers$CommitBarrier$Status[this.getStatus().ordinal()]) {
                case 1: {
                    this.addJoiner();
                    if (this.isLastParty()) {
                        onCommitTasks = this.signalCommit();
                        ** break;
                    }
lbl10:
                    // 3 sources

                    break;
                }
                case 2: {
                    ** break;
lbl13:
                    // 1 sources

                    break;
                }
                case 3: {
                    ** break;
lbl16:
                    // 1 sources

                    break;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        CountDownCommitBarrier.executeTasks(onCommitTasks);
    }

    public void atomicIncParties() {
        this.atomicIncParties(1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void atomicIncParties(int extra) {
        if (extra < 0) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            switch (this.getStatus()) {
                case Closed: {
                    if (extra == 0) {
                        return;
                    }
                    this.parties += extra;
                    return;
                }
                case Aborted: {
                    String abortMsg = "Can't call countDown on already aborted CountDownCommitBarrier";
                    throw new CommitBarrierOpenException(abortMsg);
                }
                case Committed: {
                    String commitMsg = "Can't call countDown on already committed CountDownCommitBarrier";
                    throw new CommitBarrierOpenException(commitMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void incParties(Txn tx, int extra) {
        if (tx == null) {
            throw new NullPointerException();
        }
        if (tx.getStatus() != TxnStatus.Active) {
            if (tx.getStatus() != TxnStatus.Prepared) throw new DeadTxnException(String.format("[%s] Can't call incParties on non active transaction because it is %s", new Object[]{tx.getConfig().getFamilyName(), tx.getStatus()}));
            tx.abort();
            throw new PreparedTxnException(String.format("[%s] Can't call incParties on non active transaction because it is %s", new Object[]{tx.getConfig().getFamilyName(), tx.getStatus()}));
        }
        if (extra < 0) {
            throw new IllegalArgumentException();
        }
        this.lock.lock();
        try {
            switch (this.getStatus()) {
                case Closed: {
                    if (extra == 0) {
                        return;
                    }
                    this.parties += extra;
                    tx.register(new RestorePartiesCompensatingTask(extra));
                    return;
                }
                case Aborted: {
                    String abortMsg = String.format("[%s] Can't call incParties on already aborted CountDownCommitBarrier", tx.getConfig().getFamilyName());
                    throw new CommitBarrierOpenException(abortMsg);
                }
                case Committed: {
                    String commitMsg = String.format("[%s] Can't call incParties on already committed CountDownCommitBarrier", tx.getConfig().getFamilyName());
                    throw new CommitBarrierOpenException(commitMsg);
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            this.lock.unlock();
        }
    }

    private class RestorePartiesCompensatingTask
    implements TxnListener {
        private final int extra;

        RestorePartiesCompensatingTask(int extra) {
            this.extra = extra;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void notify(Txn tx, TxnEvent event) {
            if (event != TxnEvent.PostAbort) {
                return;
            }
            List<Runnable> onCommitTasks = null;
            CountDownCommitBarrier.this.lock.lock();
            try {
                if (CountDownCommitBarrier.this.getStatus() == CommitBarrier.Status.Closed) {
                    CountDownCommitBarrier.this.parties -= this.extra;
                    if (CountDownCommitBarrier.this.isLastParty()) {
                        onCommitTasks = CountDownCommitBarrier.this.signalCommit();
                    }
                }
            }
            finally {
                CountDownCommitBarrier.this.lock.unlock();
            }
            CommitBarrier.executeTasks(onCommitTasks);
        }
    }
}

