/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.api;

import java.time.ZonedDateTime;
import java.util.Map;
import org.jreleaser.model.api.announce.Announce;
import org.jreleaser.model.api.assemble.Assemble;
import org.jreleaser.model.api.catalog.Catalog;
import org.jreleaser.model.api.checksum.Checksum;
import org.jreleaser.model.api.common.Domain;
import org.jreleaser.model.api.common.Matrix;
import org.jreleaser.model.api.deploy.Deploy;
import org.jreleaser.model.api.distributions.Distribution;
import org.jreleaser.model.api.download.Download;
import org.jreleaser.model.api.environment.Environment;
import org.jreleaser.model.api.extensions.Extension;
import org.jreleaser.model.api.files.Files;
import org.jreleaser.model.api.hooks.Hooks;
import org.jreleaser.model.api.packagers.Packagers;
import org.jreleaser.model.api.platform.Platform;
import org.jreleaser.model.api.project.Project;
import org.jreleaser.model.api.release.Release;
import org.jreleaser.model.api.signing.Signing;
import org.jreleaser.model.api.upload.Upload;

public interface JReleaserModel
extends Domain {
    public ZonedDateTime getNow();

    public String getTimestamp();

    public Commit getCommit();

    public Environment getEnvironment();

    public Matrix getMatrix();

    public Hooks getHooks();

    public Platform getPlatform();

    public Project getProject();

    public Release getRelease();

    public Packagers getPackagers();

    public Announce getAnnounce();

    public Assemble getAssemble();

    public Download getDownload();

    public Deploy getDeploy();

    public Upload getUpload();

    public Checksum getChecksum();

    public Signing getSigning();

    public Files getFiles();

    public Catalog getCatalog();

    public Map<String, ? extends Distribution> getDistributions();

    public Map<String, ? extends Extension> getExtensions();

    public static final class Commit {
        private final String shortHash;
        private final String fullHash;
        private final String refName;
        private final int commitTime;
        private final ZonedDateTime timestamp;

        public Commit(String shortHash, String fullHash, String refName, int commitTime, ZonedDateTime timestamp) {
            this.shortHash = shortHash;
            this.fullHash = fullHash;
            this.refName = refName;
            this.commitTime = commitTime;
            this.timestamp = timestamp;
        }

        public String getShortHash() {
            return this.shortHash;
        }

        public String getFullHash() {
            return this.fullHash;
        }

        public String getRefName() {
            return this.refName;
        }

        public int getCommitTime() {
            return this.commitTime;
        }

        public ZonedDateTime getTimestamp() {
            return this.timestamp;
        }
    }
}

