/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.checksums.internal;

import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.checksums.DefaultChecksumAlgorithm;
import software.amazon.awssdk.checksums.SdkChecksum;
import software.amazon.awssdk.checksums.spi.ChecksumAlgorithm;
import software.amazon.awssdk.crt.checksums.XXHash;
import software.amazon.awssdk.utils.IoUtils;

@SdkInternalApi
public final class XxHashChecksum
implements SdkChecksum {
    private final XXHash xxHash;

    public XxHashChecksum(ChecksumAlgorithm algorithm) {
        if (algorithm == DefaultChecksumAlgorithm.XXHASH64) {
            this.xxHash = XXHash.newXXHash64();
        } else if (algorithm == DefaultChecksumAlgorithm.XXHASH3) {
            this.xxHash = XXHash.newXXHash3_64();
        } else if (algorithm == DefaultChecksumAlgorithm.XXHASH128) {
            this.xxHash = XXHash.newXXHash3_128();
        } else {
            throw new UnsupportedOperationException("Unsupported algorithm: " + algorithm.algorithmId());
        }
    }

    @Override
    public void update(byte[] b) {
        this.xxHash.update(b);
    }

    @Override
    public byte[] getChecksumBytes() {
        try {
            byte[] byArray = this.xxHash.digest();
            return byArray;
        }
        finally {
            IoUtils.closeQuietlyV2((AutoCloseable)this.xxHash, null);
        }
    }

    @Override
    public void update(int b) {
        this.xxHash.update(b);
    }

    @Override
    public void update(byte[] b, int off, int len) {
        this.xxHash.update(b, off, len);
    }

    @Override
    public void reset() {
        throw new UnsupportedOperationException("mark and reset is not supported");
    }

    @Override
    public void mark(int readLimit) {
        throw new UnsupportedOperationException("mark and reset is not supported");
    }

    @Override
    public long getValue() {
        throw new UnsupportedOperationException("Use getChecksumBytes() instead.");
    }
}

