/* automatically generated by rust-bindgen 0.71.1 */

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    fn extract_bit(byte: u8, index: usize) -> bool {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        Self::extract_bit(byte, index)
    }
    #[inline]
    pub unsafe fn raw_get_bit(this: *const Self, index: usize) -> bool {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte = *(core::ptr::addr_of!((*this).storage) as *const u8).offset(byte_index as isize);
        Self::extract_bit(byte, index)
    }
    #[inline]
    fn change_bit(byte: u8, index: usize, val: bool) -> u8 {
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            byte | mask
        } else {
            byte & !mask
        }
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub unsafe fn raw_set_bit(this: *mut Self, index: usize, val: bool) {
        debug_assert!(index / 8 < core::mem::size_of::<Storage>());
        let byte_index = index / 8;
        let byte =
            (core::ptr::addr_of_mut!((*this).storage) as *mut u8).offset(byte_index as isize);
        *byte = Self::change_bit(*byte, index, val);
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub unsafe fn raw_get(this: *const Self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if Self::raw_get_bit(this, i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
    #[inline]
    pub unsafe fn raw_set(this: *mut Self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < core::mem::size_of::<Storage>());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= core::mem::size_of::<Storage>());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            Self::raw_set_bit(this, index + bit_offset, val_bit_is_set);
        }
    }
}
#[repr(C)]
#[derive(Default)]
pub struct __IncompleteArrayField<T>(::std::marker::PhantomData<T>, [T; 0]);
impl<T> __IncompleteArrayField<T> {
    #[inline]
    pub const fn new() -> Self {
        __IncompleteArrayField(::std::marker::PhantomData, [])
    }
    #[inline]
    pub fn as_ptr(&self) -> *const T {
        self as *const _ as *const T
    }
    #[inline]
    pub fn as_mut_ptr(&mut self) -> *mut T {
        self as *mut _ as *mut T
    }
    #[inline]
    pub unsafe fn as_slice(&self, len: usize) -> &[T] {
        ::std::slice::from_raw_parts(self.as_ptr(), len)
    }
    #[inline]
    pub unsafe fn as_mut_slice(&mut self, len: usize) -> &mut [T] {
        ::std::slice::from_raw_parts_mut(self.as_mut_ptr(), len)
    }
}
impl<T> ::std::fmt::Debug for __IncompleteArrayField<T> {
    fn fmt(&self, fmt: &mut ::std::fmt::Formatter<'_>) -> ::std::fmt::Result {
        fmt.write_str("__IncompleteArrayField")
    }
}
#[repr(C)]
#[derive(Debug)]
pub struct std_atomic<_Tp> {
    pub _phantom_0: ::std::marker::PhantomData<::std::cell::UnsafeCell<_Tp>>,
    pub _M_i: _Tp,
}
pub type std_atomic_value_type<_Tp> = _Tp;
pub type __sig_atomic_t = ::std::os::raw::c_int;
pub type jl_gcframe_t = _jl_gcframe_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __sigset_t {
    pub __val: [::std::os::raw::c_ulong; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __sigset_t"][::std::mem::size_of::<__sigset_t>() - 128usize];
    ["Alignment of __sigset_t"][::std::mem::align_of::<__sigset_t>() - 8usize];
    ["Offset of field: __sigset_t::__val"][::std::mem::offset_of!(__sigset_t, __val) - 0usize];
};
pub type pthread_t = ::std::os::raw::c_ulong;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct arraylist_t {
    pub len: usize,
    pub max: usize,
    pub items: *mut *mut ::std::os::raw::c_void,
    pub _space: [*mut ::std::os::raw::c_void; 29usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of arraylist_t"][::std::mem::size_of::<arraylist_t>() - 256usize];
    ["Alignment of arraylist_t"][::std::mem::align_of::<arraylist_t>() - 8usize];
    ["Offset of field: arraylist_t::len"][::std::mem::offset_of!(arraylist_t, len) - 0usize];
    ["Offset of field: arraylist_t::max"][::std::mem::offset_of!(arraylist_t, max) - 8usize];
    ["Offset of field: arraylist_t::items"][::std::mem::offset_of!(arraylist_t, items) - 16usize];
    ["Offset of field: arraylist_t::_space"][::std::mem::offset_of!(arraylist_t, _space) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct small_arraylist_t {
    pub len: usize,
    pub max: usize,
    pub items: *mut *mut ::std::os::raw::c_void,
    pub _space: [*mut ::std::os::raw::c_void; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of small_arraylist_t"][::std::mem::size_of::<small_arraylist_t>() - 64usize];
    ["Alignment of small_arraylist_t"][::std::mem::align_of::<small_arraylist_t>() - 8usize];
    ["Offset of field: small_arraylist_t::len"]
        [::std::mem::offset_of!(small_arraylist_t, len) - 0usize];
    ["Offset of field: small_arraylist_t::max"]
        [::std::mem::offset_of!(small_arraylist_t, max) - 8usize];
    ["Offset of field: small_arraylist_t::items"]
        [::std::mem::offset_of!(small_arraylist_t, items) - 16usize];
    ["Offset of field: small_arraylist_t::_space"]
        [::std::mem::offset_of!(small_arraylist_t, _space) - 24usize];
};
pub type __jmp_buf = [::std::os::raw::c_long; 8usize];
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct __jmp_buf_tag {
    pub __jmpbuf: __jmp_buf,
    pub __mask_was_saved: ::std::os::raw::c_int,
    pub __saved_mask: __sigset_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of __jmp_buf_tag"][::std::mem::size_of::<__jmp_buf_tag>() - 200usize];
    ["Alignment of __jmp_buf_tag"][::std::mem::align_of::<__jmp_buf_tag>() - 8usize];
    ["Offset of field: __jmp_buf_tag::__jmpbuf"]
        [::std::mem::offset_of!(__jmp_buf_tag, __jmpbuf) - 0usize];
    ["Offset of field: __jmp_buf_tag::__mask_was_saved"]
        [::std::mem::offset_of!(__jmp_buf_tag, __mask_was_saved) - 64usize];
    ["Offset of field: __jmp_buf_tag::__saved_mask"]
        [::std::mem::offset_of!(__jmp_buf_tag, __saved_mask) - 72usize];
};
pub type sigjmp_buf = [__jmp_buf_tag; 1usize];
pub type jl_taggedvalue_t = _jl_taggedvalue_t;
pub type jl_ptls_t = *mut _jl_tls_states_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_value_t {
    _unused: [u8; 0],
}
pub type sig_atomic_t = __sig_atomic_t;
pub type jl_value_t = _jl_value_t;
#[repr(C)]
#[repr(align(8))]
pub struct MMTkMutatorContext {
    pub _bindgen_opaque_blob: [u64; 87usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of MMTkMutatorContext"][::std::mem::size_of::<MMTkMutatorContext>() - 696usize];
    ["Alignment of MMTkMutatorContext"][::std::mem::align_of::<MMTkMutatorContext>() - 8usize];
};
#[repr(C)]
pub struct jl_gc_tls_states_t {
    pub mmtk_mutator: MMTkMutatorContext,
    pub malloc_sz_since_last_poll: std_atomic<usize>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_gc_tls_states_t"][::std::mem::size_of::<jl_gc_tls_states_t>() - 704usize];
    ["Alignment of jl_gc_tls_states_t"][::std::mem::align_of::<jl_gc_tls_states_t>() - 8usize];
    ["Offset of field: jl_gc_tls_states_t::mmtk_mutator"]
        [::std::mem::offset_of!(jl_gc_tls_states_t, mmtk_mutator) - 0usize];
    ["Offset of field: jl_gc_tls_states_t::malloc_sz_since_last_poll"]
        [::std::mem::offset_of!(jl_gc_tls_states_t, malloc_sz_since_last_poll) - 696usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_thread_heap_common_t {
    pub weak_refs: small_arraylist_t,
    pub live_tasks: small_arraylist_t,
    pub mallocarrays: small_arraylist_t,
    pub free_stacks: [small_arraylist_t; 16usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_thread_heap_common_t"]
        [::std::mem::size_of::<jl_thread_heap_common_t>() - 1216usize];
    ["Alignment of jl_thread_heap_common_t"]
        [::std::mem::align_of::<jl_thread_heap_common_t>() - 8usize];
    ["Offset of field: jl_thread_heap_common_t::weak_refs"]
        [::std::mem::offset_of!(jl_thread_heap_common_t, weak_refs) - 0usize];
    ["Offset of field: jl_thread_heap_common_t::live_tasks"]
        [::std::mem::offset_of!(jl_thread_heap_common_t, live_tasks) - 64usize];
    ["Offset of field: jl_thread_heap_common_t::mallocarrays"]
        [::std::mem::offset_of!(jl_thread_heap_common_t, mallocarrays) - 128usize];
    ["Offset of field: jl_thread_heap_common_t::free_stacks"]
        [::std::mem::offset_of!(jl_thread_heap_common_t, free_stacks) - 192usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct jl_thread_gc_num_common_t {
    pub allocd: std_atomic<i64>,
    pub pool_live_bytes: std_atomic<i64>,
    pub malloc: std_atomic<u64>,
    pub realloc: std_atomic<u64>,
    pub poolalloc: std_atomic<u64>,
    pub bigalloc: std_atomic<u64>,
    pub free_acc: std_atomic<i64>,
    pub alloc_acc: std_atomic<u64>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_thread_gc_num_common_t"]
        [::std::mem::size_of::<jl_thread_gc_num_common_t>() - 64usize];
    ["Alignment of jl_thread_gc_num_common_t"]
        [::std::mem::align_of::<jl_thread_gc_num_common_t>() - 8usize];
    ["Offset of field: jl_thread_gc_num_common_t::allocd"]
        [::std::mem::offset_of!(jl_thread_gc_num_common_t, allocd) - 0usize];
    ["Offset of field: jl_thread_gc_num_common_t::pool_live_bytes"]
        [::std::mem::offset_of!(jl_thread_gc_num_common_t, pool_live_bytes) - 8usize];
    ["Offset of field: jl_thread_gc_num_common_t::malloc"]
        [::std::mem::offset_of!(jl_thread_gc_num_common_t, malloc) - 16usize];
    ["Offset of field: jl_thread_gc_num_common_t::realloc"]
        [::std::mem::offset_of!(jl_thread_gc_num_common_t, realloc) - 24usize];
    ["Offset of field: jl_thread_gc_num_common_t::poolalloc"]
        [::std::mem::offset_of!(jl_thread_gc_num_common_t, poolalloc) - 32usize];
    ["Offset of field: jl_thread_gc_num_common_t::bigalloc"]
        [::std::mem::offset_of!(jl_thread_gc_num_common_t, bigalloc) - 40usize];
    ["Offset of field: jl_thread_gc_num_common_t::free_acc"]
        [::std::mem::offset_of!(jl_thread_gc_num_common_t, free_acc) - 48usize];
    ["Offset of field: jl_thread_gc_num_common_t::alloc_acc"]
        [::std::mem::offset_of!(jl_thread_gc_num_common_t, alloc_acc) - 56usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct jl_gc_tls_states_common_t {
    pub heap: jl_thread_heap_common_t,
    pub gc_num: jl_thread_gc_num_common_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_gc_tls_states_common_t"]
        [::std::mem::size_of::<jl_gc_tls_states_common_t>() - 1280usize];
    ["Alignment of jl_gc_tls_states_common_t"]
        [::std::mem::align_of::<jl_gc_tls_states_common_t>() - 8usize];
    ["Offset of field: jl_gc_tls_states_common_t::heap"]
        [::std::mem::offset_of!(jl_gc_tls_states_common_t, heap) - 0usize];
    ["Offset of field: jl_gc_tls_states_common_t::gc_num"]
        [::std::mem::offset_of!(jl_gc_tls_states_common_t, gc_num) - 1216usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_stack_context_t {
    pub uc_mcontext: sigjmp_buf,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_stack_context_t"][::std::mem::size_of::<jl_stack_context_t>() - 200usize];
    ["Alignment of jl_stack_context_t"][::std::mem::align_of::<jl_stack_context_t>() - 8usize];
    ["Offset of field: jl_stack_context_t::uc_mcontext"]
        [::std::mem::offset_of!(jl_stack_context_t, uc_mcontext) - 0usize];
};
pub type _jl_ucontext_t = jl_stack_context_t;
#[repr(C)]
#[derive(Copy, Clone)]
pub struct jl_ucontext_t {
    pub __bindgen_anon_1: jl_ucontext_t__bindgen_ty_1,
    pub stkbuf: *mut ::std::os::raw::c_void,
    pub bufsz: usize,
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
    pub __bindgen_padding_0: u32,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union jl_ucontext_t__bindgen_ty_1 {
    pub ctx: *mut _jl_ucontext_t,
    pub copy_ctx: *mut jl_stack_context_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_ucontext_t__bindgen_ty_1"]
        [::std::mem::size_of::<jl_ucontext_t__bindgen_ty_1>() - 8usize];
    ["Alignment of jl_ucontext_t__bindgen_ty_1"]
        [::std::mem::align_of::<jl_ucontext_t__bindgen_ty_1>() - 8usize];
    ["Offset of field: jl_ucontext_t__bindgen_ty_1::ctx"]
        [::std::mem::offset_of!(jl_ucontext_t__bindgen_ty_1, ctx) - 0usize];
    ["Offset of field: jl_ucontext_t__bindgen_ty_1::copy_ctx"]
        [::std::mem::offset_of!(jl_ucontext_t__bindgen_ty_1, copy_ctx) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_ucontext_t"][::std::mem::size_of::<jl_ucontext_t>() - 32usize];
    ["Alignment of jl_ucontext_t"][::std::mem::align_of::<jl_ucontext_t>() - 8usize];
    ["Offset of field: jl_ucontext_t::stkbuf"]
        [::std::mem::offset_of!(jl_ucontext_t, stkbuf) - 8usize];
    ["Offset of field: jl_ucontext_t::bufsz"]
        [::std::mem::offset_of!(jl_ucontext_t, bufsz) - 16usize];
};
impl jl_ucontext_t {
    #[inline]
    pub fn copy_stack(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 31u8) as u32) }
    }
    #[inline]
    pub fn set_copy_stack(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 31u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn copy_stack_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                31u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_copy_stack_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                31u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn started(&self) -> ::std::os::raw::c_uint {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(31usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_started(&mut self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(31usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn started_raw(this: *const Self) -> ::std::os::raw::c_uint {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 4usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                31usize,
                1u8,
            ) as u32)
        }
    }
    #[inline]
    pub unsafe fn set_started_raw(this: *mut Self, val: ::std::os::raw::c_uint) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 4usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                31usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        copy_stack: ::std::os::raw::c_uint,
        started: ::std::os::raw::c_uint,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 31u8, {
            let copy_stack: u32 = unsafe { ::std::mem::transmute(copy_stack) };
            copy_stack as u64
        });
        __bindgen_bitfield_unit.set(31usize, 1u8, {
            let started: u32 = unsafe { ::std::mem::transmute(started) };
            started as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type jl_thread_t = pthread_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_mutex_t {
    pub owner: u64,
    pub count: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_mutex_t"][::std::mem::size_of::<jl_mutex_t>() - 16usize];
    ["Alignment of jl_mutex_t"][::std::mem::align_of::<jl_mutex_t>() - 8usize];
    ["Offset of field: jl_mutex_t::owner"][::std::mem::offset_of!(jl_mutex_t, owner) - 0usize];
    ["Offset of field: jl_mutex_t::count"][::std::mem::offset_of!(jl_mutex_t, count) - 8usize];
};
#[repr(C)]
pub struct _jl_tls_states_t {
    pub tid: i16,
    pub threadpoolid: i8,
    pub rngseed: u64,
    pub safepoint: u64,
    pub sleep_check_state: std_atomic<i8>,
    pub gc_state: std_atomic<i8>,
    pub in_pure_callback: i16,
    pub in_finalizer: i16,
    pub disable_gc: i16,
    pub finalizers_inhibited: ::std::os::raw::c_int,
    pub gc_tls: jl_gc_tls_states_t,
    pub gc_tls_common: jl_gc_tls_states_common_t,
    pub lazily_freed_mtarraylist_buffers: small_arraylist_t,
    pub defer_signal: sig_atomic_t,
    pub current_task: u64,
    pub next_task: *mut _jl_task_t,
    pub previous_task: *mut _jl_task_t,
    pub root_task: *mut _jl_task_t,
    pub timing_stack: *mut _jl_timing_block_t,
    pub stackbase: *mut ::std::os::raw::c_void,
    pub stacksize: usize,
    pub sig_exception: *mut _jl_value_t,
    pub bt_data: *mut _jl_bt_element_t,
    pub bt_size: usize,
    pub profiling_bt_buffer: *mut _jl_bt_element_t,
    pub signal_request: std_atomic<sig_atomic_t>,
    pub io_wait: sig_atomic_t,
    pub signal_stack: *mut ::std::os::raw::c_void,
    pub signal_stack_size: usize,
    pub system_id: jl_thread_t,
    pub suspend_count: std_atomic<i16>,
    pub finalizers: arraylist_t,
    pub previous_exception: *mut _jl_value_t,
    pub locks: small_arraylist_t,
    pub engine_nqueued: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_tls_states_t"][::std::mem::size_of::<_jl_tls_states_t>() - 2560usize];
    ["Alignment of _jl_tls_states_t"][::std::mem::align_of::<_jl_tls_states_t>() - 8usize];
    ["Offset of field: _jl_tls_states_t::tid"]
        [::std::mem::offset_of!(_jl_tls_states_t, tid) - 0usize];
    ["Offset of field: _jl_tls_states_t::threadpoolid"]
        [::std::mem::offset_of!(_jl_tls_states_t, threadpoolid) - 2usize];
    ["Offset of field: _jl_tls_states_t::rngseed"]
        [::std::mem::offset_of!(_jl_tls_states_t, rngseed) - 8usize];
    ["Offset of field: _jl_tls_states_t::safepoint"]
        [::std::mem::offset_of!(_jl_tls_states_t, safepoint) - 16usize];
    ["Offset of field: _jl_tls_states_t::sleep_check_state"]
        [::std::mem::offset_of!(_jl_tls_states_t, sleep_check_state) - 24usize];
    ["Offset of field: _jl_tls_states_t::gc_state"]
        [::std::mem::offset_of!(_jl_tls_states_t, gc_state) - 25usize];
    ["Offset of field: _jl_tls_states_t::in_pure_callback"]
        [::std::mem::offset_of!(_jl_tls_states_t, in_pure_callback) - 26usize];
    ["Offset of field: _jl_tls_states_t::in_finalizer"]
        [::std::mem::offset_of!(_jl_tls_states_t, in_finalizer) - 28usize];
    ["Offset of field: _jl_tls_states_t::disable_gc"]
        [::std::mem::offset_of!(_jl_tls_states_t, disable_gc) - 30usize];
    ["Offset of field: _jl_tls_states_t::finalizers_inhibited"]
        [::std::mem::offset_of!(_jl_tls_states_t, finalizers_inhibited) - 32usize];
    ["Offset of field: _jl_tls_states_t::gc_tls"]
        [::std::mem::offset_of!(_jl_tls_states_t, gc_tls) - 40usize];
    ["Offset of field: _jl_tls_states_t::gc_tls_common"]
        [::std::mem::offset_of!(_jl_tls_states_t, gc_tls_common) - 744usize];
    ["Offset of field: _jl_tls_states_t::lazily_freed_mtarraylist_buffers"]
        [::std::mem::offset_of!(_jl_tls_states_t, lazily_freed_mtarraylist_buffers) - 2024usize];
    ["Offset of field: _jl_tls_states_t::defer_signal"]
        [::std::mem::offset_of!(_jl_tls_states_t, defer_signal) - 2088usize];
    ["Offset of field: _jl_tls_states_t::current_task"]
        [::std::mem::offset_of!(_jl_tls_states_t, current_task) - 2096usize];
    ["Offset of field: _jl_tls_states_t::next_task"]
        [::std::mem::offset_of!(_jl_tls_states_t, next_task) - 2104usize];
    ["Offset of field: _jl_tls_states_t::previous_task"]
        [::std::mem::offset_of!(_jl_tls_states_t, previous_task) - 2112usize];
    ["Offset of field: _jl_tls_states_t::root_task"]
        [::std::mem::offset_of!(_jl_tls_states_t, root_task) - 2120usize];
    ["Offset of field: _jl_tls_states_t::timing_stack"]
        [::std::mem::offset_of!(_jl_tls_states_t, timing_stack) - 2128usize];
    ["Offset of field: _jl_tls_states_t::stackbase"]
        [::std::mem::offset_of!(_jl_tls_states_t, stackbase) - 2136usize];
    ["Offset of field: _jl_tls_states_t::stacksize"]
        [::std::mem::offset_of!(_jl_tls_states_t, stacksize) - 2144usize];
    ["Offset of field: _jl_tls_states_t::sig_exception"]
        [::std::mem::offset_of!(_jl_tls_states_t, sig_exception) - 2152usize];
    ["Offset of field: _jl_tls_states_t::bt_data"]
        [::std::mem::offset_of!(_jl_tls_states_t, bt_data) - 2160usize];
    ["Offset of field: _jl_tls_states_t::bt_size"]
        [::std::mem::offset_of!(_jl_tls_states_t, bt_size) - 2168usize];
    ["Offset of field: _jl_tls_states_t::profiling_bt_buffer"]
        [::std::mem::offset_of!(_jl_tls_states_t, profiling_bt_buffer) - 2176usize];
    ["Offset of field: _jl_tls_states_t::signal_request"]
        [::std::mem::offset_of!(_jl_tls_states_t, signal_request) - 2184usize];
    ["Offset of field: _jl_tls_states_t::io_wait"]
        [::std::mem::offset_of!(_jl_tls_states_t, io_wait) - 2188usize];
    ["Offset of field: _jl_tls_states_t::signal_stack"]
        [::std::mem::offset_of!(_jl_tls_states_t, signal_stack) - 2192usize];
    ["Offset of field: _jl_tls_states_t::signal_stack_size"]
        [::std::mem::offset_of!(_jl_tls_states_t, signal_stack_size) - 2200usize];
    ["Offset of field: _jl_tls_states_t::system_id"]
        [::std::mem::offset_of!(_jl_tls_states_t, system_id) - 2208usize];
    ["Offset of field: _jl_tls_states_t::suspend_count"]
        [::std::mem::offset_of!(_jl_tls_states_t, suspend_count) - 2216usize];
    ["Offset of field: _jl_tls_states_t::finalizers"]
        [::std::mem::offset_of!(_jl_tls_states_t, finalizers) - 2224usize];
    ["Offset of field: _jl_tls_states_t::previous_exception"]
        [::std::mem::offset_of!(_jl_tls_states_t, previous_exception) - 2480usize];
    ["Offset of field: _jl_tls_states_t::locks"]
        [::std::mem::offset_of!(_jl_tls_states_t, locks) - 2488usize];
    ["Offset of field: _jl_tls_states_t::engine_nqueued"]
        [::std::mem::offset_of!(_jl_tls_states_t, engine_nqueued) - 2552usize];
};
pub type jl_function_t = jl_value_t;
pub type jl_timing_block_t = _jl_timing_block_t;
pub type jl_excstack_t = _jl_excstack_t;
pub type jl_handler_t = _jl_handler_t;
#[repr(C)]
pub struct _jl_task_t {
    pub next: *mut jl_value_t,
    pub queue: *mut jl_value_t,
    pub tls: *mut jl_value_t,
    pub donenotify: *mut jl_value_t,
    pub result: *mut jl_value_t,
    pub scope: *mut jl_value_t,
    pub start: *mut jl_function_t,
    pub _state: std_atomic<u8>,
    pub sticky: u8,
    pub priority: u16,
    pub _isexception: std_atomic<u8>,
    pub pad0: [u8; 3usize],
    pub rngState: [u64; 5usize],
    pub metrics_enabled: u8,
    pub pad1: [u8; 3usize],
    pub first_enqueued_at: std_atomic<u64>,
    pub last_started_running_at: std_atomic<u64>,
    pub running_time_ns: std_atomic<u64>,
    pub finished_at: std_atomic<u64>,
    pub tid: std_atomic<i16>,
    pub threadpoolid: i8,
    pub reentrant_timing: u8,
    pub gcstack: *mut jl_gcframe_t,
    pub world_age: usize,
    pub ptls: jl_ptls_t,
    pub excstack: *mut jl_excstack_t,
    pub eh: *mut jl_handler_t,
    pub ctx: jl_ucontext_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_task_t"][::std::mem::size_of::<_jl_task_t>() - 224usize];
    ["Alignment of _jl_task_t"][::std::mem::align_of::<_jl_task_t>() - 8usize];
    ["Offset of field: _jl_task_t::next"][::std::mem::offset_of!(_jl_task_t, next) - 0usize];
    ["Offset of field: _jl_task_t::queue"][::std::mem::offset_of!(_jl_task_t, queue) - 8usize];
    ["Offset of field: _jl_task_t::tls"][::std::mem::offset_of!(_jl_task_t, tls) - 16usize];
    ["Offset of field: _jl_task_t::donenotify"]
        [::std::mem::offset_of!(_jl_task_t, donenotify) - 24usize];
    ["Offset of field: _jl_task_t::result"][::std::mem::offset_of!(_jl_task_t, result) - 32usize];
    ["Offset of field: _jl_task_t::scope"][::std::mem::offset_of!(_jl_task_t, scope) - 40usize];
    ["Offset of field: _jl_task_t::start"][::std::mem::offset_of!(_jl_task_t, start) - 48usize];
    ["Offset of field: _jl_task_t::_state"][::std::mem::offset_of!(_jl_task_t, _state) - 56usize];
    ["Offset of field: _jl_task_t::sticky"][::std::mem::offset_of!(_jl_task_t, sticky) - 57usize];
    ["Offset of field: _jl_task_t::priority"]
        [::std::mem::offset_of!(_jl_task_t, priority) - 58usize];
    ["Offset of field: _jl_task_t::_isexception"]
        [::std::mem::offset_of!(_jl_task_t, _isexception) - 60usize];
    ["Offset of field: _jl_task_t::pad0"][::std::mem::offset_of!(_jl_task_t, pad0) - 61usize];
    ["Offset of field: _jl_task_t::rngState"]
        [::std::mem::offset_of!(_jl_task_t, rngState) - 64usize];
    ["Offset of field: _jl_task_t::metrics_enabled"]
        [::std::mem::offset_of!(_jl_task_t, metrics_enabled) - 104usize];
    ["Offset of field: _jl_task_t::pad1"][::std::mem::offset_of!(_jl_task_t, pad1) - 105usize];
    ["Offset of field: _jl_task_t::first_enqueued_at"]
        [::std::mem::offset_of!(_jl_task_t, first_enqueued_at) - 112usize];
    ["Offset of field: _jl_task_t::last_started_running_at"]
        [::std::mem::offset_of!(_jl_task_t, last_started_running_at) - 120usize];
    ["Offset of field: _jl_task_t::running_time_ns"]
        [::std::mem::offset_of!(_jl_task_t, running_time_ns) - 128usize];
    ["Offset of field: _jl_task_t::finished_at"]
        [::std::mem::offset_of!(_jl_task_t, finished_at) - 136usize];
    ["Offset of field: _jl_task_t::tid"][::std::mem::offset_of!(_jl_task_t, tid) - 144usize];
    ["Offset of field: _jl_task_t::threadpoolid"]
        [::std::mem::offset_of!(_jl_task_t, threadpoolid) - 146usize];
    ["Offset of field: _jl_task_t::reentrant_timing"]
        [::std::mem::offset_of!(_jl_task_t, reentrant_timing) - 147usize];
    ["Offset of field: _jl_task_t::gcstack"]
        [::std::mem::offset_of!(_jl_task_t, gcstack) - 152usize];
    ["Offset of field: _jl_task_t::world_age"]
        [::std::mem::offset_of!(_jl_task_t, world_age) - 160usize];
    ["Offset of field: _jl_task_t::ptls"][::std::mem::offset_of!(_jl_task_t, ptls) - 168usize];
    ["Offset of field: _jl_task_t::excstack"]
        [::std::mem::offset_of!(_jl_task_t, excstack) - 176usize];
    ["Offset of field: _jl_task_t::eh"][::std::mem::offset_of!(_jl_task_t, eh) - 184usize];
    ["Offset of field: _jl_task_t::ctx"][::std::mem::offset_of!(_jl_task_t, ctx) - 192usize];
};
pub type jl_task_t = _jl_task_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_taggedvalue_bits {
    pub _bitfield_align_1: [u64; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_taggedvalue_bits"][::std::mem::size_of::<_jl_taggedvalue_bits>() - 8usize];
    ["Alignment of _jl_taggedvalue_bits"][::std::mem::align_of::<_jl_taggedvalue_bits>() - 8usize];
};
impl _jl_taggedvalue_bits {
    #[inline]
    pub fn gc(&self) -> usize {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 2u8) as u64) }
    }
    #[inline]
    pub fn set_gc(&mut self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn gc_raw(this: *const Self) -> usize {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 8usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                2u8,
            ) as u64)
        }
    }
    #[inline]
    pub unsafe fn set_gc_raw(this: *mut Self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 8usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn in_image(&self) -> usize {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_in_image(&mut self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn in_image_raw(this: *const Self) -> usize {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 8usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u64)
        }
    }
    #[inline]
    pub unsafe fn set_in_image_raw(this: *mut Self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 8usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn unused(&self) -> usize {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u64) }
    }
    #[inline]
    pub fn set_unused(&mut self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn unused_raw(this: *const Self) -> usize {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 8usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u64)
        }
    }
    #[inline]
    pub unsafe fn set_unused_raw(this: *mut Self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 8usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn tag(&self) -> usize {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 60u8) as u64) }
    }
    #[inline]
    pub fn set_tag(&mut self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 60u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn tag_raw(this: *const Self) -> usize {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 8usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                60u8,
            ) as u64)
        }
    }
    #[inline]
    pub unsafe fn set_tag_raw(this: *mut Self, val: usize) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 8usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                60u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        gc: usize,
        in_image: usize,
        unused: usize,
        tag: usize,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 2u8, {
            let gc: u64 = unsafe { ::std::mem::transmute(gc) };
            gc as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let in_image: u64 = unsafe { ::std::mem::transmute(in_image) };
            in_image as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let unused: u64 = unsafe { ::std::mem::transmute(unused) };
            unused as u64
        });
        __bindgen_bitfield_unit.set(4usize, 60u8, {
            let tag: u64 = unsafe { ::std::mem::transmute(tag) };
            tag as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_taggedvalue_t {
    pub __bindgen_anon_1: _jl_taggedvalue_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _jl_taggedvalue_t__bindgen_ty_1 {
    pub header: usize,
    pub next: *mut jl_taggedvalue_t,
    pub type_: *mut jl_value_t,
    pub bits: _jl_taggedvalue_bits,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_taggedvalue_t__bindgen_ty_1"]
        [::std::mem::size_of::<_jl_taggedvalue_t__bindgen_ty_1>() - 8usize];
    ["Alignment of _jl_taggedvalue_t__bindgen_ty_1"]
        [::std::mem::align_of::<_jl_taggedvalue_t__bindgen_ty_1>() - 8usize];
    ["Offset of field: _jl_taggedvalue_t__bindgen_ty_1::header"]
        [::std::mem::offset_of!(_jl_taggedvalue_t__bindgen_ty_1, header) - 0usize];
    ["Offset of field: _jl_taggedvalue_t__bindgen_ty_1::next"]
        [::std::mem::offset_of!(_jl_taggedvalue_t__bindgen_ty_1, next) - 0usize];
    ["Offset of field: _jl_taggedvalue_t__bindgen_ty_1::type_"]
        [::std::mem::offset_of!(_jl_taggedvalue_t__bindgen_ty_1, type_) - 0usize];
    ["Offset of field: _jl_taggedvalue_t__bindgen_ty_1::bits"]
        [::std::mem::offset_of!(_jl_taggedvalue_t__bindgen_ty_1, bits) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_taggedvalue_t"][::std::mem::size_of::<_jl_taggedvalue_t>() - 8usize];
    ["Alignment of _jl_taggedvalue_t"][::std::mem::align_of::<_jl_taggedvalue_t>() - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_sym_t {
    pub left: u64,
    pub right: u64,
    pub hash: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_sym_t"][::std::mem::size_of::<_jl_sym_t>() - 24usize];
    ["Alignment of _jl_sym_t"][::std::mem::align_of::<_jl_sym_t>() - 8usize];
    ["Offset of field: _jl_sym_t::left"][::std::mem::offset_of!(_jl_sym_t, left) - 0usize];
    ["Offset of field: _jl_sym_t::right"][::std::mem::offset_of!(_jl_sym_t, right) - 8usize];
    ["Offset of field: _jl_sym_t::hash"][::std::mem::offset_of!(_jl_sym_t, hash) - 16usize];
};
pub type jl_sym_t = _jl_sym_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_svec_t {
    pub length: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_svec_t"][::std::mem::size_of::<jl_svec_t>() - 8usize];
    ["Alignment of jl_svec_t"][::std::mem::align_of::<jl_svec_t>() - 8usize];
    ["Offset of field: jl_svec_t::length"][::std::mem::offset_of!(jl_svec_t, length) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_genericmemory_t {
    pub length: usize,
    pub ptr: *mut ::std::os::raw::c_void,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_genericmemory_t"][::std::mem::size_of::<jl_genericmemory_t>() - 16usize];
    ["Alignment of jl_genericmemory_t"][::std::mem::align_of::<jl_genericmemory_t>() - 8usize];
    ["Offset of field: jl_genericmemory_t::length"]
        [::std::mem::offset_of!(jl_genericmemory_t, length) - 0usize];
    ["Offset of field: jl_genericmemory_t::ptr"]
        [::std::mem::offset_of!(jl_genericmemory_t, ptr) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_genericmemoryref_t {
    pub ptr_or_offset: *mut ::std::os::raw::c_void,
    pub mem: *mut jl_genericmemory_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_genericmemoryref_t"][::std::mem::size_of::<jl_genericmemoryref_t>() - 16usize];
    ["Alignment of jl_genericmemoryref_t"]
        [::std::mem::align_of::<jl_genericmemoryref_t>() - 8usize];
    ["Offset of field: jl_genericmemoryref_t::ptr_or_offset"]
        [::std::mem::offset_of!(jl_genericmemoryref_t, ptr_or_offset) - 0usize];
    ["Offset of field: jl_genericmemoryref_t::mem"]
        [::std::mem::offset_of!(jl_genericmemoryref_t, mem) - 8usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct jl_array_t {
    pub ref_: jl_genericmemoryref_t,
    pub dimsize: __IncompleteArrayField<usize>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_array_t"][::std::mem::size_of::<jl_array_t>() - 16usize];
    ["Alignment of jl_array_t"][::std::mem::align_of::<jl_array_t>() - 8usize];
    ["Offset of field: jl_array_t::ref_"][::std::mem::offset_of!(jl_array_t, ref_) - 0usize];
    ["Offset of field: jl_array_t::dimsize"][::std::mem::offset_of!(jl_array_t, dimsize) - 16usize];
};
pub type jl_typemap_t = jl_value_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_typename_t {
    pub name: *mut jl_sym_t,
    pub module: *mut _jl_module_t,
    pub names: *mut jl_svec_t,
    pub atomicfields: *const u32,
    pub constfields: *const u32,
    pub wrapper: *mut jl_value_t,
    pub Typeofwrapper: u64,
    pub cache: u64,
    pub linearcache: u64,
    pub mt: *mut _jl_methtable_t,
    pub partial: *mut jl_array_t,
    pub hash: isize,
    pub n_uninitialized: i32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 1usize]>,
    pub max_methods: u8,
    pub constprop_heustic: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_typename_t"][::std::mem::size_of::<jl_typename_t>() - 104usize];
    ["Alignment of jl_typename_t"][::std::mem::align_of::<jl_typename_t>() - 8usize];
    ["Offset of field: jl_typename_t::name"][::std::mem::offset_of!(jl_typename_t, name) - 0usize];
    ["Offset of field: jl_typename_t::module"]
        [::std::mem::offset_of!(jl_typename_t, module) - 8usize];
    ["Offset of field: jl_typename_t::names"]
        [::std::mem::offset_of!(jl_typename_t, names) - 16usize];
    ["Offset of field: jl_typename_t::atomicfields"]
        [::std::mem::offset_of!(jl_typename_t, atomicfields) - 24usize];
    ["Offset of field: jl_typename_t::constfields"]
        [::std::mem::offset_of!(jl_typename_t, constfields) - 32usize];
    ["Offset of field: jl_typename_t::wrapper"]
        [::std::mem::offset_of!(jl_typename_t, wrapper) - 40usize];
    ["Offset of field: jl_typename_t::Typeofwrapper"]
        [::std::mem::offset_of!(jl_typename_t, Typeofwrapper) - 48usize];
    ["Offset of field: jl_typename_t::cache"]
        [::std::mem::offset_of!(jl_typename_t, cache) - 56usize];
    ["Offset of field: jl_typename_t::linearcache"]
        [::std::mem::offset_of!(jl_typename_t, linearcache) - 64usize];
    ["Offset of field: jl_typename_t::mt"][::std::mem::offset_of!(jl_typename_t, mt) - 72usize];
    ["Offset of field: jl_typename_t::partial"]
        [::std::mem::offset_of!(jl_typename_t, partial) - 80usize];
    ["Offset of field: jl_typename_t::hash"][::std::mem::offset_of!(jl_typename_t, hash) - 88usize];
    ["Offset of field: jl_typename_t::n_uninitialized"]
        [::std::mem::offset_of!(jl_typename_t, n_uninitialized) - 96usize];
    ["Offset of field: jl_typename_t::max_methods"]
        [::std::mem::offset_of!(jl_typename_t, max_methods) - 101usize];
    ["Offset of field: jl_typename_t::constprop_heustic"]
        [::std::mem::offset_of!(jl_typename_t, constprop_heustic) - 102usize];
};
impl jl_typename_t {
    #[inline]
    pub fn abstract_(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_abstract(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn abstract__raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_abstract_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn mutabl(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_mutabl(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mutabl_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_mutabl_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn mayinlinealloc(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u8) }
    }
    #[inline]
    pub fn set_mayinlinealloc(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn mayinlinealloc_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set_mayinlinealloc_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn _reserved(&self) -> u8 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 5u8) as u8) }
    }
    #[inline]
    pub fn set__reserved(&mut self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn _reserved_raw(this: *const Self) -> u8 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 1usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                5u8,
            ) as u8)
        }
    }
    #[inline]
    pub unsafe fn set__reserved_raw(this: *mut Self, val: u8) {
        unsafe {
            let val: u8 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 1usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                5u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        abstract_: u8,
        mutabl: u8,
        mayinlinealloc: u8,
        _reserved: u8,
    ) -> __BindgenBitfieldUnit<[u8; 1usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 1usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let abstract_: u8 = unsafe { ::std::mem::transmute(abstract_) };
            abstract_ as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let mutabl: u8 = unsafe { ::std::mem::transmute(mutabl) };
            mutabl as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let mayinlinealloc: u8 = unsafe { ::std::mem::transmute(mayinlinealloc) };
            mayinlinealloc as u64
        });
        __bindgen_bitfield_unit.set(3usize, 5u8, {
            let _reserved: u8 = unsafe { ::std::mem::transmute(_reserved) };
            _reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_datatype_layout_t {
    pub size: u32,
    pub nfields: u32,
    pub npointers: u32,
    pub first_ptr: i32,
    pub alignment: u16,
    pub flags: jl_datatype_layout_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_datatype_layout_t__bindgen_ty_1 {
    pub _bitfield_align_1: [u16; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_datatype_layout_t__bindgen_ty_1"]
        [::std::mem::size_of::<jl_datatype_layout_t__bindgen_ty_1>() - 2usize];
    ["Alignment of jl_datatype_layout_t__bindgen_ty_1"]
        [::std::mem::align_of::<jl_datatype_layout_t__bindgen_ty_1>() - 2usize];
};
impl jl_datatype_layout_t__bindgen_ty_1 {
    #[inline]
    pub fn haspadding(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_haspadding(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn haspadding_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_haspadding_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn fielddesc_type(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 2u8) as u16) }
    }
    #[inline]
    pub fn set_fielddesc_type(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 2u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn fielddesc_type_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                2u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_fielddesc_type_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                2u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn arrayelem_isboxed(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_arrayelem_isboxed(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn arrayelem_isboxed_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_arrayelem_isboxed_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn arrayelem_isunion(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_arrayelem_isunion(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn arrayelem_isunion_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_arrayelem_isunion_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn isbitsegal(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isbitsegal(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn isbitsegal_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_isbitsegal_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn padding(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 10u8) as u16) }
    }
    #[inline]
    pub fn set_padding(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 10u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn padding_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                10u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_padding_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                10u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        haspadding: u16,
        fielddesc_type: u16,
        arrayelem_isboxed: u16,
        arrayelem_isunion: u16,
        isbitsegal: u16,
        padding: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let haspadding: u16 = unsafe { ::std::mem::transmute(haspadding) };
            haspadding as u64
        });
        __bindgen_bitfield_unit.set(1usize, 2u8, {
            let fielddesc_type: u16 = unsafe { ::std::mem::transmute(fielddesc_type) };
            fielddesc_type as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let arrayelem_isboxed: u16 = unsafe { ::std::mem::transmute(arrayelem_isboxed) };
            arrayelem_isboxed as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let arrayelem_isunion: u16 = unsafe { ::std::mem::transmute(arrayelem_isunion) };
            arrayelem_isunion as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let isbitsegal: u16 = unsafe { ::std::mem::transmute(isbitsegal) };
            isbitsegal as u64
        });
        __bindgen_bitfield_unit.set(6usize, 10u8, {
            let padding: u16 = unsafe { ::std::mem::transmute(padding) };
            padding as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_datatype_layout_t"][::std::mem::size_of::<jl_datatype_layout_t>() - 20usize];
    ["Alignment of jl_datatype_layout_t"][::std::mem::align_of::<jl_datatype_layout_t>() - 4usize];
    ["Offset of field: jl_datatype_layout_t::size"]
        [::std::mem::offset_of!(jl_datatype_layout_t, size) - 0usize];
    ["Offset of field: jl_datatype_layout_t::nfields"]
        [::std::mem::offset_of!(jl_datatype_layout_t, nfields) - 4usize];
    ["Offset of field: jl_datatype_layout_t::npointers"]
        [::std::mem::offset_of!(jl_datatype_layout_t, npointers) - 8usize];
    ["Offset of field: jl_datatype_layout_t::first_ptr"]
        [::std::mem::offset_of!(jl_datatype_layout_t, first_ptr) - 12usize];
    ["Offset of field: jl_datatype_layout_t::alignment"]
        [::std::mem::offset_of!(jl_datatype_layout_t, alignment) - 16usize];
    ["Offset of field: jl_datatype_layout_t::flags"]
        [::std::mem::offset_of!(jl_datatype_layout_t, flags) - 18usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_datatype_t {
    pub name: *mut jl_typename_t,
    pub super_: *mut _jl_datatype_t,
    pub parameters: *mut jl_svec_t,
    pub types: *mut jl_svec_t,
    pub instance: *mut jl_value_t,
    pub layout: *const jl_datatype_layout_t,
    pub hash: u32,
    pub _bitfield_align_1: [u8; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 2usize]>,
    pub __bindgen_padding_0: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_datatype_t"][::std::mem::size_of::<_jl_datatype_t>() - 56usize];
    ["Alignment of _jl_datatype_t"][::std::mem::align_of::<_jl_datatype_t>() - 8usize];
    ["Offset of field: _jl_datatype_t::name"]
        [::std::mem::offset_of!(_jl_datatype_t, name) - 0usize];
    ["Offset of field: _jl_datatype_t::super_"]
        [::std::mem::offset_of!(_jl_datatype_t, super_) - 8usize];
    ["Offset of field: _jl_datatype_t::parameters"]
        [::std::mem::offset_of!(_jl_datatype_t, parameters) - 16usize];
    ["Offset of field: _jl_datatype_t::types"]
        [::std::mem::offset_of!(_jl_datatype_t, types) - 24usize];
    ["Offset of field: _jl_datatype_t::instance"]
        [::std::mem::offset_of!(_jl_datatype_t, instance) - 32usize];
    ["Offset of field: _jl_datatype_t::layout"]
        [::std::mem::offset_of!(_jl_datatype_t, layout) - 40usize];
    ["Offset of field: _jl_datatype_t::hash"]
        [::std::mem::offset_of!(_jl_datatype_t, hash) - 48usize];
};
impl _jl_datatype_t {
    #[inline]
    pub fn hasfreetypevars(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_hasfreetypevars(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn hasfreetypevars_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                0usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_hasfreetypevars_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                0usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn isconcretetype(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isconcretetype(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn isconcretetype_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                1usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_isconcretetype_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                1usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn isdispatchtuple(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isdispatchtuple(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn isdispatchtuple_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                2usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_isdispatchtuple_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                2usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn isbitstype(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isbitstype(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn isbitstype_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                3usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_isbitstype_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                3usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn zeroinit(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_zeroinit(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn zeroinit_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                4usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_zeroinit_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                4usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn has_concrete_subtype(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(5usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_has_concrete_subtype(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(5usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn has_concrete_subtype_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                5usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_has_concrete_subtype_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                5usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn maybe_subtype_of_cache(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(6usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_maybe_subtype_of_cache(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(6usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn maybe_subtype_of_cache_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                6usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_maybe_subtype_of_cache_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                6usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn isprimitivetype(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(7usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isprimitivetype(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(7usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn isprimitivetype_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                7usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_isprimitivetype_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                7usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn ismutationfree(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_ismutationfree(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn ismutationfree_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                8usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_ismutationfree_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                8usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn isidentityfree(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(9usize, 1u8) as u16) }
    }
    #[inline]
    pub fn set_isidentityfree(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(9usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn isidentityfree_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                9usize,
                1u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_isidentityfree_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                9usize,
                1u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn smalltag(&self) -> u16 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(10usize, 6u8) as u16) }
    }
    #[inline]
    pub fn set_smalltag(&mut self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            self._bitfield_1.set(10usize, 6u8, val as u64)
        }
    }
    #[inline]
    pub unsafe fn smalltag_raw(this: *const Self) -> u16 {
        unsafe {
            ::std::mem::transmute(<__BindgenBitfieldUnit<[u8; 2usize]>>::raw_get(
                ::std::ptr::addr_of!((*this)._bitfield_1),
                10usize,
                6u8,
            ) as u16)
        }
    }
    #[inline]
    pub unsafe fn set_smalltag_raw(this: *mut Self, val: u16) {
        unsafe {
            let val: u16 = ::std::mem::transmute(val);
            <__BindgenBitfieldUnit<[u8; 2usize]>>::raw_set(
                ::std::ptr::addr_of_mut!((*this)._bitfield_1),
                10usize,
                6u8,
                val as u64,
            )
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        hasfreetypevars: u16,
        isconcretetype: u16,
        isdispatchtuple: u16,
        isbitstype: u16,
        zeroinit: u16,
        has_concrete_subtype: u16,
        maybe_subtype_of_cache: u16,
        isprimitivetype: u16,
        ismutationfree: u16,
        isidentityfree: u16,
        smalltag: u16,
    ) -> __BindgenBitfieldUnit<[u8; 2usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 2usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let hasfreetypevars: u16 = unsafe { ::std::mem::transmute(hasfreetypevars) };
            hasfreetypevars as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let isconcretetype: u16 = unsafe { ::std::mem::transmute(isconcretetype) };
            isconcretetype as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let isdispatchtuple: u16 = unsafe { ::std::mem::transmute(isdispatchtuple) };
            isdispatchtuple as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let isbitstype: u16 = unsafe { ::std::mem::transmute(isbitstype) };
            isbitstype as u64
        });
        __bindgen_bitfield_unit.set(4usize, 1u8, {
            let zeroinit: u16 = unsafe { ::std::mem::transmute(zeroinit) };
            zeroinit as u64
        });
        __bindgen_bitfield_unit.set(5usize, 1u8, {
            let has_concrete_subtype: u16 = unsafe { ::std::mem::transmute(has_concrete_subtype) };
            has_concrete_subtype as u64
        });
        __bindgen_bitfield_unit.set(6usize, 1u8, {
            let maybe_subtype_of_cache: u16 =
                unsafe { ::std::mem::transmute(maybe_subtype_of_cache) };
            maybe_subtype_of_cache as u64
        });
        __bindgen_bitfield_unit.set(7usize, 1u8, {
            let isprimitivetype: u16 = unsafe { ::std::mem::transmute(isprimitivetype) };
            isprimitivetype as u64
        });
        __bindgen_bitfield_unit.set(8usize, 1u8, {
            let ismutationfree: u16 = unsafe { ::std::mem::transmute(ismutationfree) };
            ismutationfree as u64
        });
        __bindgen_bitfield_unit.set(9usize, 1u8, {
            let isidentityfree: u16 = unsafe { ::std::mem::transmute(isidentityfree) };
            isidentityfree as u64
        });
        __bindgen_bitfield_unit.set(10usize, 6u8, {
            let smalltag: u16 = unsafe { ::std::mem::transmute(smalltag) };
            smalltag as u64
        });
        __bindgen_bitfield_unit
    }
}
pub type jl_datatype_t = _jl_datatype_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_weakref_t {
    pub value: *mut jl_value_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_weakref_t"][::std::mem::size_of::<_jl_weakref_t>() - 8usize];
    ["Alignment of _jl_weakref_t"][::std::mem::align_of::<_jl_weakref_t>() - 8usize];
    ["Offset of field: _jl_weakref_t::value"]
        [::std::mem::offset_of!(_jl_weakref_t, value) - 0usize];
};
pub type jl_weakref_t = _jl_weakref_t;
pub type jl_ptr_kind_union_t = usize;
#[repr(C)]
#[derive(Debug)]
pub struct _jl_binding_partition_t {
    pub restriction: std_atomic<jl_ptr_kind_union_t>,
    pub min_world: usize,
    pub max_world: std_atomic<usize>,
    pub next: u64,
    pub reserved: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_binding_partition_t"][::std::mem::size_of::<_jl_binding_partition_t>() - 40usize];
    ["Alignment of _jl_binding_partition_t"]
        [::std::mem::align_of::<_jl_binding_partition_t>() - 8usize];
    ["Offset of field: _jl_binding_partition_t::restriction"]
        [::std::mem::offset_of!(_jl_binding_partition_t, restriction) - 0usize];
    ["Offset of field: _jl_binding_partition_t::min_world"]
        [::std::mem::offset_of!(_jl_binding_partition_t, min_world) - 8usize];
    ["Offset of field: _jl_binding_partition_t::max_world"]
        [::std::mem::offset_of!(_jl_binding_partition_t, max_world) - 16usize];
    ["Offset of field: _jl_binding_partition_t::next"]
        [::std::mem::offset_of!(_jl_binding_partition_t, next) - 24usize];
    ["Offset of field: _jl_binding_partition_t::reserved"]
        [::std::mem::offset_of!(_jl_binding_partition_t, reserved) - 32usize];
};
pub type jl_binding_partition_t = _jl_binding_partition_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct jl_uuid_t {
    pub hi: u64,
    pub lo: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of jl_uuid_t"][::std::mem::size_of::<jl_uuid_t>() - 16usize];
    ["Alignment of jl_uuid_t"][::std::mem::align_of::<jl_uuid_t>() - 8usize];
    ["Offset of field: jl_uuid_t::hi"][::std::mem::offset_of!(jl_uuid_t, hi) - 0usize];
    ["Offset of field: jl_uuid_t::lo"][::std::mem::offset_of!(jl_uuid_t, lo) - 8usize];
};
#[repr(C)]
#[derive(Debug)]
pub struct _jl_module_t {
    pub name: *mut jl_sym_t,
    pub parent: *mut _jl_module_t,
    pub bindings: u64,
    pub bindingkeyset: u64,
    pub file: *mut jl_sym_t,
    pub line: i32,
    pub usings_backedges: *mut jl_value_t,
    pub usings: arraylist_t,
    pub build_id: jl_uuid_t,
    pub uuid: jl_uuid_t,
    pub counter: std_atomic<u32>,
    pub nospecialize: i32,
    pub optlevel: i8,
    pub compile: i8,
    pub infer: i8,
    pub istopmod: u8,
    pub max_methods: i8,
    pub lock: jl_mutex_t,
    pub hash: isize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_module_t"][::std::mem::size_of::<_jl_module_t>() - 384usize];
    ["Alignment of _jl_module_t"][::std::mem::align_of::<_jl_module_t>() - 8usize];
    ["Offset of field: _jl_module_t::name"][::std::mem::offset_of!(_jl_module_t, name) - 0usize];
    ["Offset of field: _jl_module_t::parent"]
        [::std::mem::offset_of!(_jl_module_t, parent) - 8usize];
    ["Offset of field: _jl_module_t::bindings"]
        [::std::mem::offset_of!(_jl_module_t, bindings) - 16usize];
    ["Offset of field: _jl_module_t::bindingkeyset"]
        [::std::mem::offset_of!(_jl_module_t, bindingkeyset) - 24usize];
    ["Offset of field: _jl_module_t::file"][::std::mem::offset_of!(_jl_module_t, file) - 32usize];
    ["Offset of field: _jl_module_t::line"][::std::mem::offset_of!(_jl_module_t, line) - 40usize];
    ["Offset of field: _jl_module_t::usings_backedges"]
        [::std::mem::offset_of!(_jl_module_t, usings_backedges) - 48usize];
    ["Offset of field: _jl_module_t::usings"]
        [::std::mem::offset_of!(_jl_module_t, usings) - 56usize];
    ["Offset of field: _jl_module_t::build_id"]
        [::std::mem::offset_of!(_jl_module_t, build_id) - 312usize];
    ["Offset of field: _jl_module_t::uuid"][::std::mem::offset_of!(_jl_module_t, uuid) - 328usize];
    ["Offset of field: _jl_module_t::counter"]
        [::std::mem::offset_of!(_jl_module_t, counter) - 344usize];
    ["Offset of field: _jl_module_t::nospecialize"]
        [::std::mem::offset_of!(_jl_module_t, nospecialize) - 348usize];
    ["Offset of field: _jl_module_t::optlevel"]
        [::std::mem::offset_of!(_jl_module_t, optlevel) - 352usize];
    ["Offset of field: _jl_module_t::compile"]
        [::std::mem::offset_of!(_jl_module_t, compile) - 353usize];
    ["Offset of field: _jl_module_t::infer"]
        [::std::mem::offset_of!(_jl_module_t, infer) - 354usize];
    ["Offset of field: _jl_module_t::istopmod"]
        [::std::mem::offset_of!(_jl_module_t, istopmod) - 355usize];
    ["Offset of field: _jl_module_t::max_methods"]
        [::std::mem::offset_of!(_jl_module_t, max_methods) - 356usize];
    ["Offset of field: _jl_module_t::lock"][::std::mem::offset_of!(_jl_module_t, lock) - 360usize];
    ["Offset of field: _jl_module_t::hash"][::std::mem::offset_of!(_jl_module_t, hash) - 376usize];
};
pub type jl_module_t = _jl_module_t;
#[repr(C)]
#[derive(Debug)]
pub struct _jl_methtable_t {
    pub name: *mut jl_sym_t,
    pub defs: u64,
    pub leafcache: u64,
    pub cache: u64,
    pub max_args: std_atomic<isize>,
    pub module: *mut jl_module_t,
    pub backedges: *mut jl_array_t,
    pub writelock: jl_mutex_t,
    pub offs: u8,
    pub frozen: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_methtable_t"][::std::mem::size_of::<_jl_methtable_t>() - 80usize];
    ["Alignment of _jl_methtable_t"][::std::mem::align_of::<_jl_methtable_t>() - 8usize];
    ["Offset of field: _jl_methtable_t::name"]
        [::std::mem::offset_of!(_jl_methtable_t, name) - 0usize];
    ["Offset of field: _jl_methtable_t::defs"]
        [::std::mem::offset_of!(_jl_methtable_t, defs) - 8usize];
    ["Offset of field: _jl_methtable_t::leafcache"]
        [::std::mem::offset_of!(_jl_methtable_t, leafcache) - 16usize];
    ["Offset of field: _jl_methtable_t::cache"]
        [::std::mem::offset_of!(_jl_methtable_t, cache) - 24usize];
    ["Offset of field: _jl_methtable_t::max_args"]
        [::std::mem::offset_of!(_jl_methtable_t, max_args) - 32usize];
    ["Offset of field: _jl_methtable_t::module"]
        [::std::mem::offset_of!(_jl_methtable_t, module) - 40usize];
    ["Offset of field: _jl_methtable_t::backedges"]
        [::std::mem::offset_of!(_jl_methtable_t, backedges) - 48usize];
    ["Offset of field: _jl_methtable_t::writelock"]
        [::std::mem::offset_of!(_jl_methtable_t, writelock) - 56usize];
    ["Offset of field: _jl_methtable_t::offs"]
        [::std::mem::offset_of!(_jl_methtable_t, offs) - 72usize];
    ["Offset of field: _jl_methtable_t::frozen"]
        [::std::mem::offset_of!(_jl_methtable_t, frozen) - 73usize];
};
pub const jl_small_typeof_tags_jl_null_tag: jl_small_typeof_tags = 0;
pub const jl_small_typeof_tags_jl_typeofbottom_tag: jl_small_typeof_tags = 1;
pub const jl_small_typeof_tags_jl_datatype_tag: jl_small_typeof_tags = 2;
pub const jl_small_typeof_tags_jl_unionall_tag: jl_small_typeof_tags = 3;
pub const jl_small_typeof_tags_jl_uniontype_tag: jl_small_typeof_tags = 4;
pub const jl_small_typeof_tags_jl_vararg_tag: jl_small_typeof_tags = 5;
pub const jl_small_typeof_tags_jl_tvar_tag: jl_small_typeof_tags = 6;
pub const jl_small_typeof_tags_jl_symbol_tag: jl_small_typeof_tags = 7;
pub const jl_small_typeof_tags_jl_module_tag: jl_small_typeof_tags = 8;
pub const jl_small_typeof_tags_jl_simplevector_tag: jl_small_typeof_tags = 9;
pub const jl_small_typeof_tags_jl_string_tag: jl_small_typeof_tags = 10;
pub const jl_small_typeof_tags_jl_task_tag: jl_small_typeof_tags = 11;
pub const jl_small_typeof_tags_jl_bool_tag: jl_small_typeof_tags = 12;
pub const jl_small_typeof_tags_jl_char_tag: jl_small_typeof_tags = 13;
pub const jl_small_typeof_tags_jl_int16_tag: jl_small_typeof_tags = 14;
pub const jl_small_typeof_tags_jl_int32_tag: jl_small_typeof_tags = 15;
pub const jl_small_typeof_tags_jl_int64_tag: jl_small_typeof_tags = 16;
pub const jl_small_typeof_tags_jl_int8_tag: jl_small_typeof_tags = 17;
pub const jl_small_typeof_tags_jl_uint16_tag: jl_small_typeof_tags = 18;
pub const jl_small_typeof_tags_jl_uint32_tag: jl_small_typeof_tags = 19;
pub const jl_small_typeof_tags_jl_uint64_tag: jl_small_typeof_tags = 20;
pub const jl_small_typeof_tags_jl_uint8_tag: jl_small_typeof_tags = 21;
pub const jl_small_typeof_tags_jl_tags_count: jl_small_typeof_tags = 22;
pub const jl_small_typeof_tags_jl_bitstags_first: jl_small_typeof_tags = 13;
pub const jl_small_typeof_tags_jl_max_tags: jl_small_typeof_tags = 64;
pub type jl_small_typeof_tags = ::std::os::raw::c_uint;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_gcframe_t {
    pub nroots: usize,
    pub prev: *mut _jl_gcframe_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_gcframe_t"][::std::mem::size_of::<_jl_gcframe_t>() - 16usize];
    ["Alignment of _jl_gcframe_t"][::std::mem::align_of::<_jl_gcframe_t>() - 8usize];
    ["Offset of field: _jl_gcframe_t::nroots"]
        [::std::mem::offset_of!(_jl_gcframe_t, nroots) - 0usize];
    ["Offset of field: _jl_gcframe_t::prev"][::std::mem::offset_of!(_jl_gcframe_t, prev) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_handler_t {
    pub eh_ctx: sigjmp_buf,
    pub gcstack: *mut jl_gcframe_t,
    pub scope: *mut jl_value_t,
    pub prev: *mut _jl_handler_t,
    pub gc_state: i8,
    pub locks_len: usize,
    pub defer_signal: sig_atomic_t,
    pub timing_stack: *mut jl_timing_block_t,
    pub world_age: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_handler_t"][::std::mem::size_of::<_jl_handler_t>() - 264usize];
    ["Alignment of _jl_handler_t"][::std::mem::align_of::<_jl_handler_t>() - 8usize];
    ["Offset of field: _jl_handler_t::eh_ctx"]
        [::std::mem::offset_of!(_jl_handler_t, eh_ctx) - 0usize];
    ["Offset of field: _jl_handler_t::gcstack"]
        [::std::mem::offset_of!(_jl_handler_t, gcstack) - 200usize];
    ["Offset of field: _jl_handler_t::scope"]
        [::std::mem::offset_of!(_jl_handler_t, scope) - 208usize];
    ["Offset of field: _jl_handler_t::prev"]
        [::std::mem::offset_of!(_jl_handler_t, prev) - 216usize];
    ["Offset of field: _jl_handler_t::gc_state"]
        [::std::mem::offset_of!(_jl_handler_t, gc_state) - 224usize];
    ["Offset of field: _jl_handler_t::locks_len"]
        [::std::mem::offset_of!(_jl_handler_t, locks_len) - 232usize];
    ["Offset of field: _jl_handler_t::defer_signal"]
        [::std::mem::offset_of!(_jl_handler_t, defer_signal) - 240usize];
    ["Offset of field: _jl_handler_t::timing_stack"]
        [::std::mem::offset_of!(_jl_handler_t, timing_stack) - 248usize];
    ["Offset of field: _jl_handler_t::world_age"]
        [::std::mem::offset_of!(_jl_handler_t, world_age) - 256usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct _jl_bt_element_t {
    pub __bindgen_anon_1: _jl_bt_element_t__bindgen_ty_1,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub union _jl_bt_element_t__bindgen_ty_1 {
    pub uintptr: usize,
    pub jlvalue: *mut jl_value_t,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_bt_element_t__bindgen_ty_1"]
        [::std::mem::size_of::<_jl_bt_element_t__bindgen_ty_1>() - 8usize];
    ["Alignment of _jl_bt_element_t__bindgen_ty_1"]
        [::std::mem::align_of::<_jl_bt_element_t__bindgen_ty_1>() - 8usize];
    ["Offset of field: _jl_bt_element_t__bindgen_ty_1::uintptr"]
        [::std::mem::offset_of!(_jl_bt_element_t__bindgen_ty_1, uintptr) - 0usize];
    ["Offset of field: _jl_bt_element_t__bindgen_ty_1::jlvalue"]
        [::std::mem::offset_of!(_jl_bt_element_t__bindgen_ty_1, jlvalue) - 0usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_bt_element_t"][::std::mem::size_of::<_jl_bt_element_t>() - 8usize];
    ["Alignment of _jl_bt_element_t"][::std::mem::align_of::<_jl_bt_element_t>() - 8usize];
};
pub type jl_bt_element_t = _jl_bt_element_t;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_excstack_t {
    pub top: usize,
    pub reserved_size: usize,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of _jl_excstack_t"][::std::mem::size_of::<_jl_excstack_t>() - 16usize];
    ["Alignment of _jl_excstack_t"][::std::mem::align_of::<_jl_excstack_t>() - 8usize];
    ["Offset of field: _jl_excstack_t::top"][::std::mem::offset_of!(_jl_excstack_t, top) - 0usize];
    ["Offset of field: _jl_excstack_t::reserved_size"]
        [::std::mem::offset_of!(_jl_excstack_t, reserved_size) - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_size_t_close0"]
        [::std::mem::size_of::<std_atomic<usize>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_size_t_close0"]
        [::std::mem::align_of::<std_atomic<usize>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_int64_t_close0"]
        [::std::mem::size_of::<std_atomic<i64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_int64_t_close0"]
        [::std::mem::align_of::<std_atomic<i64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_int64_t_close0"]
        [::std::mem::size_of::<std_atomic<i64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_int64_t_close0"]
        [::std::mem::align_of::<std_atomic<i64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::size_of::<std_atomic<u64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::align_of::<std_atomic<u64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::size_of::<std_atomic<u64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::align_of::<std_atomic<u64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::size_of::<std_atomic<u64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::align_of::<std_atomic<u64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::size_of::<std_atomic<u64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::align_of::<std_atomic<u64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_int64_t_close0"]
        [::std::mem::size_of::<std_atomic<i64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_int64_t_close0"]
        [::std::mem::align_of::<std_atomic<i64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::size_of::<std_atomic<u64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::align_of::<std_atomic<u64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_int8_t_close0"]
        [::std::mem::size_of::<std_atomic<i8>>() - 1usize];
    ["Align of template specialization: std_atomic_open0_int8_t_close0"]
        [::std::mem::align_of::<std_atomic<i8>>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_int8_t_close0"]
        [::std::mem::size_of::<std_atomic<i8>>() - 1usize];
    ["Align of template specialization: std_atomic_open0_int8_t_close0"]
        [::std::mem::align_of::<std_atomic<i8>>() - 1usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct _jl_timing_block_t {
    pub _address: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_sig_atomic_t_close0"]
        [::std::mem::size_of::<std_atomic<sig_atomic_t>>() - 4usize];
    ["Align of template specialization: std_atomic_open0_sig_atomic_t_close0"]
        [::std::mem::align_of::<std_atomic<sig_atomic_t>>() - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_int16_t_close0"]
        [::std::mem::size_of::<std_atomic<i16>>() - 2usize];
    ["Align of template specialization: std_atomic_open0_int16_t_close0"]
        [::std::mem::align_of::<std_atomic<i16>>() - 2usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint8_t_close0"]
        [::std::mem::size_of::<std_atomic<u8>>() - 1usize];
    ["Align of template specialization: std_atomic_open0_uint8_t_close0"]
        [::std::mem::align_of::<std_atomic<u8>>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint8_t_close0"]
        [::std::mem::size_of::<std_atomic<u8>>() - 1usize];
    ["Align of template specialization: std_atomic_open0_uint8_t_close0"]
        [::std::mem::align_of::<std_atomic<u8>>() - 1usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::size_of::<std_atomic<u64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::align_of::<std_atomic<u64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::size_of::<std_atomic<u64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::align_of::<std_atomic<u64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::size_of::<std_atomic<u64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::align_of::<std_atomic<u64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::size_of::<std_atomic<u64>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_uint64_t_close0"]
        [::std::mem::align_of::<std_atomic<u64>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_int16_t_close0"]
        [::std::mem::size_of::<std_atomic<i16>>() - 2usize];
    ["Align of template specialization: std_atomic_open0_int16_t_close0"]
        [::std::mem::align_of::<std_atomic<i16>>() - 2usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_jl_ptr_kind_union_t_close0"]
        [::std::mem::size_of::<std_atomic<jl_ptr_kind_union_t>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_jl_ptr_kind_union_t_close0"]
        [::std::mem::align_of::<std_atomic<jl_ptr_kind_union_t>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_size_t_close0"]
        [::std::mem::size_of::<std_atomic<usize>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_size_t_close0"]
        [::std::mem::align_of::<std_atomic<usize>>() - 8usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_uint32_t_close0"]
        [::std::mem::size_of::<std_atomic<u32>>() - 4usize];
    ["Align of template specialization: std_atomic_open0_uint32_t_close0"]
        [::std::mem::align_of::<std_atomic<u32>>() - 4usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of template specialization: std_atomic_open0_intptr_t_close0"]
        [::std::mem::size_of::<std_atomic<isize>>() - 8usize];
    ["Align of template specialization: std_atomic_open0_intptr_t_close0"]
        [::std::mem::align_of::<std_atomic<isize>>() - 8usize];
};
