%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%  This file is part of VivoMind Prolog Unicode Resources
%  SPDX-License-Identifier: CC0-1.0
%
%  VivoMind Prolog Unicode Resources is free software distributed using the
%  Creative Commons CC0 1.0 Universal (CC0 1.0) - Public Domain Dedication
%  license
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%  Last modified: March 19, 2012
%
%  Original Unicode file header comments follow

/*
# Jamo-6.1.0.txt
# Date: 2011-06-22, 23:07:00 GMT [KW, LI]
#
# Unicode Character Database
# Copyright (c) 1991-2011 Unicode, Inc.
# For terms of use, see http://www.unicode.org/terms_of_use.html
# For documentation, see http://www.unicode.org/reports/tr44/
#
# This file defines the Jamo_Short_Name property.
#
# See Section 3.12 of The Unicode Standard, Version 6.1
# for more information.
#
# Each line contains two fields, separated by a semicolon.
#
# The first field gives the code point, in 4-digit hexadecimal
# form, of a conjoining jamo character that participates in the
# algorithmic determination of Hangul syllable character names.
# The second field gives the Jamo_Short_Name as a one-, two-,
# or three-character ASCII string (or in one case, for U+110B,
# the null string).
#
# #############################################################
*/

unicode_jamo(0x1100, "G").		% HANGUL CHOSEONG KIYEOK
unicode_jamo(0x1101, "GG").		% HANGUL CHOSEONG SSANGKIYEOK
unicode_jamo(0x1102, "N").		% HANGUL CHOSEONG NIEUN
unicode_jamo(0x1103, "D").		% HANGUL CHOSEONG TIKEUT
unicode_jamo(0x1104, "DD").		% HANGUL CHOSEONG SSANGTIKEUT
unicode_jamo(0x1105, "R").		% HANGUL CHOSEONG RIEUL
unicode_jamo(0x1106, "M").		% HANGUL CHOSEONG MIEUM
unicode_jamo(0x1107, "B").		% HANGUL CHOSEONG PIEUP
unicode_jamo(0x1108, "BB").		% HANGUL CHOSEONG SSANGPIEUP
unicode_jamo(0x1109, "S").		% HANGUL CHOSEONG SIOS
unicode_jamo(0x110A, "SS").		% HANGUL CHOSEONG SSANGSIOS
unicode_jamo(0x110B, "").		% HANGUL CHOSEONG IEUNG
unicode_jamo(0x110C, "J").		% HANGUL CHOSEONG CIEUC
unicode_jamo(0x110D, "JJ").		% HANGUL CHOSEONG SSANGCIEUC
unicode_jamo(0x110E, "C").		% HANGUL CHOSEONG CHIEUCH
unicode_jamo(0x110F, "K").		% HANGUL CHOSEONG KHIEUKH
unicode_jamo(0x1110, "T").		% HANGUL CHOSEONG THIEUTH
unicode_jamo(0x1111, "P").		% HANGUL CHOSEONG PHIEUPH
unicode_jamo(0x1112, "H").		% HANGUL CHOSEONG HIEUH
unicode_jamo(0x1161, "A").		% HANGUL JUNGSEONG A
unicode_jamo(0x1162, "AE").		% HANGUL JUNGSEONG AE
unicode_jamo(0x1163, "YA").		% HANGUL JUNGSEONG YA
unicode_jamo(0x1164, "YAE").	% HANGUL JUNGSEONG YAE
unicode_jamo(0x1165, "EO").		% HANGUL JUNGSEONG EO
unicode_jamo(0x1166, "E").		% HANGUL JUNGSEONG E
unicode_jamo(0x1167, "YEO").	% HANGUL JUNGSEONG YEO
unicode_jamo(0x1168, "YE").		% HANGUL JUNGSEONG YE
unicode_jamo(0x1169, "O").		% HANGUL JUNGSEONG O
unicode_jamo(0x116A, "WA").		% HANGUL JUNGSEONG WA
unicode_jamo(0x116B, "WAE").	% HANGUL JUNGSEONG WAE
unicode_jamo(0x116C, "OE").		% HANGUL JUNGSEONG OE
unicode_jamo(0x116D, "YO").		% HANGUL JUNGSEONG YO
unicode_jamo(0x116E, "U").		% HANGUL JUNGSEONG U
unicode_jamo(0x116F, "WEO").	% HANGUL JUNGSEONG WEO
unicode_jamo(0x1170, "WE").		% HANGUL JUNGSEONG WE
unicode_jamo(0x1171, "WI").		% HANGUL JUNGSEONG WI
unicode_jamo(0x1172, "YU").		% HANGUL JUNGSEONG YU
unicode_jamo(0x1173, "EU").		% HANGUL JUNGSEONG EU
unicode_jamo(0x1174, "YI").		% HANGUL JUNGSEONG YI
unicode_jamo(0x1175, "I").		% HANGUL JUNGSEONG I
unicode_jamo(0x11A8, "G").		% HANGUL JONGSEONG KIYEOK
unicode_jamo(0x11A9, "GG").		% HANGUL JONGSEONG SSANGKIYEOK
unicode_jamo(0x11AA, "GS").		% HANGUL JONGSEONG KIYEOK-SIOS
unicode_jamo(0x11AB, "N").		% HANGUL JONGSEONG NIEUN
unicode_jamo(0x11AC, "NJ").		% HANGUL JONGSEONG NIEUN-CIEUC
unicode_jamo(0x11AD, "NH").		% HANGUL JONGSEONG NIEUN-HIEUH
unicode_jamo(0x11AE, "D").		% HANGUL JONGSEONG TIKEUT
unicode_jamo(0x11AF, "L").		% HANGUL JONGSEONG RIEUL
unicode_jamo(0x11B0, "LG").		% HANGUL JONGSEONG RIEUL-KIYEOK
unicode_jamo(0x11B1, "LM").		% HANGUL JONGSEONG RIEUL-MIEUM
unicode_jamo(0x11B2, "LB").		% HANGUL JONGSEONG RIEUL-PIEUP
unicode_jamo(0x11B3, "LS").		% HANGUL JONGSEONG RIEUL-SIOS
unicode_jamo(0x11B4, "LT").		% HANGUL JONGSEONG RIEUL-THIEUTH
unicode_jamo(0x11B5, "LP").		% HANGUL JONGSEONG RIEUL-PHIEUPH
unicode_jamo(0x11B6, "LH").		% HANGUL JONGSEONG RIEUL-HIEUH
unicode_jamo(0x11B7, "M").		% HANGUL JONGSEONG MIEUM
unicode_jamo(0x11B8, "B").		% HANGUL JONGSEONG PIEUP
unicode_jamo(0x11B9, "BS").		% HANGUL JONGSEONG PIEUP-SIOS
unicode_jamo(0x11BA, "S").		% HANGUL JONGSEONG SIOS
unicode_jamo(0x11BB, "SS").		% HANGUL JONGSEONG SSANGSIOS
unicode_jamo(0x11BC, "NG").		% HANGUL JONGSEONG IEUNG
unicode_jamo(0x11BD, "J").		% HANGUL JONGSEONG CIEUC
unicode_jamo(0x11BE, "C").		% HANGUL JONGSEONG CHIEUCH
unicode_jamo(0x11BF, "K").		% HANGUL JONGSEONG KHIEUKH
unicode_jamo(0x11C0, "T").		% HANGUL JONGSEONG THIEUTH
unicode_jamo(0x11C1, "P").		% HANGUL JONGSEONG PHIEUPH
unicode_jamo(0x11C2, "H").		% HANGUL JONGSEONG HIEUH
