/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.aether.internal.impl.collect;

import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.CollectResult;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.impl.DependencyCollector;
import org.eclipse.aether.internal.impl.collect.DependencyCollectorDelegate;
import org.eclipse.aether.util.ConfigUtils;

@Singleton
@Named
public class DefaultDependencyCollector
implements DependencyCollector {
    public static final String CONFIG_PROPS_PREFIX = "aether.dependencyCollector.";
    public static final String CONFIG_PROP_COLLECTOR_IMPL = "aether.dependencyCollector.impl";
    public static final String DEFAULT_COLLECTOR_IMPL = "bf";
    private final Map<String, DependencyCollectorDelegate> delegates;

    @Inject
    public DefaultDependencyCollector(Map<String, DependencyCollectorDelegate> delegates) {
        this.delegates = Objects.requireNonNull(delegates);
    }

    @Override
    public CollectResult collectDependencies(RepositorySystemSession session, CollectRequest request) throws DependencyCollectionException {
        String delegateName = ConfigUtils.getString((RepositorySystemSession)session, (String)DEFAULT_COLLECTOR_IMPL, (String[])new String[]{CONFIG_PROP_COLLECTOR_IMPL});
        DependencyCollectorDelegate delegate = this.delegates.get(delegateName);
        if (delegate == null) {
            throw new IllegalArgumentException("Unknown collector impl: '" + delegateName + "', known implementations are " + this.delegates.keySet());
        }
        return delegate.collectDependencies(session, request);
    }
}

