<!--startmeta
custom_edit_url: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/pulsar/README.md"
meta_yaml: "https://github.com/netdata/netdata/edit/master/src/go/plugin/go.d/collector/pulsar/metadata.yaml"
sidebar_label: "Apache Pulsar"
learn_status: "Published"
learn_rel_path: "Collecting Metrics/Message Brokers"
most_popular: True
message: "DO NOT EDIT THIS FILE DIRECTLY, IT IS GENERATED BY THE COLLECTOR'S metadata.yaml FILE"
endmeta-->

# Apache Pulsar


<img src="https://netdata.cloud/img/pulsar.svg" width="150"/>


Plugin: go.d.plugin
Module: pulsar

<img src="https://img.shields.io/badge/maintained%20by-Netdata-%2300ab44" />

## Overview

This collector monitors Pulsar servers.


It collects broker statistics using Pulsar's [Prometheus endpoint](https://pulsar.apache.org/docs/en/deploy-monitoring/#broker-stats).


This collector is supported on all platforms.

This collector supports collecting metrics from multiple instances of this integration, including remote instances.


### Default Behavior

#### Auto-Detection

By default, it detects Pulsar instances running on localhost.


#### Limits

The default configuration for this integration does not impose any limits on data collection.

#### Performance Impact

The default configuration for this integration is not expected to impose a significant performance impact on the system.

## Metrics

Metrics grouped by *scope*.

The scope defines the instance that the metric belongs to. An instance is uniquely identified by a set of labels.

- topic_* metrics are available when `exposeTopicLevelMetricsInPrometheus` is set to true.
- subscription_* and namespace_subscription metrics are available when `exposeTopicLevelMetricsInPrometheus` si set to true.
- replication_* and namespace_replication_* metrics are available when replication is configured and `replicationMetricsEnabled` is set to true.


### Per Apache Pulsar instance

These metrics refer to the entire monitored application.

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| pulsar.broker_components | namespaces, topics, subscriptions, producers, consumers | components |
| pulsar.messages_rate | publish, dispatch | messages/s |
| pulsar.throughput_rate | publish, dispatch | KiB/s |
| pulsar.storage_size | used | KiB |
| pulsar.storage_operations_rate | read, write | message batches/s |
| pulsar.msg_backlog | backlog | messages |
| pulsar.storage_write_latency | <=0.5ms, <=1ms, <=5ms, =10ms, <=20ms, <=50ms, <=100ms, <=200ms, <=1s, >1s | entries/s |
| pulsar.entry_size | <=128B, <=512B, <=1KB, <=2KB, <=4KB, <=16KB, <=100KB, <=1MB, >1MB | entries/s |
| pulsar.subscription_delayed | delayed | message batches |
| pulsar.subscription_msg_rate_redeliver | redelivered | messages/s |
| pulsar.subscription_blocked_on_unacked_messages | blocked | subscriptions |
| pulsar.replication_rate | in, out | messages/s |
| pulsar.replication_throughput_rate | in, out | KiB/s |
| pulsar.replication_backlog | backlog | messages |

### Per namespace

TBD

This scope has no labels.

Metrics:

| Metric | Dimensions | Unit |
|:------|:----------|:----|
| pulsar.namespace_broker_components | topics, subscriptions, producers, consumers | components |
| pulsar.namespace_messages_rate | publish, dispatch | messages/s |
| pulsar.namespace_throughput_rate | publish, dispatch | KiB/s |
| pulsar.namespace_storage_size | used | KiB |
| pulsar.namespace_storage_operations_rate | read, write | message batches/s |
| pulsar.namespace_msg_backlog | backlog | messages |
| pulsar.namespace_storage_write_latency | <=0.5ms, <=1ms, <=5ms, =10ms, <=20ms, <=50ms, <=100ms, <=200ms, <=1s, >1s | entries/s |
| pulsar.namespace_entry_size | <=128B, <=512B, <=1KB, <=2KB, <=4KB, <=16KB, <=100KB, <=1MB, >1MB | entries/s |
| pulsar.namespace_subscription_delayed | delayed | message batches |
| pulsar.namespace_subscription_msg_rate_redeliver | redelivered | messages/s |
| pulsar.namespace_subscription_blocked_on_unacked_messages | blocked | subscriptions |
| pulsar.namespace_replication_rate | in, out | messages/s |
| pulsar.namespace_replication_throughput_rate | in, out | KiB/s |
| pulsar.namespace_replication_backlog | backlog | messages |
| pulsar.topic_producers | a dimension per topic | producers |
| pulsar.topic_subscriptions | a dimension per topic | subscriptions |
| pulsar.topic_consumers | a dimension per topic | consumers |
| pulsar.topic_messages_rate_in | a dimension per topic | publishes/s |
| pulsar.topic_messages_rate_out | a dimension per topic | dispatches/s |
| pulsar.topic_throughput_rate_in | a dimension per topic | KiB/s |
| pulsar.topic_throughput_rate_out | a dimension per topic | KiB/s |
| pulsar.topic_storage_size | a dimension per topic | KiB |
| pulsar.topic_storage_read_rate | a dimension per topic | message batches/s |
| pulsar.topic_storage_write_rate | a dimension per topic | message batches/s |
| pulsar.topic_msg_backlog | a dimension per topic | messages |
| pulsar.topic_subscription_delayed | a dimension per topic | message batches |
| pulsar.topic_subscription_msg_rate_redeliver | a dimension per topic | messages/s |
| pulsar.topic_subscription_blocked_on_unacked_messages | a dimension per topic | blocked subscriptions |
| pulsar.topic_replication_rate_in | a dimension per topic | messages/s |
| pulsar.topic_replication_rate_out | a dimension per topic | messages/s |
| pulsar.topic_replication_throughput_rate_in | a dimension per topic | messages/s |
| pulsar.topic_replication_throughput_rate_out | a dimension per topic | messages/s |
| pulsar.topic_replication_backlog | a dimension per topic | messages |



## Alerts

There are no alerts configured by default for this integration.


## Setup


You can configure the **pulsar** collector in two ways:

| Method                | Best for                                                                                 | How to                                                                                                                                 |
|-----------------------|------------------------------------------------------------------------------------------|----------------------------------------------------------------------------------------------------------------------------------------|
| [**UI**](#via-ui)     | Fast setup without editing files                                                         | Go to **Nodes → Configure this node → Collectors → Jobs**, search for **pulsar**, then click **+** to add a job. |
| [**File**](#via-file) | If you prefer configuring via file, or need to automate deployments (e.g., with Ansible) | Edit `go.d/pulsar.conf` and add a job.                                                                        |

:::important

UI configuration requires paid Netdata Cloud plan.

:::


### Prerequisites

No action required.

### Configuration

#### Options

The following options can be defined globally: update_every, autodetection_retry.


<details open><summary>Config options</summary>



| Group | Option | Description | Default | Required |
|:------|:-----|:------------|:--------|:---------:|
| **Collection** | update_every | Data collection interval (seconds). | 60 | no |
|  | autodetection_retry | Autodetection retry interval (seconds). Set 0 to disable. | 0 | no |
| **Target** | url | Target endpoint URL. | http://127.0.0.1:8080/metrics | yes |
|  | timeout | HTTP request timeout (seconds). | 5 | no |
| **HTTP Auth** | username | Username for Basic HTTP authentication. |  | no |
|  | password | Password for Basic HTTP authentication. |  | no |
|  | bearer_token_file | Path to a file containing a bearer token (used for `Authorization: Bearer`). |  | no |
| **TLS** | tls_skip_verify | Skip TLS certificate and hostname verification (insecure). | no | no |
|  | tls_ca | Path to CA bundle used to validate the server certificate. |  | no |
|  | tls_cert | Path to client TLS certificate (for mTLS). |  | no |
|  | tls_key | Path to client TLS private key (for mTLS). |  | no |
| **Proxy** | proxy_url | HTTP proxy URL. |  | no |
|  | proxy_username | Username for proxy Basic HTTP authentication. |  | no |
|  | proxy_password | Password for proxy Basic HTTP authentication. |  | no |
| **Request** | method | HTTP method to use. | GET | no |
|  | body | Request body (e.g., for POST/PUT). |  | no |
|  | headers | Additional HTTP headers (one per line as key: value). |  | no |
|  | not_follow_redirects | Do not follow HTTP redirects. | no | no |
|  | force_http2 | Force HTTP/2 (including h2c over TCP). | no | no |
| **Virtual Node** | vnode | Associates this data collection job with a [Virtual Node](https://learn.netdata.cloud/docs/netdata-agent/configuration/organize-systems-metrics-and-alerts#virtual-nodes). |  | no |


</details>


#### via UI

Configure the **pulsar** collector from the Netdata web interface:

1. Go to **Nodes**.
2. Select the node **where you want the pulsar data-collection job to run** and click the :gear: (**Configure this node**). That node will run the data collection.
3. The **Collectors → Jobs** view opens by default.
4. In the Search box, type _pulsar_ (or scroll the list) to locate the **pulsar** collector.
5. Click the **+** next to the **pulsar** collector to add a new job.
6. Fill in the job fields, then click **Test** to verify the configuration and **Submit** to save.
    - **Test** runs the job with the provided settings and shows whether data can be collected.
    - If it fails, an error message appears with details (for example, connection refused, timeout, or command execution errors), so you can adjust and retest.


#### via File

The configuration file name for this integration is `go.d/pulsar.conf`.

The file format is YAML. Generally, the structure is:

```yaml
update_every: 1
autodetection_retry: 0
jobs:
  - name: some_name1
  - name: some_name2
```
You can edit the configuration file using the [`edit-config`](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#edit-a-configuration-file-using-edit-config) script from the
Netdata [config directory](https://github.com/netdata/netdata/blob/master/docs/netdata-agent/configuration/README.md#the-netdata-config-directory).

```bash
cd /etc/netdata 2>/dev/null || cd /opt/netdata/etc/netdata
sudo ./edit-config go.d/pulsar.conf
```

##### Examples

###### Basic

A basic example configuration.

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080/metrics

```
###### HTTP authentication

Basic HTTP authentication.

<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080/metrics
    username: username
    password: password

```
</details>

###### HTTPS with self-signed certificate

Do not validate server certificate chain and hostname.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: https://127.0.0.1:8080/metrics
    tls_skip_verify: yes

```
</details>

###### Multi-instance

> **Note**: When you define multiple jobs, their names must be unique.

Collecting metrics from local and remote instances.


<details open><summary>Config</summary>

```yaml
jobs:
  - name: local
    url: http://127.0.0.1:8080/metrics

  - name: remote
    url: http://192.0.2.1:8080/metrics

```
</details>



## Troubleshooting

### Debug Mode

**Important**: Debug mode is not supported for data collection jobs created via the UI using the Dyncfg feature.

To troubleshoot issues with the `pulsar` collector, run the `go.d.plugin` with the debug option enabled. The output
should give you clues as to why the collector isn't working.

- Navigate to the `plugins.d` directory, usually at `/usr/libexec/netdata/plugins.d/`. If that's not the case on
  your system, open `netdata.conf` and look for the `plugins` setting under `[directories]`.

  ```bash
  cd /usr/libexec/netdata/plugins.d/
  ```

- Switch to the `netdata` user.

  ```bash
  sudo -u netdata -s
  ```

- Run the `go.d.plugin` to debug the collector:

  ```bash
  ./go.d.plugin -d -m pulsar
  ```

  To debug a specific job:

  ```bash
  ./go.d.plugin -d -m pulsar -j jobName
  ```

### Getting Logs

If you're encountering problems with the `pulsar` collector, follow these steps to retrieve logs and identify potential issues:

- **Run the command** specific to your system (systemd, non-systemd, or Docker container).
- **Examine the output** for any warnings or error messages that might indicate issues.  These messages should provide clues about the root cause of the problem.

#### System with systemd

Use the following command to view logs generated since the last Netdata service restart:

```bash
journalctl _SYSTEMD_INVOCATION_ID="$(systemctl show --value --property=InvocationID netdata)" --namespace=netdata --grep pulsar
```

#### System without systemd

Locate the collector log file, typically at `/var/log/netdata/collector.log`, and use `grep` to filter for collector's name:

```bash
grep pulsar /var/log/netdata/collector.log
```

**Note**: This method shows logs from all restarts. Focus on the **latest entries** for troubleshooting current issues.

#### Docker Container

If your Netdata runs in a Docker container named "netdata" (replace if different), use this command:

```bash
docker logs netdata 2>&1 | grep pulsar
```


