/*
 * Copyright (c) 2012, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.  Oracle designates this
 * particular file as subject to the "Classpath" exception as provided
 * by Oracle in the LICENSE file that accompanied this code.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 */

/*
 * COPYRIGHT AND PERMISSION NOTICE
 *
 * Copyright (c) 1991-2022 Unicode, Inc. All rights reserved.
 * Distributed under the Terms of Use in https://www.unicode.org/copyright.html.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of the Unicode data files and any associated documentation
 * (the "Data Files") or Unicode software and any associated documentation
 * (the "Software") to deal in the Data Files or Software
 * without restriction, including without limitation the rights to use,
 * copy, modify, merge, publish, distribute, and/or sell copies of
 * the Data Files or Software, and to permit persons to whom the Data Files
 * or Software are furnished to do so, provided that either
 * (a) this copyright and permission notice appear with all copies
 * of the Data Files or Software, or
 * (b) this copyright and permission notice appear in associated
 * Documentation.
 *
 * THE DATA FILES AND SOFTWARE ARE PROVIDED "AS IS", WITHOUT WARRANTY OF
 * ANY KIND, EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
 * WARRANTIES OF MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT OF THIRD PARTY RIGHTS.
 * IN NO EVENT SHALL THE COPYRIGHT HOLDER OR HOLDERS INCLUDED IN THIS
 * NOTICE BE LIABLE FOR ANY CLAIM, OR ANY SPECIAL INDIRECT OR CONSEQUENTIAL
 * DAMAGES, OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THE DATA FILES OR SOFTWARE.
 *
 * Except as contained in this notice, the name of a copyright holder
 * shall not be used in advertising or otherwise to promote the sale,
 * use or other dealings in these Data Files or Software without prior
 * written authorization of the copyright holder.
 */

package sun.util.resources.cldr.ext;

import sun.util.resources.OpenListResourceBundle;

public class LocaleNames_de extends OpenListResourceBundle {
    @Override
    protected final Object[][] getContents() {
        final String metaValue_FJ = "Fidschi";
        final String metaValue_NU = "Niue";
        final String metaValue_PW = "Palau";
        final String metaValue_ar = "Arabisch";
        final String metaValue_hy = "Armenisch";
        final String metaValue_ae = "Avestisch";
        final String metaValue_ban = "Balinesisch";
        final String metaValue_bax = "Bamun";
        final String metaValue_bas = "Bassa";
        final String metaValue_bn = "Bengalisch";
        final String metaValue_zbl = "Bliss-Symbole";
        final String metaValue_bug = "Buginesisch";
        final String metaValue_ccp = "Chakma";
        final String metaValue_chr = "Cherokee";
        final String metaValue_cop = "Koptisch";
        final String metaValue_ka = "Georgisch";
        final String metaValue_got = "Gotisch";
        final String metaValue_el = "Griechisch";
        final String metaValue_gu = "Gujarati";
        final String metaValue_zh = "Chinesisch";
        final String metaValue_he = "Hebr\u00e4isch";
        final String metaValue_ja = "Japanisch";
        final String metaValue_km = "Khmer";
        final String metaValue_kn = "Kannada";
        final String metaValue_ko = "Koreanisch";
        final String metaValue_kpe = "Kpelle";
        final String metaValue_lo = "Laotisch";
        final String metaValue_men = "Mende";
        final String metaValue_ml = "Malayalam";
        final String metaValue_mn = "Mongolisch";
        final String metaValue_my = "Birmanisch";
        final String metaValue_nqo = "N\u2019Ko";
        final String metaValue_or = "Oriya";
        final String metaValue_ota = "Osmanisch";
        final String metaValue_phn = "Ph\u00f6nizisch";
        final String metaValue_sam = "Samaritanisch";
        final String metaValue_saz = "Saurashtra";
        final String metaValue_si = "Singhalesisch";
        final String metaValue_su = "Sundanesisch";
        final String metaValue_syr = "Syrisch";
        final String metaValue_te = "Telugu";
        final String metaValue_tl = "Tagalog";
        final String metaValue_bo = "Tibetisch";
        final String metaValue_uga = "Ugaritisch";
        final String metaValue_vai = "Vai";
        final String metaValue_peo = "Altpersisch";
        final String metaValue_ii = "Yi";
        final String metaValue_ssy = "Saho";
        final Object[][] data = new Object[][] {
            { "001", "Welt" },
            { "002", "Afrika" },
            { "003", "Nordamerika" },
            { "005", "S\u00fcdamerika" },
            { "009", "Ozeanien" },
            { "011", "Westafrika" },
            { "013", "Mittelamerika" },
            { "014", "Ostafrika" },
            { "015", "Nordafrika" },
            { "017", "Zentralafrika" },
            { "018", "S\u00fcdliches Afrika" },
            { "019", "Amerika" },
            { "021", "N\u00f6rdliches Amerika" },
            { "029", "Karibik" },
            { "030", "Ostasien" },
            { "034", "S\u00fcdasien" },
            { "035", "S\u00fcdostasien" },
            { "039", "S\u00fcdeuropa" },
            { "053", "Australasien" },
            { "054", "Melanesien" },
            { "057", "Mikronesisches Inselgebiet" },
            { "061", "Polynesien" },
            { "142", "Asien" },
            { "143", "Zentralasien" },
            { "145", "Westasien" },
            { "150", "Europa" },
            { "151", "Osteuropa" },
            { "154", "Nordeuropa" },
            { "155", "Westeuropa" },
            { "202", "Subsahara-Afrika" },
            { "419", "Lateinamerika" },
            { "AC", "Ascension" },
            { "AD", "Andorra" },
            { "AE", "Vereinigte Arabische Emirate" },
            { "AF", "Afghanistan" },
            { "AG", "Antigua und Barbuda" },
            { "AI", "Anguilla" },
            { "AL", "Albanien" },
            { "AM", "Armenien" },
            { "AO", "Angola" },
            { "AQ", "Antarktis" },
            { "AR", "Argentinien" },
            { "AS", "Amerikanisch-Samoa" },
            { "AT", "\u00d6sterreich" },
            { "AU", "Australien" },
            { "AW", "Aruba" },
            { "AX", "\u00c5landinseln" },
            { "AZ", "Aserbaidschan" },
            { "BA", "Bosnien und Herzegowina" },
            { "BB", "Barbados" },
            { "BD", "Bangladesch" },
            { "BE", "Belgien" },
            { "BF", "Burkina Faso" },
            { "BG", "Bulgarien" },
            { "BH", "Bahrain" },
            { "BI", "Burundi" },
            { "BJ", "Benin" },
            { "BL", "St. Barth\u00e9lemy" },
            { "BM", "Bermuda" },
            { "BN", "Brunei Darussalam" },
            { "BO", "Bolivien" },
            { "BQ", "Karibische Niederlande" },
            { "BR", "Brasilien" },
            { "BS", "Bahamas" },
            { "BT", "Bhutan" },
            { "BV", "Bouvetinsel" },
            { "BW", "Botsuana" },
            { "BY", "Belarus" },
            { "BZ", "Belize" },
            { "CA", "Kanada" },
            { "CC", "Kokosinseln" },
            { "CD", "Kongo-Kinshasa" },
            { "CF", "Zentralafrikanische Republik" },
            { "CG", "Kongo-Brazzaville" },
            { "CH", "Schweiz" },
            { "CI", "C\u00f4te d\u2019Ivoire" },
            { "CK", "Cookinseln" },
            { "CL", "Chile" },
            { "CM", "Kamerun" },
            { "CN", "China" },
            { "CO", "Kolumbien" },
            { "CP", "Clipperton-Insel" },
            { "CR", "Costa Rica" },
            { "CU", "Kuba" },
            { "CV", "Cabo Verde" },
            { "CW", "Cura\u00e7ao" },
            { "CX", "Weihnachtsinsel" },
            { "CY", "Zypern" },
            { "CZ", "Tschechien" },
            { "DE", "Deutschland" },
            { "DG", "Diego Garcia" },
            { "DJ", "Dschibuti" },
            { "DK", "D\u00e4nemark" },
            { "DM", "Dominica" },
            { "DO", "Dominikanische Republik" },
            { "DZ", "Algerien" },
            { "EA", "Ceuta und Melilla" },
            { "EC", "Ecuador" },
            { "EE", "Estland" },
            { "EG", "\u00c4gypten" },
            { "EH", "Westsahara" },
            { "ER", "Eritrea" },
            { "ES", "Spanien" },
            { "ET", "\u00c4thiopien" },
            { "EU", "Europ\u00e4ische Union" },
            { "EZ", "Eurozone" },
            { "FI", "Finnland" },
            { "FJ", metaValue_FJ },
            { "FK", "Falklandinseln" },
            { "FM", "Mikronesien" },
            { "FO", "F\u00e4r\u00f6er" },
            { "FR", "Frankreich" },
            { "GA", "Gabun" },
            { "GB", "Vereinigtes K\u00f6nigreich" },
            { "GD", "Grenada" },
            { "GE", "Georgien" },
            { "GF", "Franz\u00f6sisch-Guayana" },
            { "GG", "Guernsey" },
            { "GH", "Ghana" },
            { "GI", "Gibraltar" },
            { "GL", "Gr\u00f6nland" },
            { "GM", "Gambia" },
            { "GN", "Guinea" },
            { "GP", "Guadeloupe" },
            { "GQ", "\u00c4quatorialguinea" },
            { "GR", "Griechenland" },
            { "GS", "S\u00fcdgeorgien und die S\u00fcdlichen Sandwichinseln" },
            { "GT", "Guatemala" },
            { "GU", "Guam" },
            { "GW", "Guinea-Bissau" },
            { "GY", "Guyana" },
            { "HK", "Sonderverwaltungsregion Hongkong" },
            { "HM", "Heard und McDonaldinseln" },
            { "HN", "Honduras" },
            { "HR", "Kroatien" },
            { "HT", "Haiti" },
            { "HU", "Ungarn" },
            { "IC", "Kanarische Inseln" },
            { "ID", "Indonesien" },
            { "IE", "Irland" },
            { "IL", "Israel" },
            { "IM", "Isle of Man" },
            { "IN", "Indien" },
            { "IO", "Britisches Territorium im Indischen Ozean" },
            { "IQ", "Irak" },
            { "IR", "Iran" },
            { "IS", "Island" },
            { "IT", "Italien" },
            { "JE", "Jersey" },
            { "JM", "Jamaika" },
            { "JO", "Jordanien" },
            { "JP", "Japan" },
            { "KE", "Kenia" },
            { "KG", "Kirgisistan" },
            { "KH", "Kambodscha" },
            { "KI", "Kiribati" },
            { "KM", "Komoren" },
            { "KN", "St. Kitts und Nevis" },
            { "KP", "Nordkorea" },
            { "KR", "S\u00fcdkorea" },
            { "KW", "Kuwait" },
            { "KY", "Kaimaninseln" },
            { "KZ", "Kasachstan" },
            { "LA", "Laos" },
            { "LB", "Libanon" },
            { "LC", "St. Lucia" },
            { "LI", "Liechtenstein" },
            { "LK", "Sri Lanka" },
            { "LR", "Liberia" },
            { "LS", "Lesotho" },
            { "LT", "Litauen" },
            { "LU", "Luxemburg" },
            { "LV", "Lettland" },
            { "LY", "Libyen" },
            { "MA", "Marokko" },
            { "MC", "Monaco" },
            { "MD", "Republik Moldau" },
            { "ME", "Montenegro" },
            { "MF", "St. Martin" },
            { "MG", "Madagaskar" },
            { "MH", "Marshallinseln" },
            { "MK", "Nordmazedonien" },
            { "ML", "Mali" },
            { "MM", "Myanmar" },
            { "MN", "Mongolei" },
            { "MO", "Sonderverwaltungsregion Macau" },
            { "MP", "N\u00f6rdliche Marianen" },
            { "MQ", "Martinique" },
            { "MR", "Mauretanien" },
            { "MS", "Montserrat" },
            { "MT", "Malta" },
            { "MU", "Mauritius" },
            { "MV", "Malediven" },
            { "MW", "Malawi" },
            { "MX", "Mexiko" },
            { "MY", "Malaysia" },
            { "MZ", "Mosambik" },
            { "NA", "Namibia" },
            { "NC", "Neukaledonien" },
            { "NE", "Niger" },
            { "NF", "Norfolkinsel" },
            { "NG", "Nigeria" },
            { "NI", "Nicaragua" },
            { "NL", "Niederlande" },
            { "NO", "Norwegen" },
            { "NP", "Nepal" },
            { "NR", "Nauru" },
            { "NU", metaValue_NU },
            { "NZ", "Neuseeland" },
            { "OM", "Oman" },
            { "PA", "Panama" },
            { "PE", "Peru" },
            { "PF", "Franz\u00f6sisch-Polynesien" },
            { "PG", "Papua-Neuguinea" },
            { "PH", "Philippinen" },
            { "PK", "Pakistan" },
            { "PL", "Polen" },
            { "PM", "St. Pierre und Miquelon" },
            { "PN", "Pitcairninseln" },
            { "PR", "Puerto Rico" },
            { "PS", "Pal\u00e4stinensische Autonomiegebiete" },
            { "PT", "Portugal" },
            { "PW", metaValue_PW },
            { "PY", "Paraguay" },
            { "QA", "Katar" },
            { "QO", "\u00c4u\u00dferes Ozeanien" },
            { "RE", "R\u00e9union" },
            { "RO", "Rum\u00e4nien" },
            { "RS", "Serbien" },
            { "RU", "Russland" },
            { "RW", "Ruanda" },
            { "SA", "Saudi-Arabien" },
            { "SB", "Salomonen" },
            { "SC", "Seychellen" },
            { "SD", "Sudan" },
            { "SE", "Schweden" },
            { "SG", "Singapur" },
            { "SH", "St. Helena" },
            { "SI", "Slowenien" },
            { "SJ", "Spitzbergen und Jan Mayen" },
            { "SK", "Slowakei" },
            { "SL", "Sierra Leone" },
            { "SM", "San Marino" },
            { "SN", "Senegal" },
            { "SO", "Somalia" },
            { "SR", "Suriname" },
            { "SS", "S\u00fcdsudan" },
            { "ST", "S\u00e3o Tom\u00e9 und Pr\u00edncipe" },
            { "SV", "El Salvador" },
            { "SX", "Sint Maarten" },
            { "SY", "Syrien" },
            { "SZ", "Eswatini" },
            { "TA", "Tristan da Cunha" },
            { "TC", "Turks- und Caicosinseln" },
            { "TD", "Tschad" },
            { "TF", "Franz\u00f6sische S\u00fcd- und Antarktisgebiete" },
            { "TG", "Togo" },
            { "TH", "Thailand" },
            { "TJ", "Tadschikistan" },
            { "TK", "Tokelau" },
            { "TL", "Timor-Leste" },
            { "TM", "Turkmenistan" },
            { "TN", "Tunesien" },
            { "TO", "Tonga" },
            { "TR", "T\u00fcrkei" },
            { "TT", "Trinidad und Tobago" },
            { "TV", "Tuvalu" },
            { "TW", "Taiwan" },
            { "TZ", "Tansania" },
            { "UA", "Ukraine" },
            { "UG", "Uganda" },
            { "UM", "Amerikanische \u00dcberseeinseln" },
            { "UN", "Vereinte Nationen" },
            { "US", "Vereinigte Staaten" },
            { "UY", "Uruguay" },
            { "UZ", "Usbekistan" },
            { "VA", "Vatikanstadt" },
            { "VC", "St. Vincent und die Grenadinen" },
            { "VE", "Venezuela" },
            { "VG", "Britische Jungferninseln" },
            { "VI", "Amerikanische Jungferninseln" },
            { "VN", "Vietnam" },
            { "VU", "Vanuatu" },
            { "WF", "Wallis und Futuna" },
            { "WS", "Samoa" },
            { "XA", "Pseudo-Akzente" },
            { "XB", "Pseudo-Bidi" },
            { "XK", "Kosovo" },
            { "YE", "Jemen" },
            { "YT", "Mayotte" },
            { "ZA", "S\u00fcdafrika" },
            { "ZM", "Sambia" },
            { "ZW", "Simbabwe" },
            { "ZZ", "Unbekannte Region" },
            { "aa", "Afar" },
            { "ab", "Abchasisch" },
            { "ae", metaValue_ae },
            { "af", "Afrikaans" },
            { "ak", "Akan" },
            { "am", "Amharisch" },
            { "an", "Aragonesisch" },
            { "ar", metaValue_ar },
            { "as", "Assamesisch" },
            { "av", "Awarisch" },
            { "ay", "Aymara" },
            { "az", "Aserbaidschanisch" },
            { "ba", "Baschkirisch" },
            { "be", "Belarussisch" },
            { "bg", "Bulgarisch" },
            { "bi", "Bislama" },
            { "bm", "Bambara" },
            { "bn", metaValue_bn },
            { "bo", metaValue_bo },
            { "br", "Bretonisch" },
            { "bs", "Bosnisch" },
            { "ca", "Katalanisch" },
            { "ce", "Tschetschenisch" },
            { "ch", "Chamorro" },
            { "co", "Korsisch" },
            { "cr", "Cree" },
            { "cs", "Tschechisch" },
            { "cu", "Kirchenslawisch" },
            { "cv", "Tschuwaschisch" },
            { "cy", "Walisisch" },
            { "da", "D\u00e4nisch" },
            { "de", "Deutsch" },
            { "dv", "Dhivehi" },
            { "dz", "Dzongkha" },
            { "ee", "Ewe" },
            { "el", metaValue_el },
            { "en", "Englisch" },
            { "eo", "Esperanto" },
            { "es", "Spanisch" },
            { "et", "Estnisch" },
            { "eu", "Baskisch" },
            { "fa", "Persisch" },
            { "ff", "Ful" },
            { "fi", "Finnisch" },
            { "fj", metaValue_FJ },
            { "fo", "F\u00e4r\u00f6isch" },
            { "fr", "Franz\u00f6sisch" },
            { "fy", "Westfriesisch" },
            { "ga", "Irisch" },
            { "gd", "G\u00e4lisch (Schottland)" },
            { "gl", "Galicisch" },
            { "gn", "Guaran\u00ed" },
            { "gu", metaValue_gu },
            { "gv", "Manx" },
            { "ha", "Haussa" },
            { "he", metaValue_he },
            { "hi", "Hindi" },
            { "ho", "Hiri-Motu" },
            { "hr", "Kroatisch" },
            { "ht", "Haiti-Kreolisch" },
            { "hu", "Ungarisch" },
            { "hy", metaValue_hy },
            { "hz", "Herero" },
            { "ia", "Interlingua" },
            { "id", "Indonesisch" },
            { "ie", "Interlingue" },
            { "ig", "Igbo" },
            { "ii", metaValue_ii },
            { "ik", "Inupiak" },
            { "io", "Ido" },
            { "is", "Isl\u00e4ndisch" },
            { "it", "Italienisch" },
            { "iu", "Inuktitut" },
            { "ja", metaValue_ja },
            { "jv", "Javanisch" },
            { "ka", metaValue_ka },
            { "kg", "Kongolesisch" },
            { "ki", "Kikuyu" },
            { "kj", "Kwanyama" },
            { "kk", "Kasachisch" },
            { "kl", "Gr\u00f6nl\u00e4ndisch" },
            { "km", metaValue_km },
            { "kn", metaValue_kn },
            { "ko", metaValue_ko },
            { "kr", "Kanuri" },
            { "ks", "Kaschmiri" },
            { "ku", "Kurdisch" },
            { "kv", "Komi" },
            { "kw", "Kornisch" },
            { "ky", "Kirgisisch" },
            { "la", "Latein" },
            { "lb", "Luxemburgisch" },
            { "lg", "Ganda" },
            { "li", "Limburgisch" },
            { "ln", "Lingala" },
            { "lo", metaValue_lo },
            { "lt", "Litauisch" },
            { "lu", "Luba-Katanga" },
            { "lv", "Lettisch" },
            { "mg", "Malagasy" },
            { "mh", "Marschallesisch" },
            { "mi", "M\u0101ori" },
            { "mk", "Mazedonisch" },
            { "ml", metaValue_ml },
            { "mn", metaValue_mn },
            { "mr", "Marathi" },
            { "ms", "Malaiisch" },
            { "mt", "Maltesisch" },
            { "my", metaValue_my },
            { "na", "Nauruisch" },
            { "nb", "Norwegisch (Bokm\u00e5l)" },
            { "nd", "Nord-Ndebele" },
            { "ne", "Nepalesisch" },
            { "ng", "Ndonga" },
            { "nl", "Niederl\u00e4ndisch" },
            { "nn", "Norwegisch (Nynorsk)" },
            { "no", "Norwegisch" },
            { "nr", "S\u00fcd-Ndebele" },
            { "nv", "Navajo" },
            { "ny", "Nyanja" },
            { "oc", "Okzitanisch" },
            { "oj", "Ojibwa" },
            { "om", "Oromo" },
            { "or", metaValue_or },
            { "os", "Ossetisch" },
            { "pa", "Punjabi" },
            { "pi", "Pali" },
            { "pl", "Polnisch" },
            { "ps", "Paschtu" },
            { "pt", "Portugiesisch" },
            { "qu", "Quechua" },
            { "rm", "R\u00e4toromanisch" },
            { "rn", "Rundi" },
            { "ro", "Rum\u00e4nisch" },
            { "ru", "Russisch" },
            { "rw", "Kinyarwanda" },
            { "sa", "Sanskrit" },
            { "sc", "Sardisch" },
            { "sd", "Sindhi" },
            { "se", "Nordsamisch" },
            { "sg", "Sango" },
            { "sh", "Serbo-Kroatisch" },
            { "si", metaValue_si },
            { "sk", "Slowakisch" },
            { "sl", "Slowenisch" },
            { "sm", "Samoanisch" },
            { "sn", "Shona" },
            { "so", "Somali" },
            { "sq", "Albanisch" },
            { "sr", "Serbisch" },
            { "ss", "Swazi" },
            { "st", "S\u00fcd-Sotho" },
            { "su", metaValue_su },
            { "sv", "Schwedisch" },
            { "sw", "Suaheli" },
            { "ta", "Tamil" },
            { "te", metaValue_te },
            { "tg", "Tadschikisch" },
            { "th", "Thail\u00e4ndisch" },
            { "ti", "Tigrinya" },
            { "tk", "Turkmenisch" },
            { "tl", metaValue_tl },
            { "tn", "Tswana" },
            { "to", "Tongaisch" },
            { "tr", "T\u00fcrkisch" },
            { "ts", "Tsonga" },
            { "tt", "Tatarisch" },
            { "tw", "Twi" },
            { "ty", "Tahitisch" },
            { "ug", "Uigurisch" },
            { "uk", "Ukrainisch" },
            { "ur", "Urdu" },
            { "uz", "Usbekisch" },
            { "ve", "Venda" },
            { "vi", "Vietnamesisch" },
            { "vo", "Volap\u00fck" },
            { "wa", "Wallonisch" },
            { "wo", "Wolof" },
            { "xh", "Xhosa" },
            { "yi", "Jiddisch" },
            { "yo", "Yoruba" },
            { "za", "Zhuang" },
            { "zh", metaValue_zh },
            { "zu", "Zulu" },
            { "ace", "Aceh" },
            { "ach", "Acholi" },
            { "ada", "Adangme" },
            { "ady", "Adygeisch" },
            { "aeb", "Tunesisches Arabisch" },
            { "afh", "Afrihili" },
            { "agq", "Aghem" },
            { "ain", "Ainu" },
            { "akk", "Akkadisch" },
            { "akz", "Alabama" },
            { "ale", "Aleutisch" },
            { "aln", "Gegisch" },
            { "alt", "S\u00fcd-Altaisch" },
            { "ang", "Altenglisch" },
            { "ann", "Obolo" },
            { "anp", "Angika" },
            { "arc", "Aram\u00e4isch" },
            { "arn", "Mapudungun" },
            { "aro", "Araona" },
            { "arp", "Arapaho" },
            { "arq", "Algerisches Arabisch" },
            { "ars", "Arabisch (Nadschd)" },
            { "arw", "Arawak" },
            { "ary", "Marokkanisches Arabisch" },
            { "arz", "\u00c4gyptisches Arabisch" },
            { "asa", "Asu" },
            { "ase", "Amerikanische Geb\u00e4rdensprache" },
            { "ast", "Asturisch" },
            { "atj", "Atikamekw" },
            { "avk", "Kotava" },
            { "awa", "Awadhi" },
            { "bal", "Belutschisch" },
            { "ban", metaValue_ban },
            { "bar", "Bairisch" },
            { "bas", metaValue_bas },
            { "bax", metaValue_bax },
            { "bbc", "Batak Toba" },
            { "bbj", "Ghomala" },
            { "bej", "Bedauye" },
            { "bem", "Bemba" },
            { "bew", "Betawi" },
            { "bez", "Bena" },
            { "bfd", "Bafut" },
            { "bfq", "Badaga" },
            { "bgc", "Haryanvi" },
            { "bgn", "Westliches Belutschi" },
            { "bho", "Bhodschpuri" },
            { "bik", "Bikol" },
            { "bin", "Bini" },
            { "bjn", "Banjaresisch" },
            { "bkm", "Kom" },
            { "bla", "Blackfoot" },
            { "bpy", "Bishnupriya" },
            { "bqi", "Bachtiarisch" },
            { "bra", "Braj-Bhakha" },
            { "brh", "Brahui" },
            { "brx", "Bodo" },
            { "bss", "Akoose" },
            { "bua", "Burjatisch" },
            { "bug", metaValue_bug },
            { "bum", "Bulu" },
            { "byn", "Blin" },
            { "byv", "Medumba" },
            { "cad", "Caddo" },
            { "car", "Karibisch" },
            { "cay", "Cayuga" },
            { "cch", "Atsam" },
            { "ccp", metaValue_ccp },
            { "ceb", "Cebuano" },
            { "cgg", "Rukiga" },
            { "chb", "Chibcha" },
            { "chg", "Tschagataisch" },
            { "chk", "Chuukesisch" },
            { "chm", "Mari" },
            { "chn", "Chinook" },
            { "cho", "Choctaw" },
            { "chp", "Chipewyan" },
            { "chr", metaValue_chr },
            { "chy", "Cheyenne" },
            { "ckb", "Zentralkurdisch" },
            { "clc", "Chilcotin" },
            { "cop", metaValue_cop },
            { "cps", "Capiznon" },
            { "crg", "Michif" },
            { "crh", "Krimtatarisch" },
            { "crj", "S\u00fcdost-Cree" },
            { "crk", "Plains-Cree" },
            { "crl", "Northern East Cree" },
            { "crm", "Moose Cree" },
            { "crr", "Carolina-Algonkin" },
            { "crs", "Seychellenkreol" },
            { "csb", "Kaschubisch" },
            { "csw", "Swampy Cree" },
            { "dak", "Dakota" },
            { "dar", "Darginisch" },
            { "dav", "Taita" },
            { "del", "Delaware" },
            { "den", "Slave" },
            { "dgr", "Dogrib" },
            { "din", "Dinka" },
            { "dje", "Zarma" },
            { "doi", "Dogri" },
            { "dsb", "Niedersorbisch" },
            { "dtp", "Zentral-Dusun" },
            { "dua", "Duala" },
            { "dum", "Mittelniederl\u00e4ndisch" },
            { "dyo", "Diola" },
            { "dyu", "Dyula" },
            { "dzg", "Dazaga" },
            { "ebu", "Embu" },
            { "efi", "Efik" },
            { "egl", "Emilianisch" },
            { "egy", "\u00c4gyptisch" },
            { "eka", "Ekajuk" },
            { "elx", "Elamisch" },
            { "enm", "Mittelenglisch" },
            { "esu", "Zentral-Alaska-Yupik" },
            { "ewo", "Ewondo" },
            { "ext", "Extremadurisch" },
            { "fan", "Pangwe" },
            { "fat", "Fanti" },
            { "fil", "Filipino" },
            { "fit", "Me\u00e4nkieli" },
            { "fon", "Fon" },
            { "frc", "Cajun" },
            { "frm", "Mittelfranz\u00f6sisch" },
            { "fro", "Altfranz\u00f6sisch" },
            { "frp", "Frankoprovenzalisch" },
            { "frr", "Nordfriesisch" },
            { "frs", "Ostfriesisch" },
            { "fur", "Friaulisch" },
            { "gaa", "Ga" },
            { "gag", "Gagausisch" },
            { "gan", "Gan" },
            { "gay", "Gayo" },
            { "gba", "Gbaya" },
            { "gbz", "Gabri" },
            { "gez", "Geez" },
            { "gil", "Kiribatisch" },
            { "glk", "Gilaki" },
            { "gmh", "Mittelhochdeutsch" },
            { "goh", "Althochdeutsch" },
            { "gom", "Goa-Konkani" },
            { "gon", "Gondi" },
            { "gor", "Mongondou" },
            { "got", metaValue_got },
            { "grb", "Grebo" },
            { "grc", "Altgriechisch" },
            { "gsw", "Schweizerdeutsch" },
            { "guc", "Way\u00fau" },
            { "gur", "Farefare" },
            { "guz", "Gusii" },
            { "gwi", "Kutchin" },
            { "hai", "Haida" },
            { "hak", "Hakka" },
            { "haw", "Hawaiisch" },
            { "hax", "S\u00fcd-Haida" },
            { "hif", "Fidschi-Hindi" },
            { "hil", "Hiligaynon" },
            { "hit", "Hethitisch" },
            { "hmn", "Miao" },
            { "hsb", "Obersorbisch" },
            { "hsn", "Xiang" },
            { "hup", "Hupa" },
            { "hur", "Halkomelem" },
            { "iba", "Iban" },
            { "ibb", "Ibibio" },
            { "ikt", "Westkanadisches Inuktitut" },
            { "ilo", "Ilokano" },
            { "inh", "Inguschisch" },
            { "izh", "Ischorisch" },
            { "jam", "Jamaikanisch-Kreolisch" },
            { "jbo", "Lojban" },
            { "jgo", "Ngomba" },
            { "jmc", "Machame" },
            { "jpr", "J\u00fcdisch-Persisch" },
            { "jrb", "J\u00fcdisch-Arabisch" },
            { "jut", "J\u00fctisch" },
            { "kaa", "Karakalpakisch" },
            { "kab", "Kabylisch" },
            { "kac", "Kachin" },
            { "kaj", "Jju" },
            { "kam", "Kamba" },
            { "kaw", "Kawi" },
            { "kbd", "Kabardinisch" },
            { "kbl", "Kanembu" },
            { "kcg", "Tyap" },
            { "kde", "Makonde" },
            { "kea", "Kabuverdianu" },
            { "ken", "Kenyang" },
            { "kfo", "Koro" },
            { "kgp", "Kaingang" },
            { "kha", "Khasi" },
            { "kho", "Sakisch" },
            { "khq", "Koyra Chiini" },
            { "khw", "Khowar" },
            { "kiu", "Kirmanjki" },
            { "kkj", "Kako" },
            { "kln", "Kalenjin" },
            { "kmb", "Kimbundu" },
            { "koi", "Komi-Permjakisch" },
            { "kok", "Konkani" },
            { "kos", "Kosraeanisch" },
            { "kpe", metaValue_kpe },
            { "krc", "Karatschaiisch-Balkarisch" },
            { "kri", "Krio" },
            { "krj", "Kinaray-a" },
            { "krl", "Karelisch" },
            { "kru", "Oraon" },
            { "ksb", "Shambala" },
            { "ksf", "Bafia" },
            { "ksh", "K\u00f6lsch" },
            { "kum", "Kum\u00fckisch" },
            { "kut", "Kutenai" },
            { "kwk", "Kwak\u02bcwala" },
            { "lad", "Ladino" },
            { "lag", "Langi" },
            { "lah", "Lahnda" },
            { "lam", "Lamba" },
            { "lez", "Lesgisch" },
            { "lfn", "Lingua Franca Nova" },
            { "lij", "Ligurisch" },
            { "lil", "Lillooet" },
            { "liv", "Livisch" },
            { "lkt", "Lakota" },
            { "lmo", "Lombardisch" },
            { "lol", "Mongo" },
            { "lou", "Kreol (Louisiana)" },
            { "loz", "Lozi" },
            { "lrc", "N\u00f6rdliches Luri" },
            { "lsm", "Saamia" },
            { "ltg", "Lettgallisch" },
            { "lua", "Luba-Lulua" },
            { "lui", "Luiseno" },
            { "lun", "Lunda" },
            { "luo", "Luo" },
            { "lus", "Lushai" },
            { "luy", "Luhya" },
            { "lzh", "Klassisches Chinesisch" },
            { "lzz", "Lasisch" },
            { "mad", "Maduresisch" },
            { "maf", "Mafa" },
            { "mag", "Khotta" },
            { "mai", "Maithili" },
            { "mak", "Makassarisch" },
            { "man", "Malinke" },
            { "mas", "Massai" },
            { "mde", "Maba" },
            { "mdf", "Mokschanisch" },
            { "mdr", "Mandaresisch" },
            { "men", metaValue_men },
            { "mer", "Meru" },
            { "mfe", "Morisyen" },
            { "mga", "Mittelirisch" },
            { "mgh", "Makhuwa-Meetto" },
            { "mgo", "Meta\u2019" },
            { "mic", "Micmac" },
            { "min", "Minangkabau" },
            { "mnc", "Mandschurisch" },
            { "mni", "Meithei" },
            { "moe", "Innu-Aimun" },
            { "moh", "Mohawk" },
            { "mos", "Mossi" },
            { "mrj", "Bergmari" },
            { "mua", "Mundang" },
            { "mul", "Mehrsprachig" },
            { "mus", "Muskogee" },
            { "mwl", "Mirandesisch" },
            { "mwr", "Marwari" },
            { "mwv", "Mentawai" },
            { "mye", "Myene" },
            { "myv", "Ersja-Mordwinisch" },
            { "mzn", "Masanderanisch" },
            { "nan", "Min Nan" },
            { "nap", "Neapolitanisch" },
            { "naq", "Nama" },
            { "nds", "Niederdeutsch" },
            { "new", "Newari" },
            { "nia", "Nias" },
            { "niu", metaValue_NU },
            { "njo", "Ao-Naga" },
            { "nmg", "Kwasio" },
            { "nnh", "Ngiemboon" },
            { "nog", "Nogai" },
            { "non", "Altnordisch" },
            { "nov", "Novial" },
            { "nqo", metaValue_nqo },
            { "nso", "Nord-Sotho" },
            { "nus", "Nuer" },
            { "nwc", "Alt-Newari" },
            { "nym", "Nyamwezi" },
            { "nyn", "Nyankole" },
            { "nyo", "Nyoro" },
            { "nzi", "Nzima" },
            { "ojb", "Nordwest-Ojibwe" },
            { "ojc", "Zentral-Ojibwe" },
            { "ojs", "Oji-Cree" },
            { "ojw", "West-Ojibwe" },
            { "oka", "Okanagan" },
            { "osa", "Osage" },
            { "ota", metaValue_ota },
            { "pag", "Pangasinan" },
            { "pal", "Mittelpersisch" },
            { "pam", "Pampanggan" },
            { "pap", "Papiamento" },
            { "pau", metaValue_PW },
            { "pcd", "Picardisch" },
            { "pcm", "Nigerianisches Pidgin" },
            { "pdc", "Pennsylvaniadeutsch" },
            { "pdt", "Plautdietsch" },
            { "peo", metaValue_peo },
            { "pfl", "Pf\u00e4lzisch" },
            { "phn", metaValue_phn },
            { "pis", "Pijin" },
            { "pms", "Piemontesisch" },
            { "pnt", "Pontisch" },
            { "pon", "Ponapeanisch" },
            { "pqm", "Maliseet-Passamaquoddy" },
            { "prg", "Altpreu\u00dfisch" },
            { "pro", "Altprovenzalisch" },
            { "quc", "K\u2019iche\u2019" },
            { "qug", "Chimborazo Hochland-Quechua" },
            { "raj", "Rajasthani" },
            { "rap", "Rapanui" },
            { "rar", "Rarotonganisch" },
            { "rgn", "Romagnol" },
            { "rhg", "Rohingyalisch" },
            { "rif", "Tarifit" },
            { "rof", "Rombo" },
            { "rom", "Romani" },
            { "rtm", "Rotumanisch" },
            { "rue", "Russinisch" },
            { "rug", "Roviana" },
            { "rup", "Aromunisch" },
            { "rwk", "Rwa" },
            { "sad", "Sandawe" },
            { "sah", "Jakutisch" },
            { "sam", metaValue_sam },
            { "saq", "Samburu" },
            { "sas", "Sasak" },
            { "sat", "Santali" },
            { "saz", metaValue_saz },
            { "sba", "Ngambay" },
            { "sbp", "Sangu" },
            { "scn", "Sizilianisch" },
            { "sco", "Schottisch" },
            { "sdc", "Sassarisch" },
            { "sdh", "S\u00fcdkurdisch" },
            { "see", "Seneca" },
            { "seh", "Sena" },
            { "sei", "Seri" },
            { "sel", "Selkupisch" },
            { "ses", "Koyra Senni" },
            { "sga", "Altirisch" },
            { "sgs", "Samogitisch" },
            { "shi", "Taschelhit" },
            { "shn", "Schan" },
            { "shu", "Tschadisch-Arabisch" },
            { "sid", "Sidamo" },
            { "slh", "S\u00fcd-Lushootseed" },
            { "sli", "Schlesisch (Niederschlesisch)" },
            { "sly", "Selayar" },
            { "sma", "S\u00fcdsamisch" },
            { "smj", "Lule-Samisch" },
            { "smn", "Inari-Samisch" },
            { "sms", "Skolt-Samisch" },
            { "snk", "Soninke" },
            { "sog", "Sogdisch" },
            { "srn", "Srananisch" },
            { "srr", "Serer" },
            { "ssy", metaValue_ssy },
            { "stq", "Saterfriesisch" },
            { "str", "Straits Salish" },
            { "suk", "Sukuma" },
            { "sus", "Susu" },
            { "sux", "Sumerisch" },
            { "swb", "Komorisch" },
            { "syc", "Altsyrisch" },
            { "syr", metaValue_syr },
            { "szl", "Schlesisch (Wasserpolnisch)" },
            { "tce", "S\u00fcdliches Tutchone" },
            { "tcy", "Tulu" },
            { "tem", "Temne" },
            { "teo", "Teso" },
            { "ter", "Tereno" },
            { "tet", "Tetum" },
            { "tgx", "Tagish" },
            { "tht", "Tahltan" },
            { "tig", "Tigre" },
            { "tiv", "Tiv" },
            { "tkl", "Tokelauanisch" },
            { "tkr", "Tsachurisch" },
            { "tlh", "Klingonisch" },
            { "tli", "Tlingit" },
            { "tly", "Talisch" },
            { "tmh", "Tamaseq" },
            { "tog", "Nyasa Tonga" },
            { "tok", "Toki Pona" },
            { "tpi", "Neumelanesisch" },
            { "tru", "Turoyo" },
            { "trv", "Taroko" },
            { "tsd", "Tsakonisch" },
            { "tsi", "Tsimshian" },
            { "ttm", "N\u00f6rdliches Tutchone" },
            { "ttt", "Tatisch" },
            { "tum", "Tumbuka" },
            { "tvl", "Tuvaluisch" },
            { "twq", "Tasawaq" },
            { "tyv", "Tuwinisch" },
            { "tzm", "Zentralatlas-Tamazight" },
            { "udm", "Udmurtisch" },
            { "uga", metaValue_uga },
            { "umb", "Umbundu" },
            { "und", "Unbekannte Sprache" },
            { "vai", metaValue_vai },
            { "vec", "Venetisch" },
            { "vep", "Wepsisch" },
            { "vls", "Westfl\u00e4misch" },
            { "vmf", "Mainfr\u00e4nkisch" },
            { "vot", "Wotisch" },
            { "vro", "V\u00f5ro" },
            { "vun", "Vunjo" },
            { "wae", "Walliserdeutsch" },
            { "wal", "Walamo" },
            { "war", "Waray" },
            { "was", "Washo" },
            { "wbp", "Warlpiri" },
            { "wuu", "Wu" },
            { "xal", "Kalm\u00fcckisch" },
            { "xmf", "Mingrelisch" },
            { "xog", "Soga" },
            { "yao", "Yao" },
            { "yap", "Yapesisch" },
            { "yav", "Yangben" },
            { "ybb", "Yemba" },
            { "yrl", "Nheengatu" },
            { "yue", "Kantonesisch" },
            { "zap", "Zapotekisch" },
            { "zbl", metaValue_zbl },
            { "zea", "Seel\u00e4ndisch" },
            { "zen", "Zenaga" },
            { "zgh", "Tamazight" },
            { "zun", "Zuni" },
            { "zxx", "Keine Sprachinhalte" },
            { "zza", "Zaza" },
            { "Adlm", "Adlam" },
            { "Afak", "Afaka" },
            { "Aghb", "Kaukasisch-Albanisch" },
            { "Arab", metaValue_ar },
            { "Aran", "Nastaliq" },
            { "Armn", metaValue_hy },
            { "Avst", metaValue_ae },
            { "Bali", metaValue_ban },
            { "Bamu", metaValue_bax },
            { "Bass", metaValue_bas },
            { "Batk", "Battakisch" },
            { "Beng", metaValue_bn },
            { "Blis", metaValue_zbl },
            { "Bopo", "Bopomofo" },
            { "Brah", "Brahmi" },
            { "Brai", "Braille" },
            { "Bugi", metaValue_bug },
            { "Buhd", "Buhid" },
            { "Cakm", metaValue_ccp },
            { "Cans", "UCAS" },
            { "Cari", "Karisch" },
            { "Cham", "Cham" },
            { "Cher", metaValue_chr },
            { "Cirt", "Cirth" },
            { "Copt", metaValue_cop },
            { "Cprt", "Zypriotisch" },
            { "Cyrl", "Kyrillisch" },
            { "Cyrs", "Altkirchenslawisch" },
            { "Deva", "Devanagari" },
            { "Dsrt", "Deseret" },
            { "Dupl", "Duployanisch" },
            { "Egyd", "\u00c4gyptisch - Demotisch" },
            { "Egyh", "\u00c4gyptisch - Hieratisch" },
            { "Egyp", "\u00c4gyptische Hieroglyphen" },
            { "Elba", "Elbasanisch" },
            { "Ethi", "\u00c4thiopisch" },
            { "Geok", "Khutsuri" },
            { "Geor", metaValue_ka },
            { "Glag", "Glagolitisch" },
            { "Goth", metaValue_got },
            { "Gran", "Grantha" },
            { "Grek", metaValue_el },
            { "Gujr", metaValue_gu },
            { "Guru", "Gurmukhi" },
            { "Hanb", "Han mit Bopomofo" },
            { "Hang", "Hangul" },
            { "Hani", metaValue_zh },
            { "Hano", "Hanunoo" },
            { "Hans", "Vereinfacht" },
            { "Hant", "Traditionell" },
            { "Hebr", metaValue_he },
            { "Hira", "Hiragana" },
            { "Hluw", "Hieroglyphen-Luwisch" },
            { "Hmng", "Pahawh Hmong" },
            { "Hrkt", "Japanische Silbenschrift" },
            { "Hung", "Altungarisch" },
            { "Inds", "Indus-Schrift" },
            { "Ital", "Altitalisch" },
            { "Jamo", "Jamo" },
            { "Java", "Javanesisch" },
            { "Jpan", metaValue_ja },
            { "Jurc", "Jurchen" },
            { "Kali", "Kayah Li" },
            { "Kana", "Katakana" },
            { "Khar", "Kharoshthi" },
            { "Khmr", metaValue_km },
            { "Khoj", "Khojki" },
            { "Knda", metaValue_kn },
            { "Kore", metaValue_ko },
            { "Kpel", metaValue_kpe },
            { "Kthi", "Kaithi" },
            { "Lana", "Lanna" },
            { "Laoo", metaValue_lo },
            { "Latf", "Lateinisch - Fraktur-Variante" },
            { "Latg", "Lateinisch - G\u00e4lische Variante" },
            { "Latn", "Lateinisch" },
            { "Lepc", "Lepcha" },
            { "Limb", "Limbu" },
            { "Lina", "Linear A" },
            { "Linb", "Linear B" },
            { "Lisu", "Fraser" },
            { "Loma", "Loma" },
            { "Lyci", "Lykisch" },
            { "Lydi", "Lydisch" },
            { "Mahj", "Mahajani" },
            { "Mand", "Mand\u00e4isch" },
            { "Mani", "Manich\u00e4isch" },
            { "Maya", "Maya-Hieroglyphen" },
            { "Mend", metaValue_men },
            { "Merc", "Meroitisch kursiv" },
            { "Mero", "Meroitisch" },
            { "Mlym", metaValue_ml },
            { "Modi", "Modi" },
            { "Mong", metaValue_mn },
            { "Moon", "Moon" },
            { "Mroo", "Mro" },
            { "Mtei", "Meitei-Mayek" },
            { "Mymr", metaValue_my },
            { "Narb", "Altnordarabisch" },
            { "Nbat", "Nabat\u00e4isch" },
            { "Nkgb", "Geba" },
            { "Nkoo", metaValue_nqo },
            { "Nshu", "Frauenschrift" },
            { "Ogam", "Ogham" },
            { "Olck", "Ol Chiki" },
            { "Orkh", "Orchon-Runen" },
            { "Orya", metaValue_or },
            { "Osma", metaValue_ota },
            { "Palm", "Palmyrenisch" },
            { "Pauc", "Pau Cin Hau" },
            { "Perm", "Altpermisch" },
            { "Phag", "Phags-pa" },
            { "Phli", "Buch-Pahlavi" },
            { "Phlp", "Psalter-Pahlavi" },
            { "Phlv", "Pahlavi" },
            { "Phnx", metaValue_phn },
            { "Plrd", "Pollard Phonetisch" },
            { "Prti", "Parthisch" },
            { "Qaag", "Zawgyi" },
            { "Rjng", "Rejang" },
            { "Rohg", "Hanifi Rohingya" },
            { "Roro", "Rongorongo" },
            { "Runr", "Runenschrift" },
            { "Samr", metaValue_sam },
            { "Sara", "Sarati" },
            { "Sarb", "Alts\u00fcdarabisch" },
            { "Saur", metaValue_saz },
            { "Sgnw", "Geb\u00e4rdensprache" },
            { "Shaw", "Shaw-Alphabet" },
            { "Shrd", "Sharada" },
            { "Sidd", "Siddham" },
            { "Sind", "Khudawadi" },
            { "Sinh", metaValue_si },
            { "Sora", "Sora Sompeng" },
            { "Sund", metaValue_su },
            { "Sylo", "Syloti Nagri" },
            { "Syrc", metaValue_syr },
            { "Syre", "Syrisch - Estrangelo-Variante" },
            { "Syrj", "Westsyrisch" },
            { "Syrn", "Ostsyrisch" },
            { "Tagb", "Tagbanwa" },
            { "Takr", "Takri" },
            { "Tale", "Tai Le" },
            { "Talu", "Tai Lue" },
            { "Taml", "Tamilisch" },
            { "Tang", "Xixia" },
            { "Tavt", "Tai-Viet" },
            { "Telu", metaValue_te },
            { "Teng", "Tengwar" },
            { "Tfng", "Tifinagh" },
            { "Tglg", metaValue_tl },
            { "Thaa", "Thaana" },
            { "Thai", "Thai" },
            { "Tibt", metaValue_bo },
            { "Tirh", "Tirhuta" },
            { "Ugar", metaValue_uga },
            { "Vaii", metaValue_vai },
            { "Visp", "Sichtbare Sprache" },
            { "Wara", "Varang Kshiti" },
            { "Wole", "Woleaianisch" },
            { "Xpeo", metaValue_peo },
            { "Xsux", "Sumerisch-akkadische Keilschrift" },
            { "Yiii", metaValue_ii },
            { "Zinh", "Geerbter Schriftwert" },
            { "Zmth", "Mathematische Notation" },
            { "Zsye", "Emoji" },
            { "Zsym", "Symbole" },
            { "Zxxx", "Schriftlos" },
            { "Zyyy", "Verbreitet" },
            { "Zzzz", "Unbekannte Schrift" },
            { "de_AT", "\u00d6sterreichisches Deutsch" },
            { "de_CH", "Schweizer Hochdeutsch" },
            { "fa_AF", "Dari" },
            { "nl_BE", "Fl\u00e4misch" },
            { "ro_MD", "Moldauisch" },
            { "sw_CD", "Kongo-Swahili" },
            { "%%1901", "Alte deutsche Rechtschreibung" },
            { "%%1994", "Standardisierte Resianische Rechtschreibung" },
            { "%%1996", "Neue deutsche Rechtschreibung" },
            { "ar_001", "Modernes Hocharabisch" },
            { "key.ca", "Kalender" },
            { "key.cf", "W\u00e4hrungsformat" },
            { "key.co", "Sortierung" },
            { "key.cu", "W\u00e4hrung" },
            { "key.hc", "Stundenformat (12h/24h)" },
            { "key.lb", "Zeilenumbruchstil" },
            { "key.ms", "Ma\u00dfsystem" },
            { "key.nu", "Zahlen" },
            { "key.tz", "Zeitzone" },
            { "key.va", "Lokale Variante" },
            { "nds_NL", "Nieders\u00e4chsisch" },
            { "%%BISKE", "Bela-Dialekt" },
            { "%%BOONT", "Boontling" },
            { "%%KKCOR", "Allgemeine Rechtschreibung" },
            { "%%LIPAW", "Lipovaz-Dialekt" },
            { "%%NEDIS", "Natisone-Dialekt" },
            { "%%NJIVA", "Njiva-Dialekt" },
            { "%%OSOJS", "Osojane-Dialekt" },
            { "%%POSIX", "Posix" },
            { "%%ROZAJ", "Resianisch" },
            { "%%SAAHO", metaValue_ssy },
            { "%%SOLBA", "Solbica-Dialekt" },
            { "%%UCCOR", "Vereinheitlichte Rechtschreibung" },
            { "zh_Hans", "Chinesisch (vereinfacht)" },
            { "zh_Hant", "Chinesisch (traditionell)" },
            { "%%FONIPA", "IPA Phonetisch" },
            { "%%FONUPA", "Phonetisch (UPA)" },
            { "%%PINYIN", "Pinyin" },
            { "%%SCOUSE", "Scouse-Dialekt" },
            { "%%TARASK", "Taraskievica-Orthographie" },
            { "%%UCRCOR", "Vereinheitlichte \u00fcberarbeitete Rechtschreibung" },
            { "%%AREVELA", "Ostarmenisch" },
            { "%%AREVMDA", "Westarmenisch" },
            { "%%MONOTON", "Monotonisch" },
            { "%%POLYTON", "Polytonisch" },
            { "%%REVISED", "Revidierte Rechtschreibung" },
            { "%%1606NICT", "Sp\u00e4tes Mittelfranz\u00f6sisch" },
            { "%%1694ACAD", "Klassisches Franz\u00f6sisch" },
            { "%%1959ACAD", "Akademisch" },
            { "%%BAKU1926", "Einheitliches T\u00fcrkisches Alphabet" },
            { "%%SCOTLAND", "Schottisches Standardenglisch" },
            { "%%VALENCIA", "Valencianisch" },
            { "%%WADEGILE", "Wade-Giles" },
            { "type.ca.roc", "Kalender der Republik China" },
            { "type.co.eor", "Europ\u00e4ische Sortierregeln" },
            { "type.hc.h11", "12-Stunden-Format (0-11)" },
            { "type.hc.h12", "12-Stunden-Format (1-12)" },
            { "type.hc.h23", "24-Stunden-Format (0-23)" },
            { "type.hc.h24", "24-Stunden-Format (1-24)" },
            { "type.m0.bgn", "BGN" },
            { "type.nu.arab", "Arabisch-indische Ziffern" },
            { "type.nu.armn", "Armenische Ziffern" },
            { "type.nu.bali", "Balinesische Ziffern" },
            { "type.nu.beng", "Bengalische Ziffern" },
            { "type.nu.brah", "Brahmi-Ziffern" },
            { "type.nu.cakm", "Chakma-Ziffern" },
            { "type.nu.cham", "Cham-Ziffern" },
            { "type.nu.deva", "Devanagari-Ziffern" },
            { "type.nu.ethi", "\u00c4thiopische Ziffern" },
            { "type.nu.geor", "Georgische Ziffern" },
            { "type.nu.grek", "Griechische Ziffern" },
            { "type.nu.gujr", "Gujarati-Ziffern" },
            { "type.nu.guru", "Gurmukhi-Ziffern" },
            { "type.nu.hans", "Vereinfacht-chinesische Ziffern" },
            { "type.nu.hant", "Traditionell-chinesische Ziffern" },
            { "type.nu.hebr", "Hebr\u00e4ische Ziffern" },
            { "type.nu.java", "Javanesische Ziffern" },
            { "type.nu.jpan", "Japanische Ziffern" },
            { "type.nu.kali", "Kayah-Li-Ziffern" },
            { "type.nu.khmr", "Khmer-Ziffern" },
            { "type.nu.knda", "Kannada-Ziffern" },
            { "type.nu.lana", "Lanna-Ziffern (s\u00e4kular)" },
            { "type.nu.laoo", "Laotische Ziffern" },
            { "type.nu.latn", "Westliche Ziffern" },
            { "type.nu.lepc", "Lepcha-Ziffern" },
            { "type.nu.limb", "Limbu-Ziffern" },
            { "type.nu.mlym", "Malayalam-Ziffern" },
            { "type.nu.mong", "Mongolische Ziffern" },
            { "type.nu.mtei", "Meitei-Mayek-Ziffern" },
            { "type.nu.mymr", "Myanmar-Ziffern" },
            { "type.nu.nkoo", "N\u2019Ko-Ziffern" },
            { "type.nu.olck", "Ol-Chiki-Ziffern" },
            { "type.nu.orya", "Oriya-Ziffern" },
            { "type.nu.saur", "Saurashtra-Ziffern" },
            { "type.nu.shrd", "Sharada-Ziffern" },
            { "type.nu.sora", "Sora-Sompeng-Ziffern" },
            { "type.nu.sund", "Sundanesische Ziffern" },
            { "type.nu.takr", "Takri-Ziffern" },
            { "type.nu.talu", "Neue Tai-L\u00fc-Ziffern" },
            { "type.nu.taml", "Tamilische Ziffern" },
            { "type.nu.telu", "Telugu-Ziffern" },
            { "type.nu.thai", "Thai-Ziffern" },
            { "type.nu.tibt", "Tibetische Ziffern" },
            { "type.nu.vaii", "Vai-Ziffern" },
            { "type.ca.dangi", "Dangi-Kalender" },
            { "type.co.ducet", "Unicode-Sortierung" },
            { "type.lb.loose", "Lockerer Zeilenumbruch" },
            { "type.nu.roman", "R\u00f6mische Ziffern" },
            { "type.ca.coptic", "Koptischer Kalender" },
            { "type.ca.hebrew", "Hebr\u00e4ischer Kalender" },
            { "type.ca.indian", "Indischer Nationalkalender" },
            { "type.co.compat", "Vorherige Sortierung, Kompatibilit\u00e4t" },
            { "type.co.pinyin", "Pinyin-Sortierung" },
            { "type.co.search", "Allgemeine Suche" },
            { "type.co.stroke", "Strichfolge" },
            { "type.co.unihan", "Radikal-und-Strich-Sortierung" },
            { "type.co.zhuyin", "Zhuyin-Sortierung" },
            { "type.d0.fwidth", "Breit" },
            { "type.d0.hwidth", "Halbe Breite" },
            { "type.lb.normal", "Normaler Zeilenumbruch" },
            { "type.lb.strict", "Fester Zeilenumbruch" },
            { "type.m0.ungegn", "UNGEGN" },
            { "type.ms.metric", "Metrisches System" },
            { "type.nu.native", "Native Ziffern" },
            { "type.ca.chinese", "Chinesischer Kalender" },
            { "type.ca.islamic", "Hidschri-Kalender" },
            { "type.ca.iso8601", "ISO-8601-Kalender" },
            { "type.ca.persian", "Persischer Kalender" },
            { "type.cf.account", "W\u00e4hrungsformat (Buchhaltung)" },
            { "type.co.big5han", "Traditionelle chinesische Sortierung (Big5)" },
            { "type.d0.npinyin", "Numerisch" },
            { "type.nu.arabext", "Erweiterte arabisch-indische Ziffern" },
            { "type.nu.armnlow", "Armenische Ziffern in Kleinschrift" },
            { "type.nu.finance", "Finanzzahlen" },
            { "type.nu.greklow", "Griechische Ziffern in Kleinschrift" },
            { "type.nu.hanidec", "Chinesische Dezimalzahlen" },
            { "type.nu.hansfin", "Vereinfacht-chinesische Finanzziffern" },
            { "type.nu.hantfin", "Traditionell-chinesische Finanzziffern" },
            { "type.nu.jpanfin", "Japanische Finanzziffern" },
            { "type.nu.tamldec", "Tamil-Ziffern" },
            { "type.ca.buddhist", "Buddhistischer Kalender" },
            { "type.ca.ethiopic", "\u00c4thiopischer Kalender" },
            { "type.ca.japanese", "Japanischer Kalender" },
            { "type.cf.standard", "W\u00e4hrungsformat (Standard)" },
            { "type.co.phonetic", "Phonetische Sortierung" },
            { "type.co.searchjl", "Suche nach Anfangsbuchstaben des koreanischen Alphabets" },
            { "type.co.standard", "Standard-Sortierung" },
            { "type.ms.uksystem", "Britisches Ma\u00dfsystem" },
            { "type.ms.ussystem", "US-Ma\u00dfsystem" },
            { "type.nu.fullwide", "Vollbreite Ziffern" },
            { "type.nu.lanatham", "Lanna-Ziffern (sakral)" },
            { "type.nu.mymrshan", "Myanmarische Shan-Ziffern" },
            { "type.nu.romanlow", "R\u00f6mische Ziffern in Kleinschrift" },
            { "type.ca.gregorian", "Gregorianischer Kalender" },
            { "type.co.gb2312han", "Vereinfachte chinesische Sortierung (GB2312)" },
            { "type.co.phonebook", "Telefonbuch-Sortierung" },
            { "type.co.dictionary", "Lexikografische Sortierung" },
            { "type.co.traditional", "Traditionelle Sortierung" },
            { "type.nu.traditional", "Traditionelle Zahlen" },
            { "type.ca.islamic-civil", "B\u00fcrgerlicher Hidschri-Kalender (tabellarisch)" },
            { "type.ca.islamic-umalqura", "Hidschri-Kalender (Umm al-Qura)" },
            { "type.ca.ethiopic-amete-alem", "\u00c4thiopischer Am\u00e4t\u00e4-Al\u00e4m-Kalender" },
        };
        return data;
    }
}
