/*
 * Copyright (c) 2024, 2025, Oracle and/or its affiliates. All rights reserved.
 * DO NOT ALTER OR REMOVE COPYRIGHT NOTICES OR THIS FILE HEADER.
 *
 * This code is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 2 only, as
 * published by the Free Software Foundation.
 *
 * This code is distributed in the hope that it will be useful, but WITHOUT
 * ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
 * FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
 * version 2 for more details (a copy is included in the LICENSE file that
 * accompanied this code).
 *
 * You should have received a copy of the GNU General Public License version
 * 2 along with this work; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA.
 *
 * Please contact Oracle, 500 Oracle Parkway, Redwood Shores, CA 94065 USA
 * or visit www.oracle.com if you need additional information or have any
 * questions.
 *
 */

/*
 * @test id=static
 * @requires vm.cds.write.archived.java.heap
 * @library /test/lib
 * @build StringConcatStress
 * @run driver jdk.test.lib.helpers.ClassFileInstaller -jar app.jar StringConcatStressApp
 * @run driver StringConcatStress STATIC
 */

/*
 * @test id=aot
 * @requires vm.cds.supports.aot.class.linking
 * @comment work around JDK-8345635
 * @requires !vm.jvmci.enabled
 * @library /test/lib
 * @build StringConcatStress
 * @run driver jdk.test.lib.helpers.ClassFileInstaller -jar app.jar StringConcatStressApp
 * @run driver StringConcatStress AOT
 */

import jdk.test.lib.cds.CDSAppTester;
import jdk.test.lib.helpers.ClassFileInstaller;
import jdk.test.lib.process.OutputAnalyzer;

public class StringConcatStress {
    static final String appJar = ClassFileInstaller.getJarPath("app.jar");
    static final String mainClass = "StringConcatStressApp";

    public static void main(String[] args) throws Exception {
        Tester t = new Tester();
        t.run(args);
    }

    static class Tester extends CDSAppTester {
        public Tester() {
            super(mainClass);
        }

        @Override
        public String classpath(RunMode runMode) {
            return appJar;
        }

        public String[] vmArgs(RunMode runMode) {
            return new String[] {
                "-XX:+AOTClassLinking", // by default enables AOTInvokeDynamicLinking
            };
        }

        @Override
        public String[] appCommandLine(RunMode runMode) {
            return new String[] {
                mainClass
            };
        }

        @Override
        public void checkExecution(OutputAnalyzer out, RunMode runMode) {
            if (runMode.isApplicationExecuted()) {
                out.shouldContain("Result = 1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1,1END");
            }
        }
    }
}

class StringConcatStressApp {
    public static void main(String args[]) {
        System.out.println("Result = " + concat23String() + "END");
        lotsOfConcats();
    }

    // Test the handling of java.lang.invoke.StringConcat.highArityThreshold (default value is 20)
    // in java.lang.invoke.StringConcatFactory. If we have more than this number of concats, a
    // different form of CallSite is generated by StringConcatFactory that will uses
    // different kinds of hidden classes than usual.
    static String concat23String() {
        return f0 + ","+ f1 + ","+ f2 + ","+ f3 + ","+ f4 + ","+ f5 + ","+ f6 + ","+ f7 + ","+ f8 + ","+ f9 + ","
                + f10 + ","+ f11 + ","+ f12 + ","+ f13 + ","+ f14 + ","+ f15 + ","+ f16 + ","+ f17 + ","+ f18 + ","+ f19 + ","
                + f20 + ","+ f21 + ","+ f22;
    }

    private static String
            f0="1", f1="1", f2="1", f3="1", f4="1", f5="1", f6="1", f7="1", f8="1", f9="1",
            f10="1", f11="1", f12="1", f13="1", f14="1", f15="1", f16="1", f17="1", f18="1", f19="1",
            f20="1", f21="1", f22="1", f23="1", f24="1", f25="1", f26="1", f27="1", f28="1", f29="1",
            f30="1", f31="1", f32="1", f33="1", f34="1", f35="1", f36="1", f37="1", f38="1", f39="1",
            f40="1", f41="1", f42="1", f43="1", f44="1", f45="1", f46="1", f47="1", f48="1", f49="1",
            f50="1", f51="1", f52="1", f53="1", f54="1", f55="1", f56="1", f57="1", f58="1", f59="1",
            f60="1", f61="1", f62="1", f63="1", f64="1", f65="1", f66="1", f67="1", f68="1", f69="1",
            f70="1", f71="1", f72="1", f73="1", f74="1", f75="1", f76="1", f77="1", f78="1", f79="1",
            f80="1", f81="1", f82="1", f83="1", f84="1", f85="1", f86="1", f87="1", f88="1", f89="1",
            f90="1", f91="1", f92="1", f93="1", f94="1", f95="1", f96="1", f97="1", f98="1", f99="1",
            f100="1",f101="1",f102="1",f103="1",f104="1",f105="1",f106="1",f107="1",f108="1",f109="1",
            f110="1",f111="1",f112="1",f113="1",f114="1",f115="1",f116="1",f117="1",f118="1",f119="1",
            f120="1",f121="1",f122="1";


    static String result;
    static void lotsOfConcats() {
        long maxElapseMs = 2000;
        // Run this test case for no more than maxElapseMs milliseconds
        String s = System.getProperty("StringConcatStress.max.ms");
        if (s != null) {
            maxElapseMs = Long.parseLong(s);
        }

        long start = System.currentTimeMillis();
        int count = 0;
        long end;

        do {
            count ++;
            lotsOfConcatsInner();
            end = System.currentTimeMillis();;
        } while ((end - start) < maxElapseMs);

        System.out.println("Result  = " + result);
        System.out.println("Elapsed = " + (end - start) + " ms");
        System.out.println("Count   = " + count);
    }

    static void lotsOfConcatsInner() {
        int i = 17;
        byte b = (byte)127;
        char c = 'c';
        long l = 4711;
        boolean z = true;
        short s = 5;
        float f = 1.0f;
        double d = 2.5;
        String S = "S";
        String concat;
        concat = "" + i + l + i + b + d + d + d + b;
        concat = "" + S + S + f + f + S + l + "S" + f;
        concat = "" + c + f + s + s + "S" + d + s + b;
        concat = "" + f + z + z + s + l + d + c + S;
        concat = "" + f + "S" + c + b + f + c + "S" + s;
        concat = "" + "S" + d + l + s + s + z + i + b;
        concat = "" + S + b + "S" + s + S + l + d + s;
        concat = "" + d + b + s + z + i + l + z + S;
        concat = "" + z + z + d + i + c + c + d + "S";
        concat = "" + l + "S" + z + l + z + z + "S" + b;
        concat = "" + f + d + b + S + "S" + "S" + l + l;
        concat = "" + f + b + l + c + f + f + s + S;
        concat = "" + "S" + z + i + d + i + b + l + "S";
        concat = "" + "S" + S + S + z + i + S + z + c;
        concat = "" + f + i + i + b + z + c + i + S;
        concat = "" + d + f + d + f + s + i + d + "S";
        concat = "" + s + i + b + z + s + b + "S" + f;
        concat = "" + z + z + i + "S" + d + "S" + "S" + l;
        concat = "" + i + c + d + i + s + "S" + "S" + d;
        concat = "" + z + i + z + z + S + d + b + f;
        concat = "" + b + S + b + s + z + z + S + f;
        concat = "" + S + b + i + l + S + d + s + S;
        concat = "" + c + S + c + f + l + "S" + S + "S";
        concat = "" + b + l + b + b + s + l + l + z;
        concat = "" + "S" + b + c + d + f + l + l + b;
        concat = "" + c + S + S + i + c + z + d + z;
        concat = "" + z + d + b + S + "S" + i + l + b;
        concat = "" + z + l + S + f + b + d + l + i;
        concat = "" + i + b + l + b + l + "S" + d + d;
        concat = "" + c + s + c + z + i + i + c + c;
        concat = "" + l + i + z + "S" + d + "S" + "S" + l;
        concat = "" + "S" + "S" + b + c + i + S + z + f;
        concat = "" + d + l + d + i + d + c + z + f;
        concat = "" + b + "S" + c + c + f + z + b + f;
        concat = "" + s + c + d + c + "S" + b + "S" + b;
        concat = "" + i + i + S + i + s + d + f + d;
        concat = "" + S + c + s + i + "S" + c + s + b;
        concat = "" + b + s + l + S + S + s + c + i;
        concat = "" + s + S + d + f + S + S + s + z;
        concat = "" + S + S + c + "S" + z + f + l + s;
        concat = "" + c + d + z + f + s + f + c + S;
        concat = "" + z + b + c + c + S + c + z + l;
        concat = "" + l + "S" + "S" + c + i + S + c + l;
        concat = "" + d + d + i + z + "S" + z + i + d;
        concat = "" + d + d + f + i + "S" + b + d + b;
        concat = "" + c + l + f + d + d + b + d + c;
        concat = "" + "S" + "S" + i + i + f + c + f + S;
        concat = "" + l + z + S + b + d + f + d + b;
        concat = "" + l + S + z + f + "S" + l + f + "S";
        concat = "" + c + b + i + S + s + f + d + b;
        concat = "" + s + l + S + b + i + l + z + f;
        concat = "" + c + b + c + c + c + c + b + "S";
        concat = "" + s + s + l + S + "S" + z + l + f;
        concat = "" + i + d + d + z + z + b + b + s;
        concat = "" + "S" + "S" + b + d + z + f + s + s;
        concat = "" + b + "S" + c + b + z + d + "S" + l;
        concat = "" + c + f + S + s + z + s + S + i;
        concat = "" + d + b + i + i + z + S + c + z;
        concat = "" + s + l + l + f + "S" + f + s + S;
        concat = "" + i + c + l + "S" + S + s + f + f;
        concat = "" + d + d + s + "S" + l + z + f + b;
        concat = "" + f + l + c + "S" + f + f + "S" + S;
        concat = "" + f + l + d + S + c + i + f + c;
        concat = "" + c + "S" + z + z + i + s + i + S;
        concat = "" + f + "S" + l + d + c + s + s + b;
        concat = "" + i + i + "S" + l + c + S + d + b;
        concat = "" + "S" + z + s + f + "S" + d + z + z;
        concat = "" + "S" + S + l + "S" + l + "S" + d + f;
        concat = "" + l + f + S + f + "S" + f + i + b;
        concat = "" + l + c + b + f + s + S + d + c;
        concat = "" + s + c + l + "S" + l + b + l + S;
        concat = "" + z + "S" + s + "S" + z + s + i + c;
        concat = "" + i + z + "S" + z + f + i + S + S;
        concat = "" + S + b + f + "S" + f + i + b + S;
        concat = "" + s + S + b + S + c + c + f + b;
        concat = "" + "S" + d + b + d + i + c + S + c;
        concat = "" + b + "S" + f + c + s + b + z + "S";
        concat = "" + b + z + l + l + s + l + l + S;
        concat = "" + "S" + "S" + S + S + "S" + c + i + S;
        concat = "" + l + S + s + f + l + s + s + "S";
        concat = "" + z + d + S + z + b + l + l + b;
        concat = "" + S + f + b + "S" + c + d + f + d;
        concat = "" + i + l + S + c + S + d + "S" + c;
        concat = "" + c + b + "S" + s + s + i + z + "S";
        concat = "" + f + S + c + i + i + l + z + d;
        concat = "" + z + z + z + l + f + S + f + b;
        concat = "" + i + f + z + l + s + S + b + l;
        concat = "" + z + c + b + S + l + S + s + s;
        concat = "" + "S" + b + i + l + b + f + c + l;
        concat = "" + b + c + s + S + f + l + S + i;
        concat = "" + d + c + l + i + b + "S" + f + f;
        concat = "" + c + c + "S" + c + s + S + i + c;
        concat = "" + l + "S" + d + b + c + s + b + d;
        concat = "" + f + z + f + l + "S" + f + l + f;
        concat = "" + z + l + "S" + b + f + c + z + b;
        concat = "" + z + "S" + c + i + b + b + "S" + S;
        concat = "" + f + "S" + f + s + "S" + f + b + "S";
        concat = "" + f + i + c + S + b + "S" + d + d;
        concat = "" + f + f + d + i + f + d + d + i;
        concat = "" + f + d + f + z + f + c + s + b;
        concat = "" + f + b + f + s + f + f + c + S;
        concat = "" + i + S + l + c + s + d + d + f;
        concat = "" + S + b + c + d + c + s + b + z;
        concat = "" + f + b + "S" + z + l + f + s + b;
        concat = "" + d + S + f + "S" + f + s + f + c;
        concat = "" + c + d + "S" + i + d + z + i + c;
        concat = "" + S + "S" + c + S + c + l + c + i;
        concat = "" + d + c + f + "S" + b + S + s + d;
        concat = "" + i + S + z + i + z + l + i + c;
        concat = "" + S + f + s + f + z + i + "S" + f;
        concat = "" + b + d + s + d + d + i + S + z;
        concat = "" + z + z + b + i + d + z + s + c;
        concat = "" + c + i + b + z + s + c + l + c;
        concat = "" + S + f + s + c + s + z + i + "S";
        concat = "" + z + "S" + l + c + b + S + S + S;
        concat = "" + f + S + b + l + c + s + c + i;
        concat = "" + d + s + S + "S" + "S" + z + b + c;
        concat = "" + d + c + l + i + d + "S" + z + l;
        concat = "" + "S" + S + z + s + d + i + z + "S";
        concat = "" + c + z + f + "S" + l + i + c + i;
        concat = "" + c + i + c + S + s + s + S + z;
        concat = "" + c + f + f + l + l + i + z + d;
        concat = "" + s + S + "S" + z + l + "S" + S + c;
        concat = "" + f + l + z + f + c + i + c + z;
        concat = "" + z + s + f + l + i + i + "S" + i;
        concat = "" + S + i + i + b + S + s + z + z;
        concat = "" + z + "S" + "S" + z + f + "S" + i + f;
        concat = "" + f + "S" + c + c + i + z + l + f;
        concat = "" + b + f + f + S + f + z + S + s;
        concat = "" + i + d + f + z + d + i + i + f;
        concat = "" + b + d + d + l + "S" + d + b + i;
        concat = "" + i + "S" + b + i + S + l + z + f;
        concat = "" + z + f + s + s + "S" + s + l + "S";
        concat = "" + l + c + s + z + s + b + c + s;
        concat = "" + s + f + s + b + z + "S" + z + f;
        concat = "" + b + i + z + i + l + "S" + i + S;
        concat = "" + z + f + S + d + d + b + f + i;
        concat = "" + l + i + S + i + z + s + i + S;
        concat = "" + c + f + f + c + S + "S" + d + c;
        concat = "" + c + f + d + "S" + l + c + c + s;
        concat = "" + s + c + c + f + b + f + i + "S";
        concat = "" + i + "S" + S + l + i + "S" + i + l;
        concat = "" + b + l + z + "S" + s + c + z + i;
        concat = "" + d + "S" + "S" + "S" + b + S + c + l;
        concat = "" + l + l + z + "S" + z + d + S + b;
        concat = "" + S + b + s + b + b + i + d + s;
        concat = "" + "S" + c + S + z + s + i + z + b;
        concat = "" + f + "S" + c + "S" + s + l + c + b;
        concat = "" + l + s + c + S + z + z + d + s;
        concat = "" + z + b + s + s + l + d + f + i;
        concat = "" + c + c + i + c + b + c + S + s;
        concat = "" + z + f + s + i + c + f + b + i;
        concat = "" + "S" + f + f + f + z + l + l + l;
        concat = "" + c + i + z + S + d + l + S + z;
        concat = "" + c + d + "S" + l + f + c + l + "S";
        concat = "" + "S" + c + b + z + c + c + c + "S";
        concat = "" + z + d + S + d + l + d + c + z;
        concat = "" + c + d + l + s + z + s + b + f;
        concat = "" + l + s + d + z + l + b + i + i;
        concat = "" + f + l + b + i + l + b + z + "S";
        concat = "" + c + b + c + l + S + i + d + c;
        concat = "" + d + s + s + b + b + s + s + i;
        concat = "" + d + i + S + z + l + b + b + d;
        concat = "" + "S" + "S" + c + "S" + f + b + z + f;
        concat = "" + z + d + "S" + z + "S" + S + d + b;
        concat = "" + b + i + z + b + S + s + c + l;
        concat = "" + S + z + c + z + b + d + s + i;
        concat = "" + S + "S" + z + s + l + z + s + s;
        concat = "" + f + l + f + f + b + f + z + d;
        concat = "" + z + z + z + f + i + l + f + b;
        concat = "" + i + l + z + i + s + d + f + l;
        concat = "" + "S" + "S" + f + l + "S" + i + "S" + l;
        concat = "" + S + b + z + f + "S" + l + i + i;
        concat = "" + z + c + d + z + l + d + z + z;
        concat = "" + l + z + d + S + l + f + S + d;
        concat = "" + S + i + d + b + "S" + f + z + z;
        concat = "" + f + d + "S" + b + l + f + b + b;
        concat = "" + b + S + "S" + d + "S" + s + s + f;
        concat = "" + z + c + b + b + z + S + s + b;
        concat = "" + l + f + S + S + c + f + c + z;
        concat = "" + i + S + l + d + f + "S" + S + s;
        concat = "" + i + c + d + z + i + c + d + l;
        concat = "" + l + d + d + S + l + b + S + i;
        concat = "" + c + "S" + b + z + l + i + z + S;
        concat = "" + z + i + z + s + d + S + i + S;
        concat = "" + z + f + l + "S" + s + b + z + i;
        concat = "" + z + l + z + f + b + c + d + "S";
        concat = "" + l + s + i + "S" + S + c + f + i;
        concat = "" + S + s + b + f + f + "S" + s + i;
        concat = "" + i + s + c + "S" + z + f + "S" + d;
        concat = "" + f + s + c + f + d + s + b + c;
        concat = "" + c + s + d + d + "S" + s + f + "S";
        concat = "" + "S" + c + z + c + s + s + S + S;
        concat = "" + S + S + d + s + d + l + s + b;
        concat = "" + i + s + b + S + S + b + l + i;
        concat = "" + c + b + b + b + f + s + f + z;
        concat = "" + z + "S" + s + d + f + i + i + z;
        concat = "" + S + S + c + i + z + f + i + s;
        concat = "" + "S" + "S" + S + z + z + "S" + s + f;
        concat = "" + b + "S" + S + l + i + d + S + z;
        concat = "" + s + c + "S" + S + b + i + i + i;
        concat = "" + s + z + i + c + s + l + S + f;
        concat = "" + d + f + S + S + b + z + c + "S";
        concat = "" + z + "S" + c + "S" + b + s + f + "S";
        concat = "" + S + z + s + "S" + b + f + d + S;
        concat = "" + l + i + b + b + "S" + "S" + l + z;
        concat = "" + S + l + f + i + i + f + z + f;
        concat = "" + S + "S" + s + l + b + d + d + s;
        concat = "" + d + "S" + s + z + c + "S" + i + l;
        concat = "" + b + s + f + f + z + "S" + d + d;
        concat = "" + z + f + c + b + f + c + "S" + "S";
        concat = "" + S + S + z + b + s + f + l + i;
        concat = "" + l + i + c + z + b + b + S + b;
        concat = "" + z + c + i + "S" + s + s + "S" + S;
        concat = "" + S + d + c + z + b + s + i + i;
        concat = "" + s + z + d + s + i + d + d + S;
        concat = "" + s + z + s + l + s + l + s + z;
        concat = "" + f + d + c + f + l + f + i + z;
        concat = "" + l + d + d + z + d + "S" + z + z;
        concat = "" + "S" + d + c + "S" + l + s + "S" + c;
        concat = "" + c + S + z + i + "S" + i + i + z;
        concat = "" + d + "S" + S + d + z + "S" + f + c;
        concat = "" + z + d + S + l + i + z + i + l;
        concat = "" + d + l + c + d + f + s + f + "S";
        concat = "" + f + c + d + d + l + l + f + d;
        concat = "" + "S" + z + f + b + d + c + "S" + s;
        concat = "" + l + S + "S" + d + S + i + l + z;
        concat = "" + i + S + l + i + l + z + d + f;
        concat = "" + d + i + s + S + l + d + S + S;
        concat = "" + l + d + l + b + b + i + z + S;
        concat = "" + f + s + z + f + i + l + d + b;
        concat = "" + s + d + l + z + b + b + c + i;
        concat = "" + f + z + s + d + f + f + d + f;
        concat = "" + d + z + d + f + "S" + "S" + s + z;
        concat = "" + c + f + "S" + "S" + b + s + s + i;
        concat = "" + "S" + "S" + d + b + d + "S" + i + b;
        concat = "" + d + S + l + f + d + d + b + b;
        concat = "" + d + l + d + S + b + "S" + f + d;
        concat = "" + l + c + s + l + "S" + l + S + f;
        concat = "" + i + b + i + d + s + s + f + c;
        concat = "" + i + z + z + S + d + z + c + l;
        concat = "" + S + i + l + "S" + f + f + c + b;
        concat = "" + "S" + S + d + b + d + f + z + d;
        concat = "" + d + d + "S" + d + c + S + "S" + b;
        concat = "" + l + i + c + f + S + s + z + z;
        concat = "" + c + l + S + i + S + s + z + i;
        concat = "" + i + "S" + i + "S" + "S" + "S" + b + c;
        concat = "" + f + z + S + f + c + l + b + i;
        concat = "" + d + l + b + z + d + s + s + S;
        concat = "" + s + S + d + s + z + l + S + z;
        concat = "" + i + s + z + b + l + l + b + d;
        concat = "" + i + z + b + z + d + S + f + l;
        concat = "" + S + z + l + b + i + f + l + i;
        concat = "" + s + s + b + c + s + f + c + f;
        concat = "" + f + i + s + f + c + S + c + s;
        concat = "" + s + "S" + z + d + f + S + b + S;
        concat = "" + i + z + S + d + l + b + i + z;
        concat = "" + i + c + i + b + i + l + d + f;
        concat = "" + S + b + s + s + s + c + S + l;
        concat = "" + S + f + s + "S" + l + l + s + c;
        concat = "" + z + l + S + S + s + d + S + f;
        concat = "" + z + f + S + i + d + d + S + b;
        concat = "" + S + d + "S" + l + l + i + l + i;
        concat = "" + b + b + i + i + d + i + "S" + s;
        concat = "" + l + c + "S" + l + s + b + l + l;
        concat = "" + "S" + s + l + c + b + c + s + S;
        concat = "" + z + S + b + d + l + d + i + b;
        concat = "" + b + i + S + i + l + i + f + b;
        concat = "" + d + S + s + S + "S" + b + c + l;
        concat = "" + b + c + c + f + S + b + c + d;
        concat = "" + i + i + b + S + f + f + b + c;
        concat = "" + i + S + l + "S" + f + f + S + f;
        concat = "" + f + l + f + c + "S" + c + b + "S";
        concat = "" + S + S + z + z + "S" + d + s + "S";
        concat = "" + b + z + i + i + f + c + s + l;
        concat = "" + i + d + S + b + l + "S" + l + f;
        concat = "" + b + c + s + s + z + f + z + l;
        concat = "" + f + f + S + s + z + d + f + s;
        concat = "" + S + "S" + d + f + c + S + z + i;
        concat = "" + s + "S" + S + d + s + i + i + "S";
        concat = "" + l + z + f + d + z + l + c + i;
        concat = "" + f + i + S + S + c + i + i + d;
        concat = "" + f + d + z + "S" + s + s + z + l;
        concat = "" + c + s + s + S + z + z + b + d;
        concat = "" + f + b + d + S + c + f + l + d;
        concat = "" + "S" + d + s + f + "S" + s + c + b;
        concat = "" + S + d + b + d + z + d + z + b;
        concat = "" + s + l + c + z + s + c + c + "S";
        concat = "" + z + b + s + f + b + i + l + S;
        concat = "" + s + b + "S" + S + b + d + d + i;
        concat = "" + "S" + c + i + z + f + l + s + f;
        concat = "" + c + z + S + i + "S" + z + b + s;
        concat = "" + l + i + z + z + z + s + b + d;
        concat = "" + S + c + d + d + z + s + l + c;
        concat = "" + l + f + i + f + S + "S" + "S" + f;
        concat = "" + f + S + s + S + c + i + i + s;
        concat = "" + f + l + l + z + f + s + "S" + s;
        concat = "" + f + l + S + S + c + i + l + i;
        concat = "" + c + s + S + c + f + c + i + i;
        concat = "" + c + b + c + i + s + d + S + d;
        concat = "" + z + c + b + s + "S" + z + z + c;
        concat = "" + f + d + c + "S" + s + "S" + c + "S";
        concat = "" + d + s + i + i + z + l + l + c;
        concat = "" + l + z + c + c + b + z + i + d;
        concat = "" + b + f + f + d + b + "S" + c + f;
        concat = "" + "S" + "S" + i + z + i + z + b + l;
        concat = "" + c + z + S + c + b + S + i + i;
        concat = "" + z + z + z + s + i + s + S + s;
        concat = "" + l + b + c + d + l + i + c + l;
        concat = "" + l + l + z + d + "S" + z + b + b;
        concat = "" + d + f + c + z + b + z + l + z;
        concat = "" + f + S + s + d + z + S + i + s;
        concat = "" + d + d + b + i + s + l + "S" + i;
        concat = "" + f + "S" + b + c + "S" + s + S + d;
        concat = "" + z + s + "S" + l + c + c + b + z;
        concat = "" + z + b + s + i + f + d + b + i;
        concat = "" + i + S + z + c + s + i + z + i;
        concat = "" + c + b + c + i + i + s + f + z;
        concat = "" + b + d + c + d + S + c + b + s;
        concat = "" + c + S + b + z + b + i + "S" + l;
/*
        concat = "" + z + "S" + c + l + z + "S" + z + b;
        concat = "" + "S" + "S" + f + c + c + b + d + c;
        concat = "" + b + s + f + f + S + "S" + d + s;
        concat = "" + z + "S" + b + s + l + S + s + f;
        concat = "" + s + i + i + i + b + l + f + c;
        concat = "" + z + s + z + z + d + S + S + c;
        concat = "" + c + l + S + "S" + l + s + b + i;
        concat = "" + c + s + S + f + S + b + f + s;
        concat = "" + s + S + c + s + b + b + f + z;
        concat = "" + c + f + f + b + z + z + b + s;
        concat = "" + f + s + z + f + b + l + f + f;
        concat = "" + S + d + f + c + c + s + z + S;
        concat = "" + c + b + z + f + b + d + b + S;
        concat = "" + b + "S" + d + b + c + d + S + f;
        concat = "" + "S" + d + S + "S" + S + S + S + i;
        concat = "" + f + l + l + "S" + "S" + i + c + "S";
        concat = "" + b + i + z + "S" + l + l + d + s;
        concat = "" + c + c + z + z + l + d + "S" + b;
        concat = "" + S + l + s + d + s + c + d + l;
        concat = "" + c + b + "S" + s + "S" + s + S + l;
        concat = "" + c + c + "S" + s + z + "S" + S + c;
        concat = "" + s + S + z + i + i + l + S + f;
        concat = "" + s + i + i + f + f + z + "S" + c;
        concat = "" + S + d + d + S + S + c + d + b;
        concat = "" + b + S + S + d + c + l + "S" + "S";
        concat = "" + S + l + i + i + b + c + f + c;
        concat = "" + s + c + S + d + i + c + s + z;
        concat = "" + i + f + s + b + S + z + f + "S";
        concat = "" + "S" + s + "S" + f + "S" + "S" + l + d;
        concat = "" + b + l + S + z + c + S + S + S;
        concat = "" + i + d + s + i + s + S + i + f;
        concat = "" + c + "S" + i + c + c + b + c + "S";
        concat = "" + "S" + S + c + f + z + f + l + l;
        concat = "" + i + S + d + d + "S" + s + i + "S";
        concat = "" + i + l + d + d + S + l + z + S;
        concat = "" + s + b + z + l + l + i + s + z;
        concat = "" + f + f + i + d + d + S + "S" + s;
        concat = "" + l + z + S + b + b + b + s + b;
        concat = "" + d + c + c + s + "S" + i + z + "S";
        concat = "" + "S" + b + c + b + s + f + d + i;
        concat = "" + s + "S" + z + d + d + l + b + c;
        concat = "" + S + S + d + i + S + z + z + c;
        concat = "" + l + "S" + i + s + z + s + i + s;
        concat = "" + c + z + c + z + l + d + S + l;
        concat = "" + f + f + f + s + "S" + i + d + d;
        concat = "" + d + f + b + i + f + f + s + f;
        concat = "" + f + f + s + b + i + c + z + "S";
        concat = "" + d + c + d + i + i + S + d + S;
        concat = "" + "S" + f + f + d + c + c + f + d;
        concat = "" + z + l + b + f + i + d + "S" + d;
        concat = "" + b + s + f + z + c + i + l + d;
        concat = "" + l + l + l + "S" + i + l + s + l;
        concat = "" + "S" + z + b + S + l + z + "S" + c;
        concat = "" + S + S + b + "S" + f + "S" + c + z;
        concat = "" + d + c + c + d + d + f + c + b;
        concat = "" + S + c + b + f + l + s + b + c;
        concat = "" + s + b + l + z + i + f + b + c;
        concat = "" + S + c + "S" + d + d + f + b + z;
        concat = "" + l + "S" + l + z + "S" + s + S + s;
        concat = "" + f + l + S + s + f + S + l + c;
        concat = "" + l + d + z + z + "S" + z + i + b;
        concat = "" + b + s + c + "S" + z + "S" + c + z;
        concat = "" + s + l + "S" + b + s + d + b + i;
        concat = "" + S + "S" + z + z + z + s + i + l;
        concat = "" + "S" + "S" + z + d + c + z + c + S;
        concat = "" + c + S + f + "S" + l + z + s + "S";
        concat = "" + d + z + z + s + s + l + i + f;
        concat = "" + b + b + z + b + S + l + i + S;
        concat = "" + "S" + z + i + l + c + "S" + z + S;
        concat = "" + c + l + d + i + d + l + S + i;
        concat = "" + i + f + "S" + d + s + S + l + c;
        concat = "" + c + i + d + i + l + "S" + l + d;
        concat = "" + l + c + b + d + c + b + b + c;
        concat = "" + i + "S" + b + s + f + d + c + l;
        concat = "" + "S" + l + l + z + S + d + s + "S";
        concat = "" + f + f + f + s + S + c + S + l;
        concat = "" + "S" + f + s + S + "S" + S + "S" + s;
        concat = "" + f + z + c + s + f + c + i + d;
        concat = "" + c + z + d + d + c + i + l + l;
        concat = "" + c + "S" + S + S + c + b + l + z;
        concat = "" + f + z + S + i + S + b + l + c;
        concat = "" + i + s + c + S + f + l + z + f;
        concat = "" + i + S + "S" + c + z + s + i + "S";
        concat = "" + S + "S" + d + l + "S" + l + i + "S";
        concat = "" + l + d + f + c + S + i + b + s;
        concat = "" + l + l + l + z + d + s + l + z;
        concat = "" + "S" + i + d + l + f + S + c + z;
        concat = "" + l + S + "S" + d + d + l + z + s;
        concat = "" + c + i + b + d + "S" + "S" + s + f;
        concat = "" + "S" + f + d + c + l + S + s + i;
        concat = "" + d + d + f + f + l + l + f + b;
        concat = "" + s + c + f + d + b + s + l + b;
        concat = "" + b + f + d + s + c + z + "S" + z;
        concat = "" + l + S + s + "S" + S + S + c + i;
        concat = "" + f + s + i + f + b + S + i + z;
        concat = "" + S + f + d + z + z + s + f + s;
        concat = "" + d + "S" + s + i + b + d + c + i;
        concat = "" + l + z + d + d + f + d + s + i;
        concat = "" + f + s + S + i + "S" + "S" + S + S;
        concat = "" + l + "S" + z + f + s + l + S + z;
        concat = "" + s + "S" + b + "S" + d + z + i + d;
        concat = "" + s + c + d + f + "S" + s + l + f;
        concat = "" + i + s + i + i + b + l + S + f;
        concat = "" + S + "S" + S + l + s + l + c + "S";
        concat = "" + f + c + i + s + d + f + c + z;
        concat = "" + f + l + c + b + z + "S" + z + z;
        concat = "" + S + l + b + b + "S" + f + f + d;
        concat = "" + l + S + "S" + f + b + l + z + z;
        concat = "" + "S" + s + S + f + z + f + S + z;
        concat = "" + S + l + z + s + d + l + z + z;
        concat = "" + d + z + d + f + "S" + c + d + f;
        concat = "" + S + z + d + z + f + i + "S" + l;
        concat = "" + z + f + i + "S" + l + f + S + c;
        concat = "" + S + d + "S" + f + b + l + s + l;
        concat = "" + s + d + d + z + f + z + i + S;
        concat = "" + "S" + s + f + z + b + l + z + f;
        concat = "" + i + d + d + b + d + l + z + f;
        concat = "" + s + S + "S" + l + S + d + c + s;
        concat = "" + i + c + c + S + z + l + s + f;
        concat = "" + "S" + f + "S" + z + "S" + d + l + s;
        concat = "" + f + s + f + s + d + S + s + l;
        concat = "" + "S" + c + b + z + d + z + z + b;
        concat = "" + l + S + z + s + z + l + f + b;
        concat = "" + l + S + s + s + c + z + z + S;
        concat = "" + S + l + S + b + c + s + b + d;
        concat = "" + l + z + b + z + "S" + l + f + S;
        concat = "" + b + f + i + "S" + i + z + z + s;
        concat = "" + b + S + f + c + S + S + l + f;
        concat = "" + d + "S" + f + i + c + i + l + "S";
        concat = "" + z + i + S + z + S + "S" + s + l;
        concat = "" + "S" + S + b + l + "S" + "S" + s + "S";
        concat = "" + l + d + "S" + f + s + z + b + f;
        concat = "" + d + i + c + b + i + i + f + c;
        concat = "" + f + i + s + "S" + l + b + "S" + S;
        concat = "" + z + c + "S" + z + b + i + i + b;
        concat = "" + z + S + f + S + b + s + S + S;
        concat = "" + "S" + d + i + i + S + d + S + s;
        concat = "" + b + S + f + S + i + s + S + f;
        concat = "" + s + "S" + s + s + S + "S" + c + c;
        concat = "" + c + f + c + l + i + s + l + i;
        concat = "" + z + b + d + "S" + z + l + f + S;
        concat = "" + b + "S" + z + s + f + c + l + c;
        concat = "" + c + S + "S" + b + z + d + S + d;
        concat = "" + s + l + l + f + b + s + z + d;
        concat = "" + z + l + b + d + i + i + l + b;
        concat = "" + f + i + s + z + "S" + l + s + f;
        concat = "" + i + d + i + d + d + l + f + i;
        concat = "" + S + s + s + i + d + S + z + i;
        concat = "" + "S" + b + s + f + S + z + l + z;
        concat = "" + l + s + b + b + "S" + c + S + i;
        concat = "" + s + s + i + i + z + b + f + s;
        concat = "" + S + d + i + S + s + s + l + i;
        concat = "" + z + c + b + l + c + f + z + z;
        concat = "" + l + s + l + c + z + s + S + z;
        concat = "" + z + i + c + b + f + c + c + s;
        concat = "" + S + i + c + b + S + d + c + c;
        concat = "" + "S" + c + l + S + S + d + s + b;
        concat = "" + "S" + b + s + f + f + "S" + S + z;
        concat = "" + s + S + f + s + z + s + d + i;
        concat = "" + d + s + l + c + S + z + d + z;
        concat = "" + f + "S" + f + l + l + s + z + c;
        concat = "" + b + i + f + s + S + c + s + s;
        concat = "" + l + b + S + c + s + f + S + d;
        concat = "" + d + S + s + z + "S" + "S" + "S" + z;
        concat = "" + b + S + b + c + c + i + c + s;
        concat = "" + b + S + S + "S" + s + c + f + f;
        concat = "" + z + s + d + z + i + s + z + S;
        concat = "" + f + d + c + z + d + S + d + z;
        concat = "" + l + f + z + s + f + f + s + s;
        concat = "" + "S" + l + S + d + b + s + s + c;
        concat = "" + S + S + S + z + i + i + f + l;
        concat = "" + S + s + S + "S" + "S" + b + l + c;
        concat = "" + z + c + z + f + l + f + S + d;
        concat = "" + s + b + c + z + S + S + s + "S";
        concat = "" + f + z + S + d + z + i + b + z;
        concat = "" + z + b + z + d + f + d + c + S;
        concat = "" + S + i + "S" + i + l + c + "S" + "S";
        concat = "" + i + s + f + c + c + z + c + c;
        concat = "" + d + l + c + i + l + z + d + s;
        concat = "" + b + z + b + b + "S" + z + i + z;
        concat = "" + d + c + "S" + c + i + b + S + b;
        concat = "" + z + i + b + "S" + i + "S" + i + "S";
        concat = "" + d + S + i + "S" + S + d + c + f;
        concat = "" + f + i + d + l + c + i + "S" + d;
        concat = "" + "S" + d + S + "S" + "S" + "S" + S + S;
        concat = "" + c + d + b + s + l + i + l + l;
        concat = "" + s + d + b + b + f + i + z + z;
        concat = "" + z + b + z + c + f + f + b + d;
        concat = "" + c + b + i + z + S + l + d + d;
        concat = "" + z + "S" + z + S + i + l + z + b;
        concat = "" + S + "S" + "S" + b + s + i + d + c;
        concat = "" + l + f + "S" + z + S + c + S + c;
        concat = "" + s + d + i + s + l + "S" + l + i;
        concat = "" + S + S + c + i + "S" + f + z + d;
        concat = "" + c + i + S + "S" + l + l + s + c;
        concat = "" + l + f + "S" + S + S + i + i + d;
        concat = "" + d + b + i + b + c + z + c + f;
        concat = "" + l + d + z + l + l + l + f + "S";
        concat = "" + c + b + s + d + b + l + l + l;
        concat = "" + i + z + b + d + z + S + c + i;
        concat = "" + s + "S" + i + d + S + b + "S" + f;
        concat = "" + z + c + "S" + S + f + f + s + f;
        concat = "" + d + l + c + c + d + i + b + S;
        concat = "" + b + z + b + i + l + S + c + "S";
        concat = "" + d + f + b + d + f + c + l + l;
        concat = "" + "S" + "S" + b + i + z + z + i + f;
        concat = "" + l + f + b + s + f + d + l + S;
        concat = "" + d + l + f + S + b + c + b + i;
        concat = "" + S + l + c + s + i + "S" + l + s;
        concat = "" + c + c + l + z + l + i + S + z;
        concat = "" + "S" + "S" + i + d + z + l + f + b;
        concat = "" + i + c + s + i + i + z + i + b;
        concat = "" + f + c + b + d + "S" + f + "S" + s;
        concat = "" + i + c + S + d + "S" + "S" + S + c;
        concat = "" + l + s + i + c + z + b + i + l;
        concat = "" + s + l + i + b + f + "S" + l + "S";
        concat = "" + d + l + b + l + c + f + f + i;
        concat = "" + d + s + d + f + f + i + i + f;
        concat = "" + i + S + b + d + z + "S" + b + d;
        concat = "" + z + "S" + b + l + c + S + S + "S";
        concat = "" + s + "S" + "S" + f + d + b + l + d;
        concat = "" + b + "S" + "S" + d + d + l + d + "S";
        concat = "" + c + z + i + d + "S" + d + c + S;
        concat = "" + s + l + s + d + f + b + l + c;
        concat = "" + c + i + z + l + f + c + i + f;
        concat = "" + b + "S" + s + c + l + s + d + c;
        concat = "" + i + s + d + d + "S" + f + d + z;
        concat = "" + d + z + d + c + f + l + s + S;
        concat = "" + b + l + f + s + d + "S" + s + i;
        concat = "" + d + "S" + c + "S" + f + l + "S" + "S";
        concat = "" + c + c + c + "S" + d + d + "S" + z;
        concat = "" + "S" + S + l + "S" + c + z + s + c;
        concat = "" + "S" + s + "S" + "S" + d + s + i + "S";
        concat = "" + s + i + S + c + l + "S" + s + c;
        concat = "" + z + S + f + l + "S" + f + S + s;
        concat = "" + i + c + S + z + b + "S" + d + s;
        concat = "" + c + S + S + i + i + i + s + c;
        concat = "" + z + s + b + f + l + "S" + b + S;
        concat = "" + d + d + c + i + z + i + b + S;
        concat = "" + s + i + d + z + d + l + l + S;
        concat = "" + z + z + b + z + S + S + f + "S";
        concat = "" + c + z + l + S + b + c + c + "S";
        concat = "" + b + i + S + b + s + i + f + S;
        concat = "" + z + z + "S" + s + l + i + d + c;
        concat = "" + s + b + s + s + b + c + b + s;
        concat = "" + b + b + f + l + d + b + c + i;
        concat = "" + d + z + z + c + S + f + s + l;
        concat = "" + l + f + s + c + c + i + s + b;
        concat = "" + l + i + l + S + i + f + b + c;
        concat = "" + b + S + "S" + s + b + S + l + S;
        concat = "" + d + d + l + S + c + l + c + "S";
        concat = "" + b + i + i + d + z + f + l + b;
        concat = "" + z + f + "S" + z + b + z + z + b;
        concat = "" + d + "S" + f + z + b + S + l + i;
        concat = "" + b + c + d + c + l + l + d + b;
        concat = "" + b + l + S + b + b + s + b + b;
        concat = "" + c + c + "S" + i + S + b + f + c;
        concat = "" + c + b + c + f + l + i + d + f;
        concat = "" + b + l + f + S + z + l + d + z;
        concat = "" + z + s + i + i + "S" + b + s + b;
        concat = "" + c + i + s + S + c + "S" + s + c;
        concat = "" + "S" + z + f + l + s + c + "S" + S;
        concat = "" + z + "S" + S + s + "S" + b + b + l;
        concat = "" + c + S + b + s + "S" + c + z + l;
        concat = "" + f + c + s + l + b + c + b + i;
        concat = "" + s + i + i + c + s + z + f + s;
        concat = "" + d + f + i + s + s + c + s + b;
        concat = "" + "S" + i + f + b + d + b + S + s;
        concat = "" + l + z + "S" + c + f + d + f + l;
        concat = "" + s + c + z + "S" + l + c + d + c;
        concat = "" + z + d + S + s + c + "S" + s + "S";
        concat = "" + f + s + c + s + s + c + f + c;
        concat = "" + z + S + s + i + d + c + z + s;
        concat = "" + l + f + l + S + z + c + c + l;
        concat = "" + b + d + s + b + z + "S" + i + i;
        concat = "" + s + s + i + l + d + c + c + d;
        concat = "" + b + c + d + f + l + l + z + c;
        concat = "" + i + i + d + z + f + c + S + l;
        concat = "" + s + d + i + S + z + f + s + s;
        concat = "" + f + c + "S" + "S" + z + d + "S" + z;
        concat = "" + z + f + b + s + "S" + s + d + l;
        concat = "" + d + i + d + l + f + i + b + S;
        concat = "" + f + l + l + S + l + "S" + z + "S";
        concat = "" + z + s + b + "S" + l + b + S + z;
        concat = "" + z + z + c + d + b + l + f + b;
        concat = "" + S + d + b + S + s + S + i + l;
        concat = "" + f + c + f + z + f + c + d + c;
        concat = "" + b + s + f + z + i + s + d + z;
        concat = "" + f + z + "S" + i + "S" + l + b + "S";
        concat = "" + "S" + i + f + d + l + f + s + f;
        concat = "" + S + c + d + i + d + c + c + b;
        concat = "" + l + z + c + l + f + "S" + z + s;
        concat = "" + l + s + s + d + d + l + b + S;
        concat = "" + b + l + c + S + s + b + l + i;
        concat = "" + z + z + c + S + f + f + i + d;
        concat = "" + l + i + z + c + "S" + b + f + s;
        concat = "" + "S" + d + f + z + b + s + i + i;
        concat = "" + b + i + d + f + b + d + c + c;
        concat = "" + z + S + d + z + d + i + d + b;
        concat = "" + i + b + c + z + l + c + c + f;
        concat = "" + "S" + b + d + d + S + z + f + b;
        concat = "" + "S" + i + d + s + c + "S" + l + b;
        concat = "" + f + l + s + f + l + s + d + z;
        concat = "" + z + i + f + i + d + i + z + l;
        concat = "" + "S" + c + z + S + c + c + d + d;
        concat = "" + l + c + i + f + "S" + f + l + c;
        concat = "" + l + "S" + S + d + S + b + "S" + "S";
        concat = "" + s + f + "S" + s + S + i + "S" + f;
        concat = "" + "S" + d + "S" + b + b + S + s + b;
        concat = "" + i + i + b + f + z + f + i + d;
        concat = "" + S + d + c + d + d + "S" + d + S;
        concat = "" + f + i + d + S + f + s + s + s;
        concat = "" + l + f + i + i + i + s + "S" + z;
        concat = "" + d + f + l + l + "S" + f + c + S;
        concat = "" + z + i + S + i + l + z + f + i;
        concat = "" + b + f + "S" + S + S + d + z + S;
        concat = "" + S + l + "S" + l + f + b + f + i;
        concat = "" + S + z + f + b + "S" + "S" + i + l;
        concat = "" + s + d + l + S + i + s + b + l;
        concat = "" + "S" + f + f + c + b + s + l + b;
        concat = "" + s + i + "S" + z + S + "S" + z + f;
        concat = "" + l + d + S + c + z + S + S + b;
        concat = "" + f + z + d + "S" + z + z + l + c;
        concat = "" + c + b + s + c + S + b + s + d;
        concat = "" + l + b + S + d + c + c + d + f;
        concat = "" + s + b + z + f + b + "S" + s + c;
        concat = "" + c + d + s + S + l + i + "S" + S;
        concat = "" + z + d + f + "S" + l + d + i + i;
        concat = "" + S + b + f + "S" + s + b + "S" + c;
        concat = "" + f + c + i + z + c + i + d + z;
        concat = "" + b + d + f + i + z + "S" + s + b;
        concat = "" + f + b + s + c + S + s + i + d;
        concat = "" + s + i + d + c + z + z + f + S;
        concat = "" + z + f + b + z + i + b + S + i;
        concat = "" + S + c + z + z + z + S + "S" + z;
        concat = "" + i + l + c + "S" + S + "S" + d + c;
        concat = "" + b + z + c + z + f + s + c + b;
        concat = "" + b + i + z + c + c + l + d + z;
        concat = "" + d + l + S + i + i + l + d + b;
        concat = "" + "S" + f + "S" + d + i + b + l + S;
        concat = "" + z + s + d + s + s + z + S + f;
        concat = "" + i + b + z + s + S + l + "S" + l;
        concat = "" + c + l + i + f + l + b + z + s;
        concat = "" + f + s + c + "S" + i + b + f + "S";
        concat = "" + z + i + S + b + c + l + i + "S";
        concat = "" + z + z + f + "S" + d + b + f + "S";
        concat = "" + f + "S" + l + z + z + d + S + s;
        concat = "" + "S" + b + l + d + i + l + i + b;
        concat = "" + z + f + f + z + f + l + b + c;
        concat = "" + d + z + z + c + "S" + "S" + S + z;
        concat = "" + z + d + i + S + d + i + d + "S";
        concat = "" + f + s + l + z + b + b + b + z;
        concat = "" + S + d + d + s + d + d + l + b;
        concat = "" + z + s + d + S + d + c + "S" + d;
        concat = "" + s + "S" + l + f + c + i + l + z;
        concat = "" + "S" + "S" + s + l + "S" + S + c + c;
        concat = "" + S + S + l + b + z + b + f + z;
        concat = "" + S + f + s + S + d + l + l + d;
        concat = "" + d + f + i + i + l + z + "S" + d;
        concat = "" + l + f + "S" + l + b + z + f + c;
        concat = "" + s + S + "S" + b + "S" + "S" + l + c;
        concat = "" + d + z + s + f + S + c + z + f;
        concat = "" + c + z + c + s + l + S + i + l;
        concat = "" + "S" + S + z + l + c + f + S + b;
        concat = "" + d + S + c + b + z + f + f + c;
        concat = "" + l + z + c + z + "S" + f + b + c;
        concat = "" + l + S + c + l + s + "S" + i + S;
        concat = "" + "S" + d + l + z + S + b + b + f;
        concat = "" + c + l + f + b + z + S + d + b;
        concat = "" + z + "S" + i + d + f + l + b + f;
        concat = "" + d + "S" + z + z + "S" + S + z + c;
        concat = "" + "S" + S + d + c + "S" + i + S + S;
        concat = "" + "S" + "S" + s + f + d + s + S + f;
        concat = "" + z + i + l + i + "S" + c + z + b;
        concat = "" + S + S + z + z + i + b + "S" + l;
        concat = "" + l + "S" + l + i + s + s + s + d;
        concat = "" + l + "S" + z + b + l + f + c + f;
        concat = "" + b + S + z + l + i + i + z + s;
        concat = "" + z + b + d + S + i + "S" + f + l;
        concat = "" + l + f + l + f + d + S + d + i;
        concat = "" + b + c + b + f + z + s + S + d;
        concat = "" + z + S + s + f + d + l + "S" + s;
        concat = "" + s + f + c + l + z + S + i + c;
        concat = "" + d + "S" + s + c + i + d + d + d;
        concat = "" + z + l + d + s + i + b + c + l;
        concat = "" + f + f + S + z + b + l + "S" + l;
        concat = "" + z + b + b + d + b + c + f + z;
        concat = "" + l + c + l + f + S + b + f + "S";
        concat = "" + f + c + f + "S" + f + c + d + i;
        concat = "" + d + S + l + s + b + d + S + z;
        concat = "" + z + i + "S" + c + s + l + d + s;
        concat = "" + d + "S" + i + d + i + b + z + s;
        concat = "" + "S" + f + f + f + S + S + f + s;
        concat = "" + "S" + c + "S" + b + S + z + i + z;
        concat = "" + "S" + c + s + l + S + b + S + s;
        concat = "" + i + f + S + s + z + c + i + b;
        concat = "" + b + f + "S" + c + S + "S" + f + f;
        concat = "" + S + z + s + f + c + d + c + S;
        concat = "" + i + z + S + "S" + l + s + l + l;
        concat = "" + l + l + c + f + i + b + l + c;
        concat = "" + s + b + l + f + s + b + b + i;
        concat = "" + c + c + z + b + i + b + f + l;
        concat = "" + S + c + c + b + d + c + l + S;
        concat = "" + d + z + "S" + z + i + d + S + l;
        concat = "" + "S" + s + z + d + s + d + b + d;
        concat = "" + S + c + "S" + s + b + d + s + c;
        concat = "" + c + "S" + i + b + l + c + S + d;
        concat = "" + l + z + s + b + l + b + f + b;
        concat = "" + z + S + s + i + b + S + s + z;
        concat = "" + z + d + f + c + S + f + f + f;
        concat = "" + c + s + c + l + "S" + S + s + i;
        concat = "" + s + d + S + d + "S" + l + s + f;
        concat = "" + "S" + i + i + d + b + b + b + b;
        concat = "" + c + l + i + "S" + c + s + c + f;
        concat = "" + "S" + "S" + "S" + i + l + c + d + s;
        concat = "" + d + "S" + l + s + f + z + "S" + c;
        concat = "" + d + f + z + s + b + l + f + z;
        concat = "" + l + l + c + i + i + d + z + z;
        concat = "" + z + z + s + s + b + c + f + S;
        concat = "" + b + "S" + i + z + "S" + "S" + b + d;
        concat = "" + S + "S" + s + S + S + i + b + S;
        concat = "" + l + d + z + d + c + c + "S" + c;
        concat = "" + l + c + d + b + b + d + d + b;
        concat = "" + s + z + c + i + c + "S" + "S" + "S";
        concat = "" + s + s + "S" + b + z + c + d + S;
        concat = "" + c + S + f + f + S + l + f + "S";
        concat = "" + "S" + b + f + c + b + f + f + "S";
        concat = "" + s + S + d + "S" + S + l + b + f;
        concat = "" + b + c + l + b + f + l + b + z;
        concat = "" + i + s + s + S + c + l + l + S;
        concat = "" + i + b + f + z + z + S + z + l;
        concat = "" + c + d + f + d + S + "S" + l + s;
        concat = "" + s + S + b + c + z + z + i + s;
        concat = "" + S + z + d + S + s + c + b + s;
        concat = "" + b + d + c + z + l + S + z + b;
        concat = "" + b + i + f + i + "S" + b + s + f;
        concat = "" + b + S + z + c + z + z + b + z;
        concat = "" + l + d + d + c + "S" + "S" + c + f;
        concat = "" + l + s + c + l + f + f + "S" + i;
        concat = "" + S + z + z + S + c + S + f + S;
        concat = "" + S + c + c + b + c + S + z + f;
        concat = "" + d + s + s + i + z + c + d + s;
        concat = "" + s + c + b + z + f + S + z + S;
        concat = "" + S + z + l + i + s + c + s + z;
        concat = "" + i + l + "S" + s + b + f + l + z;
        concat = "" + f + i + l + c + l + l + i + z;
        concat = "" + b + "S" + l + d + l + i + c + S;
        concat = "" + s + S + S + f + s + S + l + d;
        concat = "" + l + l + f + d + c + s + d + c;
        concat = "" + b + d + S + l + z + c + i + z;
        concat = "" + z + f + "S" + z + d + z + z + f;
        concat = "" + s + s + d + l + S + z + d + "S";
        concat = "" + z + "S" + S + b + S + f + s + "S";
        concat = "" + c + "S" + c + z + b + l + l + f;
        concat = "" + S + S + S + d + i + z + s + d;
        concat = "" + c + c + l + f + c + f + i + f;
        concat = "" + l + c + f + i + b + f + i + f;
        concat = "" + l + s + b + "S" + z + f + f + z;
        concat = "" + s + z + z + i + d + s + b + z;
        concat = "" + c + "S" + i + "S" + "S" + f + S + l;
        concat = "" + s + c + s + d + c + S + i + s;
        concat = "" + z + S + f + f + s + z + s + s;
        concat = "" + "S" + S + d + l + "S" + f + s + z;
        concat = "" + i + l + b + l + d + i + i + b;
        concat = "" + z + d + S + c + f + S + "S" + S;
        concat = "" + S + l + f + l + d + i + "S" + z;
        concat = "" + d + "S" + z + z + b + z + i + l;
        concat = "" + z + c + d + s + c + b + "S" + S;
        concat = "" + f + S + l + f + b + f + "S" + S;
        concat = "" + s + S + c + l + d + S + l + z;
        concat = "" + d + i + i + i + b + l + d + d;
        concat = "" + l + S + b + s + l + s + d + d;
        concat = "" + b + S + l + z + f + S + c + i;
        concat = "" + f + "S" + z + d + z + s + d + f;
        concat = "" + b + s + d + c + c + d + z + "S";
        concat = "" + z + "S" + i + f + b + c + "S" + l;
        concat = "" + "S" + S + z + c + f + i + b + c;
        concat = "" + "S" + z + d + s + f + f + "S" + s;
        concat = "" + d + "S" + c + c + s + S + z + d;
        concat = "" + S + s + f + "S" + f + "S" + d + i;
        concat = "" + S + s + s + i + z + c + f + s;
        concat = "" + c + c + i + f + z + f + c + f;
        concat = "" + f + s + d + S + i + b + d + s;
        concat = "" + d + z + d + "S" + l + z + f + d;
        concat = "" + z + b + s + d + "S" + f + f + c;
        concat = "" + S + i + l + d + z + i + f + "S";
        concat = "" + "S" + c + i + d + z + S + i + S;
        concat = "" + S + "S" + b + "S" + s + S + f + d;
        concat = "" + S + z + b + "S" + i + c + i + "S";
        concat = "" + i + l + c + d + d + f + s + S;
        concat = "" + l + i + f + s + d + b + S + b;
        concat = "" + b + d + S + z + b + c + d + l;
        concat = "" + f + s + i + d + f + i + z + c;
        concat = "" + s + c + l + c + c + l + d + z;
        concat = "" + S + i + z + b + S + d + b + i;
        concat = "" + f + z + l + i + z + d + c + l;
        concat = "" + c + b + S + "S" + "S" + s + S + f;
        concat = "" + i + "S" + f + "S" + l + z + S + b;
        concat = "" + s + S + l + i + S + "S" + f + i;
        concat = "" + i + c + l + "S" + l + c + c + z;
        concat = "" + i + s + z + S + S + i + S + l;
        concat = "" + "S" + f + S + c + f + S + d + s;
        concat = "" + "S" + z + c + S + "S" + "S" + d + b;
        concat = "" + s + l + z + b + z + d + i + b;
        concat = "" + "S" + f + z + s + d + S + s + i;
        concat = "" + f + c + f + d + S + d + S + "S";
        concat = "" + l + z + S + "S" + S + i + z + c;
        concat = "" + i + z + z + i + i + f + d + "S";
        concat = "" + S + b + c + "S" + S + f + s + b;
        concat = "" + S + c + s + s + f + b + "S" + s;
        concat = "" + S + s + d + c + "S" + d + d + l;
        concat = "" + i + S + "S" + l + l + l + S + d;
        concat = "" + z + l + z + c + c + i + l + b;
        concat = "" + s + S + b + c + z + c + "S" + s;
        concat = "" + l + d + f + d + b + i + c + l;
        concat = "" + i + l + "S" + c + l + "S" + c + l;
        concat = "" + i + S + z + "S" + f + l + c + z;
        concat = "" + c + S + l + z + b + d + s + s;
        concat = "" + l + "S" + S + l + b + b + c + z;
        concat = "" + b + "S" + c + c + s + f + i + z;
        concat = "" + z + b + d + b + "S" + l + S + z;
        concat = "" + s + f + i + S + l + S + "S" + b;
        concat = "" + "S" + c + b + S + s + b + z + s;
        concat = "" + l + c + z + d + z + z + c + z;
        concat = "" + l + "S" + z + c + l + z + b + l;
        concat = "" + d + "S" + S + c + b + d + c + d;
        concat = "" + d + s + "S" + d + z + c + l + i;
        concat = "" + s + l + c + f + f + "S" + d + "S";
        concat = "" + f + s + d + z + z + d + "S" + s;
        concat = "" + z + d + s + i + d + s + d + s;
        concat = "" + c + z + f + i + i + i + d + f;
        concat = "" + l + l + i + S + d + c + z + z;
        concat = "" + "S" + l + l + b + z + z + S + c;
        concat = "" + l + S + l + S + b + c + S + b;
        concat = "" + b + b + b + c + b + c + f + c;
        concat = "" + l + d + "S" + b + d + "S" + b + S;
        concat = "" + b + c + f + S + z + l + i + "S";
        concat = "" + l + S + s + b + l + b + b + l;
        concat = "" + d + l + l + s + S + S + d + d;
        concat = "" + i + s + c + S + l + "S" + i + c;
        concat = "" + b + l + f + b + c + f + b + c;
        concat = "" + b + l + b + z + i + b + d + i;
        concat = "" + d + b + l + "S" + c + S + d + s;
        concat = "" + z + l + s + l + d + d + s + z;
        concat = "" + i + z + c + l + f + "S" + d + "S";
        concat = "" + c + s + f + s + z + b + S + z;
        concat = "" + "S" + d + c + l + d + z + S + f;
        concat = "" + "S" + i + S + s + s + z + f + l;
        concat = "" + z + d + z + S + S + l + S + f;
        concat = "" + S + b + b + d + l + l + S + S;
        concat = "" + S + s + z + "S" + c + i + S + s;
        concat = "" + l + d + S + c + "S" + l + c + f;
        concat = "" + c + d + c + s + f + c + l + i;
        concat = "" + "S" + "S" + f + d + l + l + S + S;
        concat = "" + z + b + z + z + "S" + l + i + s;
        concat = "" + z + z + "S" + z + f + "S" + s + b;
        concat = "" + s + l + f + s + b + b + c + d;
        concat = "" + z + "S" + f + S + s + s + S + b;
        concat = "" + z + i + l + S + s + b + b + "S";
        concat = "" + c + c + s + z + b + i + l + z;
        concat = "" + s + i + s + c + l + d + f + b;
        concat = "" + i + f + s + c + i + s + S + s;
        concat = "" + z + c + "S" + s + S + f + f + b;
        concat = "" + l + f + z + "S" + s + S + i + i;
        concat = "" + "S" + s + d + S + s + s + b + b;
        concat = "" + "S" + S + "S" + d + "S" + d + z + i;
        concat = "" + f + "S" + d + i + s + d + s + d;
        concat = "" + f + b + S + "S" + s + b + z + "S";
        concat = "" + S + s + S + "S" + "S" + S + d + i;
        concat = "" + "S" + i + i + b + d + l + S + S;
        concat = "" + S + d + f + b + d + S + b + s;
        concat = "" + b + s + c + z + "S" + d + i + f;
        concat = "" + S + f + z + "S" + c + d + "S" + b;
        concat = "" + z + l + s + z + d + i + c + S;
        concat = "" + d + z + S + "S" + b + d + z + z;
        concat = "" + l + "S" + f + "S" + d + c + z + b;
        concat = "" + l + b + z + f + S + s + s + "S";
        concat = "" + i + S + b + s + d + "S" + S + z;
        concat = "" + c + S + f + z + b + s + S + "S";
        concat = "" + i + z + "S" + d + s + "S" + z + i;
        concat = "" + z + s + d + s + S + z + s + "S";
        concat = "" + "S" + s + S + d + S + S + l + S;
        concat = "" + s + i + s + s + f + S + s + d;
        concat = "" + c + z + s + S + f + l + S + f;
        concat = "" + b + "S" + d + b + "S" + f + d + z;
        concat = "" + i + f + "S" + l + "S" + i + b + c;
        concat = "" + z + i + s + z + d + b + l + l;
        concat = "" + l + b + b + b + S + d + b + d;
        concat = "" + z + i + S + "S" + b + i + c + s;
        concat = "" + S + d + f + S + i + b + "S" + f;
        concat = "" + z + b + c + i + d + b + "S" + S;
        concat = "" + i + S + b + S + S + d + S + s;
        concat = "" + i + s + "S" + "S" + c + f + "S" + z;
        concat = "" + s + l + f + l + "S" + "S" + d + d;
        concat = "" + l + s + "S" + f + d + b + l + i;
        concat = "" + l + f + l + i + c + s + i + b;
        concat = "" + b + S + s + s + i + d + b + "S";
        concat = "" + S + s + b + l + "S" + l + s + l;
        concat = "" + b + f + b + l + "S" + l + c + b;
        concat = "" + l + l + z + S + z + S + c + b;
        concat = "" + z + f + c + f + b + s + S + "S";
        concat = "" + f + S + S + i + l + b + s + f;
        concat = "" + l + f + l + z + b + "S" + f + d;
        concat = "" + s + d + c + z + d + d + S + l;
        concat = "" + S + b + i + i + S + s + d + c;
        concat = "" + b + c + d + "S" + d + i + "S" + c;
        concat = "" + s + c + i + "S" + c + f + b + d;
        concat = "" + l + s + l + S + d + z + b + d;
        concat = "" + "S" + b + s + z + "S" + i + c + b;
        concat = "" + f + c + f + z + c + i + S + f;
        concat = "" + c + "S" + f + s + i + f + l + s;
        concat = "" + b + s + b + b + f + b + f + s;
        concat = "" + f + i + c + d + S + d + b + z;
        concat = "" + b + d + l + b + S + b + l + b;
        concat = "" + "S" + s + i + "S" + s + d + c + S;
        concat = "" + f + "S" + i + l + z + c + b + i;
        concat = "" + c + s + z + "S" + i + b + d + i;
        concat = "" + "S" + f + s + b + c + i + i + S;
        concat = "" + c + c + z + s + i + c + c + i;
        concat = "" + d + l + c + i + b + z + c + s;
        concat = "" + i + b + f + f + l + f + i + b;
        concat = "" + z + S + s + S + d + l + d + s;
        concat = "" + l + s + i + b + z + i + b + c;
        concat = "" + l + z + l + b + z + "S" + d + d;
        concat = "" + s + z + z + z + l + "S" + l + b;
        concat = "" + "S" + c + i + l + c + c + d + d;
        concat = "" + z + "S" + z + "S" + f + S + c + l;
        concat = "" + f + f + z + b + f + l + d + c;
        concat = "" + f + "S" + d + i + "S" + s + s + s;
        concat = "" + c + s + c + z + b + S + d + i;
        concat = "" + S + s + z + d + d + S + i + d;
        concat = "" + l + s + c + b + d + z + b + i;
        concat = "" + s + i + S + S + c + "S" + d + f;
        concat = "" + S + c + S + "S" + S + "S" + z + l;
        concat = "" + d + i + i + i + s + c + l + b;
        concat = "" + S + s + b + S + b + c + l + d;
        concat = "" + c + c + s + d + l + b + s + d;
        concat = "" + "S" + b + S + d + l + z + S + z;
        concat = "" + "S" + z + c + z + S + b + c + S;
        concat = "" + s + "S" + c + "S" + z + l + l + s;
        concat = "" + "S" + c + l + b + "S" + c + f + l;
        concat = "" + "S" + c + b + f + "S" + b + i + f;
        concat = "" + c + z + d + i + z + s + l + f;
        concat = "" + S + z + z + S + l + S + S + b;
        concat = "" + S + s + d + c + s + b + c + d;
        concat = "" + l + S + i + i + s + d + S + i;
        concat = "" + "S" + s + s + s + f + c + d + c;
        concat = "" + i + S + c + d + c + c + S + i;
        concat = "" + b + S + z + S + b + s + c + l;
        concat = "" + d + z + s + s + i + c + d + c;
        concat = "" + c + d + i + z + S + s + l + d;
        concat = "" + b + f + s + "S" + b + S + S + S;
        concat = "" + d + f + d + s + z + f + c + s;
        concat = "" + c + l + "S" + z + l + i + d + l;
        concat = "" + "S" + b + "S" + s + "S" + c + "S" + c;
        concat = "" + b + f + c + "S" + d + d + d + f;
        concat = "" + S + f + z + z + z + b + b + c;
        concat = "" + f + s + i + s + S + z + l + s;
        concat = "" + b + b + d + S + z + s + l + c;
        concat = "" + d + i + d + b + i + "S" + c + "S";
        concat = "" + c + s + "S" + i + z + s + S + i;
        concat = "" + b + f + f + b + S + c + f + s;
        concat = "" + b + c + i + l + S + S + l + f;
        concat = "" + f + c + f + c + "S" + b + i + l;
        concat = "" + f + l + i + l + l + l + i + d;
        concat = "" + "S" + s + i + s + i + b + f + f;
        concat = "" + f + "S" + z + "S" + "S" + c + s + s;
        concat = "" + f + i + l + b + "S" + S + s + s;
        concat = "" + s + f + f + f + l + c + S + b;
        concat = "" + S + d + i + i + "S" + z + d + f;
        concat = "" + z + c + S + c + S + c + i + z;
        concat = "" + d + S + i + s + f + "S" + l + s;
        concat = "" + c + b + f + z + s + l + z + c;
        concat = "" + b + c + c + "S" + S + S + d + b;
        concat = "" + s + f + "S" + "S" + z + l + d + d;
        concat = "" + z + i + i + z + s + c + c + f;
        concat = "" + s + d + d + "S" + "S" + f + f + "S";
        concat = "" + i + S + i + i + l + l + "S" + z;
        concat = "" + l + d + b + d + S + S + l + f;
        concat = "" + f + i + "S" + b + i + i + c + d;
        concat = "" + z + z + i + i + c + d + l + "S";
        concat = "" + s + d + b + l + f + d + z + f;
        concat = "" + d + c + "S" + d + "S" + l + d + i;
        concat = "" + l + s + c + "S" + l + l + i + f;
        concat = "" + s + s + i + "S" + i + s + b + i;
        concat = "" + "S" + c + s + d + i + s + S + d;
        concat = "" + b + l + S + b + b + i + d + b;
        concat = "" + c + b + S + b + "S" + b + b + c;
        concat = "" + d + "S" + S + s + c + i + z + "S";
        concat = "" + d + S + z + c + c + c + z + f;
        concat = "" + s + z + d + f + f + i + f + f;
        concat = "" + d + c + l + S + s + S + i + "S";
        concat = "" + S + f + s + s + l + b + s + z;
        concat = "" + c + l + f + S + i + b + i + i;
        concat = "" + l + b + b + s + c + z + f + f;
        concat = "" + f + c + s + S + z + "S" + d + b;
        concat = "" + i + S + l + s + z + s + s + l;
        concat = "" + S + z + f + s + c + b + c + s;
        concat = "" + c + b + z + s + c + l + s + i;
        concat = "" + f + l + s + s + S + s + i + S;
        concat = "" + s + s + b + i + d + l + d + b;
        concat = "" + S + "S" + s + s + s + d + d + b;
        concat = "" + b + "S" + "S" + b + S + "S" + c + b;
        concat = "" + d + S + c + f + "S" + "S" + z + s;
        concat = "" + i + d + i + l + c + l + d + S;
        concat = "" + l + "S" + S + d + S + b + c + f;
        concat = "" + l + f + c + d + d + s + d + c;
        concat = "" + l + l + z + l + f + l + "S" + S;
        concat = "" + s + "S" + d + f + s + l + c + f;
        concat = "" + "S" + d + s + i + s + "S" + s + c;
        concat = "" + "S" + S + "S" + z + d + f + S + d;
        concat = "" + d + "S" + i + f + z + c + l + "S";
        concat = "" + z + b + z + "S" + S + f + "S" + s;
        concat = "" + d + z + c + c + "S" + "S" + s + c;
        concat = "" + i + i + d + f + c + z + c + "S";
        concat = "" + b + S + S + f + s + b + d + b;
        concat = "" + f + i + d + "S" + l + s + c + f;
        concat = "" + i + c + f + s + z + S + f + z;
        concat = "" + z + b + c + S + b + "S" + s + s;
        concat = "" + "S" + s + d + i + i + "S" + S + l;
        concat = "" + b + b + b + c + "S" + S + i + f;
        concat = "" + b + b + b + d + S + z + z + f;
        concat = "" + c + z + d + s + z + l + b + b;
        concat = "" + b + d + z + s + b + l + l + s;
        concat = "" + "S" + s + z + b + z + S + b + s;
        concat = "" + z + l + d + d + f + f + s + z;
        concat = "" + f + b + b + z + s + i + z + l;
        concat = "" + f + i + "S" + l + S + d + c + i;
        concat = "" + "S" + i + b + c + d + S + b + "S";
        concat = "" + s + z + l + S + S + f + S + d;
        concat = "" + "S" + s + d + i + c + "S" + S + z;
        concat = "" + d + l + S + s + z + c + i + c;
        concat = "" + i + i + f + l + i + b + S + d;
        concat = "" + d + s + b + l + z + c + "S" + z;
        concat = "" + f + s + c + i + c + z + f + l;
        concat = "" + S + l + i + s + f + i + S + f;
        concat = "" + s + f + d + s + c + b + f + l;
        concat = "" + f + l + b + "S" + S + "S" + c + "S";
        concat = "" + l + i + d + l + z + "S" + b + b;
        concat = "" + "S" + i + s + s + s + b + z + c;
        concat = "" + l + i + b + s + l + "S" + c + c;
        concat = "" + d + s + f + "S" + f + i + S + b;
        concat = "" + S + "S" + d + b + b + d + z + z;
        concat = "" + f + s + i + l + f + d + b + s;
        concat = "" + c + b + s + z + "S" + i + s + f;
        concat = "" + f + i + z + S + s + S + s + l;
        concat = "" + l + z + "S" + l + c + l + l + "S";
        concat = "" + f + c + z + S + c + z + s + i;
        concat = "" + f + c + l + s + l + s + f + b;
        concat = "" + d + l + f + "S" + "S" + d + i + i;
        concat = "" + z + c + b + s + l + "S" + c + s;
        concat = "" + l + b + d + s + S + z + s + i;
        concat = "" + f + f + z + b + i + S + d + l;
        concat = "" + l + S + c + d + z + s + S + d;
        concat = "" + d + S + S + S + l + d + "S" + s;
        concat = "" + d + c + d + f + f + l + S + s;
        concat = "" + d + f + S + b + f + i + z + "S";
        concat = "" + i + c + z + S + z + s + f + s;
        concat = "" + d + l + c + "S" + "S" + c + b + "S";
        concat = "" + f + f + c + c + s + l + c + S;
        concat = "" + c + f + f + z + s + z + b + z;
        concat = "" + d + S + b + f + c + d + S + d;
        concat = "" + z + z + S + d + S + "S" + c + l;
        concat = "" + z + c + S + b + c + i + c + "S";
        concat = "" + l + s + s + z + f + f + d + c;
        concat = "" + c + "S" + S + b + b + i + l + f;
        concat = "" + b + "S" + c + s + b + "S" + l + s;
        concat = "" + f + l + c + f + l + z + "S" + S;
        concat = "" + S + S + l + s + z + b + c + i;
        concat = "" + d + l + f + f + S + "S" + S + d;
        concat = "" + l + c + S + i + b + s + f + c;
        concat = "" + d + f + f + b + f + s + f + S;
        concat = "" + d + l + l + b + d + f + "S" + d;
        concat = "" + f + c + b + s + z + i + l + l;
        concat = "" + "S" + z + l + c + z + f + i + "S";
        concat = "" + i + z + f + i + S + c + "S" + i;
        concat = "" + z + f + "S" + S + s + f + d + d;
        concat = "" + b + d + s + i + z + s + s + c;
        concat = "" + "S" + d + s + c + "S" + l + i + c;
        concat = "" + s + d + b + c + b + s + d + z;
        concat = "" + c + d + s + l + b + b + S + S;
        concat = "" + "S" + z + s + l + f + s + c + i;
        concat = "" + l + l + S + z + d + l + S + S;
        concat = "" + b + f + l + b + s + z + c + f;
        concat = "" + "S" + b + s + s + f + z + d + f;
        concat = "" + f + s + z + S + s + "S" + z + c;
        concat = "" + "S" + s + "S" + s + b + S + b + b;
        concat = "" + S + S + S + f + c + f + s + s;
        concat = "" + f + i + i + l + c + i + s + z;
        concat = "" + c + i + S + b + s + b + b + z;
        concat = "" + s + S + c + b + b + l + S + f;
        concat = "" + "S" + s + d + i + i + i + "S" + s;
        concat = "" + S + l + d + i + i + i + s + "S";
        concat = "" + b + z + S + "S" + i + l + c + i;
        concat = "" + c + z + S + f + f + c + z + z;
        concat = "" + i + "S" + S + "S" + l + b + "S" + l;
        concat = "" + i + s + z + l + "S" + S + "S" + z;
        concat = "" + l + d + s + l + z + c + c + c;
        concat = "" + c + l + l + "S" + b + c + l + b;
        concat = "" + i + f + b + l + s + z + i + "S";
        concat = "" + c + s + S + c + i + f + S + s;
        concat = "" + "S" + i + d + z + S + i + s + b;
        concat = "" + i + "S" + i + f + b + l + l + i;
        concat = "" + "S" + "S" + s + l + f + d + z + c;
        concat = "" + d + i + s + i + z + d + S + s;
        concat = "" + S + f + z + l + c + S + l + s;
        concat = "" + "S" + "S" + i + l + d + l + "S" + c;
        concat = "" + f + z + f + z + S + s + d + i;
        concat = "" + b + f + f + b + z + b + d + d;
        concat = "" + S + z + s + S + b + S + S + "S";
        concat = "" + S + d + i + i + s + i + l + b;
        concat = "" + c + d + "S" + d + S + b + d + l;
        concat = "" + b + f + d + l + i + d + l + z;
        concat = "" + l + c + l + b + c + z + c + l;
        concat = "" + s + z + S + S + b + S + c + b;
        concat = "" + c + c + d + f + d + "S" + d + i;
        concat = "" + z + s + d + i + b + z + d + d;
        concat = "" + "S" + i + "S" + f + d + S + "S" + f;
        concat = "" + i + z + s + S + c + d + d + f;
        concat = "" + l + s + c + b + s + "S" + "S" + "S";
        concat = "" + i + d + f + l + s + S + f + b;
        concat = "" + i + d + "S" + f + s + d + s + f;
        concat = "" + z + f + i + "S" + l + S + "S" + f;
        concat = "" + l + d + S + s + s + s + s + d;
        concat = "" + z + b + b + i + i + c + z + z;
        concat = "" + c + l + c + i + S + c + s + c;
        concat = "" + S + "S" + s + s + c + b + d + i;
        concat = "" + i + b + d + z + l + s + l + i;
        concat = "" + i + b + b + b + i + b + b + d;
        concat = "" + f + i + d + l + l + b + s + z;
        concat = "" + S + f + S + "S" + c + s + f + "S";
        concat = "" + c + "S" + d + "S" + c + S + c + "S";
        concat = "" + z + "S" + f + b + i + l + c + i;
        concat = "" + l + c + b + l + f + s + S + l;
        concat = "" + c + S + S + d + z + S + "S" + z;
        concat = "" + d + i + d + "S" + "S" + s + s + S;
        concat = "" + z + s + S + f + d + z + b + l;
        concat = "" + d + z + l + "S" + d + i + s + s;
        concat = "" + i + s + l + l + z + c + S + S;
        concat = "" + i + S + c + S + d + S + l + s;
        concat = "" + i + s + f + f + z + s + c + z;
        concat = "" + f + z + S + i + s + f + "S" + b;
        concat = "" + S + d + f + s + S + i + z + i;
        concat = "" + f + i + d + b + s + d + "S" + l;
        concat = "" + b + s + c + S + S + d + "S" + "S";
        concat = "" + z + "S" + S + c + s + s + S + l;
        concat = "" + b + S + i + s + f + s + S + z;
        concat = "" + l + f + "S" + c + s + b + z + f;
        concat = "" + i + i + b + i + d + "S" + i + i;
        concat = "" + d + d + l + "S" + d + i + "S" + l;
        concat = "" + c + i + l + S + "S" + "S" + f + "S";
        concat = "" + s + "S" + c + i + b + S + S + b;
        concat = "" + l + d + d + z + c + z + b + s;
        concat = "" + d + i + S + c + d + i + c + c;
        concat = "" + s + S + i + "S" + b + S + c + "S";
        concat = "" + S + d + "S" + S + d + f + s + c;
        concat = "" + s + s + l + b + s + c + c + i;
        concat = "" + b + d + c + d + z + z + z + d;
        concat = "" + c + c + "S" + z + l + s + c + f;
        concat = "" + d + b + c + s + b + S + d + f;
        concat = "" + s + b + s + f + d + "S" + f + d;
        concat = "" + S + "S" + f + z + S + c + s + s;
        concat = "" + S + b + d + c + l + l + s + l;
        concat = "" + l + S + i + l + d + f + f + "S";
        concat = "" + s + s + c + i + i + l + f + z;
        concat = "" + i + l + "S" + s + S + s + i + S;
        concat = "" + i + d + s + "S" + b + f + "S" + c;
        concat = "" + c + "S" + z + b + l + s + S + i;
        concat = "" + i + z + "S" + s + b + c + s + i;
        concat = "" + l + f + b + f + i + d + "S" + l;
        concat = "" + c + c + b + s + "S" + S + d + d;
        concat = "" + S + "S" + i + f + d + s + l + S;
        concat = "" + b + d + "S" + S + c + b + "S" + z;
        concat = "" + c + d + i + S + f + b + b + i;
        concat = "" + f + i + i + l + z + "S" + z + f;
        concat = "" + z + f + "S" + c + z + l + c + f;
        concat = "" + c + c + d + s + d + b + l + d;
        concat = "" + "S" + s + l + l + "S" + d + l + l;
        concat = "" + b + i + c + c + b + S + d + S;
        concat = "" + f + d + i + s + c + b + l + b;
        concat = "" + s + b + S + f + S + b + l + i;
        concat = "" + z + "S" + s + i + S + i + b + c;
        concat = "" + s + S + d + S + z + b + b + d;
        concat = "" + i + s + "S" + z + s + S + "S" + z;
        concat = "" + l + z + S + S + b + z + d + "S";
        concat = "" + S + b + z + S + s + l + "S" + b;
        concat = "" + d + b + d + z + s + i + z + f;
        concat = "" + "S" + "S" + b + b + c + z + S + f;
        concat = "" + d + s + i + i + b + z + "S" + s;
        concat = "" + i + f + "S" + z + i + s + s + z;
        concat = "" + S + f + c + z + "S" + l + "S" + "S";
        concat = "" + "S" + f + z + S + c + d + c + s;
        concat = "" + d + l + c + c + b + z + d + d;
        concat = "" + b + s + d + d + b + d + b + d;
        concat = "" + b + b + d + i + "S" + d + "S" + d;
        concat = "" + s + c + d + "S" + z + f + z + s;
        concat = "" + l + "S" + c + s + s + i + b + "S";
        concat = "" + b + l + d + z + S + c + c + c;
        concat = "" + S + b + c + b + z + z + c + f;
        concat = "" + s + b + z + "S" + "S" + i + i + c;
        concat = "" + z + i + f + "S" + i + c + "S" + z;
        concat = "" + d + b + i + S + z + f + l + f;
        concat = "" + c + f + s + "S" + s + s + b + "S";
        concat = "" + i + c + S + d + i + "S" + d + S;
        concat = "" + d + b + s + z + S + S + "S" + "S";
        concat = "" + "S" + s + d + f + s + i + i + "S";
        concat = "" + f + z + c + z + b + b + s + "S";
        concat = "" + c + s + d + l + c + l + c + i;
        concat = "" + f + z + S + i + z + "S" + l + S;
        concat = "" + S + c + c + s + c + s + d + c;
        concat = "" + l + i + l + S + l + S + "S" + l;
        concat = "" + c + f + f + z + d + s + S + s;
        concat = "" + f + S + d + b + i + d + f + d;
        concat = "" + l + i + l + d + i + b + l + d;
        concat = "" + b + "S" + d + "S" + s + f + d + S;
        concat = "" + i + c + i + c + i + s + d + b;
        concat = "" + d + i + z + f + "S" + "S" + d + c;
        concat = "" + s + c + i + d + c + f + d + f;
        concat = "" + "S" + b + i + s + "S" + d + d + S;
        concat = "" + s + S + b + d + f + S + S + b;
        concat = "" + f + i + s + s + c + z + b + d;
        concat = "" + b + i + z + c + f + d + f + d;
        concat = "" + d + i + b + f + d + "S" + s + c;
        concat = "" + l + z + b + b + l + z + b + b;
        concat = "" + z + S + c + "S" + "S" + S + f + z;
        concat = "" + d + S + "S" + s + b + c + c + c;
        concat = "" + b + b + "S" + d + l + s + f + "S";
        concat = "" + b + d + c + "S" + b + i + c + l;
        concat = "" + i + b + z + S + s + i + b + z;
        concat = "" + l + s + f + f + z + l + c + b;
        concat = "" + s + S + l + f + i + c + i + s;
        concat = "" + d + i + S + b + s + S + S + "S";
        concat = "" + l + s + s + z + d + S + d + l;
        concat = "" + S + S + s + f + b + f + f + c;
        concat = "" + i + z + b + S + S + b + f + i;
        concat = "" + l + z + S + b + d + S + f + i;
        concat = "" + b + i + S + l + l + b + f + l;
        concat = "" + i + s + i + z + i + c + c + c;
        concat = "" + i + S + l + c + l + b + d + s;
        concat = "" + l + s + f + "S" + s + b + S + d;
        concat = "" + f + l + f + c + s + s + S + i;
        concat = "" + i + f + i + "S" + S + z + b + d;
        concat = "" + S + l + S + l + S + c + c + l;
        concat = "" + d + d + z + l + "S" + c + d + d;
        concat = "" + b + d + c + b + l + l + f + S;
        concat = "" + S + z + l + i + s + "S" + S + s;
        concat = "" + i + z + b + "S" + i + b + s + c;
        concat = "" + z + b + c + l + S + d + i + z;
        concat = "" + "S" + c + b + i + d + z + S + i;
        concat = "" + l + z + s + s + s + b + "S" + c;
        concat = "" + c + z + d + b + d + z + s + b;
        concat = "" + l + i + f + c + b + d + "S" + i;
        concat = "" + i + S + i + f + "S" + z + d + S;
        concat = "" + z + c + b + b + S + "S" + c + d;
        concat = "" + s + f + c + s + b + z + "S" + S;
        concat = "" + l + l + b + S + "S" + "S" + f + S;
        concat = "" + S + i + f + c + l + l + c + z;
        concat = "" + z + i + z + b + b + d + s + S;
        concat = "" + l + z + f + i + z + i + S + "S";
        concat = "" + i + z + i + s + "S" + c + S + l;
        concat = "" + i + z + S + l + S + s + "S" + f;
        concat = "" + b + d + d + l + i + z + i + l;
        concat = "" + S + f + c + b + c + i + d + l;
        concat = "" + f + f + S + i + l + b + b + d;
        concat = "" + "S" + i + "S" + c + z + f + c + "S";
        concat = "" + i + s + l + l + d + c + f + i;
        concat = "" + c + c + "S" + z + S + f + i + f;
        concat = "" + c + "S" + b + "S" + l + l + z + c;
        concat = "" + d + S + s + c + s + S + c + s;
        concat = "" + "S" + S + l + S + c + d + z + s;
        concat = "" + b + s + c + f + l + S + s + b;
        concat = "" + b + "S" + "S" + f + c + "S" + c + i;
        concat = "" + l + f + S + i + s + S + l + S;
        concat = "" + f + S + i + d + l + l + l + i;
        concat = "" + S + i + d + i + b + d + d + c;
        concat = "" + l + S + "S" + b + d + z + z + i;
        concat = "" + s + l + f + "S" + z + f + f + f;
        concat = "" + l + l + i + f + b + s + c + f;
        concat = "" + s + i + c + S + "S" + c + c + s;
        concat = "" + i + b + f + S + c + b + c + c;
        concat = "" + i + b + s + z + l + f + s + "S";
        concat = "" + S + c + f + l + c + c + i + S;
        concat = "" + S + s + z + f + l + s + f + d;
        concat = "" + S + z + S + S + f + S + s + S;
        concat = "" + l + s + s + s + i + i + "S" + l;
        concat = "" + i + f + s + c + c + f + S + d;
        concat = "" + S + d + d + d + S + c + S + s;
        concat = "" + S + f + z + i + S + l + S + s;
        concat = "" + b + S + d + S + i + b + s + z;
        concat = "" + f + d + "S" + c + "S" + c + S + b;
        concat = "" + c + i + z + f + d + f + "S" + c;
        concat = "" + s + c + c + S + s + z + l + s;
        concat = "" + i + d + f + z + S + s + d + s;
        concat = "" + z + b + s + d + d + i + f + i;
        concat = "" + c + i + b + l + S + d + f + f;
        concat = "" + f + d + S + l + "S" + f + s + l;
        concat = "" + s + l + l + s + z + s + "S" + z;
        concat = "" + S + z + d + l + l + i + s + b;
        concat = "" + z + "S" + z + i + S + "S" + b + S;
        concat = "" + f + S + s + z + "S" + b + "S" + S;
        concat = "" + i + s + b + l + b + i + d + l;
        concat = "" + i + "S" + s + b + l + i + f + d;
        concat = "" + c + f + S + S + z + s + "S" + c;
        concat = "" + s + c + z + l + z + S + c + z;
        concat = "" + d + "S" + i + b + d + S + f + c;
        concat = "" + s + z + d + c + c + c + l + S;
        concat = "" + z + S + z + s + l + d + l + b;
        concat = "" + S + b + i + s + "S" + l + i + "S";
        concat = "" + "S" + z + "S" + i + S + i + l + "S";
        concat = "" + z + c + d + l + s + l + l + s;
        concat = "" + b + i + s + S + z + l + f + d;
        concat = "" + s + d + d + f + l + i + i + S;
        concat = "" + "S" + i + d + l + b + S + d + "S";
        concat = "" + l + s + b + z + s + l + s + c;
        concat = "" + z + l + b + S + d + s + b + d;
        concat = "" + "S" + S + S + f + l + i + "S" + s;
        concat = "" + i + i + i + l + d + c + z + i;
        concat = "" + d + z + b + b + l + b + z + i;
        concat = "" + d + S + S + c + s + s + f + c;
        concat = "" + b + z + f + i + d + l + l + c;
        concat = "" + i + S + d + "S" + c + l + s + c;
        concat = "" + l + f + d + f + S + c + i + f;
        concat = "" + i + f + c + S + d + z + f + z;
        concat = "" + l + z + b + S + "S" + S + c + "S";
        concat = "" + S + z + d + c + f + z + l + b;
        concat = "" + l + b + f + f + c + f + S + z;
        concat = "" + z + "S" + s + d + s + z + "S" + f;
        concat = "" + d + "S" + c + z + S + d + i + c;
        concat = "" + "S" + z + c + S + b + f + s + i;
        concat = "" + z + "S" + d + s + f + f + d + d;
        concat = "" + b + d + s + i + d + d + "S" + z;
        concat = "" + c + z + l + c + l + d + z + s;
        concat = "" + i + f + b + b + c + l + c + c;
        concat = "" + S + s + s + l + l + "S" + "S" + f;
        concat = "" + d + f + f + d + b + b + d + b;
        concat = "" + S + c + "S" + S + s + d + s + s;
        concat = "" + z + b + b + b + l + c + l + S;
        concat = "" + z + l + z + f + S + s + d + S;
        concat = "" + z + i + s + d + l + z + c + S;
        concat = "" + d + f + "S" + z + b + i + S + c;
        concat = "" + c + c + i + d + f + d + f + f;
        concat = "" + b + d + d + S + z + f + i + b;
        concat = "" + b + s + l + s + s + c + l + l;
        concat = "" + S + S + S + i + b + c + b + S;
        concat = "" + s + i + l + S + f + z + b + b;
        concat = "" + s + f + i + l + l + s + c + S;
        concat = "" + s + "S" + b + z + s + S + i + i;
        concat = "" + l + s + d + d + b + i + s + c;
        concat = "" + S + s + f + "S" + f + c + d + l;
        concat = "" + S + S + z + f + S + s + i + b;
        concat = "" + s + d + l + z + c + S + d + f;
        concat = "" + i + f + S + f + d + z + b + "S";
        concat = "" + l + d + f + d + d + b + i + z;
        concat = "" + s + f + S + l + "S" + d + i + S;
        concat = "" + S + S + "S" + S + c + "S" + f + s;
        concat = "" + z + z + c + "S" + "S" + "S" + "S" + s;
        concat = "" + l + c + z + c + f + d + i + "S";
        concat = "" + "S" + l + z + "S" + c + c + s + S;
        concat = "" + d + s + d + s + l + b + S + s;
        concat = "" + l + "S" + c + f + "S" + f + d + z;
        concat = "" + "S" + S + c + z + d + d + b + l;
        concat = "" + d + c + s + i + "S" + S + i + d;
        concat = "" + d + b + b + b + z + l + s + s;
        concat = "" + f + d + b + s + l + b + S + d;
        concat = "" + d + c + d + z + c + i + l + b;
        concat = "" + z + S + d + b + S + f + S + c;
        concat = "" + z + S + c + s + S + "S" + s + "S";
        concat = "" + z + b + d + i + S + b + l + s;
        concat = "" + i + c + s + i + f + d + "S" + b;
        concat = "" + s + s + b + l + S + b + z + f;
        concat = "" + S + i + f + d + z + z + s + s;
        concat = "" + z + z + d + l + b + c + S + f;
        concat = "" + d + l + f + l + b + l + c + i;
        concat = "" + "S" + f + i + c + l + c + b + z;
        concat = "" + l + l + "S" + S + c + l + z + i;
        concat = "" + s + f + s + z + "S" + z + c + S;
        concat = "" + d + z + i + z + b + "S" + b + b;
        concat = "" + "S" + "S" + c + i + b + c + f + l;
        concat = "" + d + z + i + S + s + z + s + c;
        concat = "" + l + i + d + c + l + s + f + b;
        concat = "" + i + s + l + l + z + c + S + b;
        concat = "" + S + c + l + S + d + b + "S" + b;
        concat = "" + b + s + "S" + f + b + S + i + s;
        concat = "" + d + z + "S" + c + s + b + z + s;
        concat = "" + b + c + s + "S" + S + b + s + z;
        concat = "" + b + f + z + c + b + d + S + c;
        concat = "" + f + "S" + s + c + l + f + l + c;
        concat = "" + b + b + z + "S" + b + l + f + s;
        concat = "" + i + f + c + f + c + f + l + i;
        concat = "" + z + S + "S" + c + i + d + z + f;
        concat = "" + f + c + l + b + f + b + "S" + "S";
        concat = "" + f + i + c + S + "S" + b + f + f;
        concat = "" + b + z + d + z + c + c + "S" + s;
        concat = "" + s + S + b + d + f + d + c + f;
        concat = "" + z + f + s + i + d + f + b + z;
        concat = "" + b + f + z + l + d + c + d + z;
        concat = "" + i + i + b + s + f + s + S + i;
        concat = "" + s + f + c + d + z + l + l + S;
        concat = "" + i + "S" + S + s + l + f + z + f;
        concat = "" + "S" + i + l + d + i + S + b + l;
        concat = "" + S + l + f + d + z + i + b + S;
        concat = "" + f + i + c + S + d + f + "S" + b;
        concat = "" + s + l + z + f + s + c + d + l;
        concat = "" + f + S + s + i + f + s + b + d;
        concat = "" + f + c + s + i + l + f + d + d;
        concat = "" + l + l + c + c + b + d + "S" + l;
        concat = "" + c + i + f + f + s + i + "S" + i;
        concat = "" + l + s + c + d + d + b + d + f;
        concat = "" + "S" + i + f + s + f + c + "S" + "S";
        concat = "" + i + "S" + f + f + s + c + c + z;
        concat = "" + s + b + c + i + i + b + "S" + c;
        concat = "" + "S" + b + f + l + s + z + z + f;
        concat = "" + s + c + i + b + z + b + i + d;
        concat = "" + l + S + c + l + z + s + b + c;
        concat = "" + "S" + b + s + l + f + b + z + z;
        concat = "" + z + c + f + S + f + l + i + i;
        concat = "" + S + f + b + b + l + f + b + c;
        concat = "" + b + b + "S" + S + d + i + S + s;
        concat = "" + b + "S" + b + b + l + d + f + d;
        concat = "" + f + b + l + l + c + b + z + b;
        concat = "" + z + S + S + s + i + s + l + z;
        concat = "" + S + l + c + d + z + "S" + d + c;
        concat = "" + S + i + l + l + "S" + i + z + l;
        concat = "" + d + l + l + i + s + s + c + i;
        concat = "" + d + S + z + i + b + i + l + b;
        concat = "" + c + b + d + z + l + c + z + s;
        concat = "" + z + i + c + S + d + d + b + f;
        concat = "" + "S" + s + l + d + i + i + s + c;
        concat = "" + c + b + i + d + l + z + s + i;
        concat = "" + s + b + d + s + i + f + s + c;
        concat = "" + "S" + f + d + z + z + i + f + b;
        concat = "" + b + c + "S" + d + d + f + f + b;
        concat = "" + f + l + l + b + d + i + z + c;
        concat = "" + b + z + z + z + f + i + "S" + c;
        concat = "" + c + i + i + d + d + b + f + d;
        concat = "" + "S" + d + c + s + z + z + c + S;
        concat = "" + f + "S" + c + c + c + z + d + z;
        concat = "" + s + z + f + i + b + d + b + "S";
        concat = "" + l + i + d + "S" + z + l + s + "S";
        concat = "" + i + z + s + z + s + z + S + l;
        concat = "" + c + b + b + "S" + c + b + s + s;
        concat = "" + c + l + s + d + b + "S" + f + "S";
        concat = "" + S + c + c + d + l + "S" + b + z;
        concat = "" + S + S + s + f + d + s + b + z;
        concat = "" + z + "S" + l + c + "S" + c + b + l;
        concat = "" + l + b + b + s + S + S + S + z;
        concat = "" + b + s + d + i + l + z + c + b;
        concat = "" + f + s + "S" + d + d + s + "S" + f;
        concat = "" + f + f + "S" + s + z + d + l + z;
        concat = "" + "S" + z + b + f + d + d + d + S;
        concat = "" + i + l + z + d + f + s + s + "S";
        concat = "" + f + c + l + S + b + b + z + z;
        concat = "" + f + f + f + S + d + c + b + S;
        concat = "" + "S" + c + S + "S" + b + i + z + z;
        concat = "" + s + "S" + b + c + s + d + b + b;
        concat = "" + S + c + "S" + S + "S" + c + "S" + S;
        concat = "" + d + z + b + l + b + "S" + i + c;
        concat = "" + f + "S" + l + i + l + S + d + S;
        concat = "" + d + c + s + S + c + f + "S" + d;
        concat = "" + z + d + s + z + i + b + d + "S";
        concat = "" + "S" + f + c + "S" + f + s + c + "S";
        concat = "" + i + i + c + b + d + l + i + f;
        concat = "" + "S" + "S" + z + z + b + c + "S" + i;
        concat = "" + l + s + i + b + f + b + l + b;
        concat = "" + S + d + z + i + "S" + c + i + l;
        concat = "" + l + S + d + c + s + l + i + z;
        concat = "" + b + S + l + z + i + f + z + i;
        concat = "" + i + S + S + d + S + d + f + b;
        concat = "" + d + z + "S" + "S" + l + c + d + c;
        concat = "" + i + s + S + f + l + s + z + c;
        concat = "" + S + S + z + S + s + c + d + i;
        concat = "" + z + d + l + f + d + i + f + S;
        concat = "" + S + z + s + b + s + S + d + b;
        concat = "" + b + s + b + l + S + S + c + b;
        concat = "" + i + c + b + "S" + i + s + d + b;
        concat = "" + f + l + i + i + S + z + z + d;
        concat = "" + S + "S" + c + b + b + z + S + i;
        concat = "" + S + l + l + S + z + c + c + b;
        concat = "" + i + b + b + i + b + b + l + l;
        concat = "" + f + c + z + c + z + s + S + i;
        concat = "" + c + c + l + b + c + s + d + d;
        concat = "" + l + z + "S" + d + s + c + i + d;
        concat = "" + f + b + l + d + b + z + s + c;
        concat = "" + i + d + l + f + c + z + "S" + i;
        concat = "" + s + s + "S" + b + b + c + f + z;
        concat = "" + z + d + f + d + c + f + i + S;
        concat = "" + b + "S" + f + l + S + i + z + b;
        concat = "" + i + z + "S" + s + S + S + c + d;
        concat = "" + i + l + d + "S" + f + f + d + f;
        concat = "" + i + z + s + d + l + f + i + "S";
        concat = "" + z + S + z + s + l + S + f + "S";
        concat = "" + "S" + i + c + f + i + l + S + f;
        concat = "" + s + f + b + c + b + b + c + S;
        concat = "" + S + d + "S" + s + l + i + c + d;
        concat = "" + f + s + "S" + S + d + l + z + z;
        concat = "" + f + S + f + "S" + S + S + d + i;
        concat = "" + s + b + z + i + "S" + S + d + i;
        concat = "" + s + d + c + l + z + c + d + i;
        concat = "" + c + z + l + "S" + s + "S" + s + b;
        concat = "" + i + z + c + s + S + s + s + "S";
        concat = "" + c + S + S + "S" + d + f + d + f;
        concat = "" + d + s + l + f + d + s + "S" + c;
        concat = "" + z + f + d + "S" + c + f + "S" + S;
        concat = "" + c + z + i + l + l + z + S + z;
        concat = "" + "S" + s + S + d + d + z + b + d;
        concat = "" + i + "S" + i + c + d + z + s + "S";
        concat = "" + l + f + z + d + s + f + S + S;
        concat = "" + l + z + d + i + i + l + b + l;
        concat = "" + i + b + S + z + d + z + i + "S";
        concat = "" + S + S + b + "S" + b + S + i + i;
        concat = "" + l + "S" + c + s + l + S + S + b;
        concat = "" + s + l + c + f + "S" + b + S + b;
        concat = "" + s + f + b + S + s + "S" + "S" + d;
        concat = "" + s + s + c + c + l + d + "S" + f;
        concat = "" + b + b + "S" + S + z + s + "S" + i;
        concat = "" + b + d + "S" + f + f + l + c + i;
        concat = "" + i + "S" + z + d + b + S + i + f;
        concat = "" + d + l + z + c + S + "S" + S + S;
        concat = "" + d + c + d + S + "S" + f + f + b;
        concat = "" + i + f + s + b + s + z + s + f;
        concat = "" + "S" + d + c + b + S + f + S + S;
        concat = "" + S + z + i + b + i + c + z + S;
        concat = "" + z + i + "S" + S + S + i + z + i;
        concat = "" + i + f + "S" + "S" + s + "S" + "S" + b;
        concat = "" + "S" + S + c + S + i + f + b + "S";
        concat = "" + i + d + f + z + s + z + i + s;
        concat = "" + s + f + z + l + S + b + "S" + l;
        concat = "" + c + "S" + b + S + z + S + l + s;
        concat = "" + c + b + c + d + c + l + b + "S";
        concat = "" + i + i + b + "S" + d + s + S + S;
        concat = "" + l + b + c + c + b + f + z + s;
        concat = "" + "S" + S + s + z + z + i + l + c;
        concat = "" + S + f + c + i + b + "S" + b + s;
        concat = "" + c + b + "S" + f + s + s + z + l;
        concat = "" + l + z + c + "S" + l + c + c + c;
        concat = "" + c + z + s + s + c + z + s + b;
        concat = "" + i + "S" + d + s + f + c + b + s;
        concat = "" + d + l + "S" + f + l + d + d + "S";
        concat = "" + b + s + d + s + l + c + l + f;
        concat = "" + S + i + c + f + i + "S" + i + s;
        concat = "" + "S" + "S" + b + i + f + b + z + s;
        concat = "" + S + c + "S" + f + "S" + i + s + c;
        concat = "" + c + b + b + s + S + S + "S" + b;
        concat = "" + s + S + i + z + s + d + i + s;
        concat = "" + "S" + "S" + "S" + z + f + c + i + i;
        concat = "" + z + "S" + s + l + S + i + f + f;
        concat = "" + z + b + c + l + i + b + l + S;
        concat = "" + s + c + f + s + l + S + d + d;
        concat = "" + z + s + b + b + z + "S" + s + S;
        concat = "" + "S" + l + f + l + l + b + f + i;
        concat = "" + i + z + i + d + S + s + l + d;
        concat = "" + f + i + b + "S" + "S" + c + b + s;
        concat = "" + "S" + S + i + c + "S" + l + z + S;
        concat = "" + d + l + d + b + c + l + d + s;
        concat = "" + f + s + c + i + l + i + c + f;
        concat = "" + l + "S" + l + d + s + "S" + i + d;
        concat = "" + f + z + "S" + "S" + b + z + "S" + S;
        concat = "" + l + z + l + "S" + z + c + z + c;
        concat = "" + l + "S" + S + z + S + z + b + "S";
        concat = "" + s + s + f + s + i + c + l + l;
        concat = "" + b + l + S + z + l + l + c + i;
        concat = "" + d + S + b + S + "S" + z + "S" + f;
        concat = "" + s + S + z + s + c + S + l + s;
        concat = "" + "S" + d + S + l + f + b + z + "S";
        concat = "" + "S" + d + c + l + "S" + b + f + S;
        concat = "" + "S" + S + s + z + i + S + l + f;
        concat = "" + s + i + f + f + i + l + d + f;
        concat = "" + "S" + s + "S" + i + s + c + "S" + d;
        concat = "" + s + f + f + i + f + l + l + c;
        concat = "" + i + f + "S" + d + f + d + l + z;
        concat = "" + "S" + S + i + d + c + b + i + l;
        concat = "" + f + l + "S" + l + s + z + b + b;
        concat = "" + z + z + f + b + b + b + l + i;
        concat = "" + s + "S" + S + c + "S" + "S" + b + b;
        concat = "" + S + l + s + c + c + i + S + f;
        concat = "" + b + z + b + f + z + S + i + b;
        concat = "" + i + d + f + l + s + "S" + s + b;
        concat = "" + d + d + d + z + i + f + i + i;
        concat = "" + S + d + z + s + "S" + f + l + S;
        concat = "" + "S" + i + s + f + S + l + s + c;
        concat = "" + i + z + S + "S" + l + z + d + z;
        concat = "" + b + f + b + b + S + "S" + l + s;
        concat = "" + "S" + l + s + "S" + f + "S" + l + z;
        concat = "" + c + s + d + z + s + "S" + z + i;
        concat = "" + s + z + S + z + "S" + i + z + b;
        concat = "" + c + i + S + z + d + S + i + d;
        concat = "" + s + f + l + i + S + f + l + s;
        concat = "" + b + i + b + d + f + f + "S" + "S";
        concat = "" + "S" + d + l + i + s + S + l + c;
        concat = "" + i + i + b + i + z + c + l + S;
        concat = "" + z + S + s + d + b + s + z + s;
        concat = "" + b + c + S + "S" + "S" + b + i + l;
        concat = "" + z + l + "S" + l + l + f + c + s;
        concat = "" + s + "S" + b + i + b + s + z + f;
        concat = "" + i + b + S + s + f + "S" + c + c;
        concat = "" + z + "S" + c + c + d + "S" + z + d;
        concat = "" + b + s + s + S + b + i + s + s;
        concat = "" + s + "S" + c + b + S + c + s + S;
        concat = "" + i + d + l + s + f + "S" + S + i;
        concat = "" + S + f + b + i + z + c + f + b;
        concat = "" + i + S + d + d + c + b + "S" + c;
        concat = "" + d + z + i + z + c + s + d + s;
        concat = "" + b + z + c + i + f + i + c + "S";
        concat = "" + f + "S" + S + d + b + f + d + b;
        concat = "" + "S" + c + l + S + z + c + z + l;
        concat = "" + S + c + d + b + d + s + "S" + f;
        concat = "" + z + b + "S" + d + c + i + "S" + d;
        concat = "" + b + "S" + c + S + z + s + i + i;
        concat = "" + s + z + i + c + i + i + i + b;
        concat = "" + c + z + z + d + b + s + b + s;
        concat = "" + "S" + z + l + i + S + s + l + b;
        concat = "" + z + b + s + f + "S" + c + f + b;
        concat = "" + "S" + b + s + S + "S" + d + i + "S";
        concat = "" + c + c + s + b + S + l + i + f;
        concat = "" + "S" + i + d + d + l + "S" + "S" + b;
        concat = "" + S + l + b + c + S + c + S + S;
        concat = "" + l + b + "S" + l + l + z + s + i;
        concat = "" + "S" + s + f + b + b + d + b + i;
        concat = "" + S + b + b + b + l + c + l + b;
        concat = "" + l + c + z + s + c + s + b + s;
        concat = "" + l + c + S + s + "S" + b + f + d;
        concat = "" + s + d + d + i + b + i + "S" + b;
        concat = "" + d + l + z + l + d + l + l + b;
        concat = "" + c + i + c + "S" + f + "S" + "S" + b;
        concat = "" + "S" + d + z + S + z + d + i + b;
        concat = "" + c + z + b + c + d + c + c + z;
        concat = "" + b + s + S + d + z + f + l + z;
        concat = "" + d + z + f + "S" + z + d + f + f;
        concat = "" + s + z + d + c + s + s + "S" + i;
        concat = "" + i + c + z + S + b + b + z + z;
        concat = "" + l + "S" + f + s + z + i + d + b;
        concat = "" + s + S + l + c + S + f + z + i;
        concat = "" + f + l + s + "S" + l + s + d + S;
        concat = "" + l + c + b + f + f + s + S + c;
        concat = "" + s + i + i + S + c + s + s + s;
        concat = "" + f + c + b + c + "S" + c + i + s;
        concat = "" + S + S + d + f + "S" + i + i + c;
        concat = "" + d + f + s + z + S + b + s + s;
        concat = "" + z + f + f + l + l + i + z + z;
        concat = "" + i + c + f + b + f + d + "S" + s;
        concat = "" + "S" + f + z + S + z + f + l + c;
        concat = "" + S + b + s + "S" + "S" + l + l + f;
        concat = "" + i + l + S + c + l + c + "S" + s;
        concat = "" + c + z + S + f + l + d + c + b;
        concat = "" + l + b + s + s + l + S + f + d;
        concat = "" + f + c + s + "S" + "S" + d + b + b;
        concat = "" + "S" + c + "S" + S + f + "S" + z + b;
        concat = "" + l + i + l + "S" + s + f + i + c;
        concat = "" + f + s + "S" + S + f + d + l + s;
        concat = "" + i + c + b + i + b + i + i + b;
        concat = "" + s + s + S + d + z + d + d + l;
        concat = "" + z + s + S + s + c + "S" + f + i;
        concat = "" + S + l + "S" + i + f + f + d + b;
        concat = "" + d + c + d + f + f + f + S + "S";
        concat = "" + c + f + S + f + "S" + i + z + i;
        concat = "" + s + b + s + b + b + i + S + z;
        concat = "" + f + b + i + S + b + i + z + l;
        concat = "" + c + s + b + S + s + s + z + c;
        concat = "" + S + b + b + l + d + z + i + i;
        concat = "" + l + S + c + d + S + b + l + i;
        concat = "" + f + f + z + "S" + z + f + S + d;
        concat = "" + c + l + b + "S" + s + d + "S" + c;
        concat = "" + s + "S" + l + s + S + l + c + f;
        concat = "" + s + S + "S" + b + i + s + i + i;
        concat = "" + s + l + z + f + b + l + i + s;
        concat = "" + S + c + i + b + c + z + i + "S";
        concat = "" + z + z + d + i + l + s + "S" + S;
        concat = "" + f + d + i + "S" + "S" + l + d + z;
        concat = "" + c + z + s + "S" + b + c + l + c;
        concat = "" + b + d + f + b + "S" + s + d + "S";
        concat = "" + S + d + S + s + S + S + c + f;
        concat = "" + z + b + S + "S" + l + z + s + z;
        concat = "" + c + f + S + "S" + f + f + f + c;
        concat = "" + l + "S" + d + l + l + f + b + c;
        concat = "" + z + S + d + i + S + s + S + "S";
        concat = "" + S + d + s + f + z + z + l + d;
        concat = "" + z + c + c + z + s + s + z + i;
        concat = "" + c + c + i + b + l + "S" + i + d;
        concat = "" + i + l + "S" + b + "S" + l + z + b;
        concat = "" + c + f + "S" + c + f + d + S + "S";
        concat = "" + i + i + "S" + c + f + z + i + "S";
        concat = "" + f + "S" + l + f + c + s + b + i;
        concat = "" + f + "S" + d + b + c + "S" + i + b;
        concat = "" + S + l + l + i + b + b + z + b;
        concat = "" + f + "S" + l + S + c + z + c + f;
        concat = "" + l + S + l + b + "S" + s + f + d;
        concat = "" + c + S + z + c + s + s + s + f;
        concat = "" + d + b + d + b + c + c + d + i;
        concat = "" + "S" + "S" + b + f + f + c + i + b;
        concat = "" + S + S + c + s + i + z + f + b;
        concat = "" + l + c + c + S + "S" + b + l + "S";
        concat = "" + f + d + S + f + b + f + "S" + f;
        concat = "" + z + z + S + s + S + b + "S" + c;
        concat = "" + b + s + c + f + z + s + z + S;
        concat = "" + c + c + d + "S" + i + z + l + z;
        concat = "" + b + d + z + S + l + S + b + S;
        concat = "" + c + S + "S" + b + "S" + i + i + c;
        concat = "" + "S" + i + "S" + S + "S" + i + l + f;
        concat = "" + s + l + c + l + f + f + l + S;
        concat = "" + l + "S" + "S" + l + c + c + d + d;
        concat = "" + l + d + z + f + d + b + c + "S";
        concat = "" + z + S + z + b + z + z + S + f;
        concat = "" + d + z + c + b + i + f + z + d;
        concat = "" + d + f + l + c + d + c + S + z;
        concat = "" + "S" + b + d + c + l + d + d + b;
        concat = "" + "S" + S + f + d + s + S + c + f;
        concat = "" + f + S + b + z + i + i + s + i;
        concat = "" + f + d + "S" + l + b + f + "S" + i;
        concat = "" + i + i + i + b + l + d + s + f;
        concat = "" + b + l + f + z + l + b + b + l;
        concat = "" + i + l + c + S + S + f + b + f;
        concat = "" + l + b + f + c + f + s + z + f;
        concat = "" + d + S + f + i + "S" + f + f + z;
        concat = "" + d + i + "S" + S + b + "S" + c + z;
        concat = "" + "S" + c + "S" + l + d + b + f + s;
        concat = "" + c + z + z + d + z + b + "S" + z;
        concat = "" + s + s + S + z + d + f + c + f;
        concat = "" + S + S + s + l + c + "S" + f + S;
        concat = "" + d + l + z + d + d + l + i + f;
        concat = "" + S + s + "S" + z + S + l + f + f;
        concat = "" + b + s + l + "S" + "S" + c + i + f;
        concat = "" + i + b + i + "S" + z + "S" + l + "S";
        concat = "" + "S" + s + l + z + i + d + z + "S";
        concat = "" + z + s + z + b + "S" + i + c + d;
        concat = "" + b + i + i + d + S + d + l + b;
        concat = "" + S + z + d + i + "S" + s + d + f;
        concat = "" + l + d + z + z + S + f + c + s;
        concat = "" + z + d + f + s + d + f + i + s;
        concat = "" + s + "S" + c + c + z + S + "S" + i;
        concat = "" + "S" + i + f + i + b + "S" + d + z;
        concat = "" + i + s + d + i + d + d + b + f;
        concat = "" + s + "S" + "S" + b + l + d + c + "S";
        concat = "" + i + "S" + f + l + s + d + d + c;
        concat = "" + d + "S" + s + i + i + "S" + b + S;
        concat = "" + l + S + c + i + d + b + i + i;
        concat = "" + s + z + s + s + c + "S" + i + f;
        concat = "" + b + f + b + "S" + s + f + S + i;
        concat = "" + b + b + i + f + c + "S" + s + z;
        concat = "" + i + "S" + f + s + d + f + "S" + z;
        concat = "" + i + z + f + S + i + l + z + z;
        concat = "" + l + s + i + i + l + z + d + d;
        concat = "" + s + S + d + s + f + d + l + "S";
        concat = "" + i + z + "S" + b + "S" + S + "S" + S;
        concat = "" + i + i + d + s + l + b + f + b;
        concat = "" + c + b + f + i + s + "S" + l + d;
        concat = "" + f + "S" + b + s + "S" + z + c + l;
        concat = "" + S + f + c + f + c + b + b + z;
        concat = "" + s + d + i + S + f + b + z + f;
        concat = "" + "S" + b + l + d + i + b + "S" + f;
        concat = "" + c + f + l + d + c + S + i + s;
        concat = "" + z + s + s + "S" + i + i + c + S;
        concat = "" + l + l + z + c + "S" + s + S + f;
        concat = "" + c + l + l + S + z + b + f + d;
        concat = "" + b + "S" + l + z + S + i + i + s;
        concat = "" + d + b + l + s + S + b + S + S;
        concat = "" + z + b + l + "S" + "S" + z + d + c;
        concat = "" + l + S + d + "S" + c + S + l + b;
        concat = "" + S + b + i + d + s + s + f + z;
        concat = "" + l + "S" + b + c + z + b + "S" + d;
        concat = "" + i + d + "S" + S + S + l + z + S;
        concat = "" + b + S + l + "S" + S + z + S + S;
        concat = "" + "S" + c + i + l + s + l + S + s;
        concat = "" + s + f + c + c + S + i + z + b;
        concat = "" + S + i + f + c + d + f + l + "S";
        concat = "" + s + z + d + S + b + d + "S" + "S";
        concat = "" + b + c + "S" + s + l + l + l + s;
        concat = "" + b + c + d + i + S + b + b + S;
        concat = "" + S + S + l + "S" + f + l + z + d;
        concat = "" + z + S + s + b + z + d + d + c;
        concat = "" + i + i + s + f + d + S + "S" + z;
        concat = "" + c + s + f + s + z + i + l + "S";
        concat = "" + z + i + "S" + s + d + l + c + i;
        concat = "" + s + f + "S" + "S" + i + l + s + S;
        concat = "" + "S" + f + s + d + f + s + f + z;
        concat = "" + f + i + i + l + "S" + S + f + l;
        concat = "" + b + S + i + z + s + f + "S" + l;
        concat = "" + z + s + l + s + l + f + i + S;
        concat = "" + c + i + c + f + f + z + d + s;
        concat = "" + S + f + f + S + z + S + z + s;
        concat = "" + c + S + S + f + "S" + z + "S" + S;
        concat = "" + S + d + S + s + s + f + l + s;
        concat = "" + f + S + c + l + z + d + d + b;
        concat = "" + f + s + d + z + l + i + f + b;
        concat = "" + b + S + d + s + c + d + b + s;
        concat = "" + b + i + S + "S" + "S" + S + f + "S";
        concat = "" + S + f + s + d + z + c + b + S;
        concat = "" + b + S + d + b + S + b + c + i;
        concat = "" + f + "S" + d + b + z + S + s + l;
        concat = "" + s + z + s + S + S + f + b + l;
        concat = "" + b + S + l + d + d + S + z + i;
        concat = "" + b + s + z + i + S + s + S + "S";
        concat = "" + s + z + i + S + i + f + c + "S";
        concat = "" + "S" + S + f + b + c + i + c + "S";
        concat = "" + "S" + d + b + d + S + i + c + z;
        concat = "" + z + "S" + c + f + z + d + S + c;
        concat = "" + f + b + c + S + z + c + f + i;
        concat = "" + d + c + "S" + i + i + d + S + S;
        concat = "" + d + f + c + S + i + c + s + "S";
        concat = "" + S + f + z + f + "S" + d + f + l;
        concat = "" + s + c + f + z + "S" + b + i + d;
        concat = "" + "S" + d + b + S + c + b + S + z;
        concat = "" + l + c + i + d + c + s + d + s;
        concat = "" + s + z + i + S + s + l + s + c;
        concat = "" + S + z + S + s + s + z + S + b;
        concat = "" + d + "S" + s + S + z + "S" + i + s;
        concat = "" + i + d + S + b + "S" + z + l + d;
        concat = "" + s + "S" + z + d + "S" + c + f + s;
        concat = "" + S + z + b + f + d + c + c + z;
        concat = "" + d + z + S + "S" + f + d + i + "S";
        concat = "" + b + c + f + f + l + f + b + s;
        concat = "" + "S" + i + c + f + f + i + "S" + i;
        concat = "" + s + S + i + c + f + i + c + d;
        concat = "" + l + d + z + d + "S" + z + "S" + c;
        concat = "" + i + s + c + l + S + c + c + "S";
        concat = "" + "S" + f + S + c + "S" + s + c + c;
        concat = "" + "S" + "S" + "S" + "S" + b + z + l + z;
        concat = "" + z + c + d + S + S + f + f + i;
        concat = "" + i + i + S + s + b + "S" + "S" + "S";
        concat = "" + l + b + d + b + d + i + "S" + c;
        concat = "" + s + z + S + s + f + z + f + c;
        concat = "" + b + f + "S" + b + c + b + d + "S";
        concat = "" + c + c + "S" + s + l + b + z + l;
        concat = "" + l + b + s + z + S + c + b + c;
        concat = "" + l + f + S + b + "S" + s + c + "S";
        concat = "" + "S" + "S" + c + c + l + S + z + d;
        concat = "" + s + z + S + f + i + c + l + s;
        concat = "" + l + c + d + z + S + S + l + b;
        concat = "" + s + f + d + S + s + f + l + b;
        concat = "" + s + f + c + i + f + c + d + z;
        concat = "" + d + z + s + l + d + "S" + i + S;
        concat = "" + s + i + l + s + d + l + s + c;
        concat = "" + l + b + z + s + d + c + S + "S";
        concat = "" + b + c + z + z + l + l + i + d;
        concat = "" + f + f + f + b + l + l + d + z;
        concat = "" + s + d + z + z + f + s + f + i;
        concat = "" + S + c + l + s + s + b + i + i;
        concat = "" + z + f + c + l + c + b + b + b;
        concat = "" + S + z + d + "S" + b + i + f + l;
        concat = "" + s + l + f + S + f + z + "S" + "S";
        concat = "" + b + c + s + S + i + s + l + f;
        concat = "" + S + "S" + d + b + f + z + s + d;
        concat = "" + "S" + l + f + "S" + l + f + b + S;
        concat = "" + l + l + S + s + s + z + S + b;
        concat = "" + c + i + d + z + l + c + c + b;
        concat = "" + l + b + b + s + s + S + z + b;
        concat = "" + f + l + d + i + s + c + i + z;
        concat = "" + "S" + d + "S" + S + f + i + S + z;
        concat = "" + b + b + c + s + f + f + f + d;
        concat = "" + f + "S" + d + f + z + "S" + "S" + "S";
        concat = "" + z + c + "S" + S + f + b + l + d;
        concat = "" + "S" + d + l + S + l + d + i + l;
        concat = "" + i + "S" + d + i + c + i + S + f;
        concat = "" + c + c + b + S + "S" + d + c + f;
        concat = "" + c + d + f + l + c + c + s + f;
        concat = "" + S + i + "S" + i + c + S + S + "S";
        concat = "" + f + "S" + "S" + b + z + s + S + d;
        concat = "" + c + l + l + "S" + b + b + c + c;
        concat = "" + b + i + "S" + c + s + S + b + l;
        concat = "" + z + i + z + S + S + s + b + c;
        concat = "" + l + l + s + i + i + z + l + "S";
        concat = "" + d + b + z + b + b + c + s + l;
        concat = "" + z + S + s + f + s + d + S + "S";
        concat = "" + d + "S" + s + b + f + "S" + S + f;
        concat = "" + b + S + z + z + z + i + f + b;
        concat = "" + b + S + S + f + "S" + c + "S" + c;
        concat = "" + s + l + d + "S" + S + s + "S" + z;
        concat = "" + i + d + S + b + s + z + S + l;
        concat = "" + b + i + "S" + l + l + c + d + f;
        concat = "" + f + "S" + b + b + c + d + f + "S";
        concat = "" + f + f + l + d + z + f + b + z;
        concat = "" + b + d + b + b + s + z + z + s;
        concat = "" + "S" + "S" + S + i + z + i + b + b;
        concat = "" + s + c + c + d + i + z + i + b;
        concat = "" + i + i + d + S + l + b + z + "S";
        concat = "" + "S" + b + b + c + S + S + d + f;
        concat = "" + s + z + f + S + d + S + s + S;
        concat = "" + l + f + b + d + d + d + b + i;
        concat = "" + i + l + z + S + b + d + d + f;
        concat = "" + l + b + b + f + i + b + d + S;
        concat = "" + d + b + "S" + l + "S" + d + c + z;
        concat = "" + l + "S" + s + "S" + d + l + f + b;
        concat = "" + s + s + l + f + c + "S" + c + c;
        concat = "" + i + S + S + b + S + s + l + l;
        concat = "" + b + z + f + f + s + S + z + c;
        concat = "" + "S" + z + "S" + l + c + f + z + "S";
        concat = "" + "S" + S + f + l + l + z + d + S;
        concat = "" + d + i + s + b + l + f + "S" + S;
        concat = "" + l + "S" + c + c + l + "S" + S + z;
        concat = "" + s + f + i + S + l + s + S + S;
        concat = "" + d + "S" + b + l + d + "S" + S + d;
        concat = "" + i + i + c + c + d + S + d + c;
        concat = "" + s + b + l + i + c + l + s + c;
        concat = "" + l + i + f + d + z + b + f + c;
        concat = "" + d + d + c + S + S + c + z + l;
        concat = "" + l + d + s + d + "S" + i + "S" + s;
        concat = "" + i + d + d + i + S + f + "S" + i;
        concat = "" + S + f + f + b + d + s + c + c;
        concat = "" + d + "S" + S + d + "S" + s + "S" + s;
        concat = "" + l + z + l + d + S + S + f + c;
        concat = "" + c + i + l + f + l + f + S + f;
        concat = "" + l + S + z + d + z + z + i + c;
        concat = "" + c + "S" + c + c + i + z + b + i;
        concat = "" + i + "S" + l + "S" + l + z + b + s;
        concat = "" + f + d + f + s + d + s + "S" + i;
        concat = "" + s + s + i + f + i + i + i + S;
        concat = "" + l + S + "S" + f + S + z + c + b;
        concat = "" + s + z + f + z + "S" + i + i + i;
        concat = "" + b + s + S + c + i + s + i + l;
        concat = "" + l + "S" + z + "S" + c + f + i + b;
        concat = "" + f + c + l + d + d + b + f + b;
        concat = "" + s + i + f + c + d + s + b + l;
        concat = "" + "S" + d + c + f + b + b + S + f;
        concat = "" + l + i + S + "S" + s + c + f + s;
        concat = "" + l + b + f + b + d + b + z + c;
        concat = "" + c + i + i + z + i + S + i + "S";
        concat = "" + "S" + "S" + b + b + s + z + d + "S";
        concat = "" + i + s + s + b + i + c + d + c;
        concat = "" + l + d + l + i + d + "S" + S + i;
        concat = "" + l + s + f + z + i + z + c + d;
        concat = "" + c + s + S + s + d + l + l + c;
        concat = "" + c + "S" + s + b + i + s + s + S;
        concat = "" + b + s + i + f + "S" + "S" + d + "S";
        concat = "" + f + s + b + d + S + d + f + i;
        concat = "" + S + c + d + z + f + s + s + c;
        concat = "" + c + s + d + c + l + i + z + c;
        concat = "" + f + "S" + f + f + b + "S" + c + "S";
        concat = "" + z + "S" + s + f + i + c + c + d;
        concat = "" + d + f + c + "S" + l + f + b + S;
        concat = "" + z + z + d + "S" + i + c + S + b;
        concat = "" + b + d + d + z + b + S + z + b;
        concat = "" + S + d + d + i + i + c + f + b;
        concat = "" + l + i + d + "S" + c + S + "S" + S;
        concat = "" + s + z + l + b + z + s + s + i;
        concat = "" + z + s + S + f + z + b + d + s;
        concat = "" + z + s + S + d + S + z + i + d;
        concat = "" + c + f + i + i + z + l + b + "S";
        concat = "" + S + i + d + l + b + "S" + s + "S";
        concat = "" + b + i + l + f + S + "S" + d + c;
        concat = "" + s + l + i + d + f + b + f + S;
        concat = "" + b + S + c + i + z + s + s + S;
        concat = "" + s + l + c + S + d + d + s + s;
        concat = "" + d + d + S + s + d + l + f + S;
        concat = "" + S + c + b + i + f + b + S + c;
        concat = "" + c + z + b + z + c + l + "S" + l;
        concat = "" + d + d + l + b + i + b + S + c;
        concat = "" + d + i + s + d + f + "S" + l + S;
        concat = "" + z + l + b + s + S + s + s + d;
        concat = "" + f + c + "S" + "S" + d + z + f + b;
        concat = "" + b + d + i + f + s + i + b + b;
        concat = "" + d + c + c + i + "S" + s + S + c;
        concat = "" + f + s + z + z + s + "S" + s + "S";
        concat = "" + b + c + c + f + S + l + S + i;
        concat = "" + s + d + i + l + s + b + b + i;
        concat = "" + z + "S" + z + z + b + c + s + z;
        concat = "" + i + f + b + s + i + d + S + d;
        concat = "" + "S" + s + i + "S" + c + b + "S" + "S";
        concat = "" + f + b + S + c + i + b + S + f;
        concat = "" + "S" + S + l + s + l + d + "S" + s;
        concat = "" + f + b + i + "S" + i + z + c + "S";
        concat = "" + c + l + d + c + b + c + i + b;
        concat = "" + i + "S" + f + c + c + c + i + c;
        concat = "" + b + b + s + "S" + c + l + z + b;
        concat = "" + z + b + i + f + d + "S" + s + S;
        concat = "" + "S" + d + d + d + z + S + d + f;
        concat = "" + z + d + s + f + l + "S" + i + f;
        concat = "" + "S" + i + i + d + i + S + l + f;
        concat = "" + "S" + b + d + S + l + d + b + c;
        concat = "" + l + "S" + z + d + b + c + S + d;
        concat = "" + f + f + z + "S" + z + f + f + z;
        concat = "" + s + "S" + d + S + b + b + i + b;
        concat = "" + z + d + S + c + b + l + l + b;
        concat = "" + f + i + i + l + i + "S" + i + b;
        concat = "" + l + c + b + z + f + "S" + s + "S";
        concat = "" + s + z + "S" + d + f + f + "S" + d;
        concat = "" + c + i + z + l + S + d + i + d;
        concat = "" + f + l + "S" + z + "S" + "S" + i + "S";
        concat = "" + z + i + b + z + d + i + "S" + l;
        concat = "" + "S" + f + S + S + l + c + S + s;
        concat = "" + s + i + l + d + b + l + d + b;
        concat = "" + c + S + d + b + s + f + S + "S";
        concat = "" + "S" + s + S + l + b + s + f + c;
        concat = "" + c + S + z + b + z + l + c + s;
        concat = "" + c + z + c + b + d + b + c + z;
        concat = "" + c + b + z + S + d + S + "S" + c;
        concat = "" + s + d + f + "S" + S + "S" + i + d;
        concat = "" + c + l + "S" + f + "S" + b + b + "S";
        concat = "" + "S" + l + b + b + c + S + z + c;
        concat = "" + "S" + l + l + s + s + S + S + s;
        concat = "" + z + d + b + "S" + d + b + l + c;
        concat = "" + l + b + d + c + s + f + i + "S";
        concat = "" + d + s + i + i + l + s + d + s;
        concat = "" + "S" + b + "S" + s + d + i + S + b;
        concat = "" + "S" + s + S + "S" + f + S + "S" + d;
        concat = "" + "S" + f + b + l + d + f + S + l;
        concat = "" + z + S + l + l + b + c + z + "S";
        concat = "" + c + b + d + i + c + i + s + s;
        concat = "" + z + z + s + f + "S" + z + l + d;
        concat = "" + z + c + b + c + z + c + f + z;
        concat = "" + s + i + S + d + i + i + l + i;
        concat = "" + l + c + z + l + z + "S" + s + l;
        concat = "" + c + b + i + c + z + S + d + b;
        concat = "" + b + d + b + z + b + z + c + d;
        concat = "" + b + b + z + z + z + d + i + s;
        concat = "" + z + d + s + s + f + f + f + b;
        concat = "" + "S" + b + z + S + S + i + s + S;
        concat = "" + "S" + i + b + f + S + f + l + S;
        concat = "" + d + d + f + l + d + s + f + i;
        concat = "" + d + s + c + b + s + d + f + "S";
        concat = "" + d + "S" + z + z + s + c + "S" + i;
        concat = "" + s + "S" + f + "S" + z + s + b + f;
        concat = "" + s + i + l + "S" + z + l + S + l;
        concat = "" + i + f + S + s + c + c + f + c;
        concat = "" + l + b + "S" + i + S + l + l + i;
        concat = "" + z + i + d + s + "S" + z + "S" + "S";
        concat = "" + f + c + z + b + l + f + b + l;
        concat = "" + i + c + S + f + S + z + S + c;
        concat = "" + i + d + d + z + d + f + f + "S";
        concat = "" + c + s + l + c + s + "S" + f + l;
        concat = "" + c + i + z + f + "S" + s + d + b;
        concat = "" + S + i + S + z + S + z + f + d;
        concat = "" + l + "S" + s + l + "S" + b + b + s;
        concat = "" + f + f + f + z + i + b + "S" + "S";
        concat = "" + c + b + z + b + f + s + b + i;
        concat = "" + S + "S" + f + c + S + i + s + "S";
        concat = "" + z + z + z + b + l + i + l + z;
        concat = "" + f + f + "S" + c + l + f + f + b;
        concat = "" + "S" + "S" + S + l + S + "S" + z + i;
        concat = "" + b + c + z + i + d + b + S + l;
        concat = "" + l + z + i + s + s + c + "S" + l;
        concat = "" + i + b + "S" + s + c + l + s + z;
        concat = "" + s + s + i + S + b + z + f + c;
        concat = "" + b + "S" + "S" + i + d + i + b + b;
        concat = "" + i + f + d + z + d + "S" + S + l;
        concat = "" + c + "S" + l + d + c + s + d + i;
        concat = "" + i + "S" + s + S + z + d + d + b;
        concat = "" + l + S + b + z + s + "S" + i + s;
        concat = "" + l + c + b + d + s + s + z + f;
        concat = "" + d + c + i + "S" + c + l + i + d;
        concat = "" + b + i + i + z + b + l + s + "S";
        concat = "" + c + "S" + S + c + z + l + l + i;
        concat = "" + f + S + c + c + f + S + f + "S";
        concat = "" + i + z + f + f + l + i + b + d;
        concat = "" + z + f + z + "S" + s + S + d + l;
        concat = "" + s + d + s + z + i + c + z + f;
        concat = "" + d + l + z + f + b + z + f + "S";
        concat = "" + s + b + z + S + "S" + z + S + i;
        concat = "" + S + S + i + i + b + d + s + d;
        concat = "" + S + c + c + b + c + z + i + "S";
        concat = "" + f + i + c + c + s + c + s + l;
        concat = "" + d + s + d + l + d + s + d + b;
        concat = "" + f + z + c + s + b + l + "S" + l;
        concat = "" + l + d + f + b + d + S + "S" + c;
        concat = "" + i + i + b + f + c + c + s + "S";
        concat = "" + "S" + i + c + d + s + c + c + f;
        concat = "" + s + f + c + s + z + d + c + i;
        concat = "" + l + c + S + d + "S" + S + f + i;
        concat = "" + f + z + "S" + b + i + f + z + z;
        concat = "" + l + l + b + f + "S" + S + z + c;
        concat = "" + f + s + z + b + S + f + b + l;
        concat = "" + s + z + z + c + d + z + b + S;
        concat = "" + f + b + i + b + f + s + z + "S";
        concat = "" + S + "S" + i + "S" + c + s + "S" + S;
        concat = "" + b + "S" + d + c + i + b + "S" + c;
        concat = "" + s + i + f + b + i + S + s + c;
        concat = "" + z + S + z + l + b + d + l + "S";
        concat = "" + l + c + "S" + c + i + "S" + c + s;
        concat = "" + b + b + b + S + d + f + l + f;
        concat = "" + b + S + d + c + s + i + S + l;
        concat = "" + f + S + S + l + c + i + d + z;
        concat = "" + l + b + z + d + b + l + z + f;
        concat = "" + b + d + f + b + "S" + c + c + "S";
        concat = "" + l + s + z + "S" + z + "S" + z + d;
        concat = "" + l + b + S + z + b + l + s + z;
        concat = "" + S + l + S + b + "S" + s + "S" + c;
        concat = "" + c + i + z + z + b + f + s + "S";
        concat = "" + f + S + z + l + f + l + b + b;
        concat = "" + z + S + d + f + l + i + f + f;
        concat = "" + f + S + z + s + z + c + z + b;
        concat = "" + d + s + l + i + "S" + S + z + "S";
        concat = "" + S + f + d + z + l + b + c + f;
        concat = "" + d + c + "S" + l + d + s + S + c;
        concat = "" + z + l + b + c + "S" + i + S + "S";
        concat = "" + z + b + i + z + l + d + S + s;
        concat = "" + f + "S" + b + s + s + i + z + l;
        concat = "" + S + c + s + s + z + d + s + z;
        concat = "" + f + "S" + i + c + S + f + c + S;
        concat = "" + i + c + S + l + d + z + f + "S";
        concat = "" + s + d + "S" + "S" + d + f + d + z;
        concat = "" + "S" + l + S + "S" + c + s + s + d;
        concat = "" + b + z + s + S + d + f + b + l;
        concat = "" + c + "S" + z + d + l + i + b + f;
        concat = "" + s + d + z + z + "S" + l + i + "S";
        concat = "" + c + i + b + z + "S" + l + "S" + i;
        concat = "" + f + f + s + z + i + b + i + f;
        concat = "" + b + z + f + s + z + c + b + z;
        concat = "" + z + z + s + s + b + z + z + s;
        concat = "" + d + b + f + "S" + b + c + i + b;
        concat = "" + i + d + c + i + d + d + z + f;
        concat = "" + d + i + l + l + i + "S" + S + S;
        concat = "" + "S" + z + f + "S" + d + b + d + i;
        concat = "" + "S" + s + s + d + b + "S" + S + d;
        concat = "" + i + b + s + S + d + c + c + z;
        concat = "" + i + b + l + l + "S" + l + l + s;
        concat = "" + i + z + s + "S" + l + c + f + i;
        concat = "" + l + i + S + b + c + S + z + S;
        concat = "" + "S" + l + s + z + d + d + s + i;
        concat = "" + b + "S" + s + s + c + c + i + c;
        concat = "" + z + i + f + z + b + c + "S" + f;
        concat = "" + f + d + s + d + s + f + f + S;
        concat = "" + "S" + f + f + d + S + c + l + f;
        concat = "" + f + i + l + b + c + c + b + b;
        concat = "" + s + l + f + i + c + i + b + S;
        concat = "" + "S" + d + b + c + f + i + i + d;
        concat = "" + "S" + s + s + f + z + c + b + z;
        concat = "" + "S" + l + c + f + b + z + c + l;
        concat = "" + s + f + d + f + c + c + b + f;
        concat = "" + c + l + S + l + l + z + i + s;
        concat = "" + f + d + l + i + c + z + S + l;
        concat = "" + "S" + s + "S" + c + f + b + s + b;
        concat = "" + c + l + S + d + b + i + c + S;
        concat = "" + c + "S" + z + d + s + c + b + i;
        concat = "" + z + i + b + i + i + "S" + "S" + c;
        concat = "" + s + S + "S" + b + b + s + i + i;
        concat = "" + S + z + c + i + "S" + f + "S" + f;
        concat = "" + z + S + S + z + S + d + i + s;
        concat = "" + z + f + c + l + S + l + z + i;
        concat = "" + z + i + b + d + i + l + d + i;
        concat = "" + z + l + l + b + z + S + l + z;
        concat = "" + b + s + f + l + b + b + i + d;
        concat = "" + S + S + i + z + c + z + b + s;
        concat = "" + c + "S" + i + l + l + i + i + i;
        concat = "" + d + b + l + S + c + b + s + z;
        concat = "" + d + "S" + l + b + b + i + s + c;
        concat = "" + f + z + f + b + S + z + d + S;
        concat = "" + b + b + z + l + b + l + i + i;
        concat = "" + "S" + b + l + f + c + i + s + "S";
        concat = "" + s + l + d + c + l + f + d + d;
        concat = "" + c + z + f + "S" + "S" + l + c + "S";
        concat = "" + S + d + l + S + S + z + s + c;
        concat = "" + S + "S" + z + S + s + c + S + z;
        concat = "" + f + "S" + c + s + i + "S" + "S" + "S";
        concat = "" + c + z + S + z + c + l + d + "S";
        concat = "" + f + z + f + b + l + "S" + s + i;
        concat = "" + l + l + i + c + f + b + z + "S";
        concat = "" + f + b + l + b + i + c + c + S;
        concat = "" + S + z + l + i + f + "S" + c + "S";
        concat = "" + d + f + c + i + i + c + z + s;
        concat = "" + S + d + s + z + z + f + b + b;
        concat = "" + l + i + d + l + c + c + l + z;
        concat = "" + s + l + c + b + c + "S" + z + l;
        concat = "" + z + z + S + b + s + s + "S" + z;
        concat = "" + c + c + f + l + i + b + b + c;
        concat = "" + "S" + i + z + S + f + s + l + b;
        concat = "" + s + l + b + i + c + S + S + s;
        concat = "" + s + b + "S" + b + c + b + b + l;
        concat = "" + c + z + z + d + "S" + "S" + d + "S";
        concat = "" + s + S + s + s + b + i + "S" + z;
        concat = "" + "S" + i + z + s + S + f + i + S;
        concat = "" + S + s + S + l + z + S + d + z;
        concat = "" + S + d + b + l + b + c + c + "S";
        concat = "" + S + z + f + d + c + f + "S" + S;
        concat = "" + c + c + S + i + i + s + b + S;
        concat = "" + c + b + "S" + z + S + s + b + f;
        concat = "" + f + "S" + d + d + c + b + f + c;
        concat = "" + b + d + f + "S" + s + z + f + i;
        concat = "" + b + S + "S" + S + f + z + d + z;
        concat = "" + f + i + S + c + i + d + f + d;
        concat = "" + l + i + z + S + z + l + z + "S";
        concat = "" + z + "S" + d + i + z + f + i + f;
        concat = "" + s + s + S + l + l + b + d + l;
        concat = "" + l + i + d + z + i + c + c + z;
        concat = "" + S + i + S + c + l + S + l + S;
        concat = "" + d + d + d + f + s + d + i + d;
        concat = "" + z + s + S + d + S + s + d + S;
        concat = "" + b + l + "S" + i + z + i + d + l;
        concat = "" + d + d + d + "S" + c + d + b + l;
        concat = "" + i + z + i + S + s + l + s + f;
        concat = "" + S + b + l + f + b + "S" + s + l;
        concat = "" + "S" + s + i + f + l + f + i + S;
        concat = "" + "S" + d + "S" + b + s + d + z + s;
        concat = "" + i + b + s + s + b + z + S + i;
        concat = "" + s + i + c + i + f + c + l + c;
        concat = "" + l + S + "S" + s + c + "S" + "S" + S;
        concat = "" + d + f + b + s + s + f + S + f;
        concat = "" + f + s + "S" + z + f + b + z + b;
        concat = "" + l + f + f + l + S + l + b + "S";
        concat = "" + i + d + z + s + b + S + c + S;
        concat = "" + c + b + d + c + "S" + i + b + l;
        concat = "" + S + "S" + c + f + z + "S" + b + b;
        concat = "" + S + b + S + i + "S" + b + l + S;
        concat = "" + S + b + s + b + d + f + i + "S";
        concat = "" + c + S + b + S + c + s + d + d;
        concat = "" + S + "S" + l + c + c + S + "S" + s;
        concat = "" + S + s + i + i + s + s + i + s;
        concat = "" + b + d + b + z + l + "S" + "S" + c;
        concat = "" + z + S + b + d + b + i + b + "S";
        concat = "" + b + b + f + b + l + f + c + f;
        concat = "" + l + "S" + b + i + c + b + f + l;
        concat = "" + "S" + z + b + "S" + f + c + l + b;
        concat = "" + c + c + S + S + "S" + f + d + l;
        concat = "" + z + f + d + z + z + i + i + i;
        concat = "" + s + "S" + l + l + d + S + c + f;
        concat = "" + b + s + i + l + c + c + S + S;
        concat = "" + b + s + i + "S" + b + b + b + d;
        concat = "" + z + "S" + S + z + i + z + d + d;
        concat = "" + s + S + f + "S" + b + S + "S" + z;
        concat = "" + f + S + d + c + S + d + l + c;
        concat = "" + i + z + f + S + "S" + b + d + c;
        concat = "" + f + c + l + "S" + i + i + f + d;
        concat = "" + s + i + i + i + S + i + c + d;
        concat = "" + d + l + d + l + i + s + S + f;
        concat = "" + f + s + c + S + b + "S" + d + f;
        concat = "" + s + l + c + b + s + b + b + s;
        concat = "" + b + c + l + f + i + c + s + z;
        concat = "" + "S" + i + i + "S" + l + d + c + i;
        concat = "" + b + l + b + i + S + f + s + l;
        concat = "" + c + s + b + s + d + c + l + i;
        concat = "" + f + "S" + i + c + "S" + f + s + b;
        concat = "" + z + d + c + f + c + c + d + b;
        concat = "" + l + b + z + z + c + c + f + S;
        concat = "" + z + S + d + l + d + "S" + b + l;
        concat = "" + b + "S" + b + S + l + "S" + f + z;
        concat = "" + S + z + i + l + d + l + l + l;
        concat = "" + f + l + d + z + b + i + "S" + "S";
        concat = "" + S + c + l + s + b + l + b + d;
        concat = "" + z + i + z + d + l + d + b + i;
        concat = "" + z + s + f + c + s + b + b + f;
        concat = "" + "S" + b + l + S + s + d + s + l;
        concat = "" + c + i + l + "S" + f + c + c + s;
        concat = "" + c + l + z + S + c + c + S + b;
        concat = "" + f + d + i + f + "S" + S + b + f;
        concat = "" + f + c + d + c + f + i + s + d;
        concat = "" + c + z + S + i + S + c + d + f;
        concat = "" + b + d + S + c + "S" + d + l + "S";
        concat = "" + z + c + l + b + s + z + f + f;
        concat = "" + b + b + s + d + l + b + z + b;
        concat = "" + l + f + c + f + S + s + b + c;
        concat = "" + f + c + s + f + "S" + b + c + c;
        concat = "" + "S" + "S" + b + d + d + "S" + s + l;
        concat = "" + c + i + d + s + b + i + s + c;
        concat = "" + c + c + z + z + l + s + S + i;
        concat = "" + s + b + d + z + l + b + "S" + f;
        concat = "" + f + c + c + c + s + s + s + S;
        concat = "" + "S" + "S" + c + S + b + b + b + i;
        concat = "" + d + i + "S" + b + d + c + f + z;
        concat = "" + b + S + z + s + d + S + z + z;
        concat = "" + i + l + i + s + s + b + i + z;
        concat = "" + s + d + c + l + b + f + S + z;
        concat = "" + f + c + z + b + b + f + b + c;
        concat = "" + b + d + s + b + s + s + l + "S";
        concat = "" + "S" + d + s + s + l + s + i + d;
        concat = "" + S + c + b + c + b + d + "S" + S;
        concat = "" + c + "S" + c + c + c + z + s + d;
        concat = "" + s + "S" + s + l + S + b + l + c;
        concat = "" + i + S + S + b + z + S + s + l;
        concat = "" + l + i + "S" + s + i + S + i + S;
        concat = "" + S + f + f + f + b + "S" + f + z;
        concat = "" + d + S + S + d + f + i + b + b;
        concat = "" + z + i + i + b + l + f + z + d;
        concat = "" + c + c + i + f + f + l + i + c;
        concat = "" + z + f + S + c + b + S + z + s;
        concat = "" + "S" + S + z + s + b + f + S + "S";
        concat = "" + l + z + S + z + "S" + b + S + "S";
        concat = "" + d + s + s + i + d + s + z + z;
        concat = "" + f + i + f + z + S + z + z + i;
        concat = "" + b + d + s + b + l + s + "S" + d;
        concat = "" + l + f + f + i + c + z + z + c;
        concat = "" + S + s + z + d + c + l + l + "S";
        concat = "" + z + d + c + f + i + "S" + d + c;
        concat = "" + S + "S" + z + d + c + b + l + "S";
        concat = "" + b + c + d + d + f + i + i + b;
        concat = "" + s + c + i + c + d + z + S + d;
        concat = "" + f + c + "S" + d + c + S + z + "S";
        concat = "" + "S" + b + l + "S" + i + l + b + d;
        concat = "" + c + d + c + "S" + c + d + b + l;
        concat = "" + l + c + b + z + s + S + d + d;
        concat = "" + d + d + c + c + d + b + s + l;
        concat = "" + d + c + c + S + "S" + c + s + b;
        concat = "" + s + i + i + i + d + z + c + f;
        concat = "" + s + S + z + d + d + c + d + f;
        concat = "" + l + b + f + s + f + c + f + b;
        concat = "" + d + b + z + S + b + s + d + l;
        concat = "" + s + z + f + b + S + s + z + "S";
        concat = "" + z + i + z + d + i + S + i + s;
        concat = "" + b + b + f + i + c + i + i + s;
        concat = "" + f + S + b + b + S + d + "S" + s;
        concat = "" + i + S + i + "S" + i + S + S + f;
        concat = "" + b + s + s + z + z + s + "S" + i;
        concat = "" + s + b + S + "S" + l + i + s + s;
        concat = "" + f + z + s + z + s + f + d + i;
        concat = "" + z + l + s + c + i + l + S + l;
        concat = "" + S + S + b + i + S + S + l + z;
        concat = "" + z + S + l + "S" + z + z + f + "S";
        concat = "" + l + S + f + c + f + f + s + S;
        concat = "" + S + i + d + i + z + b + i + b;
        concat = "" + c + l + f + d + i + f + b + d;
        concat = "" + S + s + c + d + d + c + i + "S";
        concat = "" + "S" + S + c + s + c + b + z + d;
        concat = "" + l + i + c + s + "S" + d + S + b;
        concat = "" + "S" + c + f + l + S + i + s + i;
        concat = "" + b + s + "S" + i + d + c + b + s;
        concat = "" + d + "S" + z + b + f + z + s + f;
        concat = "" + s + b + b + d + i + "S" + l + S;
        concat = "" + "S" + f + l + d + f + i + l + b;
        concat = "" + s + i + S + S + s + b + i + l;
        concat = "" + "S" + i + s + i + f + f + l + f;
        concat = "" + b + c + b + i + i + i + d + i;
        concat = "" + l + c + l + c + c + S + i + S;
        concat = "" + "S" + S + "S" + b + s + b + i + s;
        concat = "" + i + s + "S" + s + "S" + "S" + z + d;
        concat = "" + d + z + c + b + c + S + z + S;
        concat = "" + l + c + b + b + l + c + z + l;
        concat = "" + b + "S" + i + c + l + S + c + z;
        concat = "" + c + c + f + l + i + "S" + i + z;
        concat = "" + z + "S" + z + z + s + i + d + c;
        concat = "" + z + d + c + z + i + S + "S" + S;
        concat = "" + "S" + d + "S" + b + z + f + S + d;
        concat = "" + c + z + z + l + l + S + b + l;
        concat = "" + d + c + i + i + i + s + b + f;
        concat = "" + "S" + d + f + z + c + b + c + s;
        concat = "" + b + s + "S" + d + f + i + i + s;
        concat = "" + i + "S" + i + "S" + l + z + z + z;
        concat = "" + i + S + i + "S" + z + i + S + z;
        concat = "" + z + "S" + S + c + s + s + c + s;
        concat = "" + b + f + z + c + c + l + f + d;
        concat = "" + z + l + s + f + s + l + c + d;
        concat = "" + c + z + s + S + c + S + c + d;
        concat = "" + s + s + z + d + "S" + i + S + "S";
        concat = "" + "S" + f + d + "S" + d + f + c + b;
        concat = "" + b + z + b + s + S + "S" + b + b;
        concat = "" + l + d + d + d + l + "S" + i + d;
        concat = "" + d + "S" + d + b + s + c + S + f;
        concat = "" + f + d + l + S + s + i + b + S;
        concat = "" + z + c + b + b + f + b + i + z;
        concat = "" + s + f + l + c + l + z + d + z;
        concat = "" + l + S + i + d + z + z + s + d;
        concat = "" + i + c + i + d + z + S + "S" + i;
        concat = "" + d + c + z + "S" + z + l + z + z;
        concat = "" + s + s + d + S + s + c + f + z;
        concat = "" + l + "S" + l + l + "S" + z + z + S;
        concat = "" + b + b + d + z + i + b + s + d;
        concat = "" + d + d + d + S + i + c + "S" + z;
        concat = "" + l + "S" + l + S + f + "S" + b + c;
        concat = "" + s + z + "S" + S + f + S + d + b;
        concat = "" + l + s + d + "S" + f + b + s + b;
        concat = "" + f + S + i + z + z + l + l + f;
        concat = "" + "S" + S + b + b + i + f + d + b;
        concat = "" + s + b + i + c + S + S + l + d;
        concat = "" + l + z + "S" + f + "S" + "S" + b + z;
        concat = "" + b + z + f + S + s + d + d + c;
        concat = "" + f + d + l + S + b + l + c + S;
        concat = "" + c + z + b + s + z + s + S + b;
        concat = "" + i + i + b + b + S + z + b + i;
        concat = "" + f + s + i + s + l + d + i + z;
        concat = "" + z + c + S + s + b + f + b + l;
        concat = "" + s + c + "S" + "S" + b + "S" + S + f;
        concat = "" + b + b + i + z + l + z + "S" + i;
        concat = "" + f + s + s + z + f + f + d + "S";
        concat = "" + z + b + "S" + s + f + S + f + b;
        concat = "" + b + S + f + l + S + i + c + s;
        concat = "" + i + "S" + i + S + s + l + b + s;
        concat = "" + i + c + b + f + S + i + s + s;
        concat = "" + z + S + s + d + b + l + l + S;
        concat = "" + z + i + s + l + b + s + d + c;
        concat = "" + s + s + c + f + z + S + b + S;
        concat = "" + "S" + S + b + s + i + f + S + c;
        concat = "" + i + "S" + l + z + d + f + b + i;
        concat = "" + f + "S" + i + z + f + c + S + z;
        concat = "" + "S" + z + f + i + c + S + s + z;
        concat = "" + z + z + b + b + S + c + s + b;
        concat = "" + c + s + d + S + i + S + S + i;
        concat = "" + l + s + z + l + S + s + z + i;
        concat = "" + l + z + b + z + b + b + "S" + s;
        concat = "" + d + S + d + S + s + b + l + d;
        concat = "" + s + z + "S" + s + l + d + "S" + S;
        concat = "" + f + "S" + S + c + c + l + s + S;
        concat = "" + b + i + s + d + d + d + "S" + i;
        concat = "" + S + "S" + S + S + "S" + z + S + S;
        concat = "" + s + l + S + b + d + i + c + s;
        concat = "" + "S" + z + d + d + f + z + b + c;
        concat = "" + c + b + d + s + S + c + S + S;
        concat = "" + f + b + z + c + s + c + i + b;
        concat = "" + f + "S" + d + f + i + "S" + z + f;
        concat = "" + z + f + b + z + z + i + z + l;
        concat = "" + d + s + c + s + "S" + i + s + z;
        concat = "" + i + z + f + s + f + s + i + S;
        concat = "" + "S" + s + z + "S" + d + "S" + c + S;
        concat = "" + d + d + i + l + b + l + b + S;
        concat = "" + z + i + d + S + s + s + i + z;
        concat = "" + d + b + S + S + c + d + d + i;
        concat = "" + c + d + z + c + l + z + z + f;
        concat = "" + s + i + z + s + d + "S" + d + "S";
        concat = "" + d + i + S + l + z + l + i + d;
        concat = "" + s + l + i + i + z + S + f + f;
        concat = "" + c + c + l + S + l + S + i + l;
        concat = "" + "S" + f + c + c + s + b + d + l;
        concat = "" + c + c + S + c + s + f + f + S;
        concat = "" + s + l + i + s + f + S + s + f;
        concat = "" + f + c + f + i + S + i + s + s;
        concat = "" + c + f + S + f + c + "S" + S + f;
        concat = "" + i + f + z + "S" + "S" + z + f + s;
        concat = "" + z + d + "S" + l + i + d + z + f;
        concat = "" + S + S + d + c + s + "S" + c + c;
        concat = "" + l + z + d + d + b + z + c + S;
        concat = "" + d + l + "S" + l + S + d + c + l;
        concat = "" + b + z + S + d + f + "S" + i + c;
        concat = "" + z + "S" + S + d + d + c + "S" + "S";
        concat = "" + c + z + l + l + b + f + f + l;
        concat = "" + d + s + S + c + i + s + z + d;
        concat = "" + s + z + z + f + l + b + i + z;
        concat = "" + i + l + f + s + d + S + b + S;
        concat = "" + z + b + l + c + "S" + c + d + c;
        concat = "" + z + z + c + l + S + d + i + z;
        concat = "" + b + l + l + S + b + "S" + c + l;
        concat = "" + "S" + s + S + b + d + f + b + s;
        concat = "" + "S" + z + z + b + c + f + d + f;
        concat = "" + b + c + b + s + S + "S" + c + f;
        concat = "" + "S" + s + S + l + d + "S" + "S" + l;
        concat = "" + l + S + l + l + f + c + s + d;
        concat = "" + s + S + c + d + c + s + l + d;
        concat = "" + z + i + d + b + S + c + d + d;
        concat = "" + S + d + z + b + z + z + b + l;
        concat = "" + z + d + "S" + i + i + s + l + "S";
        concat = "" + S + b + S + l + d + i + l + i;
        concat = "" + d + z + "S" + l + b + "S" + i + f;
        concat = "" + d + s + b + d + i + b + z + l;
        concat = "" + l + s + i + i + f + f + "S" + f;
        concat = "" + s + i + "S" + "S" + c + i + f + b;
        concat = "" + i + b + l + S + i + c + s + c;
        concat = "" + s + c + i + "S" + i + f + c + S;
        concat = "" + "S" + c + l + b + i + f + c + b;
        concat = "" + z + c + i + "S" + l + S + S + S;
        concat = "" + S + "S" + s + s + i + f + z + S;
        concat = "" + c + S + S + c + f + l + f + d;
        concat = "" + c + i + i + l + d + f + d + i;
        concat = "" + f + d + f + z + f + "S" + "S" + f;
        concat = "" + S + z + z + s + z + i + "S" + b;
        concat = "" + z + c + i + i + d + z + l + i;
        concat = "" + f + b + s + z + i + i + "S" + d;
        concat = "" + d + s + l + z + S + c + S + i;
        concat = "" + s + f + b + S + s + c + f + z;
        concat = "" + z + b + f + d + "S" + z + b + s;
        concat = "" + b + l + z + S + S + z + i + b;
        concat = "" + i + d + f + c + "S" + b + s + d;
        concat = "" + l + d + f + c + f + l + z + f;
        concat = "" + i + l + c + l + c + i + S + z;
        concat = "" + d + i + l + f + z + b + l + c;
        concat = "" + d + "S" + S + f + c + c + f + i;
        concat = "" + b + "S" + d + z + l + f + c + f;
        concat = "" + d + c + i + "S" + z + b + l + "S";
        concat = "" + l + d + c + s + f + "S" + s + s;
        concat = "" + i + S + l + i + s + b + d + i;
        concat = "" + c + S + b + s + d + l + i + l;
        concat = "" + d + d + z + c + l + i + z + b;
        concat = "" + i + l + z + S + b + "S" + i + s;
        concat = "" + z + b + f + "S" + "S" + z + z + b;
        concat = "" + c + l + l + s + S + c + f + c;
        concat = "" + d + c + z + l + "S" + f + d + d;
        concat = "" + "S" + i + b + l + c + s + i + c;
        concat = "" + b + s + b + i + b + f + S + l;
        concat = "" + l + S + z + s + f + z + s + d;
        concat = "" + c + b + S + b + f + z + s + "S";
        concat = "" + i + s + d + z + "S" + b + z + l;
        concat = "" + c + d + i + f + i + l + d + f;
        concat = "" + "S" + "S" + z + z + f + d + d + c;
        concat = "" + z + s + S + f + S + S + i + "S";
        concat = "" + l + d + z + b + i + d + "S" + c;
        concat = "" + "S" + f + s + f + b + d + f + i;
        concat = "" + i + z + f + l + z + d + "S" + S;
        concat = "" + b + l + S + i + i + s + d + i;
        concat = "" + i + f + d + "S" + f + s + s + s;
        concat = "" + i + s + "S" + i + S + d + c + s;
        concat = "" + i + b + "S" + d + s + "S" + i + i;
        concat = "" + d + i + d + b + i + i + S + s;
        concat = "" + "S" + z + c + S + S + b + i + l;
        concat = "" + S + i + "S" + c + f + S + s + c;
        concat = "" + "S" + l + l + b + S + s + "S" + l;
        concat = "" + s + S + "S" + b + d + "S" + "S" + d;
        concat = "" + i + i + z + z + d + i + s + i;
        concat = "" + f + S + s + c + z + "S" + i + l;
        concat = "" + S + i + z + z + S + f + f + c;
        concat = "" + l + S + l + l + c + z + S + s;
        concat = "" + f + s + f + c + f + s + z + z;
        concat = "" + s + c + s + s + S + d + f + s;
        concat = "" + c + "S" + d + z + i + b + "S" + "S";
        concat = "" + S + b + i + f + l + d + s + s;
        concat = "" + c + S + b + f + s + d + i + i;
        concat = "" + l + d + i + f + s + s + b + d;
        concat = "" + f + "S" + i + S + f + c + "S" + s;
        concat = "" + s + "S" + i + f + z + i + l + c;
        concat = "" + b + i + s + "S" + l + l + "S" + b;
        concat = "" + b + d + S + "S" + S + b + s + c;
        concat = "" + "S" + d + s + b + s + f + S + c;
        concat = "" + i + l + S + i + d + d + d + b;
        concat = "" + S + f + c + b + b + f + s + b;
        concat = "" + d + i + S + z + f + l + z + s;
        concat = "" + z + S + "S" + f + b + c + s + d;
        concat = "" + c + f + b + z + b + c + "S" + d;
        concat = "" + i + d + z + i + "S" + b + S + c;
        concat = "" + s + l + s + S + c + b + l + z;
        concat = "" + f + l + z + l + "S" + b + b + i;
        concat = "" + s + d + "S" + i + S + b + z + c;
        concat = "" + "S" + d + b + l + l + s + S + l;
        concat = "" + b + z + c + s + c + l + i + l;
        concat = "" + z + d + s + S + c + f + S + c;
        concat = "" + z + s + f + S + b + b + s + b;
        concat = "" + S + d + l + b + "S" + "S" + c + S;
        concat = "" + S + z + s + z + d + "S" + i + z;
        concat = "" + c + l + f + c + f + b + d + b;
        concat = "" + f + c + s + l + i + l + s + S;
        concat = "" + b + S + "S" + f + i + c + "S" + c;
        concat = "" + s + c + l + f + z + b + f + z;
        concat = "" + s + z + b + c + l + d + l + b;
        concat = "" + s + d + f + l + i + s + S + S;
        concat = "" + l + "S" + d + z + "S" + i + c + l;
        concat = "" + i + c + z + d + s + b + S + s;
        concat = "" + z + l + b + S + b + s + l + f;
        concat = "" + i + z + f + d + f + b + s + z;
        concat = "" + f + s + S + i + S + i + S + z;
        concat = "" + d + s + l + i + c + "S" + "S" + f;
        concat = "" + f + d + z + s + d + c + s + d;
        concat = "" + b + S + b + l + c + "S" + l + b;
        concat = "" + b + "S" + s + d + b + S + c + S;
        concat = "" + l + l + i + b + d + z + z + l;
        concat = "" + z + "S" + l + S + c + l + l + c;
        concat = "" + S + z + "S" + z + S + c + c + b;
        concat = "" + f + l + c + d + d + s + d + S;
        concat = "" + f + z + z + d + z + l + d + S;
        concat = "" + s + l + c + l + S + f + S + l;
        concat = "" + c + f + d + l + "S" + b + b + b;
        concat = "" + S + b + i + S + i + s + z + c;
        concat = "" + z + c + z + S + s + f + f + f;
        concat = "" + d + d + f + l + z + "S" + "S" + i;
        concat = "" + f + f + b + c + b + c + f + z;
        concat = "" + z + f + z + d + i + b + i + b;
        concat = "" + S + "S" + i + c + b + s + i + z;
        concat = "" + f + "S" + c + c + b + z + i + i;
        concat = "" + "S" + "S" + d + i + "S" + d + i + "S";
        concat = "" + b + i + S + i + S + z + d + d;
        concat = "" + z + z + "S" + i + b + s + S + b;
        concat = "" + z + "S" + z + "S" + i + c + S + s;
        concat = "" + c + c + b + S + b + c + i + f;
        concat = "" + b + i + i + i + i + d + b + b;
        concat = "" + d + s + d + "S" + z + l + z + S;
        concat = "" + "S" + s + d + l + f + c + d + "S";
        concat = "" + i + S + b + s + d + l + l + "S";
        concat = "" + "S" + d + s + b + S + s + S + z;
        concat = "" + l + "S" + "S" + d + "S" + z + c + z;
        concat = "" + i + d + i + f + f + c + "S" + "S";
        concat = "" + l + d + l + "S" + c + l + S + "S";
        concat = "" + "S" + l + i + d + c + l + d + S;
        concat = "" + b + f + i + c + z + d + i + f;
        concat = "" + S + b + s + f + s + b + "S" + "S";
        concat = "" + z + d + b + z + l + s + z + S;
        concat = "" + b + c + z + "S" + d + d + l + l;
        concat = "" + "S" + i + i + "S" + f + s + c + c;
        concat = "" + s + i + i + s + S + z + "S" + l;
        concat = "" + s + i + f + s + z + c + l + f;
        concat = "" + i + z + z + d + s + z + f + b;
        concat = "" + "S" + l + s + d + f + "S" + i + c;
        concat = "" + i + "S" + z + z + z + b + f + l;
        concat = "" + l + S + S + "S" + c + l + f + "S";
        concat = "" + b + f + c + c + "S" + S + b + c;
        concat = "" + c + i + b + c + b + z + s + "S";
        concat = "" + f + S + d + f + i + S + S + S;
        concat = "" + f + d + S + c + b + s + i + b;
        concat = "" + b + c + z + i + f + d + d + s;
        concat = "" + "S" + c + z + l + "S" + i + s + l;
        concat = "" + c + f + "S" + s + c + "S" + "S" + d;
        concat = "" + f + c + "S" + d + f + i + z + i;
        concat = "" + l + c + z + b + d + l + i + s;
        concat = "" + c + d + l + d + i + b + S + b;
        concat = "" + d + S + z + l + c + l + b + z;
        concat = "" + "S" + l + f + i + c + S + i + c;
        concat = "" + f + c + i + "S" + z + c + c + z;
        concat = "" + "S" + S + i + i + d + b + "S" + z;
        concat = "" + l + c + c + S + l + c + s + S;
        concat = "" + s + z + z + s + d + z + S + i;
        concat = "" + l + S + d + c + i + f + "S" + "S";
        concat = "" + z + s + S + s + d + z + l + d;
        concat = "" + d + c + l + i + "S" + f + b + c;
        concat = "" + f + i + f + c + b + f + f + i;
        concat = "" + "S" + S + S + "S" + z + d + l + l;
        concat = "" + s + S + s + z + "S" + i + d + f;
        concat = "" + d + c + l + S + f + i + S + S;
        concat = "" + "S" + f + d + c + i + i + d + f;
        concat = "" + l + f + z + f + S + c + d + S;
        concat = "" + i + f + "S" + b + s + b + f + "S";
        concat = "" + l + "S" + z + i + b + c + b + l;
        concat = "" + l + S + s + "S" + f + f + z + l;
        concat = "" + "S" + c + "S" + f + i + s + "S" + f;
        concat = "" + f + s + s + i + b + S + d + b;
        concat = "" + s + f + "S" + b + f + f + i + z;
        concat = "" + s + s + S + b + "S" + s + z + z;
        concat = "" + S + f + b + l + z + s + f + S;
        concat = "" + c + s + s + c + S + s + f + c;
        concat = "" + i + f + l + d + "S" + f + i + d;
        concat = "" + l + "S" + S + c + f + b + l + d;
        concat = "" + S + s + S + S + f + c + d + S;
        concat = "" + s + l + c + l + S + c + "S" + S;
        concat = "" + i + i + l + z + "S" + i + b + b;
        concat = "" + c + i + c + S + "S" + i + s + b;
        concat = "" + l + i + c + i + z + c + d + f;
        concat = "" + f + z + S + i + i + z + z + d;
        concat = "" + l + f + z + f + c + S + l + c;
        concat = "" + "S" + s + d + l + c + s + z + d;
        concat = "" + S + s + s + z + c + b + z + i;
        concat = "" + f + b + z + f + z + "S" + s + z;
        concat = "" + "S" + S + i + d + f + d + f + d;
        concat = "" + i + l + s + l + b + z + f + i;
        concat = "" + f + z + l + f + z + z + b + d;
        concat = "" + S + i + z + l + b + i + z + d;
        concat = "" + i + i + f + f + l + d + b + b;
        concat = "" + d + S + i + f + S + S + c + l;
        concat = "" + "S" + l + "S" + S + i + b + z + l;
        concat = "" + d + l + c + b + s + "S" + s + b;
        concat = "" + c + s + l + f + c + l + "S" + b;
        concat = "" + i + "S" + z + l + z + s + s + "S";
        concat = "" + f + b + f + b + c + c + "S" + z;
        concat = "" + z + z + i + s + i + b + "S" + z;
        concat = "" + c + l + l + s + s + "S" + z + "S";
        concat = "" + i + i + d + s + z + l + b + c;
        concat = "" + f + l + l + S + "S" + i + z + "S";
        concat = "" + s + s + i + f + "S" + s + z + c;
        concat = "" + l + f + i + s + d + l + b + b;
        concat = "" + "S" + s + b + l + z + i + f + s;
        concat = "" + z + l + b + b + d + z + "S" + "S";
        concat = "" + d + s + s + l + f + z + "S" + s;
        concat = "" + l + i + "S" + z + d + f + "S" + s;
        concat = "" + f + d + i + "S" + s + S + i + i;
        concat = "" + i + b + s + S + i + s + i + i;
        concat = "" + S + "S" + d + b + z + i + S + c;
        concat = "" + f + S + i + s + s + z + f + c;
        concat = "" + c + z + l + S + d + b + f + "S";
        concat = "" + d + l + S + f + z + S + c + c;
        concat = "" + "S" + b + S + i + l + d + c + c;
        concat = "" + "S" + S + S + d + i + f + S + l;
        concat = "" + c + "S" + f + "S" + z + d + d + l;
        concat = "" + S + l + b + S + c + b + z + b;
        concat = "" + i + l + z + l + b + d + d + l;
        concat = "" + c + c + f + b + S + s + z + i;
        concat = "" + l + l + "S" + i + "S" + s + "S" + c;
        concat = "" + "S" + c + i + s + i + d + b + d;
        concat = "" + z + l + i + i + b + l + f + S;
        concat = "" + d + S + "S" + b + b + l + c + c;
        concat = "" + S + "S" + z + z + s + f + c + b;
        concat = "" + l + s + d + c + s + S + c + z;
        concat = "" + f + i + b + f + i + b + c + i;
        concat = "" + d + f + d + S + d + "S" + s + f;
        concat = "" + c + i + b + S + "S" + z + s + s;
        concat = "" + b + s + "S" + S + c + d + b + d;
        concat = "" + s + s + f + i + l + S + S + S;
        concat = "" + d + b + d + l + S + z + b + S;
        concat = "" + d + d + i + b + z + "S" + S + c;
        concat = "" + z + f + s + "S" + d + S + f + b;
        concat = "" + d + "S" + f + f + z + f + S + z;
        concat = "" + i + "S" + S + i + "S" + d + "S" + "S";
        concat = "" + "S" + S + c + z + l + c + z + d;
        concat = "" + l + z + c + i + s + i + l + S;
        concat = "" + b + s + z + "S" + b + l + s + l;
        concat = "" + d + f + i + b + c + f + s + f;
        concat = "" + S + f + l + s + d + S + i + c;
        concat = "" + "S" + s + "S" + S + z + "S" + f + d;
        concat = "" + c + z + i + S + c + "S" + d + l;
        concat = "" + c + "S" + c + c + c + "S" + i + b;
        concat = "" + c + l + f + d + d + c + i + i;
        concat = "" + i + S + s + S + f + c + d + b;
        concat = "" + i + i + S + b + l + l + "S" + c;
        concat = "" + d + z + "S" + d + i + c + b + b;
        concat = "" + c + b + S + b + b + "S" + "S" + S;
        concat = "" + c + i + l + i + d + z + "S" + l;
        concat = "" + S + d + "S" + d + b + d + s + i;
        concat = "" + z + f + S + c + c + "S" + d + "S";
        concat = "" + c + z + c + b + l + s + "S" + b;
        concat = "" + S + s + "S" + "S" + c + l + s + f;
        concat = "" + S + "S" + l + c + c + f + b + S;
        concat = "" + c + f + S + f + z + z + f + z;
        concat = "" + d + l + z + i + f + f + b + l;
        concat = "" + "S" + S + f + "S" + s + s + s + z;
        concat = "" + d + b + l + f + b + z + z + b;
        concat = "" + S + z + i + d + l + l + l + b;
        concat = "" + l + b + i + S + c + f + i + i;
        concat = "" + c + l + z + d + "S" + d + s + S;
        concat = "" + l + i + i + l + b + z + d + f;
        concat = "" + S + s + c + i + z + d + d + i;
        concat = "" + z + s + b + z + l + z + d + d;
        concat = "" + s + d + S + S + s + c + S + "S";
        concat = "" + b + b + s + s + S + l + f + z;
        concat = "" + l + "S" + i + c + i + s + "S" + "S";
        concat = "" + s + l + "S" + S + "S" + S + S + c;
        concat = "" + i + z + b + l + z + c + c + s;
        concat = "" + d + d + i + b + l + "S" + S + i;
        concat = "" + "S" + l + f + c + l + "S" + z + i;
        concat = "" + "S" + "S" + "S" + l + S + b + s + z;
        concat = "" + c + d + S + d + S + z + f + "S";
        concat = "" + c + s + S + b + s + S + c + l;
        concat = "" + "S" + b + S + S + d + c + f + b;
        concat = "" + f + l + c + S + z + b + i + c;
        concat = "" + "S" + f + i + l + S + d + i + f;
        concat = "" + d + z + s + d + S + s + z + c;
        concat = "" + b + b + z + z + S + d + S + S;
        concat = "" + s + d + b + c + z + s + f + c;
        concat = "" + c + z + S + l + "S" + z + l + S;
        concat = "" + c + i + "S" + "S" + z + s + i + "S";
        concat = "" + b + c + s + s + b + "S" + "S" + "S";
        concat = "" + "S" + S + l + z + f + i + l + i;
        concat = "" + S + c + c + S + c + i + b + i;
        concat = "" + d + b + f + S + l + l + "S" + b;
        concat = "" + d + "S" + s + d + c + s + f + l;
        concat = "" + l + s + S + s + z + d + i + z;
        concat = "" + b + "S" + i + f + b + d + i + i;
        concat = "" + c + i + b + s + "S" + f + l + d;
        concat = "" + "S" + b + d + i + f + f + S + l;
        concat = "" + f + s + b + c + b + i + c + i;
        concat = "" + s + d + z + d + b + d + c + S;
        concat = "" + c + "S" + f + c + S + b + b + d;
        concat = "" + f + d + l + f + f + S + c + i;
        concat = "" + l + b + i + i + c + b + l + "S";
        concat = "" + f + d + b + "S" + c + s + z + c;
        concat = "" + i + b + d + s + c + f + s + c;
        concat = "" + d + f + S + "S" + S + s + d + i;
        concat = "" + s + b + l + z + i + s + i + l;
        concat = "" + b + b + z + c + l + f + z + f;
        concat = "" + i + d + "S" + z + "S" + i + s + i;
        concat = "" + i + b + c + d + c + "S" + s + l;
        concat = "" + f + c + d + f + f + f + z + l;
        concat = "" + f + s + b + z + l + c + s + c;
        concat = "" + b + i + "S" + "S" + "S" + c + d + d;
        concat = "" + s + i + z + z + s + S + S + c;
        concat = "" + f + S + f + S + S + z + "S" + f;
        concat = "" + i + "S" + d + i + S + f + z + d;
        concat = "" + f + c + s + d + S + f + b + b;
        concat = "" + s + d + b + s + s + S + b + f;
        concat = "" + c + d + s + "S" + f + i + l + "S";
        concat = "" + i + s + b + z + S + s + f + "S";
        concat = "" + i + S + "S" + i + b + z + S + b;
        concat = "" + c + S + s + s + z + S + z + i;
        concat = "" + s + d + S + c + "S" + f + S + "S";
        concat = "" + "S" + c + "S" + l + s + b + z + S;
        concat = "" + s + d + d + f + f + s + z + z;
        concat = "" + d + d + "S" + c + s + b + "S" + l;
        concat = "" + i + f + S + c + d + d + d + f;
        concat = "" + i + l + d + i + b + f + l + f;
        concat = "" + s + i + s + l + l + S + d + f;
        concat = "" + l + "S" + f + d + c + b + l + c;
        concat = "" + i + b + c + i + l + "S" + c + b;
        concat = "" + s + s + f + l + c + "S" + s + s;
        concat = "" + d + c + d + S + S + S + s + l;
        concat = "" + i + "S" + b + s + c + f + c + z;
        concat = "" + S + d + d + s + S + d + l + f;
        concat = "" + c + l + c + f + l + d + "S" + f;
        concat = "" + i + d + "S" + i + S + S + f + S;
        concat = "" + "S" + s + z + s + b + d + d + c;
        concat = "" + l + z + s + f + "S" + f + f + d;
        concat = "" + "S" + l + i + "S" + d + s + S + s;
        concat = "" + d + "S" + l + S + i + "S" + b + "S";
        concat = "" + S + S + l + d + z + s + S + b;
        concat = "" + s + s + f + s + i + b + s + l;
        concat = "" + "S" + b + i + "S" + z + z + S + b;
        concat = "" + i + c + l + s + b + d + s + S;
        concat = "" + d + l + b + z + f + d + c + i;
        concat = "" + s + b + i + i + s + b + z + c;
        concat = "" + i + "S" + s + c + l + i + c + d;
        concat = "" + f + c + "S" + b + d + i + l + b;
        concat = "" + "S" + z + d + s + f + s + s + d;
        concat = "" + i + l + z + d + S + "S" + d + f;
        concat = "" + s + f + "S" + l + s + f + b + "S";
        concat = "" + S + b + z + i + i + l + i + b;
        concat = "" + d + b + f + d + d + c + b + z;
        concat = "" + d + S + d + c + l + f + S + S;
        concat = "" + S + s + z + b + s + "S" + s + z;
        concat = "" + c + S + S + d + l + S + S + f;
        concat = "" + f + d + f + "S" + f + "S" + b + s;
        concat = "" + s + S + "S" + s + f + b + S + c;
        concat = "" + i + s + S + d + S + s + f + s;
        concat = "" + i + S + b + d + d + d + c + s;
        concat = "" + S + S + f + b + S + c + f + "S";
        concat = "" + l + b + z + f + i + c + l + f;
        concat = "" + "S" + c + S + c + l + f + z + z;
        concat = "" + S + "S" + l + i + b + z + l + z;
        concat = "" + z + "S" + i + c + f + z + "S" + z;
        concat = "" + c + f + f + l + i + i + i + d;
        concat = "" + S + s + d + "S" + i + l + b + c;
        concat = "" + l + d + s + c + c + d + f + S;
        concat = "" + f + "S" + S + c + c + l + z + S;
        concat = "" + z + d + c + c + i + c + d + "S";
        concat = "" + b + S + z + b + i + "S" + "S" + "S";
        concat = "" + d + f + "S" + l + s + z + d + S;
        concat = "" + d + S + b + f + s + l + i + i;
        concat = "" + b + z + S + l + i + l + S + S;
        concat = "" + i + l + d + s + z + l + s + "S";
        concat = "" + S + S + s + b + b + z + s + "S";
        concat = "" + "S" + S + S + l + l + z + "S" + i;
        concat = "" + d + b + l + b + l + d + c + z;
        concat = "" + "S" + i + s + d + c + S + c + s;
        concat = "" + z + c + S + d + c + c + l + i;
        concat = "" + d + d + l + f + S + z + d + "S";
        concat = "" + s + f + S + z + "S" + b + c + z;
        concat = "" + "S" + c + c + d + "S" + S + d + S;
        concat = "" + c + S + i + f + c + i + s + S;
        concat = "" + "S" + S + S + c + c + i + s + l;
        concat = "" + S + d + d + b + f + c + "S" + s;
        concat = "" + f + z + f + i + "S" + i + "S" + s;
        concat = "" + "S" + f + S + c + l + S + d + s;
        concat = "" + S + i + c + c + "S" + c + i + l;
        concat = "" + i + "S" + c + d + f + z + S + S;
        concat = "" + b + f + c + l + s + d + c + S;
        concat = "" + l + S + i + i + z + l + "S" + f;
        concat = "" + z + "S" + d + i + f + i + b + b;
        concat = "" + "S" + l + f + "S" + b + f + "S" + s;
        concat = "" + i + s + b + b + i + f + s + b;
        concat = "" + l + d + i + f + l + i + S + "S";
        concat = "" + f + b + S + S + c + b + s + l;
        concat = "" + i + s + f + S + s + S + s + b;
        concat = "" + f + "S" + z + "S" + s + f + c + s;
        concat = "" + "S" + S + b + z + f + i + s + s;
        concat = "" + b + s + l + z + "S" + i + s + S;
        concat = "" + i + c + z + s + S + d + l + z;
        concat = "" + s + "S" + b + c + "S" + c + d + l;
        concat = "" + c + b + b + i + c + S + b + z;
        concat = "" + S + c + "S" + S + z + s + "S" + s;
        concat = "" + b + f + d + "S" + s + S + d + S;
        concat = "" + f + d + b + i + S + f + d + d;
        concat = "" + s + c + "S" + s + s + l + s + z;
        concat = "" + f + d + z + c + i + s + z + d;
        concat = "" + i + s + c + f + b + z + S + f;
        concat = "" + S + d + z + i + i + b + i + z;
        concat = "" + d + b + S + d + d + i + b + s;
        concat = "" + d + "S" + f + c + l + c + c + d;
        concat = "" + z + z + S + S + f + d + i + c;
        concat = "" + "S" + l + z + f + "S" + l + d + l;
        concat = "" + f + l + d + b + b + "S" + l + i;
        concat = "" + s + i + S + b + c + z + l + l;
        concat = "" + z + f + S + i + l + z + l + S;
        concat = "" + d + z + b + z + s + b + z + z;
        concat = "" + d + b + d + f + d + i + d + s;
        concat = "" + S + d + d + "S" + i + "S" + c + d;
        concat = "" + f + f + c + l + f + d + s + d;
        concat = "" + b + S + f + l + c + c + s + d;
        concat = "" + S + s + s + d + f + "S" + i + i;
        concat = "" + i + z + i + d + b + d + c + l;
        concat = "" + i + S + f + S + f + d + d + "S";
        concat = "" + i + "S" + i + l + s + l + i + b;
        concat = "" + d + "S" + "S" + c + z + S + c + c;
        concat = "" + s + l + f + l + d + "S" + l + s;
        concat = "" + b + z + S + c + c + f + l + S;
        concat = "" + z + i + f + s + d + i + S + c;
        concat = "" + "S" + S + l + l + b + z + s + s;
        concat = "" + f + z + z + l + d + c + l + d;
        concat = "" + b + c + s + b + d + l + z + b;
        concat = "" + z + f + c + s + z + b + c + c;
        concat = "" + i + b + b + c + c + d + b + f;
        concat = "" + d + f + d + f + "S" + S + "S" + d;
        concat = "" + z + z + f + i + d + i + f + "S";
        concat = "" + i + s + "S" + d + l + d + z + b;
        concat = "" + "S" + "S" + c + i + S + f + b + S;
        concat = "" + z + s + b + S + c + c + s + b;
        concat = "" + z + "S" + f + c + c + i + f + z;
        concat = "" + b + d + d + f + i + s + i + d;
        concat = "" + f + i + s + c + z + s + "S" + f;
        concat = "" + S + s + l + b + s + "S" + "S" + b;
        concat = "" + c + b + b + i + "S" + S + b + S;
        concat = "" + d + s + S + i + f + f + c + S;
        concat = "" + f + z + "S" + f + c + b + d + S;
        concat = "" + l + "S" + l + s + c + s + c + i;
        concat = "" + S + b + S + c + c + l + l + S;
        concat = "" + i + "S" + l + b + f + s + i + s;
        concat = "" + S + z + b + S + c + c + l + c;
        concat = "" + S + s + i + b + z + d + l + c;
        concat = "" + f + c + i + i + z + f + S + b;
        concat = "" + z + l + "S" + z + i + "S" + i + b;
        concat = "" + i + S + z + b + l + i + i + d;
        concat = "" + d + z + d + b + b + c + d + z;
        concat = "" + l + i + "S" + i + "S" + l + b + i;
        concat = "" + f + c + l + z + S + f + s + "S";
        concat = "" + b + i + z + "S" + d + b + d + l;
        concat = "" + c + z + c + z + "S" + S + l + s;
        concat = "" + f + f + s + b + s + l + c + s;
        concat = "" + "S" + c + S + l + f + S + z + c;
        concat = "" + i + l + f + f + f + c + b + l;
        concat = "" + d + d + "S" + c + S + l + c + z;
        concat = "" + i + d + f + i + S + S + "S" + s;
        concat = "" + f + i + z + i + s + b + S + c;
        concat = "" + z + l + s + "S" + s + i + b + f;
        concat = "" + f + s + c + "S" + f + l + z + f;
        concat = "" + z + l + S + c + c + "S" + d + f;
        concat = "" + l + z + l + s + d + b + i + "S";
        concat = "" + l + f + d + z + z + b + b + d;
        concat = "" + l + S + f + z + f + l + c + z;
        concat = "" + s + "S" + z + b + z + c + b + z;
        concat = "" + d + c + S + s + l + i + b + s;
        concat = "" + "S" + b + s + z + f + S + l + "S";
        concat = "" + l + f + b + i + z + f + i + s;
        concat = "" + f + i + S + d + f + z + S + S;
        concat = "" + d + i + c + f + s + "S" + f + s;
        concat = "" + z + l + s + s + z + f + l + i;
        concat = "" + l + z + b + l + i + f + i + c;
        concat = "" + d + s + b + d + c + l + l + b;
        concat = "" + i + b + d + d + d + c + s + i;
        concat = "" + z + "S" + f + b + i + z + i + b;
        concat = "" + s + S + c + S + c + S + "S" + b;
        concat = "" + i + b + b + d + i + l + d + s;
        concat = "" + l + S + c + z + s + z + S + "S";
        concat = "" + S + c + l + b + b + d + f + b;
        concat = "" + "S" + s + l + z + l + f + z + s;
        concat = "" + S + s + s + z + d + d + S + d;
        concat = "" + f + "S" + l + s + i + s + b + S;
        concat = "" + f + f + "S" + i + l + c + f + c;
        concat = "" + s + "S" + "S" + "S" + z + b + f + f;
        concat = "" + f + s + l + f + b + c + s + i;
        concat = "" + i + f + S + "S" + z + z + i + s;
        concat = "" + d + "S" + c + "S" + z + z + c + z;
        concat = "" + d + b + d + b + d + c + z + l;
        concat = "" + b + z + z + S + S + b + b + i;
        concat = "" + b + c + d + s + b + f + S + c;
        concat = "" + i + S + l + f + c + "S" + c + z;
        concat = "" + d + z + f + S + i + S + l + s;
        concat = "" + z + l + i + z + l + i + l + f;
        concat = "" + b + d + s + "S" + f + c + d + s;
        concat = "" + "S" + b + c + l + d + b + S + c;
        concat = "" + S + d + "S" + "S" + f + S + f + b;
        concat = "" + f + z + s + f + "S" + c + d + S;
        concat = "" + S + d + S + S + S + i + i + f;
        concat = "" + b + i + c + z + s + l + d + S;
        concat = "" + "S" + s + z + "S" + i + i + S + z;
        concat = "" + "S" + l + z + f + "S" + d + S + i;
        concat = "" + b + i + f + z + "S" + s + "S" + z;
        concat = "" + f + i + f + i + b + c + d + "S";
        concat = "" + s + s + c + d + b + s + S + l;
        concat = "" + l + S + d + d + i + z + f + d;
        concat = "" + z + f + "S" + S + c + i + s + i;
        concat = "" + l + s + f + i + s + b + s + s;
        concat = "" + "S" + l + c + S + l + c + f + z;
        concat = "" + S + c + s + s + f + l + b + b;
        concat = "" + f + "S" + S + s + S + i + s + "S";
        concat = "" + d + d + z + f + i + s + b + f;
        concat = "" + "S" + l + f + z + i + s + b + d;
        concat = "" + z + "S" + s + f + l + "S" + "S" + b;
        concat = "" + S + z + z + s + f + "S" + l + b;
        concat = "" + "S" + z + i + s + d + f + f + l;
        concat = "" + S + c + s + s + S + d + s + i;
        concat = "" + d + b + "S" + s + c + z + c + b;
        concat = "" + z + l + f + S + "S" + "S" + l + b;
        concat = "" + d + d + f + "S" + "S" + b + c + i;
        concat = "" + f + d + s + S + "S" + l + i + l;
        concat = "" + b + c + b + b + b + c + s + "S";
        concat = "" + f + c + d + "S" + z + s + b + b;
        concat = "" + d + d + i + z + "S" + b + i + c;
        concat = "" + d + s + c + s + "S" + s + f + b;
        concat = "" + z + i + l + c + b + "S" + f + s;
        concat = "" + b + S + c + b + l + s + i + i;
        concat = "" + d + f + c + z + S + S + S + s;
        concat = "" + z + z + z + c + S + c + i + i;
        concat = "" + b + i + b + f + S + i + f + d;
        concat = "" + c + f + b + i + "S" + s + "S" + c;
        concat = "" + b + i + d + b + "S" + d + z + "S";
        concat = "" + z + s + s + "S" + b + d + z + "S";
        concat = "" + z + l + S + z + S + "S" + S + d;
        concat = "" + l + f + l + S + l + "S" + f + d;
        concat = "" + z + i + c + l + d + f + s + s;
        concat = "" + i + S + c + b + c + "S" + c + "S";
        concat = "" + "S" + b + s + l + d + z + "S" + d;
        concat = "" + i + l + i + S + d + "S" + c + f;
        concat = "" + b + b + b + "S" + s + d + b + s;
        concat = "" + "S" + b + d + i + S + "S" + c + S;
        concat = "" + z + z + "S" + i + l + S + b + S;
        concat = "" + "S" + s + c + f + f + s + d + s;
        concat = "" + i + i + f + "S" + s + f + c + f;
        concat = "" + l + c + s + i + d + "S" + z + l;
        concat = "" + f + d + l + l + "S" + i + i + f;
        concat = "" + z + l + d + c + f + i + z + i;
        concat = "" + i + s + l + b + f + d + b + d;
        concat = "" + z + b + d + z + b + S + l + i;
        concat = "" + b + f + d + "S" + "S" + c + d + i;
        concat = "" + s + c + "S" + "S" + b + d + d + S;
        concat = "" + d + b + s + b + c + d + z + z;
        concat = "" + b + c + z + S + d + S + S + i;
        concat = "" + d + c + z + f + l + l + d + c;
        concat = "" + i + l + b + b + l + S + b + b;
        concat = "" + i + b + i + b + S + "S" + z + "S";
        /* Keep this comment here so you can add a /* comment above to reduce the number of shapes in this file */
        result = concat;
    }
}
