/*
 * Decompiled with CFR 0.152.
 */
package com.azul.crs.client.service;

import com.azul.crs.client.Client;
import com.azul.crs.client.PerformanceMetrics;
import com.azul.crs.client.service.ClientService;
import com.azul.crs.shared.Utils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;

public class QueueService<T>
implements ClientService {
    private static final int DEFAULT_MAX_QUEUE_SIZE = 5000;
    private static final int DEFAULT_MAX_WORKERS = 3;
    private static final int DEFAULT_MAX_BATCH_SIZE = 1000;
    private static final long DEFAULT_ADD_TIMEOUT = 500L;
    private volatile boolean stopping;
    private volatile boolean cancelled;
    private final BlockingQueue<T> queue;
    private final List<Thread> workerThreads;
    private final List<Worker> workers;
    private final int maxQueueSize;
    private final int maxWorkers;
    private final int maxBatchSize;
    private final long addTimeout;
    private final ProcessBatch<T> processBatch;
    private final String name;
    private final Object syncOrderMonitor = new Object();
    private final Object syncFinishNotifier = new Object();
    private final T syncMarker;
    private final AtomicInteger syncCount = new AtomicInteger(0);

    private QueueService(int maxQueueSize, int maxWorkers, int maxBatchSize, long addTimeout, T syncMarker, ProcessBatch<T> processBatch, String name) {
        this.maxQueueSize = maxQueueSize;
        this.maxWorkers = maxWorkers;
        this.maxBatchSize = maxBatchSize;
        this.addTimeout = addTimeout;
        this.syncMarker = syncMarker;
        this.processBatch = processBatch;
        this.queue = new LinkedBlockingDeque<T>(maxQueueSize);
        this.workerThreads = new LinkedList<Thread>();
        this.workers = new LinkedList<Worker>();
        this.name = name;
    }

    public void add(T item) {
        block3: {
            if (this.cancelled || this.stopping) {
                return;
            }
            try {
                this.queue.offer(item, this.addTimeout, TimeUnit.MILLISECONDS);
                PerformanceMetrics.logEventQueueLength(this.queue.size());
            }
            catch (InterruptedException ie) {
                if (Client.isVMShutdownInitiated()) break block3;
                this.logger().error("Queue failed to enqueue item: queueSize=" + this.queue.size() + ", maxQueueSize=" + this.maxQueueSize + ", timeout=" + this.addTimeout + ", item=" + item, new Object[0]);
            }
        }
    }

    public void addAll(Collection<T> items) {
        block4: {
            if (this.stopping) {
                return;
            }
            try {
                for (T item : items) {
                    this.queue.offer(item, this.addTimeout, TimeUnit.MILLISECONDS);
                }
                PerformanceMetrics.logEventQueueLength(this.queue.size());
            }
            catch (InterruptedException ie) {
                if (Client.isVMShutdownInitiated()) break block4;
                this.logger().error("Queue failed to enqueue item: queueSize=" + this.queue.size() + ", maxQueueSize=" + this.maxQueueSize + ", timeout=" + this.addTimeout + ", number of items=" + items.size(), new Object[0]);
            }
        }
    }

    @Override
    public synchronized void start() {
        if (this.stopping || this.cancelled) {
            throw new IllegalStateException(this.serviceName() + " is stopping or cancelled");
        }
        for (int i = 0; i < this.maxWorkers; ++i) {
            Worker w = new Worker(String.valueOf(i));
            Thread t = new Thread(w);
            this.workerThreads.add(t);
            this.workers.add(w);
            t.setDaemon(true);
            t.setName("CRSQW-" + this.name + i);
            t.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sync(long deadline) {
        if (this.cancelled) {
            return;
        }
        if (Utils.elapsedTimeMillis(deadline) >= 0L) {
            this.logger().debug("%s sync missed deadline", this.name);
            return;
        }
        Object object = this.syncOrderMonitor;
        synchronized (object) {
            boolean syncMarkerAdded = false;
            this.syncCount.set(this.maxWorkers);
            Object object2 = this.syncFinishNotifier;
            synchronized (object2) {
                this.logger().trace("%s sync start", this.name);
                while (!(syncMarkerAdded = this.queue.offer(this.syncMarker)) && Utils.currentTimeCount() < deadline) {
                    Utils.sleep(10L);
                }
                if (syncMarkerAdded) {
                    try {
                        long timeout = -Utils.elapsedTimeMillis(deadline);
                        if (timeout > 0L) {
                            this.syncFinishNotifier.wait(timeout);
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (this.syncCount.get() > 0) {
                        this.logger().warning("%s sync timeout waiting response. %d workers not finished", this.name, this.syncCount.get());
                        this.syncFinishNotifier.notifyAll();
                    }
                } else {
                    this.logger().warning("%s sync timeout waiting to initiate queue sync", this.name);
                }
            }
        }
    }

    @Override
    public void stop(long deadline) {
        if (this.stopping) {
            return;
        }
        this.stopping = true;
        this.sync(deadline);
    }

    public void cancel() {
        this.cancelled = true;
    }

    protected class Worker
    implements Runnable {
        private final String workerId;

        public Worker(String workerId) {
            this.workerId = workerId;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sync() {
            try {
                Object object = QueueService.this.syncFinishNotifier;
                synchronized (object) {
                    if (QueueService.this.syncCount.decrementAndGet() > 0) {
                        while (!QueueService.this.queue.offer(QueueService.this.syncMarker)) {
                            Thread.sleep(10L);
                        }
                        QueueService.this.syncFinishNotifier.wait();
                    } else {
                        QueueService.this.syncFinishNotifier.notifyAll();
                    }
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }

        @Override
        public void run() {
            ArrayList batch = new ArrayList(QueueService.this.maxBatchSize);
            boolean running = true;
            while (running) {
                Object item;
                int batchSize = 0;
                try {
                    item = QueueService.this.queue.take();
                }
                catch (InterruptedException ignored) {
                    break;
                }
                if (item != QueueService.this.syncMarker) {
                    batch.add(item);
                    ++batchSize;
                    while (batchSize < QueueService.this.maxBatchSize && (item = QueueService.this.queue.poll()) != QueueService.this.syncMarker && item != null) {
                        batch.add(item);
                        ++batchSize;
                    }
                    QueueService.this.processBatch.process(this.workerId, batch);
                    batch.clear();
                }
                if (item != QueueService.this.syncMarker) continue;
                this.sync();
                running = !QueueService.this.stopping;
            }
        }
    }

    public static class Builder<T> {
        private int maxQueueSize = 5000;
        private int maxWorkers = 3;
        private int maxBatchSize = 1000;
        private long addTimeout = 500L;
        private ProcessBatch<T> processBatch;
        private T stopMarker;
        private String name = "<unnamed>";

        public Builder<T> maxQueueSize(int maxQueueSize) {
            this.maxQueueSize = maxQueueSize;
            return this;
        }

        public Builder<T> maxWorkers(int maxWorkers) {
            this.maxWorkers = maxWorkers;
            return this;
        }

        public Builder<T> maxBatchSize(int maxBatchSize) {
            this.maxBatchSize = maxBatchSize;
            return this;
        }

        public Builder<T> addTimeout(long addTimeout) {
            this.addTimeout = addTimeout;
            return this;
        }

        public Builder<T> processBatch(ProcessBatch<T> processBatch) {
            this.processBatch = processBatch;
            return this;
        }

        public Builder<T> stopMarker(T stopMarker) {
            this.stopMarker = stopMarker;
            return this;
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        private void notNull(Object o) {
            o.getClass();
        }

        QueueService<T> build() {
            this.notNull(this.processBatch);
            this.notNull(this.stopMarker);
            return new QueueService(this.maxQueueSize, this.maxWorkers, this.maxBatchSize, this.addTimeout, this.stopMarker, this.processBatch, this.name);
        }
    }

    public static interface ProcessBatch<T> {
        public void process(String var1, Collection<T> var2);
    }
}

